/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public class IfStatementWithIdenticalBranchesJSInspection
extends JavaScriptInspection {
    private final InspectionJSFix fix = new CollapseIfFix();

    @Override
    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("ref.statement.with.identical.branches.error.string", new Object[0]);
        if (string == null) {
            IfStatementWithIdenticalBranchesJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IfStatementWithIdenticalBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/IfStatementWithIdenticalBranchesJSInspection", "buildErrorString"));
    }

    private static class IfStatementWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithIdenticalBranchesVisitor() {
        }

        public void visitJSIfStatement(@NotNull JSIfStatement statement) {
            if (statement == null) {
                IfStatementWithIdenticalBranchesVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSIfStatement(statement);
            JSStatement thenBranch = statement.getThen();
            JSStatement elseBranch = statement.getElse();
            if (thenBranch == null || elseBranch == null) {
                return;
            }
            if (EquivalenceChecker.statementsAreEquivalent((JSSourceElement)thenBranch, (JSSourceElement)elseBranch)) {
                this.registerStatementError((JSSourceElement)statement, new Object[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/sixrr/inspectjs/control/IfStatementWithIdenticalBranchesJSInspection$IfStatementWithIdenticalBranchesVisitor", "visitJSIfStatement"));
        }
    }

    private static class CollapseIfFix
    extends InspectionJSFix {
        private CollapseIfFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("collapse.if.statement.fix", new Object[0]);
            if (string == null) {
                CollapseIfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor2) throws IncorrectOperationException {
            PsiElement identifier = descriptor2.getPsiElement();
            JSIfStatement statement = (JSIfStatement)identifier.getParent();
            assert (statement != null);
            JSStatement thenBranch = statement.getThen();
            String bodyText = thenBranch.getText();
            CollapseIfFix.replaceStatement((JSStatement)statement, bodyText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/IfStatementWithIdenticalBranchesJSInspection$CollapseIfFix", "getFamilyName"));
        }
    }
}

