/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NestedFunctionJSInspection
extends JavaScriptInspection {
    public boolean m_includeAnonymousFunctions = false;

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        JSFunction function2 = (JSFunction)((PsiElement)args[0]).getParent();
        if (NestedFunctionJSInspection.functionHasIdentifier(function2)) {
            String string = InspectionJSBundle.message("nested.function.error.string", new Object[0]);
            if (string == null) {
                NestedFunctionJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = InspectionJSBundle.message("nested.anonymous.function.error.string", new Object[0]);
        if (string == null) {
            NestedFunctionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionJSBundle.message("include.anonymous.functions.parameter", new Object[0]), (InspectionProfileEntry)this, "m_includeAnonymousFunctions");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/NestedFunctionJSInspection", "buildErrorString"));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function2) {
            if (function2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSFunctionDeclaration(function2);
            if (!NestedFunctionJSInspection.this.m_includeAnonymousFunctions && function2 instanceof JSFunctionExpression) {
                return;
            }
            if (function2.getParent() instanceof JSClass) {
                return;
            }
            JSFunction containingFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)function2, JSFunction.class, (boolean)true);
            if (containingFunction == null) {
                return;
            }
            this.registerFunctionError(function2);
        }

        public void visitJSFunctionExpression(JSFunctionExpression node) {
            this.visitJSFunctionDeclaration((JSFunction)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/sixrr/inspectjs/confusing/NestedFunctionJSInspection$Visitor", "visitJSFunctionDeclaration"));
        }
    }
}

