/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptCompositeImportsResolverImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolverImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptImportsResolverProvider {
    public static final ExtensionPointName<TypeScriptImportsResolverProvider> EP = ExtensionPointName.create((String)"JavaScript.tsImportResolver");
    public static final ClearableLazyValue<Pair<List<String>, Set<String>>> FILE_EXTENSIONS = ExtensionPointUtil.dropLazyValueOnChange((ClearableLazyValue)ClearableLazyValue.createAtomic(() -> {
        ArrayList<String> resultWithDot = new ArrayList<String>();
        HashSet<String> resultWithoutDot = new HashSet<String>();
        String[] defaultFileExtensions = TypeScriptFileImportsResolver.TYPESCRIPT_AND_JS_EXTENSIONS_FIXED_ORDER;
        TypeScriptImportsResolverProvider.addFileExtensions(resultWithoutDot, defaultFileExtensions, true);
        TypeScriptImportsResolverProvider.addFileExtensions(resultWithDot, defaultFileExtensions, false);
        for (TypeScriptImportsResolverProvider el : EP.getExtensionList()) {
            TypeScriptImportsResolverProvider.addFileExtensions(resultWithoutDot, el.getExtensions(), true);
            TypeScriptImportsResolverProvider.addFileExtensions(resultWithDot, el.getExtensions(), false);
        }
        return new Pair(resultWithDot, resultWithoutDot);
    }), EP, null);

    @NotNull
    public static List<String> getAllFileExtensionsWithDot() {
        List list2 = (List)((Pair)TypeScriptImportsResolverProvider.FILE_EXTENSIONS.getValue()).first;
        if (list2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public static Set<String> getAllFileExtensionsWithoutDot() {
        Set set = (Set)((Pair)TypeScriptImportsResolverProvider.FILE_EXTENSIONS.getValue()).second;
        if (set == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(1);
        }
        return set;
    }

    public static void addFileExtensions(@NotNull Collection<String> result2, String @NotNull [] extensions, boolean trim) {
        if (result2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(2);
        }
        if (extensions == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(3);
        }
        for (String extension : extensions) {
            result2.add(trim ? StringUtil.trimStart((String)extension, (String)".") : extension);
        }
    }

    public static boolean checkForDynamicFiles(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(5);
        }
        for (TypeScriptImportsResolverProvider provider : EP.getExtensionList()) {
            if (!provider.isDynamicFile(project, file2)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public TypeScriptFileImportsResolver createResolver(@NotNull Project var1, @NotNull TypeScriptConfig var2);

    public String @NotNull [] getExtensions();

    @Nullable
    public TypeScriptFileImportsResolver createResolver(@NotNull Project var1, @NotNull TypeScriptImportResolveContext var2, @NotNull VirtualFile var3);

    public boolean useExplicitExtension(@NotNull String var1);

    @NotNull
    public static TypeScriptFileImportsResolver getResolver(@NotNull Project project, @NotNull TypeScriptConfig config2) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(6);
        }
        if (config2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(7);
        }
        for (TypeScriptImportsResolverProvider provider : EP.getExtensionList()) {
            TypeScriptFileImportsResolver resolver = provider.createResolver(project, config2);
            if (resolver == null) continue;
            TypeScriptFileImportsResolver typeScriptFileImportsResolver = resolver;
            if (typeScriptFileImportsResolver == null) {
                TypeScriptImportsResolverProvider.$$$reportNull$$$0(8);
            }
            return typeScriptFileImportsResolver;
        }
        return TypeScriptImportsResolverProvider.getDefaultProvider(project, config2);
    }

    @NotNull
    public static TypeScriptFileImportsResolver getResolver(@NotNull Project project, @NotNull TypeScriptImportResolveContext context, @NotNull VirtualFile file2) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(9);
        }
        if (context == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(11);
        }
        for (TypeScriptImportsResolverProvider provider : EP.getExtensionList()) {
            TypeScriptFileImportsResolver resolver = provider.createResolver(project, context, file2);
            if (resolver == null) continue;
            TypeScriptFileImportsResolver typeScriptFileImportsResolver = resolver;
            if (typeScriptFileImportsResolver == null) {
                TypeScriptImportsResolverProvider.$$$reportNull$$$0(12);
            }
            return typeScriptFileImportsResolver;
        }
        return TypeScriptImportsResolverProvider.getDefaultProvider(project, context, file2);
    }

    @NotNull
    public static JSModuleNameInfo.ExtensionSettings getPathSettings(@NotNull PsiElement place, @NotNull String extensionWithDot) {
        if (place == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(13);
        }
        if (extensionWithDot == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(14);
        }
        if (extensionWithDot.equals(".json")) {
            JSModuleNameInfo.ExtensionSettings extensionSettings = JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION;
            if (extensionSettings == null) {
                TypeScriptImportsResolverProvider.$$$reportNull$$$0(15);
            }
            return extensionSettings;
        }
        if (TypeScriptImportsResolverProvider.isMjsContext(place, extensionWithDot)) {
            JSModuleNameInfo.ExtensionSettings extensionSettings = JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION;
            if (extensionSettings == null) {
                TypeScriptImportsResolverProvider.$$$reportNull$$$0(16);
            }
            return extensionSettings;
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(place);
        if (DialectDetector.isTypeScript(place)) {
            for (TypeScriptImportsResolverProvider provider : EP.getExtensionList()) {
                if (!provider.useExplicitExtension(extensionWithDot)) continue;
                JSModuleNameInfo.ExtensionSettings extensionSettings = JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION;
                if (extensionSettings == null) {
                    TypeScriptImportsResolverProvider.$$$reportNull$$$0(17);
                }
                return extensionSettings;
            }
            JSModuleNameInfo.ExtensionSettings extensionSettings = settings.isUseExplicitJSExtension() && TypeScriptFileImportsResolver.isTsExtension(extensionWithDot) ? JSModuleNameInfo.ExtensionSettings.FORCE_JS_EXTENSION : JSModuleNameInfo.ExtensionSettings.NO_EXTENSION;
            if (extensionSettings == null) {
                TypeScriptImportsResolverProvider.$$$reportNull$$$0(18);
            }
            return extensionSettings;
        }
        if (!settings.isUseExplicitJSExtension()) {
            JSModuleNameInfo.ExtensionSettings extensionSettings = JSModuleNameInfo.ExtensionSettings.NO_EXTENSION;
            if (extensionSettings == null) {
                TypeScriptImportsResolverProvider.$$$reportNull$$$0(19);
            }
            return extensionSettings;
        }
        JSModuleNameInfo.ExtensionSettings extensionSettings = settings.isUseExplicitJSExtension() && TypeScriptFileImportsResolver.isTsExtension(extensionWithDot) ? JSModuleNameInfo.ExtensionSettings.FORCE_JS_EXTENSION : JSModuleNameInfo.ExtensionSettings.FORCE_EXTENSION;
        if (extensionSettings == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(20);
        }
        return extensionSettings;
    }

    public static boolean isMjsContext(@NotNull PsiElement place, @NotNull String extensionWithDot) {
        PsiFile file2;
        if (place == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(21);
        }
        if (extensionWithDot == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(22);
        }
        if ((file2 = place.getContainingFile()) == null) {
            return false;
        }
        String extension = JSFileReference.findImplicitExtension(file2.getName());
        return ".mjs".equals(extensionWithDot) || ".mjs".equals(extension) && !ArrayUtil.contains((String)extensionWithDot, (String[])TypeScriptUtil.TYPESCRIPT_EXTENSIONS);
    }

    @NotNull
    public static TypeScriptFileImportsResolver getDefaultProvider(@NotNull Project project, @NotNull TypeScriptImportResolveContext context, @NotNull VirtualFile file2) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(23);
        }
        if (context == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(24);
        }
        if (file2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(25);
        }
        return new TypeScriptFileImportsResolverImpl(project, context, TypeScriptNodeReference.TS_PROCESSOR);
    }

    default public boolean isDynamicFile(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(27);
        }
        return false;
    }

    @NotNull
    public static TypeScriptFileImportsResolver getDefaultProvider(@NotNull Project project, @NotNull TypeScriptConfig config2) {
        if (project == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(28);
        }
        if (config2 == null) {
            TypeScriptImportsResolverProvider.$$$reportNull$$$0(29);
        }
        TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor processor = TypeScriptNodeReference.TS_PROCESSOR;
        TypeScriptImportResolveContext context = config2.getResolveContext();
        if (!config2.allowJs()) {
            return new TypeScriptFileImportsResolverImpl(project, context, processor);
        }
        ArrayList resolvers = ContainerUtil.newArrayList((Object[])new TypeScriptFileImportsResolver[]{new TypeScriptFileImportsResolverImpl(project, context, processor), new TypeScriptFileImportsResolverImpl(project, context, processor, TypeScriptFileImportsResolver.JS_EXTENSIONS, DialectDetector.JAVASCRIPT_FILE_TYPES)});
        return new TypeScriptCompositeImportsResolverImpl(resolvers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptImportsResolverProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 11: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 14: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionWithDot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileExtensionsWithDot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileExtensionsWithoutDot";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptImportsResolverProvider";
                break;
            }
            case 8: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolver";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFileExtensions";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkForDynamicFiles";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResolver";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPathSettings";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isMjsContext";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultProvider";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isDynamicFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

