/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.html.HtmlLikeFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigUtil {
    private static final Key<ParameterizedCachedValue<TypeScriptConfig, PsiFile>> CACHE_KEY = Key.create((String)"TypeScript.PsiFile.To.Config");
    private static final ParameterizedCachedValueProvider<TypeScriptConfig, PsiFile> CACHED_JS_TS_CONFIG_PROVIDER = param -> {
        VirtualFile file2 = param.getOriginalFile().getVirtualFile();
        Project project = param.getProject();
        if (file2 == null) {
            return CachedValueProvider.Result.create(null, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(project);
        TypeScriptConfig config2 = (param instanceof JSFile || param instanceof HtmlLikeFile) && !DialectDetector.isTypeScript((PsiElement)param) ? service.getPreferableJSConfig(file2) : service.getPreferableConfig(file2);
        return CachedValueProvider.Result.create((Object)config2, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
    };

    public static String getNonStandardProjectFileName(@NotNull Project project, @NotNull VirtualFile el) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(0);
        }
        if (el == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(1);
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForFile(project, el);
        return TypeScriptConfigUtil.getNonStandardProjectFileName(config2);
    }

    @Nullable
    public static String getNonStandardProjectFileName(@Nullable TypeScriptConfig config2) {
        return TypeScriptConfigUtil.isNonStandardName(config2) ? TypeScriptConfigUtil.getConfigProjectFileName(config2) : null;
    }

    @NotNull
    public static String getConfigProjectFileName(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(2);
        }
        String string = FileUtil.toSystemDependentName((String)config2.getConfigFile().getPath());
        if (string == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static TypeScriptConfig getPreferableOrParentConfig(@NotNull PsiFile containingFile) {
        List<VirtualFile> allConfigs2;
        if (containingFile == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(4);
        }
        Project project = containingFile.getProject();
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(project);
        TypeScriptConfig configForFile = TypeScriptConfigUtil.getConfigForPsiFile(containingFile);
        if (configForFile == null && !(allConfigs2 = service.getConfigFiles()).isEmpty()) {
            configForFile = service.parseConfigFile(TypeScriptConfigUtil.getNearestParentConfigFile(containingFile.getVirtualFile(), allConfigs2));
        }
        return configForFile;
    }

    @Nullable
    public static VirtualFile finDefaultTypesDirectory(@NotNull VirtualFile context) {
        VirtualFile nodeModules;
        if (context == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(5);
        }
        return (nodeModules = JSLibraryUtil.findUpClosestNodeModulesResolveRoot(context)) != null ? nodeModules.findChild("@types") : null;
    }

    public static String toLibraryName(@NotNull String rawName) {
        if (rawName == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(6);
        }
        if ((rawName = StringUtil.toLowerCase((String)rawName)).equals("es6")) {
            return "es2015";
        }
        if (rawName.equals("es7")) {
            return "es2016";
        }
        return rawName;
    }

    public static boolean hasConfigsWithNonStandardName(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(7);
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(project);
        return service.getConfigFiles().stream().anyMatch(el -> !el.getName().equalsIgnoreCase("tsconfig.json"));
    }

    public static boolean isNonStandardName(@Nullable TypeScriptConfig config2) {
        if (config2 == null) {
            return false;
        }
        return TypeScriptConfigUtil.isNonStandardName(config2.getConfigFile());
    }

    public static boolean isNonStandardName(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(8);
        }
        return !configFile.getName().equalsIgnoreCase("tsconfig.json");
    }

    @Nullable
    private static JsonProperty getFilesProperty(Project project, TypeScriptConfig config2) {
        PsiFile file2 = PsiManager.getInstance((Project)project).findFile(config2.getConfigFile());
        return TypeScriptConfigUtil.getProperty(file2, "files");
    }

    @Nullable
    private static JsonProperty getIncludeProperty(Project project, TypeScriptConfig config2) {
        PsiFile file2 = PsiManager.getInstance((Project)project).findFile(config2.getConfigFile());
        return TypeScriptConfigUtil.getProperty(file2, "include");
    }

    @Nullable
    private static JsonProperty getProperty(@Nullable PsiFile file2, @NotNull String propertyName) {
        if (propertyName == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            return null;
        }
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getChildOfType((PsiElement)file2, JsonObject.class);
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.findProperty(propertyName);
    }

    public static boolean addVirtualFileToConfigFiles(Project project, VirtualFile file2, TypeScriptConfig config2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        assert (!config2.isDirectoryBased());
        JsonProperty property = TypeScriptConfigUtil.getFilesProperty(project, config2);
        if (property == null && (property = TypeScriptConfigUtil.getIncludeProperty(project, config2)) == null) {
            return false;
        }
        JsonArray value = (JsonArray)property.getValue();
        if (value == null) {
            return false;
        }
        String path = VfsUtilCore.findRelativePath((VirtualFile)config2.getConfigFile(), (VirtualFile)file2, (char)'/');
        if (path == null) {
            return false;
        }
        PsiElement result2 = TypeScriptConfigUtil.addValueToJsonArray(project, value, path);
        return result2 != null;
    }

    @Nullable
    public static PsiElement addValueToJsonArray(@NotNull Project project, @NotNull JsonArray value, @NotNull String toAdd) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(10);
        }
        if (value == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(11);
        }
        if (toAdd == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(12);
        }
        List list2 = value.getValueList();
        String text = value.getText();
        StringBuilder builder = new StringBuilder(text);
        int i = text.lastIndexOf("]");
        String str = (list2.isEmpty() ? "" : ",") + "\"" + toAdd + "\"";
        builder.insert(i, str);
        return value.replace((PsiElement)TypeScriptConfigUtil.createJSONAndGetPropertyValue(project, builder.toString()));
    }

    @NotNull
    private static JsonValue createJSONAndGetPropertyValue(@NotNull Project project, @NotNull String propertyValue) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(13);
        }
        if (propertyValue == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(14);
        }
        String tempName = "tempName";
        JsonProperty property = TypeScriptConfigUtil.createJsonProperty(project, tempName, propertyValue, false);
        JsonValue jsonValue = Objects.requireNonNull(property.getValue());
        if (jsonValue == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(15);
        }
        return jsonValue;
    }

    @NotNull
    public static JsonProperty createJsonProperty(@NotNull Project project, @NotNull String propertyName, @NotNull String propertyValue, boolean withComma) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(16);
        }
        if (propertyName == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(17);
        }
        if (propertyValue == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(18);
        }
        String json = String.format("{ \"" + propertyName + "\":%s" + (withComma ? "," : "") + " }", propertyValue);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText((Language)JsonLanguage.INSTANCE, (CharSequence)json);
        JsonProperty jsonProperty = Objects.requireNonNull(TypeScriptConfigUtil.getProperty(psiFile, propertyName));
        if (jsonProperty == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(19);
        }
        return jsonProperty;
    }

    public static boolean strictNullChecks(@Nullable PsiElement context) {
        if (context == null || !context.isValid() || !DialectDetector.isTypeScript(context)) {
            return false;
        }
        TypeScriptConfig file2 = TypeScriptConfigUtil.getConfigForPsiFile(context.getContainingFile());
        return file2 != null && file2.strictNullChecks();
    }

    public static boolean noImplicitThis(@Nullable PsiElement context) {
        if (context == null || !context.isValid() || !DialectDetector.isTypeScript(context)) {
            return false;
        }
        TypeScriptConfig file2 = TypeScriptConfigUtil.getConfigForPsiFile(context.getContainingFile());
        return file2 != null && file2.noImplicitThis();
    }

    public static String getOutDirectory(VirtualFile baseFile, String relativeOrAbsolutePath) {
        if (StringUtil.isEmpty((String)relativeOrAbsolutePath)) {
            return null;
        }
        if (FileUtil.isAbsolute((String)relativeOrAbsolutePath)) {
            return relativeOrAbsolutePath;
        }
        VirtualFile file2 = VfsUtil.findRelativeFile((VirtualFile)baseFile, (String[])ArrayUtilRt.toStringArray((Collection)FileUtil.splitPath((String)FileUtil.toCanonicalPath((String)relativeOrAbsolutePath))));
        return file2 == null ? null : file2.getCanonicalPath();
    }

    @Nullable
    public static TypeScriptConfig getConfigForPsiFile(@Nullable PsiFile file2) {
        return TypeScriptConfigUtil.getConfigForPsiFile(file2, false);
    }

    @Nullable
    public static TypeScriptConfig getConfigForPsiFile(@Nullable PsiFile file2, boolean includeJSConfig) {
        if (file2 == null || DumbService.isDumb((Project)file2.getProject())) {
            return null;
        }
        TypeScriptConfig config2 = (TypeScriptConfig)CachedValuesManager.getManager((Project)file2.getProject()).getParameterizedCachedValue((UserDataHolder)file2, CACHE_KEY, CACHED_JS_TS_CONFIG_PROVIDER, false, (Object)file2);
        if (!includeJSConfig && config2 != null && config2.isJSConfig()) {
            return null;
        }
        return config2;
    }

    @Nullable
    public static TypeScriptConfig getConfigForFile(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (project == null) {
            return null;
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(project);
        return service.getPreferableConfig(file2);
    }

    public static boolean configGraphIncludesFile(@NotNull Project project, @NotNull VirtualFile file2, @NotNull VirtualFile tsConfigFile) {
        if (project == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(21);
        }
        if (file2 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(22);
        }
        if (tsConfigFile == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(23);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(project);
        TypeScriptConfig tsConfig = service.parseConfigFile(tsConfigFile);
        return tsConfig != null && service.configGraphIncludesFile(file2, tsConfig);
    }

    @Deprecated
    @Nullable
    public static VirtualFile getNearestParentConfig(@Nullable VirtualFile file2) {
        VirtualFile toSearch;
        if (file2 == null) {
            return null;
        }
        VirtualFile virtualFile = toSearch = file2.isDirectory() ? file2 : file2.getParent();
        while (toSearch != null && toSearch.isValid()) {
            VirtualFile child = toSearch.findChild("tsconfig.json");
            if (child != null) {
                return child;
            }
            toSearch = toSearch.getParent();
        }
        return null;
    }

    @Nullable
    public static VirtualFile getNearestParentConfigFile(@Nullable VirtualFile file2, @NotNull Collection<? extends VirtualFile> configs) {
        if (configs == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(24);
        }
        return (VirtualFile)ContainerUtil.getFirstItem(TypeScriptConfigUtil.getNearestParentConfigFiles(file2, configs));
    }

    @NotNull
    public static Collection<? extends VirtualFile> getNearestParentConfigFiles(@Nullable VirtualFile file2, @NotNull Collection<? extends VirtualFile> configs) {
        if (configs == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(25);
        }
        if (file2 == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptConfigUtil.$$$reportNull$$$0(26);
            }
            return list2;
        }
        if (configs.size() <= 1) {
            Collection<? extends VirtualFile> collection = configs;
            if (collection == null) {
                TypeScriptConfigUtil.$$$reportNull$$$0(27);
            }
            return collection;
        }
        Collection result2 = null;
        for (VirtualFile toSearch = file2.getParent(); toSearch != null; toSearch = toSearch.getParent()) {
            for (VirtualFile virtualFile : configs) {
                ProgressManager.checkCanceled();
                if (!virtualFile.getParent().equals(toSearch)) continue;
                if (result2 == null) {
                    result2 = new SmartList();
                }
                result2.add(virtualFile);
            }
            if (result2 == null) continue;
            Collection collection = result2;
            if (collection == null) {
                TypeScriptConfigUtil.$$$reportNull$$$0(28);
            }
            return collection;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(29);
        }
        return list3;
    }

    @Nullable
    public static PathMatcher getExcludeMatchers(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(30);
        }
        Collection<String> patterns = config2.getExcludePatterns();
        return TypeScriptConfigUtil.getMatcher(config2, patterns, true);
    }

    @Nullable
    public static PathMatcher getIncludeMatchers(@NotNull TypeScriptConfig config2) {
        if (config2 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(31);
        }
        Collection<String> patterns = config2.getIncludePatterns();
        return TypeScriptConfigUtil.getMatcher(config2, patterns, false);
    }

    @Nullable
    private static PathMatcher getMatcher(@NotNull TypeScriptConfig config2, @NotNull Collection<String> patterns, boolean allowTrailingRecursion) {
        if (config2 == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(32);
        }
        if (patterns == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(33);
        }
        return TypeScriptConfigUtil.getMatcher(config2.getConfigDirectory(), patterns, allowTrailingRecursion);
    }

    @Nullable
    public static PathMatcher getMatcher(@NotNull VirtualFile baseDir, @NotNull Collection<String> patterns, boolean allowTrailingRecursion) {
        if (baseDir == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(34);
        }
        if (patterns == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(35);
        }
        String tsConfigDirectoryPath = baseDir.getPath();
        ArrayList<String> patternList = new ArrayList<String>();
        String invalidTrailingRecursionPattern = "(^|/)\\*\\*/?$";
        String invalidDotDotAfterRecursiveWildcardPattern = "(^|/)\\*\\*/(.*/)?\\.\\.($|/\\*?)";
        for (String pattern : patterns) {
            if (!allowTrailingRecursion && pattern.matches(invalidTrailingRecursionPattern) || pattern.matches(invalidDotDotAfterRecursiveWildcardPattern)) {
                return null;
            }
            String stringPath = TypeScriptConfigUtil.escapeGlobPattern(JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(tsConfigDirectoryPath, pattern));
            TypeScriptConfigUtil.preprocessPatterns(patternList, stringPath);
        }
        if (patternList.isEmpty()) {
            return null;
        }
        FileSystem fs = FileSystems.getDefault();
        String result2 = "glob:{" + String.join((CharSequence)",", patternList) + "}";
        try {
            return fs.getPathMatcher(result2);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptConfigUtil.class).error((Throwable)e);
            Path path = Paths.get(tsConfigDirectoryPath, new String[0]);
            return candidate -> candidate.startsWith(path);
        }
    }

    private static void preprocessPatterns(@NotNull List<String> patternList, @NotNull String stringPath) {
        if (patternList == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(36);
        }
        if (stringPath == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(37);
        }
        patternList.add(stringPath);
        if (!stringPath.endsWith("*")) {
            patternList.add(stringPath + "/**");
        }
        String replace = StringUtil.replace((String)stringPath, (String)"/**", (String)"");
        patternList.add(replace);
        if (!replace.endsWith("*")) {
            patternList.add(replace + "/**");
        }
    }

    @NotNull
    private static String escapeGlobPattern(@NotNull String pattern) {
        if (pattern == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(38);
        }
        String string = pattern.replace("{", "\\{").replace("}", "\\}");
        if (string == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    public static PathMatcher getPathMatcher(@NotNull Collection<String> rawPaths) {
        if (rawPaths == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(40);
        }
        if (rawPaths.isEmpty()) {
            return null;
        }
        FileSystem fs = FileSystems.getDefault();
        ArrayList objects = new ArrayList();
        rawPaths.forEach(el -> TypeScriptConfigUtil.preprocessPatterns(objects, el));
        String result2 = "glob:{" + String.join((CharSequence)",", objects) + "}";
        try {
            return fs.getPathMatcher(result2);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(TypeScriptConfigUtil.class).warn((Throwable)e);
            return candidate -> false;
        }
    }

    public static boolean isRootDiskPath(@NotNull String stringPath) {
        if (stringPath == null) {
            TypeScriptConfigUtil.$$$reportNull$$$0(41);
        }
        return FileUtil.isAbsolute((String)stringPath);
    }

    public static boolean allowJS(@Nullable PsiFile file2) {
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(file2);
        if (config2 == null) {
            return false;
        }
        return config2.allowJs();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 15: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 15: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 2: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: 
            case 15: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toAdd";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tsConfigFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternList";
                break;
            }
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringPath";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigProjectFileName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createJSONAndGetPropertyValue";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createJsonProperty";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getNearestParentConfigFiles";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeGlobPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNonStandardProjectFileName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfigProjectFileName";
                break;
            }
            case 3: 
            case 15: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 39: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPreferableOrParentConfig";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "finDefaultTypesDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toLibraryName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigsWithNonStandardName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNonStandardName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addValueToJsonArray";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createJSONAndGetPropertyValue";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createJsonProperty";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getConfigForFile";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "configGraphIncludesFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNearestParentConfigFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getNearestParentConfigFiles";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeMatchers";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getIncludeMatchers";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getMatcher";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "preprocessPatterns";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "escapeGlobPattern";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getPathMatcher";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isRootDiskPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 15: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

