/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigLibraryUpdater
implements Disposable {
    public static final String TSCONFIG_PATHS_LIBRARY = "tsconfig$paths";
    private static final String DEPRECATED_TSCONFIG_LIBRARY = "tsconfig$roots";
    private static final int UPDATE_TIME = (int)TimeUnit.SECONDS.toMillis(6L);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergingUpdateQueue myQueue;

    public TypeScriptConfigLibraryUpdater(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myQueue = new MergingUpdateQueue("Update typescript config additional roots/paths", UPDATE_TIME, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD).usePassThroughInUnitTestMode();
        this.myQueue.setRestartTimerOnAdd(true);
    }

    public void dispose() {
    }

    public void queueToUpdate() {
        TypeScriptSettings settings = TypeScriptSettings.getSettings(this.myProject);
        if (settings == null || !settings.isAutoIncludeConfigPaths()) {
            return;
        }
        this.myQueue.queue(new Update(this){

            public void run() {
                TypeScriptConfigLibraryUpdater.this.update();
            }
        });
    }

    private void update() {
        Runnable runnable = () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (DumbService.isDumb((Project)this.myProject)) {
                throw new ProcessCanceledException();
            }
            TypeScriptConfigService service = TypeScriptConfigService.Provider.get(this.myProject);
            List<VirtualFile> files = service.getConfigFiles();
            if (files.isEmpty()) {
                return;
            }
            this.processConfigsDirectory(files);
        };
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
            return;
        }
        boolean result2 = ProgressIndicatorUtils.runInReadActionWithWriteActionPriority((Runnable)runnable);
        if (!result2) {
            this.queueToUpdate();
        }
    }

    void processConfigsDirectory(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDisposed()) {
            return;
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(this.myProject);
        ScriptingLibraryMappings mappings = libraryManager.getLibraryMappings();
        ScriptingLibraryModel newLibrary = libraryManager.getLibraryByName(TSCONFIG_PATHS_LIBRARY);
        if (newLibrary != null && !mappings.isAssociatedWithProject(TSCONFIG_PATHS_LIBRARY)) {
            return;
        }
        this.processAndUpdateFiles(configs);
    }

    private void updateFiles(@NotNull Collection<VirtualFile> possibleLibraryFiles) {
        if (possibleLibraryFiles == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(2);
        }
        Application application = ApplicationManager.getApplication();
        application.assertReadAccessAllowed();
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)this.myProject);
        ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
        List fileOutOfProjectScope = ContainerUtil.filter(possibleLibraryFiles, file2 -> !NodeModuleUtil.hasNodeModulesDirInPath(file2, null) && !NodeModuleUtil.isNodeModules(file2) && !scope.accept(file2) && fileIndex.getContentRootForFile(file2, true) == null);
        if (!TypeScriptConfigLibraryUpdater.checkNeedUpdate(this.myProject, fileOutOfProjectScope)) {
            return;
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(this.myProject);
        ModificationTracker tracker = service.getTracker();
        long count = tracker.getModificationCount();
        Runnable update2 = () -> WriteAction.run(() -> TypeScriptConfigLibraryUpdater.updateLibrary(this.myProject, fileOutOfProjectScope));
        if (application.isDispatchThread()) {
            update2.run();
            return;
        }
        application.invokeLater(update2, o -> count != tracker.getModificationCount());
    }

    private void processAndUpdateFiles(@NotNull Collection<VirtualFile> configs) {
        if (configs == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(3);
        }
        if (configs.isEmpty()) {
            return;
        }
        TypeScriptConfigService service = TypeScriptConfigService.Provider.get(this.myProject);
        HashSet<VirtualFile> toUpdate = new HashSet<VirtualFile>();
        for (VirtualFile configFile : configs) {
            TypeScriptConfig config2 = service.parseConfigFile(configFile);
            ProgressManager.checkCanceled();
            if (config2 == null) continue;
            if (config2.hasErrors()) {
                return;
            }
            Collection<PsiFileSystemItem> dirs = config2.getRootDirs();
            for (PsiFileSystemItem dir : dirs) {
                String path;
                VirtualFile file2 = dir.getVirtualFile();
                if (file2 == null || (path = file2.getCanonicalPath()) == null || path.length() <= 2) continue;
                toUpdate.add(file2);
            }
            toUpdate.addAll(this.getBaseUrlRelatedFiles(config2));
        }
        this.updateFiles(toUpdate);
    }

    @NotNull
    protected Collection<VirtualFile> getBaseUrlRelatedFiles(@NotNull TypeScriptConfig config2) {
        VirtualFile baseUrl;
        if (config2 == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(4);
        }
        if ((baseUrl = config2.getBaseUrl()) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(5);
            }
            return list2;
        }
        Collection<JSModulePathSubstitution> paths = config2.getPaths();
        if (paths.isEmpty()) {
            return TypeScriptConfigLibraryUpdater.getBaseUrlFile(baseUrl);
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (JSModulePathSubstitution substitution : paths) {
            for (String path : substitution.getMappings()) {
                String canonicalPath;
                if (!TypeScriptConfigLibraryUpdater.pathCanBeProcessed(path)) {
                    return TypeScriptConfigLibraryUpdater.getBaseUrlFile(baseUrl);
                }
                boolean endsWithStar = path.contains("*");
                String normalizedPath = endsWithStar ? path.substring(0, path.indexOf("*")) : path;
                VirtualFile pathUrl = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, normalizedPath);
                if (!endsWithStar && pathUrl == null) {
                    String extension;
                    String[] stringArray = TypeScriptUtil.TYPESCRIPT_EXTENSIONS;
                    int n = stringArray.length;
                    for (int i = 0; i < n && (pathUrl = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, normalizedPath + (extension = stringArray[i]))) == null; ++i) {
                    }
                }
                if (pathUrl == null || (canonicalPath = pathUrl.getCanonicalPath()) == null || canonicalPath.length() <= 2) continue;
                result2.add(pathUrl);
            }
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private static List<VirtualFile> getBaseUrlFile(@NotNull VirtualFile baseUrl) {
        String path;
        if (baseUrl == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(7);
        }
        List list2 = (path = baseUrl.getCanonicalPath()) == null || path.length() <= 2 ? ContainerUtil.emptyList() : ContainerUtil.createMaybeSingletonList((Object)baseUrl);
        if (list2 == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static boolean checkNeedUpdate(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(9);
        }
        if (files == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Library deprecatedLibrary = TypeScriptConfigLibraryUpdater.getDeprecatedLibrary(project);
        if (deprecatedLibrary != null) {
            return true;
        }
        TypeScriptExcludeManager manager2 = TypeScriptExcludeManager.getInstance(project);
        HashSet<VirtualFile> roots2 = new HashSet<VirtualFile>(manager2.getAdditionalRoots());
        return !new HashSet<VirtualFile>(files).equals(roots2);
    }

    @Nullable
    private static Library getDeprecatedLibrary(@NotNull Project project) {
        if (project == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(11);
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.PROJECT);
        return libTable.getLibraryByName(DEPRECATED_TSCONFIG_LIBRARY);
    }

    private static void updateLibrary(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(12);
        }
        if (files == null) {
            TypeScriptConfigLibraryUpdater.$$$reportNull$$$0(13);
        }
        if (project.isDisposed()) {
            return;
        }
        TypeScriptExcludeManager manager2 = TypeScriptExcludeManager.getInstance(project);
        Library deprecatedLibrary = TypeScriptConfigLibraryUpdater.getDeprecatedLibrary(project);
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        if (deprecatedLibrary != null) {
            ScriptingLibraryModel deprecatedModule = libraryManager.getScriptingLibraryTable().getModel(deprecatedLibrary);
            libraryManager.removeLibrary(deprecatedModule);
        }
        libraryManager.getLibraryByName(TSCONFIG_PATHS_LIBRARY);
        manager2.updateAdditionalRoots(files);
        libraryManager.commitChanges();
    }

    private static boolean pathCanBeProcessed(String pattern) {
        return JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern) || pattern.contains("/*") || !pattern.contains("*");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleLibraryFiles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/tsconfig/TypeScriptConfigLibraryUpdater";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrlRelatedFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrlFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processConfigsDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAndUpdateFiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getBaseUrlRelatedFiles";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBaseUrlFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkNeedUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDeprecatedLibrary";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateLibrary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

