/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="TypeScriptGeneratedFilesManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class TypeScriptExcludeManager
implements PersistentStateComponent<State> {
    private static final int VERSION = 3;
    private static final String TEMP_FILE_PREFIX = "temp:";
    private final Project myProject;
    private volatile State myState = new State();

    public TypeScriptExcludeManager(Project project) {
        this.myProject = project;
    }

    @NotNull
    public static TypeScriptExcludeManager getInstance(@NotNull Project project) {
        if (project == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(0);
        }
        TypeScriptExcludeManager typeScriptExcludeManager = (TypeScriptExcludeManager)ServiceManager.getService((Project)project, TypeScriptExcludeManager.class);
        if (typeScriptExcludeManager == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(1);
        }
        return typeScriptExcludeManager;
    }

    public boolean isExcludeDeclarationFiles() {
        return this.myState.excludeDeclarationFiles;
    }

    public void setExcludeDeclarationFiles(boolean excludeDefinitionFiles) {
        this.myState.excludeDeclarationFiles = excludeDefinitionFiles;
    }

    public boolean isExcludeGeneratedFiles() {
        return this.myState.excludeGeneratedFiles;
    }

    @NotNull
    public Collection<VirtualFile> getExcludedPlainFiles() {
        Collection<String> files = this.getExcludedPaths();
        if (files.isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptExcludeManager.$$$reportNull$$$0(2);
            }
            return list2;
        }
        Set<VirtualFile> filteredFiles = TypeScriptExcludeManager.getVirtualFilesFor(files);
        if (filteredFiles.size() != files.size()) {
            this.updateExcludedFiles(filteredFiles);
        }
        Set<VirtualFile> set = filteredFiles;
        if (set == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Collection<VirtualFile> getAdditionalRoots() {
        Collection<String> additionalRoots = this.myState.additionalRoots;
        if (additionalRoots.isEmpty()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                TypeScriptExcludeManager.$$$reportNull$$$0(4);
            }
            return list2;
        }
        Set<VirtualFile> filteredFiles = TypeScriptExcludeManager.getVirtualFilesFor(additionalRoots);
        if (filteredFiles.size() != additionalRoots.size()) {
            this.updateAdditionalRoots(filteredFiles);
        }
        Set<VirtualFile> set = filteredFiles;
        if (set == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(5);
        }
        return set;
    }

    @NotNull
    public Collection<String> getExcludedPaths() {
        Collection<String> collection = this.myState.exactExcludedFiles;
        if (collection == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public synchronized void updateAdditionalRoots(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(7);
        }
        this.myState.additionalRoots = TypeScriptExcludeManager.mapToStrings(files);
    }

    private synchronized void updateExcludedFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(8);
        }
        this.myState.exactExcludedFiles = TypeScriptExcludeManager.mapToStrings(files);
    }

    public int getVersion() {
        return this.myState.version;
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public boolean isProjectProcessed() {
        return this.myState.version == 3;
    }

    public void updateVersion() {
        this.myState.version = 3;
    }

    public boolean addFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(9);
        }
        if (files.isEmpty()) {
            return false;
        }
        ArrayList<String> result2 = new ArrayList<String>(this.getExcludedPaths());
        result2.addAll(TypeScriptExcludeManager.mapToStrings(files));
        this.myState.exactExcludedFiles = result2;
        return true;
    }

    public boolean removeFiles(@NotNull Collection<String> toRemove) {
        if (toRemove == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(10);
        }
        if (toRemove.isEmpty()) {
            return false;
        }
        HashSet<String> set = new HashSet<String>(toRemove);
        Collection<String> oldCollection = this.getExcludedPaths();
        List newList = ContainerUtil.filter(oldCollection, el -> !set.contains(el));
        if (newList.size() != oldCollection.size()) {
            this.myState.exactExcludedFiles = new ArrayList<String>(newList);
            return true;
        }
        return false;
    }

    @NotNull
    private static Set<VirtualFile> getVirtualFilesFor(@NotNull Collection<String> files) {
        if (files == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(11);
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        TempFileSystem tempFileSystem = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance() : null;
        Set set = StreamEx.of(files).map(file2 -> tempFileSystem != null && file2.startsWith(TEMP_FILE_PREFIX) ? tempFileSystem.findFileByPath(file2.substring(TEMP_FILE_PREFIX.length())) : localFileSystem.findFileByPath(file2)).nonNull().toSet();
        if (set == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(12);
        }
        return set;
    }

    @NotNull
    private static List<String> mapToStrings(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(13);
        }
        List list2 = ContainerUtil.mapNotNull(files, el -> TypeScriptExcludeManager.mapToString(el));
        if (list2 == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    public static String mapToString(@NotNull VirtualFile el) {
        boolean isUnitTestMode;
        if (el == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(15);
        }
        Object object = (isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode()) && el.getFileSystem() instanceof TempFileSystem ? TEMP_FILE_PREFIX + el.getPath() : el.getPath();
        if (object == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(16);
        }
        return object;
    }

    public void setFiles(Collection<VirtualFile> files) {
        this.myState.exactExcludedFiles = TypeScriptExcludeManager.mapToStrings(files);
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(17);
        }
        this.myState = state;
    }

    @NotNull
    public Set<String> getIncludedJSSourcePackages() {
        Set<String> set = this.myState.includedJSSourcePackages;
        if (set == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(18);
        }
        return set;
    }

    public void setIncludedJSSourcePackages(@NotNull Set<String> includedJSSourcePackages) {
        if (includedJSSourcePackages == null) {
            TypeScriptExcludeManager.$$$reportNull$$$0(19);
        }
        this.myState.includedJSSourcePackages = includedJSSourcePackages;
    }

    public void updateProject() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return;
        }
        WriteAction.run(() -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/settings/exclude/TypeScriptExcludeManager";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedJSSourcePackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptExcludeManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPlainFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPaths";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesFor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToStrings";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "mapToString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedJSSourcePackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateAdditionalRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateExcludedFiles";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mapToStrings";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mapToString";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setIncludedJSSourcePackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        public int version = 0;
        public boolean excludeDeclarationFiles = true;
        public boolean excludeGeneratedFiles = true;
        @NotNull
        public Collection<String> exactExcludedFiles = ContainerUtil.emptyList();
        public Collection<String> additionalRoots = ContainerUtil.emptyList();
        public Set<String> includedJSSourcePackages = Collections.emptySet();
    }
}

