/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.codeInsight.daemon.ReferenceImporter;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSPlaceElementFilter;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/lang/typescript/psi/TypeScriptReferenceImporter;", "Lcom/intellij/codeInsight/daemon/ReferenceImporter;", "()V", "autoImportReferenceAtCursor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAddUnambiguousImportsOnTheFlyEnabled", "intellij.javascript.impl"})
public final class TypeScriptReferenceImporter
implements ReferenceImporter {
    public boolean autoImportReferenceAtCursor(@NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        JSReferenceExpression jSReferenceExpression = JSImportHandlingUtil.findUnresolvedReferenceExpression(editor, file2, caretModel.getOffset());
        if (jSReferenceExpression == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)jSReferenceExpression, (String)"JSImportHandlingUtil.fin\u2026l.offset) ?: return false");
        JSReferenceExpression expression = jSReferenceExpression;
        if (!DialectDetector.isTypeScript((PsiElement)expression) || Intrinsics.areEqual((Object)true, (Object)((Boolean)expression.getUserData(JSImportAction.NO_HINT_KEY)))) {
            return false;
        }
        String string = expression.getReferenceName();
        if (string == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"expression.referenceName ?: return false");
        String referenceName = string;
        JSImportAction action = new JSImportAction(editor, (PsiElement)expression, referenceName, JSPlaceElementFilter.DEFAULT_FILTER);
        List<? extends JSImportCandidate> list2 = action.getRawCandidates();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"action.rawCandidates");
        List<? extends JSImportCandidate> candidates = list2;
        if (candidates.size() == 1) {
            expression.putUserData(JSImportAction.NO_HINT_KEY, (Object)true);
            action.executeFor(candidates.get(0), (Consumer<? super JSImportCandidate>)((Consumer)new Consumer<JSImportCandidate>(expression){
                final /* synthetic */ JSReferenceExpression $expression;

                public final void consume(JSImportCandidate it) {
                    this.$expression.putUserData(JSImportAction.NO_HINT_KEY, (Object)false);
                }
                {
                    this.$expression = jSReferenceExpression;
                }
            }));
            return true;
        }
        return false;
    }

    public boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return file2 instanceof JSFile && JSApplicationSettings.getInstance().hasTSUnambiguousImportsOnTheFlyEffective(((JSFile)file2).getProject());
    }
}

