/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.SemVer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypingsMapper {
    private static final String PACKAGE_JSON = "package.json";
    private static final String TYPESCRIPT_PACKAGE = "typescript";

    @Contract(value="!null,_,_,_->!null")
    public static String substituteTypings(@Nullable String path, @NotNull VirtualFile packageJson, @NotNull PackageJsonData data, boolean useTypeScriptPackage) {
        Map<String, List<JSModulePathSubstitution>> mappings;
        if (packageJson == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(0);
        }
        if (data == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(1);
        }
        if ((mappings = data.getTypingsVersionMappings()).isEmpty()) {
            return path;
        }
        VirtualFile module = packageJson.getParent();
        if (module == null) {
            return path;
        }
        VirtualFile nodeModulesCandidate = module.getParent();
        if (!"node_modules".contentEquals(nodeModulesCandidate.getNameSequence())) {
            nodeModulesCandidate = nodeModulesCandidate.getParent();
        }
        if (nodeModulesCandidate == null) {
            return path;
        }
        SemVer tsVersion = TypeScriptTypingsMapper.detectTypeScriptSemVer(nodeModulesCandidate, useTypeScriptPackage);
        for (Map.Entry<String, List<JSModulePathSubstitution>> entry : mappings.entrySet()) {
            String version = entry.getKey();
            if (!new TypeScriptRange(version).isMatched(tsVersion)) continue;
            return TypeScriptTypingsMapper.substituteTypingsForMapping(StringUtil.trimStart((String)((String)ObjectUtils.notNull((Object)path, (Object)"index")), (String)"./"), entry.getValue());
        }
        return path;
    }

    @NotNull
    private static String substituteTypingsForMapping(@NotNull String path, @NotNull List<JSModulePathSubstitution> substitutions) {
        Pair<JSModulePathSubstitution, String> max;
        if (path == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(2);
        }
        if (substitutions == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(3);
        }
        if ((max = JSPathMappingsUtil.findMaxElementByPaths(path, substitutions)) == null) {
            String string = path;
            if (string == null) {
                TypeScriptTypingsMapper.$$$reportNull$$$0(4);
            }
            return string;
        }
        JSModulePathSubstitution substitution = (JSModulePathSubstitution)max.first;
        String matchedStar = (String)max.second;
        Iterator<String> iterator = substitution.getMappings().iterator();
        if (iterator.hasNext()) {
            String mapping = iterator.next();
            String string = JSPathMappingsUtil.replaceStarForMapping(mapping, matchedStar);
            if (string == null) {
                TypeScriptTypingsMapper.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private static SemVer detectTypeScriptSemVer(@NotNull VirtualFile nodeModules, boolean checkTypeScriptPackage) {
        PackageJsonData packageJsonData;
        SemVer semVer;
        VirtualFile packageJson;
        VirtualFile typescript;
        if (nodeModules == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(7);
        }
        if (checkTypeScriptPackage && (typescript = nodeModules.findChild(TYPESCRIPT_PACKAGE)) != null && (packageJson = typescript.findChild(PACKAGE_JSON)) != null && (semVer = (packageJsonData = PackageJsonData.getOrCreate(packageJson)).getVersion()) != null) {
            SemVer semVer2 = semVer;
            if (semVer2 == null) {
                TypeScriptTypingsMapper.$$$reportNull$$$0(8);
            }
            return semVer2;
        }
        SemVer semVer3 = Objects.requireNonNull(SemVer.parseFromText((String)"4.1.3"));
        if (semVer3 == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(9);
        }
        return semVer3;
    }

    private static Sign getSign(@NotNull String range) {
        if (range == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(10);
        }
        for (Sign value : Sign.values()) {
            if (!range.startsWith(value.sign())) continue;
            return value;
        }
        return Sign.EQ;
    }

    private static String normalizeVersion(@NotNull String version) {
        int i;
        if (version == null) {
            TypeScriptTypingsMapper.$$$reportNull$$$0(11);
        }
        if ((i = StringUtil.countChars((CharSequence)version, (char)'.')) >= 2) {
            return version;
        }
        String postfix = StringUtil.repeat((String)".0", (int)(2 - i));
        return version + postfix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModules";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteTypingsForMapping";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "detectTypeScriptSemVer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "substituteTypings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "substituteTypingsForMapping";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "detectTypeScriptSemVer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSign";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TypeScriptRange {
        @Nullable
        private final SemVer myRightVersion;
        @NotNull
        private final Sign mySign;

        private TypeScriptRange(@NotNull String range) {
            if (range == null) {
                TypeScriptRange.$$$reportNull$$$0(0);
            }
            this.mySign = TypeScriptTypingsMapper.getSign(range);
            this.myRightVersion = SemVer.parseFromText((String)TypeScriptTypingsMapper.normalizeVersion(StringUtil.trimStart((String)range, (String)this.mySign.sign())));
        }

        public boolean isMatched(@NotNull SemVer semVer) {
            if (semVer == null) {
                TypeScriptRange.$$$reportNull$$$0(1);
            }
            return this.myRightVersion != null && this.mySign.isMatched(semVer, this.myRightVersion);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "semVer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$TypeScriptRange";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMatched";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum Sign {
        GT_EQ{

            @Override
            @NotNull
            String sign() {
                return ">=";
            }

            @Override
            boolean isMatched(@NotNull SemVer leftVersion, @NotNull SemVer rightVersion) {
                if (leftVersion == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (rightVersion == null) {
                    1.$$$reportNull$$$0(1);
                }
                return leftVersion.isGreaterOrEqualThan(rightVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "leftVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rightVersion";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$Sign$1";
                objectArray[2] = "isMatched";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        LT_EQ{

            @Override
            @NotNull
            String sign() {
                return "<=";
            }

            @Override
            boolean isMatched(@NotNull SemVer leftVersion, @NotNull SemVer rightVersion) {
                if (leftVersion == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (rightVersion == null) {
                    2.$$$reportNull$$$0(1);
                }
                return rightVersion.isGreaterOrEqualThan(leftVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "leftVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rightVersion";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$Sign$2";
                objectArray[2] = "isMatched";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        GT{

            @Override
            @NotNull
            String sign() {
                return ">";
            }

            @Override
            boolean isMatched(@NotNull SemVer leftVersion, @NotNull SemVer rightVersion) {
                if (leftVersion == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (rightVersion == null) {
                    3.$$$reportNull$$$0(1);
                }
                return !leftVersion.equals((Object)rightVersion) && leftVersion.isGreaterOrEqualThan(rightVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "leftVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rightVersion";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$Sign$3";
                objectArray[2] = "isMatched";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        LT{

            @Override
            @NotNull
            String sign() {
                return "<";
            }

            @Override
            boolean isMatched(@NotNull SemVer leftVersion, @NotNull SemVer rightVersion) {
                if (leftVersion == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (rightVersion == null) {
                    4.$$$reportNull$$$0(1);
                }
                return !leftVersion.equals((Object)rightVersion) && rightVersion.isGreaterOrEqualThan(leftVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "leftVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rightVersion";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$Sign$4";
                objectArray[2] = "isMatched";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        EQ{

            @Override
            @NotNull
            String sign() {
                return "=";
            }

            @Override
            boolean isMatched(@NotNull SemVer leftVersion, @NotNull SemVer rightVersion) {
                if (leftVersion == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (rightVersion == null) {
                    5.$$$reportNull$$$0(1);
                }
                return leftVersion.equals((Object)rightVersion);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "leftVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rightVersion";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/typescript/modules/TypeScriptTypingsMapper$Sign$5";
                objectArray[2] = "isMatched";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        @NotNull
        abstract String sign();

        abstract boolean isMatched(@NotNull SemVer var1, @NotNull SemVer var2);
    }
}

