/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.frameworks.modules.JSDefaultFileReferenceCompletionFilter;
import com.intellij.lang.javascript.frameworks.modules.JSModuleFileReferenceSet;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.typescript.library.download.TypeScriptDefinitionFilesDirectory;
import com.intellij.lang.typescript.modules.PathMappingReferenceContributorBase;
import com.intellij.lang.typescript.modules.TypeScriptFileModuleReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptModuleFileReferenceSet
extends FileReferenceSet {
    @Nullable
    protected final TypeScriptConfig myConfigForFile;

    @NotNull
    static Condition<PsiFileSystemItem> createFileFilter(@Nullable PsiElement host, @Nullable TypeScriptConfig config2) {
        if (host == null || !host.isValid()) {
            Condition condition = Conditions.alwaysTrue();
            if (condition == null) {
                TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(0);
            }
            return condition;
        }
        if (host instanceof ES6ImportDeclaration && ((ES6ImportDeclaration)host).getImportModuleText() != null) {
            return new JSDefaultFileReferenceCompletionFilter(host);
        }
        PsiFile file2 = host.getContainingFile().getOriginalFile();
        HashSet<String> extensionsWithoutDot = new HashSet<String>();
        if (config2 == null) {
            extensionsWithoutDot.addAll(TypeScriptImportsResolverProvider.getAllFileExtensionsWithoutDot());
        } else {
            TypeScriptImportsResolverProvider.addFileExtensions(extensionsWithoutDot, config2.getImportResolver().getExtensionsWithDot(), true);
            if (config2.resolveJsonModule()) {
                extensionsWithoutDot.add("json");
            }
        }
        Collection<String> patterns = TypeScriptModuleFileReferenceSet.getAcceptablePatterns(host);
        return new TypeScriptFileReferenceCompletionFilter(file2, extensionsWithoutDot, patterns);
    }

    @NotNull
    private static Collection<String> getAcceptablePatterns(@Nullable PsiElement host) {
        if (host == null || DumbService.isDumb((Project)host.getProject())) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(1);
            }
            return set;
        }
        PsiFile file2 = host.getContainingFile();
        if (file2 == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(2);
            }
            return set;
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)file2, () -> {
            Collection<TypeScriptModule> patternExternalModules = TypeScriptUtil.getAllPatternExternalModules(file2.getProject(), (PsiElement)file2);
            SmartList patterns = new SmartList();
            for (TypeScriptModule module : patternExternalModules) {
                String pattern;
                String text = module.getExternalModuleText();
                if (text == null || (pattern = JSStringUtil.unquoteAndUnescapeString(text)).length() <= 1 || !pattern.startsWith("*")) continue;
                patterns.add((Object)StringUtil.trimStart((String)pattern, (String)"*"));
            }
            return CachedValueProvider.Result.create((Object)patterns, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (collection == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public TypeScriptModuleFileReferenceSet(@NotNull String reference, @Nullable TypeScriptConfig configForFile, @NotNull PsiElement element, int startInElement, @Nullable PsiReferenceProvider provider, FileType @Nullable [] suitableFileTypes) {
        if (reference == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(4);
        }
        if (element == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(5);
        }
        super(reference, element, startInElement, provider, false, false, suitableFileTypes);
        this.myConfigForFile = configForFile;
    }

    protected boolean useIncludingFileAsContext() {
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        PsiElement host = this.getElement();
        String requiredModuleName = this.getPathString();
        boolean isRelative = JSModuleFileReferenceSet.isRelative(requiredModuleName);
        Project project = host.getProject();
        PsiFile file2 = host.getContainingFile().getOriginalFile();
        LinkedHashSet<PsiFileSystemItem> altResolveModules = new LinkedHashSet<PsiFileSystemItem>();
        if (!isRelative) {
            TypeScriptModuleFileReferenceSet.fillConfigRootContexts(this.myConfigForFile, file2, altResolveModules);
            JSModuleFileReferenceSet.addNodeModulesDirContexts(project, host, altResolveModules, this, true);
            TypeScriptModuleFileReferenceSet.addTypeNodeModules(this.myConfigForFile, host, altResolveModules);
            TypeScriptModuleFileReferenceSet.addGlobalTypesContexts(altResolveModules, file2);
            if (TypeScriptModuleFileReferenceSet.addParentPathContexts(file2, requiredModuleName, altResolveModules)) {
                LinkedHashSet<PsiFileSystemItem> linkedHashSet = altResolveModules;
                if (linkedHashSet == null) {
                    TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(6);
                }
                return linkedHashSet;
            }
            altResolveModules.addAll(super.computeDefaultContexts());
        } else {
            altResolveModules.addAll(this.getParentDirectoryContext());
        }
        LinkedHashSet<PsiFileSystemItem> linkedHashSet = altResolveModules;
        if (linkedHashSet == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    private static void addGlobalTypesContexts(@NotNull Collection<PsiFileSystemItem> modules, @NotNull PsiFile file2) {
        PsiDirectory psiDirectory;
        VirtualFile directory;
        if (modules == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(9);
        }
        if ((directory = TypeScriptDefinitionFilesDirectory.getGlobalTypesDirectory()) == null) {
            return;
        }
        VirtualFile currentFile = file2.getVirtualFile();
        if (VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)currentFile, (boolean)true) && (psiDirectory = file2.getManager().findDirectory(directory)) != null) {
            modules.add((PsiFileSystemItem)psiDirectory);
        }
    }

    public static boolean addParentPathContexts(@NotNull PsiFile file2, @NotNull String refPath, @NotNull Collection<? super PsiFileSystemItem> contexts) {
        VirtualFile path;
        if (file2 == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(10);
        }
        if (refPath == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(11);
        }
        if (contexts == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(12);
        }
        if ((path = TypeScriptUtil.findFileByReferencePath(file2, refPath)) != null) {
            String s = refPath.replace('/', '\\');
            for (int i = StringUtil.countChars((CharSequence)s, (char)'\\'); i > 0; --i) {
                path = path.getParent();
            }
            PsiDirectory directory = file2.getManager().findDirectory(path.getParent());
            if (directory != null) {
                contexts.add((PsiFileSystemItem)directory);
                return true;
            }
        }
        return false;
    }

    public static void fillConfigRootContexts(@Nullable TypeScriptConfig config2, @NotNull PsiFile file2, @NotNull Collection<PsiFileSystemItem> altResolveModules) {
        if (file2 == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(13);
        }
        if (altResolveModules == null) {
            TypeScriptModuleFileReferenceSet.$$$reportNull$$$0(14);
        }
        if (config2 == null) {
            return;
        }
        VirtualFile url = config2.getBaseUrl();
        if (url != null) {
            PsiDirectory urlPsiFile = file2.getManager().findDirectory(url);
            if (urlPsiFile != null) {
                altResolveModules.add((PsiFileSystemItem)urlPsiFile);
            }
            Collection<JSModulePathSubstitution> substitutions = config2.getPaths();
            for (JSModulePathSubstitution path : substitutions) {
                if (!"*".equals(path.getMappedName())) continue;
                Collection<String> mappings = JSPathMappingsUtil.getMappings(path, "", false);
                List<String> paths = PathMappingReferenceContributorBase.getExactReferencePaths(url, "", mappings);
                VirtualFile vFile = file2.getVirtualFile();
                if (vFile == null) {
                    return;
                }
                VirtualFileSystem system = vFile.getFileSystem();
                altResolveModules.addAll(StreamEx.of(paths).map(el -> system.findFileByPath(el)).nonNull().map(el -> file2.getManager().findDirectory(el)).toList());
            }
        }
    }

    public FileReference createFileReference(TextRange textRange, int i, String text) {
        return new TypeScriptFileModuleReference(text, this.myConfigForFile, i, textRange, this, JSModuleBaseReference.ModuleTypes.DEFAULT);
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return TypeScriptModuleFileReferenceSet.createFileFilter(this.getElement(), this.myConfigForFile);
    }

    public static void addTypeNodeModules(@Nullable TypeScriptConfig configForPsiFile, PsiElement context, Collection<PsiFileSystemItem> altResolveModules) {
        VirtualFile toSearchDir = null;
        if (configForPsiFile != null) {
            toSearchDir = configForPsiFile.getConfigDirectory();
        }
        if (toSearchDir != null) {
            VirtualFile nodeModulesFile = toSearchDir.findChild("node_modules");
            if (nodeModulesFile == null) {
                nodeModulesFile = NodeModuleUtil.findUpClosestNodeModulesResolveRoot(toSearchDir);
            }
            JSModuleFileReferenceSet.addTypesForNodeModulesDir(context, altResolveModules, nodeModulesFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/modules/TypeScriptModuleFileReferenceSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contexts";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "altResolveModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFilter";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptablePatterns";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptModuleFileReferenceSet";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addGlobalTypesContexts";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addParentPathContexts";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillConfigRootContexts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class TypeScriptFileReferenceCompletionFilter
    extends JSDefaultFileReferenceCompletionFilter {
        private final Collection<String> myExtensionsWithoutDot;
        private final Collection<String> myPatterns;

        private TypeScriptFileReferenceCompletionFilter(@Nullable PsiFile file2, Collection<String> extensionsWithoutDot, Collection<String> patterns) {
            super((PsiElement)file2);
            this.myExtensionsWithoutDot = extensionsWithoutDot;
            this.myPatterns = patterns;
        }

        @Override
        protected boolean shouldExcludeTypes() {
            return false;
        }

        @Override
        public boolean value(PsiFileSystemItem item) {
            if (!super.value(item)) {
                return false;
            }
            if (!(item instanceof PsiFile)) {
                return true;
            }
            PsiFile psiFile = (PsiFile)item;
            String name = psiFile.getName();
            String extension = StringUtil.toLowerCase((String)FileUtilRt.getExtension((String)name));
            if (this.myExtensionsWithoutDot.contains(extension)) {
                return true;
            }
            for (String pattern : this.myPatterns) {
                if (!name.endsWith(pattern)) continue;
                return true;
            }
            return false;
        }
    }
}

