/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.intentions;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAddFileToConfigFix
extends FixAndIntentionAction
implements HighPriorityAction {
    public static final Logger LOGGER = Logger.getInstance(TypeScriptAddFileToConfigFix.class);
    @NotNull
    private final String myFileName;

    public TypeScriptAddFileToConfigFix(@NotNull JSElement jsElement, @NotNull PsiElement element) {
        if (jsElement == null) {
            TypeScriptAddFileToConfigFix.$$$reportNull$$$0(0);
        }
        if (element == null) {
            TypeScriptAddFileToConfigFix.$$$reportNull$$$0(1);
        }
        this.registerElementRefForFix((PsiElement)jsElement, null);
        PsiFile file2 = element.getContainingFile();
        this.myFileName = file2.getName();
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile file2) {
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        TypeScriptConfig include = TypeScriptConfigService.Provider.get(project).getPreferableConfig(virtualFile);
        return include != null && !include.isDirectoryBased();
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Override
    protected void applyFix(Project project, PsiElement el, @NotNull PsiFile file2, @Nullable Editor editor) {
        if (file2 == null) {
            TypeScriptAddFileToConfigFix.$$$reportNull$$$0(2);
        }
        if (!(el instanceof PsiPolyVariantReference)) {
            return;
        }
        Object[] results = ((PsiPolyVariantReference)el).multiResolve(false);
        if (results.length == 0) {
            return;
        }
        ResolveResult item = (ResolveResult)ArrayUtil.getFirstElement((Object[])results);
        if (!(item instanceof JSResolveResult)) {
            return;
        }
        JSResolveResult jsResolveResult = (JSResolveResult)item;
        PsiElement element = jsResolveResult.getElement();
        VirtualFile virtualFile = file2.getVirtualFile();
        TypeScriptConfig include = TypeScriptConfigService.Provider.get(project).getPreferableConfig(virtualFile);
        if (include == null) {
            return;
        }
        assert (element != null);
        PsiFile psiFileForResolvedElement = element.getContainingFile();
        VirtualFile virtualFileToAdd = psiFileForResolvedElement.getVirtualFile();
        if (!TypeScriptConfigUtil.addVirtualFileToConfigFiles(project, virtualFileToAdd, include)) {
            LOGGER.error("Cannot add reference to tsconfig.json \n" + include.toString());
        }
    }

    @IntentionName
    @NotNull
    public String getName() {
        String string = TypeScriptAddFileToConfigFix.getMessageText(this.myFileName);
        if (string == null) {
            TypeScriptAddFileToConfigFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @IntentionName
    public static String getMessageText(@NlsSafe String fileName) {
        return JavaScriptBundle.message((String)"intention.name.add.file.to.tsconfig", (Object[])new Object[]{fileName});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/intentions/TypeScriptAddFileToConfigFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/intentions/TypeScriptAddFileToConfigFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

