/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.imports;

import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.imports.FlowImportOptimizer;
import com.intellij.lang.javascript.imports.JSModuleImportOptimizerBase;
import com.intellij.lang.javascript.imports.JSOptimizeImportUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.imports.ES6UnusedImportsHelper;
import com.intellij.lang.typescript.psi.TypeScriptEntityName;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptImportOptimizer
extends JSModuleImportOptimizerBase {
    public static final TokenSet TYPESCRIPT_IMPORT = TokenSet.create((IElementType[])new IElementType[]{TypeScriptElementTypes.IMPORT_STATEMENT});

    public boolean supports(@NotNull PsiFile file2) {
        if (file2 == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(0);
        }
        return file2 instanceof JSFile && DialectDetector.isTypeScript((PsiElement)file2);
    }

    @Override
    @NotNull
    public Collection<JSModuleImportOptimizerBase.UnusedModuleInfo> getModulesInfo(@NotNull PsiElement scope) {
        if (scope == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(1);
        }
        SmartList result2 = new SmartList();
        FlowImportOptimizer es6Optimizer = new FlowImportOptimizer();
        Collection<PsiElement> modules = TypeScriptImportOptimizer.getAllModules(scope);
        for (PsiElement module : modules) {
            JSModuleImportOptimizerBase.UnusedModuleInfo info;
            if (ES6PsiUtil.isExternalModule(module)) {
                result2.addAll(es6Optimizer.getModulesInfo(module));
            }
            if ((info = TypeScriptImportOptimizer.getInfo(scope, module)) == null) continue;
            result2.add(info);
        }
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @NotNull
    private static Collection<PsiElement> getAllModules(@NotNull PsiElement scope) {
        if (scope == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(3);
        }
        if (!(scope instanceof JSElement)) {
            List<PsiElement> list2 = Collections.emptyList();
            if (list2 == null) {
                TypeScriptImportOptimizer.$$$reportNull$$$0(4);
            }
            return list2;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        result2.add(scope);
        ArrayDeque<JSElement> toProcess = new ArrayDeque<JSElement>();
        toProcess.add((JSElement)scope);
        while (!toProcess.isEmpty()) {
            PsiElement[] modules;
            JSElement current = (JSElement)toProcess.pop();
            for (PsiElement module : modules = TypeScriptImportOptimizer.getDirectChildModules(current)) {
                if (!(module instanceof TypeScriptModule)) continue;
                result2.add(module);
                toProcess.add((JSElement)module);
            }
        }
        ArrayList<PsiElement> arrayList = result2;
        if (arrayList == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static PsiElement[] getDirectChildModules(@NotNull JSElement context) {
        if (context == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(6);
        }
        return JSStubBasedPsiTreeUtil.getChildrenByType(context, JSExtendedLanguagesTokenSetProvider.MODULES);
    }

    @Nullable
    private static JSModuleImportOptimizerBase.UnusedModuleInfo getInfo(@NotNull PsiElement scope, @NotNull PsiElement module) {
        List<TypeScriptImportStatement> imports;
        if (scope == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(7);
        }
        if (module == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(8);
        }
        if ((imports = TypeScriptImportOptimizer.getImports((JSElement)module)).isEmpty()) {
            return null;
        }
        Set<TypeScriptImportStatement> unusedImports = TypeScriptImportOptimizer.getUnusedImports(imports);
        final List<String> texts = TypeScriptImportOptimizer.getNewImportTexts(scope, imports, unusedImports);
        return new JSModuleImportOptimizerBase.UnusedModuleInfo(){

            @Override
            @NotNull
            public List<String> getImportTexts() {
                List list2 = texts;
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @Nullable
            public PsiElement getAnchor() {
                return (PsiElement)ContainerUtil.getFirstItem((List)imports);
            }

            @Override
            @NotNull
            public List<PsiElement> getOldImports() {
                return new ArrayList<PsiElement>(imports);
            }

            @Override
            public List<PsiElement> getImportsForScope(@NotNull PsiElement scope) {
                if (scope == null) {
                    1.$$$reportNull$$$0(1);
                }
                return scope instanceof JSElement ? new ArrayList<TypeScriptImportStatement>(TypeScriptImportOptimizer.getImports((JSElement)scope)) : Collections.emptyList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/imports/TypeScriptImportOptimizer$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getImportTexts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/imports/TypeScriptImportOptimizer$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "getImportsForScope";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static List<String> getNewImportTexts(@NotNull PsiElement scope, @NotNull List<TypeScriptImportStatement> imports, @NotNull Set<TypeScriptImportStatement> unusedImports) {
        if (scope == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(9);
        }
        if (imports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(10);
        }
        if (unusedImports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(11);
        }
        ArrayList<String> importsResult = new ArrayList<String>();
        ArrayList<TypeScriptImportStatement> importsForProcessing = new ArrayList<TypeScriptImportStatement>(imports);
        TypeScriptImportOptimizer.sortImports(scope, importsForProcessing);
        String semicolon = JSCodeStyleSettings.getSemicolon(scope);
        Document document2 = PsiDocumentManager.getInstance((Project)scope.getProject()).getDocument(scope.getContainingFile());
        for (TypeScriptImportStatement statement : importsForProcessing) {
            if (unusedImports.contains(statement) && !ES6UnusedImportsHelper.isTypeScriptSuppressedUnused(statement)) continue;
            List<PsiElement> prevComments = JSOptimizeImportUtil.getPrevComments(document2, (PsiElement)statement);
            SmartList current = new SmartList();
            current.addAll(JSOptimizeImportUtil.getPrevCommentsAsStrings(prevComments));
            current.add(TypeScriptImportOptimizer.getImportText(document2, statement, semicolon));
            JSOptimizeImportUtil.fillImportsWithNewLines(importsResult, (PsiElement)statement, (List<String>)current);
        }
        return importsResult;
    }

    private static String getImportText(@Nullable Document document2, @NotNull TypeScriptImportStatement statement, @NotNull String semicolon) {
        if (statement == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(12);
        }
        if (semicolon == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(13);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(StringUtil.trimEnd((String)StringUtil.trim((String)statement.getText()), (String)";"));
        builder.append(semicolon);
        JSOptimizeImportUtil.addSameLineComments(document2, (PsiElement)statement, builder);
        return builder.toString();
    }

    private static void sortImports(@NotNull PsiElement scope, @NotNull List<TypeScriptImportStatement> imports) {
        if (scope == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(14);
        }
        if (imports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(15);
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(scope);
        Comparator<String> moduleComparator = ES6ImportPsiUtil.getStringImportFromComparator();
        Comparator<String> memberComparator = ES6ImportPsiUtil.getStringImportMemberComparator(scope);
        ContainerUtil.sort(imports, (o1, o2) -> {
            TypeScriptEntityName internalModuleReference1 = o1.getInternalModuleReference();
            TypeScriptEntityName internalModuleReference2 = o2.getInternalModuleReference();
            TypeScriptExternalModuleReference externalModuleReference1 = o1.getExternalModuleReference();
            TypeScriptExternalModuleReference externalModuleReference2 = o2.getExternalModuleReference();
            if (externalModuleReference1 != null && externalModuleReference2 != null) {
                if (!settings.IMPORT_SORT_MODULE_NAME) {
                    return 0;
                }
                String name1 = TypeScriptImportOptimizer.getExternalModuleReferenceText(externalModuleReference1);
                String name2 = TypeScriptImportOptimizer.getExternalModuleReferenceText(externalModuleReference2);
                return moduleComparator.compare(name1, name2);
            }
            if (internalModuleReference1 != null && internalModuleReference2 != null) {
                String text2;
                String text1 = StringUtil.trim((String)StringUtil.notNullize((String)internalModuleReference1.getText()));
                if (text1.equals(text2 = StringUtil.trim((String)StringUtil.notNullize((String)internalModuleReference2.getText())))) {
                    return memberComparator.compare(o1.getName(), o2.getName());
                }
                if (!settings.IMPORT_SORT_MODULE_NAME) {
                    return 0;
                }
                return moduleComparator.compare(text1, text2);
            }
            return internalModuleReference1 == null ? -1 : 1;
        });
    }

    @NotNull
    private static String getExternalModuleReferenceText(@Nullable TypeScriptExternalModuleReference externalModuleReference1) {
        String string = externalModuleReference1 == null ? "" : StringUtil.unquoteString((String)StringUtil.notNullize((String)externalModuleReference1.getReferenceText()));
        if (string == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static List<TypeScriptImportStatement> getImports(@NotNull JSElement module) {
        if (module == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(17);
        }
        return Arrays.stream(JSStubBasedPsiTreeUtil.getChildrenByType(module, TYPESCRIPT_IMPORT)).filter(el -> el instanceof TypeScriptImportStatement).map(el -> (TypeScriptImportStatement)el).collect(Collectors.toList());
    }

    private static Set<TypeScriptImportStatement> getUnusedImports(@NotNull Collection<TypeScriptImportStatement> imports) {
        if (imports == null) {
            TypeScriptImportOptimizer.$$$reportNull$$$0(18);
        }
        HashSet<TypeScriptImportStatement> result2 = new HashSet<TypeScriptImportStatement>();
        for (PsiElement psiElement : imports) {
            if (!(psiElement instanceof TypeScriptImportStatement) || !ES6UnusedImportsHelper.isUnusedTypeScriptImport((TypeScriptImportStatement)psiElement)) continue;
            result2.add((TypeScriptImportStatement)psiElement);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/imports/TypeScriptImportOptimizer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imports";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unusedImports";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semicolon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/imports/TypeScriptImportOptimizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllModules";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalModuleReferenceText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getModulesInfo";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllModules";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDirectChildModules";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNewImportTexts";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getImportText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "sortImports";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getImports";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getUnusedImports";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

