/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.completion;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.ES6CompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSCompletionKeyword;
import com.intellij.lang.javascript.completion.JSCompletionUtil;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClassExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptMappedTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTemplateLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompletionKeywordsContributor
extends ES6CompletionKeywordsContributor {
    public static final JSCompletionKeyword[] PRIMITIVE_TYPES = new JSCompletionKeyword[]{JSCompletionKeyword.STRING, JSCompletionKeyword.BOOLEAN, JSCompletionKeyword.NUMBER, JSCompletionKeyword.BIGINT, JSCompletionKeyword.VOID, JSCompletionKeyword.NEVER, JSCompletionKeyword.SYMBOL, JSCompletionKeyword.UNDEFINED, JSCompletionKeyword.NULL, JSCompletionKeyword.OBJECT, JSCompletionKeyword.ANY, JSCompletionKeyword.UNKNOWN};
    private static final JSCompletionKeyword[] LOW_PRIORITY_TYPE_KEYWORDS = new JSCompletionKeyword[]{JSCompletionKeyword.IMPORT_WITH_BRACES};
    public static final JSCompletionKeyword[] TYPE_PREFIXES = new JSCompletionKeyword[]{JSCompletionKeyword.TYPEOF, JSCompletionKeyword.KEYOF, JSCompletionKeyword.READONLY};
    private static final JSCompletionKeyword[] PRIMITIVE_TYPES_FOR_INDEXER = new JSCompletionKeyword[]{JSCompletionKeyword.STRING, JSCompletionKeyword.NUMBER};
    private static final JSCompletionKeyword[] TYPE_PREFIXES_FOR_INDEXER = JSCompletionKeyword.EMPTY_ARRAY;

    private static boolean isPrecededByAccessModifier(ASTNode prev, IElementType elementType) {
        if (TypeScriptCompletionKeywordsContributor.isPrivatePublicProtected(elementType)) {
            return true;
        }
        if (elementType != JSStubElementTypes.ATTRIBUTE_LIST) {
            return false;
        }
        ASTNode lastChildNode = prev.getLastChildNode();
        if (lastChildNode == null) {
            return false;
        }
        return TypeScriptCompletionKeywordsContributor.isPrivatePublicProtected(lastChildNode.getElementType());
    }

    private static boolean isPrivatePublicProtected(IElementType elementType) {
        return elementType == JSTokenTypes.PRIVATE_KEYWORD || elementType == JSTokenTypes.PROTECTED_KEYWORD || elementType == JSTokenTypes.PUBLIC_KEYWORD;
    }

    @Override
    public boolean process(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context) {
        PsiElement grandParentParent;
        ASTNode currentNode;
        ASTNode prev;
        JSFunction function2;
        PsiElement parent;
        if (consumer == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(1);
        }
        if (!TypeScriptCompletionKeywordsContributor.addInterfaceKeywords(consumer, parent = context.getParent())) {
            return false;
        }
        if (!super.process(consumer, context)) {
            return false;
        }
        boolean isTsIndexer = TypeScriptPsiUtil.isTsIndexerType(parent);
        boolean isAmbientContext = TypeScriptPsiUtil.isAmbientContext(context);
        if (parent instanceof TypeScriptImportStatement) {
            return false;
        }
        if (parent instanceof TypeScriptTemplateLiteralType && PsiUtilCore.getElementType((PsiElement)context) == JSTokenTypes.STRING_TEMPLATE_PART) {
            return false;
        }
        if (TypeScriptCompletionKeywordsContributor.addPredefinedTypesInTypeContext(parent, consumer, isTsIndexer ? PRIMITIVE_TYPES_FOR_INDEXER : PRIMITIVE_TYPES, isTsIndexer ? TYPE_PREFIXES_FOR_INDEXER : TYPE_PREFIXES, isTsIndexer ? JSCompletionKeyword.EMPTY_ARRAY : LOW_PRIORITY_TYPE_KEYWORDS)) {
            return false;
        }
        if (parent instanceof JSParameter && (function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)parent, JSFunction.class)) != null && function2.isConstructor() && (prev = TreeUtil.prevLeaf((ASTNode)(currentNode = context.getNode()))) != null) {
            IElementType type;
            ASTNode newPrev;
            if (JSTokenTypes.COMMENTS_AND_WHITESPACES.contains(prev.getElementType()) && (newPrev = TreeUtil.skipElementsBack((ASTNode)prev, (TokenSet)JSTokenTypes.COMMENTS_AND_WHITESPACES)) != null) {
                prev = newPrev;
            }
            if ((type = prev.getElementType()) == JSTokenTypes.COMMA || type == JSTokenTypes.LPAR) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.PRIVATE, JSCompletionKeyword.PUBLIC, JSCompletionKeyword.PROTECTED, JSCompletionKeyword.READONLY);
                return false;
            }
            if (TypeScriptCompletionKeywordsContributor.isPrecededByAccessModifier(prev, type)) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.READONLY);
                return false;
            }
        }
        PsiElement grandParent = parent.getParent();
        boolean grandParentParentIsModule = false;
        if (grandParent instanceof JSExpressionStatement || grandParent instanceof JSAttributeList) {
            if (grandParent instanceof JSExpressionStatement) {
                TypeScriptClassExpression classExpression;
                PsiElement prev2;
                if (TypeScriptCompletionKeywordsContributor.shouldAppendExtendsForGenerics(parent)) {
                    consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
                    return false;
                }
                grandParentParent = grandParent.getParent();
                if (grandParentParent instanceof PsiFile || grandParentParent instanceof TypeScriptModule) {
                    grandParentParentIsModule = true;
                    consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, JSCompletionKeyword.CLASS, JSCompletionKeyword.ENUM, JSCompletionKeyword.INTERFACE, JSCompletionKeyword.DECLARE, JSCompletionKeyword.ABSTRACT, JSCompletionKeyword.ASYNC, JSCompletionKeyword.EXPORT, JSCompletionKeyword.TYPE, JSCompletionKeyword.MODULE, JSCompletionKeyword.NAMESPACE, JSCompletionKeyword.IMPORT);
                }
                if ((prev2 = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent)) instanceof TypeScriptClass && prev2.getNode().findChildByType(JSTokenTypes.LBRACE) == null || prev2 instanceof TypeScriptInterface && ((TypeScriptInterface)prev2).getBody() == null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
                    if (prev2 instanceof TypeScriptClass) {
                        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.IMPLEMENTS);
                    }
                    return false;
                }
                TypeScriptType precedingTypeScriptType = TypeScriptCompletionKeywordsContributor.findPossiblePrecedingType(prev2, TypeScriptType.class);
                if (precedingTypeScriptType != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
                    if (precedingTypeScriptType instanceof TypeScriptMappedType && TypeScriptCompletionKeywordsContributor.skipIfErrorElement(precedingTypeScriptType.getLastChild()) instanceof TypeScriptMappedTypeParameter) {
                        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.AS);
                    }
                }
                if ((classExpression = TypeScriptCompletionKeywordsContributor.findPossiblePrecedingType(prev2, TypeScriptClassExpression.class)) != null && classExpression.getLastChild() instanceof PsiErrorElement) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.IMPLEMENTS);
                }
            }
            if (grandParentParentIsModule) {
                consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, JSCompletionKeyword.FUNCTION, JSCompletionKeyword.LET, JSCompletionKeyword.CONST, JSCompletionKeyword.VAR);
            } else if (isAmbientContext) {
                consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, JSCompletionKeyword.PUBLIC, JSCompletionKeyword.PRIVATE, JSCompletionKeyword.PROTECTED, JSCompletionKeyword.FUNCTION, JSCompletionKeyword.LET, JSCompletionKeyword.CONST, JSCompletionKeyword.VAR);
            }
            return !isAmbientContext;
        }
        if (grandParent instanceof TypeScriptImportStatement && parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() == null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, JSCompletionKeyword.REQUIRE);
            return false;
        }
        if (grandParent instanceof JSVarStatement) {
            grandParentParent = grandParent.getParent();
            if (grandParentParent instanceof TypeScriptClass) {
                if (TypeScriptCompletionKeywordsContributor.isIncompleteTypeParameter(grandParent)) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
                    return false;
                }
                if (!TypeScriptCompletionKeywordsContributor.checkClassMemberPrevSibling(grandParent)) {
                    return false;
                }
                TypeScriptCompletionKeywordsContributor.appendKeywordsForClassMember(consumer, (JSVarStatement)grandParent, (TypeScriptClass)grandParentParent);
                return false;
            }
            if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property) {
                return false;
            }
            if (TypeScriptCompletionKeywordsContributor.shouldAppendExtendsForGenerics(grandParent)) {
                consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
            }
        } else {
            if (parent instanceof JSReferenceExpression && grandParent instanceof ES6Property) {
                return false;
            }
            if (TypeScriptCompletionKeywordsContributor.shouldAppendExtendsForGenerics(grandParent)) {
                consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
            }
        }
        return true;
    }

    public static boolean shouldAppendExtendsForGenerics(@Nullable PsiElement grandParent) {
        if (grandParent instanceof TypeScriptTypeParameterList) {
            return true;
        }
        if (grandParent instanceof JSDefinitionExpression) {
            grandParent = grandParent.getParent();
        }
        if (!(grandParent instanceof JSBinaryExpression) && !(grandParent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement prevUnparsedContext = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)PsiTreeUtil.prevLeaf((PsiElement)grandParent));
        if (prevUnparsedContext == null) {
            return false;
        }
        PsiElement lastLeafChild = JSPsiImplUtils.getLastLeafChild(prevUnparsedContext);
        if (lastLeafChild instanceof PsiErrorElement) {
            lastLeafChild = lastLeafChild.getPrevSibling();
        }
        return lastLeafChild instanceof TypeScriptTypeParameter;
    }

    public static boolean addInterfaceKeywords(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        PsiElement parentParent;
        if (consumer == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(2);
        }
        if (parent instanceof TypeScriptPropertySignature && !JSCompletionUtil.isUnparsedGenericTail(parent) && (parentParent = parent.getParent()) instanceof TypeScriptObjectType) {
            JSAttributeList list2 = ((TypeScriptPropertySignature)parent).getAttributeList();
            if (list2 == null || !list2.hasModifier(JSAttributeList.ModifierType.READONLY)) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.READONLY, JSCompletionKeyword.NEW);
            }
            return false;
        }
        return true;
    }

    private static boolean isIncompleteTypeParameter(PsiElement pos) {
        PsiElement prevSibling = PsiTreeUtil.skipWhitespacesBackward((PsiElement)pos);
        if (!(prevSibling instanceof TypeScriptFunction)) {
            return false;
        }
        PsiElement prevLast = prevSibling.getLastChild();
        if (!(prevLast instanceof PsiErrorElement)) {
            return false;
        }
        PsiElement backward = PsiTreeUtil.skipWhitespacesBackward((PsiElement)prevLast);
        return backward instanceof TypeScriptTypeParameter;
    }

    @Nullable
    private static <T> T findPossiblePrecedingType(@Nullable PsiElement prev, Class<T> clazz) {
        PsiElement lastChild;
        prev = prev == null ? null : PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prev.getNextSibling());
        PsiElement psiElement = lastChild = prev == null ? null : TypeScriptCompletionKeywordsContributor.skipIfErrorElement(prev.getLastChild());
        while (lastChild != null && !clazz.isInstance(lastChild)) {
            lastChild = TypeScriptCompletionKeywordsContributor.skipIfErrorElement(lastChild.getLastChild());
        }
        if (lastChild instanceof TypeScriptObjectType && lastChild.getParent() instanceof TypeScriptInterface) {
            return null;
        }
        return (T)ObjectUtils.tryCast((Object)lastChild, clazz);
    }

    @Nullable
    private static PsiElement skipIfErrorElement(@Nullable PsiElement lastChild) {
        if (lastChild instanceof PsiErrorElement) {
            return lastChild.getPrevSibling();
        }
        return lastChild;
    }

    private static void appendKeywordsForClassMember(@NotNull KeywordCompletionConsumer consumer, @NotNull JSVarStatement grandParent, @NotNull TypeScriptClass grandParentParent) {
        JSAttributeList.AccessType accessType;
        if (consumer == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(3);
        }
        if (grandParent == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(4);
        }
        if (grandParentParent == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(5);
        }
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.READONLY, JSCompletionKeyword.ASYNC, JSCompletionKeyword.GET, JSCompletionKeyword.SET);
        JSAttributeList attributeList = grandParent.getAttributeList();
        if (!JSPsiImplUtils.hasModifier(attributeList, JSAttributeList.ModifierType.STATIC)) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.STATIC);
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, JSCodeStyleSettings.getCommonSettings((PsiElement)grandParent).SPACE_BEFORE_METHOD_PARENTHESES, JSCompletionKeyword.CONSTRUCTOR);
        }
        JSAttributeList.AccessType accessType2 = accessType = attributeList == null ? null : attributeList.getExplicitAccessType();
        if (accessType == null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.PUBLIC, JSCompletionKeyword.PRIVATE, JSCompletionKeyword.PROTECTED);
        }
        if (JSPsiImplUtils.hasModifier((JSAttributeListOwner)grandParentParent, JSAttributeList.ModifierType.ABSTRACT)) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.ABSTRACT);
        }
        consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, true, JSCompletionKeyword.DECLARE);
    }

    public static boolean addPredefinedTypesInTypeContext(PsiElement parent, KeywordCompletionConsumer consumer, JSCompletionKeyword @NotNull [] types2, JSCompletionKeyword @NotNull [] typesWithSpaces, JSCompletionKeyword @NotNull [] lowPriorityKeyword) {
        if (types2 == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(6);
        }
        if (typesWithSpaces == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(7);
        }
        if (lowPriorityKeyword == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(8);
        }
        if (TypeScriptCompletionKeywordsContributor.isContextForTypeKeywords(parent)) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, types2);
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, typesWithSpaces);
            consumer.consume(JSLookupPriority.KEYWORDS_PRIORITY, false, lowPriorityKeyword);
            return true;
        }
        return false;
    }

    private static boolean isContextForTypeKeywords(@NotNull PsiElement expr) {
        if (expr == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(9);
        }
        if (expr instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)expr)) {
            return (PsiTreeUtil.getParentOfType((PsiElement)expr, JSReferenceList.class) == null || DialectDetector.isTypeScript(expr)) && ((JSReferenceExpression)expr).getQualifier() == null;
        }
        return JSCompletionUtil.isUnparsedGenericTail(expr);
    }

    public static boolean addPredefinedTypesInTypeContext(PsiElement parent, KeywordCompletionConsumer consumer, JSCompletionKeyword ... types2) {
        return TypeScriptCompletionKeywordsContributor.addPredefinedTypesInTypeContext(parent, consumer, types2, JSCompletionKeyword.EMPTY_ARRAY, JSCompletionKeyword.EMPTY_ARRAY);
    }

    @Override
    public void appendSpecificKeywords(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context, PsiElement grandParent) {
        if (consumer == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(10);
        }
        if (context == null) {
            TypeScriptCompletionKeywordsContributor.$$$reportNull$$$0(11);
        }
        super.appendSpecificKeywords(consumer, context, grandParent);
    }

    @Override
    protected void appendKeywordsAfterExport(KeywordCompletionConsumer consumer) {
        super.appendKeywordsAfterExport(consumer);
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.NAMESPACE, JSCompletionKeyword.MODULE, JSCompletionKeyword.ENUM, JSCompletionKeyword.TYPE, JSCompletionKeyword.INTERFACE, JSCompletionKeyword.ABSTRACT, JSCompletionKeyword.DECLARE);
    }

    @Override
    protected void appendKeywordsAfterImport(KeywordCompletionConsumer consumer) {
        super.appendKeywordsAfterImport(consumer);
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.TYPE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParentParent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesWithSpaces";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowPriorityKeyword";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/completion/TypeScriptCompletionKeywordsContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addInterfaceKeywords";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendKeywordsForClassMember";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addPredefinedTypesInTypeContext";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isContextForTypeKeywords";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpecificKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

