/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceRequest;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptChangeRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandSetRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandWithArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompositeRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenExternalProjectRequest;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadFileCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptReloadProjectsCommand;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class TypeScriptLanguageServiceCache
extends JSLanguageServiceDefaultCacheData {
    protected final Project myProject;
    protected final Map<VirtualFile, LastUpdateInfo> myUpdateFiles = new ConcurrentHashMap<VirtualFile, LastUpdateInfo>();
    protected final Set<VirtualFile> myOpenedFilesByEvent = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<VirtualFile> myExternalConfigs = Collections.newSetFromMap(new ConcurrentHashMap());

    public TypeScriptLanguageServiceCache(Project project) {
        this.myProject = project;
    }

    @Override
    @Nullable
    public final JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
        if (input == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(0);
        }
        if (input instanceof TypeScriptLanguageServiceUpdateCommand) {
            return (JSLanguageServiceObject)ReadAction.compute(() -> this.getUpdateFilesServiceObject((TypeScriptLanguageServiceUpdateCommand)input));
        }
        if (input instanceof TypeScriptCompositeCommand) {
            JSLanguageServiceCommand[] commands = ((TypeScriptCompositeCommand)input).getNestedCommands();
            ArrayList<JSLanguageServiceRequest> results = new ArrayList<JSLanguageServiceRequest>(commands.length);
            for (JSLanguageServiceCommand command : commands) {
                JSLanguageServiceObject serviceObject = this.updateCacheAndGetServiceObject(command);
                if (serviceObject == null) continue;
                if (serviceObject instanceof TypeScriptCommandSetRequest) {
                    ((TypeScriptCommandSetRequest)serviceObject).nestedRequests.forEach((nestedServiceObject, nestedCommand) -> {
                        JSLanguageServiceRequest request = new JSLanguageServiceRequest((JSLanguageServiceCommand)nestedCommand, (JSLanguageServiceObject)nestedServiceObject, -1L, -1);
                        results.add(request);
                    });
                    continue;
                }
                JSLanguageServiceRequest request = new JSLanguageServiceRequest(command, serviceObject, -1L, -1);
                results.add(request);
            }
            if (results.size() == 0) {
                return null;
            }
            return new TypeScriptCompositeRequest(results);
        }
        if (input instanceof JSLanguageServiceSimpleCommand) {
            VirtualFile file2;
            if (input instanceof TypeScriptOpenEditorCommand) {
                return (JSLanguageServiceObject)ReadAction.compute(() -> this.refreshAndGetOpenEditorCommand((JSLanguageServiceSimpleCommand)input));
            }
            if (input instanceof TypeScriptCloseEditorCommand) {
                return (JSLanguageServiceObject)ReadAction.compute(() -> this.refreshAndGetCloseEditorCommand((JSLanguageServiceSimpleCommand)input));
            }
            if (input instanceof TypeScriptReloadFileCommand && (this.myOpenedFilesByEvent.contains(file2 = ((TypeScriptReloadFileCommand)input).getFile()) || this.myUpdateFiles.containsKey(file2))) {
                return null;
            }
            return ((JSLanguageServiceSimpleCommand)input).toSerializableObject();
        }
        return null;
    }

    @Nullable
    public JSLanguageServiceObject refreshAndGetCloseEditorCommand(@NotNull JSLanguageServiceSimpleCommand input) {
        Set<VirtualFile> configs;
        VirtualFile configFile;
        String name;
        TypeScriptConfig config2;
        if (input == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(1);
        }
        TypeScriptCloseEditorCommand command = (TypeScriptCloseEditorCommand)input;
        VirtualFile virtualFile = command.getFile();
        this.myOpenedFilesByEvent.remove(virtualFile);
        if (this.myUpdateFiles.remove(virtualFile) == null) {
            return null;
        }
        if (TypeScriptConfigUtil.hasConfigsWithNonStandardName(this.myProject) && TypeScriptConfigUtil.isNonStandardName(config2 = this.getConfigForFile(virtualFile)) && this.myExternalConfigs.contains(config2.getConfigFile()) && (name = JSLanguageServiceUtil.normalizeNameAndPath(configFile = config2.getConfigFile())) != null && !(configs = this.getNonStandardConfigsForChangedAndOpenFiles()).contains(configFile)) {
            this.myExternalConfigs.remove(configFile);
            return new TypeScriptCommandSetRequest(ContainerUtil.newArrayList((Object[])new JSLanguageServiceSimpleCommand[]{new TypeScriptCloseExternalProjectRequest(name), input}));
        }
        return input.toSerializableObject();
    }

    @Nullable
    protected TypeScriptConfig getConfigForFile(VirtualFile virtualFile) {
        return TypeScriptConfigUtil.getConfigForFile(this.myProject, virtualFile);
    }

    @Nullable
    public JSLanguageServiceObject refreshAndGetOpenEditorCommand(@NotNull JSLanguageServiceSimpleCommand input) {
        VirtualFile configFile;
        String name;
        if (input == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(2);
        }
        TypeScriptOpenEditorCommand command = (TypeScriptOpenEditorCommand)input;
        VirtualFile file2 = command.getFile();
        this.myOpenedFilesByEvent.add(file2);
        if (this.myUpdateFiles.containsKey(file2)) {
            return null;
        }
        String path = JSLanguageServiceUtil.normalizeNameAndPath(file2);
        this.myUpdateFiles.put(file2, new LastUpdateInfo(path, command.getTimestamp(), command.getContentLength(), command.getLineCount(), command.getLastLineStartOffset()));
        if (!TypeScriptConfigUtil.hasConfigsWithNonStandardName(this.myProject)) {
            return input.toSerializableObject();
        }
        TypeScriptConfig config2 = this.getConfigForFile(file2);
        if (TypeScriptConfigUtil.isNonStandardName(config2) && !this.myExternalConfigs.contains(config2.getConfigFile()) && (name = JSLanguageServiceUtil.normalizeNameAndPath(configFile = config2.getConfigFile())) != null) {
            this.myExternalConfigs.add(configFile);
            return new TypeScriptCommandSetRequest(ContainerUtil.newArrayList((Object[])new JSLanguageServiceSimpleCommand[]{new TypeScriptOpenExternalProjectRequest(name), input}));
        }
        return input.toSerializableObject();
    }

    @Nullable
    private JSLanguageServiceObject getUpdateFilesServiceObject(@NotNull TypeScriptLanguageServiceUpdateCommand command) {
        if (command == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myProject.isDisposed()) {
            return null;
        }
        Map<VirtualFile, Long> currentChangedFiles = command.myChangedFilesToTimeStamp;
        Map<VirtualFile, Document> unsavedContents = command.myUnsavedFilesContent;
        Set<VirtualFile> filesToClose = this.getFilesToClose(currentChangedFiles);
        Collection<VirtualFile> filesToOpen = this.getFilesToOpen(currentChangedFiles);
        Collection<VirtualFile> changedFiles = this.getFilesToChange(currentChangedFiles, filesToOpen);
        HashMap toUpdateCache = new HashMap();
        List toOpen = ((StreamEx)StreamEx.of(filesToOpen).filter(el -> !filesToClose.contains(el) && unsavedContents.containsKey(el))).map(el -> {
            Document document2 = (Document)unsavedContents.get(el);
            Long timestampObject = (Long)currentChangedFiles.get(el);
            CharSequence text = this.getPreprocessedDocumentText((VirtualFile)el, document2);
            long timestamp = timestampObject == null ? -1L : timestampObject;
            LastUpdateInfo value = TypeScriptLanguageServiceCache.createLastUpdateInfo(el, text, timestamp);
            toUpdateCache.put(el, value);
            String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(this.myProject, el);
            return this.createOpenCommand((VirtualFile)el, value, text, projectFileName, timestamp);
        }).toList();
        List toChange = ((StreamEx)StreamEx.of(changedFiles).filter(el -> !filesToClose.contains(el))).map(el -> {
            LastUpdateInfo info = this.myUpdateFiles.get(el);
            Document document2 = (Document)unsavedContents.get(el);
            CharSequence text = this.getPreprocessedDocumentText((VirtualFile)el, document2);
            long newTimestamp = (Long)currentChangedFiles.get(el);
            LastUpdateInfo value = TypeScriptLanguageServiceCache.createLastUpdateInfo(el, text, newTimestamp);
            toUpdateCache.put(el, value);
            TypeScriptChangeRequestArgs req = TypeScriptChangeRequestArgs.build(el, text, info.myContentLength, info.myLineCount, info.myLastLineStartOffset);
            return new TypeScriptChangeCommand(req);
        }).toList();
        ArrayList toCloseByRename = new ArrayList();
        ArrayList toOpenByRename = new ArrayList();
        HashSet filesToCloseByRename = new HashSet();
        HashSet<TypeScriptConfig> configsToReload = new HashSet<TypeScriptConfig>();
        this.myUpdateFiles.forEach((file2, storedInfo) -> {
            String newPath = JSLanguageServiceUtil.normalizeNameAndPath(file2);
            String oldPath = storedInfo.myLastPath;
            if (newPath != null && !Objects.equals(newPath, oldPath)) {
                toCloseByRename.add(TypeScriptLanguageServiceCache.createCloseCommand(file2, oldPath));
                filesToCloseByRename.add(file2);
                if (!filesToOpen.contains(file2) && !filesToClose.contains(file2)) {
                    LastUpdateInfo updateInfo = (LastUpdateInfo)toUpdateCache.get(file2);
                    LastUpdateInfo info = new LastUpdateInfo(updateInfo == null ? storedInfo : updateInfo, newPath);
                    Document document2 = (Document)unsavedContents.get(file2);
                    CharSequence text = document2 == null ? null : this.getPreprocessedDocumentText((VirtualFile)file2, document2);
                    TypeScriptConfig config2 = this.getConfigForFile((VirtualFile)file2);
                    String projectFileName = TypeScriptConfigUtil.getNonStandardProjectFileName(config2);
                    toOpenByRename.add(this.createOpenCommand((VirtualFile)file2, info, text, projectFileName, info.myTimestamp));
                    toUpdateCache.put(file2, info);
                    if (config2 != null) {
                        configsToReload.add(config2);
                    }
                }
            }
        });
        Collection toClose = filesToClose.stream().filter(el -> !filesToCloseByRename.contains(el)).map(el -> TypeScriptLanguageServiceCache.createCloseCommand(el, JSLanguageServiceUtil.normalizeNameAndPath(el))).collect(Collectors.toList());
        filesToClose.forEach(el -> this.myUpdateFiles.remove(el));
        this.myUpdateFiles.putAll(toUpdateCache);
        if (toChange.isEmpty() && toClose.isEmpty() && toOpen.isEmpty() && toCloseByRename.isEmpty() && toOpenByRename.isEmpty()) {
            return null;
        }
        Pair<Collection<TypeScriptCommandWithArguments>, Collection<TypeScriptCommandWithArguments>> openAndCloseExternals = this.getAndUpdateExternalConfigsCommand();
        Collection openExternal = (Collection)openAndCloseExternals.getFirst();
        Collection closeExternal = (Collection)openAndCloseExternals.getSecond();
        ArrayList<TypeScriptCommandWithArguments> result2 = new ArrayList<TypeScriptCommandWithArguments>();
        TypeScriptLanguageServiceCache.addReloadCommands(configsToReload, result2);
        result2.addAll(openExternal);
        result2.addAll(toCloseByRename);
        result2.addAll(toOpen);
        result2.addAll(toOpenByRename);
        result2.addAll(toChange);
        result2.addAll(toClose);
        result2.addAll(closeExternal);
        return new TypeScriptCommandSetRequest(result2);
    }

    private static void addReloadCommands(@NotNull Collection<TypeScriptConfig> configsToReload, @NotNull List<TypeScriptCommandWithArguments> result2) {
        if (configsToReload == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(5);
        }
        for (TypeScriptConfig config2 : configsToReload) {
            TypeScriptFileWithConfigArgs args = new TypeScriptFileWithConfigArgs();
            args.projectFileName = config2 != null ? LocalFilePath.create(TypeScriptConfigUtil.getConfigProjectFileName(config2)) : null;
            result2.add(new TypeScriptReloadProjectsCommand(args));
        }
    }

    @Nullable
    protected TypeScriptOpenEditorCommand createOpenCommand(@NotNull VirtualFile file2, @NotNull LastUpdateInfo info, @Nullable CharSequence text, @Nullable String projectFileName, long timestamp) {
        if (file2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(6);
        }
        if (info == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(7);
        }
        return new TypeScriptOpenEditorCommand(file2, timestamp, info.myContentLength, info.myLineCount, info.myLastLineStartOffset, text, projectFileName);
    }

    @NotNull
    private static LastUpdateInfo createLastUpdateInfo(@NotNull VirtualFile el, @NotNull CharSequence text, long newTimestamp) {
        if (el == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(8);
        }
        if (text == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(9);
        }
        int lineCount = TypeScriptServerServiceImpl.getLineCountForText(text);
        int lastLineStartOffset = TypeScriptServerServiceImpl.getLastLineStartOffsetFromText(text, lineCount);
        int newContentLength = text.length();
        String path = JSLanguageServiceUtil.normalizeNameAndPath(el);
        return new LastUpdateInfo(path, newTimestamp, newContentLength, lineCount, lastLineStartOffset);
    }

    @NotNull
    protected final CharSequence getPreprocessedDocumentText(@NotNull VirtualFile file2, @NotNull Document document2) {
        if (file2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(10);
        }
        if (document2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(11);
        }
        CharSequence text = this.getDocumentText(file2, document2);
        CharSequence charSequence = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(this.myProject, text, file2);
        if (charSequence == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(12);
        }
        return charSequence;
    }

    @NotNull
    protected CharSequence getDocumentText(@NotNull VirtualFile file2, @NotNull Document document2) {
        if (file2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(13);
        }
        if (document2 == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(14);
        }
        CharSequence charSequence = document2.getImmutableCharSequence();
        if (charSequence == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(15);
        }
        return charSequence;
    }

    @NotNull
    private Pair<Collection<TypeScriptCommandWithArguments>, Collection<TypeScriptCommandWithArguments>> getAndUpdateExternalConfigsCommand() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myExternalConfigs.isEmpty() && !TypeScriptConfigUtil.hasConfigsWithNonStandardName(this.myProject)) {
            Pair pair = Pair.create((Object)ContainerUtil.emptyList(), (Object)ContainerUtil.emptyList());
            if (pair == null) {
                TypeScriptLanguageServiceCache.$$$reportNull$$$0(16);
            }
            return pair;
        }
        Set<VirtualFile> actualExternalConfigs = this.getNonStandardConfigsForChangedAndOpenFiles();
        HashSet<VirtualFile> toClose = new HashSet<VirtualFile>(this.myExternalConfigs);
        toClose.removeAll(actualExternalConfigs);
        HashSet<VirtualFile> toOpen = new HashSet<VirtualFile>(actualExternalConfigs);
        toOpen.removeAll(this.myExternalConfigs);
        this.myExternalConfigs.clear();
        this.myExternalConfigs.addAll(actualExternalConfigs);
        Pair pair = Pair.create(TypeScriptLanguageServiceCache.convertToCommands(toOpen, (Function<String, TypeScriptCommandWithArguments>)((Function)TypeScriptOpenExternalProjectRequest::new)), TypeScriptLanguageServiceCache.convertToCommands(toClose, (Function<String, TypeScriptCommandWithArguments>)((Function)TypeScriptCloseExternalProjectRequest::new)));
        if (pair == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(17);
        }
        return pair;
    }

    @NotNull
    private Set<VirtualFile> getNonStandardConfigsForChangedAndOpenFiles() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Set set = ((StreamEx)StreamEx.of(this.myUpdateFiles.keySet()).append(this.myOpenedFilesByEvent).map(file2 -> this.getConfigForFile((VirtualFile)file2)).nonNull().filter(el -> TypeScriptConfigUtil.isNonStandardName(el))).map(el -> el.getConfigFile()).toSet();
        if (set == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(18);
        }
        return set;
    }

    @NotNull
    private static Set<TypeScriptCommandWithArguments> convertToCommands(@NotNull Set<VirtualFile> toOpen, @NotNull Function<String, TypeScriptCommandWithArguments> factory) {
        if (toOpen == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(19);
        }
        if (factory == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(20);
        }
        Set<TypeScriptCommandWithArguments> set = toOpen.stream().map(el -> JSLanguageServiceUtil.normalizeNameAndPath(el)).filter(el -> el != null).map(el -> (TypeScriptCommandWithArguments)factory.fun(el)).collect(Collectors.toSet());
        if (set == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(21);
        }
        return set;
    }

    @NotNull
    private static TypeScriptCloseEditorCommand createCloseCommand(@NotNull VirtualFile el, @Nullable String path) {
        if (el == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(22);
        }
        TypeScriptFileObject object = new TypeScriptFileObject();
        object.file = LocalFilePath.create(path);
        return new TypeScriptCloseEditorCommand(object, el);
    }

    private Collection<VirtualFile> getFilesToOpen(@NotNull Map<VirtualFile, Long> currentChangedFiles) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(23);
        }
        return ContainerUtil.filter(currentChangedFiles.keySet(), el -> !this.myUpdateFiles.containsKey(el));
    }

    private Collection<VirtualFile> getFilesToChange(@NotNull Map<VirtualFile, Long> currentChangedFiles, @NotNull Collection<VirtualFile> filesToOpen) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(24);
        }
        if (filesToOpen == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(25);
        }
        ArrayList<VirtualFile> realChangedFiles = new ArrayList<VirtualFile>();
        currentChangedFiles.forEach((file2, modified) -> {
            if (filesToOpen.contains(file2)) {
                return;
            }
            LastUpdateInfo lastUpdateInfo = this.myUpdateFiles.get(file2);
            if (lastUpdateInfo == null) {
                JSLanguageServiceQueue.LOGGER.error("Incorrect cache");
                return;
            }
            long timeStamp = lastUpdateInfo.myTimestamp;
            if (modified < 0L || timeStamp == -1L || modified != timeStamp) {
                realChangedFiles.add((VirtualFile)file2);
            }
        });
        return realChangedFiles;
    }

    @NotNull
    protected Set<VirtualFile> getFilesToClose(@NotNull Map<VirtualFile, Long> currentChangedFiles) {
        if (currentChangedFiles == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(26);
        }
        HashSet<VirtualFile> toClose = new HashSet<VirtualFile>();
        for (VirtualFile file2 : this.myUpdateFiles.keySet()) {
            if (currentChangedFiles.containsKey(file2) || this.myOpenedFilesByEvent.contains(file2)) continue;
            toClose.add(file2);
        }
        HashSet<VirtualFile> hashSet = toClose;
        if (hashSet == null) {
            TypeScriptLanguageServiceCache.$$$reportNull$$$0(27);
        }
        return hashSet;
    }

    @Override
    public void dispose() {
        this.clear();
        this.myExternalConfigs.clear();
        this.myOpenedFilesByEvent.clear();
        this.myUpdateFiles.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configsToReload";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toOpen";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentChangedFiles";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToOpen";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreprocessedDocumentText";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAndUpdateExternalConfigsCommand";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonStandardConfigsForChangedAndOpenFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToCommands";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToClose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateCacheAndGetServiceObject";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetCloseEditorCommand";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetOpenEditorCommand";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUpdateFilesServiceObject";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addReloadCommands";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createOpenCommand";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLastUpdateInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPreprocessedDocumentText";
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentText";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertToCommands";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createCloseCommand";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToOpen";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToChange";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getFilesToClose";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LastUpdateInfo {
        public final long myTimestamp;
        public final long myContentLength;
        public final int myLineCount;
        public final int myLastLineStartOffset;
        public final String myLastPath;

        LastUpdateInfo(@NotNull LastUpdateInfo toCopy, @NotNull String newPath) {
            if (toCopy == null) {
                LastUpdateInfo.$$$reportNull$$$0(0);
            }
            if (newPath == null) {
                LastUpdateInfo.$$$reportNull$$$0(1);
            }
            this.myTimestamp = toCopy.myTimestamp;
            this.myContentLength = toCopy.myContentLength;
            this.myLineCount = toCopy.myLineCount;
            this.myLastLineStartOffset = toCopy.myLastLineStartOffset;
            this.myLastPath = newPath;
        }

        LastUpdateInfo(String path, long timestamp, long contentLength, int lineCount, int lastLineStartOffset) {
            this.myTimestamp = timestamp;
            this.myContentLength = contentLength;
            this.myLineCount = lineCount;
            this.myLastLineStartOffset = lastLineStartOffset;
            this.myLastPath = path;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "toCopy";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newPath";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache$LastUpdateInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

