/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.analysis.problemsView.FileProblem;
import com.intellij.analysis.problemsView.Problem;
import com.intellij.analysis.problemsView.ProblemsCollector;
import com.intellij.analysis.problemsView.ProblemsProvider;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSAsyncLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptFileProblem;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptDiagnosticsResponse;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptServiceProjectErrors
implements Disposable,
ProblemsProvider {
    public static final Key<Boolean> TOOL_WINDOW_IS_SHOWN = Key.create((String)"problems.tool.window.open");
    public static final int MERGE_INTERVAL_MILLS = 200;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Gson myGson;
    @NotNull
    private final JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter myReporter;
    @NotNull
    private final Map<Pair<String, ServiceError>, List<JSAnnotationError>> myErrors;
    private final Map<Pair<String, ServiceError>, Set<FileProblem>> myNewErrors;
    @NotNull
    private final List<JSAnnotationError> myGlobalErrors;
    @NotNull
    private final MergingUpdateQueue myProjectErrorsQueue;
    @NotNull
    private final Disposable myDisposable;
    @Nullable
    private String myProjectContext;
    private volatile boolean myDisposed;

    public TypeScriptServiceProjectErrors(@NotNull Project project, @NotNull JSLanguageServiceProtocol protocol, @NotNull JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter reporter) {
        if (project == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(0);
        }
        if (protocol == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(2);
        }
        this.myErrors = new HashMap<Pair<String, ServiceError>, List<JSAnnotationError>>();
        this.myNewErrors = new HashMap<Pair<String, ServiceError>, Set<FileProblem>>();
        this.myGlobalErrors = new CopyOnWriteArrayList<JSAnnotationError>();
        this.myDisposed = false;
        this.myProject = project;
        this.myGson = protocol instanceof JSLanguageServiceNodeStdProtocolBase ? ((JSLanguageServiceNodeStdProtocolBase)protocol).getGson() : JSLanguageServiceQueue.GSON;
        this.myReporter = reporter;
        this.myDisposable = Disposer.newDisposable();
        this.myProjectErrorsQueue = new MergingUpdateQueue("TypeScript service project errors queue", 200, true, null, this.myDisposable, null, Alarm.ThreadToUse.POOLED_THREAD);
    }

    public synchronized void setProjectContext(@Nullable String projectContext, @NotNull List<JSAnnotationError> globalErrors) {
        if (globalErrors == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(3);
        }
        if (this.myDisposed) {
            return;
        }
        if (!Objects.equals(projectContext, this.myProjectContext)) {
            this.myProjectContext = projectContext;
            this.clear();
            this.myProjectErrorsQueue.cancelAllUpdates();
        }
        if (projectContext != null && !Objects.equals(globalErrors, this.myGlobalErrors)) {
            ArrayList<JSAnnotationError> old = new ArrayList<JSAnnotationError>(this.myGlobalErrors);
            this.myGlobalErrors.clear();
            this.myGlobalErrors.addAll(globalErrors);
            this.reportGlobalErrorsNew(globalErrors, old);
            this.queueUpdate();
        }
    }

    private synchronized void reportGlobalErrorsNew(@NotNull List<JSAnnotationError> newErrors, @NotNull List<JSAnnotationError> old) {
        if (newErrors == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(4);
        }
        if (old == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(5);
        }
        ProblemsCollector collector = ProblemsCollector.getInstance((Project)this.myProject);
        Collection<? extends FileProblem> oldProblems = this.convertToFileProblem(old);
        Collection<? extends FileProblem> newProblems = this.convertToFileProblem(newErrors);
        for (FileProblem fileProblem : oldProblems) {
            collector.problemDisappeared((Problem)fileProblem);
        }
        for (FileProblem fileProblem : newProblems) {
            collector.problemAppeared((Problem)fileProblem);
        }
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(6);
        }
        return project;
    }

    public void pushSyntaxErrors(@NotNull JSLanguageServiceAnswer answer) {
        if (answer == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(7);
        }
        this.handleAnswer(answer, ServiceError.SYNTAX);
    }

    public void pushSemanticErrors(@NotNull JSLanguageServiceAnswer answer) {
        if (answer == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(8);
        }
        this.handleAnswer(answer, ServiceError.SEMANTICS);
    }

    private void handleAnswer(@NotNull JSLanguageServiceAnswer answer, @NotNull ServiceError serviceError) {
        if (answer == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(9);
        }
        if (serviceError == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(10);
        }
        if (this.myDisposed) {
            return;
        }
        if (this.convertEventsToAnnotations(answer, serviceError)) {
            this.queueUpdate();
        }
    }

    private void queueUpdate() {
        this.myProjectErrorsQueue.queue(new Update(this){

            public void run() {
                TypeScriptServiceProjectErrors.this.logCurrentErrors();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCurrentErrors() {
        List<JSAnnotationError> result2;
        TypeScriptServiceProjectErrors typeScriptServiceProjectErrors = this;
        synchronized (typeScriptServiceProjectErrors) {
            if (this.myDisposed) {
                return;
            }
            if (this.myProjectContext == null) {
                return;
            }
            result2 = this.getAllErrors();
        }
        this.myReporter.logCurrentErrors(null, result2);
    }

    @NotNull
    private synchronized List<JSAnnotationError> getAllErrors() {
        List<JSAnnotationError> list2 = Stream.concat(this.myGlobalErrors.stream(), this.myErrors.values().stream().flatMap(el -> el.stream())).collect(Collectors.toList());
        if (list2 == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private synchronized boolean convertEventsToAnnotations(@NotNull JSLanguageServiceAnswer answer, @NotNull ServiceError serviceError) {
        if (answer == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(12);
        }
        if (serviceError == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(13);
        }
        if (this.myProjectContext == null) {
            return false;
        }
        JsonObject element = answer.getElement();
        JsonElement body = element.get("body");
        if (body == null) {
            return false;
        }
        TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo responseInfo = (TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo)this.myGson.fromJson(body, TypeScriptDiagnosticsResponse.DiagnosticsResponseInfo.class);
        String path = LocalFilePath.getPath(responseInfo.file);
        List<JSAnnotationError> newElements = TypeScriptServerServiceImpl.parseDiagnosticsForFile(path, responseInfo.diagnostics);
        Pair key = new Pair((Object)path, (Object)serviceError);
        List<JSAnnotationError> oldElements = this.myErrors.get(key);
        this.handleNewProjectErrors((Pair<String, ServiceError>)key, newElements);
        if (newElements.isEmpty()) {
            this.myErrors.remove(key);
            return oldElements != null;
        }
        this.myErrors.put((Pair<String, ServiceError>)key, newElements);
        return !Objects.equals(newElements, oldElements);
    }

    private synchronized void handleNewProjectErrors(@NotNull Pair<String, ServiceError> key, @NotNull List<JSAnnotationError> newElements) {
        if (key == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(14);
        }
        if (newElements == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(15);
        }
        Set<FileProblem> oldEls = !this.myNewErrors.containsKey(key) ? Collections.emptySet() : this.myNewErrors.get(key);
        ProblemsCollector collector = ProblemsCollector.getInstance((Project)this.myProject);
        if (newElements.isEmpty()) {
            if (!oldEls.isEmpty()) {
                oldEls.forEach(el -> collector.problemDisappeared((Problem)el));
                this.myNewErrors.remove(key);
            }
            return;
        }
        Collection<? extends FileProblem> newEls = this.convertToFileProblem(newElements);
        HashSet<? extends FileProblem> newProblems = new HashSet<FileProblem>(newEls);
        if (!newProblems.equals(oldEls)) {
            this.myNewErrors.put(key, newProblems);
            for (FileProblem fileProblem : oldEls) {
                collector.problemDisappeared((Problem)fileProblem);
            }
            for (FileProblem fileProblem : newEls) {
                collector.problemAppeared((Problem)fileProblem);
            }
        }
    }

    @NotNull
    private Collection<? extends FileProblem> convertToFileProblem(@NotNull List<JSAnnotationError> newElements) {
        if (newElements == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(16);
        }
        Set set = StreamEx.of(newElements).map(el -> {
            String pathCandidate = el.getAbsoluteFilePath();
            if (pathCandidate == null) {
                return null;
            }
            VirtualFile path = LocalFileSystem.getInstance().findFileByPath(pathCandidate);
            return path != null ? new TypeScriptFileProblem(this, (JSAnnotationError)el, path) : null;
        }).nonNull().toSet();
        if (set == null) {
            TypeScriptServiceProjectErrors.$$$reportNull$$$0(17);
        }
        return set;
    }

    private synchronized void clear() {
        this.clearNew();
        this.myGlobalErrors.clear();
        this.myErrors.clear();
    }

    private synchronized void clearNew() {
        if (!this.myProject.isDisposed()) {
            ProblemsCollector collector = ProblemsCollector.getInstance((Project)this.myProject);
            this.myNewErrors.forEach((key, value) -> value.forEach(el -> collector.problemDisappeared((Problem)el)));
            this.convertToFileProblem(this.myGlobalErrors).forEach(el -> collector.problemDisappeared((Problem)el));
        }
        this.myNewErrors.clear();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
        this.clear();
        this.myDisposed = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalErrors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newErrors";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "old";
                break;
            }
            case 6: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServiceProjectErrors";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceError";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServiceProjectErrors";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllErrors";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToFileProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setProjectContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reportGlobalErrorsNew";
                break;
            }
            case 6: 
            case 11: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pushSyntaxErrors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "pushSemanticErrors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "handleAnswer";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "convertEventsToAnnotations";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "handleNewProjectErrors";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "convertToFileProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum ServiceError {
        SYNTAX,
        SEMANTICS,
        GLOBAL;

    }
}

