/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSAsyncLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServiceProjectErrors;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptServerState
implements Disposable {
    private static final int TIME_TO_MERGE_COMPILE_EVENTS_MILLS = 2500;
    private static final int TIME_TO_REMOVE_USELESS_EVENTS = 10000;
    public static final String TYPESCRIPT_PACKAGE = "typescript";
    @NotNull
    private final MergingUpdateQueue myCompileQueue;
    @NotNull
    private final ConcurrentMap<String, Consumer<JSLanguageServiceAnswer>> myEventCollector;
    @NotNull
    private final ConcurrentMap<String, JSLanguageServiceAnswer> myConfigDiagnostics;
    @NotNull
    private final MergingUpdateQueue myVfsChangedFilesQueue;
    @NotNull
    private final Set<VirtualFile> myVfsChangedFiles;
    @NotNull
    private final Pair<VirtualFile, Long> myServicePackageJsonInfo;
    protected volatile Set<String> myErrorCodeFixes;
    private final TypeScriptServiceProjectErrors myProjectErrors;
    @NotNull
    @Nls
    private volatile String myStatus;

    public TypeScriptServerState(@NotNull Project project, @NotNull JSLanguageServiceProtocol protocol, @NotNull JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter reporter, @NotNull String servicePath) {
        if (project == null) {
            TypeScriptServerState.$$$reportNull$$$0(0);
        }
        if (protocol == null) {
            TypeScriptServerState.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            TypeScriptServerState.$$$reportNull$$$0(2);
        }
        if (servicePath == null) {
            TypeScriptServerState.$$$reportNull$$$0(3);
        }
        this.myConfigDiagnostics = new ConcurrentHashMap<String, JSLanguageServiceAnswer>();
        this.myErrorCodeFixes = Collections.emptySet();
        VirtualFile serviceDirectory = LocalFileSystem.getInstance().findFileByPath(servicePath);
        VirtualFile packageRoot = serviceDirectory == null ? null : (serviceDirectory.getName().equals(TYPESCRIPT_PACKAGE) ? serviceDirectory : serviceDirectory.getParent());
        VirtualFile packageJson = packageRoot == null ? null : packageRoot.findChild("package.json");
        this.myServicePackageJsonInfo = Pair.create((Object)packageJson, (Object)(packageJson == null ? -1L : packageJson.getModificationStamp()));
        this.myEventCollector = new ConcurrentHashMap<String, Consumer<JSLanguageServiceAnswer>>();
        this.myCompileQueue = new MergingUpdateQueue("TypeScript service compile queue", 2500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myProjectErrors = new TypeScriptServiceProjectErrors(project, protocol, reporter);
        this.myVfsChangedFilesQueue = new MergingUpdateQueue("TypeScript service files to reload", 10000, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myVfsChangedFilesQueue.setRestartTimerOnAdd(true);
        this.myVfsChangedFiles = Collections.newSetFromMap(new ConcurrentHashMap());
        this.registerEventTracker("configFileDiag", (Consumer<JSLanguageServiceAnswer>)((Consumer)el -> {
            JsonObject element = el.getElement();
            JsonObject body = element.getAsJsonObject("body");
            JsonElement file2 = body.get("configFile");
            if (file2 != null && file2.isJsonPrimitive()) {
                String string = file2.getAsString();
                this.myConfigDiagnostics.put(FileUtil.toSystemIndependentName((String)string), (JSLanguageServiceAnswer)el);
                JSLanguageServiceQueue.LOGGER.debug("Updated config diagnostics: " + el.getElement());
            }
        }));
        this.registerEventTracker("syntaxDiag", (Consumer<JSLanguageServiceAnswer>)((Consumer)this.myProjectErrors::pushSyntaxErrors));
        this.registerEventTracker("semanticDiag", (Consumer<JSLanguageServiceAnswer>)((Consumer)this.myProjectErrors::pushSemanticErrors));
        this.myStatus = JavaScriptBundle.message((String)"typescript.compiler.starting", (Object[])new Object[0]);
    }

    public final void registerEventTracker(@NotNull String eventName, @NotNull Consumer<JSLanguageServiceAnswer> tracker) {
        if (eventName == null) {
            TypeScriptServerState.$$$reportNull$$$0(4);
        }
        if (tracker == null) {
            TypeScriptServerState.$$$reportNull$$$0(5);
        }
        this.myEventCollector.put(eventName, tracker);
    }

    void addToCompileQueue(@NotNull Update update2) {
        if (update2 == null) {
            TypeScriptServerState.$$$reportNull$$$0(6);
        }
        this.myCompileQueue.queue(update2);
    }

    void processEvent(@NotNull JSLanguageServiceAnswer el) {
        String type;
        if (el == null) {
            TypeScriptServerState.$$$reportNull$$$0(7);
        }
        if ((type = el.getProperty("event")) == null) {
            return;
        }
        Consumer consumer = (Consumer)this.myEventCollector.get(type);
        if (consumer != null) {
            consumer.consume((Object)el);
        } else {
            JSLanguageServiceQueue.LOGGER.debug("Unprocessed event: " + el.getElement());
        }
    }

    @Nullable
    JSLanguageServiceAnswer getConfigDiagnostics(@NotNull String config2) {
        if (config2 == null) {
            TypeScriptServerState.$$$reportNull$$$0(8);
        }
        return (JSLanguageServiceAnswer)this.myConfigDiagnostics.get(config2);
    }

    void flushCompileQueue() {
        this.myCompileQueue.flush();
    }

    void addFileToVfsQueue(final @NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptServerState.$$$reportNull$$$0(9);
        }
        this.myVfsChangedFiles.add(file2);
        this.myVfsChangedFilesQueue.queue(new Update(file2){

            public void run() {
                TypeScriptServerState.this.myVfsChangedFiles.remove(file2);
            }
        });
    }

    @NotNull
    public Set<VirtualFile> getVfsChangedFiles() {
        return new HashSet<VirtualFile>(this.myVfsChangedFiles);
    }

    public void dispose() {
        this.myCompileQueue.cancelAllUpdates();
        this.myVfsChangedFiles.clear();
        this.myVfsChangedFilesQueue.cancelAllUpdates();
        this.myEventCollector.clear();
        Disposer.dispose((Disposable)this.myProjectErrors);
    }

    public void forceProjectOwner(@Nullable String projectContext, @NotNull List<JSAnnotationError> globalErrors) {
        if (globalErrors == null) {
            TypeScriptServerState.$$$reportNull$$$0(10);
        }
        this.myProjectErrors.setProjectContext(projectContext, globalErrors);
    }

    public void setErrorCodes(@NotNull Set<String> errorCodeFixes) {
        if (errorCodeFixes == null) {
            TypeScriptServerState.$$$reportNull$$$0(11);
        }
        this.myErrorCodeFixes = errorCodeFixes;
    }

    public void setStatus(@Nls @NotNull String status) {
        if (status == null) {
            TypeScriptServerState.$$$reportNull$$$0(12);
        }
        this.myStatus = status;
    }

    @NotNull
    @Nls
    public String getStatus() {
        String string = this.myStatus;
        if (string == null) {
            TypeScriptServerState.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean isServiceValid() {
        VirtualFile packageJson = (VirtualFile)this.myServicePackageJsonInfo.first;
        if (packageJson == null || !packageJson.isValid()) {
            return true;
        }
        return packageJson.getModificationStamp() == ((Long)this.myServicePackageJsonInfo.second).longValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servicePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalErrors";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorCodeFixes";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptServerState";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerEventTracker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addToCompileQueue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processEvent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfigDiagnostics";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addFileToVfsQueue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forceProjectOwner";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setErrorCodes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setStatus";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

