/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpManager;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JSTargetElementEvaluator;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.e4x.impl.JSXmlAttributeImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.JSXXmlLiteralExpressionImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceResponse;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.compiler.ui.TypeScriptNodePackageWrapper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.concurrent.Future;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class TypeScriptLanguageServiceUtil {
    public static final String LIB_DIRECTORY = "lib";
    public static final Condition<VirtualFile> IS_VALID_FILE_FOR_SERVICE = virtualFile -> virtualFile != null && virtualFile.isInLocalFileSystem();
    public static final Condition<VirtualFile> ACCEPTABLE_TS_FILE = virtualFile -> {
        if (!IS_VALID_FILE_FOR_SERVICE.value(virtualFile)) {
            return false;
        }
        FileType type = virtualFile.getFileType();
        return TypeScriptCompilerSettings.acceptFileType(type) && virtualFile.getUserData(JSLanguageServiceQueue.GENERATED_FILE_MARKER) == null;
    };
    public static volatile boolean USE_SERVICE = false;

    @TestOnly
    public static void setUseService(boolean useService) {
        USE_SERVICE = useService;
    }

    public static boolean isServiceEnabled(Project project) {
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return TypeScriptLanguageServiceUtil.isServiceEnabled(settings);
    }

    public static boolean isServiceEnabled(@Nullable TypeScriptCompilerSettings settings) {
        if (settings == null || ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return false;
        }
        return settings.useService();
    }

    public static boolean useServiceCompletion(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(0);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(project)) {
            return false;
        }
        return TypeScriptLanguageServiceUtil.useNewTypeScriptService(project) && TypeScriptCompilerSettings.getSettings(project).isUseServiceCompletion();
    }

    public static boolean useServiceParameterInfo(@Nullable Project project, @NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(1);
        }
        if (!TypeScriptLanguageServiceUtil.checkProject(project)) {
            return false;
        }
        return TypeScriptLanguageServiceUtil.useNewTypeScriptService(project) && ACCEPTABLE_TS_FILE.value((Object)file2) && TypeScriptCompilerSettings.getSettings(project).isUseServiceParameterInfo();
    }

    @Contract(value="null -> false")
    public static boolean checkProject(@Nullable Project project) {
        return project != null && !project.isDisposed() && project.isOpen();
    }

    private static boolean useNewTypeScriptService(@Nullable Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return false;
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return settings.useService();
    }

    public static boolean shouldUseMainFile(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(2);
        }
        return settings.useMainFile();
    }

    @Nullable
    public static String getActualLibDirectory(@Nullable Project project, @NotNull TypeScriptCompilerSettings settings) {
        VirtualFile dir;
        VirtualFile packageJson;
        if (settings == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(3);
        }
        if (project == null || project.isDefault() || project.isDisposed() || ApplicationManager.getApplication().isUnitTestMode() && !USE_SERVICE) {
            return null;
        }
        NodeJsInterpreter interpreter = TypeScriptLanguageServiceUtil.getNodeInterpreter(project, settings);
        TypeScriptNodePackageWrapper.TypeScriptNodePackageDescriptor descriptor2 = TypeScriptNodePackageWrapper.createDescriptor(project, settings);
        NodePackage nodePackage = TypeScriptNodePackageWrapper.getPackageFromSettings(project, descriptor2, settings, interpreter);
        String path = nodePackage.getSystemIndependentPath();
        if (nodePackage instanceof YarnPnpNodePackage && (packageJson = ((YarnPnpNodePackage)nodePackage).getPackageJson(project)) != null && (dir = YarnPnpManager.getInstance(project).findInstalledPackageDir(packageJson, nodePackage.getName())) != null) {
            return nodePackage.getSystemIndependentPath();
        }
        VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
        VirtualFile modulePackage = TypeScriptLanguageServiceUtil.getTypeScriptLibFromNodeModulePackage(fileByPath);
        return modulePackage == null ? null : modulePackage.getPath();
    }

    @Nullable
    public static VirtualFile getTypeScriptLibFromNodeModulePackage(@Nullable VirtualFile nodeModulePackage) {
        if (nodeModulePackage == null) {
            return null;
        }
        if (TypeScriptLanguageServiceUtil.hasServiceFiles(nodeModulePackage)) {
            return nodeModulePackage;
        }
        VirtualFile lib = nodeModulePackage.findChild(LIB_DIRECTORY);
        if (lib == null) {
            return null;
        }
        if (TypeScriptLanguageServiceUtil.hasServiceFiles(lib)) {
            return lib;
        }
        return null;
    }

    public static boolean hasServiceFiles(@NotNull VirtualFile lib) {
        VirtualFile[] children;
        if (lib == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(4);
        }
        if ((children = lib.getChildren()) != null) {
            for (VirtualFile file2 : children) {
                if (!ArrayUtil.contains((String)file2.getName(), (String[])TypeScriptCompilerSettings.TYPESCRIPT_SERVICE_FILES)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    @NlsSafe
    public static String getNormalizedVersionString(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Version parseVersion = Version.parseVersion((String)version);
        if (parseVersion == null) {
            return null;
        }
        return parseVersion.toString();
    }

    public static void fillFilePosition(@NotNull TypeScriptFileLocationRequestArgs args, @NotNull VirtualFile virtualFile, @NotNull Document document2, int positionInFileOffset) {
        if (args == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(6);
        }
        if (document2 == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(7);
        }
        if (document2 instanceof DocumentWindow) {
            positionInFileOffset = ((DocumentWindow)document2).injectedToHost(positionInFileOffset);
            document2 = ((DocumentWindow)document2).getDelegate();
        }
        int line = document2.getLineNumber(positionInFileOffset);
        int offset = positionInFileOffset - document2.getLineStartOffset(line);
        args.line = line + 1;
        args.offset = offset + 1;
        args.file = LocalFilePath.create(TypeScriptCompilerConfigUtil.normalizeNameAndPath(virtualFile));
    }

    @Nullable
    public static NodeJsInterpreter getNodeInterpreter(@NotNull Project project, @NotNull TypeScriptCompilerSettings settings) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(9);
        }
        return NodeJsInterpreterRef.create(settings.getNodeInterpreterRefName()).resolve(project);
    }

    @Deprecated
    @Nullable
    public static String getNodeInterpreterPath(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(10);
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return JSLanguageServiceUtil.getInterpreterPathIfValid(TypeScriptLanguageServiceUtil.getNodeInterpreter(project, settings));
    }

    @Nullable
    public static NodeJsInterpreter getNodeInterpreter(@NotNull Project project) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(11);
        }
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(project);
        return JSLanguageServiceUtil.getInterpreterIfValid(TypeScriptLanguageServiceUtil.getNodeInterpreter(project, settings));
    }

    @NotNull
    public static String getRelativePath(@NotNull Project project, @Nullable String path) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(12);
        }
        if (StringUtil.isEmpty((String)path)) {
            String string = StringUtil.notNullize((String)path);
            if (string == null) {
                TypeScriptLanguageServiceUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = (String)ReadAction.compute(() -> {
            VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
            if (fileByPath == null) {
                return path;
            }
            if (DumbService.isDumb((Project)project) || project.isDisposed() || !project.isOpen()) {
                return path;
            }
            VirtualFile root = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(fileByPath);
            if (root != null) {
                return "/" + VfsUtilCore.getRelativePath((VirtualFile)fileByPath, (VirtualFile)root);
            }
            return path;
        });
        if (string == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Nullable
    public static JSLanguageServiceUtil.PsiElementInfo getPsiElementInfo(@Nullable PsiFile file2, @NotNull Document document2, @Nullable TypeScriptResponseCommon.Location start, @Nullable TypeScriptResponseCommon.Location end) {
        if (document2 == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(15);
        }
        if (start == null || end == null) {
            return null;
        }
        int line = start.line - 1;
        int startOffset = start.offset - 1;
        int endLine = end.line - 1;
        int endOffset = end.offset - 1;
        return JSLanguageServiceUtil.getElementInfo(file2, document2, line, startOffset, endLine, endOffset);
    }

    @Nullable
    public static <T extends JSLanguageServiceResponse> T deserialize(@NotNull Gson gson, @NotNull JSLanguageServiceAnswer answer, @NotNull Class<T> classToUse) {
        JsonObject element;
        JsonElement jsonElement;
        if (gson == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(16);
        }
        if (answer == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(17);
        }
        if (classToUse == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(18);
        }
        return (T)((jsonElement = (element = answer.getElement()).get("body")) == null ? null : (JSLanguageServiceResponse)gson.fromJson(jsonElement, classToUse));
    }

    public static PsiElement @Nullable [] getNavigationFromService(@NotNull Project project, @Nullable Document document2, @NotNull PsiElement sourceElement) {
        if (project == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(19);
        }
        if (sourceElement == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(20);
        }
        if (document2 == null && (document2 = PsiDocumentManager.getInstance((Project)project).getDocument(sourceElement.getContainingFile())) == null) {
            return null;
        }
        Future<TypeScriptResponseCommon.FileSpan[]> future = TypeScriptLanguageServiceEvents.getService(project).getDeclaration(sourceElement, document2);
        if (future == null) {
            return null;
        }
        TypeScriptResponseCommon.FileSpan[] spans = JSLanguageServiceUtil.awaitFuture(future, 700L, 5L, null);
        if (spans == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return (PsiElement[])Arrays.stream(spans).map(el -> {
            String path = el.file.getPath();
            VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path);
            if (file2 == null) {
                return null;
            }
            PsiFile psiFile = psiManager.findFile(file2);
            if (psiFile == null) {
                return null;
            }
            Document newDocument = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            if (newDocument == null) {
                return null;
            }
            return TypeScriptLanguageServiceUtil.getElement(psiFile, newDocument, el);
        }).filter(el -> el != null).map(el -> JSTargetElementEvaluator.adjustTargetElement(el, null)).toArray(PsiElement[]::new);
    }

    @Nullable
    private static PsiElement getElement(@NotNull PsiFile psiFile, @NotNull Document document2, @NotNull TypeScriptResponseCommon.FileSpan span) {
        TypeScriptResponseCommon.Location end;
        TypeScriptResponseCommon.Location start;
        JSLanguageServiceUtil.PsiElementInfo info;
        if (psiFile == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(21);
        }
        if (document2 == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(22);
        }
        if (span == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(23);
        }
        if ((info = TypeScriptLanguageServiceUtil.getPsiElementInfo(psiFile, document2, start = span.start, end = span.end)) == null) {
            return null;
        }
        PsiElement element = info.getElement();
        if (element != null) {
            return element;
        }
        TextRange range = info.getRange();
        if (range == null) {
            return null;
        }
        return TypeScriptPsiUtil.getPsiElementByRange(psiFile, range);
    }

    public static TypeScriptCompilerService.CompletionMergeStrategy getMergeStrategyForPosition(@NotNull PsiElement position, boolean isJavaScript) {
        ES6FromClause clause;
        ES6ImportDeclaration declaration;
        ASTNode node;
        TypeScriptCompilerService.CompletionMergeStrategy defaultStrategy;
        PsiElement parent;
        if (position == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(24);
        }
        if ((parent = position.getParent()) == null) {
            return TypeScriptCompilerService.CompletionMergeStrategy.NON;
        }
        if (parent instanceof JSLiteralExpression && ((JSLiteralExpression)parent).isQuotedLiteral()) {
            return TypeScriptCompilerService.CompletionMergeStrategy.MERGE;
        }
        TypeScriptCompilerService.CompletionMergeStrategy completionMergeStrategy = defaultStrategy = isJavaScript ? TypeScriptCompilerService.CompletionMergeStrategy.MERGE : TypeScriptCompilerService.CompletionMergeStrategy.REPLACE;
        if (parent instanceof JSXXmlLiteralExpressionImpl && (node = position.getNode()).getElementType() == JSTokenTypes.XML_TAG_NAME && position.textContains('.') && node.getText().endsWith("IntellijIdeaRulezzz")) {
            return defaultStrategy;
        }
        if (parent instanceof ES6ImportSpecifier && (declaration = ((ES6ImportSpecifier)parent).getDeclaration()) != null && (clause = declaration.getFromClause()) != null) {
            return clause.resolveReferencedElements().isEmpty() ? defaultStrategy : TypeScriptCompilerService.CompletionMergeStrategy.NON;
        }
        if (parent instanceof JSXmlAttributeImpl) {
            return defaultStrategy;
        }
        if (parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getQualifier() != null) {
            return defaultStrategy;
        }
        if (parent instanceof JSReferenceExpression && TypeScriptLanguageServiceUtil.isShorthandedProperty(parent)) {
            return defaultStrategy;
        }
        if (parent instanceof JSVariable && parent.getParent() instanceof JSDestructuringProperty) {
            return defaultStrategy;
        }
        return TypeScriptCompilerService.CompletionMergeStrategy.NON;
    }

    private static boolean isShorthandedProperty(@NotNull PsiElement parent) {
        PsiElement candidate;
        if (parent == null) {
            TypeScriptLanguageServiceUtil.$$$reportNull$$$0(25);
        }
        return (candidate = parent.getParent()) instanceof ES6Property && ((ES6Property)candidate).isShorthanded();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = LIB_DIRECTORY;
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 7: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gson";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToUse";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "span";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceUtil";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "useServiceCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "useServiceParameterInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseMainFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActualLibDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasServiceFiles";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillFilePosition";
                break;
            }
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNodeInterpreter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNodeInterpreterPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementInfo";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationFromService";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getMergeStrategyForPosition";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isShorthandedProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

