/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitParameterStructure;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSignatureHelpResponse;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSymbolDisplayPart;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.List;

public class TypeScriptLanguageServiceResponseParser {
    public static final String NO_NAME = "noname";

    public static List<JSFunctionItem> parseFunctions(TypeScriptSignatureHelpResponse response) {
        Object[] items = response.items;
        if (ArrayUtil.isEmpty((Object[])items)) {
            return ContainerUtil.emptyList();
        }
        SmartList result2 = new SmartList();
        for (Object item : items) {
            String functionName = NO_NAME;
            for (TypeScriptSymbolDisplayPart part : ((TypeScriptSignatureHelpResponse.TypeScriptSignatureHelpItem)item).prefixDisplayParts) {
                if (!"methodName".equals(part.kind)) continue;
                functionName = part.text;
            }
            JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(functionName, null);
            builder.setType(JSImplicitElement.Type.Function);
            Object[] parameters = ((TypeScriptSignatureHelpResponse.TypeScriptSignatureHelpItem)item).parameters;
            if (ArrayUtil.isEmpty((Object[])parameters)) {
                result2.add((JSFunctionItem)builder.toImplicitElement());
                continue;
            }
            SmartList parameterStructures = new SmartList();
            for (Object parameter : parameters) {
                int symbolIndex;
                String typeText = null;
                Object[] parameterParts = ((TypeScriptSignatureHelpResponse.TypeScriptSignatureHelpParameter)parameter).displayParts;
                if (!ArrayUtil.isEmpty((Object[])parameterParts) && !TypeScriptLanguageServiceResponseParser.isInvalidPlace((TypeScriptSymbolDisplayPart[])parameterParts, symbolIndex = TypeScriptLanguageServiceResponseParser.waitSymbolWithoutBrace((TypeScriptSymbolDisplayPart[])parameterParts, 0, ':'))) {
                    typeText = TypeScriptLanguageServiceResponseParser.readRestText((TypeScriptSymbolDisplayPart[])parameterParts, symbolIndex);
                }
                parameterStructures.add(new JSImplicitParameterStructure(((TypeScriptSignatureHelpResponse.TypeScriptSignatureHelpParameter)parameter).name, typeText, ((TypeScriptSignatureHelpResponse.TypeScriptSignatureHelpParameter)parameter).isOptional, false, true));
            }
            builder.setParameters((List<JSImplicitParameterStructure>)parameterStructures);
            result2.add((JSFunctionItem)builder.toImplicitElement());
        }
        return result2;
    }

    public static String readRestText(TypeScriptSymbolDisplayPart[] parts, int startIndex) {
        StringBuilder result2 = new StringBuilder();
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            TypeScriptLanguageServiceResponseParser.appendText(result2, part);
        }
        return result2.toString();
    }

    public static void appendText(StringBuilder result2, TypeScriptSymbolDisplayPart part) {
        if ("space".equals(part.kind)) {
            result2.append(" ");
        } else {
            result2.append(part.text);
        }
    }

    public static int waitSymbolWithoutBrace(TypeScriptSymbolDisplayPart[] parts, int startIndex, char symbol) {
        ArrayDeque<String> toSkipPairs = new ArrayDeque<String>();
        for (int i = startIndex; i < parts.length; ++i) {
            TypeScriptSymbolDisplayPart part = parts[i];
            String text = part.text;
            if ("{".equals(text)) {
                toSkipPairs.addLast("}");
                continue;
            }
            if ("<".equals(text)) {
                toSkipPairs.addLast(">");
                continue;
            }
            if ("[".equals(text)) {
                toSkipPairs.addLast("]");
                continue;
            }
            if (symbol != '(' && "(".equals(text)) {
                toSkipPairs.addLast(")");
                continue;
            }
            if (!toSkipPairs.isEmpty()) {
                if (!text.equals(toSkipPairs.getLast())) continue;
                toSkipPairs.removeLast();
                continue;
            }
            if (!text.equals(String.valueOf(symbol))) continue;
            return i + 1;
        }
        return -1;
    }

    public static boolean isInvalidPlace(TypeScriptSymbolDisplayPart[] parts, int cursor) {
        return cursor == -1 || cursor >= parts.length;
    }
}

