/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.validation.fixes.ES6ConvertDefaultImportToSpecifierFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ThrowableRunnable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0006H\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016J3\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0002J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/lang/javascript/validation/fixes/ES6ConvertDefaultImportToSpecifierFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;", "(Lcom/intellij/lang/ecmascript6/psi/ES6ImportedBinding;)V", "bindingName", "", "getBindingName", "()Ljava/lang/String;", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "isAvailable", "", "memberWithBindingNameIsAvailableFromModule", "declaration", "Lcom/intellij/lang/ecmascript6/psi/ES6ImportDeclaration;", "intellij.javascript.impl"})
public final class ES6ConvertDefaultImportToSpecifierFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final String bindingName;

    @NotNull
    public final String getBindingName() {
        return this.bindingName;
    }

    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"es6.change.to.named.import.fix", (Object[])new Object[]{this.bindingName});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JavaScriptBundle.message\u2026import.fix\", bindingName)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (!this.isAvailable(project, file2, startElement, endElement)) {
            return;
        }
        ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportedBinding)startElement).getDeclaration();
        Intrinsics.checkNotNull((Object)eS6ImportDeclaration);
        ES6ImportDeclaration declaration = eS6ImportDeclaration;
        WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(this, declaration){
            final /* synthetic */ ES6ConvertDefaultImportToSpecifierFix this$0;
            final /* synthetic */ ES6ImportDeclaration $declaration;

            public final void run() {
                block4: {
                    ES6ImportedBinding newBinding;
                    Object v4;
                    block3: {
                        ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = new ES6ImportPsiUtil.CreateImportExportInfo(this.this$0.getBindingName(), ES6ImportPsiUtil.ImportExportType.SPECIFIER);
                        ES6ImportSpecifier eS6ImportSpecifier = ES6ImportPsiUtil.insertImportSpecifier(this.$declaration, createImportExportInfo);
                        if (eS6ImportSpecifier == null) {
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)eS6ImportSpecifier, (String)"insertImportSpecifier(de\u2026ExportInfo) ?: return@run");
                        ES6ImportSpecifier insertImportSpecifier = eS6ImportSpecifier;
                        ES6ImportDeclaration eS6ImportDeclaration = insertImportSpecifier.getDeclaration();
                        if (eS6ImportDeclaration == null) {
                            return;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)eS6ImportDeclaration, (String)"insertImportSpecifier.declaration ?: return@run");
                        ES6ImportDeclaration eS6ImportDeclaration2 = eS6ImportDeclaration;
                        Object[] objectArray = eS6ImportDeclaration2.getImportedBindings();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"eS6ImportDeclaration.importedBindings");
                        Sequence sequence = ArraysKt.asSequence((Object[])objectArray);
                        boolean bl = false;
                        Sequence sequence2 = sequence;
                        boolean bl2 = false;
                        for (E e : sequence2) {
                            ES6ImportedBinding it = (ES6ImportedBinding)e;
                            boolean bl3 = false;
                            ES6ImportedBinding eS6ImportedBinding = it;
                            Intrinsics.checkNotNullExpressionValue((Object)eS6ImportedBinding, (String)"it");
                            if (!Intrinsics.areEqual((Object)eS6ImportedBinding.getDeclaredName(), (Object)this.this$0.getBindingName())) continue;
                            v4 = e;
                            break block3;
                        }
                        v4 = null;
                    }
                    ES6ImportedBinding eS6ImportedBinding = newBinding = (ES6ImportedBinding)v4;
                    if (eS6ImportedBinding == null) break block4;
                    eS6ImportedBinding.delete();
                }
            }
            {
                this.this$0 = eS6ConvertDefaultImportToSpecifierFix;
                this.$declaration = eS6ImportDeclaration;
            }
        }));
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Object v3;
        ES6ImportDeclaration declaration;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            if (!(startElement instanceof ES6ImportedBinding)) {
                return false;
            }
            ES6ImportDeclaration eS6ImportDeclaration = ((ES6ImportedBinding)startElement).getDeclaration();
            if (eS6ImportDeclaration == null) {
                return false;
            }
            Intrinsics.checkNotNullExpressionValue((Object)eS6ImportDeclaration, (String)"startElement.declaration ?: return false");
            declaration = eS6ImportDeclaration;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)((PsiElement)declaration))) {
                return false;
            }
            Object[] objectArray = declaration.getImportSpecifiers();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"declaration.importSpecifiers");
            Sequence sequence = ArraysKt.asSequence((Object[])objectArray);
            boolean bl = false;
            Sequence sequence2 = sequence;
            boolean bl2 = false;
            for (Object e : sequence2) {
                ES6ImportSpecifier it = (ES6ImportSpecifier)e;
                boolean bl3 = false;
                ES6ImportSpecifier eS6ImportSpecifier = it;
                Intrinsics.checkNotNullExpressionValue((Object)eS6ImportSpecifier, (String)"it");
                if (!Intrinsics.areEqual((Object)this.bindingName, (Object)eS6ImportSpecifier.getReferenceName())) continue;
                v3 = e;
                break block4;
            }
            v3 = null;
        }
        return v3 == null && this.memberWithBindingNameIsAvailableFromModule(declaration);
    }

    private final boolean memberWithBindingNameIsAvailableFromModule(ES6ImportDeclaration declaration) {
        Object v4;
        block3: {
            ES6FromClause fromClause = declaration.getFromClause();
            if (fromClause == null) {
                return false;
            }
            PsiElement module = ES6PsiUtil.findExternalModule((PsiElement)declaration);
            if (!(module instanceof JSElement)) {
                return false;
            }
            Collection collection = fromClause.resolveReferencedElements();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"fromClause.resolveReferencedElements()");
            Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)memberWithBindingNameIsAvailableFromModule.1.INSTANCE);
            boolean bl = false;
            Sequence sequence2 = sequence;
            boolean bl2 = false;
            for (Object e : sequence2) {
                PsiElement element;
                JSElement it = (JSElement)e;
                boolean bl3 = false;
                Object[] symbolsInModule = ES6PsiUtil.resolveSymbolInModule(this.bindingName, (PsiElement)declaration, it);
                Intrinsics.checkNotNullExpressionValue((Object)symbolsInModule, (String)"symbolsInModule");
                ResolveResult resolveResult = (ResolveResult)ArraysKt.firstOrNull((Object[])symbolsInModule);
                Object object = element = resolveResult != null ? resolveResult.getElement() : null;
                boolean bl4 = element instanceof JSPsiElementBase && ((JSPsiElementBase)element).isExported();
                if (!bl4) continue;
                v4 = e;
                break block3;
            }
            v4 = null;
        }
        return v4 != null;
    }

    public ES6ConvertDefaultImportToSpecifierFix(@NotNull ES6ImportedBinding element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super((PsiElement)element);
        String string = StringUtil.notNullize((String)element.getDeclaredName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.notNullize(element.declaredName)");
        this.bindingName = string;
    }
}

