/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.JSAccessibilityCheckInspection;
import com.intellij.lang.javascript.inspections.JSCheckFunctionSignaturesInspection;
import com.intellij.lang.javascript.inspections.JSUnresolvedVariableInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSUnresolvedReferenceErrorUpdater;
import com.intellij.lang.javascript.validation.JSValidateExpressionUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.javascript.validation.fixes.FixPropertyNameTypoQuickFix;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.EditDistance;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceChecker {
    @NotNull
    protected final JSProblemReporter<?> myReporter;

    public JSReferenceChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            JSReferenceChecker.$$$reportNull$$$0(0);
        }
        this.myReporter = reporter;
    }

    public void checkRefExpression(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(1);
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(node, "arguments") && PsiTreeUtil.getParentOfType((PsiElement)node, XmlAttributeValue.class) != null) {
            return;
        }
        if (!node.shouldCheckReferences() || JSUnresolvedVariableInspection.getCallIfMethodExpression(node) != null) {
            return;
        }
        ResolveResult[] resolveResults = node.multiResolve(false);
        boolean hasValidResult = false;
        for (ResolveResult r : resolveResults) {
            if (!r.isValidResult()) continue;
            hasValidResult = true;
            if (this.processExpressionResolveResult((JSExpression)node, r.getElement())) break;
        }
        if (!hasValidResult) {
            this.registerQuickFixesForUnresolvedRef(node, resolveResults);
        } else if (!JSResolveUtil.isSelfReference((PsiElement)node) && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.ReadWrite) {
            PsiElement element;
            boolean seenRead = false;
            boolean seenWrite = false;
            for (ResolveResult r : resolveResults) {
                PsiElement element2 = r.getElement();
                if (element2 instanceof JSFunction && ((JSFunction)element2).isGetProperty() || element2 instanceof JSProperty && ((JSProperty)element2).isGetProperty()) {
                    seenRead = true;
                    continue;
                }
                if (element2 instanceof JSFunction && ((JSFunction)element2).isSetProperty() || element2 instanceof JSProperty && ((JSProperty)element2).isSetProperty()) {
                    seenWrite = true;
                    continue;
                }
                if (!(element2 instanceof JSProperty) && !(element2 instanceof JSVariable) && !(element2 instanceof JSDefinitionExpression)) continue;
                seenWrite = true;
                seenRead = true;
                break;
            }
            if ((seenRead || seenWrite) && (element = node.getReferenceNameElement()) != null) {
                if (!seenRead) {
                    this.myReporter.registerProblem(element, null, JavaScriptBundle.message((String)"javascript.missing.read.property", (Object[])new Object[0]), null, new LocalQuickFix[0]);
                }
                if (!seenWrite) {
                    this.myReporter.registerProblem(element, null, JavaScriptBundle.message((String)"javascript.missing.write.property", (Object[])new Object[0]), null, new LocalQuickFix[0]);
                }
            }
        }
    }

    protected boolean processExpressionResolveResult(@Nullable JSExpression expression, @Nullable PsiElement resolved) {
        return true;
    }

    protected void registerQuickFixesForUnresolvedRef(JSReferenceExpression node, ResolveResult[] resolveResults) {
        boolean canHaveCreateFromUsage;
        PsiElement nameIdentifier = node.getReferenceNameElement();
        if (nameIdentifier == null) {
            return;
        }
        LinkedList<LocalQuickFix> fixes = new LinkedList<LocalQuickFix>();
        JSReferenceExpression topReferenceExpression = (JSReferenceExpression)JSResolveUtil.getTopReferenceExpression((PsiElement)node);
        boolean inTypeContext = JSResolveUtil.isExprInTypeContext(topReferenceExpression);
        JSExpression qualifier = node.getQualifier();
        boolean bl = canHaveCreateFromUsage = JSReferenceChecker.findInsufficientVisibilityResult(resolveResults) == null && JSReferenceChecker.canHaveCreateFromUsage(qualifier);
        if (canHaveCreateFromUsage) {
            ContainerUtil.addIfNotNull(fixes, (Object)this.getPreferredQuickFixForUnresolvedRef(nameIdentifier));
            if (fixes.isEmpty()) {
                boolean reportProblem;
                PsiFile containingFile = node.getContainingFile();
                boolean ecma = containingFile.getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                ProblemHighlightType highlightType = this.getUnresolvedReferenceHighlightType(node);
                boolean bl2 = reportProblem = (!ecma || highlightType != ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) && highlightType != null;
                if (!reportProblem) {
                    return;
                }
                inTypeContext = this.addCreateFromUsageFixes(node, resolveResults, fixes, inTypeContext, ecma);
            }
        }
        JSReferenceChecker.addEscalateVisibilityFix(resolveResults, node, fixes);
        fixes.add(JSReferenceChecker.renameReferenceFix());
        String message = JavaScriptBundle.message((String)(node.getQualifier() == null ? (inTypeContext && node == topReferenceExpression ? "javascript.unresolved.type.name.message" : "javascript.unresolved.variable.or.type.name.message") : "javascript.unresolved.variable.name.message"), (Object[])new Object[]{node.getReferenceName()});
        this.reportUnresolvedReference(resolveResults, node, fixes, message, false, inTypeContext);
    }

    protected boolean suggestCreateVarFromUsage(JSReferenceExpression node) {
        return true;
    }

    @Nullable
    protected LocalQuickFix getPreferredQuickFixForUnresolvedRef(PsiElement nameIdentifier) {
        return null;
    }

    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSType type;
        JSExpression qualifier;
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(2);
        }
        if ((qualifier = node.getQualifier()) == null && node.getParent() instanceof JSDefinitionExpression && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            return ProblemHighlightType.ERROR;
        }
        if (qualifier != null && (type = JSResolveUtil.getExpressionJSType(qualifier)) != null && JSTypeUtils.isMapType(type)) {
            return null;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    protected boolean addCreateFromUsageFixes(JSReferenceExpression node, ResolveResult[] resolveResults, List<LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
        boolean isField;
        JSClass contextClass;
        if (!inTypeContext && !ecma && JSInsertThisFix.isThisFixAvailable(node)) {
            String name = node.getReferenceName();
            fixes.add((LocalQuickFix)new JSInsertThisFix((JSExpression)node));
            fixes.add(this.createJSVariableIntentionAction(name, false, false, false));
            JSReferenceChecker.addCreateParameterFix(node.getParent(), fixes, name);
            return false;
        }
        JSExpression qualifier = node.getQualifier();
        String referencedName = node.getReferenceName();
        PsiElement parent = node.getParent();
        PsiFile containingFile = node.getContainingFile();
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)containingFile);
        boolean supportsClasses = JSClassUtils.canHaveClasses(parent);
        JSReferenceChecker.addTypoQuickFixes(node, fixes, qualifier);
        JSClass jSClass = contextClass = supportsClasses ? JSResolveUtil.getClassOfContext((PsiElement)node) : null;
        if (ES6PsiUtil.isInsideDecorator((PsiElement)node)) {
            contextClass = JSResolveUtil.getClassOfContext((PsiElement)contextClass);
        }
        if (parent instanceof JSReferenceListMember) {
            if (supportsClasses && contextClass != null && qualifier == null) {
                boolean isInterface = contextClass.isInterface() || parent.getParent().getNode().getElementType() == JSStubElementTypes.IMPLEMENTS_LIST;
                fixes.add(JSReferenceChecker.createClassOrInterfaceFix(node, isInterface));
            }
            return inTypeContext;
        }
        if (inTypeContext && !(node.getParent() instanceof JSReferenceExpression) && supportsClasses && resolveResults.length == 0) {
            PsiElement element;
            fixes.add(JSReferenceChecker.createClassOrInterfaceFix(node, true));
            fixes.add(JSReferenceChecker.createClassOrInterfaceFix(node, false));
            if (qualifier instanceof JSReferenceExpression && (element = ((JSReferenceExpression)qualifier).resolve()) instanceof TypeScriptEnum) {
                fixes.add(this.createJSVariableIntentionAction(referencedName, true, false, false));
            }
            return true;
        }
        boolean bl = isField = qualifier != null || (ecma || supportsClasses) && contextClass != null;
        if (!inTypeContext) {
            if (parent instanceof JSArgumentList && (dialect == null || !dialect.isTypeScript) || JSReferenceChecker.isFunctionExpectedType(node) || parent instanceof ES6Decorator) {
                if (parent instanceof JSArgumentList && ecma) {
                    fixes.add(JSFixFactory.getInstance().createJSFunctionFromArgumentIntentionAction(referencedName, qualifier, true));
                } else {
                    this.addFunctionFixes(node, fixes, referencedName, dialect, qualifier);
                }
            }
            if (!(parent instanceof ES6Decorator) && this.suggestCreateVarFromUsage(node)) {
                boolean isTypeScriptModule = JSReferenceChecker.isTypeScriptModule(qualifier);
                fixes.add(this.createJSVariableIntentionAction(referencedName, isField, false, isTypeScriptModule));
                if (qualifier != null && referencedName != null) {
                    this.addSurroundWithTypeGuardFix(qualifier, fixes, referencedName);
                }
                if (isField && qualifier == null) {
                    fixes.add(this.createJSVariableIntentionAction(referencedName, false, false, false));
                }
                if (qualifier == null) {
                    JSReferenceChecker.addCreateParameterFix(parent, fixes, referencedName);
                }
                if (ecma && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read) {
                    fixes.add(this.createJSVariableIntentionAction(referencedName, isField, true, isTypeScriptModule));
                }
            }
        }
        return inTypeContext;
    }

    @NotNull
    private static Set<String> getPotentialTypos(JSExpression qualifier, String referencedName) {
        if (qualifier == null || referencedName == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JSReferenceChecker.$$$reportNull$$$0(3);
            }
            return set;
        }
        JSType type = JSResolveUtil.getExpressionJSType(qualifier);
        if (type == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                JSReferenceChecker.$$$reportNull$$$0(4);
            }
            return set;
        }
        LinkedHashSet<String> allProperties = new LinkedHashSet<String>();
        for (JSRecordType.TypeMember member : type.asRecordType().getTypeMembers()) {
            String name1;
            if (!(member instanceof JSRecordType.PropertySignature) || (name1 = ((JSRecordType.PropertySignature)member).getMemberName()).length() == 1 || referencedName.length() == 1 || !name1.equalsIgnoreCase(referencedName) && EditDistance.optimalAlignment((CharSequence)name1, (CharSequence)referencedName, (boolean)false) > 1) continue;
            allProperties.add(name1);
        }
        LinkedHashSet<String> linkedHashSet = allProperties;
        if (linkedHashSet == null) {
            JSReferenceChecker.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    private static boolean isTypeScriptModule(JSExpression qualifier) {
        return qualifier instanceof JSReferenceExpression && DialectDetector.isTypeScript((PsiElement)qualifier) && ((JSReferenceExpression)qualifier).resolve() instanceof TypeScriptModule;
    }

    protected void addSurroundWithTypeGuardFix(@NotNull JSExpression qualifier, @NotNull List<LocalQuickFix> fixes, @NotNull String name) {
        if (qualifier == null) {
            JSReferenceChecker.$$$reportNull$$$0(6);
        }
        if (fixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(7);
        }
        if (name == null) {
            JSReferenceChecker.$$$reportNull$$$0(8);
        }
    }

    protected void addCreateFromUsageFixesForCall(@NotNull JSReferenceExpression methodExpression, boolean isNewExpression, ResolveResult @NotNull [] resolveResults, @NotNull List<LocalQuickFix> quickFixes) {
        if (methodExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(9);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(10);
        }
        if (resolveResults == null) {
            JSReferenceChecker.$$$reportNull$$$0(11);
        }
        String refName = methodExpression.getReferenceName();
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)methodExpression);
        JSExpression qualifier = methodExpression.getQualifier();
        boolean isAsync = JSReferenceChecker.isAsyncContext(methodExpression);
        JSReferenceChecker.addTypoQuickFixes(methodExpression, quickFixes, qualifier);
        if (!isNewExpression && JSInsertThisFix.isThisFixAvailable(methodExpression)) {
            quickFixes.add((LocalQuickFix)new JSInsertThisFix((JSExpression)methodExpression));
        }
        if (isNewExpression) {
            if (qualifier != null && !(qualifier instanceof JSReferenceExpression)) {
                return;
            }
            if (dialect != null && !dialect.hasFeature(JSLanguageFeature.CLASSES)) {
                boolean isModuleScope = JSReferenceChecker.isTypeScriptModule(qualifier);
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, isModuleScope, isAsync));
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, false, isModuleScope, isAsync));
            } else {
                JSNewExpression newExpression = (JSNewExpression)ObjectUtils.tryCast((Object)methodExpression.getParent(), JSNewExpression.class);
                if (newExpression != null) {
                    quickFixes.add(JSReferenceChecker.createClassFromNewFix(methodExpression, newExpression.getArgumentList(), JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)newExpression)));
                }
            }
        } else {
            this.addFunctionFixes(methodExpression, quickFixes, refName, dialect, qualifier);
        }
        quickFixes.add(JSReferenceChecker.renameReferenceFix());
    }

    private static void addTypoQuickFixes(@NotNull JSReferenceExpression expression, @NotNull List<LocalQuickFix> quickFixes, JSExpression qualifier) {
        if (expression == null) {
            JSReferenceChecker.$$$reportNull$$$0(12);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(13);
        }
        Set<String> myPotentialTypo = JSReferenceChecker.getPotentialTypos(qualifier, expression.getReferenceName());
        for (String typo : myPotentialTypo) {
            quickFixes.add((LocalQuickFix)new FixPropertyNameTypoQuickFix(expression, typo));
        }
    }

    protected void addFunctionFixes(@NotNull JSReferenceExpression node, @NotNull List<LocalQuickFix> quickFixes, @Nullable String refName, DialectOptionHolder dialect, JSExpression qualifier) {
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(14);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(15);
        }
        boolean isAsync = JSReferenceChecker.isAsyncContext(node);
        if (qualifier != null) {
            quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, JSReferenceChecker.isTypeScriptModule(qualifier), isAsync));
            if (refName != null) {
                this.addSurroundWithTypeGuardFix(qualifier, quickFixes, refName);
            }
        } else {
            if (JSResolveUtil.getClassOfContext((PsiElement)node) != null && PsiTreeUtil.getParentOfType((PsiElement)node, ES6Decorator.class, (boolean)true, (Class[])new Class[]{JSClass.class}) == null && !JSInsertThisFix.isThisFixAvailable(node)) {
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, false, isAsync));
            }
            if (dialect == null || dialect.isJavaScript() && !dialect.isECMA6) {
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, true, false, isAsync));
            }
            if (dialect == null || !dialect.isECMA4) {
                quickFixes.add(JSFixFactory.getInstance().createJSFunctionIntentionAction(refName, false, false, isAsync));
            }
        }
    }

    private static boolean isAsyncContext(JSReferenceExpression node) {
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)node.getParent(), JSCallExpression.class);
        if (callExpression == null) {
            return false;
        }
        JSPrefixExpression expression = (JSPrefixExpression)ObjectUtils.tryCast((Object)callExpression.getParent(), JSPrefixExpression.class);
        return expression != null && expression.getOperationSign() == JSTokenTypes.AWAIT_KEYWORD;
    }

    protected LocalQuickFix createJSVariableIntentionAction(String referencedName, boolean isField, boolean isConstant, boolean isModuleScope) {
        return JSFixFactory.getInstance().createJSVariableIntentionAction(referencedName, isField, isConstant, isModuleScope);
    }

    protected void reportUnresolvedReference(ResolveResult @NotNull [] resolveResults, @NotNull JSReferenceExpression referenceExpression, @NotNull List<LocalQuickFix> quickFixes, @NotNull @InspectionMessage String message, boolean isFunction, boolean inTypeContext) {
        PsiElement place;
        if (referenceExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(16);
        }
        if (quickFixes == null) {
            JSReferenceChecker.$$$reportNull$$$0(17);
        }
        if (message == null) {
            JSReferenceChecker.$$$reportNull$$$0(18);
        }
        if (resolveResults == null) {
            JSReferenceChecker.$$$reportNull$$$0(19);
        }
        if ((place = referenceExpression.getReferenceNameElement()) == null) {
            return;
        }
        boolean jsSymbolNotAccessible = JSAccessibilityCheckInspection.isSymbolNotAccessible(resolveResults);
        if (resolveResults.length > 0 && resolveResults[0] instanceof JSResolveResult) {
            String resolveProblemKey;
            if (isFunction) {
                JSReferenceChecker.addEscalateVisibilityFix(resolveResults, referenceExpression, quickFixes);
            }
            if ((resolveProblemKey = ((JSResolveResult)resolveResults[0]).getResolveProblemKey()) != null) {
                message = JavaScriptBundle.message((String)resolveProblemKey, (Object[])new Object[0]);
            }
            PsiElement element = resolveResults[0].getElement();
            if (jsSymbolNotAccessible && element instanceof JSQualifiedNamedElement) {
                JSAttributeList.AccessType newVisibility = JSVisibilityUtil.getEscalatedJSDocVisibility((JSQualifiedNamedElement)element, (PsiElement)referenceExpression);
                quickFixes.add((LocalQuickFix)new JSAccessibilityCheckInspection.SetJSDocElementVisibilityFix(element, newVisibility));
            }
        }
        if (resolveResults.length == 0) {
            JSType qualifierType;
            JSFunction parentFunction;
            String referenceName = referenceExpression.getReferenceName();
            JSExpression qualifier = referenceExpression.getQualifier();
            if (qualifier != null && referenceName != null && (parentFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)qualifier, JSFunction.class)) != null && JSPsiImplUtils.hasModifier((JSAttributeListOwner)parentFunction, JSAttributeList.ModifierType.ASYNC) && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) instanceof JSGenericTypeImpl && JSTypeUtils.isExactlyPromiseLikeType(qualifierType)) {
                JSRecordType.PropertySignature signature;
                JSType innerType = JSTypeUtils.getSingleGenericArgTypeFromGenericType((JSGenericTypeImpl)qualifierType, t -> true, false);
                JSRecordType.PropertySignature propertySignature = signature = innerType == null ? null : innerType.asRecordType().findPropertySignature(referenceName);
                if (signature != null) {
                    quickFixes.add(JSFixFactory.getInstance().createInsertAwaitFix(qualifier, false));
                }
            }
        }
        JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl info = new JSUnresolvedReferenceErrorUpdater.ErrorInfoImpl(quickFixes);
        for (JSUnresolvedReferenceErrorUpdater provider : JSUnresolvedReferenceErrorUpdater.EP_NAME.getExtensionList()) {
            provider.updateError(info, referenceExpression, resolveResults, inTypeContext);
            String newMessage = info.getMessage();
            if (newMessage == null) continue;
            message = newMessage;
        }
        if (jsSymbolNotAccessible) {
            this.myReporter.registerProblem(place, null, message, null, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        } else {
            ProblemHighlightType type = this.getUnresolvedReferenceHighlightType(referenceExpression);
            if (isFunction) {
                if (JSCheckFunctionSignaturesInspection.reportIncompleteAsArgumentTypesMismatch(resolveResults) == null) {
                    this.myReporter.registerProblem(place, null, message, type, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                }
            } else {
                this.myReporter.registerProblem(place, null, message, type, quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    protected boolean isErrorReported(@NotNull JSReferenceExpression ref) {
        Object[] results;
        boolean hasValidResult;
        if (ref == null) {
            JSReferenceChecker.$$$reportNull$$$0(20);
        }
        if (!(hasValidResult = ContainerUtil.exists((Object[])(results = ref.multiResolve(false)), ResolveResult::isValidResult)) && this.getUnresolvedReferenceHighlightType(ref) == ProblemHighlightType.ERROR) {
            return true;
        }
        JSExpression qualifier = ref.getQualifier();
        return qualifier instanceof JSReferenceExpression && this.isErrorReported((JSReferenceExpression)qualifier);
    }

    public void checkCallReferences(JSReferenceExpression methodExpression, boolean isNewExpression) {
        PsiElement element;
        JSElement expression;
        ResolveResult[] resolveResults = methodExpression.multiResolve(false);
        boolean noCompleteResolve = true;
        boolean mismatchArguments = resolveResults.length > 0;
        for (ResolveResult r : resolveResults) {
            if (r.isValidResult()) {
                noCompleteResolve = false;
                if (this.processExpressionResolveResult((JSExpression)methodExpression, r.getElement())) break;
            }
            mismatchArguments &= r instanceof JSResolveResult && ((JSResolveResult)r).getResolveProblemKey() == "javascript.argument.types.mismatch";
        }
        if (resolveResults.length == 0 || noCompleteResolve) {
            boolean canCreateFromUsage;
            JSExpression qualifier = methodExpression.getQualifier();
            LinkedList<LocalQuickFix> quickFixes = new LinkedList<LocalQuickFix>();
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)methodExpression);
            boolean simpleJs = dialect != null && dialect.isJavaScript();
            ProblemHighlightType unresolvedRefHighlightType = this.getUnresolvedReferenceHighlightType(methodExpression);
            boolean reportProblem = unresolvedRefHighlightType != null && (dialect == null || !dialect.isECMA4 || unresolvedRefHighlightType != ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
            boolean bl = canCreateFromUsage = JSReferenceChecker.canHaveCreateFromUsage(qualifier) && (simpleJs || JSReferenceChecker.findInsufficientVisibilityResult(resolveResults) == null);
            if (reportProblem && canCreateFromUsage && !mismatchArguments) {
                this.addCreateFromUsageFixesForCall(methodExpression, isNewExpression, resolveResults, quickFixes);
            }
            if (reportProblem) {
                String message = this.createUnresolvedCallReferenceMessage(methodExpression, isNewExpression);
                this.reportUnresolvedReference(resolveResults, methodExpression, quickFixes, message, true, false);
            }
        } else if (resolveResults.length == 1 && resolveResults[0].getElement() instanceof JSVariable && methodExpression.getQualifier() == null && ((expression = JSSymbolUtil.calcRefExprValue(methodExpression)) instanceof JSObjectLiteralExpression || expression instanceof JSArrayLiteralExpression) && (element = methodExpression.getReferenceNameElement()) != null) {
            this.myReporter.registerProblem(element, null, JavaScriptBundle.message((String)"javascript.invalid.invoker.target", (Object[])new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    @NotNull
    @InspectionMessage
    protected String createUnresolvedCallReferenceMessage(@NotNull JSReferenceExpression methodExpression, boolean isNewExpression) {
        if (methodExpression == null) {
            JSReferenceChecker.$$$reportNull$$$0(21);
        }
        String refName = methodExpression.getReferenceName();
        String string = JavaScriptBundle.message((String)(isNewExpression ? "javascript.unresolved.type.name.message" : "javascript.unresolved.function.name.message"), (Object[])new Object[]{refName});
        if (string == null) {
            JSReferenceChecker.$$$reportNull$$$0(22);
        }
        return string;
    }

    public void checkNewExpressionInsideCallReferences(JSNewExpression methodExpression) {
        PsiElement elt;
        ResolveResult[] results;
        JSExpression methodExpr = methodExpression.getMethodExpression();
        if (methodExpr instanceof JSReferenceExpression && (results = ((JSReferenceExpression)methodExpr).multiResolve(false)).length > 0 && ((elt = results[0].getElement()) instanceof JSFunction && ((JSFunction)elt).isConstructor() || elt instanceof JSClass)) {
            this.myReporter.registerProblem((PsiElement)methodExpression, null, JavaScriptBundle.message((String)"javascript.term.does.not.evaluate.to.function", (Object[])new Object[0]), this.getUnresolvedReferenceHighlightType((JSReferenceExpression)methodExpr), new LocalQuickFix[0]);
        }
    }

    private static JSResolveResult findInsufficientVisibilityResult(ResolveResult[] results) {
        for (ResolveResult r : results) {
            String problemKey;
            if (r.isValidResult() || !(r instanceof JSResolveResult) || !ArrayUtil.contains((String)(problemKey = ((JSResolveResult)r).getResolveProblemKey()), (String[])JSResolveResult.INSUFFICIENT_VISIBILITY_PROBLEM_KEYS)) continue;
            return (JSResolveResult)r;
        }
        return null;
    }

    private static void addEscalateVisibilityFix(ResolveResult[] resolveResults, JSReferenceExpression refExpr, List<LocalQuickFix> fixes) {
        JSResolveResult result2 = JSReferenceChecker.findInsufficientVisibilityResult(resolveResults);
        if (result2 == null || !(result2.getElement() instanceof JSAttributeListOwner)) {
            return;
        }
        JSAttributeListOwner element = (JSAttributeListOwner)result2.getElement();
        JSAttributeList attributeList = element.getAttributeList();
        if (attributeList == null) {
            return;
        }
        if (JSProjectUtil.isInLibrary((PsiElement)element)) {
            return;
        }
        JSVisibilityUtil.Options options = new JSVisibilityUtil.Options();
        String key = result2.getResolveProblemKey();
        if (key == "javascript.private.member.is.not.accessible.without.sharp.message") {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, JSAttributeList.AccessType.PUBLIC, null));
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createAddRemoveSharpFix(refExpr, false));
            return;
        }
        if (key == "javascript.public.member.is.not.accessible.via.sharp.message") {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, JSAttributeList.AccessType.PRIVATE, null));
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createAddRemoveSharpFix(refExpr, true));
            return;
        }
        if (key == "javascript.private.member.is.not.accessible.via.sharp.message") {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createAddRemoveSharpFix(refExpr, true));
            return;
        }
        options.ignoreClassInheritance = key == "javascript.protected.member.is.not.accessible.message";
        JSAttributeList.AccessType visibility = JSVisibilityUtil.getEscalatedVisibility(element, (PsiElement)refExpr, attributeList.getAccessType(), options);
        fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, visibility, null));
        if (DialectDetector.isJavaScriptFamily((PsiElement)element) && visibility == JSAttributeList.AccessType.PROTECTED) {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createChangeVisibilityFix(element, JSAttributeList.AccessType.PUBLIC, null));
        }
    }

    protected static void addCreateParameterFix(PsiElement parentElement, List<? super LocalQuickFix> fixes, String referencedName) {
        if (PsiTreeUtil.getParentOfType((PsiElement)parentElement, JSFunction.class) != null && !ES6PsiUtil.isInsideDecorator(parentElement)) {
            fixes.add((LocalQuickFix)JSFixFactory.getInstance().createJSParameterIntentionAction(referencedName));
        }
    }

    private static boolean isFunctionExpectedType(@NotNull JSReferenceExpression node) {
        JSType type;
        JSType valuableType;
        if (node == null) {
            JSReferenceChecker.$$$reportNull$$$0(23);
        }
        return (valuableType = JSTypeUtils.getValuableType(type = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)node, JSExpectedTypeKind.EXPECTED))) != null && !JSTypeCastUtil.isAlwaysAssignableType(valuableType, (PsiElement)node) && JSTypeUtils.hasFunctionType(valuableType, false, (PsiElement)node);
    }

    protected static LocalQuickFix createClassOrInterfaceFix(JSReferenceExpression referenceExpression, boolean isInterface) {
        return JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)referenceExpression, isInterface, null, null);
    }

    private static LocalQuickFix createClassFromNewFix(JSReferenceExpression referenceExpression, JSArgumentList argumentList, JSType expectedType) {
        return JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)referenceExpression, false, argumentList, expectedType);
    }

    private static LocalQuickFix renameReferenceFix() {
        return JSFixFactory.getInstance().renameReferenceFix();
    }

    private static boolean canHaveCreateFromUsage(JSExpression qualifier) {
        JSExpression innerExpression;
        if (qualifier instanceof JSParenthesizedExpression && (innerExpression = ((JSParenthesizedExpression)qualifier).getInnerExpression()) instanceof JSBinaryExpression && JSTokenTypes.AS_KEYWORD == ((JSBinaryExpression)innerExpression).getOperationSign()) {
            return true;
        }
        return qualifier == null || qualifier instanceof JSThisExpression || qualifier instanceof JSSuperExpression || qualifier instanceof JSNewExpression || qualifier instanceof JSCallExpression && (DialectDetector.isActionScript((PsiElement)qualifier) || DialectDetector.isTypeScript((PsiElement)qualifier)) || JSValidateExpressionUtil.isLHSExpression(qualifier);
    }

    public static LocalQuickFix[] getCreateFixesForUnresolvedRef(ES6ImportExportDeclarationPart importExportPart) {
        PsiElement file2 = ES6PsiUtil.computeFromFileForImportExport((PsiElement)importExportPart);
        if (JSReferenceChecker.isInapplicableFile(file2)) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix createClassFix = JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)importExportPart, false, null, null);
        LocalQuickFix createInterfaceFix = JSFixFactory.getInstance().createClassOrInterfaceFix((PsiElement)importExportPart, true, null, null);
        FixAndIntentionAction createVariableFix = (FixAndIntentionAction)JSFixFactory.getInstance().createJSVariableIntentionAction(JSReferenceChecker.getNameToCreate(importExportPart), true, false, true);
        createVariableFix.registerElementRefForFix((PsiElement)importExportPart, null);
        FixAndIntentionAction createFunctionFix = (FixAndIntentionAction)JSFixFactory.getInstance().createJSFunctionIntentionAction(JSReferenceChecker.getNameToCreate(importExportPart), true, true, false);
        createFunctionFix.registerElementRefForFix((PsiElement)importExportPart, null);
        return new LocalQuickFix[]{createClassFix, createInterfaceFix, createVariableFix, createFunctionFix};
    }

    private static boolean isInapplicableFile(@Nullable PsiElement file2) {
        if (file2 == null) {
            return true;
        }
        PsiFile file1 = file2.getContainingFile();
        if (file1 == null) {
            return true;
        }
        VirtualFile virtualFile = file1.getVirtualFile();
        return virtualFile == null || JSLibraryUtil.isProbableLibraryFile(virtualFile);
    }

    public static String getNameToCreate(ES6ImportExportDeclarationPart importExportPart) {
        if (importExportPart instanceof ES6ImportExportSpecifier) {
            return ((ES6ImportExportSpecifier)importExportPart).getReferenceName();
        }
        return importExportPart.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: 
            case 2: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSReferenceChecker";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixes";
                break;
            }
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSReferenceChecker";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPotentialTypos";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnresolvedCallReferenceMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkRefExpression";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUnresolvedReferenceHighlightType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSurroundWithTypeGuardFix";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCreateFromUsageFixesForCall";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addTypoQuickFixes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addFunctionFixes";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "reportUnresolvedReference";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isErrorReported";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createUnresolvedCallReferenceMessage";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionExpectedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

