/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.index.JSInheritanceCallEvaluator;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSIncludeDirective;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSImplicitItem;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.lang.typescript.resolve.GlobalSearchScopeWithIdFilter;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStructureViewElement
extends JSStructureViewElementBase {
    private final Set<String> myParentReferencedNames;
    private final boolean myEcma;

    public JSStructureViewElement(@NotNull PsiElement element, boolean ecma) {
        if (element == null) {
            JSStructureViewElement.$$$reportNull$$$0(0);
        }
        super(element, null, false);
        this.myParentReferencedNames = Collections.emptySet();
        this.myEcma = ecma;
    }

    public JSStructureViewElement(@NotNull PsiElement element, @Nullable ItemPresentation presentation) {
        if (element == null) {
            JSStructureViewElement.$$$reportNull$$$0(1);
        }
        super(element, presentation, false);
        this.myParentReferencedNames = Collections.emptySet();
        this.myEcma = false;
    }

    private JSStructureViewElement(@NotNull List<PsiElement> elements, @Nullable Set<String> parentReferencedNames, boolean ecma) {
        if (elements == null) {
            JSStructureViewElement.$$$reportNull$$$0(2);
        }
        this(elements, parentReferencedNames, null, ecma, false);
    }

    protected JSStructureViewElement(@NotNull List<PsiElement> elements, @Nullable Set<String> parentReferencedNames, @Nullable ItemPresentation presentation, boolean ecma, boolean inherited) {
        if (elements == null) {
            JSStructureViewElement.$$$reportNull$$$0(3);
        }
        super(elements, presentation, inherited);
        this.myParentReferencedNames = parentReferencedNames != null ? new HashSet<String>(parentReferencedNames) : Collections.emptySet();
        this.myEcma = ecma;
    }

    @Override
    @NotNull
    protected JSStructureViewElementBase copyWithInheritedImpl() {
        return new JSStructureViewElement(this.getAllElements(), this.myParentReferencedNames, this.getPresentation(), this.myEcma, true);
    }

    @Override
    @NotNull
    public List<StructureViewTreeElement> getOwnChildren() {
        PsiElement element = this.getValue();
        if (!element.isValid()) {
            List<StructureViewTreeElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSStructureViewElement.$$$reportNull$$$0(4);
            }
            return list2;
        }
        HashSet<String> referencedNames = new HashSet<String>(this.myParentReferencedNames);
        JSQualifiedName ns = JSStructureViewElement.getProvidedNamespaceByElement(element);
        List<StructureViewTreeElement> list3 = this.collectMyElements(referencedNames, ns, element.getContainingFile());
        if (list3 == null) {
            JSStructureViewElement.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @Override
    @NotNull
    public List<StructureViewTreeElement> getInherited() {
        PsiElement element = this.getValue();
        if (!element.isValid()) {
            List<StructureViewTreeElement> list2 = Collections.emptyList();
            if (list2 == null) {
                JSStructureViewElement.$$$reportNull$$$0(6);
            }
            return list2;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof JSFile && ((JSFile)file2).isMinified()) {
            List<StructureViewTreeElement> list3 = Collections.emptyList();
            if (list3 == null) {
                JSStructureViewElement.$$$reportNull$$$0(7);
            }
            return list3;
        }
        List<StructureViewTreeElement> elementsFromSupers = null;
        HashSet<String> referencedNames = new HashSet<String>(this.myParentReferencedNames);
        JSNamespace providedNs = element instanceof JSElementBase ? JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)element, true, null) : null;
        JSQualifiedName namespace = providedNs != null ? providedNs.getQualifiedName() : null;
        this.collectMyElements(referencedNames, namespace, element.getContainingFile());
        if (element instanceof JSClass) {
            elementsFromSupers = this.getInheritedForClass((JSClass)element, (Function<? super PsiElement, ? extends JSStructureViewElementBase>)((Function)superClass -> this.createStructureViewElement((PsiElement)superClass, (Set<String>)referencedNames)));
        } else if (!this.myEcma) {
            JSQualifiedName parent;
            JSQualifiedName jSQualifiedName = parent = namespace != null ? namespace.getParent() : null;
            if (parent != null && "Object".equals(parent.getQualifiedName())) {
                providedNs = null;
            }
            if (element instanceof JSPsiElementBase && !JSSymbolUtil.isConstructorSymbol((JSPsiElementBase)element) && (!(element instanceof JSFunction) || element instanceof JSFunctionExpression) && (!(element instanceof JSVariable) || !JSSymbolUtil.isMeaningfulLocalVariableInitializer(((JSVariable)element).getInitializerOrStub()) || ((JSVariable)element).isLocal()) || !(element instanceof JSNamedElement) && (namespace == null || !JSSymbolUtil.isConstructorName(namespace.getQualifiedName())) || element instanceof JSProperty || element instanceof JSImplicitElement && !JSStructureViewElement.isClass((JSImplicitItem)((JSImplicitElement)element))) {
                providedNs = null;
            }
            if (providedNs != null && providedNs.getQualifiedName() != null) {
                providedNs = JSNamedTypeFactory.copyWithJSContext(providedNs, JSContext.INSTANCE);
                GlobalSearchScope scope = JSResolveUtil.getResolveScope((PsiElement)file2);
                elementsFromSupers = this.getInheritedElements(element, providedNs, scope, referencedNames);
            }
        }
        List<StructureViewTreeElement> list4 = elementsFromSupers != null ? elementsFromSupers : Collections.emptyList();
        if (list4 == null) {
            JSStructureViewElement.$$$reportNull$$$0(8);
        }
        return list4;
    }

    @Nullable
    private List<StructureViewTreeElement> getInheritedElements(@NotNull PsiElement element, @NotNull JSNamespace providedNs, @NotNull GlobalSearchScope scope, @NotNull Set<String> outReferencedNames) {
        if (element == null) {
            JSStructureViewElement.$$$reportNull$$$0(9);
        }
        if (providedNs == null) {
            JSStructureViewElement.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            JSStructureViewElement.$$$reportNull$$$0(11);
        }
        if (outReferencedNames == null) {
            JSStructureViewElement.$$$reportNull$$$0(12);
        }
        HashSet visitedTypes = new HashSet();
        JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex(element, providedNs, true, true, true, (Processor<? super JSType>)((Processor)type -> {
            JSNamespace ns = JSTypeUtils.getNamespaceMatchingType(type, false);
            if (ns != null) {
                visitedTypes.add(ns);
            }
            return true;
        }));
        MultiMap result2 = new MultiMap();
        for (JSNamespace type2 : visitedTypes) {
            JSQualifiedName name = type2.getQualifiedName();
            if (name == null) continue;
            this.addElementsFromNamespace((MultiMap<String, PsiElement>)result2, scope, name.getQualifiedName());
        }
        List superElements = ContainerUtil.map(this.convertPsiToElements((MultiMap<String, PsiElement>)result2, outReferencedNames), el -> ((JSStructureViewElement)((Object)el)).copyWithInherited());
        return !superElements.isEmpty() ? superElements : null;
    }

    private static boolean isClass(JSImplicitItem element) {
        JSImplicitElement.Type type = element.getType();
        return type == JSImplicitElement.Type.Class || type == JSImplicitElement.Type.Interface;
    }

    @Nullable
    private static JSQualifiedName getProvidedNamespaceByElement(PsiElement element) {
        JSNamespace jsNamespace;
        if (element instanceof JSElementBase && (jsNamespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)element, true, null)) != null) {
            return jsNamespace.getQualifiedName();
        }
        return null;
    }

    protected JSStructureViewElement createStructureViewElement(PsiElement element, Set<String> parentReferencedNames) {
        return this.createStructureViewElement(Collections.singletonList(element), parentReferencedNames);
    }

    private JSStructureViewElement createStructureViewElement(List<PsiElement> elements, Set<String> parentReferencedNames) {
        return new JSStructureViewElement(elements, parentReferencedNames, this.myEcma);
    }

    protected List<StructureViewTreeElement> collectMyElements(Set<String> referencedNames, JSQualifiedName ns, PsiFile contextFile) {
        return this.doCollectMyElements(referencedNames, ns, contextFile, this.getElement(), this.getAllElements(), false);
    }

    private List<StructureViewTreeElement> doCollectMyElements(Set<String> referencedNames, JSQualifiedName ns, PsiFile contextFile, PsiElement mainElement, List<PsiElement> mainElements, boolean oneElementOnly) {
        boolean shouldFindNsInDepth;
        boolean myElementIsFile = mainElement instanceof PsiFile;
        boolean bl = shouldFindNsInDepth = myElementIsFile && mainElement.getLanguage() != JavaScriptSupportLoader.ECMA_SCRIPT_L4 || mainElement instanceof JSImplicitElement;
        if (mainElement instanceof JSDefinitionExpression && "prototype".equals(((JSDefinitionExpression)mainElement).getName())) {
            return Collections.emptyList();
        }
        HashSet<PsiFile> visitedFiles = new HashSet<PsiFile>();
        visitedFiles.add(contextFile);
        MultiMap children = MultiMap.createLinked();
        Function childrenProvider = el -> JSStructureViewElement.gatherChildElements(el, visitedFiles);
        JSStructureViewElementBase.ChildElementProcessor childProcessor = (el, name) -> this.addChildElement(el, name, ns, mainElement, shouldFindNsInDepth, (MultiMap<String, PsiElement>)children);
        if (this.fillChildrenElement(mainElements, (MultiMap<String, PsiElement>)children, (Function<PsiElement, Collection<? extends PsiElement>>)childrenProvider, childProcessor, oneElementOnly)) {
            return this.convertPsiToElements((MultiMap<String, PsiElement>)children, referencedNames);
        }
        if (ns != null && !oneElementOnly) {
            this.addElementsFromNamespaceFromFile(ns, contextFile, (MultiMap<String, PsiElement>)children);
        }
        referencedNames.addAll(children.keySet());
        return this.convertPsiToElements((MultiMap<String, PsiElement>)children, referencedNames);
    }

    private void addElementsFromNamespaceFromFile(@NotNull JSQualifiedName ns, @NotNull PsiFile contextFile, @NotNull MultiMap<String, PsiElement> children) {
        if (ns == null) {
            JSStructureViewElement.$$$reportNull$$$0(13);
        }
        if (contextFile == null) {
            JSStructureViewElement.$$$reportNull$$$0(14);
        }
        if (children == null) {
            JSStructureViewElement.$$$reportNull$$$0(15);
        }
        GlobalSearchScopeWithIdFilter scope = new GlobalSearchScopeWithIdFilter(contextFile);
        FileBasedIndex.getInstance().ignoreDumbMode(DumbModeAccessType.RELIABLE_DATA_ONLY, () -> this.lambda$addElementsFromNamespaceFromFile$5(children, (GlobalSearchScope)scope, ns));
    }

    private boolean addChildElement(PsiElement element, String name, JSQualifiedName ns, PsiElement parentElement, boolean shouldFindNsInDepth, MultiMap<String, PsiElement> children) {
        if (JSStructureViewElement.isElementInMyNamespace(element, ns, parentElement, shouldFindNsInDepth)) {
            this.addElement(children, element, name);
            return true;
        }
        if (element instanceof JSPsiElementBase) {
            String childName;
            JSQualifiedName namespace = ((JSPsiElementBase)element).getJSNamespace().getQualifiedName();
            JSQualifiedName childNs = JSStructureViewElement.findFirstLevelChildNs(ns, namespace);
            childNs = childNs == null && JSStructureViewElement.shouldAddNamespaceFromDefinition(element, namespace, this.myParentReferencedNames) ? namespace : childNs;
            String string = childName = childNs != null ? childNs.getName() : null;
            if (childNs != null && this.myParentReferencedNames.contains(name) && Comparing.equal((Object)childNs, (Object)namespace)) {
                return true;
            }
            if (childNs != null && !childName.equals("Window")) {
                children.putValue((Object)childName, (Object)new JSStructureImplicitNamespace(childNs, (JSPsiElementBase)element));
                return true;
            }
        }
        return false;
    }

    private static boolean shouldAddNamespaceFromDefinition(PsiElement element, JSQualifiedName namespace, Set<String> parentReferencedNames) {
        return namespace != null && element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getInitializerOrStub() instanceof JSFunctionItem && !parentReferencedNames.contains(namespace.getName());
    }

    private void addElementsFromNamespace(MultiMap<String, PsiElement> children, GlobalSearchScope scope, String namespace) {
        boolean isObject = "Object".equals(namespace);
        for (JSPsiElementBase namedElement : JSClassResolver.getInstance().findNamespaceMembersIncludingLocal(namespace, scope)) {
            String name;
            if (isObject && namedElement.getJSContext() == JSContext.STATIC || (name = this.getName((PsiElement)namedElement, children.size())) == null) continue;
            this.addElement(children, (PsiElement)namedElement, name);
        }
    }

    @Override
    protected String getName(@NotNull PsiElement element, int count) {
        if (element == null) {
            JSStructureViewElement.$$$reportNull$$$0(16);
        }
        if (element instanceof JSPackageStatement) {
            return null;
        }
        if (element instanceof JSDefinitionExpression) {
            PsiFile file2;
            JSFunction function2;
            JSClass clazz;
            JSDefinitionExpression definition = (JSDefinitionExpression)element;
            if ("prototype".equals(definition.getName()) && definition.getJSContext() != JSContext.INSTANCE) {
                return null;
            }
            if (this.myEcma && (clazz = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)(function2 = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)definition, (Class[])new Class[]{JSFunction.class})), (Class[])new Class[]{JSClass.class})) != null) {
                return null;
            }
            if ("exports".equals(definition.getName()) && (file2 = definition.getContainingFile()) instanceof JSFile && ((JSFile)file2).isCommonJSModule()) {
                return null;
            }
            if (definition.getJSNamespace().getQualifiedName() == null && !(definition.getInitializerOrStub() instanceof JSFunctionItem) && !this.hasStructureElements(element)) {
                return null;
            }
        }
        return super.getName(element, count);
    }

    @Override
    protected boolean hasStructureElements(PsiElement element) {
        List<StructureViewTreeElement> elements = this.doCollectMyElements((Set<String>)new THashSet(), JSStructureViewElement.getProvidedNamespaceByElement(element), element.getContainingFile(), element, Collections.singletonList(element), true);
        return !elements.isEmpty();
    }

    private static Collection<? extends PsiElement> gatherChildElements(PsiElement element, Set<PsiFile> visitedFiles) {
        JSExpression value;
        if (element instanceof JSStructureImplicitNamespace) {
            return Collections.singleton(element.getParent());
        }
        if (element instanceof JSAssignmentExpression) {
            SmartList result2 = new SmartList();
            PsiElement value2 = element;
            while (value2 instanceof JSAssignmentExpression) {
                PsiElement definition = ((JSStubElementImpl)value2).getStubOrPsiChild((IStubElementType)JSStubElementTypes.DEFINITION_EXPRESSION);
                ContainerUtil.addIfNotNull((Collection)result2, (Object)definition);
                value2 = ((JSStubElementImpl)value2).getStubOrPsiChild((IStubElementType)JSStubElementTypes.ASSIGNMENT_EXPRESSION);
            }
            return result2;
        }
        if (element instanceof JSDefinitionExpression && (value = ((JSDefinitionExpression)element).getInitializerOrStub()) != null) {
            return Collections.singleton(value);
        }
        if (element instanceof JSIncludeDirective) {
            PsiFile file2 = ((JSIncludeDirective)element).resolveFile();
            element = file2 != null && !visitedFiles.contains(file2) ? file2 : element;
            visitedFiles.add(file2);
        }
        return JSStructureViewElement.getPsiOrStubChildren(element);
    }

    @NotNull
    private List<StructureViewTreeElement> convertPsiToElements(MultiMap<String, PsiElement> children, final Set<String> parentReferencedNames) {
        List list2 = JBIterable.from((Iterable)children.entrySet()).flatMap((Function)new Function<Map.Entry<String, Collection<PsiElement>>, List<StructureViewTreeElement>>(){

            public List<StructureViewTreeElement> fun(Map.Entry<String, Collection<PsiElement>> entry) {
                List value = (List)entry.getValue();
                SmartList staticElements = new SmartList();
                boolean hasInstanceMember = false;
                for (PsiElement element : value) {
                    if (!(element instanceof JSPsiElementBase)) continue;
                    JSContext context = ((JSPsiElementBase)element).getJSContext();
                    if (context == JSContext.STATIC) {
                        staticElements.add((Object)element);
                        continue;
                    }
                    if (context != JSContext.INSTANCE) continue;
                    hasInstanceMember = true;
                }
                if (!staticElements.isEmpty() && hasInstanceMember) {
                    SmartList otherElements = new SmartList();
                    Iterator staticElementsIterator = staticElements.iterator();
                    PsiElement staticElement = (PsiElement)staticElementsIterator.next();
                    for (PsiElement element : value) {
                        if (staticElement == element) {
                            staticElement = staticElementsIterator.hasNext() ? (PsiElement)staticElementsIterator.next() : null;
                            continue;
                        }
                        otherElements.add((Object)element);
                    }
                    return ContainerUtil.newArrayList((Object[])new StructureViewTreeElement[]{this.sortAndCreate((List<PsiElement>)staticElements), this.sortAndCreate((List<PsiElement>)otherElements)});
                }
                return Collections.singletonList(this.sortAndCreate(value));
            }

            private StructureViewTreeElement sortAndCreate(List<PsiElement> value) {
                JSStructureViewElement.this.sortChildrenByImplicitElements(value);
                return JSStructureViewElement.this.createStructureViewElement(value, (Set<String>)parentReferencedNames);
            }
        }).toList();
        if (list2 == null) {
            JSStructureViewElement.$$$reportNull$$$0(17);
        }
        return list2;
    }

    private static boolean isElementInMyNamespace(PsiElement element, JSQualifiedName myNs, PsiElement parentElement, boolean shouldFindNsInDepth) {
        JSInheritanceCallEvaluator.JSInheritanceCallResult inheritance;
        JSExpression initializer;
        if (!(element instanceof JSElementBase)) {
            return true;
        }
        JSQualifiedName namespace = ((JSElementBase)element).getJSNamespace().getQualifiedName();
        if (namespace == null) {
            return true;
        }
        if (namespace.equals(myNs)) {
            return true;
        }
        String name = namespace.getName();
        if (parentElement instanceof PsiFile) {
            if (Comparing.equal((Object)namespace.getParent(), (Object)myNs) && "Window".equals(name)) {
                return true;
            }
            if (!shouldFindNsInDepth && element instanceof JSClass && JSStructureViewElement.findFirstLevelChildNs(myNs, namespace) != null) {
                return true;
            }
        } else if (!StringUtil.isEmpty((String)name) && myNs != null && name.equals(myNs.getName()) && Comparing.equal((Object)JSStructureViewElement.getParentSkippingWindow(namespace), (Object)JSStructureViewElement.getParentSkippingWindow(myNs))) {
            return true;
        }
        return parentElement instanceof JSInitializerOwner && (initializer = ((JSInitializerOwner)parentElement).getInitializer()) instanceof JSCallExpression && (inheritance = JSInheritanceCallEvaluator.findInheritance((JSCallExpression)initializer)) != null && inheritance.destination != initializer && inheritance.isCallExpressionMatchesDestination;
    }

    private static JSQualifiedName getParentSkippingWindow(@Nullable JSQualifiedName namespace) {
        JSQualifiedName parent;
        JSQualifiedName jSQualifiedName = parent = namespace != null ? namespace.getParent() : null;
        if (parent != null && "Window".equals(parent.getName())) {
            return parent.getParent();
        }
        return parent;
    }

    private static JSQualifiedName findFirstLevelChildNs(JSQualifiedName parent, JSQualifiedName namespace) {
        while (namespace != null) {
            JSQualifiedName parentNs = namespace.getParent();
            if (Comparing.equal((Object)parentNs, (Object)parent)) {
                return namespace;
            }
            namespace = parentNs;
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSStructureViewElement element = (JSStructureViewElement)((Object)o);
        return this.myEcma == element.myEcma && this.myParentReferencedNames.equals(element.myParentReferencedNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myParentReferencedNames, this.myEcma);
    }

    private /* synthetic */ Object lambda$addElementsFromNamespaceFromFile$5(MultiMap children, GlobalSearchScope scope, JSQualifiedName ns) throws RuntimeException {
        this.addElementsFromNamespace((MultiMap<String, PsiElement>)children, scope, ns.getQualifiedName());
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/structureView/JSStructureViewElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providedNs";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outReferencedNames";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/structureView/JSStructureViewElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnChildren";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInherited";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "convertPsiToElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInheritedElements";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addElementsFromNamespaceFromFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class JSStructureImplicitNamespace
    extends JSImplicitElementImpl {
        private JSStructureImplicitNamespace(JSQualifiedName parent, JSPsiElementBase element) {
            super(new JSImplicitElementImpl.Builder(parent, (PsiElement)element).setType(JSStructureImplicitNamespace.isClassMemberDefinition((PsiElement)element) ? JSImplicitElement.Type.Class : JSImplicitElement.Type.Namespace));
        }

        private static boolean isClassMemberDefinition(PsiElement element) {
            return element instanceof JSDefinitionExpression && ((JSDefinitionExpression)element).getJSContext() == JSContext.INSTANCE;
        }
    }
}

