/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service.highlighting;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingPass;
import com.intellij.lang.javascript.service.highlighting.JSLanguageServiceHighlightingStateHolder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSLanguageServiceHighlightingPassFactory
implements Disposable,
TextEditorHighlightingPassFactory {
    private final JSLanguageServiceHighlightingStateHolder mySharedCalcHolder;
    protected final Project myProject;

    protected JSLanguageServiceHighlightingPassFactory(@NotNull Project project, @NotNull TextEditorHighlightingPassRegistrar registrar) {
        if (project == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, new int[]{4}, true, -1);
        this.mySharedCalcHolder = new JSLanguageServiceHighlightingStateHolder();
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (file2 == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(3);
        }
        if (!this.isAcceptablePsiFile(file2)) {
            return null;
        }
        JSLanguageService service = this.getService(file2);
        if (service == null || !this.isAcceptableService(file2, service)) {
            if (!this.mySharedCalcHolder.isInitialized()) {
                return null;
            }
            return new TextEditorHighlightingPass(this.myProject, editor.getDocument()){

                public void doCollectInformation(@NotNull ProgressIndicator progress) {
                    if (progress == null) {
                        1.$$$reportNull$$$0(0);
                    }
                }

                public void doApplyInformationToEditor() {
                    UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myDocument.getTextLength(), (Collection)ContainerUtil.emptyList(), (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPassFactory$1", "doCollectInformation"));
                }
            };
        }
        return new JSLanguageServiceHighlightingPass(this.myProject, service, file2, this.mySharedCalcHolder, editor);
    }

    public boolean isAcceptableService(@NotNull PsiFile file2, @Nullable JSLanguageService service) {
        if (file2 == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(4);
        }
        return service != null && service.isAcceptable(file2.getVirtualFile());
    }

    @Nullable
    protected abstract JSLanguageService getService(@NotNull PsiFile var1);

    protected boolean isAcceptablePsiFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            JSLanguageServiceHighlightingPassFactory.$$$reportNull$$$0(5);
        }
        return file2 instanceof JSFile;
    }

    public void dispose() {
        this.mySharedCalcHolder.reset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/service/highlighting/JSLanguageServiceHighlightingPassFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createHighlightingPass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptableService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAcceptablePsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

