/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.service.JSAsyncLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceToolWindowInfoReporter
implements JSAsyncLanguageServiceBase.JSLanguageServiceInfoReporter {
    private final Project myProject;
    private final String myName;
    @NotNull
    private final JSLanguageServiceToolWindowManager myManager;
    private final boolean myActive;

    public JSLanguageServiceToolWindowInfoReporter(Project project, @NotNull String name, @NotNull JSLanguageServiceToolWindowManager manager2, boolean setActive) {
        if (name == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(0);
        }
        if (manager2 == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myName = name;
        this.myManager = manager2;
        this.myActive = setActive;
    }

    @Override
    @NotNull
    public String getPresentableServiceName() {
        String string = this.myName;
        if (string == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void startingError(@NotNull String errorText) {
        if (errorText == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!this.myProject.isInitialized()) {
                return;
            }
            this.myManager.logCurrentErrors((List<JSAnnotationError>)JSLanguageServiceAnnotationResult.buildError(errorText), this.myActive);
        });
    }

    @Override
    public void setProcess(@Nullable String text) {
        ApplicationManager.getApplication().invokeLater(() -> this.myManager.setProgressText(text), this.myProject.getDisposed());
    }

    @Override
    public void logCurrentErrors(@Nullable VirtualFile virtualFile, @NotNull List<JSAnnotationError> rawResults) {
        if (rawResults == null) {
            JSLanguageServiceToolWindowInfoReporter.$$$reportNull$$$0(4);
        }
        ArrayList<JSAnnotationError> subSorted = new ArrayList<JSAnnotationError>(rawResults);
        ContainerUtil.sort(subSorted, Comparator.comparing(JSAnnotationError::getAbsoluteFilePath));
        ApplicationManager.getApplication().invokeLater(() -> {
            Editor editor = FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor();
            if (editor instanceof EditorEx) {
                VirtualFile editorFile = ((EditorEx)editor).getVirtualFile();
                if (virtualFile == null || virtualFile.equals(editorFile)) {
                    if (editorFile != null) {
                        String editorFilePath = JSLanguageServiceUtil.normalizeNameAndPath(editorFile);
                        ContainerUtil.sort((List)subSorted, Comparator.comparing(el -> Objects.equals(el.getAbsoluteFilePath(), editorFilePath) ? -1 : 0));
                    }
                    this.myManager.logCurrentErrors(subSorted, false);
                }
            }
        }, this.myProject.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableServiceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startingError";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logCurrentErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

