/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSLanguageServiceCacheData;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommand;
import com.intellij.lang.javascript.service.JSLanguageServiceCacheableCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutor;
import com.intellij.lang.javascript.service.JSLanguageServiceExecutorImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceQueueImpl
extends JSLanguageServiceExecutorImpl
implements JSLanguageServiceQueue {
    @NotNull
    private final JSLanguageServiceCacheData myCacheData;

    public JSLanguageServiceQueueImpl(@NotNull Project project, @NotNull JSLanguageServiceProtocol protocol, @Nullable JSLanguageServiceQueue.ProcessConnector connector, @NotNull JSLanguageServiceQueue.ServiceInfoReporter reporter, @NotNull JSLanguageServiceCacheData cacheData) {
        if (project == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(0);
        }
        if (protocol == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(1);
        }
        if (reporter == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(2);
        }
        if (cacheData == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(3);
        }
        super(project, protocol, connector, reporter);
        this.myCacheData = cacheData;
        LowMemoryWatcher.register(this::resetCaches, (Disposable)this);
    }

    @Override
    public void resetCaches() {
        this.myCacheData.clear();
    }

    @Override
    @Nullable
    public final <T> CompletableFuture<T> executeWithCache(@NotNull JSLanguageServiceCacheableCommand input, @NotNull JSLanguageServiceCacheableCommandProcessor<? extends T> processor) {
        if (input == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(5);
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
                    return null;
                }
                try {
                    Object t = this.executeWithCacheImpl(input, processor);
                    return t;
                }
                catch (Throwable err) {
                    LOGGER.error(err.getMessage(), err);
                }
                finally {
                    this.endAction();
                }
                return null;
            }, this.myExecutorService);
        }
        catch (RejectedExecutionException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Nullable
    private <T> T executeWithCacheImpl(@NotNull JSLanguageServiceCacheableCommand input, @NotNull JSLanguageServiceCacheableCommandProcessor<T> processor) {
        if (input == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(7);
        }
        long startTime = System.currentTimeMillis();
        Object valueFromCache = this.myCacheData.getValueFromCache(input);
        if (valueFromCache != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Used service cache " + input);
            }
            return processor.processFromCache(input, valueFromCache);
        }
        JSLanguageServiceObject objectToSend = this.myCacheData.updateCacheAndGetServiceObject(input);
        if (objectToSend == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skip processing: " + input);
            }
            return null;
        }
        this.startAction(input);
        JSLanguageServiceAnswer answer = this.await(input, objectToSend);
        if (answer == null || answer.isEmpty() || this.myState != JSLanguageServiceExecutor.State.STARTED) {
            LOGGER.debug("There is no result");
            this.myCacheData.putCacheValue(input, answer, null);
            return null;
        }
        T result2 = processor.process(input, objectToSend, answer);
        this.myCacheData.putCacheValue(input, answer, result2);
        if (LOGGER.isDebugEnabled()) {
            long totalTime = System.currentTimeMillis() - startTime;
            LOGGER.debug("Total process queue command " + input.getCommand() + " time, millis: " + totalTime);
        }
        return result2;
    }

    @Override
    @Nullable
    public final <T> CompletableFuture<T> execute(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(9);
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
                    return null;
                }
                try {
                    Object t = this.executeImpl(command, processor);
                    return t;
                }
                finally {
                    this.endAction();
                }
            }, this.myExecutorService);
        }
        catch (RejectedExecutionException exception) {
            LOGGER.warn(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Nullable
    public <T> T executeImpl(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceCommandProcessor<T> processor) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(11);
        }
        long startTime = System.currentTimeMillis();
        JSLanguageServiceObject serviceObject = this.myCacheData.updateCacheAndGetServiceObject(command);
        if (serviceObject == null) {
            return null;
        }
        this.startAction(command);
        JSLanguageServiceAnswer answer = this.await(command, serviceObject);
        if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
            return null;
        }
        if (answer == null) {
            return null;
        }
        T process = processor.process(serviceObject, answer);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Total process queue " + command.getCommand() + " time, millis: " + (System.currentTimeMillis() - startTime));
        }
        return process;
    }

    @Override
    @Nullable
    public CompletableFuture<Void> executeNoBlocking(@NotNull JSLanguageServiceCommand command, @Nullable Consumer<? super JSLanguageServiceAnswer> answerConsumer) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(12);
        }
        return this.executeNoBlocking(command, answerConsumer, null);
    }

    @Override
    @Nullable
    public final CompletableFuture<Void> executeNoBlocking(@NotNull JSLanguageServiceCommand command, @Nullable Consumer<? super JSLanguageServiceAnswer> answerConsumer, @Nullable Consumer<? super JSLanguageServiceObject> serviceObjectConsumer) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(13);
        }
        try {
            return CompletableFuture.supplyAsync(() -> {
                if (this.myState != JSLanguageServiceExecutor.State.STARTED) {
                    return null;
                }
                if (answerConsumer != null) {
                    this.startAction(command);
                }
                try {
                    this.executeNoBlockingImpl(command, answerConsumer, serviceObjectConsumer);
                }
                catch (IOException e) {
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    LOGGER.error(throwable.getMessage(), throwable);
                }
                return null;
            }, this.myExecutorService);
        }
        catch (RejectedExecutionException exception) {
            LOGGER.debug(exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    private void executeNoBlockingImpl(final @NotNull JSLanguageServiceCommand command, final @Nullable Consumer<? super JSLanguageServiceAnswer> consumer, @Nullable Consumer<? super JSLanguageServiceObject> afterSendData) throws Exception {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(14);
        }
        final long startTime = System.currentTimeMillis();
        JSLanguageServiceObject serviceObject = this.myCacheData.updateCacheAndGetServiceObject(command);
        if (serviceObject == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Send data for: " + command.getCommand());
        }
        this.sendData(command, serviceObject, consumer == null ? null : new JSLanguageServiceAnswerConsumer(){

            @Override
            public void consume(JSLanguageServiceAnswer message) {
                if (JSLanguageServiceQueueImpl.this.myState != JSLanguageServiceExecutor.State.STARTED) {
                    return;
                }
                JSLanguageServiceQueueImpl.this.endAction();
                if (message != null) {
                    consumer.consume((Object)message);
                    if (JSLanguageServiceQueue.LOGGER.isDebugEnabled()) {
                        long processingTime = System.currentTimeMillis() - startTime;
                        JSLanguageServiceQueue.LOGGER.debug("Total process queue non-blocking command " + command.getCommand() + " time, millis: " + processingTime);
                    }
                }
            }
        });
        if (afterSendData != null) {
            afterSendData.consume((Object)serviceObject);
        }
    }

    @Nullable
    private JSLanguageServiceAnswer await(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(15);
        }
        if (data == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(16);
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Start await \"" + command.getCommand() + "\"");
            }
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference ref = new AtomicReference();
            Object cancellationToken = this.sendData(command, data, new JSLanguageServiceAnswerConsumer(){

                @Override
                public void consume(JSLanguageServiceAnswer message) {
                    ref.set(message);
                    latch.countDown();
                }
            });
            if (JSLanguageServiceUtil.TIMEOUT_DISABLED) {
                latch.await();
            } else if (!latch.await(command.getTimeout(), TimeUnit.MILLISECONDS)) {
                this.handleCommandTimeout(command, cancellationToken);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Language Service answer was received: " + command.getCommand());
            }
            return (JSLanguageServiceAnswer)ref.get();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        catch (Throwable err) {
            LOGGER.error(err.getMessage(), err);
        }
        return null;
    }

    protected void handleCommandTimeout(@NotNull JSLanguageServiceCommand command, @NotNull Object cancellationToken) {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(17);
        }
        if (cancellationToken == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(18);
        }
        this.getProtocol().cancelCommand(cancellationToken);
        this.infoLog("Timeout waiting answer for: " + command.getCommand());
    }

    @NotNull
    protected Object sendData(@NotNull JSLanguageServiceCommand command, @NotNull JSLanguageServiceObject data, @Nullable JSLanguageServiceAnswerConsumer consumer) throws Exception {
        if (command == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(19);
        }
        if (data == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(20);
        }
        Object object = this.getProtocol().sendCommand(command, data, consumer);
        if (object == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(21);
        }
        return object;
    }

    @Override
    protected void doDispose() {
        super.doDispose();
        Disposer.dispose((Disposable)this.myCacheData);
    }

    @Override
    @NotNull
    public JSLanguageServiceProtocol getProtocol() {
        JSLanguageServiceProtocol jSLanguageServiceProtocol = (JSLanguageServiceProtocol)this.myServiceConnector;
        if (jSLanguageServiceProtocol == null) {
            JSLanguageServiceQueueImpl.$$$reportNull$$$0(22);
        }
        return jSLanguageServiceProtocol;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheData";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancellationToken";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceQueueImpl";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "sendData";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "executeWithCache";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeWithCacheImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeNoBlocking";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "executeNoBlockingImpl";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "await";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "handleCommandTimeout";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "sendData";
                break;
            }
            case 21: 
            case 22: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

