/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSFileHighlightingInfo;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class JSHighlightingInfoBuilder {
    @NotNull
    public static JSFileHighlightingInfo createInfoWithUnSavedFiles(@NotNull Project project, @NotNull VirtualFile currentVirtualFile, @NotNull Condition<VirtualFile> filesFilter) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(0);
        }
        if (currentVirtualFile == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(1);
        }
        if (filesFilter == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        JSLanguageServiceUpdateContext context = JSHighlightingInfoBuilder.createUpdateContext(project, filesFilter);
        return new JSFileHighlightingInfo(currentVirtualFile, context);
    }

    @NotNull
    public static JSLanguageServiceUpdateContext createUpdateContext(@NotNull Project project, @NotNull Condition<VirtualFile> filesFilter) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(3);
        }
        if (filesFilter == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashMap<VirtualFile, Document> nameToUnsavedContent = new HashMap<VirtualFile, Document>();
        HashMap<VirtualFile, Document> nameToOpenContent = new HashMap<VirtualFile, Document>();
        HashMap<VirtualFile, Long> nameToTimestamps = new HashMap<VirtualFile, Long>();
        JSHighlightingInfoBuilder.fillByUnsavedDocuments(project, nameToUnsavedContent, nameToTimestamps, filesFilter);
        JSHighlightingInfoBuilder.fillByOpenedEditors(project, nameToOpenContent, nameToTimestamps, filesFilter);
        return new JSLanguageServiceUpdateContext(nameToUnsavedContent, nameToOpenContent, nameToTimestamps);
    }

    private static void fillByOpenedEditors(@NotNull Project project, @NotNull Map<VirtualFile, Document> nameToContent, @NotNull Map<VirtualFile, Long> nameToTimestamps, @NotNull Condition<VirtualFile> filesFilter) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(5);
        }
        if (nameToContent == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(6);
        }
        if (nameToTimestamps == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(7);
        }
        if (filesFilter == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(8);
        }
        Map<VirtualFile, Document> filteredFiles = JSHighlightingInfoBuilder.getFilteredOpenedFiles(project, filesFilter);
        for (Map.Entry<VirtualFile, Document> entry : filteredFiles.entrySet()) {
            VirtualFile processedOpenedFile = entry.getKey();
            Document document2 = entry.getValue();
            nameToContent.put(processedOpenedFile, document2);
            if (nameToTimestamps.containsKey(processedOpenedFile)) continue;
            long processedStamp = JSHighlightingInfoBuilder.getTimestamp(processedOpenedFile, document2);
            nameToTimestamps.put(processedOpenedFile, processedStamp);
        }
    }

    public static long getTimestamp(@NotNull VirtualFile openedFile, @NotNull Document document2) {
        long processedDocumentModificationStamp;
        long processedStamp;
        if (openedFile == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(9);
        }
        if (document2 == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(10);
        }
        if ((processedStamp = openedFile.getModificationStamp()) < (processedDocumentModificationStamp = document2.getModificationStamp())) {
            processedStamp = processedDocumentModificationStamp;
        }
        return processedStamp;
    }

    private static void fillByUnsavedDocuments(@NotNull Project project, @NotNull Map<VirtualFile, Document> nameToContent, @NotNull Map<VirtualFile, Long> nameToTimestamps, @NotNull Condition<VirtualFile> filter) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(11);
        }
        if (nameToContent == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(12);
        }
        if (nameToTimestamps == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(13);
        }
        if (filter == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(14);
        }
        FileDocumentManager manager2 = FileDocumentManager.getInstance();
        GlobalSearchScope scope = ProjectScope.getAllScope((Project)project);
        for (Document document2 : manager2.getUnsavedDocuments()) {
            VirtualFile virtualFile = manager2.getFile(document2);
            if (virtualFile == null || !filter.value((Object)virtualFile) || !scope.accept(virtualFile)) continue;
            nameToContent.put(virtualFile, document2);
            nameToTimestamps.put(virtualFile, document2.getModificationStamp());
        }
    }

    @NotNull
    public static Pair<String, String> getModuleInfo(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(15);
        }
        if (file2 == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(16);
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        VirtualFile contentRoot = projectFileIndex.getContentRootForFile(file2);
        String contentRootPath = null;
        if (contentRoot != null) {
            contentRootPath = JSLanguageServiceUtil.normalizeNameAndPath(contentRoot.getPath());
        }
        VirtualFile sourceRoot = projectFileIndex.getSourceRootForFile(file2);
        String sourceRootPath = null;
        if (sourceRoot != null) {
            sourceRootPath = JSLanguageServiceUtil.normalizeNameAndPath(sourceRoot.getPath());
        }
        Pair pair = Pair.create((Object)contentRootPath, sourceRootPath);
        if (pair == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(17);
        }
        return pair;
    }

    @NotNull
    public static String toPath(@NotNull VirtualFile configFile) {
        if (configFile == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(18);
        }
        String string = FileUtil.toSystemDependentName((String)configFile.getPath());
        if (string == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static Map<VirtualFile, Document> getFilteredOpenedFiles(@NotNull Project project, @NotNull Condition<? super VirtualFile> filesFilter) {
        if (project == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(20);
        }
        if (filesFilter == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(21);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        HashMap<VirtualFile, Document> filesToOpen = new HashMap<VirtualFile, Document>();
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            VirtualFile vFile;
            Project editorProject = editor.getProject();
            if (editorProject != project || !(editor instanceof EditorEx) || editor.getProject() != editorProject || (vFile = ((EditorEx)editor).getVirtualFile()) == null || !filesFilter.value((Object)vFile)) continue;
            filesToOpen.put(vFile, editor.getDocument());
        }
        HashMap<VirtualFile, Document> hashMap = filesToOpen;
        if (hashMap == null) {
            JSHighlightingInfoBuilder.$$$reportNull$$$0(22);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentVirtualFile";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesFilter";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToContent";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameToTimestamps";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openedFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSHighlightingInfoBuilder";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleInfo";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "toPath";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredOpenedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createInfoWithUnSavedFiles";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fillByOpenedEditors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTimestamp";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillByUnsavedDocuments";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModuleInfo";
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "toPath";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredOpenedFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

