/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.util;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.ide.util.PlatformPackageUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.ECMAScriptImportOptimizer;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.macro.JSSuggestVariableNameMacro;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionDeclaration;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSStatementExpressionOwner;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureUtil;
import com.intellij.lang.javascript.refactoring.util.JSFunctionsRefactoringUtil;
import com.intellij.lang.javascript.refactoring.util.JSMemberUsageInfo;
import com.intellij.lang.javascript.types.TypeFromUsageDetector;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.lang.javascript.validation.fixes.ImplementMethodsFix;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRefactoringUtil {
    public static final String _PROTO = "__proto__";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil");
    public static final String ABSTRACT_DOC_COMMENT = "/**\n*  @abstract\n*/";
    private static final String TEMPLATE_VAR_NAME = "tmp111";
    private static final int MAX_DEPTH_DEF_VALUE = 10;

    @Nullable
    public static JSPsiElementBase tryBuildInterfaceSignature(@NotNull JSElementBase member) {
        if (member == null) {
            JSRefactoringUtil.$$$reportNull$$$0(0);
        }
        if (member instanceof JSVariable) {
            return JSRefactoringUtil.buildInterfaceProperty((JSVariable)member);
        }
        if (member instanceof JSFunction) {
            return JSRefactoringUtil.buildInterfaceSignature((JSFunction)member);
        }
        return null;
    }

    @NotNull
    public static TypeScriptPropertySignature buildInterfaceProperty(@NotNull JSVariable member) {
        if (member == null) {
            JSRefactoringUtil.$$$reportNull$$$0(1);
        }
        assert (!DialectDetector.isActionScript((PsiElement)member));
        JSVariable copy = member.getParent() instanceof JSVarStatement ? ((JSVarStatement)member.getParent().copy()).getVariables()[0] : (JSVariable)member.copy();
        JSRefactoringUtil.specifyInferredReturnTypeExplicitly((JSNamedElement)copy, copy.getTypeElement());
        JSRefactoringUtil.removeInitializer((JSInitializerOwner)copy);
        JSRefactoringUtil.removeDecorators((JSAttributeListOwner)copy);
        JSAttributeListWrapper attributeListWrapper = new JSAttributeListWrapper((JSAttributeListOwner)copy);
        attributeListWrapper.removeAccessModifier();
        attributeListWrapper.applyTo((JSAttributeListOwner)copy);
        return JSRefactoringUtil.buildInterfacePropertyFromText((JSElement)member, copy.getText());
    }

    @NotNull
    public static TypeScriptPropertySignature buildInterfacePropertyFromText(@NotNull JSElement context, @NotNull String propertyText) {
        if (context == null) {
            JSRefactoringUtil.$$$reportNull$$$0(2);
        }
        if (propertyText == null) {
            JSRefactoringUtil.$$$reportNull$$$0(3);
        }
        TypeScriptInterface clazz = (TypeScriptInterface)JSRefactoringUtil.buildClassOrInterface(context, (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class), "interface", propertyText);
        TypeScriptPropertySignature typeScriptPropertySignature = (TypeScriptPropertySignature)clazz.getBody().getTypeMembers()[0];
        if (typeScriptPropertySignature == null) {
            JSRefactoringUtil.$$$reportNull$$$0(4);
        }
        return typeScriptPropertySignature;
    }

    @NotNull
    public static JSFunction buildAbstractMethodSignature(@NotNull JSFunction method, boolean isTypeScript) {
        if (method == null) {
            JSRefactoringUtil.$$$reportNull$$$0(5);
        }
        JSFunction signature = JSRefactoringUtil.buildFunctionSignature(method, "class", (attributes, owner) -> {
            if (isTypeScript) {
                attributes.overrideModifier(JSAttributeList.ModifierType.ABSTRACT, true);
            } else {
                JSRefactoringUtil.setAbstract((PsiElement)method, owner);
            }
        });
        if (isTypeScript) {
            JSFunction jSFunction = signature;
            if (jSFunction == null) {
                JSRefactoringUtil.$$$reportNull$$$0(6);
            }
            return jSFunction;
        }
        PsiElement child = signature.getLastChild();
        if (child instanceof PsiWhiteSpace || child instanceof PsiComment) {
            child = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)child);
        }
        if (PsiUtilCore.getElementType((PsiElement)child) == JSTokenTypes.SEMICOLON) {
            child.delete();
        }
        signature.addBefore((PsiElement)JSPsiElementFactory.createJSStatement("{}", (PsiElement)signature), null);
        JSFunction jSFunction = signature;
        if (jSFunction == null) {
            JSRefactoringUtil.$$$reportNull$$$0(7);
        }
        return jSFunction;
    }

    @NotNull
    public static JSFunction buildInterfaceSignature(@NotNull JSFunction method) {
        if (method == null) {
            JSRefactoringUtil.$$$reportNull$$$0(8);
        }
        return JSRefactoringUtil.buildFunctionSignature(method, "interface", (attributes, owner) -> attributes.removeAccessModifier());
    }

    @NotNull
    private static JSFunction buildFunctionSignature(@NotNull JSFunction originalMethod, String classKeyword, @NotNull BiConsumer<? super JSAttributeListWrapper, ? super JSAttributeListOwner> configureAttributeList) {
        if (originalMethod == null) {
            JSRefactoringUtil.$$$reportNull$$$0(9);
        }
        if (configureAttributeList == null) {
            JSRefactoringUtil.$$$reportNull$$$0(10);
        }
        JSClass containingClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)originalMethod, JSClass.class);
        JSFunction signature = (JSFunction)originalMethod.copy();
        JSRefactoringUtil.specifyInferredReturnTypeExplicitly((JSNamedElement)signature, signature.getReturnTypeElement());
        JSBlockStatement block = signature.getBlock();
        if (block != null) {
            block.delete();
        }
        if (signature.getLastChild() instanceof PsiWhiteSpace) {
            signature.getLastChild().delete();
        }
        JSAttributeListWrapper wrapper = new JSAttributeListWrapper((JSAttributeListOwner)signature);
        wrapper.overrideModifier(JSAttributeList.ModifierType.FINAL, false);
        wrapper.overrideModifier(JSAttributeList.ModifierType.OVERRIDE, false);
        wrapper.overrideModifier(JSAttributeList.ModifierType.ASYNC, false);
        configureAttributeList.accept(wrapper, (JSAttributeListOwner)signature);
        wrapper.applyTo((JSAttributeListOwner)signature);
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)signature);
        if (dialect != null && dialect.isTypeScript) {
            for (JSParameter parameter : signature.getParameterVariables()) {
                JSRefactoringUtil.removeInitializer((JSInitializerOwner)parameter);
            }
            JSRefactoringUtil.removeDecorators((JSAttributeListOwner)signature);
        }
        JSClass clazz = JSRefactoringUtil.buildClassOrInterface((JSElement)originalMethod, containingClass, classKeyword, signature.getText());
        JSFunction jSFunction = Objects.requireNonNull(clazz.findFunctionByName(signature.getName()));
        if (jSFunction == null) {
            JSRefactoringUtil.$$$reportNull$$$0(11);
        }
        return jSFunction;
    }

    @NotNull
    private static JSClass buildClassOrInterface(@NotNull JSElement context, @Nullable JSClass clazz, @NotNull String classKeyword, @NotNull String memberText) {
        TypeScriptTypeParameterList typeParameterList;
        if (context == null) {
            JSRefactoringUtil.$$$reportNull$$$0(12);
        }
        if (classKeyword == null) {
            JSRefactoringUtil.$$$reportNull$$$0(13);
        }
        if (memberText == null) {
            JSRefactoringUtil.$$$reportNull$$$0(14);
        }
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)context);
        StringBuilder builder = new StringBuilder();
        builder.append(classKeyword);
        builder.append(" Foo ");
        TypeScriptTypeParameterList typeScriptTypeParameterList = typeParameterList = clazz instanceof TypeScriptTypeParameterListOwner ? ((TypeScriptTypeParameterListOwner)clazz).getTypeParameterList() : null;
        if (typeParameterList != null) {
            builder.append(typeParameterList.getText());
        }
        builder.append("{");
        builder.append(memberText);
        builder.append(semicolon);
        builder.append("}");
        JSClass jSClass = JSPsiElementFactory.createJSClass(builder.toString(), (PsiElement)context);
        if (jSClass == null) {
            JSRefactoringUtil.$$$reportNull$$$0(15);
        }
        return jSClass;
    }

    public static void removeInitializer(@NotNull JSInitializerOwner variable) {
        JSExpression initializer;
        PsiElement eqSign;
        if (variable == null) {
            JSRefactoringUtil.$$$reportNull$$$0(16);
        }
        PsiElement psiElement = eqSign = (initializer = variable.getInitializer()) != null ? PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)initializer) : null;
        if (initializer != null && eqSign != null && eqSign.getNode().getElementType() == JSTokenTypes.EQ) {
            variable.deleteChildRange(eqSign, (PsiElement)initializer);
        }
    }

    private static void removeDecorators(@NotNull JSAttributeListOwner copy) {
        JSAttributeList attributeList;
        if (copy == null) {
            JSRefactoringUtil.$$$reportNull$$$0(17);
        }
        if ((attributeList = copy.getAttributeList()) != null) {
            for (ES6Decorator decorator : attributeList.getDecorators()) {
                decorator.delete();
            }
        }
    }

    private static void specifyInferredReturnTypeExplicitly(@NotNull JSNamedElement member, @Nullable PsiElement typeDeclaration) {
        DialectOptionHolder dialect;
        if (member == null) {
            JSRefactoringUtil.$$$reportNull$$$0(18);
        }
        if ((dialect = DialectDetector.dialectOfElement((PsiElement)member)) != null && dialect.isTypeScript && typeDeclaration == null && !TypeScriptPsiUtil.returnTypeAnnotationForbidden((JSElement)member)) {
            JSType inferredType = (JSType)ObjectUtils.coalesce((Object)TypeFromUsageDetector.detectTypeFromUsage((PsiElement)member), (Object)JSAnyType.get((PsiElement)member, true));
            JSRefactoringUtil.setType((JSElement)member, TypeScriptUtil.getShortestTypeNameInContext(inferredType, (PsiElement)member));
        }
    }

    @Nullable
    public static String removeFromReferenceList(@NotNull JSReferenceList refList, @NotNull JSClass aClass, @NotNull Collection<? super FormatFixer> formatters) {
        JSReferenceExpression ref;
        if (refList == null) {
            JSRefactoringUtil.$$$reportNull$$$0(19);
        }
        if (aClass == null) {
            JSRefactoringUtil.$$$reportNull$$$0(20);
        }
        if (formatters == null) {
            JSRefactoringUtil.$$$reportNull$$$0(21);
        }
        if ((ref = JSRefactoringUtil.findReferenceToClass(refList, aClass)) != null) {
            String refText = ref.getText();
            if (XmlBackedJSClassImpl.isImplementsAttribute((JSFile)refList.getContainingFile())) {
                ((XmlBackedJSClassImpl)JSResolveUtil.findParentClass((JSFile)refList.getContainingFile())).removeFromImplementsList(refText);
            } else {
                formatters.add(FormatFixer.create(JSRefactoringUtil.getElementToFormat((PsiElement)ref), FormatFixer.Mode.FirstLinebreak));
                ref.delete();
            }
            return refText;
        }
        return null;
    }

    @Nullable
    private static JSReferenceExpression findReferenceToClass(@NotNull JSReferenceList refList, @NotNull JSClass aClass) {
        String name;
        if (refList == null) {
            JSRefactoringUtil.$$$reportNull$$$0(22);
        }
        if (aClass == null) {
            JSRefactoringUtil.$$$reportNull$$$0(23);
        }
        if ((name = aClass.getQualifiedName()) == null) {
            return null;
        }
        return JSRefactoringUtil.findReferenceToClass(refList, name);
    }

    @Nullable
    private static JSReferenceExpression findReferenceToClass(@NotNull JSReferenceList refList, @NotNull String name) {
        JSExpression[] expressions;
        if (refList == null) {
            JSRefactoringUtil.$$$reportNull$$$0(24);
        }
        if (name == null) {
            JSRefactoringUtil.$$$reportNull$$$0(25);
        }
        if ((expressions = refList.getExpressions()).length == 0) {
            return null;
        }
        for (JSExpression expression : expressions) {
            String typeName;
            if (!(expression instanceof JSReferenceExpression) || !name.equals(typeName = JSImportHandlingUtil.resolveTypeName(expression.getText(), (PsiElement)refList))) continue;
            return (JSReferenceExpression)expression;
        }
        return null;
    }

    public static void addToSupersList(@NotNull JSClass clazz, @Nullable String refText, boolean isInterface) {
        JSReferenceList newReferenceList;
        JSReferenceList existing;
        if (clazz == null) {
            JSRefactoringUtil.$$$reportNull$$$0(26);
        }
        if (refText == null) {
            return;
        }
        if (clazz instanceof XmlBackedJSClassImpl) {
            ((XmlBackedJSClassImpl)clazz).addToImplementsList(refText);
            return;
        }
        boolean addToExtends = clazz.isInterface() || !isInterface;
        JSReferenceList jSReferenceList = existing = addToExtends ? clazz.getExtendsList() : clazz.getImplementsList();
        if (existing != null && JSRefactoringUtil.findReferenceToClass(existing, refText) != null) {
            return;
        }
        String text = "class Foo " + (addToExtends ? "extends " : "implements ") + refText;
        JSClass c = JSPsiElementFactory.createJSClass(text, (PsiElement)clazz);
        JSReferenceList jSReferenceList2 = newReferenceList = addToExtends ? c.getExtendsList() : c.getImplementsList();
        if (newReferenceList == null) {
            return;
        }
        if (existing != null) {
            if (existing.getExpressions().length > 0) {
                existing.addAfter(JSChangeUtil.createCommaPsiElement((PsiElement)existing), existing.getLastChild());
            }
            existing.addAfter((PsiElement)newReferenceList.getExpressions()[0], existing.getLastChild());
        } else {
            TypeScriptTypeParameterList typeParameterList = clazz instanceof TypeScriptTypeParameterListOwner ? ((TypeScriptTypeParameterListOwner)clazz).getTypeParameterList() : null;
            ASTNode keywordNode = clazz.getNode().findChildByType(clazz.isInterface() ? JSTokenTypes.INTERFACE_KEYWORD : JSTokenTypes.CLASS_KEYWORD);
            List<PsiElement> candidates = Arrays.asList(clazz.getExtendsList(), typeParameterList, clazz.getNameIdentifier(), keywordNode != null ? keywordNode.getPsi() : null);
            clazz.addAfter((PsiElement)newReferenceList, (PsiElement)ObjectUtils.coalesce(candidates));
        }
    }

    public static void makeQualified(@NotNull JSReferenceExpression refExpr, @Nullable JSQualifiedNamedElement to, boolean force) {
        if (refExpr == null) {
            JSRefactoringUtil.$$$reportNull$$$0(27);
        }
        JSExpression qualifier = refExpr.getQualifier();
        if (to != null) {
            if (qualifier == null) {
                qualifier = JSPsiElementFactory.createJSExpression("IntellijIDEARulezz.IntellijIDEARulezz", (PsiElement)refExpr);
                qualifier = (JSExpression)refExpr.addRangeBefore(qualifier.getFirstChild(), qualifier.getFirstChild().getNextSibling(), refExpr.getFirstChild());
            }
            if (force || qualifier instanceof JSReferenceExpression) {
                if (qualifier instanceof JSReferenceExpression) {
                    JSRefactoringUtil.makeQualified((JSReferenceExpression)qualifier, null, false);
                    JSReferenceExpressionImpl.bindToElement((JSReferenceExpression)qualifier, to.getQualifiedName(), (PsiNamedElement)to, true);
                } else {
                    JSRefactoringUtil.makeQualified(refExpr, null, false);
                    JSRefactoringUtil.makeQualified(refExpr, to, false);
                }
            }
        } else if (qualifier != null) {
            PsiElement rangeEnd = PsiTreeUtil.findSiblingForward((PsiElement)qualifier, (IElementType)JSTokenTypes.DOT, null);
            if (rangeEnd == null) {
                rangeEnd = qualifier;
            }
            refExpr.deleteChildRange((PsiElement)qualifier, rangeEnd);
        }
    }

    public static boolean isChildOfAny(PsiElement element, Collection<? extends PsiElement> ancestors) {
        for (PsiElement psiElement : ancestors) {
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)element, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOrWillBeInTargetClass(PsiElement place, Collection<? extends PsiElement> membersToMove, @Nullable JSClass targetClass, boolean includeSubclasses) {
        if (JSRefactoringUtil.isChildOfAny(place, membersToMove)) {
            return true;
        }
        JSClass clazz = JSResolveUtil.getClassOfContext(place);
        if (clazz == null || targetClass == null) {
            return false;
        }
        return targetClass.equals(clazz) || includeSubclasses && JSInheritanceUtil.isParentClass(clazz, targetClass);
    }

    public static JSVarStatement getVarStatementCopy(@NotNull JSVariable member) {
        if (member == null) {
            JSRefactoringUtil.$$$reportNull$$$0(28);
        }
        int index = 0;
        for (JSVariable variable : (JSVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)member.getParent(), JSVariable.class)) {
            if (member == variable) break;
            ++index;
        }
        JSVarStatement result2 = (JSVarStatement)member.getParent().copy();
        JSVariable[] newVars = (JSVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)result2, JSVariable.class);
        assert (newVars != null);
        JSVariable newVar = newVars[index];
        while (newVars != null && newVars.length > 1) {
            if (newVars[0] != newVar) {
                newVars[0].delete();
            } else {
                newVars[1].delete();
            }
            newVars = (JSVariable[])PsiTreeUtil.getChildrenOfType((PsiElement)result2, JSVariable.class);
        }
        return result2;
    }

    @Nullable
    private static JSMemberUsageInfo getUsage(JSAttributeListOwner member, PsiReference psiReference, Collection<? extends JSAttributeListOwner> membersToMove, JSClass targetClass) {
        PsiElement ref = psiReference.getElement();
        if (!(ref instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression refExpr = (JSReferenceExpression)ref;
        JSExpression qualifier = refExpr.getQualifier();
        if (JSRefactoringUtil.isOrWillBeInTargetClass((PsiElement)refExpr, membersToMove, targetClass, true)) {
            if (!JSRefactoringUtil.isChildOfAny((PsiElement)refExpr, membersToMove)) {
                return new JSMemberUsageInfo(member, refExpr, null, psiReference);
            }
            if (qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).isReferenceTo((PsiElement)JSUtils.getMemberContainingClass((PsiElement)member))) {
                return new JSMemberUsageInfo(member, refExpr, null, psiReference);
            }
            return null;
        }
        return new JSMemberUsageInfo(member, refExpr, targetClass, psiReference);
    }

    public static UsageInfo[] getUsages(Collection<? extends JSAttributeListOwner> members, JSClass targetClass) {
        ArrayList<JSMemberUsageInfo> usagesList = new ArrayList<JSMemberUsageInfo>();
        for (JSAttributeListOwner jSAttributeListOwner : members) {
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)jSAttributeListOwner)) {
                JSMemberUsageInfo usage = JSRefactoringUtil.getUsage(jSAttributeListOwner, psiReference, members, targetClass);
                if (usage == null) continue;
                usagesList.add(usage);
            }
        }
        UsageInfo[] usageInfos = usagesList.toArray(UsageInfo.EMPTY_ARRAY);
        usageInfos = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        return usageInfos;
    }

    @Nullable
    public static JSNamespaceDeclaration getNamespace(PsiElement element) {
        PsiElement namespace;
        JSReferenceExpression namespaceRef;
        JSAttributeList attributeList;
        if (element instanceof JSAttributeListOwner && (attributeList = ((JSAttributeListOwner)element).getAttributeList()) != null && (namespaceRef = attributeList.getNamespaceElement()) != null && (namespace = namespaceRef.resolve()) instanceof JSNamespaceDeclaration) {
            return (JSNamespaceDeclaration)namespace;
        }
        return null;
    }

    public static void postProcess(@Nullable PsiElement sourceClassOrFile, JSQualifiedNamedElement targetClass, Collection<? extends PsiFile> filesWithExternalUsages, Collection<String> importsInTargetFile, Collection<String> namespacesInTargetFile, List<FormatFixer> postponedFormatters, boolean allowFormat, boolean forceOptimizeImports) {
        String targetFqn;
        String targetPackageName;
        if (sourceClassOrFile != null) {
            PsiFile sourceFile = sourceClassOrFile instanceof JSClass ? (sourceClassOrFile instanceof XmlBackedJSClass ? sourceClassOrFile.getParent().getContainingFile() : sourceClassOrFile.getContainingFile()) : (PsiFile)sourceClassOrFile;
            postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(sourceFile));
        }
        String string = targetPackageName = (targetFqn = targetClass.getQualifiedName()) == null ? null : StringUtil.getPackageName((String)targetFqn);
        if (!StringUtil.isEmpty((String)targetPackageName)) {
            for (PsiFile psiFile : filesWithExternalUsages) {
                Object place = psiFile instanceof JSFile ? JSPsiImplUtils.findPackageStatement((JSFile)psiFile) : XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)psiFile);
                if (place == null) continue;
                String placeFqn = place.getQualifiedName();
                if (placeFqn == null || !targetPackageName.equals(StringUtil.getPackageName((String)placeFqn))) {
                    ImportUtils.insertImportStatements((PsiElement)place, Collections.singletonList(targetFqn));
                }
                postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(psiFile));
            }
        }
        ContainerUtil.addIfNotNull(postponedFormatters, (Object)JSRefactoringUtil.addUseNamespaceDirectives(targetClass, namespacesInTargetFile));
        if (!importsInTargetFile.isEmpty() || forceOptimizeImports) {
            PsiFile file3 = targetClass.getContainingFile();
            ImportUtils.insertImportStatements((PsiElement)targetClass, importsInTargetFile);
            postponedFormatters.addAll(ECMAScriptImportOptimizer.executeNoFormat(file3));
        }
        if (allowFormat) {
            JSRefactoringUtil.format(postponedFormatters);
        }
    }

    @Nullable
    public static FormatFixer addUseNamespaceDirectives(JSQualifiedNamedElement targetClass, Collection<String> namespaces) {
        JSUseNamespaceDirective[] existing;
        if (namespaces.isEmpty()) {
            return null;
        }
        JSQualifiedNamedElement container = targetClass;
        if (container.getParent() instanceof JSPackageStatement) {
            container = (JSElement)container.getParent();
        }
        if ((existing = (JSUseNamespaceDirective[])PsiTreeUtil.getChildrenOfType((PsiElement)container, JSUseNamespaceDirective.class)) != null) {
            for (JSUseNamespaceDirective directive : existing) {
                PsiElement resolved;
                JSReferenceExpression ref = directive.getNamespaceReference();
                if (ref == null || !((resolved = ref.resolve()) instanceof JSNamespaceDeclaration)) continue;
                String qName = ((JSNamespaceDeclaration)resolved).getQualifiedName();
                Iterator<String> i = namespaces.iterator();
                while (i.hasNext()) {
                    if (!Objects.equals(qName, i.next())) continue;
                    i.remove();
                    if (!namespaces.isEmpty()) continue;
                    return null;
                }
            }
        }
        ArrayList<String> sortedNamespaces = new ArrayList<String>(namespaces);
        sortedNamespaces.sort((o1, o2) -> -StringUtil.getShortName((String)o1).compareTo(StringUtil.getShortName((String)o2)));
        PsiElement anchor = JSRefactoringUtil.getImportDirectiveAnchor((JSElement)container);
        PsiElement firstAdded = null;
        PsiElement lastAdded = null;
        for (String namespace : sortedNamespaces) {
            String text = "use namespace " + namespace + JSCodeStyleSettings.getSemicolon((PsiElement)targetClass);
            PsiElement newDirective = Objects.requireNonNull(JSChangeUtil.createJSTreeFromTextWithContext(text, (PsiElement)targetClass)).getPsi();
            PsiElement added = container.addBefore(newDirective, anchor);
            if (firstAdded == null) {
                firstAdded = added;
            }
            lastAdded = added;
            anchor = added;
        }
        return firstAdded == null || lastAdded == null ? null : FormatFixer.create(firstAdded, lastAdded, FormatFixer.Mode.Reformat);
    }

    private static PsiElement getImportDirectiveAnchor(JSElement targetClass) {
        PsiElement anchor;
        for (anchor = targetClass instanceof XmlBackedJSClassImpl ? Objects.requireNonNull(((XmlBackedJSClassImpl)targetClass).findFirstScriptTag()).getFirstChild() : ImportUtils.findLBrace(targetClass); anchor instanceof PsiWhiteSpace || anchor instanceof JSImportStatement || anchor != null && !(anchor instanceof JSSourceElement); anchor = anchor.getNextSibling()) {
        }
        return anchor;
    }

    public static void format(List<? extends FormatFixer> postponedFormatters) {
        postponedFormatters = FormatFixer.merge(postponedFormatters);
        FormatFixer.fixAll(postponedFormatters);
    }

    public static PsiElement getElementToFormat(PsiElement element) {
        JSReferenceListMember member;
        if (element instanceof JSVariable && ((JSVarStatement)element.getParent()).getVariables().length == 1) {
            element = element.getParent();
        } else if (element instanceof JSReferenceExpression && element.getParent() instanceof JSReferenceListMember && ((JSReferenceList)(member = (JSReferenceListMember)element.getParent()).getParent()).getExpressions().length == 1) {
            element = member.getParent();
        }
        return element;
    }

    public static JSFunction buildImplementationMethod(JSFunction method, JSClass targetClass) {
        MultiMap types2 = MultiMap.createSet();
        for (String type : BaseCreateMembersFix.getFunctionTypes(method)) {
            String resolved = JSImportHandlingUtil.resolveTypeName(type, (PsiElement)method);
            if (type.indexOf(46) == -1 && type.equals(resolved)) continue;
            types2.putValue((Object)JSResolveUtil.getShortTypeName(type, false), (Object)resolved);
        }
        ImplementMethodsFix fix = new ImplementMethodsFix(targetClass);
        String text = fix.buildFunctionText(method, (MultiMap<String, String>)types2);
        PsiElement element = Objects.requireNonNull(JSChangeUtil.createJSTreeFromTextWithContext(text, (PsiElement)method)).getPsi();
        return (JSFunction)element;
    }

    public static void addRemovalFormatters(JSClass sourceClass, Collection<? extends PsiElement> movedMembers, Condition<? super JSFunction> withMethodsAsdoc, Condition<? super JSVariable> withFieldsAsdoc, List<? super FormatFixer> result2) {
        ArrayList<PsiElement> removed = new ArrayList<PsiElement>();
        for (PsiElement psiElement : movedMembers) {
            PsiElement comment;
            if ((psiElement instanceof JSFunction && !withMethodsAsdoc.value((Object)((JSFunction)psiElement)) || psiElement instanceof JSVariable && !withFieldsAsdoc.value((Object)((JSVariable)psiElement))) && (comment = JSRefactoringUtil.findDocComment(psiElement)) != null) {
                removed.add(comment);
            }
            removed.add(JSRefactoringUtil.getElementToFormat(psiElement));
        }
        if (sourceClass instanceof XmlBackedJSClassImpl) {
            ((XmlBackedJSClassImpl)sourceClass).processInjectedFiles((Processor<? super JSFile>)((Processor)jsFile -> {
                JSRefactoringUtil.processParent((PsiElement)jsFile, movedMembers, result2, removed);
                return true;
            }));
        } else {
            JSRefactoringUtil.processParent((PsiElement)sourceClass, movedMembers, result2, removed);
        }
    }

    private static void processParent(PsiElement parent, Collection<? extends PsiElement> movedMembers, List<? super FormatFixer> result2, Collection<PsiElement> removed) {
        PsiElement from = null;
        PsiElement to = null;
        for (PsiElement e = parent.getFirstChild(); e != null; e = e.getNextSibling()) {
            boolean elementWillBeRemoved;
            if (e instanceof JSVarStatement) {
                elementWillBeRemoved = true;
                for (JSVariable var : ((JSVarStatement)e).getVariables()) {
                    if (movedMembers.contains(var)) continue;
                    elementWillBeRemoved = false;
                    break;
                }
            } else {
                elementWillBeRemoved = removed.contains(e);
            }
            if (elementWillBeRemoved) {
                if (from == null) {
                    from = e;
                }
                to = e;
                continue;
            }
            if (e instanceof PsiWhiteSpace || from == null) continue;
            result2.add(FormatFixer.create(from, to, FormatFixer.Mode.FirstLinebreak));
            to = null;
            from = null;
        }
        if (from != null) {
            result2.add(FormatFixer.create(from, to, FormatFixer.Mode.FirstLinebreak));
        }
    }

    public static void deleteWithNoPostponedFormatting(PsiElement toDelete) {
        PostprocessReformattingAspect.getInstance((Project)toDelete.getProject()).disablePostprocessFormattingInside(() -> toDelete.delete());
    }

    public static PsiElement findDocComment(PsiElement element) {
        PsiElement elementForWhichPreviousCommentWillBeSearched = JSDocumentationProvider.findElementForWhichPreviousCommentWillBeSearched(element, null);
        if (elementForWhichPreviousCommentWillBeSearched == null) {
            return null;
        }
        PsiComment comment = JSDocumentationUtils.findDocComment(elementForWhichPreviousCommentWillBeSearched);
        return comment instanceof JSDocComment ? comment : null;
    }

    @Nullable
    @NlsContexts.DialogMessage
    private static String checkCanCreateFile(PsiDirectory directory, String className2) {
        for (VirtualFile file2 : directory.getVirtualFile().getChildren()) {
            if (!className2.equals(file2.getNameWithoutExtension()) || !FileTypeManager.getInstance().isFileOfType(file2, (FileType)JavaScriptSupportLoader.JAVASCRIPT) && !JavaScriptSupportLoader.isMxmlOrFxgFile(file2)) continue;
            return JavaScriptBundle.message((String)"directory.already.contains.file", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl(), file2.getName()});
        }
        return null;
    }

    @Nullable
    private static Pair<PsiElement, Boolean> getMemberInsertionAnchor(@NotNull PsiElement membersHolder, @NotNull Condition<? super PsiElement> isFunction, @NotNull Condition<? super PsiElement> isField, @NotNull Condition<? super PsiElement> toSkip, boolean forField) {
        PsiElement result2;
        if (membersHolder == null) {
            JSRefactoringUtil.$$$reportNull$$$0(29);
        }
        if (isFunction == null) {
            JSRefactoringUtil.$$$reportNull$$$0(30);
        }
        if (isField == null) {
            JSRefactoringUtil.$$$reportNull$$$0(31);
        }
        if (toSkip == null) {
            JSRefactoringUtil.$$$reportNull$$$0(32);
        }
        if (membersHolder instanceof XmlBackedJSClassImpl) {
            result2 = ((XmlBackedJSClassImpl)membersHolder).createOrGetFirstScriptTag().getFirstChild();
        } else {
            ASTNode lBrace = membersHolder.getNode().findChildByType(JSTokenTypes.LBRACE);
            PsiElement psiElement = result2 = lBrace != null ? lBrace.getPsi() : null;
        }
        if (result2 == null) {
            return null;
        }
        PsiElement e = result2;
        while (e != null) {
            if (toSkip.value((Object)e)) {
                result2 = e;
            } else if (isFunction.value((Object)e)) {
                if (forField) {
                    return Pair.create((Object)e, (Object)true);
                }
                result2 = e;
            } else if (isField.value((Object)e)) {
                result2 = e;
            }
            e = PsiTreeUtil.skipWhitespacesForward((PsiElement)e);
        }
        PsiElement next = PsiTreeUtil.skipWhitespacesForward((PsiElement)result2);
        if (next == null) {
            return null;
        }
        if (next.getNode().getElementType() == JSTokenTypes.RBRACE) {
            return Pair.create((Object)next, (Object)true);
        }
        return Pair.create((Object)result2, (Object)false);
    }

    public static PsiElement addMemberToTargetClass(@NotNull JSClass clazz, @NotNull PsiElement element) {
        if (clazz == null) {
            JSRefactoringUtil.$$$reportNull$$$0(33);
        }
        if (element == null) {
            JSRefactoringUtil.$$$reportNull$$$0(34);
        }
        return JSRefactoringUtil.addMemberToMemberHolder((PsiElement)clazz, element, (PsiElement)(clazz instanceof TypeScriptInterface ? ((TypeScriptInterface)clazz).getBody() : clazz));
    }

    public static PsiElement addMemberToMemberHolder(@NotNull PsiElement originalContext, @NotNull PsiElement element, PsiElement membersHolder) {
        Condition toSkip;
        Condition fieldFilter;
        Condition functionFilter;
        Pair<PsiElement, Boolean> anchor;
        if (originalContext == null) {
            JSRefactoringUtil.$$$reportNull$$$0(35);
        }
        if (element == null) {
            JSRefactoringUtil.$$$reportNull$$$0(36);
        }
        if ((anchor = JSRefactoringUtil.getMemberInsertionAnchor(membersHolder, (Condition<? super PsiElement>)(functionFilter = e -> originalContext instanceof TypeScriptInterface ? e instanceof TypeScriptTypeMember && !(e instanceof TypeScriptPropertySignature) : e instanceof JSFunction), (Condition<? super PsiElement>)(fieldFilter = e -> e instanceof JSVarStatement || e instanceof TypeScriptPropertySignature), (Condition<? super PsiElement>)(toSkip = e -> {
            if (originalContext instanceof TypeScriptInterface || originalContext instanceof JSObjectLiteralExpression) {
                IElementType elementType = e.getNode().getElementType();
                return elementType == JSTokenTypes.COMMA || elementType == JSTokenTypes.SEMICOLON;
            }
            return JSRefactoringUtil.isEndRegionComment(e);
        }), fieldFilter.value((Object)element))) == null) {
            return membersHolder.add(element);
        }
        if (((Boolean)anchor.second).booleanValue()) {
            return membersHolder.addBefore(element, (PsiElement)anchor.first);
        }
        return membersHolder.addAfter(element, (PsiElement)anchor.first);
    }

    public static boolean isEndRegionComment(PsiElement e) {
        if (!(e instanceof PsiComment)) {
            return false;
        }
        String text = e.getText();
        text = StringUtil.trimStart((String)text, (String)"//");
        text = StringUtil.trimStart((String)text, (String)"/*");
        text = StringUtil.trimEnd((String)text, (String)"*/");
        return text.trim().endsWith("endregion");
    }

    public static void handleDocCommentAndFormat(PsiElement newImmediateMember, List<? super FormatFixer> postponedFormatters) {
        PsiElement reformatTo = newImmediateMember.getNextSibling() instanceof PsiWhiteSpace ? newImmediateMember.getNextSibling() : newImmediateMember;
        postponedFormatters.add(FormatFixer.create(newImmediateMember, reformatTo, FormatFixer.Mode.Reformat));
    }

    public static void setType(@NotNull JSElement declaration, @Nullable String type) {
        PsiElement parent;
        if (declaration == null) {
            JSRefactoringUtil.$$$reportNull$$$0(37);
        }
        if (declaration instanceof JSFunction) {
            JSRefactoringUtil.setFunctionReturnType((JSFunction)declaration, type);
        }
        if (declaration instanceof JSParameterListElement && (parent = JSDestructuringUtil.getParentSkippingDestructuring(declaration)) instanceof JSParameterList && JSFunctionsRefactoringUtil.noBracesAroundSingleParameter((JSParameterList)parent)) {
            JSFunctionDeclaration functionDeclaration = JSPsiElementFactory.createJSSourceElement("function f(" + declaration.getText() + ") {}", parent, JSFunctionDeclaration.class);
            JSParameterList newList = (JSParameterList)parent.replace((PsiElement)Objects.requireNonNull(functionDeclaration.getParameterList()));
            declaration = newList.getParameters()[0];
        }
        if (declaration instanceof JSTypeDeclarationOwner) {
            Object anchor = declaration instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)declaration).getNameIdentifier() : (declaration instanceof JSDestructuringElement ? ((JSDestructuringElement)declaration).getTarget() : null);
            PsiElement nextAnchor = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)anchor);
            IElementType nextType = PsiUtilCore.getElementType((PsiElement)nextAnchor);
            if (nextType == JSTokenTypes.QUEST || nextType == JSTokenTypes.EXCL) {
                anchor = nextAnchor;
            }
            JSRefactoringUtil.setType(declaration, type, ((JSTypeDeclarationOwner)declaration).getTypeElement(), anchor);
        }
    }

    public static void setFunctionReturnType(@NotNull JSFunction declaration, @Nullable String type) {
        if (declaration == null) {
            JSRefactoringUtil.$$$reportNull$$$0(38);
        }
        JSParameterList parameterList = declaration.getParameterList();
        if (type != null && declaration.isArrowFunction() && parameterList != null) {
            parameterList = JSChangeSignatureUtil.addParenthesesIfNeeded(parameterList);
        }
        JSRefactoringUtil.setType((JSElement)declaration, type, declaration.getReturnTypeElement(), (PsiElement)parameterList);
    }

    private static void setType(@NotNull JSElement target, @Nullable String type, @Nullable PsiElement existingTypeElement, @Nullable PsiElement insertionAnchor) {
        if (target == null) {
            JSRefactoringUtil.$$$reportNull$$$0(39);
        }
        if (!DialectDetector.hasFeature((PsiElement)target, JSLanguageFeature.TYPES)) {
            return;
        }
        if (StringUtil.isEmpty((String)type)) {
            if (existingTypeElement != null) {
                PsiElement deleteFrom = existingTypeElement.getPrevSibling();
                while (deleteFrom instanceof PsiWhiteSpace) {
                    deleteFrom = deleteFrom.getPrevSibling();
                }
                target.deleteChildRange(deleteFrom, existingTypeElement);
            }
        } else {
            PsiElement newTypeElement = JSChangeUtil.tryCreateTypeElement(type, (PsiElement)target);
            assert (newTypeElement != null) : String.format("Could not parse type from '%s'", type);
            if (existingTypeElement != null) {
                existingTypeElement.replace(newTypeElement);
            } else {
                target.addRangeAfter(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)newTypeElement), newTypeElement, insertionAnchor);
            }
        }
    }

    public static boolean isResolvableType(String typeText, PsiElement context, boolean allowEmpty, boolean allowEllipsis) {
        if (StringUtil.isEmpty((String)typeText)) {
            return allowEmpty;
        }
        if ("void".equals(typeText) || "*".equals(typeText) || allowEllipsis && "...".equals(typeText)) {
            return true;
        }
        JSResolveUtil.GenericSignature signature = JSResolveUtil.extractGenericSignature(typeText);
        if (signature != null) {
            if (!"Vector".equals(signature.elementType)) {
                return false;
            }
            typeText = signature.genericType;
        }
        return JSResolveUtil.findType(typeText, context, true) != null;
    }

    public static boolean isValidIdentifier(String name, Project project) {
        return !"as".equals(name) && LanguageNamesValidation.isIdentifier((Language)JavascriptLanguage.INSTANCE, (String)name, (Project)project);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static PsiDirectory chooseOrCreateDirectoryForClass(@NotNull Project project, @Nullable Module module, GlobalSearchScope scope, @NotNull String packageName, @Nullable String className2, @Nullable PsiDirectory baseDir, ThreeState chooseFlag) {
        if (project == null) {
            JSRefactoringUtil.$$$reportNull$$$0(40);
        }
        if (packageName == null) {
            JSRefactoringUtil.$$$reportNull$$$0(41);
        }
        LOG.assertTrue(ApplicationManager.getApplication().isDispatchThread());
        if (className2 != null) {
            String qName = StringUtil.getQualifiedName((String)packageName, (String)className2);
            PsiElement clazz = JSDialectSpecificHandlersFactory.forLanguage((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(qName, scope);
            if (clazz != null) {
                String message = JavaScriptBundle.message((String)"item.already.exists", (Object[])new Object[]{new JSNamedElementPresenter(clazz, Capitalization.UpperCase).describeElementKind(), qName});
                Messages.showErrorDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle());
                return null;
            }
        }
        @NlsContexts.DialogMessage Ref error = new Ref();
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(project, () -> {
            try {
                result2.set((Object)PlatformPackageUtil.findOrCreateDirectoryForPackage((Project)project, (Module)module, (GlobalSearchScope)scope, (String)packageName, (PsiDirectory)baseDir, (boolean)true, (ThreeState)chooseFlag));
                if (result2.isNull()) {
                    error.set((Object)"");
                    return;
                }
                if (className2 != null) {
                    error.set((Object)JSRefactoringUtil.checkCanCreateFile((PsiDirectory)result2.get(), className2));
                }
            }
            catch (IncorrectOperationException e) {
                error.set((Object)e.getMessage());
            }
        }, CodeInsightBundle.message((String)"create.directory.command", (Object[])new Object[0]), null);
        if (!error.isNull() && ((String)error.get()).length() > 0) {
            Messages.showErrorDialog((Project)project, (String)((String)error.get()), (String)CommonBundle.getErrorTitle());
            return null;
        }
        return (PsiDirectory)result2.get();
    }

    public static boolean checkReadOnlyStatus(@NotNull PsiElement element, @Nullable Editor editor, @NlsContexts.DialogTitle @NotNull String title) {
        if (element == null) {
            JSRefactoringUtil.$$$reportNull$$$0(42);
        }
        if (title == null) {
            JSRefactoringUtil.$$$reportNull$$$0(43);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)element.getProject(), (PsiElement)element)) {
            return false;
        }
        if (JSProjectUtil.isInLibrary(element)) {
            CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)RefactoringBundle.getCannotRefactorMessage((String)JavaScriptBundle.message((String)"cannot.modify.library.code", (Object[])new Object[0])), (String)StringUtil.capitalizeWords((String)title, (boolean)true), null);
            return false;
        }
        return true;
    }

    public static void addConstructorUsages(JSClass clazz, Collection<? super UsageInfo> result2) {
        JSFunction constructor = clazz.getConstructor();
        if (constructor != null) {
            ReferencesSearch.search((PsiElement)constructor, (SearchScope)constructor.getUseScope()).forEach(psiReference -> {
                PsiElement element = psiReference.getElement();
                if (!(element instanceof JSReferenceExpression)) {
                    return true;
                }
                result2.add((UsageInfo)new ConstructorUsageInfo((JSReferenceExpression)element, clazz));
                return true;
            });
        }
    }

    @Nullable
    @Contract(value="!null,_ -> !null")
    public static String transformVarNameToAccessorName(@Nullable String s, @NotNull PsiElement context) {
        if (context == null) {
            JSRefactoringUtil.$$$reportNull$$$0(44);
        }
        return JSRefactoringUtil.transformVarNameToAccessorName(s, JSCodeStyleSettings.getSettings(context));
    }

    @Nullable
    @Contract(value="!null,_ -> !null")
    public static String transformVarNameToAccessorName(@Nullable String s, JSCodeStyleSettings codeStyleSettings) {
        if (s == null) {
            return null;
        }
        if (StringUtil.startsWith((CharSequence)s, (CharSequence)codeStyleSettings.FIELD_PREFIX)) {
            s = ((String)s).substring(codeStyleSettings.FIELD_PREFIX.length());
        }
        if (StringUtil.startsWith((CharSequence)s, (CharSequence)("\"" + codeStyleSettings.FIELD_PREFIX))) {
            s = "\"" + ((String)s).substring(codeStyleSettings.FIELD_PREFIX.length() + 1);
        }
        if (StringUtil.startsWith((CharSequence)s, (CharSequence)("'" + codeStyleSettings.FIELD_PREFIX))) {
            s = "'" + ((String)s).substring(codeStyleSettings.FIELD_PREFIX.length() + 1);
        }
        s = ((String)s).startsWith("\"") ? "\"" + codeStyleSettings.PROPERTY_PREFIX + ((String)s).substring(1) : (((String)s).startsWith("'") ? "'" + codeStyleSettings.PROPERTY_PREFIX + ((String)s).substring(1) : codeStyleSettings.PROPERTY_PREFIX + (String)s);
        return s;
    }

    @Nullable
    @Contract(value="!null,_ -> !null")
    public static String transformAccessorNameToPropertyName(@Nullable String varName, @NotNull PsiElement context) {
        if (context == null) {
            JSRefactoringUtil.$$$reportNull$$$0(45);
        }
        if (varName == null) {
            return null;
        }
        JSCodeStyleSettings settings = JSCodeStyleSettings.getSettings(context);
        varName = StringUtil.trimStart((String)varName, (String)settings.PROPERTY_PREFIX);
        varName = settings.FIELD_PREFIX + (String)varName;
        return varName;
    }

    public static void reformatElementWithoutBody(@NotNull PsiElement statement, @NotNull PsiElement expression) {
        if (statement == null) {
            JSRefactoringUtil.$$$reportNull$$$0(46);
        }
        if (expression == null) {
            JSRefactoringUtil.$$$reportNull$$$0(47);
        }
        JSRefactoringUtil.createFixerForReformatWithoutBody(statement, expression).fixFormat();
    }

    public static FormatFixer createFixerForReformatWithoutBody(@NotNull PsiElement statement, @NotNull PsiElement expression) {
        PsiComment firstChild;
        if (statement == null) {
            JSRefactoringUtil.$$$reportNull$$$0(48);
        }
        if (expression == null) {
            JSRefactoringUtil.$$$reportNull$$$0(49);
        }
        ASTNode leftBrace = JSRefactoringUtil.getLeftBrace(expression);
        PsiComment jsDoc = JSDocumentationUtils.findDocComment(statement);
        Object object = firstChild = jsDoc instanceof JSDocComment ? jsDoc : statement.getFirstChild();
        if (firstChild != null && leftBrace != null) {
            return FormatFixer.create((PsiElement)firstChild, leftBrace.getPsi(), FormatFixer.Mode.ReformatExactRange);
        }
        return FormatFixer.create(statement, FormatFixer.Mode.Reformat);
    }

    @Nullable
    public static ASTNode getLeftBrace(PsiElement element) {
        JSBlockStatement blockStatement;
        ASTNode leftBrace = element.getNode().findChildByType(JSTokenTypes.LBRACE);
        if (leftBrace == null && (blockStatement = (JSBlockStatement)PsiTreeUtil.findChildOfType((PsiElement)element, JSBlockStatement.class)) != null) {
            leftBrace = blockStatement.getNode().findChildByType(JSTokenTypes.LBRACE);
        }
        return leftBrace;
    }

    public static void deleteSiblingWhitespace(PsiElement element, boolean deleteBefore, boolean deleteAfter) {
        PsiElement sibling = element;
        if (deleteBefore) {
            while ((sibling = sibling.getPrevSibling()) instanceof PsiWhiteSpace) {
                sibling.delete();
            }
        }
        if (deleteAfter) {
            sibling = element;
            while ((sibling = sibling.getNextSibling()) instanceof PsiWhiteSpace) {
                sibling.delete();
            }
        }
    }

    @NotNull
    public static JSElement classDeclarationFromClassExpression(@NotNull JSClass clazz, @NotNull String name, boolean isExport) {
        if (clazz == null) {
            JSRefactoringUtil.$$$reportNull$$$0(50);
        }
        if (name == null) {
            JSRefactoringUtil.$$$reportNull$$$0(51);
        }
        JSClass createdClass = JSPsiElementFactory.createJSClass((isExport ? "export " : "") + "class " + name + "{}", (PsiElement)clazz);
        ASTNode brace = createdClass.getNode().findChildByType(JSTokenTypes.RBRACE);
        assert (brace != null);
        ASTNode[] children = clazz.getNode().getChildren(null);
        boolean afterBracket = false;
        for (ASTNode child : children) {
            if (afterBracket) {
                if (child.getElementType() == JSTokenTypes.RBRACE) break;
                createdClass.addBefore(child.getPsi().copy(), brace.getPsi());
                continue;
            }
            if (child.getElementType() != JSTokenTypes.LBRACE) continue;
            afterBracket = true;
        }
        JSClass jSClass = createdClass;
        if (jSClass == null) {
            JSRefactoringUtil.$$$reportNull$$$0(52);
        }
        return jSClass;
    }

    @NotNull
    public static List<PsiElement> findExistingInScope(@NotNull String name, @Nullable PsiElement scope, boolean processStatics) {
        JSProperty property;
        if (name == null) {
            JSRefactoringUtil.$$$reportNull$$$0(53);
        }
        if (scope == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSRefactoringUtil.$$$reportNull$$$0(54);
            }
            return list2;
        }
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(name, new ResolveResultSink(null, name));
        processor.getAccessibilityProcessingHandler().setProcessStatics(processStatics);
        if (scope instanceof JSClass) {
            processor.configureClassScope((JSClass)scope);
        }
        PsiElement place = scope;
        if (scope instanceof JSObjectLiteralExpression && (property = ((JSObjectLiteralExpression)scope).getFirstProperty()) != null) {
            place = property;
        }
        scope.processDeclarations(processor, ResolveState.initial(), scope, place);
        List list3 = (List)ObjectUtils.notNull(JSResolveResult.toElements(processor.getResultsAsResolveResults()), (Object)ContainerUtil.emptyList());
        if (list3 == null) {
            JSRefactoringUtil.$$$reportNull$$$0(55);
        }
        return list3;
    }

    @NlsContexts.DetailedDescription
    @NotNull
    public static String getMemberAlreadyExistsMessage(@NotNull PsiElement existing) {
        if (existing == null) {
            JSRefactoringUtil.$$$reportNull$$$0(56);
        }
        String description = StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)existing, (boolean)false));
        String string = JavaScriptBundle.message((String)"javascript.introduce.element.already.exists", (Object[])new Object[]{description});
        if (string == null) {
            JSRefactoringUtil.$$$reportNull$$$0(57);
        }
        return string;
    }

    public static void copyDecorators(@NotNull JSAttributeListOwner source, @NotNull JSAttributeListOwner target) {
        if (source == null) {
            JSRefactoringUtil.$$$reportNull$$$0(58);
        }
        if (target == null) {
            JSRefactoringUtil.$$$reportNull$$$0(59);
        }
        JSAttributeList sourceAttributeList = source.getAttributeList();
        JSAttributeList targetAttributeList = target.getAttributeList();
        if (sourceAttributeList == null || targetAttributeList == null) {
            return;
        }
        JSRefactoringUtil.copyDecorators(sourceAttributeList, targetAttributeList);
    }

    public static void copyDecorators(@Nullable JSAttributeList attributeList, @NotNull JSAttributeList newAttributeList) {
        if (newAttributeList == null) {
            JSRefactoringUtil.$$$reportNull$$$0(60);
        }
        if (attributeList == null) {
            return;
        }
        ES6Decorator[] decorators = attributeList.getDecorators();
        if (decorators.length == 0) {
            return;
        }
        ES6Decorator firstToCopy = decorators[0];
        ES6Decorator lastToCopy = decorators[decorators.length - 1];
        while (firstToCopy.getPrevSibling() instanceof PsiWhiteSpace) {
            firstToCopy = firstToCopy.getPrevSibling();
        }
        while (lastToCopy.getNextSibling() instanceof PsiWhiteSpace) {
            lastToCopy = lastToCopy.getNextSibling();
        }
        newAttributeList.addRange((PsiElement)firstToCopy, (PsiElement)lastToCopy);
    }

    public static void addBracesToShorthandArrowFunction(@NotNull JSFunctionExpression function2) {
        List prefixElements;
        if (function2 == null) {
            JSRefactoringUtil.$$$reportNull$$$0(61);
        }
        Project project = function2.getProject();
        PsiFile psiFile = function2.getContainingFile();
        ASTNode arrow = JSPsiImplUtils.getFunctionArrowNode((JSFunction)function2);
        if (arrow == null) {
            return;
        }
        JSExpression expression = JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)function2);
        if (expression == null) {
            return;
        }
        boolean isVoid = JSResolveUtil.getExpressionJSType(expression) instanceof JSVoidType || JSDialectSpecificHandlersFactory.findExpectedType(expression) instanceof JSVoidType;
        String text = String.format("{%snull%s }", isVoid ? "" : " return ", JSCodeStyleSettings.getSemicolon((PsiElement)function2));
        JSBlockStatement block = JSPsiElementFactory.createJSStatement(text, (PsiElement)function2, JSBlockStatement.class);
        JSSourceElement statement = (JSSourceElement)ArrayUtil.getFirstElement((Object[])block.getStatementListItems());
        assert (statement instanceof JSStatementExpressionOwner);
        Objects.requireNonNull(((JSStatementExpressionOwner)statement).getExpression()).replace(expression);
        PsiElement rangeStart = arrow.getPsi().getNextSibling();
        PsiElement rangeEnd = expression.getPrevSibling();
        List list2 = prefixElements = rangeStart == null || rangeEnd == null ? ContainerUtil.emptyList() : PsiTreeUtil.getElementsOfRange((PsiElement)rangeStart, (PsiElement)rangeEnd);
        if (!prefixElements.isEmpty()) {
            prefixElements.forEach(el -> JSChangeUtil.doDoAddBeforePure(statement.getParent(), el, (PsiElement)statement));
            function2.getNode().removeRange(((PsiElement)prefixElements.get(0)).getNode(), expression.getNode());
        }
        JSBlockStatement replacedBody = (JSBlockStatement)expression.replace((PsiElement)block);
        if (PsiDocumentManager.getInstance((Project)project).getDocument(psiFile) != null) {
            FormatFixer.create((PsiElement)replacedBody, FormatFixer.Mode.Reformat).fixFormat();
        }
    }

    public static void removeElementWithLinebreak(@NotNull PsiElement element) {
        if (element == null) {
            JSRefactoringUtil.$$$reportNull$$$0(62);
        }
        FormatFixer ff = FormatFixer.create(element, FormatFixer.Mode.FirstLinebreak);
        element.delete();
        ff.fixFormat();
    }

    @NotNull
    public static JSStatement replaceStatementAndReformat(@NotNull JSStatement statement, @NotNull String text) {
        JSStatement newStatement;
        Document document2;
        if (statement == null) {
            JSRefactoringUtil.$$$reportNull$$$0(63);
        }
        if (text == null) {
            JSRefactoringUtil.$$$reportNull$$$0(64);
        }
        if ((document2 = PsiDocumentManager.getInstance((Project)(newStatement = JSChangeUtil.replaceStatement(statement, JSPsiElementFactory.createJSStatement(text, (PsiElement)statement))).getProject()).getDocument(newStatement.getContainingFile())) != null) {
            FormatFixer.create((PsiElement)newStatement, FormatFixer.Mode.Reformat).fixFormat();
        }
        JSStatement jSStatement = newStatement;
        if (jSStatement == null) {
            JSRefactoringUtil.$$$reportNull$$$0(65);
        }
        return jSStatement;
    }

    @NotNull
    public static JSExpression replaceExpressionAndReformat(@NotNull JSExpression expression, @NotNull String text) {
        JSExpression newExpression;
        Document document2;
        if (expression == null) {
            JSRefactoringUtil.$$$reportNull$$$0(66);
        }
        if (text == null) {
            JSRefactoringUtil.$$$reportNull$$$0(67);
        }
        if ((document2 = PsiDocumentManager.getInstance((Project)(newExpression = JSChangeUtil.replaceExpression(expression, JSPsiElementFactory.createJSExpression(text, (PsiElement)expression))).getProject()).getDocument(newExpression.getContainingFile())) != null) {
            FormatFixer.create((PsiElement)newExpression, FormatFixer.Mode.Reformat).fixFormat();
        }
        JSExpression jSExpression = newExpression;
        if (jSExpression == null) {
            JSRefactoringUtil.$$$reportNull$$$0(68);
        }
        return jSExpression;
    }

    @NotNull
    public static String getKindAndLongName(@NotNull PsiElement element) {
        if (element == null) {
            JSRefactoringUtil.$$$reportNull$$$0(69);
        }
        String string = UsageViewUtil.getType((PsiElement)element) + " " + UsageViewUtil.getLongName((PsiElement)element);
        if (string == null) {
            JSRefactoringUtil.$$$reportNull$$$0(70);
        }
        return string;
    }

    public static void suggestSameFileRename(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull PsiNameIdentifierOwner elementToRename, @Nullable String initialName) {
        if (file2 == null) {
            JSRefactoringUtil.$$$reportNull$$$0(71);
        }
        if (editor == null) {
            JSRefactoringUtil.$$$reportNull$$$0(72);
        }
        if (elementToRename == null) {
            JSRefactoringUtil.$$$reportNull$$$0(73);
        }
        PsiElement scope = elementToRename instanceof JSVariable ? ((JSVariable)elementToRename).getDeclarationScope() : null;
        PsiFile templateScope = scope == null ? file2 : scope;
        ApplicationManager.getApplication().runWriteAction(() -> JSRefactoringUtil.lambda$suggestSameFileRename$13(file2, editor, (PsiElement)templateScope, elementToRename, initialName));
    }

    public static String defaultValueOfType(@Nullable JSType type) {
        return JSRefactoringUtil.doGetDefaultValueOfType(type, 0);
    }

    @NotNull
    private static String doGetDefaultValueOfType(@Nullable JSType type, int depth) {
        if (JSTypeUtils.isPromiseLikeType(type) && depth < 10) {
            JSUndefinedType innerType = type instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)type).getArguments().get(0) : new JSUndefinedType(type.getSource());
            String string = "Promise.resolve(" + JSRefactoringUtil.doGetDefaultValueOfType(innerType, depth + 1) + ")";
            if (string == null) {
                JSRefactoringUtil.$$$reportNull$$$0(74);
            }
            return string;
        }
        PsiElement sourceElement = type == null ? null : type.getSourceElement();
        String defaultValue = JSTypeUtils.defaultValueOfType(type);
        if (sourceElement != null) {
            String quote = JSCodeStyleSettings.getQuote(sourceElement);
            return JSRefactoringUtil.recodeQuotes(defaultValue, quote);
        }
        String string = defaultValue;
        if (string == null) {
            JSRefactoringUtil.$$$reportNull$$$0(75);
        }
        return string;
    }

    @NotNull
    public static String recodeQuotes(@NotNull String defaultValue, @NotNull String quote) {
        char otherQuote;
        if (defaultValue == null) {
            JSRefactoringUtil.$$$reportNull$$$0(76);
        }
        if (quote == null) {
            JSRefactoringUtil.$$$reportNull$$$0(77);
        }
        char c = otherQuote = "\"".equals(quote) ? (char)'\'' : '\"';
        if (defaultValue.indexOf(otherQuote) == -1) {
            String string = defaultValue;
            if (string == null) {
                JSRefactoringUtil.$$$reportNull$$$0(78);
            }
            return string;
        }
        char quoteChar = quote.charAt(0);
        int slashes = 0;
        int quotes1 = 0;
        int quotes2 = 0;
        StringBuilder newValue = new StringBuilder();
        for (int i = 0; i < defaultValue.length(); ++i) {
            char c2 = defaultValue.charAt(i);
            if (c2 == '\\') {
                if (++slashes <= 0 || slashes % 2 != 0) continue;
                newValue.append("\\\\");
                continue;
            }
            if (slashes % 2 == 0) {
                if (c2 == quoteChar) {
                    if (quotes2 % 2 != 0) {
                        newValue.append("\\");
                    } else {
                        ++quotes1;
                    }
                    newValue.append(quoteChar);
                } else if (c2 != otherQuote) {
                    newValue.append(c2);
                } else {
                    if (quotes1 % 2 != 0) {
                        newValue.append("\\");
                    } else {
                        ++quotes2;
                    }
                    newValue.append(quote);
                }
            } else {
                newValue.append('\\').append(c2);
            }
            slashes = 0;
        }
        String string = newValue.toString();
        if (string == null) {
            JSRefactoringUtil.$$$reportNull$$$0(79);
        }
        return string;
    }

    public static void updateRefSharpness(@NotNull List<JSReferenceExpression> allReferences, boolean sharp, boolean wasSharp) {
        if (allReferences == null) {
            JSRefactoringUtil.$$$reportNull$$$0(80);
        }
        if (!wasSharp && !sharp) {
            return;
        }
        for (JSReferenceExpression reference : allReferences) {
            ASTNode dotNode;
            boolean isPrivateAccessContext = JSUtils.isPrivateFieldSharpAccessContext((PsiElement)reference);
            if (wasSharp && isPrivateAccessContext) {
                ASTNode node = reference.getNode();
                ASTNode dotSharp = node.findChildByType(JSElementTypes.DOT_SHARP);
                if (dotSharp != null) {
                    dotSharp.getPsi().replace(JSChangeUtil.createTokenElement((PsiElement)reference, JSTokenTypes.DOT, "."));
                    continue;
                }
                String text = node.getText();
                if (!text.startsWith("#")) continue;
                reference.replace(JSPsiElementFactory.createJSExpression("this." + text.substring(1), (PsiElement)reference));
                continue;
            }
            if (!sharp || isPrivateAccessContext || (dotNode = reference.getNode().findChildByType(JSTokenTypes.DOT)) == null) continue;
            dotNode.getPsi().replace(JSChangeUtil.createTwoTokenComposite((PsiElement)reference, JSElementTypes.DOT_SHARP, JSTokenTypes.DOT, JSTokenTypes.SHARP, ".", "#"));
        }
    }

    public static boolean isAbstract(@NotNull PsiElement context, @NotNull JSAttributeListOwner target) {
        if (context == null) {
            JSRefactoringUtil.$$$reportNull$$$0(81);
        }
        if (target == null) {
            JSRefactoringUtil.$$$reportNull$$$0(82);
        }
        if (JSPsiImplUtils.hasModifier(target, JSAttributeList.ModifierType.ABSTRACT)) {
            return true;
        }
        if (DialectDetector.isTypeScript(context)) {
            return false;
        }
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)target);
        return comment instanceof JSDocComment && ((JSDocComment)comment).hasAbstractTag();
    }

    public static void setAbstract(@NotNull PsiElement context, @NotNull JSAttributeListOwner target) {
        if (context == null) {
            JSRefactoringUtil.$$$reportNull$$$0(83);
        }
        if (target == null) {
            JSRefactoringUtil.$$$reportNull$$$0(84);
        }
        if (DialectDetector.isTypeScript(context)) {
            JSAttributeListWrapper wrapper = new JSAttributeListWrapper(target);
            wrapper.overrideModifier(JSAttributeList.ModifierType.ABSTRACT, true);
            wrapper.applyTo(target);
        } else {
            PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)target);
            if (comment == null) {
                PsiElement child = target.getFirstChild();
                PsiElement addedComment = target.addBefore((PsiElement)JSPsiElementFactory.createJSDocComment(ABSTRACT_DOC_COMMENT, (PsiElement)target), child);
                if (!(target instanceof JSClass)) {
                    target.addAfter(JSChangeUtil.createTokenElement((PsiElement)target, JSTokenTypes.WHITE_SPACE, "\n"), addedComment);
                }
            } else {
                JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)comment, Collections.singletonList("abstract"), null, null);
            }
        }
    }

    public static boolean isSuperCall(@Nullable JSSourceElement item) {
        if (!(item instanceof JSExpressionStatement)) {
            return false;
        }
        JSExpression expression = ((JSExpressionStatement)item).getExpression();
        return expression instanceof JSCallExpression && ((JSCallExpression)expression).getMethodExpression() instanceof JSSuperExpression;
    }

    public static void addBracesToStatement(@NotNull PsiElement element) {
        if (element == null) {
            JSRefactoringUtil.$$$reportNull$$$0(85);
        }
        if (!(element instanceof JSStatement)) {
            return;
        }
        JSStatement statement = (JSStatement)element;
        if (JSRefactoringUtil.isStatementWrappedWithBraces(statement)) {
            return;
        }
        JSElement parent = (JSElement)element.getParent();
        String text = element.getText();
        String newText = parent.getLastChild() instanceof PsiComment ? "{" + text + "\n}" : "{" + text + "}";
        JSRefactoringUtil.replaceAndReformat(statement, newText);
    }

    private static boolean isStatementWrappedWithBraces(@NotNull JSStatement statement) {
        if (statement == null) {
            JSRefactoringUtil.$$$reportNull$$$0(86);
        }
        return PsiUtilCore.getElementType((PsiElement)statement.getFirstChild()) == JSTokenTypes.LBRACE || PsiUtilCore.getElementType((PsiElement)statement.getLastChild()) == JSTokenTypes.RBRACE;
    }

    private static void replaceAndReformat(@NotNull JSStatement statement, @NotNull String text) {
        if (statement == null) {
            JSRefactoringUtil.$$$reportNull$$$0(87);
        }
        if (text == null) {
            JSRefactoringUtil.$$$reportNull$$$0(88);
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)statement.getProject());
        JSStatement newStatement = (JSStatement)codeStyleManager.performActionWithFormatterDisabled(() -> statement.replace(JSPsiElementFactory.createJSStatement(text, (PsiElement)statement)));
        PsiElement formatted = codeStyleManager.reformat((PsiElement)newStatement);
        codeStyleManager.reformatNewlyAddedElement(formatted.getNode().getTreeParent(), formatted.getNode());
    }

    public static void registerRefactoringUndo(final @NotNull Project project, final @Nullable String refactoringId) {
        if (project == null) {
            JSRefactoringUtil.$$$reportNull$$$0(89);
        }
        if (refactoringId == null) {
            return;
        }
        UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

            public void undo() {
                ((RefactoringEventListener)project.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).undoRefactoring(refactoringId);
            }

            public void redo() {
            }
        });
    }

    private static /* synthetic */ void lambda$suggestSameFileRename$13(PsiFile file2, Editor editor, PsiElement templateScope, PsiNameIdentifierOwner elementToRename, String initialName) {
        CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance((Project)file2.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder(templateScope);
            builder.replaceElement(elementToRename.getNameIdentifier(), TEMPLATE_VAR_NAME, (Expression)new MacroCallNode((Macro)new JSSuggestVariableNameMacro(initialName)), true, false);
            ReferencesSearch.search((PsiElement)elementToRename, (SearchScope)GlobalSearchScope.fileScope((PsiFile)file2)).forEach(r -> {
                if (!(r instanceof JSReferenceExpression)) {
                    return;
                }
                String referenceName = ((JSReferenceExpression)r).getReferenceName();
                if (referenceName == null) {
                    return;
                }
                builder.replaceElement(((JSReferenceExpression)r).getReferenceNameElement(), TEMPLATE_VAR_NAME, null, false, true);
            });
            builder.run(editor, true);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 65: 
            case 68: 
            case 70: 
            case 74: 
            case 75: 
            case 78: 
            case 79: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 65: 
            case 68: 
            case 70: 
            case 74: 
            case 75: 
            case 78: 
            case 79: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 2: 
            case 12: 
            case 44: 
            case 45: 
            case 81: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyText";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 65: 
            case 68: 
            case 70: 
            case 74: 
            case 75: 
            case 78: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalMethod";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configureAttributeList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classKeyword";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberText";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 19: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refList";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatters";
                break;
            }
            case 25: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 26: 
            case 33: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersHolder";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isFunction";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isField";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSkip";
                break;
            }
            case 34: 
            case 36: 
            case 42: 
            case 62: 
            case 69: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContext";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 39: 
            case 59: 
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 40: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 46: 
            case 48: 
            case 63: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 47: 
            case 49: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existing";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAttributeList";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 64: 
            case 67: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quote";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/util/JSRefactoringUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInterfacePropertyFromText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAbstractMethodSignature";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionSignature";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClassOrInterface";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "classDeclarationFromClassExpression";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "findExistingInScope";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberAlreadyExistsMessage";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceStatementAndReformat";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceExpressionAndReformat";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindAndLongName";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetDefaultValueOfType";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "recodeQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryBuildInterfaceSignature";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildInterfaceProperty";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildInterfacePropertyFromText";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 65: 
            case 68: 
            case 70: 
            case 74: 
            case 75: 
            case 78: 
            case 79: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildAbstractMethodSignature";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "buildInterfaceSignature";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionSignature";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildClassOrInterface";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeInitializer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeDecorators";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "specifyInferredReturnTypeExplicitly";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeFromReferenceList";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceToClass";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addToSupersList";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "makeQualified";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getVarStatementCopy";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getMemberInsertionAnchor";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addMemberToTargetClass";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addMemberToMemberHolder";
                break;
            }
            case 37: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setFunctionReturnType";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "chooseOrCreateDirectoryForClass";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkReadOnlyStatus";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "transformVarNameToAccessorName";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "transformAccessorNameToPropertyName";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "reformatElementWithoutBody";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "createFixerForReformatWithoutBody";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "classDeclarationFromClassExpression";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findExistingInScope";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getMemberAlreadyExistsMessage";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "copyDecorators";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "addBracesToShorthandArrowFunction";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "removeElementWithLinebreak";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "replaceStatementAndReformat";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpressionAndReformat";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getKindAndLongName";
                break;
            }
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "suggestSameFileRename";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "recodeQuotes";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "updateRefSharpness";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isAbstract";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "setAbstract";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "addBracesToStatement";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isStatementWrappedWithBraces";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "replaceAndReformat";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "registerRefactoringUndo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 15: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 65: 
            case 68: 
            case 70: 
            case 74: 
            case 75: 
            case 78: 
            case 79: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConstructorUsageInfo
    extends MoveRenameUsageInfo {
        public ConstructorUsageInfo(JSReferenceExpression ref, JSClass subject) {
            super((PsiReference)ref, (PsiElement)subject);
        }

        @Nullable
        public JSClass getSubject() {
            return (JSClass)this.getReferencedElement();
        }

        public JSReferenceExpression getElement() {
            return (JSReferenceExpression)super.getElement();
        }
    }
}

