/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.react.extractComponent;

import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.introduce.JSIntroducedExpressionUtil;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentDialog;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentHandlerBase;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactExtractComponentHandler
extends ReactExtractComponentHandlerBase {
    @Override
    @Nullable
    protected Pair<JSXmlLiteralExpression, TextRange> getSourceExpression(@NotNull Editor editor, @NotNull PsiFile file2) {
        Pair<JSExpression, TextRange> candidate;
        int selectionEnd;
        int selectionStart;
        List<Pair<JSExpression, TextRange>> expressionCandidates;
        if (editor == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(1);
        }
        if ((expressionCandidates = JSIntroducedExpressionUtil.findExpressionsInRange(file2, selectionStart = editor.getSelectionModel().getSelectionStart(), selectionEnd = editor.getSelectionModel().getSelectionEnd())) == null || expressionCandidates.isEmpty()) {
            return null;
        }
        Pair<JSExpression, TextRange> pair = candidate = expressionCandidates.size() > 1 ? (Pair<JSExpression, TextRange>)ContainerUtil.find(expressionCandidates, t -> t.first instanceof JSXmlLiteralExpression && t.second == null) : expressionCandidates.get(0);
        if (candidate != null) {
            JSExpression withoutPars;
            if (candidate.first instanceof JSXmlLiteralExpression) {
                return Pair.create((Object)((JSXmlLiteralExpression)candidate.first), (Object)((TextRange)candidate.second));
            }
            if (candidate.second == null && (withoutPars = JSUtils.unparenthesize((JSExpression)candidate.first)) instanceof JSXmlLiteralExpression) {
                return Pair.create((Object)((JSXmlLiteralExpression)withoutPars), null);
            }
        }
        return null;
    }

    @Override
    protected void doRefactoring(@NotNull Editor editor, @NotNull Pair<? extends JSExpression, TextRange> sourceDescriptor, @NotNull PsiElement anchor, @NotNull String componentText, @NotNull ReactExtractComponentHandlerBase.ComponentToExtract component) {
        if (editor == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(2);
        }
        if (sourceDescriptor == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(3);
        }
        if (anchor == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(4);
        }
        if (componentText == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(5);
        }
        if (component == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(6);
        }
        JSIntroducedExpressionUtil.Replacer replacer = JSIntroducedExpressionUtil.createReplacer(sourceDescriptor);
        String usageReplacementText = String.format("<%s %s/>", component.name, StringUtil.join(component.props, prop -> prop.name + "={" + prop.value + "}", (String)""));
        Runnable format = this.addDeclarations(component, editor, anchor, componentText);
        JSExpression replacementExpression = JSChangeUtil.createExpressionPsiWithContext(usageReplacementText, (PsiElement)sourceDescriptor.first, JSExpression.class);
        assert (replacementExpression != null);
        replacer.replaceExpression(replacementExpression);
        if (format != null) {
            format.run();
        }
    }

    @Override
    @Nullable
    protected Pair<String, ReactExtractComponentHandlerBase.ComponentType> getUserSettings(@NotNull JSElement introductionScope, @NotNull DataContext dataContext) {
        if (introductionScope == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(7);
        }
        if (dataContext == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Pair.create((Object)((String)dataContext.getData(TEST_NAME_KEY)), (Object)((Object)((ReactExtractComponentHandlerBase.ComponentType)((Object)dataContext.getData(TEST_COMPONENT_TYPE_KEY)))));
        }
        InputValidatorEx inputValidator = ReactExtractComponentHandler.createNameValidator((PsiElement)introductionScope);
        ReactExtractComponentDialog dialog = new ReactExtractComponentDialog(introductionScope.getProject(), inputValidator, "NewComponent");
        if (!dialog.showAndGet()) {
            return null;
        }
        return Pair.create((Object)dialog.getSelectedName(), (Object)((Object)dialog.getSelectedType()));
    }

    @Override
    @NotNull
    protected Pair<Collection<ReactExtractComponentHandlerBase.Prop>, String> buildPropsAndComponentBody(@NotNull Pair<JSXmlLiteralExpression, TextRange> expressionDescriptor, final @Nullable JSPsiElementBase sourceComponent, final @NotNull PsiElement introductionScope, final @NotNull ReactExtractComponentHandlerBase.ComponentType componentType) {
        if (expressionDescriptor == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(9);
        }
        if (introductionScope == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(10);
        }
        if (componentType == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(11);
        }
        JSXmlLiteralExpression sourceExpression = (JSXmlLiteralExpression)expressionDescriptor.first;
        final TextRange rangeToProcess = expressionDescriptor.second != null ? (TextRange)expressionDescriptor.second : sourceExpression.getTextRange();
        final Ref keyProp = new Ref();
        final LinkedHashMap expressionReplacements = new LinkedHashMap();
        final LinkedHashMap propsByValue = new LinkedHashMap();
        final HashSet propNames = new HashSet();
        sourceExpression.accept((PsiElementVisitor)new JSRecursiveWalkingElementVisitor(){

            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                if (embeddedContent.getParent() instanceof XmlAttributeValue && embeddedContent.getParent().getParent() instanceof XmlAttribute && StringUtil.equals((CharSequence)"key", (CharSequence)((XmlAttribute)embeddedContent.getParent().getParent()).getName())) {
                    JSExpression expression = (JSExpression)PsiTreeUtil.findChildOfType((PsiElement)embeddedContent, JSExpression.class);
                    if (expression != null) {
                        ReactExtractComponentHandlerBase.Prop prop = new ReactExtractComponentHandlerBase.Prop("key", null, expression.getText());
                        expressionReplacements.put(embeddedContent.getParent().getParent(), "");
                        keyProp.set((Object)prop);
                    }
                } else {
                    super.visitJSEmbeddedContent(embeddedContent);
                }
            }

            public void visitJSReferenceExpression(JSReferenceExpression node) {
                if (!rangeToProcess.contains(node.getTextRange())) {
                    return;
                }
                if (ReactExtractComponentHandlerBase.isContextDependant(node, sourceComponent, introductionScope)) {
                    this.processPropCandidate((JSExpression)node);
                } else {
                    super.visitJSReferenceExpression(node);
                }
            }

            public void visitJSThisExpression(JSThisExpression node) {
                if (!rangeToProcess.contains(node.getTextRange())) {
                    return;
                }
                this.processPropCandidate((JSExpression)node);
            }

            public void visitJSCallExpression(JSCallExpression node) {
                if (!rangeToProcess.contains(node.getTextRange())) {
                    return;
                }
                Object[] arguments = node.getArguments();
                JSReferenceExpression methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)node.getMethodExpression(), JSReferenceExpression.class);
                if (ContainerUtil.or((Object[])arguments, expression -> expression instanceof JSThisExpression) || methodExpression != null && ReactExtractComponentHandlerBase.isContextDependant(methodExpression, sourceComponent, introductionScope)) {
                    this.processPropCandidate((JSExpression)node);
                } else {
                    super.visitJSCallExpression(node);
                }
            }

            public void visitJSFunctionExpression(JSFunctionExpression node) {
                if (!rangeToProcess.contains(node.getTextRange())) {
                    return;
                }
                this.processPropCandidate((JSExpression)node);
            }

            private void processPropCandidate(@NotNull JSExpression node) {
                ReactExtractComponentHandlerBase.Prop prop;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((prop = (ReactExtractComponentHandlerBase.Prop)propsByValue.get(node.getText())) == null) {
                    prop = ReactExtractComponentHandlerBase.propFromExpression(node, propNames);
                    propsByValue.put(node.getText(), prop);
                }
                expressionReplacements.put(node, this.getReplacementForProp(node, prop));
            }

            @NotNull
            private String getReplacementForProp(@NotNull JSExpression expression, @NotNull ReactExtractComponentHandlerBase.Prop prop) {
                ES6Property property;
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (prop == null) {
                    1.$$$reportNull$$$0(2);
                }
                String text = (componentType != ReactExtractComponentHandlerBase.ComponentType.Function ? "this." : "") + "props." + prop.name;
                if (expression.getParent() instanceof ES6Property && (property = (ES6Property)expression.getParent()).isShorthanded()) {
                    String string = property.getName() + ": " + text;
                    if (string == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                String string = text;
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "node";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prop";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler$1";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReplacementForProp";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processPropCandidate";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getReplacementForProp";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        String result2 = ReactExtractComponentHandler.replaceOccurrences((JSElement)sourceExpression, rangeToProcess, expressionReplacements);
        ArrayList resultProps = new ArrayList();
        ContainerUtil.addIfNotNull(resultProps, (Object)((ReactExtractComponentHandlerBase.Prop)keyProp.get()));
        resultProps.addAll(((HashMap)propsByValue).values());
        String replacementText = expressionDescriptor.second == null ? result2 : "<>" + (String)(StringUtil.contains((CharSequence)result2, (CharSequence)"\n") ? "\n" + result2 + "\n" : result2) + "</>";
        Pair pair = Pair.create(resultProps, (Object)replacementText);
        if (pair == null) {
            ReactExtractComponentHandler.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @Override
    protected String getRefactoringTitle() {
        return JavaScriptBundle.message((String)"refactoring.extract.react.component.title", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introductionScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentHandler";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPropsAndComponentBody";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSourceExpression";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUserSettings";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildPropsAndComponentBody";
                break;
            }
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

