/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.react.extractComponent;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.refactoring.react.extractComponent.ReactExtractComponentHandlerBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactExtractComponentDialog
extends DialogWrapper {
    private final JPanel myPanel;
    private final JTextField myNameField;
    private final Map<ReactExtractComponentHandlerBase.ComponentType, JRadioButton> myButtonMap;
    private final InputValidatorEx myInputValidator;

    public ReactExtractComponentDialog(@Nullable Project project, @NotNull InputValidatorEx inputValidator, @NlsSafe String defaultName) {
        if (inputValidator == null) {
            ReactExtractComponentDialog.$$$reportNull$$$0(0);
        }
        super(project);
        this.setTitle(JavaScriptBundle.message((String)"refactoring.extract.react.component.title", (Object[])new Object[0]));
        this.myNameField = new JTextField(defaultName);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel typePanel = new JPanel(new FlowLayout(0));
        this.myInputValidator = inputValidator;
        this.myButtonMap = new HashMap<ReactExtractComponentHandlerBase.ComponentType, JRadioButton>();
        ReactExtractComponentHandlerBase.ComponentType lastComponentType = ReactExtractComponentHandlerBase.getLastComponentType();
        for (ReactExtractComponentHandlerBase.ComponentType componentType : ReactExtractComponentHandlerBase.ComponentType.values()) {
            JBRadioButton radio = new JBRadioButton(componentType.getDescription());
            radio.setSelected(componentType == lastComponentType);
            radio.setMnemonic(componentType.getDescription().charAt(0));
            typePanel.add((Component)radio);
            buttonGroup.add((AbstractButton)radio);
            this.myButtonMap.put(componentType, (JRadioButton)radio);
        }
        this.myPanel = FormBuilder.createFormBuilder().addLabeledComponent(JavaScriptBundle.message((String)"label.name", (Object[])new Object[0]), (JComponent)this.myNameField).addLabeledComponent(JavaScriptBundle.message((String)"label.type", (Object[])new Object[0]), (JComponent)typePanel).getPanel();
        this.init();
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String errorText = this.myInputValidator.getErrorText(this.getSelectedName());
        if (errorText != null) {
            return new ValidationInfo(errorText, (JComponent)this.myNameField);
        }
        return super.doValidate();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected void doOKAction() {
        super.doOKAction();
        ReactExtractComponentHandlerBase.setLastComponentType(this.getSelectedType());
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public String getSelectedName() {
        return this.myNameField.getText().trim();
    }

    public ReactExtractComponentHandlerBase.ComponentType getSelectedType() {
        for (Map.Entry<ReactExtractComponentHandlerBase.ComponentType, JRadioButton> entry : this.myButtonMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            return entry.getKey();
        }
        assert (false);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputValidator", "com/intellij/lang/javascript/refactoring/react/extractComponent/ReactExtractComponentDialog", "<init>"));
    }
}

