/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.refactoring.convertToClass.ClassInheritanceNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectTargetsToConvertToClass {
    @NotNull
    private final ClassInheritanceNode myRoot;
    private ClassInheritanceNode[] myCheckedNodes;
    private boolean mySelectAll;

    public SelectTargetsToConvertToClass(@NotNull ClassInheritanceNode root) {
        if (root == null) {
            SelectTargetsToConvertToClass.$$$reportNull$$$0(0);
        }
        this.myRoot = root;
    }

    public void setSelectAll(boolean selectAll) {
        this.mySelectAll = selectAll;
    }

    public void process() {
        TreeSelectionListener[] listeners;
        MyTreeNode here = new MyTreeNode(this.myRoot);
        here.setChecked(true);
        here.setEnabled(false);
        MyTreeNode root = SelectTargetsToConvertToClass.createTreeData(here, here);
        if (ApplicationManager.getApplication().isUnitTestMode() || this.mySelectAll) {
            this.formCheckedNodes(root);
            return;
        }
        DialogBuilder builder = new DialogBuilder();
        builder.setTitle(JavaScriptBundle.message((String)"dialog.title.select.targets.to.convert.to.class", (Object[])new Object[0]));
        MyTreeNode fictive = new MyTreeNode(this.myRoot);
        fictive.add((MutableTreeNode)((Object)root));
        MyTree tree = new MyTree(fictive);
        TreeUtil.expandAll((JTree)((Object)tree));
        tree.setSelectionRow(0);
        for (TreeSelectionListener listener2 : listeners = tree.getTreeSelectionListeners()) {
            tree.removeTreeSelectionListener(listener2);
        }
        builder.centerPanel((JComponent)new JBScrollPane((Component)((Object)tree)));
        builder.addOkAction();
        builder.addCancelAction();
        builder.setPreferredFocusComponent((JComponent)((Object)tree));
        builder.setDimensionServiceKey(SelectTargetsToConvertToClass.class.getName());
        if (builder.showAndGet()) {
            this.formCheckedNodes(root);
        }
    }

    private void formCheckedNodes(MyTreeNode root) {
        ArrayList<ClassInheritanceNode> checked = new ArrayList<ClassInheritanceNode>();
        ArrayDeque<MyTreeNode> queue = new ArrayDeque<MyTreeNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            MyTreeNode node = (MyTreeNode)((Object)queue.removeFirst());
            if (node.isChecked()) {
                checked.add(node.getNode());
            }
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                queue.add((MyTreeNode)((Object)children.nextElement()));
            }
        }
        this.myCheckedNodes = checked.isEmpty() ? null : checked.toArray(new ClassInheritanceNode[0]);
    }

    public ClassInheritanceNode[] getCheckedNodes() {
        return this.myCheckedNodes;
    }

    private static MyTreeNode createTreeData(MyTreeNode here, MyTreeNode root) {
        while (root.getNode().getParent() != null) {
            MyTreeNode was = root;
            root = new MyTreeNode(root.getNode().getParent());
            root.add((MutableTreeNode)((Object)was));
            SelectTargetsToConvertToClass.addNodeChildren(root, was.getNode());
        }
        SelectTargetsToConvertToClass.addNodeChildren(here, null);
        return root;
    }

    private static void addNodeChildren(MyTreeNode here, @Nullable ClassInheritanceNode except) {
        ArrayDeque<MyTreeNode> queue = new ArrayDeque<MyTreeNode>();
        queue.add(here);
        while (!queue.isEmpty()) {
            MyTreeNode node = (MyTreeNode)((Object)queue.removeFirst());
            List<ClassInheritanceNode> descendants = node.getNode().getDescendants();
            for (ClassInheritanceNode descendant : descendants) {
                if (descendant.equals(except)) continue;
                MyTreeNode child = new MyTreeNode(descendant);
                node.add((MutableTreeNode)((Object)child));
                queue.add(child);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/javascript/refactoring/convertToClass/SelectTargetsToConvertToClass", "<init>"));
    }

    private static class MyTree
    extends CheckboxTree {
        MyTree(MyTreeNode root) {
            super(new CheckboxTree.CheckboxTreeCellRenderer(){
                {
                    this.myIgnoreInheritance = true;
                }

                public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    if (value instanceof MyTreeNode) {
                        JSFunction function2 = ((MyTreeNode)((Object)value)).getFunction();
                        String text = JSFormatUtil.formatMethod(function2, 1, 0);
                        ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                        textRenderer.append(text, SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES);
                        textRenderer.setIcon(function2.getIcon(1));
                    }
                }
            }, (CheckedTreeNode)root, new CheckboxTreeBase.CheckPolicy(false, false, false, false));
        }
    }

    private static class MyTreeNode
    extends CheckedTreeNode {
        @NotNull
        private final ClassInheritanceNode myNode;

        MyTreeNode(@NotNull ClassInheritanceNode node) {
            if (node == null) {
                MyTreeNode.$$$reportNull$$$0(0);
            }
            super((Object)node);
            this.myNode = node;
        }

        @NotNull
        public JSFunction getFunction() {
            JSFunction jSFunction = this.myNode.getFunction();
            if (jSFunction == null) {
                MyTreeNode.$$$reportNull$$$0(1);
            }
            return jSFunction;
        }

        @NotNull
        public ClassInheritanceNode getNode() {
            ClassInheritanceNode classInheritanceNode = this.myNode;
            if (classInheritanceNode == null) {
                MyTreeNode.$$$reportNull$$$0(2);
            }
            return classInheritanceNode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/refactoring/convertToClass/SelectTargetsToConvertToClass$MyTreeNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/SelectTargetsToConvertToClass$MyTreeNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFunction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

