/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import java.util.ArrayList;

public class HighlightingUtils {
    public static ArrayList<RangeHighlighter> highlightOccurrences(Project project, Editor editor, PsiElement[] elts) {
        return HighlightingUtils.highlightOccurrences(project, editor, new PsiElementsOccurrenceInfoSource(elts));
    }

    public static ArrayList<RangeHighlighter> highlightOccurrences(Project project, Editor editor, PsiElementsOccurrenceInfoSource occurrenceInfoSource) {
        ArrayList<RangeHighlighter> result2 = HighlightingUtils.doHighlightOccurences(project, editor, occurrenceInfoSource, false);
        HighlightingUtils.informThatHighlightingCanbeRemoved(project);
        return result2;
    }

    public static void informThatHighlightingCanbeRemoved(Project project) {
        WindowManager.getInstance().getStatusBar(project).setInfo(RefactoringBundle.message((String)"press.escape.to.remove.the.highlighting"));
    }

    public static ArrayList<RangeHighlighter> doHighlightOccurences(Project project, Editor editor, PsiElementsOccurrenceInfoSource occurrenceInfoSource, boolean isWrite) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        TextAttributesKey attributes = isWrite ? EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES : EditorColors.SEARCH_RESULT_ATTRIBUTES;
        ArrayList<RangeHighlighter> result2 = new ArrayList<RangeHighlighter>();
        assert (occurrenceInfoSource != null);
        PsiElement[] occurrences = occurrenceInfoSource.occurrences;
        highlightManager.addOccurrenceHighlights(editor, occurrences, attributes, true, result2);
        return result2;
    }

    public static class PsiElementsOccurrenceInfoSource {
        private final PsiElement[] occurrences;

        public PsiElementsOccurrenceInfoSource(PsiElement[] occurrences) {
            this.occurrences = occurrences;
        }
    }
}

