/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSNumericIndexerAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringContext {
    @NotNull
    private final List<PsiElement> myDestructuringElements;
    @Nullable
    private final JSInitializerOwner myOuterElement;

    private JSDestructuringContext(@NotNull List<PsiElement> destructuringElements, @Nullable JSInitializerOwner condition) {
        if (destructuringElements == null) {
            JSDestructuringContext.$$$reportNull$$$0(0);
        }
        this.myDestructuringElements = destructuringElements;
        this.myOuterElement = condition;
    }

    public boolean isEmpty() {
        return this.myDestructuringElements.isEmpty();
    }

    @Nullable
    public String buildFieldName() {
        StringBuilder fieldNameBuilder = new StringBuilder();
        for (int i = this.myDestructuringElements.size() - 1; i >= 0; --i) {
            PsiElement parent = this.myDestructuringElements.get(i);
            if (!(parent instanceof JSDestructuringProperty)) continue;
            if (fieldNameBuilder.length() > 0) {
                fieldNameBuilder.append('.');
            }
            fieldNameBuilder.append(((JSDestructuringProperty)parent).getName());
        }
        return fieldNameBuilder.length() > 0 ? fieldNameBuilder.toString() : null;
    }

    @NotNull
    public static JSDestructuringContext findDestructuringParents(@NotNull PsiElement destructuringElement, @NotNull Predicate<? super JSInitializerOwner> parentCondition) {
        if (destructuringElement == null) {
            JSDestructuringContext.$$$reportNull$$$0(1);
        }
        if (parentCondition == null) {
            JSDestructuringContext.$$$reportNull$$$0(2);
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        PsiElement element = destructuringElement;
        PsiElement prevElement = destructuringElement;
        while (element instanceof JSDestructuringContainer || element instanceof JSDestructuringProperty || element instanceof JSDestructuringArrayRestElement || element instanceof JSInitializerOwner) {
            if (element instanceof JSInitializerOwner && parentCondition.test((JSInitializerOwner)((JSInitializerOwner)element))) {
                return new JSDestructuringContext(result2, (JSInitializerOwner)element);
            }
            if (element instanceof JSDestructuringArray) {
                if (!(prevElement instanceof JSDestructuringArrayRestElement)) {
                    result2.add(prevElement);
                }
            } else if (element instanceof JSDestructuringProperty) {
                result2.add(element);
            }
            prevElement = element;
            element = element.getParent();
        }
        return new JSDestructuringContext(result2, null);
    }

    @Nullable
    public JSInitializerOwner getOuterElement() {
        return this.myOuterElement;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public JSType applyToOuterType(@Nullable JSType type) {
        if (type == null || this.myDestructuringElements.isEmpty()) {
            return type;
        }
        JSType result2 = type;
        for (int i = this.myDestructuringElements.size() - 1; i >= 0; --i) {
            PsiElement destructuringElement = this.myDestructuringElements.get(i);
            if (destructuringElement instanceof JSDestructuringProperty) {
                String name = ((JSDestructuringProperty)destructuringElement).getName();
                if (name == null) {
                    return JSAnyType.get(destructuringElement, false);
                }
                result2 = new JSQualifiedReferenceType(name, result2, JSTypeSourceFactory.createTypeSource(destructuringElement, true));
                continue;
            }
            PsiElement parent = destructuringElement.getParent();
            if (!(parent instanceof JSDestructuringArray)) {
                Logger.getInstance(JSDestructuringUtil.class).error("Unexpected parent " + (parent == null ? null : parent.getClass().getSimpleName()));
                return JSAnyType.get(destructuringElement, false);
            }
            int childIndex = ArrayUtil.indexOf((Object[])((JSDestructuringArray)parent).getElementsWithRest(), (Object)destructuringElement);
            if (childIndex == -1) {
                Logger.getInstance(JSDestructuringUtil.class).error("Can't find destructuring array child");
                return JSAnyType.get(destructuringElement, false);
            }
            result2 = new JSNumericIndexerAccessType(childIndex, result2, JSTypeSourceFactory.createTypeSource(destructuringElement, true));
        }
        return result2;
    }

    @Nullable
    public JSParameterTypeDecorator applyToOuterParameterTypeDecorator(@NotNull JSParameterTypeDecorator decorator) {
        if (decorator == null) {
            JSDestructuringContext.$$$reportNull$$$0(3);
        }
        if (this.myDestructuringElements.isEmpty()) {
            return decorator;
        }
        JSType type = decorator.getSimpleType();
        for (int i = this.myDestructuringElements.size() - 1; i >= 0; --i) {
            PsiElement destructuringElement = this.myDestructuringElements.get(i);
            if (destructuringElement instanceof JSDestructuringProperty) {
                String name = ((JSDestructuringProperty)destructuringElement).getName();
                if (name == null) {
                    return null;
                }
                if (type instanceof JSRecordType) {
                    JSRecordType.PropertySignature signature = ((JSRecordType)type).findPropertySignature(name);
                    if (signature == null) continue;
                    type = signature.getJSType();
                    if (i != 0) continue;
                    return new JSParameterTypeDecoratorImpl(type, signature.isOptional(), false, decorator.isExplicitlyDeclared());
                }
                if (type == null) continue;
                return new JSParameterTypeDecoratorImpl(new JSQualifiedReferenceType(name, type, type.getSource()), decorator.isOptional(), false, decorator.isExplicitlyDeclared());
            }
            PsiElement parent = destructuringElement.getParent();
            if (!(parent instanceof JSDestructuringArray)) {
                Logger.getInstance(JSDestructuringUtil.class).error("Unexpected parent " + (parent == null ? null : parent.getClass().getSimpleName()));
                return null;
            }
            int childIndex = ArrayUtil.indexOf((Object[])((JSDestructuringArray)parent).getElementsWithRest(), (Object)destructuringElement);
            if (childIndex == -1) {
                Logger.getInstance(JSDestructuringUtil.class).error("Can't find destructuring array child");
                return null;
            }
            if (type != null) {
                type = JSArrayType.GenericArrayBuilder.asArrayIfGenericType(type);
            }
            JSType jSType = type = type instanceof JSArrayType ? ((JSArrayType)type).getType() : null;
            if (i != 0) continue;
            return new JSParameterTypeDecoratorImpl(type, false, false, decorator.isExplicitlyDeclared());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCondition";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSDestructuringContext";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findDestructuringParents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyToOuterParameterTypeDecorator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

