/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;

public class JSStringType
extends JSPrimitiveType {
    private static final String DEFAULT_VALUE = "\"\"";

    public JSStringType(boolean primitive, @NotNull JSTypeSource source, @NotNull JSTypeContext staticOrInstance) {
        if (source == null) {
            JSStringType.$$$reportNull$$$0(0);
        }
        if (staticOrInstance == null) {
            JSStringType.$$$reportNull$$$0(1);
        }
        super(primitive, source, staticOrInstance);
    }

    public JSStringType(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSStringType.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSStringType.$$$reportNull$$$0(3);
        }
        super(typeSource, inputStream);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSStringType.$$$reportNull$$$0(4);
        }
        if (processingContext == null) {
            JSStringType.$$$reportNull$$$0(5);
        }
        if (elementType instanceof JSResolvableType) {
            if ("XML".equals(elementType.getTypeText()) || "XMLList".equals(elementType.getTypeText())) {
                return true;
            }
            JSResolvedTypeInfo resolvedType = ((JSResolvableType)elementType).resolveType();
            if (resolvedType.isEnumLiteral()) {
                return TypeScriptTypeRelations.checkEnumTypeForPrimitive(resolvedType, JSStringType.class);
            }
            if (resolvedType.isEnum()) {
                JSType literals = JSCompositeTypeImpl.optimizeTypeIfComposite(TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(elementType));
                return literals != elementType && this.isDirectlyAssignableType(literals, processingContext);
            }
        }
        if (elementType instanceof JSStringType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSStringType.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            JSStringType.$$$reportNull$$$0(7);
        }
        builder.append(this.isPrimitive() && !this.isEcma() && format != JSType.TypeTextFormat.RESOLVED ? "string" : "String");
    }

    @NotNull
    public String getDefaultValue() {
        return DEFAULT_VALUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/primitives/JSStringType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTypeTextImpl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

