/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerResolvedIdBase;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSContextualUnionType;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSExoticStringLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutionContextImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptStringMappingTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTemplateLiteralJSTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.typescript.resolve.TypeScriptTypeHelper;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeRelations {
    private static final JSType.LocalTypeKey ENUM_VALUES_UNION_TYPE_KEY = JSType.createLocalTypeKey((String)"enum.values.union.type");

    public static boolean isTypeDerivedFrom(@Nullable JSType source, @Nullable JSType target, @NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(0);
        }
        if (source instanceof JSUnionType) {
            return StreamEx.of(((JSUnionType)source).getTypes()).allMatch(el -> TypeScriptTypeRelations.isTypeDerivedFrom(el, target, context));
        }
        if (target instanceof JSUnionType) {
            return StreamEx.of(((JSUnionType)target).getTypes()).anyMatch(el -> TypeScriptTypeRelations.isTypeDerivedFrom(source, el, context));
        }
        if (source != null && TypeScriptTypeRelations.isInstantiableNonPrimitive(source)) {
            return TypeScriptTypeRelations.isTypeDerivedFrom(TypeScriptTypeRelations.getBaseConstraintOfType(source, context), target, context);
        }
        if (source != null) {
            return TypeScriptTypeRelations.hasBaseType(source, target);
        }
        return false;
    }

    @Contract(value="!null, _ -> !null")
    public static JSType subtypeReduction(@Nullable JSType type, @NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(1);
        }
        if (!(type instanceof JSUnionType)) {
            return type;
        }
        List<JSType> types2 = ((JSUnionType)type).getTypes();
        if (TypeScriptTypeRelations.isSubsetOfOneEnumLiteral(types2)) {
            return type;
        }
        ArrayList<JSType> result2 = new ArrayList<JSType>(types2);
        if (!TypeScriptTypeRelations.reduceBySubtyping(context, types2, result2)) {
            return TypeScriptTypeRelations.getUnionType(result2, type.getSource());
        }
        return result2.size() == types2.size() ? type : TypeScriptTypeRelations.getUnionType(result2, type.getSource());
    }

    public static boolean reduceBySubtyping(@NotNull PsiElement context, List<JSType> types2, List<JSType> result2) {
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(2);
        }
        ProcessingContext subtypingProcessingContext = JSTypeComparingContextService.createSubtypingProcessingContext(context);
        int count = 0;
        HashSet<JSType> removed = new HashSet<JSType>();
        block0: for (int i = types2.size() - 1; i >= 0; --i) {
            JSType source = types2.get(i);
            for (JSType target : types2) {
                if (source == target || removed.contains(target)) continue;
                if (count == 100000 && types2.size() > 1000000) {
                    return false;
                }
                ++count;
                if (!TypeScriptTypeRelations.isTypeSubtypeOf(source, target, subtypingProcessingContext) || TypeScriptTypeRelations.isClassType(source) && TypeScriptTypeRelations.isClassType(target) && !TypeScriptTypeRelations.isTypeDerivedFrom(source, target, context)) continue;
                result2.remove(i);
                removed.add(source);
                continue block0;
            }
        }
        return true;
    }

    private static boolean isClassType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(3);
        }
        if (!(type instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        Collection<JSClass> classes = info.getDeclarationsOfType(JSClass.class);
        return !classes.isEmpty() && classes.stream().anyMatch(el -> !el.isInterface());
    }

    private static boolean isSubsetOfOneEnumLiteral(@NotNull List<JSType> types2) {
        JSResolvedTypeInfo info;
        JSType first;
        if (types2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(4);
        }
        if ((first = types2.get(0)) instanceof JSResolvableType && (info = ((JSResolvableType)first).resolveType()).isEnumLiteral()) {
            JSType type = TypeScriptUtil.getBaseTypeOfEnumLiteralType((JSResolvableType)first);
            for (int i = 1; i < types2.size(); ++i) {
                JSType next = types2.get(0);
                if (!(next instanceof JSResolvableType)) {
                    return false;
                }
                JSResolvedTypeInfo resolved = ((JSResolvableType)next).resolveType();
                if (!resolved.isEnumLiteral()) {
                    return false;
                }
                JSType nextEnum = TypeScriptUtil.getBaseTypeOfEnumLiteralType((JSResolvableType)next);
                if (type.isEquivalentTo(nextEnum, null, true)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasBaseType(@NotNull JSType type, @Nullable JSType checkBase) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(5);
        }
        JSType sourceType = TypeScriptTypeRelations.unwrapGenericType(type);
        JSType baseType = TypeScriptTypeRelations.unwrapGenericType(checkBase);
        if (baseType instanceof JSNamedType && sourceType instanceof JSNamedType) {
            return TypeScriptTypeHelper.areNamedTypesClassAssignable((JSNamedType)baseType, (JSNamedType)sourceType).isAssignable();
        }
        if (baseType instanceof JSIntersectionType) {
            return StreamEx.of(((JSIntersectionType)baseType).getTypes()).anyMatch(el -> TypeScriptTypeRelations.hasBaseType(sourceType, el));
        }
        return false;
    }

    @Nullable
    private static JSType unwrapGenericType(@Nullable JSType type) {
        return type instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)type).getType() : type;
    }

    public static boolean isTypeSubtypeOf(@Nullable JSType source, @Nullable JSType target, @NotNull ProcessingContext processingContext) {
        if (processingContext == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(6);
        }
        if (source == null || target == null) {
            return false;
        }
        assert (processingContext.get(JSTypeComparingCache.SUBTYPING_CONTEXT) != null);
        return TypeScriptTypeRelations.isTypeRelatedTo(source, target, processingContext);
    }

    public static boolean areTypesComparable(@Nullable JSType type1, @Nullable JSType type2, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeComparableTo(type1, type2, context) || TypeScriptTypeRelations.isTypeComparableTo(type2, type1, context);
    }

    public static boolean isCoercibleUnderDoubleEquals(@Nullable JSType source, @Nullable JSType target) {
        if (source == null || target == null) {
            return false;
        }
        return TypeScriptTypeRelations.isCoercibleSource(source) && TypeScriptTypeRelations.isCoercibleTarget(target);
    }

    private static boolean isCoercibleSource(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(7);
        }
        return !(type instanceof JSStringLiteralTypeImpl) && !(type instanceof JSNumberLiteralTypeImpl) && (type instanceof JSStringType || type instanceof JSNumberType || type instanceof JSBooleanType);
    }

    private static boolean isCoercibleTarget(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(8);
        }
        if (TypeScriptTypeRelations.isBooleanUnionType(type)) {
            return true;
        }
        return !(type instanceof JSPrimitiveLiteralType) && (type instanceof JSStringType || type instanceof JSNumberType || type instanceof JSBooleanType);
    }

    public static boolean isTypeComparableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        block3: {
            block2: {
                if (!(source instanceof JSUnionType)) break block2;
                for (JSType sourceSubType : ((JSUnionType)source).getTypes()) {
                    if (!TypeScriptTypeRelations.isTypeComparableTo(sourceSubType, target, context)) continue;
                    return true;
                }
                break block3;
            }
            if (!(target instanceof JSUnionType)) break block3;
            for (JSType targetSubType : ((JSUnionType)target).getTypes()) {
                if (!TypeScriptTypeRelations.isTypeRelatedTo(source, targetSubType, context)) continue;
                return true;
            }
        }
        return TypeScriptTypeRelations.isTypeRelatedTo(source, target, context);
    }

    @NotNull
    public static JSType mapType(@NotNull JSType type, Function<? super JSType, ? extends JSType> function2) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(9);
        }
        if (type instanceof TypeScriptNeverJSTypeImpl) {
            JSType jSType = type;
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        if (!(type instanceof JSUnionType)) {
            JSType jSType = (JSType)function2.fun((Object)type);
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(11);
            }
            return jSType;
        }
        JSType jSType = ((JSUnionType)type).transformTypes((NullableFunction<? super JSType, JSType>)((NullableFunction)arg_0 -> function2.fun(arg_0)));
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(12);
        }
        return jSType;
    }

    public static boolean isTypeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return TypeScriptTypeRelations.isTypeRelatedTo(source, target, context);
    }

    public static JSType getCanonicalType(@Nullable JSType type) {
        if (type instanceof JSDecoratedType) {
            type = ((JSDecoratedType)type).getOriginalType();
        }
        return TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(type);
    }

    @Contract(value="!null->!null")
    public static JSType getCanonicalTypeForExoticLiterals(@Nullable JSType type) {
        if (type instanceof JSExoticStringLiteralType) {
            return ((JSExoticStringLiteralType)type).asSimpleLiteralType();
        }
        return type;
    }

    public static boolean isTypeRelatedTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        return target != null && TypeScriptTypeRelations.getRegularTypeOfLiteralType(target).isDirectlyAssignableType(TypeScriptTypeRelations.getRegularTypeOfLiteralType(source), context);
    }

    public static boolean typeMaybeAssignableTo(@Nullable JSType source, @Nullable JSType target, @Nullable ProcessingContext context) {
        if (source instanceof JSUnionType) {
            return ((JSUnionType)source).getTypes().stream().anyMatch(el -> TypeScriptTypeRelations.typeMaybeAssignableTo(el, target, context));
        }
        return TypeScriptTypeRelations.isTypeAssignableTo(source, target, context);
    }

    @Contract(value="!null -> !null; null -> null")
    public static JSType expandAndOptimizeTypeRecursive(@Nullable JSType type) {
        if (type == null) {
            return null;
        }
        return type.substitute();
    }

    @Deprecated
    @Contract(value="!null->!null")
    public static JSType expandAliasesRecursive(@Nullable JSType originalType) {
        if (originalType == null) {
            return null;
        }
        if (originalType instanceof JSEvaluableOnlyType && originalType.isJavaScript()) {
            return originalType;
        }
        JSType type = originalType.substitute((JSTypeSubstitutionContext)new JSTypeSubstitutionContextImpl());
        return type == null ? JSAnyType.get(originalType.getSource()) : type;
    }

    public static boolean isInstantiableNonPrimitive(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(13);
        }
        return type instanceof TypeScriptMappedJSTypeImpl || type instanceof JSGenericParameterImpl || type instanceof TypeScriptConditionalTypeJSTypeImpl || type instanceof TypeScriptIndexedAccessJSTypeImpl;
    }

    public static boolean isInstantiablePrimitive(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(14);
        }
        return type instanceof JSKeyofType || type instanceof JSTemplateLiteralType || type instanceof TypeScriptStringMappingTypeImpl;
    }

    public static boolean isGenericIndexType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(15);
        }
        if (type instanceof JSUnionOrIntersectionType) {
            return ContainerUtil.exists(((JSUnionOrIntersectionType)type).getTypes(), TypeScriptTypeRelations::isGenericIndexType);
        }
        return (TypeScriptTypeRelations.isInstantiableNonPrimitive(type) || TypeScriptTypeRelations.isInstantiablePrimitive(type)) && !TypeScriptTypeRelations.isPatternLiteralType(type);
    }

    public static boolean isInstantiable(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(16);
        }
        return TypeScriptTypeRelations.isInstantiableNonPrimitive(type) || TypeScriptTypeRelations.isInstantiablePrimitive(type);
    }

    @Nullable
    public static JSType expandUnionOrIntersectionType(@NotNull JSType originalType, @NotNull JSTypeSubstitutionContext context) {
        List expandedTypes;
        List<JSType> types2;
        if (originalType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(17);
        }
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(18);
        }
        if (ContainerUtil.equalsIdentity(types2 = ((JSUnionOrIntersectionType)originalType).getTypes(), (List)(expandedTypes = ContainerUtil.map(types2, sub -> {
            JSType type = context.substituteNested(sub);
            return type == null ? JSAnyType.get(originalType.getSource()) : type;
        })))) {
            return originalType;
        }
        return TypeScriptTypeRelations.createTypeBy(originalType, expandedTypes);
    }

    @Nullable
    public static JSType getBaseConstraintOfType(@Nullable JSType type, @Nullable PsiElement context) {
        if (type == null) {
            return null;
        }
        if (type instanceof JSGenericParameterImpl) {
            return ((JSGenericParameterImpl)type).getConstraintType();
        }
        if (type instanceof JSKeyofType) {
            return TypeScriptTypeRelations.getKeyOfConstraintType(context);
        }
        if (type instanceof JSTemplateLiteralType) {
            return TypeScriptTypeRelations.getTemplateLiteralConstraintType((JSTemplateLiteralType)type);
        }
        if (type instanceof TypeScriptStringMappingTypeImpl) {
            return TypeScriptTypeRelations.getStringMappingConstraintType((TypeScriptStringMappingTypeImpl)type);
        }
        return null;
    }

    @NotNull
    private static JSType getStringMappingConstraintType(@NotNull TypeScriptStringMappingTypeImpl type) {
        JSType constraintOfType;
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(19);
        }
        if ((constraintOfType = TypeScriptTypeRelations.getBaseConstraintOfType(type.getType(), type.getSourceElement())) == null || constraintOfType == type.getType()) {
            return new JSStringType(true, type.getSource(), JSTypeContext.INSTANCE);
        }
        JSType jSType = TypeScriptStringMappingTypeImpl.createType(type.getKind(), constraintOfType, type.getSource());
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(20);
        }
        return jSType;
    }

    @NotNull
    public static JSType getKeyOfConstraintType(@Nullable PsiElement context) {
        TypeScriptConfig config2;
        JSTypeSource source = context == null ? JSTypeSource.EMPTY_TS : JSTypeSourceFactory.createTypeSource(context, true);
        TypeScriptConfig typeScriptConfig = config2 = context == null ? null : TypeScriptConfigUtil.getConfigForPsiFile(context.getContainingFile());
        if (config2 != null && config2.keyofStringsOnly()) {
            JSType jSType = JSNamedTypeFactory.createType("string", source, JSContext.INSTANCE);
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(21);
            }
            return jSType;
        }
        List<JSType> types2 = TypeScriptTypeRelations.getDefaultKeyOfTypes(source);
        JSType jSType = JSCompositeTypeFactory.createUnionType(source, types2);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(22);
        }
        return jSType;
    }

    @NotNull
    public static JSType getTemplateLiteralConstraintType(@NotNull JSTemplateLiteralType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(23);
        }
        if (type.getTypes().isEmpty()) {
            JSTemplateLiteralType jSTemplateLiteralType = type;
            if (jSTemplateLiteralType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(24);
            }
            return jSTemplateLiteralType;
        }
        ArrayList<JSType> newTypes = new ArrayList<JSType>(type.getTypes().size());
        for (JSType childType : type.getTypes()) {
            JSType constraint = TypeScriptTypeRelations.getBaseConstraintOfType(childType, type.getSourceElement());
            if (constraint == null) {
                return new JSStringType(true, type.getSource(), JSTypeContext.INSTANCE);
            }
            newTypes.add(constraint);
        }
        JSType jSType = TypeScriptTemplateLiteralJSTypeImpl.createType(type.getTexts(), newTypes, type.allowWidening(), type.getSource()).substitute();
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    @NotNull
    public static List<JSType> getDefaultKeyOfTypes(JSTypeSource source) {
        List list2 = ContainerUtil.map((Object[])JSCommonTypeNames.KEYOF_TYPES, typeName -> JSNamedTypeFactory.createType(typeName, source, JSContext.INSTANCE));
        if (list2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(26);
        }
        return list2;
    }

    @NotNull
    private static JSType createTypeBy(@NotNull JSType originalType, @NotNull List<JSType> expandedTypes) {
        if (originalType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(27);
        }
        if (expandedTypes == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(28);
        }
        if (originalType instanceof JSContextualUnionType) {
            JSType jSType = JSCompositeTypeFactory.createContextualUnionType(expandedTypes, originalType.getSource());
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(29);
            }
            return jSType;
        }
        if (originalType instanceof JSUnionType) {
            JSType jSType = JSCompositeTypeFactory.createUnionType(originalType.getSource(), expandedTypes);
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(30);
            }
            return jSType;
        }
        if (originalType instanceof JSIntersectionType) {
            JSType jSType = JSCompositeTypeFactory.createIntersectionType(expandedTypes, originalType.getSource());
            if (jSType == null) {
                TypeScriptTypeRelations.$$$reportNull$$$0(31);
            }
            return jSType;
        }
        JSType jSType = originalType;
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(32);
        }
        return jSType;
    }

    @NotNull
    public static JSType filterType(@Nullable JSType type, @NotNull Predicate<? super JSType> filter, @NotNull PsiElement context) {
        if (filter == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(33);
        }
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(34);
        }
        if (type == null) {
            return new TypeScriptNeverJSTypeImpl(JSTypeSourceFactory.createTypeSource(context, true));
        }
        if (type instanceof JSDecoratedType) {
            JSDecoratedType decorated = (JSDecoratedType)type;
            JSType original = decorated.getOriginalType();
            JSType filtered = TypeScriptTypeRelations.filterType(original, filter, context);
            if (filtered instanceof TypeScriptNeverJSTypeImpl) {
                JSType jSType = filtered;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(35);
                }
                return jSType;
            }
            if (filtered == original) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(36);
                }
                return jSType;
            }
            return new JSDecoratedTypeImpl(type.getSource(), filtered, decorated.getDecorations());
        }
        if (type instanceof JSUnionType) {
            List<JSType> types2 = ((JSUnionType)type).getTypes();
            List resultTypes = ContainerUtil.filter(types2, el -> filter.apply(el));
            if (types2.size() == resultTypes.size()) {
                JSType jSType = type;
                if (jSType == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(37);
                }
                return jSType;
            }
            return TypeScriptTypeRelations.getUnionType(resultTypes, type.getSource());
        }
        return filter.apply((Object)type) ? type : new TypeScriptNeverJSTypeImpl(type.getSource());
    }

    public static boolean isBooleanUnionType(@NotNull JSType type) {
        if (type == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(38);
        }
        if (!(type instanceof JSUnionType)) {
            return false;
        }
        List<JSType> types2 = ((JSUnionType)type).getTypes();
        if (types2.size() != 2) {
            return false;
        }
        JSType type1 = types2.get(0);
        JSType type2 = types2.get(1);
        if (!(type1 instanceof JSBooleanLiteralTypeImpl) || !(type2 instanceof JSBooleanLiteralTypeImpl)) {
            return false;
        }
        return ((JSBooleanLiteralTypeImpl)type1).getLiteral() != ((JSBooleanLiteralTypeImpl)type2).getLiteral();
    }

    @Nullable
    public static JSType getAsUnionIfBooleanOrEnum(@Nullable JSType type) {
        if (!((type = TypeScriptTypeRelations.getAsUnionTypeIfEnumWithLiterals(type)) instanceof JSBooleanType) || !((JSBooleanType)type).isPrimitive() || type instanceof JSBooleanLiteralTypeImpl) {
            return type;
        }
        JSTypeSource source = type.getSource();
        JSBooleanLiteralTypeImpl trueType = new JSBooleanLiteralTypeImpl(true, true, source);
        JSBooleanLiteralTypeImpl falseType = new JSBooleanLiteralTypeImpl(false, true, source);
        return JSCompositeTypeFactory.createUnionType(source, trueType, falseType);
    }

    @Contract(value="!null -> !null")
    public static JSType getAsUnionTypeIfEnumWithLiterals(@Nullable JSType type) {
        if (!(type instanceof JSResolvableType) || !type.isTypeScript()) {
            return type;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)type).resolveType();
        if (info.isEnumWithLiteralValues()) {
            return type.getLocalCachedType(() -> {
                JSType result2 = TypeScriptTypeRelations.createEnumValuesUnionType(type, info);
                return result2 == null ? type : result2;
            }, ENUM_VALUES_UNION_TYPE_KEY);
        }
        return type;
    }

    @NotNull
    public static JSType getUnionType(@NotNull Collection<? extends JSType> resultTypes, @NotNull JSTypeSource source) {
        if (resultTypes == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(39);
        }
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(40);
        }
        JSType jSType = JSCompositeTypeImpl.getCommonType(resultTypes, source, true);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(41);
        }
        return jSType;
    }

    @Contract(value="!null -> !null")
    public static JSType getRegularTypeOfLiteralType(@Nullable JSType valueType) {
        if ((valueType = JSTypeUtils.unwrapType(TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(valueType))) instanceof JSLiteralType && ((JSLiteralType)valueType).allowWidening()) {
            return ((JSLiteralType)valueType).copyWithAllowWidening(false);
        }
        return valueType;
    }

    @Nullable
    public static JSType createEnumValuesUnionType(@NotNull JSType elementType, @NotNull JSResolvedTypeInfo resolvedType) {
        Collection<TypeScriptEnum> enums;
        if (elementType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(42);
        }
        if (resolvedType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(43);
        }
        if ((enums = resolvedType.getDeclarationsOfType(TypeScriptEnum.class)).isEmpty()) {
            return null;
        }
        SmartList combinedTypeMembers = new SmartList();
        for (TypeScriptEnum enumDeclaration : enums) {
            JSField[] members;
            for (JSField member : members = enumDeclaration.getFields()) {
                combinedTypeMembers.add(JSNamedTypeFactory.createType(elementType.getTypeText() + "." + member.getName(), JSTypeSourceFactory.createTypeSource((PsiElement)member, true), JSTypeContext.INSTANCE, false));
            }
        }
        return combinedTypeMembers.isEmpty() ? null : JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource(elementType.getSourceElement(), true), (Collection<? extends JSType>)combinedTypeMembers);
    }

    @Nullable
    public static JSType getBestChoiceType(@Nullable JSType lType, @Nullable JSType rType, @NotNull PsiElement context) {
        if (context == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(44);
        }
        boolean isTypeScript = DialectDetector.isTypeScript(context);
        if (lType == null) {
            if (!isTypeScript) {
                return rType;
            }
            lType = JSAnyType.get(context, true);
        }
        if (rType == null) {
            if (!isTypeScript) {
                return lType;
            }
            rType = JSAnyType.get(context, true);
        }
        if (DialectDetector.isActionScript(context) || isTypeScript && (rType instanceof JSAnyType || lType instanceof JSAnyType)) {
            return JSTypeUtils.getCommonType(lType, rType, DialectDetector.dialectOfElement(context), true);
        }
        if (!isTypeScript) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(context, lType.isSourceStrict() && rType.isSourceStrict());
            return JSCompositeTypeFactory.createContextualUnionType(Arrays.asList(lType, rType), typeSource);
        }
        ProcessingContext processingContext = JSTypeComparingContextService.createSubtypingProcessingContext(context);
        boolean firstAssignableToSecond = TypeScriptTypeRelations.isTypeAssignableTo(lType, rType, processingContext);
        boolean secondAssignableToFirst = TypeScriptTypeRelations.isTypeAssignableTo(rType, lType, processingContext);
        if (secondAssignableToFirst && !firstAssignableToSecond) {
            return lType;
        }
        if (firstAssignableToSecond && !secondAssignableToFirst) {
            return rType;
        }
        return TypeScriptTypeRelations.subtypeReduction(JSCompositeTypeImpl.getCommonType(lType, rType, JSTypeSourceFactory.createTypeSource(context, true), true), context);
    }

    @NotNull
    private static JSType replaceTypeSourceByNotStrict(JSType partType) {
        JSType jSType = JSTypeUtils.copyWithStrictRecursive(partType, false);
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(45);
        }
        return jSType;
    }

    public static boolean checkEnumTypeForPrimitive(@NotNull JSResolvedTypeInfo resolvedType, @NotNull Class<?> primitiveClass) {
        if (resolvedType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(46);
        }
        if (primitiveClass == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(47);
        }
        return primitiveClass.isInstance(resolvedType.getEnumConstValue().getExpandedJSType(null));
    }

    @NotNull
    public static ThreeState areExplicitAssignableByNames(@NotNull String lText, @NotNull String rText) {
        if (lText == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(48);
        }
        if (rText == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(49);
        }
        switch (lText) {
            case "PromiseLike": {
                ThreeState threeState = "Promise".equals(rText) ? ThreeState.YES : ThreeState.UNSURE;
                if (threeState == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(50);
                }
                return threeState;
            }
            case "ArrayLike": 
            case "ConcatArray": {
                ThreeState threeState = JSCommonTypeNames.ARRAY_LIKE_CLASSES.contains(rText) ? ThreeState.YES : ThreeState.UNSURE;
                if (threeState == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(51);
                }
                return threeState;
            }
            case "Iterable": {
                ThreeState threeState = "ReadonlyArray".equals(rText) || "Array".equals(rText) ? ThreeState.YES : ThreeState.UNSURE;
                if (threeState == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(52);
                }
                return threeState;
            }
            case "Array": {
                ThreeState threeState = "ReadonlyArray".equals(rText) ? ThreeState.NO : ThreeState.UNSURE;
                if (threeState == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(53);
                }
                return threeState;
            }
            case "ReadonlyArray": {
                ThreeState threeState = "Array".equals(rText) ? ThreeState.YES : ThreeState.UNSURE;
                if (threeState == null) {
                    TypeScriptTypeRelations.$$$reportNull$$$0(54);
                }
                return threeState;
            }
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(55);
        }
        return threeState;
    }

    @NotNull
    public static JSCacheableTypeTransformerResolvedIdBase genericParametersToAnyTransformer() {
        return new JSCacheableTypeTransformerResolvedIdBase(){

            @NotNull
            public JSType fun(@NotNull JSType t) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSType jSType = t instanceof JSGenericParameterImpl ? JSAnyType.get(t.getSource()) : t;
                if (jSType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "t";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fun";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fun";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static boolean isTypeOrUnionOf(@Nullable JSType expressionJSType, @NotNull Class<? extends JSType> expectedType) {
        if (expectedType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(56);
        }
        if (expressionJSType == null) {
            return false;
        }
        if (expectedType.isInstance(expressionJSType)) {
            return true;
        }
        return expressionJSType instanceof JSUnionType && ((JSUnionType)expressionJSType).getTypes().stream().allMatch(t -> expectedType.isInstance(t));
    }

    public static boolean isUnionWithUndefinedType(@Nullable JSType p) {
        return p instanceof JSUnionType && ((JSUnionType)p).getTypes().stream().anyMatch(t -> t instanceof JSUndefinedType);
    }

    public static boolean checkCrossProductUnion(@NotNull Collection<JSType> types2) {
        if (types2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(57);
        }
        int size = 1;
        for (JSType type : types2) {
            if (type instanceof JSUnionType) {
                size *= ((JSUnionType)type).getTypes().size();
                continue;
            }
            if (!(type instanceof TypeScriptNeverJSTypeImpl)) continue;
            size = 0;
            break;
        }
        return size < 100000;
    }

    public static boolean isPatternLiteralType(@Nullable JSType type) {
        return type instanceof JSTemplateLiteralType && ContainerUtil.all(((JSTemplateLiteralType)type).getTypes(), TypeScriptTypeRelations::isPatternLiteralPlaceholderType);
    }

    public static boolean isPatternLiteralPlaceholderType(@Nullable JSType type) {
        return type instanceof JSStringType || type instanceof JSNumberType || type instanceof JSBooleanType || type instanceof JSBigIntType || type instanceof JSNullType || type instanceof JSUndefinedType || type instanceof JSAnyType;
    }

    public static <T extends JSType> boolean everyType(@NotNull List<T> types1, @NotNull List<T> types2, @NotNull BiFunction<? super T, ? super T, Boolean> comparer) {
        if (types1 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(58);
        }
        if (types2 == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(59);
        }
        if (comparer == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(60);
        }
        if (types1.size() != types2.size()) {
            return false;
        }
        for (int i = 0; i < types1.size(); ++i) {
            if (comparer.apply(types1.get(i), types2.get(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static JSType createTemplateLiteralConstraintType(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(61);
        }
        JSType jSType = JSCompositeTypeFactory.createUnionType(source, new JSStringType(true, source, JSTypeContext.INSTANCE), new JSBooleanType(true, source, JSTypeContext.INSTANCE), new JSBigIntType(true, source, JSTypeContext.INSTANCE), new JSNumberType(true, source, JSTypeContext.INSTANCE), new JSUndefinedType(source), new JSNullType(source));
        if (jSType == null) {
            TypeScriptTypeRelations.$$$reportNull$$$0(62);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 45: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 45: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 23: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 45: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedTypes";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultTypes";
                break;
            }
            case 40: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedType";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitiveClass";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lText";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rText";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types1";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types2";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeRelations";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "mapType";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringMappingConstraintType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyOfConstraintType";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateLiteralConstraintType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultKeyOfTypes";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeBy";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "filterType";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnionType";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceTypeSourceByNotStrict";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "areExplicitAssignableByNames";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplateLiteralConstraintType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTypeDerivedFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "subtypeReduction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reduceBySubtyping";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isClassType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSubsetOfOneEnumLiteral";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasBaseType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isTypeSubtypeOf";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCoercibleSource";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCoercibleTarget";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mapType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 45: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 62: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiableNonPrimitive";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiablePrimitive";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isGenericIndexType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isInstantiable";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "expandUnionOrIntersectionType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStringMappingConstraintType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateLiteralConstraintType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createTypeBy";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "filterType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanUnionType";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getUnionType";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createEnumValuesUnionType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getBestChoiceType";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkEnumTypeForPrimitive";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "areExplicitAssignableByNames";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isTypeOrUnionOf";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkCrossProductUnion";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "everyType";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateLiteralConstraintType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 45: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

