/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSElvisType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSControlFlowTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByNeverReturnOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSNarrowTypeByTypePredicateOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.guard.operations.TypeScriptNarrowTypeByInKeywordOperation;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import gnu.trove.TIntHashSet;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptTypeGuard
extends JSControlFlowTypeGuard {
    TypeScriptTypeGuard(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(0);
        }
        super(element);
    }

    private static boolean isOptionalProperty(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof JSProperty) {
            return false;
        }
        if (resolveResult instanceof JSInitializerOwner && ((JSInitializerOwner)resolveResult).hasInitializer()) {
            return false;
        }
        return resolveResult instanceof JSOptionalOwner && ((JSOptionalOwner)resolveResult).isOptional();
    }

    @Nullable
    private static JSType addUndefinedTypeForOptionalProperties(@Nullable JSType startType, @Nullable PsiElement resolveResult, @Nullable TypeScriptConfig config2) {
        if (config2 == null) {
            return startType;
        }
        if (TypeScriptTypeGuard.isOptionalProperty(resolveResult) && startType != null) {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource(resolveResult, true);
            return TypeScriptTypeGuard.wrapWithUndefined(startType, source);
        }
        return startType;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static JSType wrapWithUndefined(@Nullable JSType startType, @Nullable JSTypeSource source) {
        if (startType == null) {
            return null;
        }
        if (source == null) {
            source = startType.getSource();
        }
        if (!source.isTypeScript()) {
            return startType;
        }
        if (startType instanceof JSElvisType) {
            return ((JSElvisType)startType).isHadNullableComponent() ? startType : new JSElvisType(startType.getSource(), ((JSElvisType)startType).getOriginalType(), true);
        }
        if (startType instanceof JSUnionType && ((JSUnionType)startType).getTypes().stream().anyMatch(t -> t instanceof JSUndefinedType)) {
            return startType;
        }
        return TypeScriptTypeGuard.unionWithUndefined(startType, source);
    }

    @NotNull
    private static JSType unionWithUndefined(@NotNull JSType startType, @NotNull JSTypeSource source) {
        if (startType == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(1);
        }
        if (source == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(2);
        }
        JSType jSType = JSCompositeTypeFactory.createUnionType(source, startType, JSNamedTypeFactory.createType("undefined", source, JSContext.UNKNOWN));
        if (jSType == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(3);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeGuardChecker createTypeScriptTypeGuard(@NotNull PsiElement element, @Nullable JSType startType, @Nullable PsiElement resolveResult) {
        Pair<Boolean, Boolean> states;
        if (element == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(4);
        }
        TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(element.getContainingFile());
        boolean useAutoVariableType = false;
        boolean useAutoArrayType = false;
        if (resolveResult != null && TypeScriptTypeGuard.checkUseAutoTypeFromConfig(element, resolveResult, config2) && (states = JSTypeGuardUtil.getAutoTypeStates(resolveResult)) != null) {
            useAutoVariableType = (Boolean)states.first;
            useAutoArrayType = (Boolean)states.second;
        }
        boolean strictNullCheck = config2 != null && config2.strictNullChecks();
        return new JSTypeGuardChecker(element, TypeScriptTypeGuard.addUndefinedTypeForOptionalProperties(startType, resolveResult, config2), useAutoArrayType, useAutoVariableType, strictNullCheck);
    }

    @Override
    @NotNull
    protected JSTypeOperation createNarrowByCallExpressionOperation(@NotNull JSTypeOperation prev, @NotNull JSCallExpression expr, boolean assumeTrue, boolean isAssertion) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(5);
        }
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(6);
        }
        TIntHashSet matched = new TIntHashSet();
        TIntHashSet matchedNonRefs = new TIntHashSet();
        if (this.checkMethodCallPredicateCandidate(expr)) {
            matched.add(-1);
        }
        JSExpression[] arguments = expr.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            JSExpression argument = arguments[i];
            if (argument instanceof JSReferenceExpression && this.isMatchingReference(this.myElement, (PsiElement)argument)) {
                matched.add(i);
                continue;
            }
            if (!isAssertion || !SyntaxTraverser.psiTraverser((PsiElement)argument).filter(JSReferenceExpression.class).filter(r -> this.isMatchingReference(this.myElement, (PsiElement)r)).isNotEmpty()) continue;
            matchedNonRefs.add(i);
        }
        if (matched.isEmpty() && matchedNonRefs.isEmpty()) {
            if (!isAssertion || !assumeTrue) {
                JSTypeOperation jSTypeOperation = prev;
                if (jSTypeOperation == null) {
                    TypeScriptTypeGuard.$$$reportNull$$$0(7);
                }
                return jSTypeOperation;
            }
            return new JSNarrowTypeByNeverReturnOperation(prev, expr);
        }
        return new JSNarrowTypeByTypePredicateOperation(prev, (JSExpression)expr, matched, matchedNonRefs, assumeTrue, this::narrowTypeOperation, isAssertion);
    }

    private boolean checkMethodCallPredicateCandidate(@NotNull JSCallExpression expr) {
        JSExpression method;
        if (expr == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(8);
        }
        if ((method = expr.getMethodExpression()) instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)method).getQualifier();
            return this.isMatchingReference(this.myElement, (PsiElement)qualifier);
        }
        return false;
    }

    @Override
    @NotNull
    protected JSTypeOperation createNarrowTypeByInKeywordOperation(@NotNull JSTypeOperation prev, @NotNull PsiElement propertySource, @NotNull String property, boolean assumeTrue) {
        if (prev == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(9);
        }
        if (propertySource == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(10);
        }
        if (property == null) {
            TypeScriptTypeGuard.$$$reportNull$$$0(11);
        }
        return new TypeScriptNarrowTypeByInKeywordOperation(prev, propertySource, property, assumeTrue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeGuard";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySource";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/TypeScriptTypeGuard";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unionWithUndefined";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNarrowByCallExpressionOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unionWithUndefined";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTypeScriptTypeGuard";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowByCallExpressionOperation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodCallPredicateCandidate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createNarrowTypeByInKeywordOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

