/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTaskList;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.stubs.impl.JSFileStubBuilder;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSStubBasedExpressionType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType {
    private static final IStubElementType<?, ?>[] ELEMENT_TYPES = new IStubElementType[]{JSStubElementTypes.OBJECT_LITERAL_EXPRESSION, JSStubElementTypes.FUNCTION_EXPRESSION, JSStubElementTypes.TYPESCRIPT_FUNCTION_EXPRESSION, FlowJSElementTypes.FLOW_JS_FUNCTION_EXPRESSION, ES6StubElementTypes.CLASS_EXPRESSION, FlowJSElementTypes.FLOW_JS_CLASS_EXPRESSION, JSStubElementTypes.TYPESCRIPT_CLASS_EXPRESSION};
    @NotNull
    private final JSExpressionAnchor myAnchor;

    public JSStubBasedExpressionType(@NotNull StubBasedPsiElement<?> element, @NotNull JSTypeSource source) {
        if (element == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(1);
        }
        super(source);
        this.myAnchor = new JSExpressionAstAnchor(element);
    }

    public JSStubBasedExpressionType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(3);
        }
        super(source);
        int stubIndex = JSTypeSerializer.readInt(inputStream);
        int elementTypeIndex = JSTypeSerializer.readInt(inputStream);
        this.myAnchor = new JSExpressionStubAnchor(stubIndex, elementTypeIndex);
    }

    private JSStubBasedExpressionType(@NotNull JSExpressionAnchor anchor, @NotNull JSTypeSource source) {
        if (anchor == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(4);
        }
        if (source == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(5);
        }
        super(source);
        this.myAnchor = anchor;
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(6);
        }
        super.serialize(outputStream);
        if (ApplicationManager.getApplication().isUnitTestMode() && this.myAnchor instanceof JSExpressionAstAnchor) {
            ((JSExpressionAstAnchor)this.myAnchor).assertStubIndexCached();
        }
        JSTypeSerializer.writeInt(this.myAnchor.getStubIndex(), outputStream);
        JSTypeSerializer.writeInt(this.myAnchor.getElementTypeIndex(), outputStream);
    }

    @Override
    protected int hashCodeImpl() {
        JSExpression expression = this.findAssociatedExpression();
        return expression == null ? 0 : expression.hashCode();
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(7);
        }
        return Objects.equals(this.findAssociatedExpression(), ((JSStubBasedExpressionType)type).findAssociatedExpression());
    }

    @Override
    @NotNull
    protected JSStubBasedExpressionType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(8);
        }
        return new JSStubBasedExpressionType(this.myAnchor, source);
    }

    @Nullable
    public JSExpression findAssociatedExpression() {
        return this.myAnchor.findAssociatedExpression();
    }

    public void applyMappings(@NotNull Map<StubBasedPsiElement<?>, ObjectStubBase<?>> mappings) {
        if (mappings == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(9);
        }
        if (this.myAnchor instanceof JSExpressionAstAnchor) {
            ((JSExpressionAstAnchor)this.myAnchor).applyMappings(mappings);
        }
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext evaluateContext) {
        JSExpression expression;
        if (evaluateContext == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(10);
        }
        if ((expression = this.findAssociatedExpression()) == null) {
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSStubBasedExpressionType.$$$reportNull$$$0(11);
            }
            return jSEvaluationTaskList;
        }
        JSEvaluateContext newContext = evaluateContext.withCombinedStrictness(!JSTypeEvaluator.isEmptyJSObjectLiteral(expression));
        JSTypeEvaluationResultProcessor processor = new JSTypeEvaluationResultProcessor();
        JSTypeEvaluator.createEvaluator(processor, (PsiElement)expression, newContext).doEvaluateTypesStubSafely(expression);
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(Collections.unmodifiableList(processor.getNotNullResult().getResults()));
        if (jSEvaluationTask == null) {
            JSStubBasedExpressionType.$$$reportNull$$$0(12);
        }
        return jSEvaluationTask;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSStubBasedExpressionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSStubBasedExpressionType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyMappings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class JSExpressionStubAnchor
    implements JSExpressionAnchor {
        private final int myStubIndex;
        private final int myElementTypeIndex;
        @Nullable
        private SoftReference<StubBasedPsiElement<?>> myRestoredElement;

        private JSExpressionStubAnchor(int stubIndex, int elementTypeIndex) {
            this.myStubIndex = stubIndex;
            this.myElementTypeIndex = elementTypeIndex;
        }

        @Override
        @Nullable
        public JSExpression findAssociatedExpression() {
            JSExpression restored = (JSExpression)SoftReference.deref(this.myRestoredElement);
            if (restored != null) {
                return restored;
            }
            PsiFile scope = JSStubBasedExpressionType.this.getScope();
            if (scope == null) {
                return null;
            }
            if (!(scope instanceof PsiFileWithStubSupport)) {
                Logger.getInstance(JSStubBasedExpressionType.class).error("Not PsiFileWithStubSupport:" + scope.getClass());
                return null;
            }
            IStubElementType<?, ?> type = ELEMENT_TYPES[this.myElementTypeIndex];
            PsiElement element = PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)((PsiFileWithStubSupport)scope), (int)this.myStubIndex, type, (boolean)false);
            if (!(element instanceof JSExpression)) {
                Logger.getInstance(JSStubBasedExpressionType.class).error("Not JSExpression: " + element + " expected element type: " + type.getExternalId() + " file: " + scope.getName() + " index: " + this.myStubIndex);
                return null;
            }
            this.myRestoredElement = new SoftReference((Object)((StubBasedPsiElement)element));
            return (JSExpression)element;
        }

        @Override
        public int getStubIndex() {
            return this.myStubIndex;
        }

        @Override
        public int getElementTypeIndex() {
            return this.myElementTypeIndex;
        }
    }

    private final class JSExpressionAstAnchor
    implements JSExpressionAnchor {
        @NotNull
        private final StubBasedPsiElement<?> myElement;
        private int myCachedStubIndex;
        private int myCachedElementTypeIndex;

        private JSExpressionAstAnchor(StubBasedPsiElement<?> element) {
            if (element == null) {
                JSExpressionAstAnchor.$$$reportNull$$$0(0);
            }
            this.myCachedStubIndex = -1;
            this.myCachedElementTypeIndex = -1;
            this.myElement = element;
        }

        @Override
        @NotNull
        public JSExpression findAssociatedExpression() {
            JSExpression jSExpression = (JSExpression)this.myElement;
            if (jSExpression == null) {
                JSExpressionAstAnchor.$$$reportNull$$$0(1);
            }
            return jSExpression;
        }

        @Override
        public int getStubIndex() {
            int stubIndex = this.myCachedStubIndex;
            if (stubIndex == -1) {
                stubIndex = PsiAnchor.calcStubIndex(this.myElement);
                if (stubIndex == -1) {
                    throw new IllegalArgumentException(this.myElement.getElementType().getExternalId() + " not found");
                }
                this.myCachedStubIndex = stubIndex;
            }
            return stubIndex;
        }

        @Override
        public int getElementTypeIndex() {
            int elementTypeIndex = this.myCachedElementTypeIndex;
            if (elementTypeIndex == -1) {
                elementTypeIndex = ArrayUtil.indexOf((Object[])ELEMENT_TYPES, (Object)this.myElement.getElementType());
                if (elementTypeIndex == -1) {
                    throw new IllegalArgumentException(this.myElement.getElementType().getExternalId() + " is not supported");
                }
                this.myCachedElementTypeIndex = elementTypeIndex;
            }
            return elementTypeIndex;
        }

        private void applyMappings(@NotNull Map<StubBasedPsiElement<?>, ObjectStubBase<?>> mappings) {
            if (mappings == null) {
                JSExpressionAstAnchor.$$$reportNull$$$0(2);
            }
            if (this.myCachedStubIndex == -1) {
                ObjectStubBase<?> stub = mappings.get(this.myElement);
                if (stub == null) {
                    Logger.getInstance(JSStubBasedExpressionType.class).error("Mapping was not found");
                } else {
                    if (ApplicationManager.getApplication().isUnitTestMode() && stub.getStubType() != this.myElement.getElementType()) {
                        Logger.getInstance(JSStubBasedExpressionType.class).error("Mappings are invalid: stub type = " + stub.getStubType() + ", myElement type = " + this.myElement.getElementType());
                    }
                    this.myCachedStubIndex = stub.getStubId();
                }
            }
        }

        private void assertStubIndexCached() {
            IStubFileElementType fileElementType;
            PsiFile scope;
            if (this.myCachedStubIndex == -1 && (scope = JSStubBasedExpressionType.this.getScope()) instanceof PsiFileImpl && (fileElementType = ((PsiFileImpl)scope).getElementTypeForStubBuilder()) != null && fileElementType.getBuilder() instanceof JSFileStubBuilder) {
                Logger.getInstance(JSStubBasedExpressionType.class).error("myStubIndex wasn't set");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSStubBasedExpressionType$JSExpressionAstAnchor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSStubBasedExpressionType$JSExpressionAstAnchor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findAssociatedExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyMappings";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface JSExpressionAnchor {
        @Nullable
        public JSExpression findAssociatedExpression();

        public int getStubIndex();

        public int getElementTypeIndex();
    }
}

