/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTagContextBuilder;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeGuardEvaluator;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTaskList;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSTypeOfPsiElementBase;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceExpressionType
extends JSTypeOfPsiElementBase<JSReferenceExpression>
implements JSEvaluableOnlyType {
    private static final int MAX_RESOLVE_RESULT_COUNT_TO_EVALUATE_DEEPLY = 3;

    public JSReferenceExpressionType(@NotNull JSReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(0);
        }
        super(referenceExpression);
    }

    private JSReferenceExpressionType(@NotNull JSReferenceExpression referenceExpression, @NotNull JSTypeSource typeSource) {
        if (referenceExpression == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(1);
        }
        if (typeSource == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(2);
        }
        super(referenceExpression, typeSource);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(3);
        }
        return new JSReferenceExpressionType((JSReferenceExpression)this.getElement(), source);
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext context) {
        boolean addUnknownElement;
        JSType type;
        JSExpression qualifier;
        JSExpression exprQualifier;
        JSReferenceExpression expression;
        String referenceName;
        if (context == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(4);
        }
        if ("prototype".equals(referenceName = (expression = (JSReferenceExpression)this.getElement()).getReferenceName()) && !DialectDetector.isTypeScript((PsiElement)expression) && (exprQualifier = expression.getQualifier()) instanceof JSReferenceExpression) {
            JSType qualifierType = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)exprQualifier, context);
            JSApplyNewType type2 = new JSApplyNewType(qualifierType, JSTypeSourceFactory.createTypeSource((PsiElement)expression, true));
            JSEvaluationResultElement jSEvaluationResultElement = JSEvaluationResultElement.fromType(type2, context);
            if (jSEvaluationResultElement == null) {
                JSReferenceExpressionType.$$$reportNull$$$0(5);
            }
            return jSEvaluationResultElement;
        }
        if ("constructor".equals(referenceName) && DialectDetector.isJavaScript((PsiElement)expression) && (qualifier = expression.getQualifier()) != null && (type = JSResolveUtil.getExpressionJSType(qualifier, context.isContextualOverloadEvaluation())) instanceof JSNamedType && ((JSNamedType)type).getJSContext() != JSContext.STATIC) {
            JSEvaluationResultElement jSEvaluationResultElement = JSEvaluationResultElement.fromType((JSType)((JSNamedType)type).copyWithJSContext(JSContext.STATIC), context);
            if (jSEvaluationResultElement == null) {
                JSReferenceExpressionType.$$$reportNull$$$0(6);
            }
            return jSEvaluationResultElement;
        }
        if (JSSymbolUtil.isExplicitExportReference(expression) && DialectDetector.isJavaScript((PsiElement)expression)) {
            return JSReferenceExpressionType.addDefaultExportNamespaces(expression, context);
        }
        Object[] resolveResults = JSReferenceExpressionType.getResolveResultsFromQualifier(expression);
        ResolveResult[] resultsToProcess = JSReferenceExpressionType.shouldSkipProcessing((ResolveResult[])resolveResults) ? ResolveResult.EMPTY_ARRAY : resolveResults;
        boolean isResolveStrict = JSResolveUtil.isResolveStrict((PsiReference)expression, (ResolveResult[])resolveResults);
        JSTypeEvaluationResultProcessor resultsProcessor = new JSTypeEvaluationResultProcessor();
        JSEvaluateContext referenceContext = context.withCombinedStrictness(isResolveStrict).withProcessedExpression(expression);
        JSTypeEvaluator subEvaluator = JSTypeEvaluator.createEvaluator(resultsProcessor, (PsiElement)expression, referenceContext);
        for (ResolveResult resolveResult : resultsToProcess) {
            subEvaluator.addTypeFromResolveResult(referenceName, resolveResult);
        }
        ArrayList<JSEvaluationTask> tasks = new ArrayList<JSEvaluationTask>(3);
        boolean evaluateDeeply = !DialectDetector.isJavaScript((PsiElement)expression) || resolveResults.length <= 3;
        this.addTasksForResolveResults(resultsProcessor.getNotNullResult().getResults(), evaluateDeeply, true, this.getSource(), referenceContext, tasks);
        tasks.add(JSReferenceExpressionType.getAdditionalTypes(expression, context));
        boolean bl = addUnknownElement = resultsToProcess.length == 0 || JSReferenceType.addUnknownElementFromResolveResults((PsiElement)expression, ContainerUtil.mapNotNull((Object[])resolveResults, ResolveResult::getElement));
        if (addUnknownElement) {
            tasks.add(JSReferenceExpressionType.getTaskForUnknownElement((PsiElement)expression, context));
        }
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(tasks);
        if (jSEvaluationTask == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(7);
        }
        return jSEvaluationTask;
    }

    private static boolean shouldSkipProcessing(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(8);
        }
        if (resolveResults.length < 20) {
            return false;
        }
        return !JSResolveUtil.isTypeScriptDeclarationMerging(resolveResults);
    }

    @NotNull
    private static JSEvaluationTask addDefaultExportNamespaces(@NotNull JSReferenceExpression exportReference, @NotNull JSEvaluateContext context) {
        if (exportReference == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(9);
        }
        if (context == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(10);
        }
        PsiFile file2 = exportReference.getContainingFile();
        JSQualifiedNameImpl moduleExportsName = JSQualifiedNameImpl.fromComponents("module", "exports");
        JSNamespace moduleExports = JSNamedTypeFactory.createNamespace(moduleExportsName, JSContext.STATIC, (PsiElement)file2, true, true, true);
        JSEvaluationResultElement moduleExportsType = JSEvaluationResultElement.fromAdditionalType((JSType)moduleExports, context);
        JSNamespace exports = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("exports", null), JSContext.STATIC, (PsiElement)file2, true, true, true);
        JSEvaluationResultElement exportsType = JSEvaluationResultElement.fromAdditionalType((JSType)exports, context);
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(List.of(moduleExportsType, exportsType));
        if (jSEvaluationTask == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(11);
        }
        return jSEvaluationTask;
    }

    private static ResolveResult @NotNull [] getResolveResultsFromQualifier(@NotNull JSReferenceExpression qualifier) {
        if (qualifier == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(12);
        }
        ResolveResult[] resolveResult = qualifier.multiResolve(false);
        boolean hasModules = false;
        for (ResolveResult result2 : resolveResult) {
            if (!(result2.getElement() instanceof TypeScriptModule)) continue;
            hasModules = true;
            break;
        }
        if (!hasModules || resolveResult.length <= 1) {
            if (resolveResult == null) {
                JSReferenceExpressionType.$$$reportNull$$$0(13);
            }
            return resolveResult;
        }
        ArrayList<ResolveResult> newResults = new ArrayList<ResolveResult>(resolveResult.length);
        HashSet<String> visitedQualifiers = new HashSet<String>();
        for (ResolveResult result3 : resolveResult) {
            PsiElement element = result3.getElement();
            if (!(element instanceof TypeScriptModule)) {
                newResults.add(result3);
                continue;
            }
            TypeScriptModule module = (TypeScriptModule)element;
            if (module.isAugmentation() || !visitedQualifiers.add(module.getQualifiedName())) continue;
            newResults.add(result3);
        }
        ResolveResult[] resolveResultArray = newResults.size() == resolveResult.length ? resolveResult : newResults.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(14);
        }
        return resolveResultArray;
    }

    @NotNull
    private static JSEvaluationTask getAdditionalTypes(@NotNull JSReferenceExpression qualifier, @NotNull JSEvaluateContext context) {
        if (qualifier == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(15);
        }
        if (context == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(16);
        }
        if (DialectDetector.isTypeScript((PsiElement)qualifier) || DialectDetector.isActionScript((PsiElement)qualifier)) {
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSReferenceExpressionType.$$$reportNull$$$0(17);
            }
            return jSEvaluationTaskList;
        }
        JSEvaluationTask types2 = JSTypeEvaluator.getAdditionalTypes((PsiElement)qualifier, (JSReferenceItem)qualifier, context);
        if ("getComponentById".equals(qualifier.getReferenceName())) {
            JSEvaluationTasks.fromList(List.of(types2, JSReferenceExpressionType.getBindowsType(qualifier, context)));
        }
        JSEvaluationTask jSEvaluationTask = types2;
        if (jSEvaluationTask == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(18);
        }
        return jSEvaluationTask;
    }

    @NotNull
    private static JSEvaluationTask getBindowsType(@NotNull JSReferenceExpression qualifier, @NotNull JSEvaluateContext context) {
        JSIndexContent content;
        Collection<JSImplicitElementsIndex.JSElementProxy> proxies;
        PsiFile containingFile;
        PsiElement element;
        if (qualifier == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(19);
        }
        if (context == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(20);
        }
        if (!((element = qualifier.getParent()) instanceof JSCallExpression)) {
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSReferenceExpressionType.$$$reportNull$$$0(21);
            }
            return jSEvaluationTaskList;
        }
        JSArgumentList argumentList = ((JSCallExpression)element).getArgumentList();
        if (argumentList == null) {
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSReferenceExpressionType.$$$reportNull$$$0(22);
            }
            return jSEvaluationTaskList;
        }
        JSExpression[] expressions = argumentList.getArguments();
        if (expressions.length == 0 || !(expressions[0] instanceof JSLiteralExpression)) {
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSReferenceExpressionType.$$$reportNull$$$0(23);
            }
            return jSEvaluationTaskList;
        }
        String val = StringUtil.unquoteString((String)expressions[0].getText());
        PsiElement contextElement = qualifier.getContainingFile().getContext();
        if (contextElement != null && JSTagContextBuilder.isBindowsXml(containingFile = contextElement.getContainingFile()) && (proxies = (content = JSIndexContent.get(containingFile)).getImplicitElements().get(val)) != null) {
            for (JSImplicitElementsIndex.JSElementProxy proxy : proxies) {
                XmlTag tag;
                PsiElement elementAtOffset = proxy.toOffsetBasedImplicitElement(containingFile).getElementAtOffset();
                if (elementAtOffset == null || (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)elementAtOffset, XmlTag.class)) == null) continue;
                JSType type = JSNamedTypeFactory.createType(JSTagContextBuilder.getTypeName(tag), JSTypeSourceFactory.createTypeSource(elementAtOffset, false), JSContext.UNKNOWN);
                return new JSEvaluationResultElement(type, false, elementAtOffset, context);
            }
        }
        JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
        if (jSEvaluationTaskList == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(24);
        }
        return jSEvaluationTaskList;
    }

    private void addTasksForResolveResults(@NotNull Collection<JSEvaluationResultElement> results, boolean evaluateDeeply, boolean addGuardedTypeFromEmpty, @NotNull JSTypeSource source, @NotNull JSEvaluateContext context, List<JSEvaluationTask> tasks) {
        if (results == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(25);
        }
        if (source == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(26);
        }
        if (context == null) {
            JSReferenceExpressionType.$$$reportNull$$$0(27);
        }
        boolean typeGuardAppliedAtLeastOnce = false;
        ArrayList<JSEvaluationTask> elementsFromResults = new ArrayList<JSEvaluationTask>();
        ArrayList<JSEvaluationResultElement> evaluableElements = new ArrayList<JSEvaluationResultElement>();
        for (JSEvaluationResultElement resultElement : results) {
            JSType type = resultElement.getType();
            if (JSReferenceExpressionType.isEvaluableType(type)) {
                evaluableElements.add(resultElement);
                continue;
            }
            JSEvaluateContext contextForResultElement = context.combineWith(resultElement.getEvaluateContext());
            JSType typeOrAdditionalType = resultElement.getTypeOrAdditionalType();
            if (type != null) {
                typeGuardAppliedAtLeastOnce = true;
                PsiElement resolvedElement = contextForResultElement.getSource();
                typeOrAdditionalType = JSTypeGuardEvaluator.applyToExpressionType(type, (JSExpression)this.myElement, resolvedElement, contextForResultElement);
            }
            elementsFromResults.add(new JSEvaluationResultElement(typeOrAdditionalType, resultElement.isAdditionalType(), resultElement.getSource(), contextForResultElement));
        }
        if (!evaluableElements.isEmpty()) {
            elementsFromResults.add(JSEvaluationResultElement.fromType(new JSApplyResolveResultsType(evaluableElements, evaluateDeeply, addGuardedTypeFromEmpty && !typeGuardAppliedAtLeastOnce, source), context));
        }
        tasks.add(JSEvaluationTasks.fromSet(elementsFromResults, this.isJavaScript()));
        if (evaluableElements.isEmpty() && addGuardedTypeFromEmpty && !typeGuardAppliedAtLeastOnce) {
            JSReferenceExpression expression = (JSReferenceExpression)this.getElement();
            JSEvaluateContext referenceContext = context.withProcessedExpression(expression);
            JSType typeFromGuard = JSTypeGuardEvaluator.applyToExpressionType(null, (JSExpression)expression, expression.resolve(), referenceContext);
            if (typeFromGuard != null) {
                tasks.add(JSEvaluationResultElement.fromType(typeFromGuard, context.withCombinedStrictness(false)));
            }
        }
    }

    private static boolean isEvaluableType(@Nullable JSType type) {
        return type instanceof JSEvaluableOnlyType && !(type instanceof JSPropertiesOwnerType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 10: 
            case 16: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSReferenceExpressionType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportReference";
                break;
            }
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSReferenceExpressionType";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addDefaultExportNamespaces";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveResultsFromQualifier";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalTypes";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getBindowsType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipProcessing";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDefaultExportNamespaces";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResolveResultsFromQualifier";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalTypes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getBindowsType";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "addTasksForResolveResults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class JSApplyResolveResultsType
    extends JSEvaluableOnlyTypeBase
    implements JSEvaluableOnlyType {
        @NotNull
        private final Collection<JSEvaluationResultElement> myResults;
        private final boolean myEvaluateDeeply;
        private final boolean myAddGuardedTypeFromEmpty;

        JSApplyResolveResultsType(Collection<JSEvaluationResultElement> results, boolean evaluateDeeply, @NotNull boolean addGuardedTypeFromEmpty, JSTypeSource source) {
            if (results == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(0);
            }
            if (source == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(1);
            }
            super(source);
            if (results.isEmpty()) {
                throw new IllegalArgumentException("Can't be empty");
            }
            for (JSEvaluationResultElement result2 : results) {
                JSType type = result2.getTypeOrAdditionalType();
                if (JSReferenceExpressionType.isEvaluableType(type)) continue;
                throw new IllegalArgumentException("Only evaluable types are allowed");
            }
            this.myResults = results;
            this.myEvaluateDeeply = evaluateDeeply;
            this.myAddGuardedTypeFromEmpty = addGuardedTypeFromEmpty;
        }

        @Override
        @NotNull
        protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
            if (source == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(2);
            }
            return new JSApplyResolveResultsType(this.myResults, this.myEvaluateDeeply, this.myAddGuardedTypeFromEmpty, source);
        }

        @Override
        protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
            if (type == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(3);
            }
            JSApplyResolveResultsType other = (JSApplyResolveResultsType)type;
            if (!this.getReferenceExpressionType().isEquivalentTo(other.getReferenceExpressionType(), context, allowResolve)) {
                return false;
            }
            return this.myResults.equals(other.myResults) && this.myEvaluateDeeply == other.myEvaluateDeeply && this.myAddGuardedTypeFromEmpty == other.myAddGuardedTypeFromEmpty;
        }

        @NotNull
        JSReferenceExpressionType getReferenceExpressionType() {
            JSReferenceExpressionType jSReferenceExpressionType = JSReferenceExpressionType.this;
            if (jSReferenceExpressionType == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(4);
            }
            return jSReferenceExpressionType;
        }

        @Override
        protected int hashCodeImpl() {
            return Objects.hash(JSTypeHashCodeUtil.getHashCode(this.myResults), this.getReferenceExpressionType(), this.myEvaluateDeeply, this.myAddGuardedTypeFromEmpty);
        }

        @Override
        public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
            if (visitor == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(5);
            }
            for (JSEvaluationResultElement result2 : this.myResults) {
                JSType additionalType;
                JSType type = result2.getType();
                if (type != null) {
                    type.accept(visitor);
                }
                if ((additionalType = result2.getAdditionalType()) == null) continue;
                additionalType.accept(visitor);
            }
        }

        @Override
        @NotNull
        public JSEvaluationTask evaluate(@NotNull JSEvaluateContext context) {
            if (context == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(6);
            }
            ArrayList<JSEvaluationTask> newTasks = new ArrayList<JSEvaluationTask>();
            JSTypeEvaluationResultProcessor resultProcessor = new JSTypeEvaluationResultProcessor();
            JSReferenceExpression expression = (JSReferenceExpression)JSReferenceExpressionType.this.getElement();
            JSEvaluateContext referenceContext = context.withProcessedExpression(expression);
            for (JSEvaluationResultElement resultElement : this.myResults) {
                JSType type = resultElement.getType();
                assert (type != null);
                JSEvaluateContext resultElementContext = referenceContext.combineWith(resultElement.getEvaluateContext());
                if (!this.myEvaluateDeeply && !this.isResolveResultType(type)) {
                    newTasks.add(JSApplyResolveResultsType.getTaskForUnknownElement((PsiElement)expression, resultElementContext));
                    continue;
                }
                JSTypeEvaluator.evaluateWithRecursionGuard((JSEvaluableOnlyType)type, resultElementContext, resultProcessor);
            }
            List newResults = ContainerUtil.filter(resultProcessor.getNotNullResult().getResults(), er -> {
                JSType type = er.getTypeOrAdditionalType();
                return !this.hasSameReference(type);
            });
            JSReferenceExpressionType.this.addTasksForResolveResults(newResults, this.myEvaluateDeeply, this.myAddGuardedTypeFromEmpty, this.getSource(), referenceContext, newTasks);
            JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromSet(newTasks, this.isJavaScript());
            if (jSEvaluationTask == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(7);
            }
            return jSEvaluationTask;
        }

        private boolean hasSameReference(@NotNull JSType type) {
            if (type == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(8);
            }
            final Ref found = Ref.create((Object)false);
            type.accept(new JSRecursiveTypeVisitor(){

                public void visitJSType(@NotNull JSType type) {
                    if (type == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!((Boolean)found.get()).booleanValue()) {
                        if (type instanceof JSApplyResolveResultsType && ((JSApplyResolveResultsType)type).getReferenceExpressionType().equals(JSApplyResolveResultsType.this.getReferenceExpressionType())) {
                            found.set((Object)true);
                        } else {
                            super.visitJSType(type);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/evaluable/JSReferenceExpressionType$JSApplyResolveResultsType$1", "visitJSType"));
                }
            });
            return (Boolean)found.get();
        }

        private boolean isResolveResultType(@NotNull JSType type) {
            if (type == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(9);
            }
            if (!(type instanceof JSPsiBasedTypeOfType)) {
                return false;
            }
            Object element = ((JSPsiBasedTypeOfType)type).getElement();
            return !(element instanceof JSExpression) || !JSTypeEvaluator.isEvaluatedAsExpression((JSExpression)element);
        }

        @Override
        public boolean matchesSourceElement() {
            return false;
        }

        @NotNull
        public JSType transformTypes(@NotNull NotNullFunction<? super JSType, ? extends JSType> converter) {
            if (converter == null) {
                JSApplyResolveResultsType.$$$reportNull$$$0(10);
            }
            if (this.myResults.isEmpty()) {
                JSApplyResolveResultsType jSApplyResolveResultsType = this;
                if (jSApplyResolveResultsType == null) {
                    JSApplyResolveResultsType.$$$reportNull$$$0(11);
                }
                return jSApplyResolveResultsType;
            }
            JSTypeEvaluationResult newTypeEvaluationResult = new JSTypeEvaluationResult();
            for (JSEvaluationResultElement result2 : this.myResults) {
                JSType type = result2.getTypeOrAdditionalType();
                JSType transformedType = (JSType)converter.fun((Object)type);
                if (transformedType != type) {
                    result2 = new JSEvaluationResultElement(transformedType, result2.isAdditionalType(), result2.getSource(), result2.getEvaluateContext());
                }
                newTypeEvaluationResult.addResultElement(result2);
            }
            return new JSApplyResolveResultsType(newTypeEvaluationResult.getResults(), this.myEvaluateDeeply, this.myAddGuardedTypeFromEmpty, this.getSource());
        }

        public boolean isEmpty() {
            return this.myResults.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "results";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 3: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSReferenceExpressionType$JSApplyResolveResultsType";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "converter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSReferenceExpressionType$JSApplyResolveResultsType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferenceExpressionType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "evaluate";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformTypes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "copyWithNewSource";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEquivalentToWithSameClass";
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "acceptChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluate";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "hasSameReference";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "isResolveResultType";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "transformTypes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

