/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.evaluable;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTaskList;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSApplyIndexedAccessType
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType,
JSType.CompositeStructure {
    @NotNull
    private final JSType myQualifierType;
    @Nullable
    private final JSType myArgumentType;

    public JSApplyIndexedAccessType(@NotNull JSType qualifierType, @Nullable JSType argumentType, @NotNull JSTypeSource source) {
        if (qualifierType == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(1);
        }
        super(source);
        this.myQualifierType = qualifierType;
        this.myArgumentType = argumentType;
    }

    public JSApplyIndexedAccessType(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(3);
        }
        super(source);
        this.myQualifierType = JSTypeSerializer.TYPE_SERIALIZER.read(source, inputStream);
        this.myArgumentType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myQualifierType, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myArgumentType, outputStream);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(5);
        }
        this.myQualifierType.accept(visitor);
        if (this.myArgumentType != null) {
            this.myArgumentType.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(6);
        }
        return new JSApplyIndexedAccessType(this.myQualifierType, this.myArgumentType, source);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myQualifierType, this.myArgumentType);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(7);
        }
        return this.myQualifierType.isEquivalentTo(((JSApplyIndexedAccessType)type).myQualifierType, context, allowResolve) && (this.myArgumentType == null ? ((JSApplyIndexedAccessType)type).myArgumentType == null : this.myArgumentType.isEquivalentTo(((JSApplyIndexedAccessType)type).myArgumentType, context, allowResolve));
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(8);
        }
        JSType newQualifierType = this.myQualifierType.transformTypeHierarchy(childTransform);
        JSType newArgumentType = JSTypeUtils.transformTypeHierarchySafe(this.myArgumentType, childTransform);
        if (newQualifierType == this.myQualifierType && this.myArgumentType == newArgumentType) {
            JSApplyIndexedAccessType jSApplyIndexedAccessType = this;
            if (jSApplyIndexedAccessType == null) {
                JSApplyIndexedAccessType.$$$reportNull$$$0(9);
            }
            return jSApplyIndexedAccessType;
        }
        return new JSApplyIndexedAccessType(newQualifierType, newArgumentType, this.getSource());
    }

    @NotNull
    public JSType getQualifierType() {
        JSType jSType = this.myQualifierType;
        if (jSType == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @Nullable
    public JSType getArgumentType() {
        return this.myArgumentType;
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext evaluateContext) {
        JSType componentType;
        JSType qualifierType;
        if (evaluateContext == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(11);
        }
        if ((qualifierType = this.getQualifierType()) instanceof JSTupleType && this.myArgumentType instanceof JSNumberLiteralTypeImpl) {
            JSTupleType tupleType = (JSTupleType)qualifierType;
            Double literal = ((JSNumberLiteralTypeImpl)this.myArgumentType).getLiteral();
            int index = literal.intValue();
            if (literal == (double)index && tupleType.hasTypeByIndex(index)) {
                JSType typeByIndex = tupleType.getTypeByIndex(index);
                if (typeByIndex != null) {
                    JSEvaluationResultElement jSEvaluationResultElement = JSEvaluationResultElement.fromType(typeByIndex, evaluateContext);
                    if (jSEvaluationResultElement == null) {
                        JSApplyIndexedAccessType.$$$reportNull$$$0(12);
                    }
                    return jSEvaluationResultElement;
                }
                JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
                if (jSEvaluationTaskList == null) {
                    JSApplyIndexedAccessType.$$$reportNull$$$0(13);
                }
                return jSEvaluationTaskList;
            }
        }
        if ((componentType = JSTypeUtils.getIndexableComponentType(qualifierType.substitute())) != null) {
            JSType optimizeTypeIfComposite = componentType.substitute();
            if (optimizeTypeIfComposite instanceof JSUnionType) {
                optimizeTypeIfComposite = JSTypeUtils.copyWithStrict(optimizeTypeIfComposite, false);
            }
            JSEvaluationResultElement jSEvaluationResultElement = JSEvaluationResultElement.fromType(optimizeTypeIfComposite, evaluateContext);
            if (jSEvaluationResultElement == null) {
                JSApplyIndexedAccessType.$$$reportNull$$$0(14);
            }
            return jSEvaluationResultElement;
        }
        JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
        if (jSEvaluationTaskList == null) {
            JSApplyIndexedAccessType.$$$reportNull$$$0(15);
        }
        return jSEvaluationTaskList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/evaluable/JSApplyIndexedAccessType";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/evaluable/JSApplyIndexedAccessType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierType";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

