/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptStringLiteralType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeOperator;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptLiteralBasedPropertyElementImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerResolvedIdBase;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTaggedLiteralKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeKeyTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutionContextImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithGenericParameters;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedTypeGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveReadonlyArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptMappedJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSTypeWithIncompleteSubstitution,
JSDistributedType,
JSEvaluableType,
JSTypeWithGenericParameters {
    private static final Key<Map<JSResolvedTypeId, Set<JSResolvedTypeId>>> CONVERT_TO_INDEX_ACCESS_KEY = Key.create((String)"convert.as.index.key");
    private static final String INFER_GENERIC_PREFIX = "_infer_";
    private final boolean myReadonly;
    private final boolean myMinusReadonly;
    private final boolean myOptional;
    private final boolean myMinusOptional;
    @NotNull
    private final JSTypeSubstitutor.JSTypeGenericId myParameterId;
    @NotNull
    private final JSType myParameterType;
    @NotNull
    private final JSType myResultType;
    @Nullable
    private final JSType myNameType;
    private final AtomicNotNullLazyValue<Boolean> myHasForeignParameters;
    private static final int MAX_SOURCE_DEPTH = 10;

    @ApiStatus.Internal
    public TypeScriptMappedJSTypeImpl(@NotNull JSTypeSource source, boolean isReadonly, boolean isOptional, boolean isMinusReadonly, boolean isMinusOptional, @NotNull JSTypeSubstitutor.JSTypeGenericId parameterId, @NotNull JSType parameterType, @NotNull JSType resultType, @Nullable JSType nameType) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameterId == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (parameterType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(2);
        }
        if (resultType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(3);
        }
        super(source);
        this.myHasForeignParameters = AtomicNotNullLazyValue.createValue(() -> JSTypeUtils.hasForeignGenericParameter(this.getParameterType(), ContainerUtil.newHashSet((Object[])new JSTypeSubstitutor.JSTypeGenericId[]{this.getParameterId()})));
        this.myReadonly = isReadonly;
        this.myMinusReadonly = isMinusReadonly;
        this.myOptional = isOptional;
        this.myMinusOptional = isMinusOptional;
        this.myParameterId = parameterId;
        this.myParameterType = parameterType;
        this.myResultType = resultType;
        this.myNameType = nameType;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(5);
        }
        builder.append("{");
        boolean readonly = this.isReadonly();
        boolean minusReadonly = this.isMinusReadonly();
        if (readonly || minusReadonly) {
            builder.append(minusReadonly ? "-readonly " : "readonly ");
        }
        builder.append("[");
        String name = this.getParameterName();
        builder.append(name);
        builder.append(" in ");
        this.getParameterType().buildTypeText(format, builder);
        JSType nameType = this.getNameType();
        if (nameType != null) {
            builder.append(" as ");
            nameType.buildTypeText(format, builder);
        }
        builder.append("]");
        boolean optional = this.isOptional();
        boolean minusOptional = this.isMinusOptional();
        if (optional || minusOptional) {
            builder.append(optional ? "?" : "-?");
        }
        builder.append(this.getTypeSeparator());
        this.getResultType().buildTypeText(format, builder);
        builder.append("}");
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.getParameterType(), this.getResultType());
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> childTransform) {
        if (childTransform == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(6);
        }
        JSType newParameterType = JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform);
        JSType newResultType = JSTypeUtils.transformTypeHierarchySafe(this.getResultType(), childTransform);
        JSType newNamedType = JSTypeUtils.transformTypeHierarchySafe(this.getNameType(), childTransform);
        if (newParameterType == this.getParameterType() && newResultType == this.getResultType() && newNamedType == this.getNameType()) {
            TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
            if (typeScriptMappedJSTypeImpl == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(7);
            }
            return typeScriptMappedJSTypeImpl;
        }
        JSType jSType = JSCompositeTypeFactory.createMappedType(this.getSource(), this.isReadonly(), this.isOptional(), this.isMinusReadonly(), this.isMinusOptional(), this.myParameterId, newParameterType, newResultType, newNamedType);
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(8);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(9);
        }
        return new TypeScriptMappedJSTypeImpl(source, this.myReadonly, this.myOptional, this.myMinusReadonly, this.myMinusOptional, this.myParameterId, this.myParameterType, this.myResultType, this.myNameType);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType substitute;
        if (elementType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(10);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(11);
        }
        if ((substitute = this.substitute()) != this) {
            return substitute.isDirectlyAssignableType(elementType, processingContext);
        }
        JSType paramType = this.getParameterType();
        if (JSTypeCastUtil.isTypeOperatorLikeType(paramType) && TypeScriptMappedJSTypeImpl.isDirectAssignableForMappedTypeWithTypeOperator(elementType, this, processingContext, false)) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    public Set<JSTypeSubstitutor.JSTypeGenericId> getGenericIds() {
        return Collections.singleton(this.myParameterId);
    }

    public static boolean isDirectAssignableForMappedTypeWithTypeOperator(@NotNull JSType operand, @NotNull TypeScriptMappedJSTypeImpl mappedType, @NotNull ProcessingContext processingContext, boolean isDirectComparing) {
        if (operand == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(12);
        }
        if (mappedType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(13);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(14);
        }
        JSType paramType = mappedType.getParameterType();
        TypeScriptMappedTypeGenericParameterImpl nameAsType = new TypeScriptMappedTypeGenericParameterImpl(mappedType.myParameterId, mappedType.getSource());
        JSType typeForGuard = TypeScriptMappedJSTypeImpl.getSubstitutionTypeInIndexAccess(operand);
        Boolean referencedType = TypeScriptMappedJSTypeImpl.processHomomorphicType(operand, mappedType, processingContext, paramType);
        if (referencedType != null) {
            return referencedType;
        }
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(typeForGuard.getResolvedTypeId(), nameAsType.getResolvedTypeId(), CONVERT_TO_INDEX_ACCESS_KEY, nameAsType, processingContext, (type, ctx) -> {
            JSType result2;
            JSType indexedType = JSCompositeTypeFactory.createIndexedAccessType(operand, type, mappedType.getSource());
            if (!TypeScriptMappedJSTypeImpl.isAssignableDirectOrInverseType(indexedType, result2 = mappedType.getResultType(), ctx, isDirectComparing)) {
                return false;
            }
            if (JSGenericTypesEvaluator.isGenericProcessingInProgress(ctx) && JSTypeUtils.hasForeignGenericParameter(paramType)) {
                JSType typeOperator = JSCompositeTypeFactory.createKeyOfType(operand, operand.getSource());
                TypeScriptMappedJSTypeImpl.isAssignableDirectOrInverseType(typeOperator, paramType, ctx, isDirectComparing);
            }
            return true;
        });
    }

    @Nullable
    private static Boolean processHomomorphicType(@NotNull JSType operand, @NotNull TypeScriptMappedJSTypeImpl mappedType, @NotNull ProcessingContext processingContext, JSType paramType) {
        JSType parameterType;
        if (operand == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(15);
        }
        if (mappedType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(16);
        }
        if (processingContext == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(17);
        }
        if (!(paramType instanceof JSKeyofType)) {
            return null;
        }
        JSType referencedType = ((JSKeyofType)paramType).getReferencedType();
        JSType resultType = mappedType.getResultType();
        if (resultType instanceof TypeScriptIndexedAccessJSTypeImpl && (parameterType = ((TypeScriptIndexedAccessJSTypeImpl)resultType).getParameterType()) instanceof JSGenericParameterType && mappedType.getGenericIds().contains(((JSGenericParameterType)parameterType).getGenericId()) && referencedType.isEquivalentTo(((TypeScriptIndexedAccessJSTypeImpl)resultType).getOwner(), processingContext)) {
            return referencedType instanceof JSGenericParameterType && operand.isJavaScript() || referencedType.isDirectlyAssignableType(operand, processingContext);
        }
        if (JSGenericTypesEvaluator.isGenericProcessingInProgress(processingContext) && referencedType instanceof JSGenericParameterType) {
            HashMap<String, JSRecordType.MemberSource> sourceMap = new HashMap<String, JSRecordType.MemberSource>();
            Collection allProperties = operand.asRecordType().getProperties();
            HashSet<String> optionalProps = new HashSet<String>();
            HashSet<String> readonlyProps = new HashSet<String>();
            for (JSRecordType.PropertySignature property : allProperties) {
                JSGenericParameterImpl temp_Generic = new JSGenericParameterImpl((JSTypeSubstitutor.JSTypeGenericId)new JSTypeSubstitutor.StringGenericId(INFER_GENERIC_PREFIX + property.getMemberName()), resultType.getSource(), JSGenericParameterType.JSGenericState.APPLYING, null);
                JSType type = resultType.transformTypeHierarchy(t -> t instanceof TypeScriptIndexedAccessJSTypeImpl && TypeScriptMappedJSTypeImpl.isIndexedByOwnKey((TypeScriptIndexedAccessJSTypeImpl)t, mappedType.getGenericIds()) ? temp_Generic : t);
                JSType propType = property.getJSType();
                if (propType == null) continue;
                RecursionManager.doPreventingRecursion((Object)"TypeScriptMappedJSTypeImpl.processHomomorphicType", (boolean)false, () -> {
                    JSRecursiveTypeUtil.computeWithRecursiveTypes(type.getResolvedTypeId(), propType.getResolvedTypeId(), CONVERT_TO_INDEX_ACCESS_KEY, propType, processingContext, (t, ctx) -> type.isDirectlyAssignableType(t, ctx));
                    return null;
                });
                sourceMap.put(property.getMemberName(), JSRecordMemberSourceFactory.createSource(property.getMemberSource().getAllSourceElements(), JSRecordType.MemberSourceKind.MappedNoStatus));
                if (property.isOptional()) {
                    optionalProps.add(property.getMemberName());
                }
                if (!property.isConst()) continue;
                readonlyProps.add(property.getMemberName());
            }
            JSGenericMappings mappings = (JSGenericMappings)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey);
            ArrayList<JSRecordType.TypeMember> newTypeProps = new ArrayList<JSRecordType.TypeMember>();
            int inferredCount = 0;
            for (JSTypeSubstitutor.JSTypeGenericId id : new HashSet(mappings.getMapping().keySet())) {
                String name = id.getName();
                if (!name.startsWith(INFER_GENERIC_PREFIX)) continue;
                Collection types2 = mappings.getMapping().remove((Object)id);
                String propName = name.substring(INFER_GENERIC_PREFIX.length());
                if (types2 == null || !sourceMap.containsKey(propName)) continue;
                JSType type = JSCompositeTypeFactory.createUnionType(referencedType.getSource(), types2);
                newTypeProps.addAll(TypeScriptMappedJSTypeImpl.mapNameAndCreateProperty(mappedType, propName, type, readonlyProps.contains(propName), optionalProps.contains(propName), (JSRecordType.MemberSource)sourceMap.get(propName), null));
                ++inferredCount;
            }
            if (inferredCount == allProperties.size()) {
                mappings.getMapping().put((Object)((JSGenericParameterType)referencedType).getGenericId(), (Collection)new SmartList((Object)new JSRecordTypeImpl(referencedType.getSource(), newTypeProps)));
            }
        }
        return null;
    }

    private static boolean isIndexedByOwnKey(TypeScriptIndexedAccessJSTypeImpl t, Set<JSTypeSubstitutor.JSTypeGenericId> ids) {
        JSType type = t.getParameterType();
        return type instanceof JSGenericParameterType && ids.contains(((JSGenericParameterType)type).getGenericId());
    }

    private static boolean isAssignableDirectOrInverseType(@NotNull JSType thisType, @NotNull JSType rType, @NotNull ProcessingContext context, boolean direct) {
        if (thisType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(18);
        }
        if (rType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(19);
        }
        if (context == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(20);
        }
        return direct ? thisType.isDirectlyAssignableType(rType, context) : rType.isDirectlyAssignableType(thisType, context);
    }

    @NotNull
    public static JSType getSubstitutionTypeInIndexAccess(@NotNull JSType elementType) {
        if (elementType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(21);
        }
        while (elementType instanceof TypeScriptIndexedAccessJSTypeImpl) {
            elementType = ((TypeScriptIndexedAccessJSTypeImpl)elementType).getOwner();
        }
        JSType jSType = elementType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(22);
        }
        return jSType;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(23);
        }
        if (this.myHasForeignParameters.getValue() == Boolean.TRUE) {
            return this;
        }
        return this.substituteInternal(context);
    }

    @NotNull
    public JSType substituteCompletely() {
        if (this.myHasForeignParameters.getValue() == Boolean.TRUE) {
            JSType jSType = this.getLocalCachedType(() -> this.substituteInternal(new JSTypeSubstitutionContextImpl()), SUBSTITUTE_COMPLETE);
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(24);
            }
            return jSType;
        }
        JSType jSType = this.substitute();
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    public boolean hasForeignGenericParameters() {
        return this.myHasForeignParameters.getValue() == Boolean.TRUE;
    }

    @Nullable
    private JSType substituteInternal(@NotNull JSTypeSubstitutionContext context) {
        JSType distributeType;
        if (context == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(26);
        }
        if ((distributeType = this.distributeType()) != this) {
            return distributeType;
        }
        JSType parameterType = this.getParameterType();
        JSType originalResultType = this.getResultType();
        JSType type = context.substituteNested(parameterType);
        if (type == null) {
            return null;
        }
        Collection<String> strings = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(type);
        if (strings.isEmpty()) {
            JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
            substitutor.put(this.getParameterId(), (JSType)new JSStringType(true, this.getSource(), JSTypeContext.INSTANCE));
            JSType resultType = JSTypeUtils.applyGenericArguments(originalResultType, substitutor);
            if (this.myOptional) {
                resultType = TypeScriptTypeGuard.wrapWithUndefined(resultType, this.getSource());
            }
            if (JSTypeUtils.isAnyType(type) || type instanceof JSGenericParameterType) {
                return new JSRecordTypeImpl(this.getSource(), Collections.singletonList(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, this.getSource(), JSTypeContext.INSTANCE), resultType, this.getSourceElement(), false)));
            }
            if (type instanceof JSStringType || type instanceof JSNumberType || type instanceof JSSymbolType) {
                return new JSRecordTypeImpl(this.getSource(), Collections.singletonList(new JSRecordTypeImpl.IndexSignatureImpl(type, resultType, this.getSourceElement(), false)));
            }
            if (type instanceof JSUnionType && ((JSUnionType)type).getTypes().stream().allMatch(t -> t instanceof JSStringType || t instanceof JSNumberType || t instanceof JSSymbolType)) {
                return new JSRecordTypeImpl(this.getSource(), Arrays.asList(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, this.getSource(), JSTypeContext.INSTANCE), resultType, this.getSourceElement(), false), new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSNumberType(true, this.getSource(), JSTypeContext.INSTANCE), resultType, this.getSourceElement(), false)));
            }
            if (type instanceof TypeScriptNeverJSTypeImpl) {
                return new JSRecordTypeImpl(this.getSource(), Collections.emptyList());
            }
            return JSAnyType.getWithLanguage(this.getSource().getLanguage(), this.isSourceStrict());
        }
        boolean hasOptionalKeyword = this.isOptional();
        boolean hasMinusOptionalKeyword = this.isMinusOptional();
        SmartList result2 = new SmartList();
        JSRecordType originalType = TypeScriptMappedJSTypeImpl.getOriginalType(parameterType);
        Map<String, LiteralStatus> sources = TypeScriptMappedJSTypeImpl.buildLiteralSourceElementsMap(parameterType, context);
        if (originalResultType instanceof TypeScriptIndexedAccessJSTypeImpl && TypeScriptMappedJSTypeImpl.isParameter(this.myParameterId, ((TypeScriptIndexedAccessJSTypeImpl)originalResultType).getParameterType())) {
            TypeScriptIndexedAccessJSTypeImpl accessJSType = (TypeScriptIndexedAccessJSTypeImpl)originalResultType;
            JSType owner = accessJSType.getOwner();
            if (JSTypeUtils.isAnyType(owner)) {
                JSAnyType pureAny = JSAnyType.get(owner.getSource());
                for (String string : strings) {
                    result2.add(new JSRecordTypeImpl.PropertySignatureImpl(string, (JSType)pureAny, hasOptionalKeyword, this.isReadonly(), type.getSourceElement()));
                }
            } else {
                JSRecordType ownerRecordType = owner.asRecordType();
                HashSet<String> propertyNames = new HashSet<String>(strings);
                for (JSRecordType.TypeMember member : ownerRecordType.getTypeMembers()) {
                    JSRecordType.PropertySignature propertySignature;
                    String memberName;
                    if (!(member instanceof JSRecordType.PropertySignature) || !propertyNames.contains(memberName = (propertySignature = (JSRecordType.PropertySignature)member).getMemberName())) continue;
                    LiteralStatus status = sources.get(memberName);
                    JSRecordType.MemberSource source = this.computeCommonMemberSource(status == null ? Collections.emptySet() : status.sources, originalType, propertySignature, memberName);
                    boolean originalOptional = TypeScriptMappedJSTypeImpl.calcOriginalOptional(originalType, source, memberName, status);
                    boolean propIsOptional = hasOptionalKeyword || TypeScriptMappedJSTypeImpl.canPropagateOptionalStatus(parameterType) && !hasMinusOptionalKeyword && originalOptional;
                    result2.addAll(this.mapNameAndCreateProperty(memberName, propertySignature.getJSType(), propIsOptional, this.isReadonly(), source, context));
                }
            }
        } else {
            List<JSRecordType> keyBases = TypeScriptMappedJSTypeImpl.getKeyBases(parameterType);
            for (String string : strings) {
                final JSStringLiteralTypeImpl toReplace = !keyBases.isEmpty() ? new JSTypeKeyTypeImpl(string, keyBases, originalResultType.getSource()) : new JSStringLiteralTypeImpl(string, false, originalResultType.getSource());
                JSType propertyType = originalResultType.transformTypeHierarchy((JSRecursiveTypeTransformer)new JSCacheableTypeTransformerResolvedIdBase(){

                    @NotNull
                    public JSType fun(@NotNull JSType el) {
                        if (el == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        JSType jSType = TypeScriptMappedJSTypeImpl.isParameter(TypeScriptMappedJSTypeImpl.this.myParameterId, el) ? toReplace : el;
                        if (jSType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return jSType;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 1: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 1: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "el";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl$1";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "fun";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "fun";
                                break;
                            }
                            case 1: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 1: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                });
                LiteralStatus status = sources.get(string);
                JSRecordType.MemberSource source = this.computeCommonMemberSource(status == null ? Collections.emptySet() : status.sources, originalType, null, string);
                boolean originalOptional = TypeScriptMappedJSTypeImpl.calcOriginalOptional(originalType, source, string, status);
                boolean propIsOptional = hasOptionalKeyword || TypeScriptMappedJSTypeImpl.canPropagateOptionalStatus(parameterType) && !hasMinusOptionalKeyword && originalOptional;
                result2.addAll(this.mapNameAndCreateProperty(string, propertyType, propIsOptional, this.isReadonly(), source, context));
            }
        }
        JSTypeSource typeSource = originalType != null ? originalType.getSource() : this.getSource();
        typeSource = TypeScriptMappedJSTypeImpl.updateIfFromJSDoc(typeSource, originalResultType);
        return new JSRecordTypeImpl(typeSource, (List<? extends JSRecordType.TypeMember>)result2);
    }

    @NotNull
    private List<JSRecordType.TypeMember> mapNameAndCreateProperty(@NotNull String memberName, @Nullable JSType type, boolean propIsOptional, boolean readonly, @NotNull JSRecordType.MemberSource source, @Nullable JSTypeSubstitutionContext context) {
        if (memberName == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(27);
        }
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(28);
        }
        return TypeScriptMappedJSTypeImpl.mapNameAndCreateProperty(this, memberName, type, propIsOptional, readonly, source, context);
    }

    @NotNull
    private static List<JSRecordType.TypeMember> mapNameAndCreateProperty(final @NotNull TypeScriptMappedJSTypeImpl mappedType, @NotNull String memberName, @Nullable JSType type, boolean propIsOptional, boolean readonly, @NotNull JSRecordType.MemberSource source, @Nullable JSTypeSubstitutionContext context) {
        JSType nameType;
        if (mappedType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(29);
        }
        if (memberName == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(30);
        }
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(31);
        }
        if ((nameType = mappedType.getNameType()) != null) {
            final JSStringLiteralTypeImpl toReplace = new JSStringLiteralTypeImpl(memberName, false, nameType.getSource());
            JSType newNamedType = nameType.transformTypeHierarchy((JSRecursiveTypeTransformer)new JSCacheableTypeTransformerResolvedIdBase(){

                @NotNull
                public JSType fun(@NotNull JSType el) {
                    if (el == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    JSType jSType = TypeScriptMappedJSTypeImpl.isParameter(mappedType.getParameterId(), el) ? toReplace : el;
                    if (jSType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return jSType;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "el";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "fun";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "fun";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            JSType substitute = context == null ? newNamedType.substitute() : context.substituteNested(newNamedType);
            SmartList result2 = new SmartList();
            List<JSType> types2 = substitute instanceof JSUnionType ? ((JSUnionType)substitute).getTypes() : Collections.singletonList(substitute);
            for (JSType jsType : types2) {
                if (!(jsType instanceof JSStringLiteralTypeImpl)) continue;
                memberName = ((JSStringLiteralTypeImpl)jsType).getLiteral();
                result2.add(new JSRecordTypeImpl.PropertySignatureImpl(memberName, type, propIsOptional, readonly, source));
            }
            SmartList smartList = result2;
            if (smartList == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(32);
            }
            return smartList;
        }
        List<JSRecordTypeImpl.PropertySignatureImpl> list2 = Collections.singletonList(new JSRecordTypeImpl.PropertySignatureImpl(memberName, type, propIsOptional, readonly, source));
        if (list2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(33);
        }
        return list2;
    }

    @NotNull
    private static JSTypeSource updateIfFromJSDoc(@NotNull JSTypeSource typeSource, @Nullable JSType resultType) {
        JSType owner;
        if (typeSource == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(34);
        }
        if (resultType instanceof TypeScriptIndexedAccessJSTypeImpl && (owner = ((TypeScriptIndexedAccessJSTypeImpl)resultType).getOwner()) instanceof JSRecordType && owner.isJavaScript() && owner.getSourceElement() instanceof JSDocComment) {
            JSTypeSource jSTypeSource = owner.getSource();
            if (jSTypeSource == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(35);
            }
            return jSTypeSource;
        }
        JSTypeSource jSTypeSource = typeSource;
        if (jSTypeSource == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(36);
        }
        return jSTypeSource;
    }

    private static boolean calcOriginalOptional(@Nullable JSRecordType originalType, @NotNull JSRecordType.MemberSource source, @NotNull String memberName, @Nullable LiteralStatus status) {
        PsiElement element;
        JSRecordType.PropertySignature originalSignature;
        if (source == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(37);
        }
        if (memberName == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(38);
        }
        JSRecordType.PropertySignature propertySignature = originalSignature = originalType != null ? originalType.findPropertySignature(memberName) : null;
        if (originalSignature != null) {
            return originalSignature.isOptional();
        }
        List elements = source.getAllSourceElements();
        if (elements.size() == 1 && (element = (PsiElement)elements.get(0)) instanceof JSRecordType.PropertySignature) {
            return ((JSRecordType.PropertySignature)element).isOptional();
        }
        return status != null && status.isOptional();
    }

    private static boolean canPropagateOptionalStatus(@Nullable JSType parameterType) {
        if (!(parameterType instanceof JSUnionOrIntersectionType)) {
            return true;
        }
        return parameterType.getSourceElement() instanceof TypeScriptTypeOperator;
    }

    @NotNull
    private static List<JSRecordType> getKeyBases(@Nullable JSType parameterType) {
        if (parameterType instanceof JSKeyofType) {
            List<JSRecordType> list2 = Collections.singletonList(((JSKeyofType)parameterType).getReferencedType().asRecordType());
            if (list2 == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(39);
            }
            return list2;
        }
        if (parameterType instanceof JSUnionOrIntersectionType) {
            List<JSRecordType> list3 = ((JSUnionOrIntersectionType)parameterType).getTypes().stream().filter(t -> t instanceof JSKeyofType).map(t -> ((JSKeyofType)t).getReferencedType().asRecordType()).collect(Collectors.toList());
            if (list3 == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(40);
            }
            return list3;
        }
        List list4 = ContainerUtil.emptyList();
        if (list4 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(41);
        }
        return list4;
    }

    @NotNull
    private static List<JSType> collectReferencedTypes(@Nullable JSType type, boolean expandTypeof) {
        JSResolvedTypeInfo info;
        JSType alias;
        if (type instanceof JSKeyofType) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)((JSKeyofType)type).getReferencedType());
            if (list2 == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(42);
            }
            return list2;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            ArrayList<JSType> types2 = new ArrayList<JSType>();
            for (JSType part : ((JSUnionOrIntersectionType)type).getTypes()) {
                types2.addAll(TypeScriptMappedJSTypeImpl.collectReferencedTypes(part, false));
            }
            ArrayList<JSType> arrayList = types2;
            if (arrayList == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(43);
            }
            return arrayList;
        }
        if (expandTypeof && type instanceof JSResolvableType && (alias = (info = ((JSResolvableType)type).resolveType()).getAliasedType()) != null) {
            return TypeScriptMappedJSTypeImpl.collectReferencedTypes(alias, false);
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(44);
        }
        return list3;
    }

    @Nullable
    private static JSRecordType getOriginalType(@Nullable JSType type) {
        List<JSType> types2 = TypeScriptMappedJSTypeImpl.collectReferencedTypes(type, true);
        if (types2.size() == 0) {
            return null;
        }
        if (types2.size() == 1) {
            return types2.get(0).asRecordType();
        }
        assert (type != null);
        return JSCompositeTypeFactory.createUnionType(type.getSource(), types2).asRecordType();
    }

    @NotNull
    private JSRecordType.MemberSource computeCommonMemberSource(@NotNull Set<PsiElement> extraSourceElements, @Nullable JSRecordType originalType, @Nullable JSRecordType.PropertySignature propertySignature, @NotNull String memberName) {
        JSRecordType.MemberSource originalSignatureSource;
        JSRecordType.PropertySignature originalSignature;
        JSRecordType.MemberSource source;
        if (extraSourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(45);
        }
        if (memberName == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(46);
        }
        JSRecordType.MemberSource memberSource = source = propertySignature == null ? JSRecordMemberSourceFactory.createEmptySource() : propertySignature.getMemberSource().copyWithKind(this.getMemberSourceKind());
        if (originalType != null && (originalSignature = originalType.findPropertySignature(memberName)) != null && !(originalSignatureSource = originalSignature.getMemberSource()).isEmpty()) {
            source = source.isEmpty() ? originalSignatureSource.copyWithKind(this.getMemberSourceKind()) : JSRecordMemberSourceFactory.createSource(ContainerUtil.concat((List)source.getAllSourceElements(), (List)originalSignatureSource.getAllSourceElements()), this.getMemberSourceKind());
        }
        ArrayList<PsiElement> sourceElements = new ArrayList<PsiElement>();
        if (!source.isEmpty()) {
            sourceElements.addAll(source.getAllSourceElements());
        }
        sourceElements.addAll(extraSourceElements);
        JSRecordType.MemberSource memberSource2 = JSRecordMemberSourceFactory.createSource(sourceElements, this.getMemberSourceKind());
        if (memberSource2 == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(47);
        }
        return memberSource2;
    }

    @NotNull
    private JSRecordType.MemberSourceKind getMemberSourceKind() {
        JSRecordType.MemberSourceKind memberSourceKind = JSRecordType.MemberSourceKind.getMappedKind((boolean)this.isOptional(), (boolean)this.isMinusOptional(), (boolean)this.isReadonly(), (boolean)this.isMinusReadonly());
        if (memberSourceKind == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(48);
        }
        return memberSourceKind;
    }

    @NotNull
    private static Map<String, LiteralStatus> buildLiteralSourceElementsMap(@Nullable JSType type, @NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(49);
        }
        if (type == null) {
            Map<String, LiteralStatus> map = Collections.emptyMap();
            if (map == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(50);
            }
            return map;
        }
        HashMap<String, LiteralStatus> map = new HashMap<String, LiteralStatus>();
        TypeScriptMappedJSTypeImpl.fillExtraLiteralSourceElements(type, map, context, 0);
        HashMap<String, LiteralStatus> hashMap = map;
        if (hashMap == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(51);
        }
        return hashMap;
    }

    private static void fillExtraLiteralSourceElements(@Nullable JSType type, @NotNull Map<String, LiteralStatus> sourceElements, @NotNull JSTypeSubstitutionContext context, int depth) {
        PsiElement owner;
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(52);
        }
        if (context == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(53);
        }
        if (depth > 10 || type == null) {
            return;
        }
        if (type instanceof JSTypeImpl) {
            TypeScriptEnumField field;
            JSResolvedTypeInfo typeInfo = ((JSTypeImpl)type).resolveType();
            if (typeInfo.getDeclarationOfType(TypeScriptTypeAlias.class) != null) {
                TypeScriptMappedJSTypeImpl.addSourceElementsFromAliasedType(sourceElements, typeInfo.getAliasedType());
                return;
            }
            if (typeInfo.isEnumWithLiteralValues()) {
                TypeScriptEnum tsEnum = typeInfo.getDeclarationOfType(TypeScriptEnum.class);
                if (tsEnum != null) {
                    for (JSField field2 : tsEnum.getFields()) {
                        TypeScriptMappedJSTypeImpl.putIfStringLiteral(sourceElements, (TypeScriptEnumField)field2);
                    }
                }
            } else if (typeInfo.isEnumLiteral() && (field = typeInfo.getDeclarationOfType(TypeScriptEnumField.class)) != null) {
                TypeScriptMappedJSTypeImpl.putIfStringLiteral(sourceElements, field);
            }
        }
        if ((type = context.substituteNested(type)) instanceof JSUnionOrIntersectionType) {
            for (JSType part : JSCompositeTypeBaseImpl.flattenTypes(((JSUnionOrIntersectionType)type).getTypes().stream(), type.getClass())) {
                TypeScriptMappedJSTypeImpl.fillExtraLiteralSourceElements(part, sourceElements, context, depth + 1);
            }
        }
        if (type instanceof JSTypeKeyTypeImpl) {
            String literal = ((JSTypeKeyTypeImpl)type).getLiteral();
            LiteralStatus status = TypeScriptMappedJSTypeImpl.getStatus(sourceElements, literal);
            status.addKey((JSTypeKeyTypeImpl)type);
        }
        if (type instanceof JSTaggedLiteralKeyTypeImpl && (owner = type.getSource().getSourceElement()) instanceof TypeScriptStringLiteralType) {
            String literal = ((JSTaggedLiteralKeyTypeImpl)type).getLiteral();
            LiteralStatus status = TypeScriptMappedJSTypeImpl.getStatus(sourceElements, literal);
            status.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(literal, owner));
        }
    }

    private static void putIfStringLiteral(@NotNull Map<String, LiteralStatus> sourceElements, @NotNull TypeScriptEnumField field) {
        String stringValue;
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(54);
        }
        if (field == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(55);
        }
        if (!StringUtil.isEmpty((String)(stringValue = field.getConstantValue().getAsString()))) {
            LiteralStatus status = TypeScriptMappedJSTypeImpl.getStatus(sourceElements, stringValue);
            status.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(stringValue, (PsiElement)field));
        }
    }

    @NotNull
    private static LiteralStatus getStatus(@NotNull Map<String, LiteralStatus> sourceElements, @NotNull String stringValue) {
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(56);
        }
        if (stringValue == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(57);
        }
        LiteralStatus literalStatus = sourceElements.computeIfAbsent(stringValue, key -> new LiteralStatus());
        if (literalStatus == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(58);
        }
        return literalStatus;
    }

    private static void addSourceElementsFromAliasedType(@NotNull Map<String, LiteralStatus> sourceElements, @Nullable JSType typedef) {
        if (sourceElements == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(59);
        }
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)t -> {
            if (t instanceof JSStringLiteralTypeImpl) {
                PsiElement owner = t.getSource().getSourceElement();
                String literal = ((JSStringLiteralTypeImpl)t).getLiteral();
                if (owner instanceof TypeScriptLiteralType) {
                    LiteralStatus status = TypeScriptMappedJSTypeImpl.getStatus(sourceElements, literal);
                    status.add((PsiElement)new TypeScriptLiteralBasedPropertyElementImpl(literal, owner));
                } else if ((owner instanceof JSField || owner instanceof JSProperty) && t instanceof JSTypeKeyTypeImpl) {
                    LiteralStatus status = TypeScriptMappedJSTypeImpl.getStatus(sourceElements, literal);
                    status.add(owner);
                }
            }
            return true;
        }), typedef, false, true, true);
    }

    private static boolean isParameter(@NotNull JSTypeSubstitutor.JSTypeGenericId id, @NotNull JSType el) {
        if (id == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(60);
        }
        if (el == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(61);
        }
        return el instanceof TypeScriptMappedTypeGenericParameterImpl && id.equals((Object)((TypeScriptMappedTypeGenericParameterImpl)el).getGenericId());
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    public boolean isMinusReadonly() {
        return this.myMinusReadonly;
    }

    public boolean isMinusOptional() {
        return this.myMinusOptional;
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(62);
        }
        TypeScriptMappedJSTypeImpl mappedType = (TypeScriptMappedJSTypeImpl)type;
        return this.isReadonly() == mappedType.isReadonly() && this.isMinusReadonly() == mappedType.isMinusReadonly() && this.isOptional() == mappedType.isOptional() && this.isMinusOptional() == mappedType.isMinusOptional() && this.getParameterType().isEquivalentTo(mappedType.getParameterType(), context, allowResolve) && this.getResultType().isEquivalentTo(mappedType.getResultType(), context, allowResolve) && JSType.isEquivalentToSafe((JSType)this.getNameType(), (JSType)mappedType.getNameType(), (ProcessingContext)context, (boolean)allowResolve);
    }

    @Nullable
    private JSType getNameType() {
        return this.myNameType;
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(63);
        }
        return jSType;
    }

    @NotNull
    public JSType getResultType() {
        JSType jSType = this.myResultType;
        if (jSType == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(64);
        }
        return jSType;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    @NotNull
    public String getParameterName() {
        String string = this.myParameterId.getName();
        if (string == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(65);
        }
        return string;
    }

    @NotNull
    public JSTypeSubstitutor.JSTypeGenericId getParameterId() {
        JSTypeSubstitutor.JSTypeGenericId jSTypeGenericId = this.myParameterId;
        if (jSTypeGenericId == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(66);
        }
        return jSTypeGenericId;
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(67);
        }
        this.myResultType.accept(visitor);
        this.myParameterType.accept(visitor);
    }

    @NotNull
    public JSType distributeType() {
        JSType parameterType = this.getParameterType();
        if (parameterType instanceof JSKeyofType) {
            return this.distributeByKey(((JSKeyofType)parameterType).getReferencedType());
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(68);
        }
        return typeScriptMappedJSTypeImpl;
    }

    @NotNull
    private JSType distributeByKey(JSType keyType) {
        if (keyType instanceof JSPrimitiveType && !(keyType instanceof JSPrimitiveLiteralType)) {
            JSType jSType = keyType;
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(69);
            }
            return jSType;
        }
        if (keyType instanceof JSUnionType) {
            List<JSType> types2 = ((JSUnionType)keyType).getTypes();
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types2.size());
            JSType resultType = this.getResultType();
            for (JSType type : types2) {
                newTypes.add(JSCompositeTypeFactory.createMappedType(this.getSource(), this.isReadonly(), this.isOptional(), this.isMinusReadonly(), this.isMinusOptional(), this.myParameterId, JSCompositeTypeFactory.createKeyOfType(type, this.getSource()), TypeScriptMappedJSTypeImpl.transformForIndexer(keyType, this.myParameterId, type, resultType, true), this.getNameType()));
            }
            JSType jSType = JSCompositeTypeFactory.createUnionType(this.getSource(), newTypes);
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(70);
            }
            return jSType;
        }
        JSGenericTypeImpl genericArrayType = TypeScriptMappedJSTypeImpl.getGenericArrayType(keyType);
        if (genericArrayType != null) {
            JSType arrayBase = genericArrayType.getType();
            JSType S = genericArrayType.getArguments().get(0);
            JSType X = this.getResultType();
            if (this.isReadonly() && TypeScriptMappedJSTypeImpl.isArrayKind(arrayBase, "Array")) {
                arrayBase = new JSPrimitiveReadonlyArrayType(arrayBase.getSource(), ((JSNamedType)arrayBase).getTypeContext());
            } else if (this.isMinusReadonly() && TypeScriptMappedJSTypeImpl.isArrayKind(arrayBase, "ReadonlyArray")) {
                arrayBase = new JSPrimitiveArrayType(arrayBase.getSource(), ((JSNamedType)arrayBase).getTypeContext());
            }
            return new JSGenericTypeImpl(this.getSource(), arrayBase, TypeScriptMappedJSTypeImpl.transformForIndexer(keyType, this.myParameterId, S, X, false));
        }
        if (keyType instanceof JSTupleType) {
            List types3 = ((JSTupleType)keyType).getTypes();
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types3.size());
            JSType X = this.getResultType();
            for (JSType type : types3) {
                newTypes.add(TypeScriptMappedJSTypeImpl.transformForIndexer(keyType, this.myParameterId, type, X, false));
            }
            JSType jSType = JSCompositeTypeFactory.createTupleType(this.getSource(), newTypes, keyType.isSourceStrict(), ((JSTupleType)keyType).getOptionalStart(), !this.isMinusReadonly() && (this.isReadonly() || ((JSTupleType)keyType).isReadonly()));
            if (jSType == null) {
                TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(71);
            }
            return jSType;
        }
        TypeScriptMappedJSTypeImpl typeScriptMappedJSTypeImpl = this;
        if (typeScriptMappedJSTypeImpl == null) {
            TypeScriptMappedJSTypeImpl.$$$reportNull$$$0(72);
        }
        return typeScriptMappedJSTypeImpl;
    }

    private static boolean isArrayKind(JSType type, String arrayClass) {
        return type instanceof JSNamedType && arrayClass.equals(((JSNamedType)type).getQualifiedName().getQualifiedName());
    }

    private static JSType transformForIndexer(JSType keyType, JSTypeSubstitutor.JSTypeGenericId parameterId, JSType type, JSType x, boolean preserveIndexer) {
        return x.transformTypeHierarchy(t -> {
            if (t instanceof TypeScriptIndexedAccessJSTypeImpl) {
                JSType owner = ((TypeScriptIndexedAccessJSTypeImpl)t).getOwner();
                JSType parameterType = ((TypeScriptIndexedAccessJSTypeImpl)t).getParameterType();
                if (owner.isEquivalentTo(keyType, null, true) && TypeScriptMappedJSTypeImpl.isParameter(parameterId, parameterType)) {
                    return preserveIndexer ? JSCompositeTypeFactory.createIndexedAccessType(type, parameterType, t.getSource()).substitute() : type;
                }
            }
            return t;
        });
    }

    @Nullable
    private static JSGenericTypeImpl getGenericArrayType(@Nullable JSType keyType) {
        String typeText;
        JSType type;
        JSGenericTypeImpl genericArrayType = null;
        if (keyType instanceof JSArrayType) {
            genericArrayType = ((JSArrayType)keyType).asGenericType();
        } else if (keyType instanceof JSGenericTypeImpl && (type = ((JSGenericTypeImpl)keyType).getType()) instanceof JSNamedType && ("Array".equals(typeText = type.getTypeText(JSType.TypeTextFormat.SIMPLE)) || "ReadonlyArray".equals(typeText))) {
            genericArrayType = (JSGenericTypeImpl)keyType;
        }
        return genericArrayType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 58: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 58: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 58: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 10: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 13: 
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappedType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 20: 
            case 23: 
            case 26: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 27: 
            case 30: 
            case 38: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberName";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraSourceElements";
                break;
            }
            case 52: 
            case 54: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElements";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringValue";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionTypeInIndexAccess";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNameAndCreateProperty";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "updateIfFromJSDoc";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyBases";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "collectReferencedTypes";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "computeCommonMemberSource";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberSourceKind";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLiteralSourceElementsMap";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatus";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getResultType";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterName";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterId";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeByKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 58: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableForMappedTypeWithTypeOperator";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processHomomorphicType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableDirectOrInverseType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutionTypeInIndexAccess";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "substituteInternal";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "mapNameAndCreateProperty";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateIfFromJSDoc";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "calcOriginalOptional";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "computeCommonMemberSource";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "buildLiteralSourceElementsMap";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fillExtraLiteralSourceElements";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "putIfStringLiteral";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addSourceElementsFromAliasedType";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isParameter";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 58: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LiteralStatus {
        private final Set<PsiElement> sources = new THashSet();
        private ThreeState optional = ThreeState.UNSURE;

        private LiteralStatus() {
        }

        void add(@NotNull PsiElement key) {
            if (key == null) {
                LiteralStatus.$$$reportNull$$$0(0);
            }
            this.optional = ThreeState.NO;
            this.sources.add(key);
        }

        void addKey(@NotNull JSTypeKeyTypeImpl key) {
            if (key == null) {
                LiteralStatus.$$$reportNull$$$0(1);
            }
            this.sources.addAll(key.getKeySourceElements());
            if (this.optional != ThreeState.NO) {
                this.optional = ThreeState.fromBoolean((boolean)key.isOptional());
            }
        }

        boolean isOptional() {
            return this.optional == ThreeState.YES;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "key";
            objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptMappedJSTypeImpl$LiteralStatus";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

