/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeParser {
    public static final char SERIALIZED_TYPE_MARK = '\u001d';
    public static final String TYPEOF_IDENTIFIER = "#typeof";
    public static final String CONTEXTUAL_TYPEOF_IDENTIFIER = "#ctypeof";
    public static final String COMPONENT_OF_ITERABLE_IDENTIFIER = "#compof";
    public static final String REST_IDENTIFIER = "#restof";
    public static final String TYPE_LITERAL_KEY_PREFIX = "#literalkey";
    public static final String TAGGED_LITERAL_KEY_PREFIX = "#taggedliteralkey";
    public static final char SINGLE_TYPE_SPECIAL_CHAR = '\u0001';
    public static final String MODULE_PREFIX = "module:";
    public static final String EVENT_PREFIX = "event:";
    private static final String REST_PARAM_PREFIX = "...";
    @NotNull
    private final String myTypeString;
    private final JSTypeVisitor myVisitor;
    private final boolean myIsFromJSDoc;
    private int myCurrentOffset;
    @NotNull
    private final JSTypeSource mySource;
    private boolean myParsingFunction;

    public JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource source) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(1);
        }
        this(typeString, source, false);
    }

    public JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource source, boolean isFromJSDoc) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSTypeParser.$$$reportNull$$$0(3);
        }
        this(typeString, source, null, isFromJSDoc);
    }

    public JSTypeParser(@NotNull String typeString, JSTypeVisitor visitor) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(4);
        }
        this(typeString, JSTypeSource.EMPTY, visitor, true);
    }

    private JSTypeParser(@NotNull String typeString, @NotNull JSTypeSource typeSource, @Nullable JSTypeVisitor visitor, boolean isFromJSDoc) {
        if (typeString == null) {
            JSTypeParser.$$$reportNull$$$0(5);
        }
        if (typeSource == null) {
            JSTypeParser.$$$reportNull$$$0(6);
        }
        this.myTypeString = typeString;
        this.myIsFromJSDoc = isFromJSDoc;
        this.mySource = typeSource;
        this.myVisitor = visitor;
        this.myCurrentOffset = 0;
    }

    @Nullable
    public JSType parse() {
        return this.parse(false);
    }

    @Nullable
    public JSType parse(boolean allowCommentAfterType) {
        return this.handleParseResult(this.parseComposite(true), allowCommentAfterType);
    }

    @Nullable
    public JSParameterTypeDecorator parseParameterType() {
        return this.parseParameterType(false);
    }

    @Nullable
    public JSParameterTypeDecorator parseParameterType(boolean allowCommentAfterType) {
        return this.handleParseResult(this.parseInnerParameterType(true), allowCommentAfterType);
    }

    @Nullable
    public JSType parseNamepath() {
        return this.handleParseResult(this.parseSingleType(true), false);
    }

    private <T> T handleParseResult(T result2, boolean allowCommentAfterType) {
        if (!allowCommentAfterType && this.myCurrentOffset != this.myTypeString.length()) {
            return null;
        }
        return result2;
    }

    public int getTypeStringLength() {
        return this.myCurrentOffset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private JSParameterTypeDecorator parseInnerParameterType(boolean allowComma) {
        JSType type;
        this.advanceSpaces();
        boolean rest = false;
        if (this.startsWith(REST_PARAM_PREFIX)) {
            char afterDotsChar;
            rest = true;
            this.advanceBy(REST_PARAM_PREFIX.length());
            this.advanceSpaces();
            if (!this.hasSymbol() || (afterDotsChar = this.getSymbol()) == ',' || afterDotsChar == ')' || afterDotsChar == '}') {
                type = JSAnyType.get(this.mySource);
            } else {
                boolean parseBrackets;
                boolean bl = parseBrackets = this.myParsingFunction && this.checkCurrentSymbol('[');
                if (parseBrackets) {
                    this.advance();
                }
                type = this.parseComposite(false);
                if (parseBrackets) {
                    if (!this.checkCurrentSymbol(']')) return null;
                    this.advance();
                }
            }
        } else {
            type = this.parseComposite(allowComma);
        }
        this.advanceSpaces();
        boolean optional = false;
        if (this.hasSymbol()) {
            char symbol = this.getSymbol();
            if (symbol == '?' || symbol == '=') {
                optional = true;
                this.advance();
                this.advanceSpaces();
                while (this.hasSymbol() && (this.getSymbol() == '\"' || StringUtil.isJavaIdentifierPart((char)this.getSymbol()))) {
                    this.advance();
                }
            } else if (symbol == ',') {
                int beforeCommaOffset = this.myCurrentOffset;
                this.advance();
                this.advanceSpaces();
                if (this.startsWith("optional")) {
                    this.advanceBy("optional".length());
                    optional = true;
                } else {
                    this.myCurrentOffset = beforeCommaOffset;
                }
            }
        }
        this.advanceSpaces();
        if (type == null && !optional) {
            if (!rest) return null;
        }
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(type, optional, rest, this.mySource.isStrict());
        return jSParameterTypeDecoratorImpl;
    }

    private JSType parseComposite(boolean allowComma) {
        return this.parseComposite(allowComma, "|/", true);
    }

    @Nullable
    private JSType parseComposite(boolean allowComma, @NotNull String delimiters, boolean isUnion) {
        if (delimiters == null) {
            JSTypeParser.$$$reportNull$$$0(7);
        }
        this.advanceSpaces();
        if (!this.hasSymbol()) {
            return null;
        }
        JSType type = this.parseTypeFromComposite(isUnion);
        this.advanceSpaces();
        ArrayList<JSType> addedUnionOptions = null;
        while (this.hasSymbol() && (delimiters.indexOf(this.getSymbol()) != -1 || allowComma && ',' == this.getSymbol())) {
            JSType unionOption;
            int commaOffset = ',' != this.getSymbol() ? -1 : this.myCurrentOffset;
            this.advance();
            if (addedUnionOptions == null) {
                addedUnionOptions = new ArrayList<JSType>();
            }
            if ((unionOption = this.parseTypeFromComposite(isUnion)) == null) continue;
            this.advanceSpaces();
            if (commaOffset >= 0 && unionOption instanceof JSTypeImpl && "optional".equals(unionOption.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
                this.myCurrentOffset = commaOffset;
                break;
            }
            addedUnionOptions.add(unionOption);
        }
        if (addedUnionOptions != null && !addedUnionOptions.isEmpty()) {
            if (type != null) {
                addedUnionOptions.add(0, type);
            }
            type = isUnion ? JSCompositeTypeFactory.createUnionType(this.mySource, (Collection<? extends JSType>)addedUnionOptions) : JSCompositeTypeFactory.createIntersectionType((Collection<? extends JSType>)addedUnionOptions, this.mySource);
        }
        return type;
    }

    private JSType parseTypeFromComposite(boolean isUnion) {
        if (isUnion) {
            return this.parseComposite(false, "&", false);
        }
        return this.parseType();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private JSType parseType() {
        void var1_13;
        boolean decorationsAdded;
        this.advanceSpaces();
        if (!this.hasSymbol()) {
            return null;
        }
        if (!this.myIsFromJSDoc && this.getSymbol() == '\u001d') {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(this.myTypeString, this.myCurrentOffset);
            try {
                JSType read = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(this.mySource, stringCharacterIterator);
                this.myCurrentOffset = stringCharacterIterator.getIndex();
                return read;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.getInstance(JSTypeUtils.class).error("Can't deserialize type", (Throwable)e, new Attachment[]{new Attachment("type", StringUtil.escapeStringCharacters((String)this.myTypeString))});
                return null;
            }
        }
        char c = this.getSymbol();
        if (c == '{') {
            JSRecordType jSRecordType = this.parseRecordType();
            if (jSRecordType == null) {
                return null;
            }
        } else if (c == '(') {
            this.advance();
            JSType jSType = this.parseComposite(true);
            this.advanceSpaces();
            if (!this.hasSymbol() || this.getSymbol() != ')') return null;
            this.advance();
        } else if (c == '[') {
            this.advance();
            JSType jSType = this.parseComposite(true);
            this.advanceSpaces();
            if (!this.hasSymbol() || this.getSymbol() != ']') {
                return null;
            }
            this.advance();
            JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl(jSType, this.mySource);
        } else if (c == 'f' && this.startsWith("function")) {
            int funcStartOffset = this.myCurrentOffset;
            this.advanceBy("function".length());
            this.advanceSpaces();
            if (this.hasSymbol() && (this.getSymbol() == ':' || this.getSymbol() == '(')) {
                Pair<@NotNull JSFunctionTypeImpl, @Nullable JSType> functionTypes = this.parseFunctionAfterKeyword();
                if (functionTypes != null && functionTypes.second != null) {
                    ArrayList<JSRecordType.TypeMember> members = new ArrayList<JSRecordType.TypeMember>(2);
                    this.addMembersFromFunctionParsingResult(functionTypes, members);
                    JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.mySource, members);
                } else {
                    JSType jSType = functionTypes != null ? (JSType)functionTypes.first : null;
                }
            } else {
                this.myCurrentOffset = funcStartOffset;
                JSType jSType = this.parseSingleType(false);
            }
        } else if (JSTypeParser.isQuote(c)) {
            JSStringLiteralTypeImpl jSStringLiteralTypeImpl = this.parseStringLiteralType();
        } else {
            JSType jSType = this.parseSingleType(false);
        }
        do {
            this.advanceSpaces();
            decorationsAdded = true;
            if (this.startsWith("[]")) {
                JSArrayTypeImpl jSArrayTypeImpl = new JSArrayTypeImpl((JSType)var1_13, this.mySource);
                this.advanceBy("[]".length());
                continue;
            }
            if (this.checkCurrentSymbol('!')) {
                JSType jSType = this.addTypeDecoration((JSType)var1_13, JSDecoratedType.TypeDecoration.JSDOC_NOTNULL);
                this.advance();
                continue;
            }
            if (this.checkCurrentSymbol('<')) {
                this.advance();
                while (this.hasSymbol() && this.getSymbol() != '>') {
                    int typeStart = this.myCurrentOffset;
                    JSType jSType = this.addGenericArgument((JSType)var1_13, this.parseComposite(false));
                    this.advanceSpaces();
                    if (this.checkCurrentSymbol(',')) {
                        this.advance();
                        this.advanceSpaces();
                    }
                    if (typeStart != this.myCurrentOffset) continue;
                    return null;
                }
                if (!this.hasSymbol()) {
                    return null;
                }
                this.advance();
                continue;
            }
            if (this.checkCurrentSymbol('.')) {
                this.advance();
                continue;
            }
            decorationsAdded = false;
        } while (decorationsAdded);
        return var1_13;
    }

    private void addMembersFromFunctionParsingResult(@NotNull @NotNull Pair<@NotNull JSFunctionTypeImpl, @Nullable JSType> functionTypes, List<JSRecordType.TypeMember> members) {
        if (functionTypes == null) {
            JSTypeParser.$$$reportNull$$$0(8);
        }
        if (((JSFunctionTypeImpl)functionTypes.first).getReturnType() != null) {
            members.add((JSRecordType.TypeMember)new JSRecordTypeImpl.CallSignatureImpl(false, (JSFunctionType)functionTypes.first));
        }
        if (functionTypes.second != null) {
            JSFunctionTypeImpl newType = new JSFunctionTypeImpl(this.mySource, ((JSFunctionTypeImpl)functionTypes.first).getParameters(), (JSType)functionTypes.second, ((JSFunctionTypeImpl)functionTypes.first).getThisType());
            members.add((JSRecordType.TypeMember)new JSRecordTypeImpl.CallSignatureImpl(true, newType));
        }
    }

    private JSRecordType parseRecordType() {
        ArrayList<JSRecordType.TypeMember> typeMembers = new ArrayList<JSRecordType.TypeMember>();
        this.advance();
        this.advanceSpaces();
        while (this.hasSymbol() && this.getSymbol() != '}') {
            int labelStart = this.myCurrentOffset;
            if (this.checkCurrentSymbol('(')) {
                Pair<JSFunctionTypeImpl, JSType> functionTypes = this.parseFunctionAfterKeyword();
                if (functionTypes != null) {
                    this.addMembersFromFunctionParsingResult(functionTypes, typeMembers);
                }
            } else {
                boolean optional = false;
                char startSymbol = this.getSymbol();
                boolean isSymbol = startSymbol == '[' && this.startsWith("[Symbol.");
                boolean isQuoted = JSTypeParser.isQuote(startSymbol);
                if (!isSymbol && !isQuoted && startSymbol == '[') {
                    optional = true;
                    this.advance();
                    this.advanceSpaces();
                }
                labelStart = this.myCurrentOffset;
                if (isSymbol || isQuoted) {
                    this.advance();
                }
                while (this.hasSymbol() && (StringUtil.isJavaIdentifierPart((char)this.getSymbol()) || '.' == this.getSymbol() || isQuoted && this.getSymbol() != startSymbol)) {
                    this.advance();
                }
                if (isSymbol && this.checkCurrentSymbol(']')) {
                    this.advance();
                }
                if (isQuoted && this.checkCurrentSymbol(startSymbol)) {
                    this.advance();
                }
                String recordLabel = this.myTypeString.substring(labelStart, this.myCurrentOffset);
                if (isQuoted) {
                    recordLabel = JSStringUtil.unquoteAndUnescapeString(recordLabel);
                }
                this.advanceSpaces();
                if (optional && this.checkCurrentSymbol(']')) {
                    this.advance();
                    this.advanceSpaces();
                }
                if (!optional && !isQuoted && "new".equals(recordLabel) && this.checkCurrentSymbol('(')) {
                    Pair<JSFunctionTypeImpl, JSType> functionTypes = this.parseFunctionAfterKeyword();
                    if (functionTypes != null) {
                        typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.CallSignatureImpl(true, (JSFunctionType)functionTypes.first));
                    }
                } else {
                    JSParameterTypeDecorator recordPropertyType = null;
                    if (this.checkCurrentSymbol('?')) {
                        optional = true;
                        this.advance();
                        this.advanceSpaces();
                    }
                    if (this.checkCurrentSymbol(':')) {
                        this.advance();
                        this.advanceSpaces();
                        recordPropertyType = this.parseInnerParameterType(false);
                        this.advanceSpaces();
                    }
                    JSType type = recordPropertyType != null ? recordPropertyType.getSimpleType() : null;
                    typeMembers.add((JSRecordType.TypeMember)new JSRecordTypeImpl.PropertySignatureImpl(recordLabel, type, optional |= recordPropertyType != null && recordPropertyType.isOptional(), false));
                    if (this.myVisitor != null) {
                        this.myVisitor.visitRecordProperty(labelStart, recordLabel, type != null ? type.getTypeText() : null);
                    }
                }
            }
            if (this.hasSymbol() && this.getSymbol() == ',') {
                this.advance();
                this.advanceSpaces();
            }
            if (labelStart != this.myCurrentOffset) continue;
            break;
        }
        if (!this.hasSymbol() || this.getSymbol() != '}') {
            return null;
        }
        this.advance();
        return new JSRecordTypeImpl(this.mySource, typeMembers);
    }

    @Nullable
    private JSStringLiteralTypeImpl parseStringLiteralType() {
        String literalValue = this.parseStringLiteral();
        return literalValue == null ? null : new JSStringLiteralTypeImpl(literalValue, false, this.mySource);
    }

    @Nullable
    private String parseStringLiteral() {
        char quote = this.getSymbol();
        this.advance();
        int literalStart = this.myCurrentOffset;
        boolean screened = false;
        while (this.hasSymbol()) {
            char c = this.getSymbol();
            if (c == '\\') {
                screened = !screened;
            } else if (!screened && c == quote) {
                this.advance();
                return this.myTypeString.substring(literalStart, this.myCurrentOffset - 1);
            }
            this.advance();
        }
        return null;
    }

    @Nullable
    private JSType addTypeDecoration(@Nullable JSType type, JSDecoratedType.TypeDecoration decoration) {
        JSDecoratedTypeImpl decoratedType;
        if (type == null) {
            return null;
        }
        if (type instanceof JSDecoratedTypeImpl) {
            EnumSet<JSDecoratedType.TypeDecoration> decorations = EnumSet.copyOf(((JSDecoratedTypeImpl)type).getDecorations());
            decorations.add(decoration);
            decoratedType = new JSDecoratedTypeImpl(this.mySource, ((JSDecoratedTypeImpl)type).getType(), decorations);
        } else {
            decoratedType = new JSDecoratedTypeImpl(this.mySource, type, EnumSet.of(decoration));
        }
        return decoratedType;
    }

    @Nullable
    private JSType addGenericArgument(JSType type, JSType genericArgument) {
        if (type == null || genericArgument == null) {
            return null;
        }
        if (type instanceof JSGenericTypeImpl) {
            List<JSType> arguments = ((JSGenericTypeImpl)type).getArguments();
            ArrayList<JSType> newArgs = new ArrayList<JSType>(arguments);
            newArgs.add(genericArgument);
            return new JSGenericTypeImpl(type.getSource(), ((JSGenericTypeImpl)type).getType(), newArgs);
        }
        return new JSGenericTypeImpl(this.mySource, type, genericArgument);
    }

    @Nullable
    private @Nullable Pair<@NotNull JSFunctionTypeImpl, @Nullable JSType> parseFunctionAfterKeyword() {
        SmartList decorators = new SmartList();
        JSType newType = null;
        JSType thisType = null;
        this.myParsingFunction = true;
        if (this.checkCurrentSymbol('(')) {
            this.advance();
            this.advanceSpaces();
            while (this.hasSymbol() && this.getSymbol() != ')') {
                JSType paramType;
                int paramStart = this.myCurrentOffset;
                while (this.hasSymbol() && StringUtil.isJavaIdentifierPart((char)this.getSymbol())) {
                    this.advance();
                }
                int identifierEnd = this.myCurrentOffset;
                this.advanceSpaces();
                String recordLabel = null;
                if (this.checkCurrentSymbol(':')) {
                    this.advance();
                    recordLabel = this.myTypeString.substring(paramStart, identifierEnd);
                } else {
                    this.myCurrentOffset = paramStart;
                }
                JSParameterTypeDecorator paramTypeDecorator = this.parseInnerParameterType(false);
                JSType jSType = paramType = paramTypeDecorator != null ? paramTypeDecorator.getSimpleType() : null;
                if ("this".equals(recordLabel)) {
                    thisType = paramType;
                } else if ("new".equals(recordLabel)) {
                    newType = paramType;
                } else {
                    boolean optional = paramTypeDecorator != null && paramTypeDecorator.isOptional();
                    boolean rest = paramTypeDecorator != null && paramTypeDecorator.isRest();
                    JSParameterTypeDecoratorImpl decorator = new JSParameterTypeDecoratorImpl(recordLabel, paramType, optional, rest, true);
                    decorators.add(decorator);
                }
                this.advanceSpaces();
                if (this.checkCurrentSymbol(',')) {
                    this.advance();
                    this.advanceSpaces();
                }
                if (this.myCurrentOffset != paramStart) continue;
                return null;
            }
            if (!this.hasSymbol()) {
                return null;
            }
            this.advance();
        }
        this.advanceSpaces();
        JSType returnType = null;
        if (this.checkCurrentSymbol(':')) {
            this.advance();
            returnType = this.parseType();
        }
        return Pair.create((Object)new JSFunctionTypeImpl(this.mySource, (List<? extends JSParameterTypeDecorator>)decorators, returnType, thisType), newType);
    }

    @Nullable
    private JSType parseSingleType(boolean isNamepathOnly) {
        char c;
        this.advanceSpaces();
        char c2 = c = this.hasSymbol() ? this.getSymbol() : (char)'\u0000';
        if (c == '?') {
            this.advance();
            this.advanceSpaces();
            int afterQuestOffset = this.myCurrentOffset;
            JSType type = this.parseType();
            return type == null && afterQuestOffset == this.myCurrentOffset ? JSUnknownType.JS_INSTANCE : this.addTypeDecoration(type, JSDecoratedType.TypeDecoration.JSDOC_NULLABLE);
        }
        if (c == '!') {
            this.advance();
            JSType type = this.parseType();
            return this.addTypeDecoration(type, JSDecoratedType.TypeDecoration.JSDOC_NOTNULL);
        }
        if (c == '*') {
            this.advance();
            return JSAnyType.get(this.mySource);
        }
        int typeTextStartOffset = this.myCurrentOffset;
        JSContext jsContext = JSContext.INSTANCE;
        if (c == 't' && this.startsWith("typeof ")) {
            this.advanceBy("typeof".length());
            this.advanceSpaces();
            if (this.hasSymbol() && this.getSymbol() == 'i' && this.startsWith("import(")) {
                return this.parseImportType(typeTextStartOffset);
            }
            if (this.hasSymbol() && StringUtil.isJavaIdentifierPart((char)this.getSymbol())) {
                jsContext = JSContext.STATIC;
                typeTextStartOffset = this.myCurrentOffset;
            } else {
                this.myCurrentOffset = typeTextStartOffset;
            }
        } else if (c == 'i' && this.startsWith("import(")) {
            return this.parseImportType(typeTextStartOffset);
        }
        Matcher matcher = (isNamepathOnly ? JSDocumentationUtils.NAMEPATH_PATTERN : JSDocumentationUtils.NAMEPATH_IN_TYPE_PATTERN).matcher(this.myTypeString.substring(typeTextStartOffset));
        if (!matcher.lookingAt()) {
            return null;
        }
        int typeTextEndOffset = this.fixGenericArgumentPosition(typeTextStartOffset + matcher.end());
        return this.createTypeForOffsets(typeTextStartOffset, typeTextEndOffset, jsContext);
    }

    private int fixGenericArgumentPosition(int typeTextEndOffset) {
        if (typeTextEndOffset < this.myTypeString.length() && this.myTypeString.charAt(typeTextEndOffset) == '<' && typeTextEndOffset > 0 && this.myTypeString.charAt(typeTextEndOffset - 1) == '.') {
            --typeTextEndOffset;
        }
        return typeTextEndOffset;
    }

    @Nullable
    private JSType createTypeForOffsets(int typeTextStartOffset, int typeTextEndOffset, @NotNull JSContext jsContext) {
        if (jsContext == null) {
            JSTypeParser.$$$reportNull$$$0(9);
        }
        assert (typeTextEndOffset >= typeTextStartOffset);
        this.myCurrentOffset = typeTextEndOffset;
        if (typeTextEndOffset > typeTextStartOffset) {
            JSAnyType type;
            boolean isTypeScript;
            String name = this.myTypeString.substring(typeTextStartOffset, typeTextEndOffset);
            if (name.charAt(name.length() - 1) == '.') {
                jsContext = JSContext.STATIC;
            }
            boolean bl = isTypeScript = this.mySource.getLanguage() == JSTypeSource.SourceLanguage.TS;
            JSAnyType jSAnyType = isTypeScript && "any".equals(name) ? JSAnyType.get(this.mySource) : (type = isTypeScript && "unknown".equals(name) ? JSUnknownType.TS_INSTANCE : JSNamedTypeFactory.createType(name, this.mySource, JSTypeContext.fromJSContext(jsContext), this.myIsFromJSDoc));
            if (this.myVisitor != null) {
                this.myVisitor.visitSingleType(typeTextStartOffset, type, name);
            }
            return type;
        }
        return null;
    }

    @Nullable
    private JSType parseImportType(int identifierStartOffset) {
        this.advanceBy("import(".length());
        while (this.hasSymbol() && this.getSymbol() != ')') {
            this.advance();
        }
        if (!this.checkCurrentSymbol(')')) {
            return null;
        }
        this.advance();
        int typeTextEndOffset = this.myCurrentOffset;
        if (this.checkCurrentSymbol('.') && !this.startsWith(".<")) {
            this.advance();
            int startNamespaceMatching = this.myCurrentOffset;
            Matcher matcher = JSDocumentationUtils.NAMEPATH_IN_TYPE_PATTERN.matcher(this.myTypeString.substring(this.myCurrentOffset));
            if (!matcher.lookingAt()) {
                return null;
            }
            typeTextEndOffset = startNamespaceMatching + matcher.end();
        }
        typeTextEndOffset = this.fixGenericArgumentPosition(typeTextEndOffset);
        return this.createTypeForOffsets(identifierStartOffset, typeTextEndOffset, JSContext.INSTANCE);
    }

    private static boolean isQuote(char c) {
        return c == '\"' || c == '\'';
    }

    private char getSymbol() {
        return this.myTypeString.charAt(this.myCurrentOffset);
    }

    private boolean checkCurrentSymbol(char ch) {
        return this.hasSymbol() && this.getSymbol() == ch;
    }

    private void advance() {
        ++this.myCurrentOffset;
    }

    private void advanceBy(int count) {
        this.myCurrentOffset += count;
    }

    private boolean hasSymbol() {
        return this.myCurrentOffset < this.myTypeString.length();
    }

    private boolean startsWith(String prefix) {
        return this.myTypeString.startsWith(prefix, this.myCurrentOffset);
    }

    private void advanceSpaces() {
        while (this.myCurrentOffset < this.myTypeString.length() && StringUtil.isWhiteSpace((char)this.getSymbol())) {
            this.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiters";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionTypes";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "parseComposite";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addMembersFromFunctionParsingResult";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createTypeForOffsets";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Chars {
        private static final char LPAREN = '(';
        private static final char RPAREN = ')';
        private static final char LBRACE = '{';
        private static final char RBRACE = '}';
        private static final char LBRACKET = '[';
        private static final char RBRACKET = ']';
        private static final char COMMA = ',';
        private static final char QUESTION = '?';
        private static final char EQ = '=';
        private static final char LT = '<';
        private static final char GT = '>';
        private static final char DOT = '.';
        private static final char EXCLAMATION = '!';
        private static final char COLON = ':';

        private Chars() {
        }
    }
}

