/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeAssignableErrorMessage;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWrapperType;
import com.intellij.lang.javascript.psi.types.TypeScriptGenericThisTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.TypeScriptTypePredicateTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTypeCastUtil {
    public static final JSRecordType NO_RECORD_TYPE = new JSRecordTypeImpl(JSTypeSource.EMPTY, ContainerUtil.emptyList());

    public static boolean isFalsy(@Nullable JSType type) {
        return JSTypeUtils.isNullOrUndefinedType(type) || JSTypeCastUtil.isFalseBooleanLiteralType(type) || JSTypeCastUtil.isEmptyStringLiteralType(type) || JSTypeCastUtil.isZeroBigIntLiteralType(type) || JSTypeCastUtil.isZeroNumberLiteralType(type);
    }

    private static boolean isFalseBooleanLiteralType(@Nullable JSType type) {
        return type instanceof JSBooleanLiteralTypeImpl && ((JSBooleanLiteralTypeImpl)type).getLiteral() == Boolean.FALSE;
    }

    private static boolean isEmptyStringLiteralType(@Nullable JSType type) {
        return type instanceof JSStringLiteralTypeImpl && ((JSStringLiteralTypeImpl)type).getLiteral().isEmpty();
    }

    private static boolean isZeroNumberLiteralType(@Nullable JSType type) {
        return type instanceof JSNumberLiteralTypeImpl && ((JSNumberLiteralTypeImpl)type).getLiteral() == 0.0;
    }

    private static boolean isZeroBigIntLiteralType(@Nullable JSType type) {
        return type instanceof JSBigIntLiteralTypeImpl && ((JSBigIntLiteralTypeImpl)type).getLiteral().equals(BigInteger.ZERO);
    }

    public static boolean areListsEquivalent(@NotNull List<JSType> types1, @NotNull List<JSType> types2, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (types1 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(0);
        }
        if (types2 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(1);
        }
        Iterator<JSType> iterator = types2.iterator();
        for (JSType jsType : types1) {
            if (iterator.hasNext() && jsType.isEquivalentTo(iterator.next(), processingContext, allowResolve)) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    @Nullable
    private static JSType getMainType(@NotNull JSType candidate) {
        if (candidate == null) {
            JSTypeCastUtil.$$$reportNull$$$0(2);
        }
        if (candidate instanceof JSGenericTypeImpl) {
            return ((JSGenericTypeImpl)candidate).getType();
        }
        if (candidate instanceof JSNamedType) {
            return candidate;
        }
        return null;
    }

    @NotNull
    public static AssignableResult isDirectlyAssignableInClassHierarchy(@NotNull JSType lType, @NotNull JSType rType, @NotNull ProcessingContext processingContext) {
        JSType rMainType;
        if (lType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(3);
        }
        if (rType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(4);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(5);
        }
        if ((rMainType = JSTypeCastUtil.getMainType(rType)) == null) {
            AssignableResult assignableResult = AssignableResult.NOT_SURE;
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(6);
            }
            return assignableResult;
        }
        JSType lMainType = JSTypeCastUtil.getMainType(lType);
        if (lMainType == null) {
            AssignableResult assignableResult = AssignableResult.NOT_SURE;
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(7);
            }
            return assignableResult;
        }
        List<JSType> lArguments = lType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)lType).getArguments() : ContainerUtil.emptyList();
        List<JSType> rArguments = rType instanceof JSGenericTypeImpl ? ((JSGenericTypeImpl)rType).getArguments() : ContainerUtil.emptyList();
        boolean isSameMainType = lMainType.isEquivalentTo(rMainType, processingContext);
        if (!isSameMainType) {
            ThreeState state = JSTypeCastUtil.areExplicitAssignable(lMainType, rMainType);
            if (state == ThreeState.NO) {
                AssignableResult assignableResult = AssignableResult.NOT_ASSIGNABLE;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(8);
                }
                return assignableResult;
            }
            if (state == ThreeState.YES) {
                isSameMainType = true;
            }
        }
        if (isSameMainType) {
            return JSTypeCastUtil.isAssignableWithSameMainType(lMainType, rMainType, lArguments, rArguments, processingContext);
        }
        if (rMainType instanceof JSNamedType && lMainType instanceof JSNamedType) {
            Collection<? extends PsiElement> lOpElements = TypeScriptTypeParser.resolveElementsByType(lMainType);
            Collection<? extends PsiElement> rOpElements = TypeScriptTypeParser.resolveElementsByType(rMainType);
            for (PsiElement psiElement : lOpElements) {
                for (PsiElement psiElement2 : rOpElements) {
                    if (!(psiElement instanceof JSClass) || !(psiElement2 instanceof JSClass)) continue;
                    JSClass rClass = (JSClass)psiElement2;
                    JSClass lClass = (JSClass)psiElement;
                    if (JSInheritanceUtil.isParentClass(rClass, lClass, false)) {
                        List<JSType> inferredRight = JSTypeCastUtil.inferGenericsForSubClass(rMainType, rArguments, lClass, rClass);
                        AssignableResult assignableResult = JSGenericTypeImpl.areGenericArgumentsAssignable(lArguments, inferredRight, processingContext, false, true);
                        if (assignableResult == null) {
                            JSTypeCastUtil.$$$reportNull$$$0(9);
                        }
                        return assignableResult;
                    }
                    if (!JSInheritanceUtil.isParentClass(lClass, rClass, true)) continue;
                    if (lOpElements.size() > 1 || !JSTypeCastUtil.canUseReverseHierarchy(lClass, rOpElements)) {
                        AssignableResult assignableResult = AssignableResult.NOT_SURE;
                        if (assignableResult == null) {
                            JSTypeCastUtil.$$$reportNull$$$0(10);
                        }
                        return assignableResult;
                    }
                    List<JSType> inferredLeft = JSTypeCastUtil.inferGenericsForSubClass(lMainType, lArguments, rClass, lClass);
                    AssignableResult assignableResult = JSGenericTypeImpl.areGenericArgumentsAssignable(inferredLeft, rArguments, processingContext, false, true);
                    if (assignableResult == null) {
                        JSTypeCastUtil.$$$reportNull$$$0(11);
                    }
                    return assignableResult;
                }
            }
        }
        AssignableResult assignableResult = AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            JSTypeCastUtil.$$$reportNull$$$0(12);
        }
        return assignableResult;
    }

    @NotNull
    private static AssignableResult isAssignableWithSameMainType(@NotNull JSType lMainType, @NotNull JSType rMainType, List<JSType> lArguments, @NotNull List<JSType> rArguments, @NotNull ProcessingContext processingContext) {
        AssignableResult assignableResult;
        if (lMainType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(13);
        }
        if (rMainType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(14);
        }
        if (rArguments == null) {
            JSTypeCastUtil.$$$reportNull$$$0(15);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(16);
        }
        if ((assignableResult = JSGenericTypeImpl.areGenericArgumentsAssignable(lArguments, rArguments, processingContext, false, true)).isAssignable() || !assignableResult.isStrict()) {
            AssignableResult assignableResult2 = AssignableResult.ASSIGNABLE;
            if (assignableResult2 == null) {
                JSTypeCastUtil.$$$reportNull$$$0(17);
            }
            return assignableResult2;
        }
        if (lMainType instanceof JSArrayType && ((JSArrayType)lMainType).isPrimitive() && rMainType instanceof JSArrayType && ((JSArrayType)rMainType).isPrimitive()) {
            AssignableResult assignableResult3 = AssignableResult.NOT_ASSIGNABLE;
            if (assignableResult3 == null) {
                JSTypeCastUtil.$$$reportNull$$$0(18);
            }
            return assignableResult3;
        }
        AssignableResult assignableResult4 = AssignableResult.NOT_SURE;
        if (assignableResult4 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(19);
        }
        return assignableResult4;
    }

    private static boolean canUseReverseHierarchy(@NotNull JSClass toCheck, Collection<? extends PsiElement> parents) {
        if (toCheck == null) {
            JSTypeCastUtil.$$$reportNull$$$0(20);
        }
        HashSet<JSClass> visited = new HashSet<JSClass>();
        while (visited.add(toCheck)) {
            ProgressManager.checkCanceled();
            if (toCheck.getMembers().iterator().hasNext()) {
                return false;
            }
            if (!JSTypeCastUtil.hasOnlyOneSuperReference(toCheck)) {
                return false;
            }
            JSClass[] supers = toCheck.getSupers();
            if (supers.length == 0) {
                return false;
            }
            toCheck = supers[0];
            if (parents.contains(toCheck)) {
                return true;
            }
            if (supers.length <= 1) continue;
            return false;
        }
        return false;
    }

    private static boolean hasOnlyOneSuperReference(@NotNull JSClass toCheck) {
        if (toCheck == null) {
            JSTypeCastUtil.$$$reportNull$$$0(21);
        }
        JSReferenceList list2 = toCheck.getExtendsList();
        JSReferenceList implList = toCheck.getImplementsList();
        return (implList == null ? 0 : implList.getMembers().length) + (list2 == null ? 0 : list2.getMembers().length) == 1;
    }

    @NotNull
    private static ThreeState areExplicitAssignable(@NotNull JSType lMainType, @NotNull JSType rMainType) {
        PsiElement element;
        if (lMainType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(22);
        }
        if (rMainType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(23);
        }
        if ((element = lMainType.getSourceElement()) == null) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(24);
            }
            return threeState;
        }
        Set<VirtualFile> libraries = TypeScriptLibraryProvider.getAllLibraries(element.getProject());
        if (!JSTypeCastUtil.isAcceptableLibraryType(lMainType, libraries) || !JSTypeCastUtil.isAcceptableLibraryType(rMainType, libraries)) {
            ThreeState threeState = ThreeState.UNSURE;
            if (threeState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(25);
            }
            return threeState;
        }
        String lText = lMainType.getResolvedTypeText();
        String rText = rMainType.getResolvedTypeText();
        ThreeState threeState = TypeScriptTypeRelations.areExplicitAssignableByNames(lText, rText);
        if (threeState == null) {
            JSTypeCastUtil.$$$reportNull$$$0(26);
        }
        return threeState;
    }

    @NotNull
    private static List<JSType> inferGenericsForSubClass(@NotNull JSType mainType, @NotNull List<JSType> arguments, @NotNull JSClass parentCandidate, @NotNull JSClass childCandidate) {
        TypeScriptTypeParameterList lParameters;
        if (mainType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(27);
        }
        if (arguments == null) {
            JSTypeCastUtil.$$$reportNull$$$0(28);
        }
        if (parentCandidate == null) {
            JSTypeCastUtil.$$$reportNull$$$0(29);
        }
        if (childCandidate == null) {
            JSTypeCastUtil.$$$reportNull$$$0(30);
        }
        TypeScriptTypeParameterList typeScriptTypeParameterList = lParameters = parentCandidate instanceof TypeScriptTypeParameterListOwner ? ((TypeScriptTypeParameterListOwner)parentCandidate).getTypeParameterList() : null;
        if (lParameters != null) {
            JSTypeSource source = mainType.getSource();
            ArrayList<JSType> rawGenerics = new ArrayList<JSType>();
            for (TypeScriptTypeParameter parameter : lParameters.getTypeParameters()) {
                String name = parameter.getName();
                TypeScriptGenericParameterImpl toCheck = new TypeScriptGenericParameterImpl(parameter.getGenericId(), source, null);
                if (name == null) continue;
                rawGenerics.add(toCheck);
            }
            JSGenericTypeImpl guessedType = new JSGenericTypeImpl(mainType.getSource(), mainType, rawGenerics);
            JSType type = TypeScriptGenericTypesEvaluator.processClassWithGenericArguments(childCandidate, arguments, parentCandidate, guessedType);
            if (type instanceof JSGenericTypeImpl) {
                List<JSType> list2 = ((JSGenericTypeImpl)type).getArguments();
                if (list2 == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(31);
                }
                return list2;
            }
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            JSTypeCastUtil.$$$reportNull$$$0(32);
        }
        return list3;
    }

    private static boolean isAcceptableLibraryType(@NotNull JSType type, @NotNull Set<VirtualFile> libraries) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(33);
        }
        if (libraries == null) {
            JSTypeCastUtil.$$$reportNull$$$0(34);
        }
        if (type instanceof JSArrayType) {
            return true;
        }
        if (!(type instanceof JSResolvableType)) {
            return false;
        }
        Collection<PsiElement> declarations = ((JSResolvableType)type).getDeclarations();
        for (PsiElement declaration : declarations) {
            if (!libraries.contains(PsiUtilCore.getVirtualFile((PsiElement)declaration))) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static NullableState getNullableState(@Nullable JSType type) {
        if (!((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) instanceof JSUnionType)) {
            if (type instanceof JSNullType) {
                NullableState nullableState = NullableState.HAS_NULL;
                if (nullableState == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(35);
                }
                return nullableState;
            }
            if (type instanceof JSUndefinedType) {
                NullableState nullableState = NullableState.HAS_UNDEFINED;
                if (nullableState == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(36);
                }
                return nullableState;
            }
            NullableState nullableState = NullableState.NOT_NULLABLE;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(37);
            }
            return nullableState;
        }
        boolean hasNull = false;
        boolean hasUndefined = false;
        for (JSType part : ((JSUnionType)type).getTypes()) {
            if (part instanceof JSNullType) {
                hasNull = true;
                continue;
            }
            if (part instanceof JSUndefinedType) {
                hasUndefined = true;
                continue;
            }
            if (!hasNull || !hasUndefined) continue;
            break;
        }
        if (hasNull && hasUndefined) {
            NullableState nullableState = NullableState.HAS_NULL_AND_UNDEFINED;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(38);
            }
            return nullableState;
        }
        if (hasNull) {
            NullableState nullableState = NullableState.HAS_NULL;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(39);
            }
            return nullableState;
        }
        if (hasUndefined) {
            NullableState nullableState = NullableState.HAS_UNDEFINED;
            if (nullableState == null) {
                JSTypeCastUtil.$$$reportNull$$$0(40);
            }
            return nullableState;
        }
        NullableState nullableState = NullableState.NOT_NULLABLE;
        if (nullableState == null) {
            JSTypeCastUtil.$$$reportNull$$$0(41);
        }
        return nullableState;
    }

    @NotNull
    public static AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType thisOperand, @NotNull JSType rOperand, @NotNull ProcessingContext processingContext) {
        JSType constraint;
        JSType substitutedType;
        JSType type;
        if (thisOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(42);
        }
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(43);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(44);
        }
        if (rOperand.isTypeScript() && JSTypeCastUtil.strictNullChecks(processingContext)) {
            if (rOperand instanceof JSNullType) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand instanceof JSNullType || thisOperand instanceof JSAnyType);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(45);
                }
                return assignableResult;
            }
            if (rOperand instanceof JSUndefinedType) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand instanceof JSUndefinedType || thisOperand instanceof JSAnyType || thisOperand instanceof JSVoidType);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(46);
                }
                return assignableResult;
            }
        }
        if (rOperand instanceof JSUndefinedType) {
            AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(47);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSGenericParameterImpl) {
            boolean assignable;
            JSType constraintType = ((JSGenericParameterImpl)rOperand).getConstraintType();
            if (constraintType != null && thisOperand.isDirectlyAssignableType(constraintType, processingContext)) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(true);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(48);
                }
                return assignableResult;
            }
            boolean bl = assignable = thisOperand instanceof JSGenericParameterType || rOperand.isDirectlyAssignableType(thisOperand, processingContext);
            if (assignable) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(true);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(49);
                }
                return assignableResult;
            }
        }
        if (rOperand instanceof JSDecoratedTypeImpl && !((JSDecoratedTypeImpl)rOperand).getDecorations().isEmpty()) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(((JSDecoratedTypeImpl)rOperand).getType(), processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(50);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSUnionOrIntersectionType) {
            JSUnionOrIntersectionType compositeType = (JSUnionOrIntersectionType)rOperand;
            boolean isIntersection = compositeType instanceof JSIntersectionType;
            boolean isStrictContext = JSTypeCastUtil.isStrictTypeScriptUnionType(compositeType) && thisOperand.isSourceStrict() && thisOperand.isTypeScript();
            boolean result2 = JSTypeCastUtil.checkAssignableComposite(thisOperand, compositeType, processingContext, !isIntersection && isStrictContext);
            if (result2 || !isStrictContext) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(result2);
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(51);
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSTypeImpl) {
            JSTypeImpl jsType = (JSTypeImpl)rOperand;
            JSType typedefValue = jsType.getJSTypedef();
            if (typedefValue != null) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(typedefValue, processingContext));
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(52);
                }
                return assignableResult;
            }
        } else if (rOperand instanceof JSGenericTypeImpl && (type = ((JSGenericTypeImpl)rOperand).getType()) instanceof JSTypeImpl && ((JSTypeImpl)type).getJSTypedef() != null && (substitutedType = rOperand.substitute()) != rOperand) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(substitutedType, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(53);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSRestTypeImpl && ((JSRestTypeImpl)rOperand).getIterableType() instanceof JSTupleType) {
            AssignableResult assignableResult = AssignableResult.NOT_ASSIGNABLE;
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(54);
            }
            return assignableResult;
        }
        if ((rOperand instanceof TypeScriptTypePredicateTypeImpl || rOperand instanceof TypeScriptGenericThisTypeImpl) && (type = ((JSTypeWithIncompleteSubstitution)rOperand).substituteCompletely()) != rOperand) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(55);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSTupleType) {
            type = ((JSTupleType)rOperand).toArrayType(true);
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(56);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSTemplateLiteralType && (constraint = TypeScriptTypeRelations.getBaseConstraintOfType(rOperand, rOperand.getSourceElement())) != null && constraint != rOperand) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(constraint, processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(57);
            }
            return assignableResult;
        }
        if (rOperand instanceof JSEvaluableType || rOperand instanceof JSUnionType) {
            TypeScriptMappedJSTypeImpl mappedType;
            JSType paramType;
            type = rOperand.substitute();
            if (type != rOperand) {
                AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(type, processingContext));
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(58);
                }
                return assignableResult;
            }
            if (rOperand instanceof TypeScriptMappedJSTypeImpl && JSTypeCastUtil.isTypeOperatorLikeType(paramType = (mappedType = (TypeScriptMappedJSTypeImpl)rOperand).getParameterType()) && TypeScriptMappedJSTypeImpl.isDirectAssignableForMappedTypeWithTypeOperator(thisOperand, mappedType, processingContext, true)) {
                AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(59);
                }
                return assignableResult;
            }
            if (rOperand instanceof JSEvaluableType) {
                AssignableResult assignableResult = AssignableResult.ASSIGNABLE;
                if (assignableResult == null) {
                    JSTypeCastUtil.$$$reportNull$$$0(60);
                }
                return assignableResult;
            }
        }
        if (rOperand instanceof JSWrapperType) {
            AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(thisOperand.isDirectlyAssignableType(JSTypeUtils.unwrapType(rOperand), processingContext));
            if (assignableResult == null) {
                JSTypeCastUtil.$$$reportNull$$$0(61);
            }
            return assignableResult;
        }
        AssignableResult assignableResult = thisOperand.isEcma() && thisOperand.isEquivalentTo(rOperand, processingContext) ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_SURE;
        if (assignableResult == null) {
            JSTypeCastUtil.$$$reportNull$$$0(62);
        }
        return assignableResult;
    }

    @Contract(value="null -> false")
    public static boolean isTypeOperatorLikeType(@Nullable JSType paramType) {
        return paramType instanceof JSKeyofType || paramType instanceof JSGenericParameterImpl && JSTypeCastUtil.isKeyLikeConstraint((JSGenericParameterImpl)paramType);
    }

    private static boolean isKeyLikeConstraint(@NotNull JSGenericParameterImpl paramType) {
        JSType constraintType;
        if (paramType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(63);
        }
        return (constraintType = paramType.getConstraintType()) instanceof JSKeyofType || constraintType instanceof JSStringType || constraintType instanceof JSUnionType && ((JSUnionType)constraintType).getTypes().stream().anyMatch(t -> t instanceof JSStringType || t instanceof JSKeyofType);
    }

    public static boolean isAlwaysAssignableType(@NotNull JSType type, boolean isJavaScriptContext, @Nullable ProcessingContext processingContext, @Nullable PsiElement context) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(64);
        }
        if (type instanceof JSAnyType || type instanceof TypeScriptNeverJSTypeImpl || type instanceof JSRequireCallExpressionType || type instanceof JSUnionType && ((JSUnionType)type).isAnyType()) {
            return true;
        }
        if ((type instanceof JSNullType || type instanceof JSUndefinedType) && !isJavaScriptContext) {
            if (processingContext != null) {
                return !JSTypeCastUtil.strictNullChecks(processingContext);
            }
            return !TypeScriptConfigUtil.strictNullChecks(context);
        }
        return false;
    }

    public static boolean isAlwaysAssignableType(@NotNull JSType type, @Nullable PsiElement context) {
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(65);
        }
        return JSTypeCastUtil.isAlwaysAssignableType(type, type.getSource().isJavaScript(), null, context);
    }

    public static boolean isStrictTypeScriptUnionType(@NotNull JSUnionOrIntersectionType rOperand) {
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(66);
        }
        assert (rOperand instanceof JSTypeBaseImpl);
        JSTypeBaseImpl baseType = (JSTypeBaseImpl)((Object)rOperand);
        if (!baseType.isTypeScript() || !baseType.isSourceStrict()) {
            return false;
        }
        for (JSType type : rOperand.getTypes()) {
            if (!(type instanceof JSAnyType)) continue;
            return false;
        }
        return true;
    }

    public static AssignableResult toStrictAssignable(boolean value) {
        return value ? AssignableResult.ASSIGNABLE : AssignableResult.NOT_ASSIGNABLE;
    }

    @Nullable
    public static JSRecordType buildWithAppliedGenericArguments(@NotNull JSClass jsClass, @NotNull JSGenericTypeImpl type, boolean hasOuters) {
        TypeScriptTypeParameterListOwner owner;
        if (jsClass == null) {
            JSTypeCastUtil.$$$reportNull$$$0(67);
        }
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(68);
        }
        if (jsClass instanceof TypeScriptTypeParameterListOwner && ((owner = (TypeScriptTypeParameterListOwner)jsClass).getTypeParameterList() != null || hasOuters)) {
            JSTypeSubstitutor genericArgumentsMap = TypeScriptGenericTypesEvaluator.getSubstitutorForTypeArguments(owner, type);
            JSType baseType = type.getType();
            boolean isStatic = baseType instanceof JSNamedType && ((JSNamedType)baseType).isStaticOrInstance() == JSContext.STATIC;
            JSRecordType recordType = TypeScriptTypeParser.buildTypeFromClass(jsClass, isStatic);
            return (JSRecordType)JSTypeUtils.applyGenericArguments((JSType)recordType, genericArgumentsMap);
        }
        return null;
    }

    public static boolean checkAssignableComposite(@NotNull JSType thisOperand, @NotNull JSUnionOrIntersectionType rOperand, @NotNull ProcessingContext beforeContext, boolean needCheckAllTypes) {
        if (thisOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(69);
        }
        if (rOperand == null) {
            JSTypeCastUtil.$$$reportNull$$$0(70);
        }
        if (beforeContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(71);
        }
        return JSTypeCastUtil.executeJoinInferredGenerics((Processor<? super ProcessingContext>)((Processor)processingContext -> {
            StreamEx collection = thisOperand instanceof JSUnionType ? StreamEx.of(((JSUnionType)thisOperand).getTypes()) : StreamEx.of((Object)thisOperand);
            Set ids = collection.map(el -> TypeScriptTypeRelations.getRegularTypeOfLiteralType(el).getResolvedTypeId()).toSet();
            for (JSType jsType : rOperand.getTypes()) {
                boolean result2;
                boolean bl = result2 = ids.contains(TypeScriptTypeRelations.getRegularTypeOfLiteralType(jsType).getResolvedTypeId()) || thisOperand.isDirectlyAssignableType(jsType, processingContext);
                if (needCheckAllTypes) {
                    if (result2) continue;
                    return false;
                }
                if (!result2) continue;
                return true;
            }
            return needCheckAllTypes;
        }), beforeContext, rOperand.getSource(), false);
    }

    public static boolean compareByExcessProperties(@NotNull JSTypeBaseImpl ownType, @NotNull JSFreshObjectLiteralType otherType, @NotNull ProcessingContext processingContext) {
        if (ownType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(72);
        }
        if (otherType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(73);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(74);
        }
        if (ownType instanceof JSObjectType || ownType instanceof JSGenericParameterType || JSTypeCastUtil.excessPropertyChecksDisabled(ownType)) {
            return true;
        }
        Set literalProperties = otherType.getPropertyNames();
        if (ownType instanceof JSUnionType) {
            List<JSType> types2 = ((JSUnionType)((Object)ownType)).getTypes();
            if (types2.isEmpty()) {
                return true;
            }
            Collection<String> properties = JSTypeCastUtil.getObjectTypeProperties(otherType);
            for (JSType type : types2) {
                if (!JSTypeCastUtil.checkExcessPropertiesForFinalType(type, properties, literalProperties, processingContext)) continue;
                return true;
            }
            return false;
        }
        return JSTypeCastUtil.checkExcessPropertiesForFinalType(ownType, JSTypeCastUtil.getObjectTypeProperties(otherType), literalProperties, processingContext);
    }

    @NotNull
    public static Collection<String> getObjectTypeProperties(@NotNull JSFreshObjectLiteralType otherType) {
        if (otherType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(75);
        }
        JSType objectType = JSNamedTypeFactory.createType("Object", otherType.getSource(), JSContext.INSTANCE);
        Set set = objectType.asRecordType().getPropertyNames();
        if (set == null) {
            JSTypeCastUtil.$$$reportNull$$$0(76);
        }
        return set;
    }

    private static boolean checkExcessPropertiesForFinalType(@Nullable JSType finalType, @NotNull Collection<String> objectTypeProperties, @NotNull Collection<String> literalProperties, ProcessingContext processingContext) {
        boolean isValid;
        if (objectTypeProperties == null) {
            JSTypeCastUtil.$$$reportNull$$$0(77);
        }
        if (literalProperties == null) {
            JSTypeCastUtil.$$$reportNull$$$0(78);
        }
        if (finalType instanceof JSObjectType || finalType == null) {
            return true;
        }
        JSRecordType ownTypeAsRecord = finalType.asRecordType();
        if (!JSTypeCastUtil.shouldCheckForExcessProperties(ownTypeAsRecord)) {
            return true;
        }
        HashSet<String> otherProps = new HashSet<String>(literalProperties);
        otherProps.removeAll(ownTypeAsRecord.getPropertyNames());
        otherProps.removeAll(objectTypeProperties);
        boolean bl = isValid = otherProps.size() == 0;
        if (!isValid) {
            HashSet<String> nonProcessed = new HashSet<String>(otherProps);
            JSTypeAssignableErrorMessage.addMessageToContext((ProcessingContext)processingContext, e -> {
                if (!(e instanceof JSObjectLiteralExpression)) {
                    return null;
                }
                int startOffset = -1;
                int endOffset = -1;
                for (JSProperty property : ((JSObjectLiteralExpression)e).getProperties()) {
                    if (startOffset == -1) {
                        if (nonProcessed.remove(property.getName())) {
                            startOffset = property.getTextOffset();
                            endOffset = property.getTextRange().getEndOffset();
                        }
                    } else {
                        endOffset = property.getTextRange().getEndOffset();
                        if (!nonProcessed.remove(property.getName()) && !nonProcessed.isEmpty()) {
                            return null;
                        }
                    }
                    if (nonProcessed.isEmpty()) break;
                }
                if (startOffset != -1 && endOffset != -1) {
                    return new TextRange(startOffset, endOffset).shiftLeft(e.getTextOffset());
                }
                return null;
            }, (String)"javascript.known.props.only", (String[])new String[]{StringUtil.join(otherProps, p -> "'" + p + "'", (String)", ")});
        }
        return isValid;
    }

    private static boolean shouldCheckForExcessProperties(@NotNull JSRecordType recordType) {
        if (recordType == null) {
            JSTypeCastUtil.$$$reportNull$$$0(79);
        }
        return !recordType.hasIndexers() && recordType.hasProperties();
    }

    public static boolean strictNullChecks(@Nullable ProcessingContext context) {
        return context != null && Boolean.TRUE.equals(context.get(JSTypeComparingContextService.NULL_CHECKS));
    }

    private static boolean excessPropertyChecksDisabled(@NotNull JSTypeBaseImpl type) {
        TypeScriptConfig config2;
        PsiFile scope;
        if (type == null) {
            JSTypeCastUtil.$$$reportNull$$$0(80);
        }
        return (scope = type.getSource().getScope()) != null && scope.isValid() && (config2 = TypeScriptConfigUtil.getConfigForPsiFile(scope)) != null && config2.suppressExcessPropertyChecks();
    }

    public static boolean executeJoinInferredGenerics(@NotNull Processor<? super ProcessingContext> command, @NotNull ProcessingContext processingContext, @NotNull JSTypeSource source, boolean intersectionType) {
        JSGenericMappings originalGenericArgumentsMapping;
        if (command == null) {
            JSTypeCastUtil.$$$reportNull$$$0(81);
        }
        if (processingContext == null) {
            JSTypeCastUtil.$$$reportNull$$$0(82);
        }
        if (source == null) {
            JSTypeCastUtil.$$$reportNull$$$0(83);
        }
        if ((originalGenericArgumentsMapping = (JSGenericMappings)processingContext.get(JSGenericTypesEvaluator.ourGenericArgumentsMapKey)) == null) {
            return command.process((Object)processingContext);
        }
        JSGenericMappings newGenericArgumentsMap = originalGenericArgumentsMapping.copyWithMapping((MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType>)new MultiMap());
        processingContext.put(JSGenericTypesEvaluator.ourGenericArgumentsMapKey, (Object)newGenericArgumentsMap);
        boolean result2 = command.process((Object)processingContext);
        processingContext.put(JSGenericTypesEvaluator.ourGenericArgumentsMapKey, (Object)originalGenericArgumentsMapping);
        for (Map.Entry entry : newGenericArgumentsMap.getMapping().entrySet()) {
            Collection items = (Collection)entry.getValue();
            if (items.isEmpty()) continue;
            ArrayList types2 = new ArrayList(items);
            JSType resultType = JSCompositeTypeImpl.optimizeTypeIfComposite(intersectionType || processingContext.get(JSGenericTypesEvaluator.ourHadContravariantGenerics) == Boolean.TRUE ? JSCompositeTypeFactory.createIntersectionType(types2, source) : JSCompositeTypeFactory.createUnionType(source, types2));
            originalGenericArgumentsMapping.getMapping().putValue((Object)((JSTypeSubstitutor.JSTypeGenericId)entry.getKey()), (Object)resultType);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 5: 
            case 16: 
            case 44: 
            case 74: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeCastUtil";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lMainType";
                break;
            }
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rMainType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rArguments";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toCheck";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainType";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentCandidate";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childCandidate";
                break;
            }
            case 33: 
            case 64: 
            case 65: 
            case 68: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraries";
                break;
            }
            case 42: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisOperand";
                break;
            }
            case 43: 
            case 66: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rOperand";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramType";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeContext";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownType";
                break;
            }
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectTypeProperties";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalProperties";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeCastUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableInClassHierarchy";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "isAssignableWithSameMainType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "areExplicitAssignable";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericsForSubClass";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullableState";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectTypeProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "areListsEquivalent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMainType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableInClassHierarchy";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 76: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableWithSameMainType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canUseReverseHierarchy";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyOneSuperReference";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "areExplicitAssignable";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericsForSubClass";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableLibraryType";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isKeyLikeConstraint";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysAssignableType";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isStrictTypeScriptUnionType";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "buildWithAppliedGenericArguments";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignableComposite";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "compareByExcessProperties";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getObjectTypeProperties";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "checkExcessPropertiesForFinalType";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "shouldCheckForExcessProperties";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "excessPropertyChecksDisabled";
                break;
            }
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "executeJoinInferredGenerics";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AssignableResult {
        ASSIGNABLE(true, true),
        NOT_ASSIGNABLE(true, false),
        NOT_SURE(false, false),
        NO_CACHE(false, false);

        private final boolean myStrict;
        private final boolean myAssignable;

        private AssignableResult(boolean strict, boolean assignable) {
            this.myStrict = strict;
            this.myAssignable = assignable;
        }

        public boolean isAssignable() {
            return this.myAssignable;
        }

        public boolean isStrict() {
            return this.myStrict;
        }

        public String toString() {
            return "AssignableResult{myStrict=" + this.myStrict + ", myAssignable=" + this.myAssignable + "}";
        }
    }

    public static enum NullableState {
        HAS_NULL,
        HAS_UNDEFINED,
        HAS_NULL_AND_UNDEFINED,
        NOT_NULLABLE;


        public boolean hasNull() {
            return this == HAS_NULL || this == HAS_NULL_AND_UNDEFINED;
        }

        public boolean hasUndefined() {
            return this == HAS_UNDEFINED || this == HAS_NULL_AND_UNDEFINED;
        }
    }
}

