/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSOverflowTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSPresentableTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSRecursiveTypeTransformer;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeHelper;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformer;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerBase;
import com.intellij.lang.javascript.psi.types.JSCacheableTypeTransformerResolvedIdBase;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeUtil;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeIdCache;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeComparingCache;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutionContextImpl;
import com.intellij.lang.javascript.psi.types.JSTypesAssignableError;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.settings.JSSymbolPresentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.StackOverflowPreventedException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class JSTypeBaseImpl
implements JSType {
    public static final Key<Boolean> CALL_ENV_KEY = Key.create((String)"js.type.is.call.env");
    public static final Key<Boolean> EQ_EVALUATED = Key.create((String)"eq.evaluated");
    private static final JSType.LocalTypeKey RECORD_TYPE_CACHE = JSType.createLocalTypeKey((String)"js.record.type.cache.base");
    protected static final Key<Set<JSResolvedTypeId>> VISITED_TYPES = Key.create((String)"js.type.visited.set");
    private static boolean ASSERT_ON_RECORD_TYPE_USAGE = false;
    private static final Key<?>[] IDS = new Key[]{CALL_ENV_KEY, JSTypeComparingCache.SUBTYPING_CONTEXT, JSGenericTypesEvaluator.ourGenericArgumentsMapKey, JSGenericTypesEvaluator.ourHadContravariantGenerics, JSRecursiveTypeUtil.ASSIGNABLE_KEY, JSTypeComparingContextService.NULL_CHECKS};
    @Nullable
    private volatile JSResolvedTypeIdImpl myResolvedKey;
    @NotNull
    private final JSTypeSource mySource;
    private int myHashCode;

    @NotNull
    public static JSType getSelfNoTransformationType() {
        JSType jSType = Holder.SELF_NO_TRANSFORMATION;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(0);
        }
        return jSType;
    }

    @NotNull
    public static JSType getNullType() {
        JSType jSType = Holder.NULL_TYPE;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(1);
        }
        return jSType;
    }

    @TestOnly
    public static void assertOnRecordTypeUsage(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(2);
        }
        ASSERT_ON_RECORD_TYPE_USAGE = true;
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ASSERT_ON_RECORD_TYPE_USAGE = false;
            }
        });
    }

    @Contract(value="!null->!null")
    public static ProcessingContext copyProcessingContextWithoutComparingCache(@Nullable ProcessingContext context) {
        if (context == null) {
            return null;
        }
        ProcessingContext newContext = new ProcessingContext();
        for (Key<?> id : IDS) {
            Object value = context.get(id);
            if (value == null) continue;
            newContext.put(id, value);
        }
        return newContext;
    }

    protected JSTypeBaseImpl(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(3);
        }
        this.myHashCode = 0;
        this.mySource = source;
    }

    @NotNull
    public final JSType getLocalCachedType(@NotNull Supplier<? extends JSType> factory, @NotNull JSType.LocalTypeKey cacheKey) {
        JSResolvedTypeIdImpl id;
        JSType value;
        if (factory == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(4);
        }
        if (cacheKey == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(5);
        }
        JSTypeBaseImpl jSTypeBaseImpl = (value = (id = this.getResolvedTypeId()).getLocalCachedValue(cacheKey, factory)) == null ? this : value;
        if (jSTypeBaseImpl == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(6);
        }
        return jSTypeBaseImpl;
    }

    @NotNull
    public final String getTypeText() {
        String string = super.getTypeText();
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public final String getResolvedTypeText() {
        String string = super.getResolvedTypeText();
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getTypeText(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(9);
        }
        Object builder = format == JSType.TypeTextFormat.PRESENTABLE ? new JSPresentableTypeTextStringBuilder() : new JSOverflowTypeTextStringBuilder(format);
        this.buildTypeTextInner(format, (JSTypeTextBuilder)builder, true);
        String string = builder.getResult();
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    public final void buildTypeText(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(12);
        }
        this.buildTypeTextInner(format, builder, false);
    }

    private void buildTypeTextInner(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder, boolean fromTypeText) {
        if (format == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(14);
        }
        try {
            ProgressManager.checkCanceled();
            if (!builder.startProcessType((JSType)this)) {
                return;
            }
            this.buildTypeTextImpl(format, builder);
            builder.endProcessType((JSType)this);
        }
        catch (IllegalStateException exception) {
            if (fromTypeText || Holder.TEST_MODE) {
                throw exception;
            }
            builder.append(this.getTypeText(format));
        }
    }

    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(15);
        }
        if (builder == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(16);
        }
        throw new IllegalStateException("Method buildTypeTextImpl must be implemented");
    }

    @NotNull
    public final JSTypeSource getSource() {
        JSTypeSource jSTypeSource = this.mySource;
        if (jSTypeSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(17);
        }
        return jSTypeSource;
    }

    public final boolean isDirectlyAssignableType(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        boolean result2 = this.isDirectlyAssignableTypeWithCache(elementType, processingContext);
        if (processingContext != null) {
            JSTypesAssignableError.updateAssignableChain(this, elementType, result2, processingContext);
        }
        return result2;
    }

    private boolean isDirectlyAssignableTypeWithCache(@Nullable JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            return true;
        }
        if (this.isDirectAssignableTypeSimple(elementType, processingContext)) {
            return true;
        }
        ProgressManager.checkCanceled();
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        JSType expandThis = TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(this.substitute());
        JSType expandRType = TypeScriptTypeRelations.getCanonicalTypeForExoticLiterals(elementType.substitute());
        if (this != expandThis || elementType != expandRType) {
            return expandThis.isDirectlyAssignableType(expandRType, processingContext);
        }
        JSResolvedTypeIdImpl thisId = this.getResolvedTypeId();
        JSResolvedTypeId rTypeId = elementType.getResolvedTypeId();
        return JSRecursiveTypeUtil.computeWithRecursiveTypes(thisId, rTypeId, JSRecursiveTypeUtil.ASSIGNABLE_KEY, elementType, processingContext, this::isDirectlyAssignableUnderRecursionProtection);
    }

    private boolean isDirectlyAssignableUnderRecursionProtection(@NotNull JSType elementType, ProcessingContext finalProcessingContext) {
        JSTypeComparingCache cache2;
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(18);
        }
        if ((cache2 = (JSTypeComparingCache)finalProcessingContext.get(JSTypeComparingContextService.TYPE_COMPARATOR)) != null) {
            JSTypeCastUtil.AssignableResult assignableResult = cache2.areAssignableTypes(this, elementType, finalProcessingContext);
            if (assignableResult.isStrict()) {
                this.checkCachedValue(elementType, finalProcessingContext, assignableResult);
                return assignableResult.isAssignable();
            }
            if (assignableResult != JSTypeCastUtil.AssignableResult.NO_CACHE) {
                boolean result2 = this.calculateAssignabilityWithoutCache(elementType, finalProcessingContext);
                cache2.putAssignableTypes(this, elementType, finalProcessingContext, JSTypeCastUtil.toStrictAssignable(result2));
                return result2;
            }
        }
        return this.calculateAssignabilityWithoutCache(elementType, finalProcessingContext);
    }

    private boolean isDirectAssignableTypeSimple(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(19);
        }
        if (this.isTypeScript() && elementType == JSUnknownType.TS_INSTANCE) {
            return this instanceof JSAnyType;
        }
        if (this.isEquivalentTo(elementType, processingContext, !this.isEcma())) {
            return true;
        }
        if (JSTypeComparingContextService.isSubtyping(processingContext) && elementType instanceof JSAnyType) {
            return false;
        }
        return this.checkAlwaysAssignableType(elementType, processingContext);
    }

    protected boolean checkAlwaysAssignableType(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(20);
        }
        return JSTypeCastUtil.isAlwaysAssignableType(elementType, this.isJavaScript() && elementType.isJavaScript(), processingContext, null);
    }

    private boolean calculateAssignabilityWithoutCache(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSFreshObjectLiteralType freshType;
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(21);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(22);
        }
        JSFreshObjectLiteralType jSFreshObjectLiteralType = freshType = elementType instanceof JSFreshObjectLiteralType ? (JSFreshObjectLiteralType)elementType : null;
        if (freshType != null) {
            elementType = ((JSFreshObjectLiteralType)elementType).removeFreshness();
        }
        return this.isDirectlyAssignableTypeImpl(elementType, processingContext) && (!this.isTypeScript() || freshType == null || JSTypeCastUtil.compareByExcessProperties(this, freshType, processingContext));
    }

    private void checkCachedValue(@NotNull JSType elementType, @NotNull ProcessingContext processingContext, @NotNull JSTypeCastUtil.AssignableResult fromCache) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(23);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(24);
        }
        if (fromCache == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(25);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        ProcessingContext newContext = JSTypeBaseImpl.copyProcessingContextWithoutComparingCache(processingContext);
        boolean isAssignable = this.calculateAssignabilityWithoutCache(elementType, newContext);
        if (fromCache.isAssignable() != isAssignable) {
            String message = String.format("checkCachedValue failed. This: %s;\nElement: %s;\nFrom cache: %s;\nIsAssignable:%s", new Object[]{this.getTypeText(), elementType.getTypeText(), fromCache, isAssignable});
            Logger.getInstance(this.getClass()).error(message);
        }
    }

    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(26);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(27);
        }
        return this.isDirectlyAssignableTypeCommon(elementType, processingContext).isAssignable();
    }

    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(28);
        }
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(29);
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.isDirectlyAssignableTypeCommon(this, elementType, processingContext);
        if (assignableResult == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(30);
        }
        return assignableResult;
    }

    public void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(31);
        }
        visitor.visitJSTypeBaseImpl((JSType)this);
    }

    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(32);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        List fields = ReflectionUtil.collectFields(this.getClass());
        fields.forEach(el -> {
            Class<?> componentType;
            if (Modifier.isStatic(el.getModifiers())) {
                return;
            }
            Class<?> type = el.getType();
            if (JSType.class.isAssignableFrom(type)) {
                throw new AssertionError((Object)("Type must visit all nested types " + this.getClass()));
            }
            if (Collection.class.isAssignableFrom(type) && (componentType = type.getComponentType()) != null && JSType.class.isAssignableFrom(type)) {
                throw new AssertionError((Object)("Type must visit all nested types " + this.getClass()));
            }
        });
    }

    @Nullable
    public final PsiFile getScope() {
        return this.mySource.getScope();
    }

    @NotNull
    protected final JSTypeHelper getTypeHelper() {
        JSLanguageDialect language = null;
        switch (this.getSource().getLanguage()) {
            case TS: {
                language = JavaScriptSupportLoader.TYPESCRIPT;
                break;
            }
            case AS: {
                language = JavaScriptSupportLoader.ECMA_SCRIPT_L4;
                break;
            }
            case JS: {
                language = JavascriptLanguage.INSTANCE;
            }
        }
        JSTypeHelper jSTypeHelper = JSDialectSpecificHandlersFactory.forLanguage((Language)language).getTypeHelper();
        if (jSTypeHelper == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(33);
        }
        return jSTypeHelper;
    }

    @Deprecated
    @Nullable
    public JSClass resolveClass() {
        return null;
    }

    @NotNull
    public final JSType transformTypeHierarchy(@NotNull Function<JSType, JSType> transformation) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(34);
        }
        if (transformation instanceof JSRecursiveTypeTransformer) {
            return this.transformTypeHierarchy((JSRecursiveTypeTransformer)transformation);
        }
        JSCacheableTypeTransformer transformer = new JSCacheableTypeTransformer(transformation);
        return this.transformTypeHierarchy(transformer);
    }

    @NotNull
    public final JSType transformTypeHierarchy(@NotNull JSRecursiveTypeTransformer transformation) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(35);
        }
        ProgressManager.checkCanceled();
        JSType jSType = transformation.transformRecursive((JSType)this, this::transformTypeOrCopyWithTransformation);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(36);
        }
        return jSType;
    }

    @NotNull
    private JSType transformTypeOrCopyWithTransformation(@NotNull Function<JSType, JSType> transformation) {
        JSType transformedType;
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(37);
        }
        if (this != (transformedType = (JSType)transformation.fun((Object)this))) {
            if (transformedType == JSTypeBaseImpl.getSelfNoTransformationType()) {
                JSTypeBaseImpl jSTypeBaseImpl = this;
                if (jSTypeBaseImpl == null) {
                    JSTypeBaseImpl.$$$reportNull$$$0(38);
                }
                return jSTypeBaseImpl;
            }
            this.checkUselessCopy(transformation, transformedType);
            JSType jSType = transformedType;
            if (jSType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(39);
            }
            return jSType;
        }
        JSType result2 = this.copyTypeHierarchy(transformation);
        this.checkUselessCopy(transformation, result2);
        JSType jSType = result2;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(40);
        }
        return jSType;
    }

    private void checkUselessCopy(@NotNull Function<JSType, JSType> transformation, @NotNull JSType result2) {
        if (transformation == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(41);
        }
        if (result2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(42);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        if (transformation instanceof JSCacheableTypeTransformerResolvedIdBase && result2.getSource() == this.getSource() && result2 != this && result2.getResolvedTypeId().equals(this.getResolvedTypeId())) {
            Logger.getInstance(this.getClass()).error("Useless type copy " + this.getTypeText() + ". \nTypes must be the same if there are no changes in nested types.");
        }
    }

    private void checkSymmetrical(@NotNull JSType rType, boolean result2, boolean eqEvaluated, boolean allowResolve) {
        if (rType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(43);
        }
        if (!Holder.TEST_MODE) {
            return;
        }
        ProcessingContext context = new ProcessingContext();
        JSTypeBaseImpl thisType = this;
        if (eqEvaluated) {
            context.put(EQ_EVALUATED, (Object)Boolean.TRUE);
            thisType = JSTypeBaseImpl.expandCodeBased(this);
            rType = JSTypeBaseImpl.expandCodeBased(rType);
        }
        if (result2 != ((JSTypeBaseImpl)rType).isEquivalentToWithSameClass(thisType, context, allowResolve)) {
            Logger.getInstance(this.getClass()).error("isEquivalentTo must be a symmetrical relation: " + this.getTypeText() + ", " + rType.getTypeText() + ": class " + thisType.getClass().getName());
        }
    }

    @NotNull
    protected abstract JSType copyTypeHierarchy(@NotNull Function<JSType, JSType> var1);

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext) {
        return this.isEquivalentTo(type, processingContext, true);
    }

    public final boolean isEquivalentTo(@Nullable JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        Class<?> typeClass;
        Class<?> thisClass;
        boolean eqEvaluated;
        if (this == type) {
            return true;
        }
        if (type == null) {
            return false;
        }
        boolean bl = eqEvaluated = processingContext != null && allowResolve && processingContext.get(EQ_EVALUATED) == Boolean.TRUE;
        if (eqEvaluated) {
            JSType thisType = JSTypeBaseImpl.expandCodeBased(this);
            JSType rType = JSTypeBaseImpl.expandCodeBased(type);
            if (thisType != this || type != rType) {
                return thisType.isEquivalentTo(rType, processingContext, true);
            }
        }
        if (!allowResolve) {
            JSTypeSource rSource = type.getSource();
            JSTypeSource thisSource = this.getSource();
            if (rSource.getLanguage() != thisSource.getLanguage()) {
                return false;
            }
            if (rSource.isStrict() != thisSource.isStrict()) {
                return false;
            }
        }
        if (!(thisClass = this.getClass()).equals(typeClass = type.getClass())) {
            return false;
        }
        if (processingContext == null) {
            processingContext = new ProcessingContext();
        }
        ProgressManager.checkCanceled();
        boolean result2 = this.isEquivalentToWithSameClass(type, processingContext, allowResolve);
        this.checkSymmetrical(type, result2, eqEvaluated, allowResolve);
        return result2;
    }

    @NotNull
    private static JSType expandCodeBased(@NotNull JSType type) {
        if (type == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(44);
        }
        JSType rType = type;
        if (type instanceof JSCodeBasedType) {
            rType = type.substitute();
        }
        JSType jSType = rType;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(45);
        }
        return jSType;
    }

    @NotNull
    public final JSType copyWithStrict(boolean strict) {
        JSTypeSource source = this.getSource();
        if (source.isStrict() == strict) {
            JSTypeBaseImpl jSTypeBaseImpl = this;
            if (jSTypeBaseImpl == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(46);
            }
            return jSTypeBaseImpl;
        }
        return this.withNewSource(JSTypeSourceFactory.copyTypeSource(source, strict));
    }

    @NotNull
    protected abstract JSType copyWithNewSource(@NotNull JSTypeSource var1);

    @NotNull
    public final JSType withNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(47);
        }
        JSType jSType = this.copyWithNewSource(source);
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(48);
        }
        return jSType;
    }

    protected abstract boolean isEquivalentToWithSameClass(@NotNull JSType var1, @Nullable ProcessingContext var2, boolean var3);

    @NotNull
    public final JSRecordType asRecordType() {
        if (ASSERT_ON_RECORD_TYPE_USAGE && (!(this instanceof JSTypeImpl) || ((JSTypeImpl)this).getJSContext() != JSContext.STATIC)) {
            throw new AssertionError((Object)"Record type must be not used");
        }
        ProgressManager.checkCanceled();
        JSRecordType value = this.useCacheForRecordType() ? this.getLocalCachedType(this::asRecordTypeNoCache, RECORD_TYPE_CACHE) : this.asRecordTypeNoCache();
        JSRecordType jSRecordType = value instanceof JSRecordType ? value : JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(49);
        }
        return jSRecordType;
    }

    protected boolean useCacheForRecordType() {
        return false;
    }

    protected boolean useCacheForSubstitute() {
        return this.canBeSubstituted();
    }

    private boolean canBeSubstituted() {
        return !(this instanceof JSUtilType) && !(this instanceof JSFunctionType) && !(this instanceof JSGenericParameterImpl) && !(this instanceof JSRecordType);
    }

    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        if (this.isEcma()) {
            JSRecordType jSRecordType = JSTypeCastUtil.NO_RECORD_TYPE;
            if (jSRecordType == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(50);
            }
            return jSRecordType;
        }
        JSRecordType jSRecordType = JSTypeComparingContextService.buildRecordType(this);
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(51);
        }
        return jSRecordType;
    }

    @NotNull
    public final JSType substitute() {
        if (this.isEcma() || !this.canBeSubstituted()) {
            JSTypeBaseImpl jSTypeBaseImpl = this;
            if (jSTypeBaseImpl == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(52);
            }
            return jSTypeBaseImpl;
        }
        JSType result2 = this.substitute(new JSTypeSubstitutionContextImpl());
        JSType jSType = result2 == null ? JSAnyType.get(this.getSource()) : result2;
        if (jSType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(53);
        }
        return jSType;
    }

    @Nullable
    public final JSType substitute(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(54);
        }
        ProgressManager.checkCanceled();
        if (this.useCacheForSubstitute() && context.canCache()) {
            boolean canCacheNull;
            JSResolvedTypeIdImpl id = this.getResolvedTypeId();
            JSType result2 = id.getLocalCachedValue(SUBSTITUTE, () -> this.lambda$substitute$1(context, canCacheNull = context.canCacheNull()));
            return result2 == JSTypeBaseImpl.getNullType() ? null : result2;
        }
        return this.substituteAndOptimizeNoCache(context);
    }

    @Nullable
    private JSType substituteAndOptimizeNoCache(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(55);
        }
        return JSTypeBaseImpl.optimizeTypeInSubstitute(this.substituteNoCache(context), context);
    }

    @Nullable
    private JSType substituteNoCache(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(56);
        }
        if (!this.canBeSubstituted()) {
            return this;
        }
        if (!context.add((JSType)this)) {
            return null;
        }
        JSType type = this.substituteImpl(context);
        if (type == null) {
            return null;
        }
        if (type == this) {
            return type;
        }
        if (!context.isVisited(type = JSTypeBaseImpl.optimizeTypeInSubstitute(type, context))) {
            return type.substitute(context);
        }
        return type;
    }

    @Nullable
    private static JSType optimizeTypeInSubstitute(@Nullable JSType type, @NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(57);
        }
        return JSCompositeTypeImpl.optimizeTypeIfComposite(type, JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE, context);
    }

    @Nullable
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(58);
        }
        return this;
    }

    @Contract(value="!null,_ -> !null", pure=true)
    public static JSType replaceEmptySourceRecursive(@Nullable JSType type, @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(59);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, newSource, (Condition<? super JSTypeSource>)((Condition)oldSource -> oldSource == JSTypeSource.EMPTY));
    }

    @Deprecated
    public static JSType replaceSourceRecursive(@Nullable JSType type, @NotNull JSTypeSource newSource) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(60);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, newSource, (Condition<? super JSTypeSource>)((Condition)oldSource -> oldSource != newSource));
    }

    @Contract(value="!null, _ -> !null")
    public static JSType copyWithLanguageRecursive(@Nullable JSType type, @NotNull JSTypeSource.SourceLanguage sourceLanguage) {
        if (sourceLanguage == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(61);
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, (Function<? super JSTypeBaseImpl, ? extends JSType>)((Function)currentType -> {
            if (currentType.getSource().getLanguage() == sourceLanguage) {
                return currentType;
            }
            return currentType.withNewSource(currentType.getSource().copyWithNewLanguage(sourceLanguage));
        }));
    }

    private static JSType replaceSourceRecursive(@Nullable JSType type, @NotNull JSTypeSource newSource, @NotNull Condition<? super JSTypeSource> replaceCondition) {
        if (newSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(62);
        }
        if (replaceCondition == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(63);
        }
        if (type == null) {
            return null;
        }
        return JSTypeBaseImpl.replaceSourceRecursive(type, (Function<? super JSTypeBaseImpl, ? extends JSType>)((Function)currentType -> {
            if (!replaceCondition.value((Object)currentType.getSource())) {
                return currentType;
            }
            return currentType.withNewSource(newSource);
        }));
    }

    @Contract(value="!null, _ -> !null")
    public static JSType replaceSourceRecursive(@Nullable JSType type, final @NotNull Function<? super JSTypeBaseImpl, ? extends JSType> createNewSource) {
        if (createNewSource == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(64);
        }
        if (type == null) {
            return null;
        }
        JSCacheableTypeTransformerBase cacheableFunction = new JSCacheableTypeTransformerBase(){

            @NotNull
            public JSType fun(@NotNull JSType currentType) {
                if (currentType == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (currentType instanceof JSTypeBaseImpl) {
                    JSType elementResult = (JSType)createNewSource.fun((Object)((JSTypeBaseImpl)currentType));
                    if (elementResult == currentType) {
                        JSType jSType = elementResult;
                        if (jSType == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return jSType;
                    }
                    JSType jSType = elementResult.transformTypeHierarchy((JSRecursiveTypeTransformer)this);
                    if (jSType == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return jSType;
                }
                assert (false);
                JSType jSType = currentType;
                if (jSType == null) {
                    2.$$$reportNull$$$0(3);
                }
                return jSType;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentType";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$2";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "fun";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "fun";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        return type.transformTypeHierarchy((Function)cacheableFunction);
    }

    protected int hashCodeImpl() {
        return super.hashCode();
    }

    protected boolean resolvedEquals(@Nullable JSType rType) {
        return this.isEquivalentTo(rType, null, true);
    }

    protected final int getSourceHashCode() {
        PsiElement element = this.getSourceElement();
        return element != null ? element.hashCode() : super.hashCode();
    }

    @NotNull
    public final JSResolvedTypeIdImpl getResolvedTypeId() {
        long trackId;
        JSResolvedTypeIdImpl key = this.myResolvedKey;
        PsiElement element = this.getSource().getSourceElement();
        boolean isElementValid = element != null && element.isValid();
        Project project = isElementValid ? element.getProject() : null;
        long l = trackId = isElementValid ? PsiModificationTracker.SERVICE.getInstance((Project)project).getModificationCount() : -1L;
        if (key == null || key.myTrackId != trackId) {
            JSResolvedTypeIdCache cache2 = null;
            if (project != null) {
                cache2 = JSTypeComparingContextService.getService(project).getResolvedTypeIdCacheCache();
            }
            this.myResolvedKey = key = new JSResolvedTypeIdImpl(trackId, cache2);
        }
        JSResolvedTypeIdImpl jSResolvedTypeIdImpl = key;
        if (jSResolvedTypeIdImpl == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(65);
        }
        return jSResolvedTypeIdImpl;
    }

    @NotNull
    protected String getTypeSeparator() {
        String string = JSSymbolPresentationProvider.getDefaultTypeSeparator(this.getSource().getSourceElement());
        if (string == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(66);
        }
        return string;
    }

    public <T> void setResolvedFlag(@NotNull Key<T> key, @Nullable T value) {
        JSResolvedTypeIdImpl id;
        if (key == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(67);
        }
        if (!(id = this.getResolvedTypeId()).isValid()) {
            return;
        }
        id.getLocalCachedValue(key, () -> value);
    }

    @NotNull
    public final Stream<JSType> getFunctionTypes(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(68);
        }
        ProgressManager.checkCanceled();
        JSType toProcess = JSTypeUtils.unwrapType(this);
        if (toProcess != this) {
            Stream stream = toProcess.getFunctionTypes(processingContext, newCallSignatures);
            if (stream == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(69);
            }
            return stream;
        }
        HashSet<JSResolvedTypeIdImpl> ids = (HashSet<JSResolvedTypeIdImpl>)processingContext.get(VISITED_TYPES);
        if (ids == null) {
            ids = new HashSet<JSResolvedTypeIdImpl>();
            processingContext.put(VISITED_TYPES, ids);
        }
        if (!ids.add(this.getResolvedTypeId())) {
            if (Holder.TEST_MODE && JSEvaluatorComplexityTracker.isAssertOnPrevention()) {
                throw new StackOverflowPreventedException("Infinite function type evaluation " + this.getTypeText());
            }
            Stream<JSType> stream = Stream.of(this);
            if (stream == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(70);
            }
            return stream;
        }
        if (this.checkAlwaysAssignableType(this, processingContext) && !(this instanceof JSUnionOrIntersectionType)) {
            Stream<JSType> stream = Stream.of(this);
            if (stream == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(71);
            }
            return stream;
        }
        JSType substitute = this.substitute();
        if (substitute instanceof JSEvaluableType) {
            Stream<JSType> stream = Stream.of(this);
            if (stream == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(72);
            }
            return stream;
        }
        if (substitute != this) {
            Stream stream = substitute.getFunctionTypes(processingContext, newCallSignatures);
            if (stream == null) {
                JSTypeBaseImpl.$$$reportNull$$$0(73);
            }
            return stream;
        }
        Stream<JSType> stream = this.getFunctionTypesImpl(processingContext, newCallSignatures);
        if (stream == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(74);
        }
        return stream;
    }

    @NotNull
    protected static ProcessingContext copyProcessingContextForFunctionTypes(@NotNull ProcessingContext context, boolean strict) {
        if (context == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(75);
        }
        ProcessingContext processingContext = new ProcessingContext();
        processingContext.put(JSTypeComparingContextService.NULL_CHECKS, (Object)strict);
        Set ids = (Set)context.get(VISITED_TYPES);
        processingContext.put(VISITED_TYPES, new HashSet(ids));
        ProcessingContext processingContext2 = processingContext;
        if (processingContext2 == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(76);
        }
        return processingContext2;
    }

    @NotNull
    protected Stream<JSType> getFunctionTypesImpl(@NotNull ProcessingContext processingContext, boolean newCallSignatures) {
        if (processingContext == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(77);
        }
        Stream<JSType> stream = Stream.empty();
        if (stream == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(78);
        }
        return stream;
    }

    @Nullable
    public <T> T getResolvedFlag(@NotNull Key<T> key) {
        JSResolvedTypeIdImpl id;
        if (key == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(79);
        }
        if (!(id = this.getResolvedTypeId()).isValid()) {
            return null;
        }
        return (T)id.getLocalCachedValue(key, () -> null);
    }

    @NotNull
    protected final JSRecordType emptyRecordType() {
        JSRecordType jSRecordType = this.isTypeScript() ? new JSRecordTypeImpl(this.getSource(), Collections.emptyList()) : JSTypeCastUtil.NO_RECORD_TYPE;
        if (jSRecordType == null) {
            JSTypeBaseImpl.$$$reportNull$$$0(80);
        }
        return jSRecordType;
    }

    public int hashCode() {
        int code = this.myHashCode;
        if (code == 0) {
            this.myHashCode = code = Objects.hash(this.hashCodeImpl(), this.getClass(), this.isSourceStrict());
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JSType) {
            return this.isEquivalentTo((JSType)obj, null, false);
        }
        return false;
    }

    public String toString() {
        return this.getTypeText();
    }

    private /* synthetic */ JSType lambda$substitute$1(JSTypeSubstitutionContext context, boolean canCacheNull) {
        JSType expanded = this.substituteAndOptimizeNoCache(context);
        if (expanded == null && canCacheNull) {
            return JSTypeBaseImpl.getNullType();
        }
        return expanded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 75: 
            case 77: 
            case 79: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 75: 
            case 77: 
            case 79: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 3: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheKey";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 68: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromCache";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 34: 
            case 35: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformation";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 59: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceLanguage";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceCondition";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createNewSource";
                break;
            }
            case 67: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelfNoTransformationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 75: 
            case 77: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalCachedType";
                break;
            }
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeText";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSource";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHelper";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypeHierarchy";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypeOrCopyWithTransformation";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "expandCodeBased";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithStrict";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "withNewSource";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordType";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "substitute";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedTypeId";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypes";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "copyProcessingContextForFunctionTypes";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionTypesImpl";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyRecordType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "assertOnRecordTypeUsage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocalCachedType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextInner";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableUnderRecursionProtection";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableTypeSimple";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkAlwaysAssignableType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calculateAssignabilityWithoutCache";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkCachedValue";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeHierarchy";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "transformTypeOrCopyWithTransformation";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkUselessCopy";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkSymmetrical";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "expandCodeBased";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "withNewSource";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "substituteAndOptimizeNoCache";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "substituteNoCache";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "optimizeTypeInSubstitute";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "replaceEmptySourceRecursive";
                break;
            }
            case 60: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "replaceSourceRecursive";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "copyWithLanguageRecursive";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "setResolvedFlag";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypes";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "copyProcessingContextForFunctionTypes";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionTypesImpl";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedFlag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 47: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 67: 
            case 68: 
            case 75: 
            case 77: 
            case 79: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected final class JSResolvedTypeIdImpl
    implements JSResolvedTypeId {
        private final long myTrackId;
        @Nullable
        private final JSResolvedTypeIdCache myCache;

        public JSResolvedTypeIdImpl(@Nullable long trackId, JSResolvedTypeIdCache cache2) {
            this.myTrackId = trackId;
            this.myCache = cache2;
        }

        public boolean isValid() {
            return this.myTrackId != -1L;
        }

        public int hashCode() {
            return JSTypeBaseImpl.this.hashCode();
        }

        @NotNull
        public JSType getOwnerType() {
            JSTypeBaseImpl jSTypeBaseImpl = JSTypeBaseImpl.this;
            if (jSTypeBaseImpl == null) {
                JSResolvedTypeIdImpl.$$$reportNull$$$0(0);
            }
            return jSTypeBaseImpl;
        }

        @Nullable
        public <T> T getLocalCachedValue(@NotNull Key<T> key, @NotNull Supplier<? extends T> supplier) {
            if (key == null) {
                JSResolvedTypeIdImpl.$$$reportNull$$$0(1);
            }
            if (supplier == null) {
                JSResolvedTypeIdImpl.$$$reportNull$$$0(2);
            }
            if (!this.isValid() || this.myCache == null) {
                return supplier.get();
            }
            return this.myCache.getLocalCachedValue(this, key, supplier);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof JSResolvedTypeId) || obj.hashCode() != this.hashCode()) {
                return false;
            }
            return JSTypeBaseImpl.this.resolvedEquals(((JSResolvedTypeId)obj).getOwnerType());
        }

        public String toString() {
            return JSTypeBaseImpl.this.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$JSResolvedTypeIdImpl";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOwnerType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeBaseImpl$JSResolvedTypeIdImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getLocalCachedValue";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class Holder {
        private static final boolean TEST_MODE = ApplicationManager.getApplication().isUnitTestMode();
        private static final JSType SELF_NO_TRANSFORMATION = new JSAnyType(JSTypeSource.SourceLanguage.JS, true){

            @Override
            public String toString() {
                return "Self type";
            }
        };
        private static final JSType NULL_TYPE = new JSAnyType(JSTypeSource.SourceLanguage.JS, true){

            @Override
            public String toString() {
                return "Null type";
            }
        };

        private Holder() {
        }
    }
}

