/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSTupleTypeImpl
extends JSCompositeTypeBaseImpl
implements JSTupleType {
    private final boolean myStrict;
    private final boolean myReadonly;
    private final int myFirstOptional;
    private final List<String> myNames;

    @Deprecated
    public JSTupleTypeImpl(JSTypeSource source, Collection<? extends JSType> _types, boolean strict, int firstOptional) {
        this(source, ContainerUtil.newArrayList(_types), Collections.emptyList(), strict, firstOptional, false);
    }

    @ApiStatus.Internal
    public JSTupleTypeImpl(JSTypeSource source, List<? extends JSType> types2, List<String> names, boolean strict, int firstOptional, boolean isReadonly) {
        super(source, types2);
        assert (names.isEmpty() || types2.size() == names.size());
        this.myNames = names;
        this.myStrict = strict;
        this.myFirstOptional = firstOptional;
        this.myReadonly = isReadonly;
    }

    JSTupleTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(0);
        }
        if (inputStream == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(1);
        }
        super(source, inputStream);
        this.myStrict = JSTypeSerializer.readBoolean(inputStream);
        this.myReadonly = JSTypeSerializer.readBoolean(inputStream);
        this.myFirstOptional = JSTypeSerializer.readInt(inputStream);
        this.myNames = JSTypeSerializer.STRING_LIST.read(source, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(2);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myStrict, outputStream);
        JSTypeSerializer.writeBoolean(this.myReadonly, outputStream);
        JSTypeSerializer.writeInt(this.myFirstOptional, outputStream);
        JSTypeSerializer.STRING_LIST.write(this.myNames, outputStream);
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        return ",";
    }

    public int getOptionalStart() {
        return this.myFirstOptional;
    }

    public int getMinLength() {
        if (this.myFirstOptional != -1) {
            return this.myFirstOptional;
        }
        List<JSType> types2 = this.getTypes();
        for (int i = types2.size() - 1; i >= 0; --i) {
            JSType type = types2.get(i);
            if (!JSTupleTypeImpl.isRest(type)) continue;
            return i;
        }
        return types2.size();
    }

    public int getMaxLength() {
        List<JSType> types2 = this.getTypes();
        if (types2.size() > 0 && types2.stream().anyMatch(el -> JSTupleTypeImpl.isVariableType(el))) {
            return Integer.MAX_VALUE;
        }
        return types2.size();
    }

    public boolean isReadonly() {
        return this.myReadonly;
    }

    @NotNull
    public List<String> getNames() {
        List<String> list2 = this.myNames;
        if (list2 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public boolean allowWidening() {
        return !this.myStrict;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(5);
        }
        if (this.isTypeScript() && this.isReadonly()) {
            builder.append("readonly ");
        }
        builder.append("[");
        super.buildTypeTextImpl(format, builder);
        builder.append("]");
    }

    @Override
    @NotNull
    protected JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(6);
        }
        List<JSType> types2 = this.getTypes();
        ArrayList<JSType> newTypes = new ArrayList<JSType>(types2.size());
        for (JSType type : types2) {
            JSTupleType tupleType;
            JSType substitute = context.substituteNested(type);
            if (substitute instanceof JSSpreadType && (tupleType = (JSTupleType)ObjectUtils.tryCast((Object)((JSSpreadType)substitute).getInnerType(), JSTupleType.class)) != null) {
                newTypes.addAll(tupleType.getTypes());
                continue;
            }
            newTypes.add(substitute);
        }
        if (ContainerUtil.equalsIdentity(types2, newTypes)) {
            JSTupleTypeImpl jSTupleTypeImpl = this;
            if (jSTupleTypeImpl == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(7);
            }
            return jSTupleTypeImpl;
        }
        JSType jSType = JSCompositeTypeFactory.createTupleType(this.getSource(), newTypes, this.myNames, this.myStrict, this.myFirstOptional, this.myReadonly);
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(8);
        }
        return jSType;
    }

    @Override
    protected void buildNestedTypePresentation(@NotNull JSType t, int index, @NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        String name;
        if (t == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(9);
        }
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(11);
        }
        String string = name = this.myNames.size() > index ? this.myNames.get(index) : null;
        if (name != null) {
            builder.append(name).append(": ");
        }
        if (format == JSType.TypeTextFormat.PRESENTABLE && t instanceof JSNullType) {
            builder.append("*");
            return;
        }
        super.buildNestedTypePresentation(t, index, format, builder);
    }

    @Override
    @NotNull
    protected String getTypeSeparatorForTypeText(@NotNull JSType.TypeTextFormat format) {
        if (format == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(12);
        }
        return ", ";
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource, boolean sourceOnly) {
        if (transformedTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(13);
        }
        if (newSource == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(14);
        }
        JSType jSType = JSCompositeTypeFactory.createTupleType(newSource, transformedTypes, this.myNames, this.myStrict, this.myFirstOptional, this.myReadonly);
        if (jSType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(15);
        }
        return jSType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(16);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(17);
        }
        if (!this.myStrict) {
            return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
        }
        if ((elementType instanceof JSTupleType || elementType instanceof JSArrayType) && this.isInferenceForNestedTypes(processingContext)) {
            return this.inferGenericsWithTupleOrArray(elementType, processingContext);
        }
        if (!(elementType instanceof JSTupleType)) {
            return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
        }
        if (!this.myReadonly && ((JSTupleType)elementType).isReadonly()) {
            return false;
        }
        List elementTypes = ((JSTupleType)elementType).getTypes();
        List<JSType> currentTypes = this.getTypes();
        int min = Math.min(elementTypes.size(), currentTypes.size());
        for (int i = 0; i < min; ++i) {
            JSType nestedElement;
            JSType nestedCurrent = currentTypes.get(i);
            if (nestedCurrent instanceof JSSpreadType) {
                nestedCurrent = ((JSSpreadType)nestedCurrent).getComponentType();
            }
            if ((nestedElement = (JSType)elementTypes.get(i)) instanceof JSSpreadType) {
                nestedElement = ((JSSpreadType)nestedElement).getComponentType();
            }
            if (nestedCurrent.isDirectlyAssignableType(nestedElement, processingContext)) continue;
            return false;
        }
        if (currentTypes.size() == elementTypes.size()) {
            JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
            JSType lastOther = (JSType)ContainerUtil.getLastItem((List)elementTypes);
            if (this.isTypeScript() && lastOther instanceof JSSpreadType && lastCurrent != null && !(lastCurrent instanceof JSSpreadType)) {
                return false;
            }
        }
        if (currentTypes.size() < elementTypes.size()) {
            JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
            if (!(lastCurrent instanceof JSSpreadType)) {
                return !this.isTypeScript();
            }
            if (currentTypes.size() - elementTypes.size() + 1 == 0 && ContainerUtil.getLastItem((List)elementTypes) instanceof JSSpreadType) {
                return true;
            }
            return !this.isTypeScript() || JSTupleTypeImpl.checkWithSpreads(processingContext, elementTypes, min, ((JSSpreadType)lastCurrent).getComponentType(), false);
        }
        if (elementTypes.size() < currentTypes.size()) {
            JSType lastItem = (JSType)ContainerUtil.getLastItem((List)elementTypes);
            if (!(lastItem instanceof JSSpreadType)) {
                return this.myFirstOptional != -1 && min >= this.myFirstOptional || elementTypes.size() - currentTypes.size() + 1 == 0 && ContainerUtil.getLastItem(currentTypes) instanceof JSSpreadType;
            }
            JSType lastCurrent = (JSType)ContainerUtil.getLastItem(currentTypes);
            if (this.isTypeScript() && lastCurrent instanceof JSSpreadType) {
                return false;
            }
            JSType componentType = ((JSSpreadType)lastItem).getComponentType();
            return JSTupleTypeImpl.checkWithSpreads(processingContext, currentTypes, min, componentType, true);
        }
        return true;
    }

    private boolean isInferenceForNestedTypes(@NotNull ProcessingContext processingContext) {
        List generics;
        JSGenericMappings mappings;
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(18);
        }
        return (mappings = JSGenericTypesEvaluator.getGenericMappings(processingContext)) != null && (generics = StreamEx.of(this.getTypes()).map(el -> el instanceof JSSpreadType ? ((JSSpreadType)el).getInnerType() : null).select(JSGenericParameterType.class).toList()).size() > 0 && generics.stream().anyMatch(el -> el.isApplying());
    }

    private static boolean areTupleTypesDefinitelyUnrelated(@NotNull JSTupleType thisType, @NotNull JSTupleType otherType) {
        if (thisType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(19);
        }
        if (otherType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(20);
        }
        if (!JSTupleTypeImpl.hasVariadic(thisType) && thisType.getMinLength() > otherType.getMinLength()) {
            return true;
        }
        if (JSTupleTypeImpl.hasRest(thisType)) {
            return !JSTupleTypeImpl.hasRest(otherType) || JSTupleTypeImpl.getFixedLength(thisType.getTypes()) < JSTupleTypeImpl.getFixedLength(otherType.getTypes());
        }
        return false;
    }

    private static boolean hasRest(@NotNull JSTupleType thisType) {
        if (thisType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(21);
        }
        for (JSType type : thisType.getTypes()) {
            if (!JSTupleTypeImpl.isRest(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasVariadic(@NotNull JSTupleType thisType) {
        if (thisType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(22);
        }
        for (JSType type : thisType.getTypes()) {
            if (!JSTupleTypeImpl.isVariadic(type)) continue;
            return true;
        }
        return false;
    }

    private boolean inferGenericsWithTupleOrArray(@NotNull JSType sourceType, @NotNull ProcessingContext processingContext) {
        int i;
        boolean targetHasVariables;
        if (sourceType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(23);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(24);
        }
        if (!(sourceType instanceof JSTupleType) && !(sourceType instanceof JSArrayType)) {
            return true;
        }
        JSTupleType sourceTuple = (JSTupleType)ObjectUtils.tryCast((Object)sourceType, JSTupleType.class);
        if (sourceTuple != null && JSTupleTypeImpl.areTupleTypesDefinitelyUnrelated(this, sourceTuple)) {
            return false;
        }
        List<JSType> targetTypes = this.getTypes();
        List sourceTypes = sourceTuple != null ? sourceTuple.getTypes() : Collections.emptyList();
        int sourceArity = sourceTypes.size();
        int targetArity = targetTypes.size();
        if (sourceTuple != null && this.isTupleTypeStructureMatching(sourceTuple)) {
            for (int i2 = 0; i2 < targetTypes.size(); ++i2) {
                JSType otherNestedType = (JSType)sourceTypes.get(i2);
                JSType thisNestedType = targetTypes.get(i2);
                if (thisNestedType.isDirectlyAssignableType(otherNestedType, processingContext)) continue;
                return false;
            }
            return true;
        }
        int sourceFixedLength = sourceTuple != null ? JSTupleTypeImpl.getFixedLength(sourceTypes) : 0;
        int targetFixedLength = JSTupleTypeImpl.getFixedLength(targetTypes);
        int startLength = Math.min(sourceFixedLength, targetFixedLength);
        JSType sourceRestComponent = sourceTuple != null ? JSTupleTypeImpl.getSourceRestType(sourceTypes, sourceArity) : ((JSArrayType)sourceType).getType();
        boolean bl = targetHasVariables = targetFixedLength != targetArity;
        int endLength = !targetHasVariables ? 0 : (sourceRestComponent != null ? JSTupleTypeImpl.getEndLengthOfType(this) : Math.min(JSTupleTypeImpl.getEndLengthOfType(this), sourceTuple != null ? JSTupleTypeImpl.getEndLengthOfType(sourceTuple) : 0));
        int sourceEndLength = sourceRestComponent != null ? 0 : endLength;
        for (i = 0; i < startLength; ++i) {
            JSType otherNestedType = (JSType)sourceTypes.get(i);
            JSType thisNestedType = targetTypes.get(i);
            if (thisNestedType.isDirectlyAssignableType(otherNestedType, processingContext)) continue;
            return false;
        }
        if (sourceRestComponent != null && sourceArity - startLength == 1) {
            for (i = startLength; i < targetArity - endLength; ++i) {
                JSType toProcess;
                JSType targetNested = targetTypes.get(i);
                JSType jSType = toProcess = JSTupleTypeImpl.isVariadic(targetNested) ? new JSArrayTypeImpl(sourceRestComponent, sourceRestComponent.getSource()) : sourceRestComponent;
                if (targetNested.isDirectlyAssignableType(toProcess, processingContext)) continue;
                return false;
            }
        } else {
            int middleLength = targetArity - startLength - endLength;
            if (middleLength == 2 && sourceTuple != null) {
                if (targetArity > startLength + 1) {
                    JSType startType0 = targetTypes.get(startLength);
                    JSType startType1 = targetTypes.get(startLength + 1);
                    if (JSTupleTypeImpl.isVariadic(startType1) && JSTupleTypeImpl.isVariadic(startType0)) {
                        JSType innerType0 = ((JSSpreadType)startType0).getInnerType();
                        JSType innerType1 = ((JSSpreadType)startType1).getInnerType();
                        int arity = JSGenericTypesEvaluator.getImpliedArity(innerType0, processingContext);
                        if (arity != -1) {
                            JSType first = this.sliceTupleType(sourceTuple, startLength, sourceEndLength + sourceArity - arity);
                            if (!innerType0.isDirectlyAssignableType(first, processingContext)) {
                                return false;
                            }
                            JSType second = this.sliceTupleType(sourceTuple, startLength + arity, sourceEndLength);
                            if (!innerType1.isDirectlyAssignableType(second, processingContext)) {
                                return false;
                            }
                        }
                    }
                }
            } else if (middleLength == 1 && targetArity > startLength) {
                JSType type = targetTypes.get(startLength);
                if (JSTupleTypeImpl.isVariadic(type)) {
                    JSType sourceSlice = sourceTuple != null ? this.sliceTupleType(sourceTuple, startLength, sourceEndLength) : sourceType;
                    JSType innerType = ((JSSpreadType)type).getInnerType();
                    if (!innerType.isDirectlyAssignableType(sourceSlice, processingContext)) {
                        return false;
                    }
                } else if (JSTupleTypeImpl.isRest(type)) {
                    JSType nestedType = sourceRestComponent;
                    if (nestedType == null && sourceTuple != null) {
                        JSType arrayType;
                        JSType arrayOrTuple = this.sliceTupleType(sourceTuple, startLength, sourceEndLength);
                        JSType jSType = arrayType = arrayOrTuple instanceof JSTupleType ? ((JSTupleType)arrayOrTuple).toArrayType(false) : arrayOrTuple;
                        if (arrayType instanceof JSArrayType) {
                            nestedType = ((JSArrayType)arrayType).getType();
                        }
                    }
                    if (nestedType != null && !type.isDirectlyAssignableType(nestedType, processingContext)) {
                        return false;
                    }
                }
            }
        }
        for (i = 0; i < endLength; ++i) {
            JSType sourceNestedType = sourceRestComponent != null || sourceTuple == null ? sourceRestComponent : (JSType)sourceTypes.get(sourceArity - i - 1);
            JSType targetNestedType = targetTypes.get(targetArity - i - 1);
            if (targetNestedType.isDirectlyAssignableType(sourceNestedType, processingContext)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private JSType sliceTupleType(@NotNull JSTupleType type, int index, int endSkipCount) {
        if (type == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(25);
        }
        List types2 = type.getTypes();
        List<String> names = type.getNames();
        int endIndex = endSkipCount > 0 ? types2.size() - endSkipCount : types2.size();
        JSTypeSource source = this.getSource();
        if (index > JSTupleTypeImpl.getFixedLength(types2)) {
            JSType last = (JSType)ContainerUtil.getLastItem((List)types2);
            if (JSTupleTypeImpl.isRest(last)) {
                JSSpreadType spread = (JSSpreadType)last;
                JSType jSType = spread.getInnerType();
                if (jSType == null) {
                    JSTupleTypeImpl.$$$reportNull$$$0(26);
                }
                return jSType;
            }
            return new JSArrayTypeImpl(JSAnyType.get(source), source);
        }
        List newTypes = types2.subList(index, endIndex);
        List<String> newNames = names.size() > 0 ? names.subList(index, endIndex) : names;
        return new JSTupleTypeImpl(source, newTypes, newNames, !this.allowWidening(), this.myFirstOptional < newTypes.size() ? this.myFirstOptional : -1, this.isReadonly());
    }

    @Nullable
    private static JSType getSourceRestType(@NotNull List<JSType> sourceTypes, int sourceArity) {
        if (sourceTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(27);
        }
        if (sourceArity > 0 && JSTupleTypeImpl.isRest(sourceTypes.get(sourceArity - 1))) {
            JSSpreadType type = (JSSpreadType)ObjectUtils.tryCast((Object)sourceTypes.get(sourceArity - 1), JSSpreadType.class);
            return type != null ? type.getComponentType() : null;
        }
        return null;
    }

    private static int getEndLengthOfType(@NotNull JSTupleType type) {
        if (type == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(28);
        }
        List types2 = type.getTypes();
        int arity = types2.size();
        for (int i = types2.size() - 1; i >= 0; --i) {
            if (!JSTupleTypeImpl.isVariableType((JSType)types2.get(i))) continue;
            return arity - i - 1;
        }
        return types2.size();
    }

    private static int getFixedLength(@NotNull List<JSType> types2) {
        if (types2 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(29);
        }
        int size = types2.size();
        for (int i = 0; i < size; ++i) {
            if (!JSTupleTypeImpl.isVariableType(types2.get(i))) continue;
            return i;
        }
        return types2.size();
    }

    private boolean isTupleTypeStructureMatching(@NotNull JSTupleType elementType) {
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(30);
        }
        List<JSType> ownTypes = this.getTypes();
        List otherTypes = elementType.getTypes();
        if (ownTypes.size() != otherTypes.size()) {
            return false;
        }
        for (int i = 0; i < ownTypes.size(); ++i) {
            JSType otherNestedType = (JSType)otherTypes.get(i);
            JSType thisNestedType = ownTypes.get(i);
            if (JSTupleTypeImpl.isVariableType(otherNestedType) == JSTupleTypeImpl.isVariableType(thisNestedType)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkWithSpreads(@NotNull ProcessingContext processingContext, @NotNull List<JSType> currentTypes, int min, @NotNull JSType componentType, boolean forward) {
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(31);
        }
        if (currentTypes == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(32);
        }
        if (componentType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(33);
        }
        for (int i = min; i < currentTypes.size(); ++i) {
            JSType type = currentTypes.get(i);
            if (type instanceof JSSpreadType) {
                type = ((JSSpreadType)type).getComponentType();
            }
            if ((forward ? type : componentType).isDirectlyAssignableType(forward ? componentType : type, processingContext)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public JSType getTypeByIndex(int index) {
        JSType type;
        if (index < 0) {
            return null;
        }
        List<JSType> types2 = this.getTypes();
        int lastIndex = types2.size() - 1;
        if (index <= lastIndex) {
            JSType type2 = types2.get(index);
            if (index == lastIndex && type2 instanceof JSSpreadType) {
                return ((JSSpreadType)type2).getComponentType();
            }
            return type2;
        }
        if (lastIndex >= 0 && (type = types2.get(lastIndex)) instanceof JSSpreadType) {
            return ((JSSpreadType)type).getComponentType();
        }
        return null;
    }

    private static boolean isVariableType(@NotNull JSType candidate) {
        if (candidate == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(34);
        }
        return candidate instanceof JSSpreadType;
    }

    public static boolean isRest(@NotNull JSType candidate) {
        if (candidate == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(35);
        }
        if (!(candidate instanceof JSSpreadType)) {
            return false;
        }
        return ((JSSpreadType)candidate).isRest();
    }

    private static boolean isVariadic(@NotNull JSType candidate) {
        if (candidate == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(36);
        }
        if (!(candidate instanceof JSSpreadType)) {
            return false;
        }
        return ((JSSpreadType)candidate).isVariadic();
    }

    @Nullable
    public String getNameByIndex(int index) {
        if (this.myNames.size() > index) {
            return this.myNames.get(index);
        }
        return null;
    }

    public boolean hasTypeByIndex(int index) {
        if (index < 0) {
            return false;
        }
        List<JSType> types2 = this.getTypes();
        int lastIndex = types2.size() - 1;
        if (index <= lastIndex) {
            return true;
        }
        if (lastIndex >= 0) {
            return types2.get(lastIndex) instanceof JSSpreadType;
        }
        return false;
    }

    @Nullable
    public JSType excludePrefix(int length) {
        if (length <= 0) {
            return this;
        }
        List<JSType> types2 = this.getTypes();
        int lastIndex = types2.size() - 1;
        if (length > lastIndex) {
            JSType lastType;
            if (lastIndex >= 0 && (lastType = types2.get(lastIndex)) instanceof JSSpreadType) {
                return JSCompositeTypeFactory.createTupleType(this.getSource(), ContainerUtil.createMaybeSingletonList((Object)lastType), this.myStrict, -1, this.myReadonly);
            }
            return null;
        }
        List<JSType> newTypes = types2.subList(length, types2.size());
        return JSCompositeTypeFactory.createTupleType(this.getSource(), newTypes, this.myStrict, this.myFirstOptional == -1 || this.myFirstOptional + length >= newTypes.size() ? -1 : this.myFirstOptional + length, this.myReadonly);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (elementType == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(37);
        }
        if (processingContext == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(38);
        }
        if ((assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(39);
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.toArrayType(true).isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(40);
        }
        return assignableResult3;
    }

    @NotNull
    public final JSType toArrayType(boolean allowResolve) {
        return this.toArrayImpl(allowResolve);
    }

    @NotNull
    private JSType toArrayImpl(boolean allowResolve) {
        JSTypeSource source = this.getSource();
        List<JSType> types2 = this.getTypes();
        List providers = ContainerUtil.map(types2, el -> () -> el instanceof JSSpreadType ? ((JSSpreadType)el).getComponentType() : el);
        JSType commonType = JSTypeUtils.getCommonType(providers, source.getSourceElement(), allowResolve);
        if (commonType instanceof JSNullType || !this.isTypeScript() && commonType instanceof TypeScriptNeverJSTypeImpl) {
            commonType = JSAnyType.get(source.getSourceElement(), false);
        }
        return this.myReadonly ? new JSReadonlyArrayTypeImpl(commonType, source) : new JSArrayTypeImpl(commonType, source);
    }

    @Override
    protected boolean useCacheForRecordType() {
        return true;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType parent = this.toArrayImpl(true).asRecordType();
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> members = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>(parent.getTypeMembers());
        List<JSType> types2 = this.getTypes();
        for (int i = 0; i < types2.size(); ++i) {
            members.add(new JSRecordTypeImpl.PropertySignatureImpl(String.valueOf(i), types2.get(i), false, false));
        }
        return new JSRecordTypeImpl(parent.getSource(), members);
    }

    public JSQualifiedName getQualifiedName() {
        return JSQualifiedNameImpl.create("Array", null);
    }

    public boolean hasQualifiedName() {
        return true;
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(super.hashCodeImpl(), this.myStrict, this.myFirstOptional, this.myReadonly);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(41);
        }
        return super.isEquivalentToWithSameClass(type, processingContext, allowResolve) && this.myReadonly == ((JSTupleTypeImpl)type).myReadonly && this.myStrict == ((JSTupleTypeImpl)type).myStrict && this.myFirstOptional == ((JSTupleTypeImpl)type).myFirstOptional;
    }

    @NotNull
    public String getDefaultValue() {
        StringBuilder type = new StringBuilder("[");
        List<JSType> types2 = this.getTypes();
        int size = types2.size();
        int i = 0;
        for (JSType jsType : types2) {
            type.append(JSTypeUtils.defaultValueOfType(jsType));
            if (i < size - 1) {
                type.append(",");
            }
            ++i;
        }
        String string = type.append("]").toString();
        if (string == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(42);
        }
        return string;
    }

    @Override
    protected boolean preserveInnerTypes() {
        return true;
    }

    @NotNull
    public final JSTupleType transformTypes(@NotNull BiFunction<? super JSType, Long, JSType> converter) {
        if (converter == null) {
            JSTupleTypeImpl.$$$reportNull$$$0(43);
        }
        List<JSType> originalTypes = this.getTypes();
        ArrayList<JSType> result2 = new ArrayList<JSType>(originalTypes.size());
        for (int i = 0; i < originalTypes.size(); ++i) {
            result2.add(converter.apply((JSType)originalTypes.get(i), Long.valueOf(i)));
        }
        if (ContainerUtil.equalsIdentity(result2, originalTypes)) {
            JSTupleTypeImpl jSTupleTypeImpl = this;
            if (jSTupleTypeImpl == null) {
                JSTupleTypeImpl.$$$reportNull$$$0(44);
            }
            return jSTupleTypeImpl;
        }
        return new JSTupleTypeImpl(this.getSource(), result2, this.myNames, this.myStrict, this.myFirstOptional, this.myReadonly);
    }

    public int getFirstOptional() {
        return this.myFirstOptional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 15: 
            case 26: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 15: 
            case 26: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 15: 
            case 26: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 4: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 16: 
            case 30: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 17: 
            case 18: 
            case 24: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceType";
                break;
            }
            case 25: 
            case 28: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceTypes";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTypes";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTupleTypeImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "sliceTupleType";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "transformTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 15: 
            case 26: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildNestedTypePresentation";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSeparatorForTypeText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isInferenceForNestedTypes";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "areTupleTypesDefinitelyUnrelated";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "hasRest";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasVariadic";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericsWithTupleOrArray";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "sliceTupleType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getSourceRestType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getEndLengthOfType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getFixedLength";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isTupleTypeStructureMatching";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "checkWithSpreads";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isVariableType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isRest";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isVariadic";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "transformTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 15: 
            case 26: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

