/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.JSTypedEntity;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.resolve.processors.JSModuleElementsResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSModuleTypeImpl
extends JSEvaluableOnlyTypeBase
implements JSEvaluableOnlyType,
JSType.CompositeStructure,
JSTypeWithIncompleteSubstitution,
JSPropertiesOwnerType {
    private final boolean myIsFromRequire;

    public JSModuleTypeImpl(@NotNull JSFile file2, boolean isFromRequire) {
        if (file2 == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(0);
        }
        this(JSTypeSourceFactory.createTypeSource((PsiElement)file2, true), isFromRequire);
    }

    public JSModuleTypeImpl(@NotNull JSEmbeddedContent embeddedContent, boolean isFromRequire) {
        if (embeddedContent == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(1);
        }
        this(JSTypeSourceFactory.createTypeSource((PsiElement)embeddedContent, true), isFromRequire);
    }

    private JSModuleTypeImpl(@NotNull JSTypeSource source, boolean isFromRequire) {
        if (source == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myIsFromRequire = isFromRequire;
    }

    public JSModuleTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(4);
        }
        super(source);
        PsiElement module = source.getSourceElement();
        if (!(module instanceof JSFile) && !ES6PsiUtil.isEmbeddedModule(module)) {
            throw new IllegalStateException("Source element must be a JSFile or an embedded module: " + module);
        }
        this.myIsFromRequire = JSTypeSerializer.readBoolean(inputStream);
    }

    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(5);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myIsFromRequire, outputStream);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(6);
        }
        return new JSModuleTypeImpl(source, this.myIsFromRequire);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(7);
        }
        return Objects.equals(this.getSourceElement(), type.getSourceElement()) && this.myIsFromRequire == ((JSModuleTypeImpl)type).myIsFromRequire;
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.getSourceElement(), this.myIsFromRequire);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(9);
        }
        if (format == JSType.TypeTextFormat.SIMPLE) {
            builder.append("modt()");
            return;
        }
        JSType evaluatedType = this.substitute();
        if (evaluatedType != this) {
            evaluatedType.buildTypeText(format, builder);
        } else {
            builder.append("any");
        }
    }

    @NotNull
    public JSType substituteCompletely() {
        JSType jSType = this.substitute();
        if (jSType == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(10);
        }
        return jSType;
    }

    @Override
    @NotNull
    public JSEvaluationTask evaluate(@NotNull JSEvaluateContext evaluateContext) {
        JSSimpleRecordTypeImpl recordType;
        if (evaluateContext == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(11);
        }
        ArrayList<JSEvaluationTask> tasks = new ArrayList<JSEvaluationTask>(3);
        JSExecutionScope module = this.getModule();
        List<PsiElement> exportedElements = Collections.unmodifiableList(JSResolveUtil.getExportedElements(module));
        if (!exportedElements.isEmpty()) {
            JSEvaluationTask task = this.addTypeFromExportedElements(exportedElements, evaluateContext);
            if (exportedElements.size() == 1 && exportedElements.get(0) instanceof TypeScriptExportAssignment) {
                JSEvaluationTask jSEvaluationTask = task;
                if (jSEvaluationTask == null) {
                    JSModuleTypeImpl.$$$reportNull$$$0(12);
                }
                return jSEvaluationTask;
            }
            tasks.add(task);
        }
        boolean processDefaultExportForLegacyCompatibility = this.myIsFromRequire;
        if (this.myIsFromRequire) {
            boolean bl = processDefaultExportForLegacyCompatibility = !(module instanceof JSFile) || ((JSFile)module).getModuleStatus() == JSFile.ModuleStatus.ES6;
        }
        if (processDefaultExportForLegacyCompatibility) {
            JSElement defaultExport = ES6PsiUtil.findDefaultExport((PsiElement)module);
            if (defaultExport instanceof ES6ExportDefaultAssignment) {
                exportedElements = Collections.unmodifiableList(JSModuleTypeImpl.resolveExportAssignmentLocally((JSExportAssignment)defaultExport));
            } else if (defaultExport != null) {
                exportedElements = Collections.singletonList(defaultExport);
            }
            tasks.add(this.addTypeFromExportedElements(exportedElements, evaluateContext));
        }
        tasks.add((recordType = JSModuleTypeImpl.getRecordTypeFromModuleExports(module)) != null ? JSEvaluationResultElement.fromType(recordType, evaluateContext) : JSModuleTypeImpl.getTaskForUnknownElement((PsiElement)module, evaluateContext));
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(tasks);
        if (jSEvaluationTask == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(13);
        }
        return jSEvaluationTask;
    }

    @Override
    public boolean matchesSourceElement() {
        return false;
    }

    @NotNull
    public JSExecutionScope getModule() {
        JSExecutionScope jSExecutionScope = (JSExecutionScope)Objects.requireNonNull(this.getSource().getSourceElement());
        if (jSExecutionScope == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(14);
        }
        return jSExecutionScope;
    }

    public boolean isFromRequire() {
        return this.myIsFromRequire;
    }

    @NotNull
    private JSEvaluationTask addTypeFromExportedElements(@NotNull Collection<PsiElement> exportedElements, @NotNull JSEvaluateContext context) {
        if (exportedElements == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(15);
        }
        if (context == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(16);
        }
        List tasks = ContainerUtil.map(exportedElements, e -> JSEvaluationResultElement.fromType(JSCodeBasedTypeFactory.getPsiBasedType(e, context), context));
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromSet(tasks, this.isJavaScript());
        if (jSEvaluationTask == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(17);
        }
        return jSEvaluationTask;
    }

    @Nullable
    private static JSSimpleRecordTypeImpl getRecordTypeFromModuleExports(@NotNull JSExecutionScope module) {
        if (module == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(18);
        }
        return (JSSimpleRecordTypeImpl)CachedValuesManager.getCachedValue((PsiElement)module, () -> CachedValueProvider.Result.create((Object)JSModuleTypeImpl.buildRecordTypeFromModuleExports(module), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    @NotNull
    private static JSSimpleRecordTypeImpl buildRecordTypeFromModuleExports(@NotNull JSExecutionScope module) {
        PsiElement aliased;
        if (module == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(19);
        }
        final ArrayList exportedMembers = new ArrayList();
        PsiScopeProcessor collectingProcessor = new PsiScopeProcessor(){

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                exportedMembers.add(element);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/types/JSModuleTypeImpl$1";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)module);
        JSModuleElementsResolveProcessor exportedMembersProcessor = new JSModuleElementsResolveProcessor(isTypeScript ? new ES6PsiUtil.ES6ExportedElementsProcessor(collectingProcessor) : collectingProcessor);
        ES6PsiUtil.processExportDeclarationInScope((JSElement)module, exportedMembersProcessor);
        boolean isOptional = !isTypeScript;
        ArrayList<JSRecordTypeImpl.PropertySignatureImpl> typeMembers = new ArrayList<JSRecordTypeImpl.PropertySignatureImpl>();
        for (PsiElement member : exportedMembers) {
            JSPsiNamedElementBase named = member instanceof JSPsiNamedElementBase ? (JSPsiNamedElementBase)member : null;
            if (named == null || StringUtil.isEmpty((String)named.getName())) continue;
            typeMembers.add(new JSRecordTypeImpl.PropertySignatureImpl(named.getName(), JSTypeUtils.getTypeOfElement((PsiElement)named), isOptional, false, (PsiElement)named));
        }
        JSElement defaultExport = ES6PsiUtil.findDefaultExport((PsiElement)module);
        if (defaultExport instanceof JSExportAssignment) {
            JSType type = ((JSExportAssignment)defaultExport).getJSType();
            typeMembers.add((JSRecordTypeImpl.PropertySignatureImpl)JSModuleTypeImpl.getDefaultPropertyFromExportedElement(defaultExport, type, isOptional));
        } else if (defaultExport instanceof ES6ExportSpecifierAlias && (aliased = ((ES6ExportSpecifierAlias)defaultExport).findAliasedElement()) != null) {
            JSType type = aliased instanceof JSTypeOwner ? ((JSTypeOwner)aliased).getJSType() : (aliased instanceof JSTypedEntity ? ((JSTypedEntity)aliased).getJSType() : new JSPsiBasedTypeOfType(aliased, false));
            typeMembers.add((JSRecordTypeImpl.PropertySignatureImpl)JSModuleTypeImpl.getDefaultPropertyFromExportedElement((JSElement)aliased, type, isOptional));
        }
        return new JSSimpleRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)module, true), typeMembers);
    }

    @NotNull
    private static JSRecordType.TypeMember getDefaultPropertyFromExportedElement(@NotNull JSElement exported, @Nullable JSType type, boolean isOptional) {
        if (exported == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(20);
        }
        return new JSRecordTypeImpl.PropertySignatureImpl("default", type, isOptional, true, (PsiElement)exported);
    }

    @NotNull
    private static List<PsiElement> resolveExportAssignmentLocally(@NotNull JSExportAssignment defaultExport) {
        String reference;
        if (defaultExport == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(21);
        }
        if ((reference = defaultExport.getInitializerReference()) != null) {
            List<PsiElement> list2 = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(reference, (PsiElement)defaultExport);
            if (list2 == null) {
                JSModuleTypeImpl.$$$reportNull$$$0(22);
            }
            return list2;
        }
        JSElement element = defaultExport.getStubSafeElement();
        if (element != null) {
            List<JSElement> list3 = Collections.singletonList(element);
            if (list3 == null) {
                JSModuleTypeImpl.$$$reportNull$$$0(23);
            }
            return list3;
        }
        List<PsiElement> list4 = Collections.emptyList();
        if (list4 == null) {
            JSModuleTypeImpl.$$$reportNull$$$0(24);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "embeddedContent";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSModuleTypeImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportedElements";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exported";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultExport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSModuleTypeImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addTypeFromExportedElements";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveExportAssignmentLocally";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExportedElements";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRecordTypeFromModuleExports";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "buildRecordTypeFromModuleExports";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPropertyFromExportedElement";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "resolveExportAssignmentLocally";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

