/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSKeyofType;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSReadonlyArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTemplateLiteralType;
import com.intellij.lang.javascript.psi.types.JSTupleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.TypeScriptAwaitedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptIndexedAccessJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptMappedJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptObjectJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeOperatorJSTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.AbstractStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSCompositeTypeFactory {
    private static final Set<Class<? extends JSType>> PRIMITIVES = ContainerUtil.immutableSet((Object[])new Class[]{JSStringType.class, JSNumberType.class, JSBooleanType.class, JSBigIntType.class});
    private static final Set<Class<? extends JSType>> IMPOSSIBLE_COMBINATIONS = ContainerUtil.immutableSet((Object[])new Class[]{JSNullType.class, JSUndefinedType.class, JSStringType.class, JSNumberType.class, JSBooleanType.class, JSBigIntType.class, JSSymbolType.class, TypeScriptObjectJSTypeImpl.class, JSVoidType.class});

    @NotNull
    public static JSType createIntersectionType(@NotNull Collection<? extends JSType> types2, @NotNull JSTypeSource source) {
        if (types2 == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(1);
        }
        return JSCompositeTypeFactory.createIntersectionType(types2, source, false);
    }

    @NotNull
    public static JSType createIntersectionType(@NotNull Collection<? extends JSType> types2, @NotNull JSTypeSource source, boolean allowResolve) {
        Collection<? extends JSType> resultTypes;
        if (types2 == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(2);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(3);
        }
        if ((resultTypes = JSCompositeTypeFactory.optimizeIntersectionTypes(types2, source, allowResolve, true)).size() == 0) {
            JSUnknownType jSUnknownType = source.isTypeScript() ? JSUnknownType.TS_INSTANCE : JSUnknownType.JS_INSTANCE;
            if (jSUnknownType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(4);
            }
            return jSUnknownType;
        }
        if (resultTypes.size() == 1) {
            JSType jSType = resultTypes.iterator().next();
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        return new JSIntersectionTypeImpl(source, JSCompositeTypeBaseImpl.flattenTypes(resultTypes.stream(), JSIntersectionType.class));
    }

    @NotNull
    public static JSType createContextualUnionType(@NotNull Collection<? extends JSType> types2, @NotNull JSTypeSource source) {
        JSType result2;
        if (types2 == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(6);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(7);
        }
        if ((result2 = JSCompositeTypeFactory.getContextualForCallSignatures(types2, source)) != null) {
            JSType jSType = result2;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(8);
            }
            return jSType;
        }
        Collection<? extends JSType> results = JSCompositeTypeFactory.optimizeIntersectionTypes(types2, source, true, false);
        if (results.size() == 0) {
            JSAnyType jSAnyType = JSAnyType.get(source);
            if (jSAnyType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(9);
            }
            return jSAnyType;
        }
        if (results.size() == 1) {
            JSType jSType = results.iterator().next();
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(10);
            }
            return jSType;
        }
        return new JSContextualUnionTypeImpl(source, JSCompositeTypeBaseImpl.flattenTypes(results.stream(), JSContextualUnionTypeImpl.class));
    }

    @NotNull
    public static JSType createTupleType(@NotNull JSTypeSource source, @NotNull List<? extends JSType> _types, boolean strict, int firstOptional, boolean isReadonly) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(11);
        }
        if (_types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(12);
        }
        return JSCompositeTypeFactory.createTupleType(source, _types, Collections.emptyList(), strict, firstOptional, isReadonly);
    }

    @NotNull
    public static JSType createTupleType(@NotNull JSTypeSource source, @NotNull List<? extends JSType> _types, @NotNull List<String> names, boolean strict, int firstOptional, boolean isReadonly) {
        JSType singleType;
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(13);
        }
        if (_types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(14);
        }
        if (names == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(15);
        }
        if (_types.size() == 1 && (singleType = _types.iterator().next()) instanceof JSSpreadType && ((JSSpreadType)singleType).isRest()) {
            JSType componentType = ((JSSpreadType)singleType).getComponentType();
            if (!isReadonly) {
                return new JSArrayTypeImpl(componentType, source);
            }
            return new JSReadonlyArrayTypeImpl(componentType, source);
        }
        return new JSTupleTypeImpl(source, _types, names, strict, firstOptional, isReadonly);
    }

    @NotNull
    public static JSType createUnionType(@NotNull JSTypeSource source, @NotNull Collection<? extends JSType> _types) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(16);
        }
        if (_types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(17);
        }
        if (_types.size() == 0) {
            return new TypeScriptNeverJSTypeImpl(source);
        }
        if (_types.size() == 1) {
            JSType jSType = _types.iterator().next();
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(18);
            }
            return jSType;
        }
        List<JSType> flattenedTypes = JSCompositeTypeBaseImpl.flattenTypes(JSCompositeTypeFactory.collapseTypesForUnion(_types, source.isJavaScript()), JSUnionType.class);
        if (flattenedTypes.size() == 0) {
            return new TypeScriptNeverJSTypeImpl(source);
        }
        if (flattenedTypes.size() == 1) {
            JSType jSType = flattenedTypes.iterator().next();
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(19);
            }
            return jSType;
        }
        return new JSCompositeTypeImpl(source, flattenedTypes);
    }

    @NotNull
    public static Stream<? extends JSType> collapseTypesForUnion(@NotNull Collection<? extends JSType> _types, boolean isJavaScript) {
        if (_types == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(20);
        }
        boolean hasBoolean = false;
        boolean hasTrueValue = false;
        boolean hasFalseValue = false;
        for (JSType jSType : _types) {
            if (jSType instanceof JSAnyType && !isJavaScript && !(jSType instanceof JSUnknownType)) {
                Stream<JSType> stream = Stream.of(jSType);
                if (stream == null) {
                    JSCompositeTypeFactory.$$$reportNull$$$0(21);
                }
                return stream;
            }
            if (jSType instanceof JSBooleanLiteralTypeImpl) {
                if (((JSBooleanLiteralTypeImpl)jSType).allowWidening()) continue;
                boolean literal = ((JSBooleanLiteralTypeImpl)jSType).getLiteral();
                hasTrueValue |= literal == Boolean.TRUE;
                hasFalseValue |= literal == Boolean.FALSE;
                continue;
            }
            if (!(jSType instanceof JSBooleanType)) continue;
            hasBoolean = true;
        }
        if (hasBoolean) {
            Stream<JSType> stream = _types.stream().filter(t -> !(t instanceof JSBooleanLiteralTypeImpl) && !(t instanceof TypeScriptNeverJSTypeImpl));
            if (stream == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(22);
            }
            return stream;
        }
        if (!hasTrueValue || !hasFalseValue) {
            Stream<JSType> stream = _types.stream().filter(t -> !(t instanceof TypeScriptNeverJSTypeImpl));
            if (stream == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(23);
            }
            return stream;
        }
        JSBooleanType type = new JSBooleanType(true, _types.iterator().next().getSource(), JSTypeContext.INSTANCE);
        AbstractStreamEx abstractStreamEx = StreamEx.of((Object)type).append(_types).filter(t -> !(t instanceof JSBooleanLiteralTypeImpl) && !(t instanceof TypeScriptNeverJSTypeImpl));
        if (abstractStreamEx == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(24);
        }
        return abstractStreamEx;
    }

    public static JSType createUnionType(@NotNull JSTypeSource source, JSType ... _types) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(25);
        }
        return JSCompositeTypeFactory.createUnionType(source, Arrays.asList(_types));
    }

    @NotNull
    static Collection<? extends JSType> optimizeIntersectionTypes(@NotNull Collection<? extends JSType> types2, @NotNull JSTypeSource source, boolean allowResolve, boolean asIntersection) {
        JSType simplifiedType;
        Collection<? extends JSType> plainTypes;
        if (types2 == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(26);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(27);
        }
        if ((plainTypes = JSCompositeTypeImpl.flattenAndDeduplicate(types2, Collections.emptySet(), allowResolve ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE : JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE, !asIntersection, null)).size() == 0) {
            List<? extends JSType> list2 = plainTypes;
            if (list2 == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(28);
            }
            return list2;
        }
        if (plainTypes.size() == 1) {
            List<? extends JSType> list3 = plainTypes;
            if (list3 == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(29);
            }
            return list3;
        }
        if (asIntersection && JSCompositeTypeFactory.hasAnyType(plainTypes)) {
            JSType item = (JSType)ContainerUtil.getFirstItem(plainTypes);
            assert (item != null);
            List<JSAnyType> list4 = Collections.singletonList(JSAnyType.get(source));
            if (list4 == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(30);
            }
            return list4;
        }
        if (asIntersection) {
            plainTypes = JSCompositeTypeFactory.collapseWithLiterals(plainTypes);
        }
        if ((simplifiedType = JSCompositeTypeFactory.normalizeIfPossible(plainTypes, source, allowResolve, asIntersection)) != null) {
            List<JSType> list5 = Collections.singletonList(simplifiedType);
            if (list5 == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(31);
            }
            return list5;
        }
        Collection<? extends JSType> collection = plainTypes;
        if (collection == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(32);
        }
        return collection;
    }

    @Nullable
    static JSType normalizeIfPossible(@NotNull Collection<? extends JSType> plainTypes, @NotNull JSTypeSource source, boolean allowResolve, boolean intersection) {
        if (plainTypes == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(33);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(34);
        }
        ProgressManager.checkCanceled();
        if (!intersection) {
            return null;
        }
        JSType impossibleType = JSCompositeTypeFactory.getTypeForImpossibleTypeCombination(plainTypes, source, allowResolve);
        if (impossibleType != null) {
            return impossibleType;
        }
        int i = -1;
        for (JSType jSType : plainTypes) {
            ++i;
            if (!(jSType instanceof JSUnionType)) continue;
            List<JSType> parts = ((JSUnionType)jSType).getTypes();
            ArrayList<JSType> newParts = new ArrayList<JSType>(parts.size());
            ArrayList<? extends JSType> typesCopy = new ArrayList<JSType>(plainTypes);
            for (JSType part : parts) {
                ProgressManager.checkCanceled();
                typesCopy.set(i, (JSType)part);
                newParts.add(JSCompositeTypeFactory.createIntersectionType(typesCopy, source, allowResolve));
            }
            return JSCompositeTypeFactory.createUnionType(source, newParts);
        }
        return null;
    }

    @NotNull
    private static Collection<? extends JSType> collapseWithLiterals(@NotNull Collection<? extends JSType> types2) {
        if (types2 == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(35);
        }
        @NotNull MultiMap primitives = MultiMap.createSet();
        HashSet primitiveLiterals = new HashSet();
        for (JSType jSType : types2) {
            if (PRIMITIVES.contains(jSType.getClass())) {
                primitives.putValue(jSType.getClass(), (Object)jSType);
            }
            if (!(jSType instanceof JSPrimitiveLiteralType) || ((JSPrimitiveLiteralType)jSType).allowWidening()) continue;
            primitiveLiterals.add(((JSPrimitiveLiteralType)jSType).asPrimitiveType().getClass());
        }
        if (primitiveLiterals.isEmpty() || primitives.isEmpty()) {
            Collection<? extends JSType> collection = types2;
            if (collection == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(36);
            }
            return collection;
        }
        boolean hasModifications = false;
        ArrayList<? extends JSType> arrayList = new ArrayList<JSType>(types2);
        for (Class clazz : primitiveLiterals) {
            if (!primitives.containsKey((Object)clazz)) continue;
            arrayList.removeAll(primitives.get((Object)clazz));
            hasModifications = true;
        }
        Collection<? extends JSType> collection = hasModifications ? arrayList : types2;
        if (collection == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(37);
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static JSType getTypeForImpossibleTypeCombination(@NotNull Collection<? extends JSType> plainTypes, @NotNull JSTypeSource source, boolean allowResolve) {
        if (plainTypes == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(38);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(39);
        }
        HashSet primitives = new HashSet();
        boolean hasNull = false;
        boolean hasUndefined = false;
        boolean hasPrimitive = false;
        boolean isStrictNullChecks = allowResolve && TypeScriptConfigUtil.strictNullChecks(source.getSourceElement());
        boolean hasNonObjectTypes = false;
        HashSet literalValues = new HashSet();
        for (JSType jSType : plainTypes) {
            void var11_11;
            Class<?> typeClass;
            if (jSType instanceof JSPrimitiveLiteralType && !((JSPrimitiveLiteralType)jSType).allowWidening()) {
                Object literal = ((JSPrimitiveLiteralType)jSType).getLiteral();
                boolean isEmpty = literalValues.isEmpty();
                boolean added = literalValues.add(literal);
                if (!isEmpty && added) {
                    return new TypeScriptNeverJSTypeImpl(source);
                }
            }
            if (jSType instanceof JSNullType) {
                hasNull = true;
            } else if (jSType instanceof JSUndefinedType) {
                hasUndefined = true;
            } else {
                hasNonObjectTypes |= !(jSType instanceof JSRecordType);
            }
            if (jSType instanceof JSPrimitiveType) {
                hasPrimitive = true;
            }
            if ((hasNull || hasUndefined) && hasPrimitive) {
                return new TypeScriptNeverJSTypeImpl(source);
            }
            if (jSType instanceof JSPrimitiveType && !((JSPrimitiveType)jSType).isPrimitive()) continue;
            if (jSType instanceof JSLiteralType) {
                JSType jSType2 = ((JSLiteralType)jSType).asPrimitiveType();
            }
            if (IMPOSSIBLE_COMBINATIONS.contains(typeClass = var11_11.getClass())) {
                primitives.add(typeClass);
            }
            if (primitives.size() <= 1) continue;
            return new TypeScriptNeverJSTypeImpl(source);
        }
        if (!allowResolve) {
            return null;
        }
        if (hasNull && !hasNonObjectTypes) {
            return isStrictNullChecks ? new TypeScriptNeverJSTypeImpl(source) : new JSNullType(source);
        }
        if (hasUndefined && !hasNonObjectTypes) {
            return isStrictNullChecks ? new TypeScriptNeverJSTypeImpl(source) : new JSUndefinedType(source);
        }
        return null;
    }

    private static boolean hasAnyType(@NotNull Collection<? extends JSType> types2) {
        if (types2 == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(40);
        }
        for (JSType jSType : types2) {
            if (!(jSType instanceof JSAnyType)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static JSType getContextualForCallSignatures(@NotNull Collection<? extends JSType> types2, @NotNull JSTypeSource source) {
        if (types2 == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(41);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(42);
        }
        if (types2.size() > 1 && types2.stream().allMatch(el -> el instanceof JSFunctionTypeImpl)) {
            List collect = StreamEx.of(types2).select(JSFunctionTypeImpl.class).map(el -> new JSRecordTypeImpl.CallSignatureImpl(false, (JSFunctionType)el)).toList();
            return new JSRecordTypeImpl(source, collect);
        }
        return null;
    }

    @NotNull
    public static JSType createKeyOfType(@NotNull JSType referencedType, @NotNull JSTypeSource source) {
        if (referencedType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(43);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(44);
        }
        if (referencedType instanceof JSUnknownType) {
            return new TypeScriptNeverJSTypeImpl(source);
        }
        if (referencedType instanceof TypeScriptNeverJSTypeImpl) {
            return JSCompositeTypeFactory.createUnionType(source, TypeScriptTypeRelations.getDefaultKeyOfTypes(source));
        }
        if (referencedType instanceof JSRecordType && (((JSRecordType)referencedType).getTypeMembers().isEmpty() || !JSRecordTypeImpl.isObjectType((JSRecordType)referencedType))) {
            JSType jSType = TypeScriptTypeOperatorJSTypeImpl.substituteRecordTypeNoResolve((JSRecordType)referencedType, source);
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(45);
            }
            return jSType;
        }
        return new TypeScriptTypeOperatorJSTypeImpl(referencedType, source);
    }

    public static JSType createConditionalType(@NotNull JSTypeSource source, @NotNull JSType checkedType, @NotNull JSType testType, @NotNull JSType typeIfTrue, @NotNull JSType typeIfFalse) {
        JSType literalMatch;
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(46);
        }
        if (checkedType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(47);
        }
        if (testType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(48);
        }
        if (typeIfTrue == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(49);
        }
        if (typeIfFalse == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(50);
        }
        if (checkedType.isEquivalentTo(testType, new ProcessingContext(), false)) {
            return typeIfTrue;
        }
        if (checkedType instanceof JSRecordType && !((JSRecordType)checkedType).hasMembers() && (testType instanceof JSArrayType || testType instanceof JSPrimitiveType)) {
            return typeIfFalse;
        }
        if (checkedType instanceof TypeScriptNeverJSTypeImpl) {
            return typeIfTrue;
        }
        if (checkedType instanceof JSAnyType && testType instanceof JSTemplateLiteralType) {
            return new TypeScriptNeverJSTypeImpl(source);
        }
        if (checkedType instanceof JSAnyType && !(checkedType instanceof JSUnknownType)) {
            return JSCompositeTypeFactory.createUnionType(source, typeIfTrue, typeIfFalse);
        }
        if (checkedType instanceof JSPrimitiveType && testType instanceof TypeScriptObjectJSTypeImpl) {
            return typeIfFalse;
        }
        if (!JSTypeUtils.hasForeignGenericParameter(typeIfTrue)) {
            if (checkedType instanceof JSArrayType && testType instanceof TypeScriptObjectJSTypeImpl) {
                return typeIfTrue;
            }
            if (typeIfTrue.isEquivalentTo(typeIfFalse, new ProcessingContext(), false)) {
                return typeIfTrue;
            }
        }
        if ((literalMatch = JSCompositeTypeFactory.processAsLiterals(checkedType, testType, typeIfTrue, typeIfFalse)) != null) {
            return literalMatch;
        }
        return new TypeScriptConditionalTypeJSTypeImpl(source, checkedType, testType, typeIfTrue, typeIfFalse);
    }

    @NotNull
    public static JSType createIndexedAccessType(@NotNull JSType owner, @NotNull JSType parameterType, @NotNull JSTypeSource source) {
        JSType jsType;
        JSRecordType.PropertySignature signature;
        if (owner == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(51);
        }
        if (parameterType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(52);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(53);
        }
        if (owner instanceof JSAnyType || owner instanceof TypeScriptNeverJSTypeImpl) {
            JSType jSType = owner;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(54);
            }
            return jSType;
        }
        if (parameterType instanceof JSAnyType) {
            JSType jSType = parameterType;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(55);
            }
            return jSType;
        }
        if (owner instanceof JSRecordType && parameterType instanceof JSStringLiteralTypeImpl && !((JSStringLiteralTypeImpl)parameterType).allowWidening() && (signature = ((JSRecordType)owner).findPropertySignature(((JSStringLiteralTypeImpl)parameterType).getLiteral())) != null && (jsType = signature.getJSTypeWithOptionality()) != null) {
            JSType jSType = jsType;
            if (jSType == null) {
                JSCompositeTypeFactory.$$$reportNull$$$0(56);
            }
            return jSType;
        }
        if (owner instanceof TypeScriptMappedJSTypeImpl) {
            JSType type = ((TypeScriptMappedJSTypeImpl)owner).getParameterType();
            JSType resultType = ((TypeScriptMappedJSTypeImpl)owner).getResultType();
            if (!JSTypeUtils.hasForeignGenericParameter(resultType) && parameterType.isEquivalentTo(type, new ProcessingContext(), false)) {
                JSType jSType = resultType;
                if (jSType == null) {
                    JSCompositeTypeFactory.$$$reportNull$$$0(57);
                }
                return jSType;
            }
        }
        return new TypeScriptIndexedAccessJSTypeImpl(owner, parameterType, source);
    }

    public static JSType createMappedType(@NotNull JSTypeSource source, boolean isReadonly, boolean isOptional, boolean isMinusReadonly, boolean isMinusOptional, @NotNull JSTypeSubstitutor.JSTypeGenericId parameterId, @NotNull JSType parameterType, @NotNull JSType resultType, @Nullable JSType namedType) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(58);
        }
        if (parameterId == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(59);
        }
        if (parameterType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(60);
        }
        if (resultType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(61);
        }
        if (parameterType instanceof JSAnyType) {
            return JSCompositeTypeFactory.createSingleIndexerRecord(source, resultType);
        }
        if (parameterType instanceof TypeScriptNeverJSTypeImpl) {
            return new JSSimpleRecordTypeImpl(source, Collections.emptyList());
        }
        if (parameterType instanceof TypeScriptTypeOperatorJSTypeImpl) {
            JSType referencedType = ((TypeScriptTypeOperatorJSTypeImpl)parameterType).getReferencedType();
            if (referencedType instanceof JSUnknownType || referencedType instanceof TypeScriptNeverJSTypeImpl) {
                return new JSSimpleRecordTypeImpl(source, Collections.emptyList());
            }
            if (referencedType instanceof JSAnyType) {
                return JSCompositeTypeFactory.createSingleIndexerRecord(source, resultType);
            }
        }
        return new TypeScriptMappedJSTypeImpl(source, isReadonly, isOptional, isMinusReadonly, isMinusOptional, parameterId, parameterType, resultType, namedType);
    }

    public static JSType createAwaitedType(@NotNull JSType referencedType, @NotNull JSTypeSource source) {
        List<JSType> arguments;
        if (referencedType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(62);
        }
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(63);
        }
        if (referencedType instanceof JSPrimitiveType || referencedType instanceof JSAnyType) {
            return referencedType;
        }
        if (referencedType instanceof JSGenericTypeImpl && JSTypeUtils.isPromiseNamedType(((JSGenericTypeImpl)referencedType).getType()) && (arguments = ((JSGenericTypeImpl)referencedType).getArguments()).size() == 1) {
            return arguments.get(0);
        }
        return new TypeScriptAwaitedJSTypeImpl(referencedType, source);
    }

    @NotNull
    private static JSSimpleRecordTypeImpl createSingleIndexerRecord(@NotNull JSTypeSource source, @NotNull JSType resultType) {
        if (source == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(64);
        }
        if (resultType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(65);
        }
        return new JSSimpleRecordTypeImpl(source, Collections.singletonList(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, source, JSTypeContext.INSTANCE), resultType, (PsiElement)null, false)));
    }

    @Nullable
    private static JSType processAsLiterals(@NotNull JSType checkedType, @NotNull JSType testType, @NotNull JSType typeIfTrue, @NotNull JSType typeIfFalse) {
        if (checkedType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(66);
        }
        if (testType == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(67);
        }
        if (typeIfTrue == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(68);
        }
        if (typeIfFalse == null) {
            JSCompositeTypeFactory.$$$reportNull$$$0(69);
        }
        if (checkedType instanceof JSKeyofType && ((JSKeyofType)checkedType).getReferencedType() instanceof JSAnyType && testType instanceof TypeScriptNeverJSTypeImpl) {
            return typeIfFalse;
        }
        if (checkedType instanceof JSPrimitiveType && testType instanceof TypeScriptNeverJSTypeImpl) {
            return typeIfFalse;
        }
        if (!(checkedType instanceof JSPrimitiveLiteralType) || !(testType instanceof JSPrimitiveLiteralType) || ((JSLiteralType)checkedType).allowWidening() || ((JSLiteralType)testType).allowWidening()) {
            return null;
        }
        if (!((JSLiteralType)checkedType).asPrimitiveType().isEquivalentTo(((JSLiteralType)testType).asPrimitiveType(), new ProcessingContext(), false)) {
            return typeIfFalse;
        }
        return !Objects.equals(((JSPrimitiveLiteralType)checkedType).getLiteral(), ((JSPrimitiveLiteralType)testType).getLiteral()) ? typeIfFalse : typeIfTrue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 45: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 45: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: 
            case 13: 
            case 16: 
            case 25: 
            case 27: 
            case 34: 
            case 39: 
            case 42: 
            case 44: 
            case 46: 
            case 53: 
            case 58: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 45: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeFactory";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plainTypes";
                break;
            }
            case 43: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedType";
                break;
            }
            case 47: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkedType";
                break;
            }
            case 48: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testType";
                break;
            }
            case 49: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeIfTrue";
                break;
            }
            case 50: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeIfFalse";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 52: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterId";
                break;
            }
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSCompositeTypeFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntersectionType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createContextualUnionType";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnionType";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseTypesForUnion";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeIntersectionTypes";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseWithLiterals";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyOfType";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndexedAccessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createIntersectionType";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 45: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createContextualUnionType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTupleType";
                break;
            }
            case 16: 
            case 17: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createUnionType";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collapseTypesForUnion";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "optimizeIntersectionTypes";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "normalizeIfPossible";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "collapseWithLiterals";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForImpossibleTypeCombination";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getContextualForCallSignatures";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "createKeyOfType";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createConditionalType";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createIndexedAccessType";
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createMappedType";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createAwaitedType";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createSingleIndexerRecord";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processAsLiterals";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 36: 
            case 37: 
            case 45: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

