/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.EnumStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubElementTypeHolder;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubIndexingUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSTypeHolderOwner;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSFunctionStubBaseImpl<T extends JSFunction>
extends JSQualifiedObjectStubBase<T>
implements JSFunctionStubBase<T>,
JSTypeHolderOwner {
    private static final EnumStructureElement<JSFunction.FunctionKind> FUNCTION_KIND_FLAG = new EnumStructureElement<JSFunction.FunctionKind>(JSFunction.FunctionKind.class);
    private static final BooleanStructureElement REFERENCES_ARGUMENTS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement REFERENCES_THIS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement CONSTRUCTOR_CAN_BE_INVOKED_WITHOUT_NEW_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_OVERRIDE_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement RETURN_TYPE_STRICT_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_ANONYMOUS_FUNC_CALL_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_RETURN_TYPE = new BooleanStructureElement();
    private static final BooleanStructureElement IS_GENERATOR = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_EXPLICITLY_DECLARED_RETURN_TYPE = new BooleanStructureElement();
    private static final BooleanStructureElement IS_TYPE_FROM_JSDOC = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSQualifiedObjectStubBase.FLAGS_STRUCTURE, FUNCTION_KIND_FLAG, REFERENCES_ARGUMENTS_FLAG, REFERENCES_THIS_FLAG, CONSTRUCTOR_CAN_BE_INVOKED_WITHOUT_NEW_FLAG, IS_OVERRIDE_FLAG, RETURN_TYPE_STRICT_FLAG, IS_ANONYMOUS_FUNC_CALL_FLAG, HAS_RETURN_TYPE, IS_GENERATOR, HAS_EXPLICITLY_DECLARED_RETURN_TYPE, IS_TYPE_FROM_JSDOC);
    @Nullable
    private final JSStubElementTypeHolder myReturnTypeHolder;

    protected JSFunctionStubBaseImpl(T function2, StubElement parent, @NotNull JSStubElementType<?, T> elementType) {
        if (elementType == null) {
            JSFunctionStubBaseImpl.$$$reportNull$$$0(0);
        }
        super(function2, parent, elementType);
        this.writeFlag(FUNCTION_KIND_FLAG, function2.getKind());
        this.writeFlag(REFERENCES_ARGUMENTS_FLAG, function2.isReferencesArguments());
        this.writeFlag(REFERENCES_THIS_FLAG, function2.isReferencesThis());
        this.writeFlag(CONSTRUCTOR_CAN_BE_INVOKED_WITHOUT_NEW_FLAG, function2.constructorCanBeInvokedWithoutNew());
        this.writeFlag(IS_OVERRIDE_FLAG, function2.isOverride());
        JSType type = this.getReturnTypeToSerialize(function2);
        this.myReturnTypeHolder = JSStubElementTypeHolder.fromJSType(type);
        this.writeFlag(RETURN_TYPE_STRICT_FLAG, type != null && type.isSourceStrict());
        this.writeFlag(IS_ANONYMOUS_FUNC_CALL_FLAG, function2.isAnonymousFunctionCall());
        this.writeFlag(HAS_RETURN_TYPE, this.myReturnTypeHolder != null);
        this.writeFlag(IS_GENERATOR, function2.isGenerator());
        this.writeFlag(HAS_EXPLICITLY_DECLARED_RETURN_TYPE, function2.hasExplicitlyDeclaredReturnType());
        this.writeFlag(IS_TYPE_FROM_JSDOC, JSStubIndexingUtils.isAstBasedTypeFromJSDoc(type));
    }

    public JSFunctionStubBaseImpl(StubInputStream dataStream, StubElement parentStub, @NotNull JSStubElementType elementType) throws IOException {
        if (elementType == null) {
            JSFunctionStubBaseImpl.$$$reportNull$$$0(1);
        }
        super(dataStream, parentStub, (IStubElementType)elementType);
        this.myReturnTypeHolder = this.readFlag(HAS_RETURN_TYPE) != false ? JSStubElementTypeHolder.fromDataStream(dataStream) : null;
    }

    public JSFunctionStubBaseImpl(String name, @NotNull JSFunction.FunctionKind kind, String qName, String returnType, StubElement parentStub, @NotNull JSContext jsContext, @NotNull JSAttributeList.AccessType accessType, @NotNull JSStubElementType elementType) {
        if (kind == null) {
            JSFunctionStubBaseImpl.$$$reportNull$$$0(2);
        }
        if (jsContext == null) {
            JSFunctionStubBaseImpl.$$$reportNull$$$0(3);
        }
        if (accessType == null) {
            JSFunctionStubBaseImpl.$$$reportNull$$$0(4);
        }
        if (elementType == null) {
            JSFunctionStubBaseImpl.$$$reportNull$$$0(5);
        }
        super(name, qName, parentStub, jsContext, accessType, (IStubElementType)elementType);
        this.myReturnTypeHolder = returnType != null ? new JSStubElementTypeHolder(returnType) : null;
        this.writeFlag(FUNCTION_KIND_FLAG, kind);
        this.writeFlag(HAS_RETURN_TYPE, this.myReturnTypeHolder != null);
    }

    public boolean isGetProperty() {
        return this.readFlag(FUNCTION_KIND_FLAG) == JSFunction.FunctionKind.GETTER;
    }

    public boolean isSetProperty() {
        return this.readFlag(FUNCTION_KIND_FLAG) == JSFunction.FunctionKind.SETTER;
    }

    public boolean isConstructor() {
        return this.readFlag(FUNCTION_KIND_FLAG) == JSFunction.FunctionKind.CONSTRUCTOR;
    }

    public boolean isOverride() {
        return this.readFlag(IS_OVERRIDE_FLAG);
    }

    public boolean isReferencesArguments() {
        return this.readFlag(REFERENCES_ARGUMENTS_FLAG);
    }

    public boolean isReferencesThis() {
        return this.readFlag(REFERENCES_THIS_FLAG);
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_RETURN_TYPE).booleanValue()) {
            JSStubElementTypeHolder.serialize(this.myReturnTypeHolder, dataStream);
        }
    }

    public String getReturnTypeString() {
        return this.myReturnTypeHolder != null ? this.myReturnTypeHolder.getTypeString() : null;
    }

    public boolean isReturnTypeStrict() {
        return this.readFlag(RETURN_TYPE_STRICT_FLAG);
    }

    public boolean isReturnTypeFromJSDoc() {
        return this.readFlag(IS_TYPE_FROM_JSDOC);
    }

    public boolean constructorCanBeInvokedWithoutNew() {
        return this.readFlag(CONSTRUCTOR_CAN_BE_INVOKED_WITHOUT_NEW_FLAG);
    }

    public boolean isAnonymousFunCall() {
        return this.readFlag(IS_ANONYMOUS_FUNC_CALL_FLAG);
    }

    public boolean isGenerator() {
        return this.readFlag(IS_GENERATOR);
    }

    public boolean hasExplicitlyDeclaredReturnType() {
        return this.readFlag(HAS_EXPLICITLY_DECLARED_RETURN_TYPE);
    }

    @Nullable
    protected JSType getReturnTypeToSerialize(@NotNull T function2) {
        PsiElement element;
        if (function2 == null) {
            JSFunctionStubBaseImpl.$$$reportNull$$$0(6);
        }
        if ((element = function2.getReturnTypeElement()) instanceof JSTypeDeclaration) {
            return null;
        }
        JSType type = function2.getReturnType();
        return JSStubIndexingUtils.needSerializeType(type) ? type : null;
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSFunctionStubBaseImpl.$$$reportNull$$$0(7);
        }
        return flagsStructure;
    }

    @Override
    @Nullable
    public JSStubElementTypeHolder getJSTypeHolder() {
        return this.myReturnTypeHolder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/stubs/impl/JSFunctionStubBaseImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSFunctionStubBaseImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFlagsStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReturnTypeToSerialize";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

