/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSDestructuringParameterImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringElementStubImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringParameterStubImpl
extends JSDestructuringElementStubImpl<JSDestructuringParameter> {
    private static final BooleanStructureElement IS_OPTIONAL_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_REST_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_SERIALIZED_TYPE_FLAG = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSDestructuringElementStubImpl.FLAGS_STRUCTURE, IS_OPTIONAL_FLAG, IS_REST_FLAG, HAS_SERIALIZED_TYPE_FLAG);
    @Nullable
    private final String mySerializedType;

    public JSDestructuringParameterStubImpl(JSDestructuringParameter psi, StubElement parent) {
        super(psi, parent, JSStubElementTypes.DESTRUCTURING_PARAMETER);
        this.writeFlag(IS_OPTIONAL_FLAG, psi.isOptional());
        this.writeFlag(IS_REST_FLAG, psi.isRest());
        Pair<JSType, Boolean> typeAndNeedsSerialization = JSDestructuringParameterImpl.getTypeAndNeedsSerialization((JSDestructuringParameterImpl)psi, null);
        boolean needSerializeType = typeAndNeedsSerialization.first != null && (Boolean)typeAndNeedsSerialization.second != false;
        this.writeFlag(HAS_SERIALIZED_TYPE_FLAG, needSerializeType);
        this.mySerializedType = needSerializeType ? JSTypeUtils.serializeType((JSType)typeAndNeedsSerialization.first) : null;
    }

    public JSDestructuringParameterStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, (JSStubElementType<?, ?>)JSStubElementTypes.DESTRUCTURING_PARAMETER);
        this.mySerializedType = this.readFlag(HAS_SERIALIZED_TYPE_FLAG) != false ? dataStream.readNameString() : null;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        if (this.readFlag(HAS_SERIALIZED_TYPE_FLAG).booleanValue()) {
            dataStream.writeName(this.mySerializedType);
        }
    }

    @Override
    public JSDestructuringParameter createPsi() {
        return new JSDestructuringParameterImpl(this);
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            JSDestructuringParameterStubImpl.$$$reportNull$$$0(0);
        }
        return flagsStructure;
    }

    public boolean isOptional() {
        return this.readFlag(IS_OPTIONAL_FLAG);
    }

    @Nullable
    public String getSerializedType() {
        return this.mySerializedType;
    }

    public boolean isRest() {
        return this.readFlag(IS_REST_FLAG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/JSDestructuringParameterStubImpl", "getFlagsStructure"));
    }
}

