/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.frameworks.amd.JSAmdModulesIndex;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.frameworks.gcl.JSGclModuleReference;
import com.intellij.lang.javascript.frameworks.gcl.JSGclReferenceContributor;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSLocalTypeEvaluatorBase;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSEmptyExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSOptionalOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReferenceItem;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSFunctionBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSThisExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSCachingTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.resolve.JSTypeGuardEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTaskList;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationTasks;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElementWithBackingItem;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBigIntLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSElvisType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralType;
import com.intellij.lang.javascript.psi.types.JSFreshObjectLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIterableComponentTypeImpl;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSWidenType;
import com.intellij.lang.javascript.psi.types.JsonElementType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyCallType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyIndexedAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyNewType;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSCustomElementType;
import com.intellij.lang.javascript.psi.types.evaluable.JSDestructuringTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyType;
import com.intellij.lang.javascript.psi.types.evaluable.JSEvaluableOnlyTypeBase;
import com.intellij.lang.javascript.psi.types.evaluable.JSPropertiesOwnerType;
import com.intellij.lang.javascript.psi.types.evaluable.JSQualifiedReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSStubBasedExpressionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.util.JSDestructuringContext;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiQualifiedReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.Deprecated;
import kotlin.ReplaceWith;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTypeEvaluator {
    public static final PsiElement EXPLICIT_TYPE_MARKER_ELEMENT = PsiUtilCore.NULL_PSI_ELEMENT;
    private static final JSComplexityAwareRecursionGuard<JSEvaluationKey> ourRecursionGuard = new JSComplexityAwareRecursionGuard("js.type.evaluator");
    public static final int MAX_RESOLVE_RESULT_COUNT_TO_EVALUATE = 20;
    private static final Key<JSElementEvaluationResultCache> CACHE_KEY_EXPRESSION_TYPE = Key.create((String)"js.evaluator.expression.type");
    private static final CacheProviderExpressionType CACHE_PROVIDER_EXPRESSION_TYPE = new CacheProviderExpressionType();
    public static final String JQUERY_NS = "jQuery";
    @NotNull
    protected JSEvaluateContext myContext;
    @NotNull
    protected final JSTypeProcessor myTypeProcessor;
    private static final Predicate<JSInitializerOwner> WITH_TYPE_DECLARATION_PREDICATE = owner -> {
        JSFunction function2;
        if (owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)owner).getTypeElement() != null) {
            return true;
        }
        if (owner instanceof JSDestructuringParameter && (function2 = ((JSDestructuringParameter)owner).getDeclaringFunction()) instanceof JSFunctionBaseImpl) {
            return ((JSFunctionBaseImpl)function2).getTypeFromComments((JSParameterItem)((JSDestructuringParameter)owner)) != null;
        }
        return false;
    };

    protected JSTypeEvaluator(@NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myTypeProcessor = processor;
    }

    @java.lang.Deprecated
    @Nullable
    public static JSType forceEvaluateType(@NotNull JSExpression expr) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(2);
        }
        JSSimpleTypeProcessor typeProcessor = new JSSimpleTypeProcessor((PsiElement)expr);
        JSTypeEvaluator.processWithEvaluationGuard((PsiElement)expr, new JSEvaluateContext(expr.getContainingFile(), false), () -> {
            JSEvaluateContext context = new JSEvaluateContext(expr.getContainingFile(), false);
            JSCompleteTypeEvaluationProcessor completeProcessor = new JSCompleteTypeEvaluationProcessor(typeProcessor, (PsiElement)expr, context);
            JSType type = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)expr, new JSEvaluateContext(expr.getContainingFile()));
            ((JSCachingTypeProcessor)completeProcessor).doAddType(type, context, null);
            return null;
        });
        return typeProcessor.getType();
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(3);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(4);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes((PsiElement)expr, expr.getContainingFile(), typeProcessor, false);
    }

    public static void evaluateTypes(@NotNull JSExpression expr, @NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor) {
        if (expr == null) {
            JSTypeEvaluator.$$$reportNull$$$0(5);
        }
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(6);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(7);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes((PsiElement)expr, targetFile, typeProcessor, false);
    }

    public static void evaluateExpressionOrElementTypes(@NotNull PsiFile targetFile, @NotNull JSTypeProcessor typeProcessor, @NotNull PsiElement element) {
        if (targetFile == null) {
            JSTypeEvaluator.$$$reportNull$$$0(8);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(9);
        }
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(10);
        }
        JSCompleteTypeEvaluationProcessor.evaluateTypes(element, targetFile, typeProcessor, false);
    }

    private static void doEvaluateExpressionOrElementTypeForCaching(@NotNull PsiElement element, @NotNull JSEvaluateContext context, @NotNull JSTypeEvaluationProcessor processor) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(11);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(12);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(13);
        }
        JSCachingTypeProcessor completeProcessor = new JSCachingTypeProcessor(processor, element, context);
        JSType type = JSCodeBasedTypeFactory.getPsiBasedType(element, context);
        completeProcessor.doAddType(type, context, null);
    }

    public void doEvaluateExpressionOrElementTypes(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(14);
        }
        if (element instanceof JSExpression && JSTypeEvaluator.isEvaluatedAsExpression((JSExpression)element)) {
            this.doEvaluateTypes((JSExpression)element);
        } else if (element instanceof JSDestructuringContainer) {
            this.evaluateDestructuringContainer((JSDestructuringContainer)element);
        } else {
            this.doAddTypeFromResolveResult(element);
        }
    }

    public static boolean isEvaluatedAsExpression(@NotNull JSExpression element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(15);
        }
        return !(element instanceof JSDefinitionExpression);
    }

    @NotNull
    public static JSTypeEvaluator createEvaluator(@NotNull JSTypeProcessor typeProcessor, @Nullable PsiElement element, @NotNull JSEvaluateContext context) {
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(16);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(17);
        }
        JSTypeEvaluator jSTypeEvaluator = JSDialectSpecificHandlersFactory.forElement(element).newTypeEvaluator(context, typeProcessor);
        if (jSTypeEvaluator == null) {
            JSTypeEvaluator.$$$reportNull$$$0(18);
        }
        return jSTypeEvaluator;
    }

    @java.lang.Deprecated
    @Nullable
    public static JSTypeEvaluationResult getExpressionType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(19);
        }
        return JSTypeEvaluator.getElementType((PsiElement)expression);
    }

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(20);
        }
        return JSTypeEvaluator.getElementType(element, new JSEvaluateContext(element.getContainingFile(), false));
    }

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element, @NotNull JSEvaluateContext context) {
        JSElementEvaluationResultCache data;
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(21);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(22);
        }
        if ((data = (JSElementEvaluationResultCache)element.getUserData(CACHE_KEY_EXPRESSION_TYPE)) == null) {
            data = new JSElementEvaluationResultCache();
            element.putUserData(CACHE_KEY_EXPRESSION_TYPE, (Object)data);
        }
        return data.getElementType(element, context);
    }

    void addTypeEvaluationResultElement(@NotNull JSEvaluationResultElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(23);
        }
        JSReferenceExpression originalExpression = this.myContext.getProcessedExpression();
        PsiElement originalSource = this.myContext.getSource();
        JSEvaluateContext combinedContext = this.myContext.combineWith(element.getEvaluateContext());
        this.runWithContext(combinedContext, () -> {
            PsiElement source = element.getSource();
            JSType type = element.getTypeOrAdditionalType();
            if (element.isAdditionalType()) {
                this.addAdditionalType(type, source);
                return;
            }
            if (originalExpression != null) {
                type = JSTypeGuardEvaluator.applyToExpressionType(type, (JSExpression)originalExpression, originalSource, this.myContext);
            } else if (originalSource != null) {
                type = JSTypeGuardEvaluator.applyToResolveResultType(type, originalSource, this.myContext);
            }
            JSTypeEvaluator.applyContextAndProcess(type, source, this.myContext, this.myTypeProcessor);
        });
    }

    public void addType(@Nullable JSType type, @Nullable PsiElement source) {
        if (type == null) {
            return;
        }
        this.doAddType(type, source);
    }

    protected void doAddType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(24);
        }
        this.addAdditionalTypesForType(type);
        this.myTypeProcessor.process(type, this.myContext, source);
    }

    static void applyContextAndProcess(@NotNull JSType type, @Nullable PsiElement source, @NotNull JSEvaluateContext context, @NotNull JSTypeProcessor typeProcessor) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(25);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(26);
        }
        if (typeProcessor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(27);
        }
        if (type instanceof JSEvaluableType && !(type instanceof JSPropertiesOwnerType)) {
            type = type.substitute();
        }
        type = JSGenericTypesEvaluator.getEvaluator(type.getSourceElement()).evaluateGenerics(type, (JSExpression)context.getProcessedExpression(), null);
        if (!context.isStrict() && type.isSourceStrict()) {
            type = JSTypeUtils.copyWithStrictRecursive(type, false);
        }
        if ((type = JSCompositeTypeImpl.optimizeTypeForSubstitute(type, (PsiElement)context.getProcessedExpression())) instanceof JSFreshObjectLiteralType && context.getSource() instanceof JSVariable) {
            type = ((JSFreshObjectLiteralType)type).removeFreshness();
        }
        typeProcessor.process(type, context, source);
    }

    private void addAdditionalTypesForType(@Nullable JSType type) {
        PsiElement element;
        JSType referenceType;
        Object object = type instanceof JSReferenceType || type instanceof JSQualifiedReferenceType ? type : (referenceType = type instanceof JSApplyCallType ? ((JSApplyCallType)type).getBaseType() : null);
        if (referenceType instanceof JSReferenceItem && (element = referenceType.getSourceElement()) != null) {
            JSReferenceItem refType = (JSReferenceItem)referenceType;
            JSTypeEvaluator.addAdditionalTypes(element, refType, this.myTypeProcessor, this.myContext);
        }
    }

    private void addNamespace(@NotNull JSNamespace namespace, @Nullable PsiElement source) {
        if (namespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(28);
        }
        this.addAdditionalType((JSType)namespace, source);
    }

    public void addAdditionalType(@NotNull JSType type, @Nullable PsiElement source) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(29);
        }
        this.myTypeProcessor.processAdditionalType(type, this.myContext, source);
    }

    private void doEvaluateTypes(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(30);
        }
        if (this.myContext.isAstAccessAllowed((PsiElement)rawqualifier) && JSElvisType.isElvisContext(rawqualifier)) {
            JSType qualifierType = JSEvaluableOnlyTypeBase.substituteWithEvaluator(JSAnyType.get((PsiElement)rawqualifier, true), (evaluator, processor) -> evaluator.doEvaluateTypesImpl(rawqualifier));
            qualifierType = JSElvisType.applyElvisContext(rawqualifier, qualifierType);
            this.addType(qualifierType, null);
            return;
        }
        this.doEvaluateTypesImpl(rawqualifier);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void doEvaluateTypesImpl(@NotNull JSExpression rawqualifier) {
        JSType typecast;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(31);
        }
        if (this.myContext.isAstAccessAllowed((PsiElement)rawqualifier) && (typecast = this.evaluateTypeFromInlineComment(rawqualifier)) != null) {
            this.addType(typecast, null);
            return;
        }
        if (rawqualifier instanceof JSDefinitionExpression) {
            rawqualifier = ((JSDefinitionExpression)rawqualifier).getExpression();
        }
        if (rawqualifier instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)rawqualifier;
            if (referenceExpression.getQualifier() == null && rawqualifier.getNode().findChildByType(JSTokenTypes.UNDEFINED_KEYWORD) != null) {
                this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true)), (PsiElement)rawqualifier);
                return;
            }
            this.processRefExpr(referenceExpression);
            return;
        }
        if (rawqualifier instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSPrefixExpression) {
            JSPrefixExpression prefixExpression = (JSPrefixExpression)rawqualifier;
            IElementType sign = prefixExpression.getOperationSign();
            String evaluatedType = null;
            JSType evaluatedJsType = null;
            if (JSTokenTypes.EXCL == sign || JSTokenTypes.DELETE_KEYWORD == sign) {
                evaluatedType = "boolean";
            } else if (JSTokenTypes.PLUS == sign || JSTokenTypes.PLUSPLUS == sign || JSTokenTypes.TILDE == sign || JSTokenTypes.MINUSMINUS == sign || JSTokenTypes.MINUS == sign) {
                if (JSSymbolUtil.isLiteralOrLiteralWithSign((JSExpression)prefixExpression)) {
                    this.addTypeFromLiteralExpression((JSExpression)prefixExpression);
                    return;
                }
                if (!DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    this.addNumericOperatorType(prefixExpression.getExpression(), null, (JSExpression)prefixExpression);
                    return;
                }
                JSType type = this.getExpressionTypeInContext(prefixExpression.getExpression());
                if (type != null) {
                    evaluatedType = type.getTypeText();
                }
            } else if (JSTokenTypes.TYPEOF_KEYWORD == sign) {
                if (!DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                    JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                    evaluatedJsType = JSCompositeTypeFactory.createUnionType(typeSource, ContainerUtil.map((Object[])JSCommonTypeNames.TYPEOF_VALUES, v -> new JSStringLiteralTypeImpl((String)v, false, typeSource)));
                } else {
                    evaluatedType = "string";
                }
            } else if (JSTokenTypes.AWAIT_KEYWORD == sign) {
                this.addCodeBasedType(rawqualifier);
                return;
            }
            if (evaluatedJsType != null) {
                this.addType(evaluatedJsType, (PsiElement)rawqualifier);
                return;
            }
            if (evaluatedType != null) {
                JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                JSType type = JSNamedTypeFactory.createType(evaluatedType, source, JSContext.INSTANCE);
                this.addType(type, (PsiElement)rawqualifier);
                return;
            }
            this.setUnknownElement((PsiElement)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSPostfixExpression) {
            JSPostfixExpression postfixExpression = (JSPostfixExpression)rawqualifier;
            IElementType sign = postfixExpression.getOperationSign();
            if (JSTokenTypes.PLUSPLUS != sign) {
                if (JSTokenTypes.MINUSMINUS != sign) return;
            }
            if (DialectDetector.isActionScript((PsiElement)rawqualifier)) {
                this.simpleEvalType(rawqualifier, postfixExpression.getExpression());
                return;
            }
            this.addNumericOperatorType(postfixExpression.getExpression(), null, rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)rawqualifier;
            IElementType sign = binaryExpression.getOperationSign();
            JSExpression rOperand = binaryExpression.getROperand();
            JSExpression lOperand = binaryExpression.getLOperand();
            if (lOperand == null) return;
            if (rOperand == null) return;
            this.processBinaryOperation(binaryExpression, sign, lOperand, rOperand);
            return;
        }
        if (rawqualifier instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression(rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSArrayLiteralExpression) {
            JSType type;
            JSArrayLiteralExpression literal = (JSArrayLiteralExpression)rawqualifier;
            if (!literal.isEmpty()) {
                type = this.getArrayTypeFromExpressions(literal, literal.getExpressionStream());
            } else {
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
                type = new JSArrayTypeImpl(JSAnyType.get((PsiElement)rawqualifier, true), typeSource);
            }
            this.addType(type, (PsiElement)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSIndexedPropertyAccessExpression) {
            this.addType(this.getIndexedPropertyAccessType((JSIndexedPropertyAccessExpression)rawqualifier), (PsiElement)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)rawqualifier, this.myContext.isAstAccessAllowed((PsiElement)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSParenthesizedExpression) {
            this.evaluateTypes(((JSParenthesizedExpression)rawqualifier).getInnerExpression());
            return;
        }
        if (rawqualifier instanceof JSThisExpression) {
            this.processThisQualifierExpression((JSThisExpression)rawqualifier);
            return;
        }
        if (rawqualifier instanceof JSSuperExpression) {
            JSClass jsClass = JSResolveUtil.getClassOfContext((PsiElement)rawqualifier);
            this.processSuperQualifierExpression((JSSuperExpression)rawqualifier, jsClass);
            return;
        }
        if (rawqualifier instanceof JSFunctionExpression) {
            this.processFunction((JSFunction)((JSFunctionExpression)rawqualifier));
            return;
        }
        if (rawqualifier instanceof JSConditionalExpression) {
            JSConditionalExpression conditionalExpression = (JSConditionalExpression)rawqualifier;
            JSExpression thenPart = conditionalExpression.getThen();
            JSExpression elsePart = conditionalExpression.getElse();
            JSType thenType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, thenPart);
            JSType elseType = this.getConditionalPartTypeOrAny((JSExpression)conditionalExpression, elsePart);
            if (thenType == null) {
                if (elseType == null) return;
            }
            JSType common = TypeScriptTypeRelations.getBestChoiceType(thenType, elseType, (PsiElement)conditionalExpression);
            this.addType(common, (PsiElement)conditionalExpression);
            return;
        }
        if (rawqualifier instanceof JSEmptyExpression) {
            this.addType(new JSUndefinedType(JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, false)), (PsiElement)rawqualifier);
            return;
        }
        if (this.evaluateDialectSpecificTypes(rawqualifier)) return;
        if (rawqualifier == null) return;
        this.setUnknownElement((PsiElement)rawqualifier);
    }

    private void processBinaryOperation(@NotNull JSBinaryExpression binaryExpression, @Nullable IElementType sign, @Nullable JSExpression lOperand, @Nullable JSExpression rOperand) {
        if (binaryExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(32);
        }
        if (sign == JSTokenTypes.AS_KEYWORD) {
            this.resolveAsBinaryOperationExpression((JSExpression)binaryExpression, rOperand);
        } else if (JSTokenTypes.BOOLEAN_RESULT_OPERATIONS.contains(sign)) {
            this.addType(new JSBooleanType(true, JSTypeSourceFactory.createTypeSource((PsiElement)binaryExpression, true), JSTypeContext.INSTANCE), null);
        } else if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(sign) || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign) || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.OROR || sign == JSTokenTypes.QUEST_QUEST || sign == JSTokenTypes.MULTMULT) {
            if (sign == JSTokenTypes.DIV || (sign == JSTokenTypes.OR || sign == JSTokenTypes.AND || sign == JSTokenTypes.XOR || sign == JSTokenTypes.MINUS || sign == JSTokenTypes.MULTMULT || JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(sign)) && !DialectDetector.isActionScript((PsiElement)binaryExpression)) {
                this.addNumericOperatorType(lOperand, rOperand, (JSExpression)binaryExpression);
            } else {
                JSType lProcType = JSTypeUtils.getValuableType(this.getExpressionTypeInContext(lOperand));
                JSType rProcType = JSTypeUtils.getValuableType(this.getExpressionTypeInContext(rOperand));
                if (sign == JSTokenTypes.OROR || sign == JSTokenTypes.ANDAND || sign == JSTokenTypes.QUEST_QUEST) {
                    this.evaluateAndOrOrType((JSExpression)binaryExpression, sign, lProcType, rProcType);
                } else {
                    this.evaluatePlusType(binaryExpression, lProcType, rProcType);
                }
            }
        } else if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(sign)) {
            JSTypeEvaluationResult result2 = null;
            if (lOperand instanceof JSDefinitionExpression) {
                lOperand = ((JSDefinitionExpression)lOperand).getExpression();
            }
            if (lOperand != null && DialectDetector.isActionScript((PsiElement)binaryExpression)) {
                result2 = this.getTypeEvaluationResultInContext((PsiElement)lOperand);
            }
            if (result2 == null) {
                result2 = this.getTypeEvaluationResultInContext((PsiElement)rOperand);
            }
            if (result2 != null) {
                for (JSEvaluationResultElement element : result2.getResults()) {
                    this.addTypeEvaluationResultElement(element);
                }
            } else {
                this.setUnknownElement((PsiElement)binaryExpression);
            }
        } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(sign)) {
            this.simpleEvalType((JSExpression)binaryExpression, lOperand);
        }
    }

    protected JSType evaluateTypeFromInlineComment(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(33);
        }
        return JSDocumentationUtils.findTypeFromInlineComment((PsiElement)rawqualifier);
    }

    private void addNumericOperatorType(@Nullable JSExpression firstOperand, @Nullable JSExpression secondOperand, @NotNull JSExpression evaluatedExpression) {
        if (evaluatedExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(34);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)evaluatedExpression, true);
        JSType expressionType = this.getExpressionTypeInContext(firstOperand);
        if (expressionType instanceof JSBigIntType) {
            this.addType(new JSBigIntType(true, typeSource, JSTypeContext.INSTANCE), null);
        } else {
            JSType otherExpressionType = this.getExpressionTypeInContext(secondOperand);
            if (otherExpressionType instanceof JSBigIntType) {
                this.addType(new JSBigIntType(true, typeSource, JSTypeContext.INSTANCE), null);
            } else {
                this.addType(new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), null);
            }
        }
    }

    protected void evaluatePlusType(@NotNull JSBinaryExpression binaryExpression, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        JSType evaluatedType;
        if (binaryExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(35);
        }
        if ((evaluatedType = JSLocalTypeEvaluatorBase.evaluatePlusForExpandedTypes((PsiElement)binaryExpression, lProcType, rProcType)) != null) {
            this.addType(evaluatedType, (PsiElement)binaryExpression);
        } else {
            this.setUnknownElement((PsiElement)binaryExpression);
        }
    }

    protected void evaluateAndOrOrType(@NotNull JSExpression rawqualifier, @NotNull IElementType sign, @Nullable JSType lProcType, @Nullable JSType rProcType) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(36);
        }
        if (sign == null) {
            JSTypeEvaluator.$$$reportNull$$$0(37);
        }
        if (lProcType != null) {
            this.addType(lProcType, (PsiElement)rawqualifier);
        }
        if (rProcType != null) {
            this.addType(rProcType, (PsiElement)rawqualifier);
        }
        if (lProcType == null && rProcType == null) {
            this.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    protected JSType getIndexedPropertyAccessType(@NotNull JSIndexedPropertyAccessExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(38);
        }
        return this.addComponentTypeFromArrayExpression((JSExpression)rawqualifier, rawqualifier.getQualifier());
    }

    private void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier) {
        JSClass jsClass;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(39);
        }
        JSClass jSClass = jsClass = JSResolveUtil.ownerHasExplicitThisParameter((JSExpression)rawqualifier) ? null : (JSClass)ObjectUtils.tryCast((Object)JSThisExpressionImpl.resolveThisContext((PsiElement)rawqualifier), JSClass.class);
        if (jsClass != null) {
            JSContext staticOrInstance = JSResolveUtil.calculateStaticFromContext((PsiElement)rawqualifier) ? JSContext.STATIC : JSContext.INSTANCE;
            this.processThisQualifierExpression(rawqualifier, jsClass, staticOrInstance);
        } else {
            PsiElement thisScope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)rawqualifier);
            this.processThisQualifierInExecutionScope(rawqualifier, thisScope);
        }
    }

    protected void processThisQualifierExpression(@NotNull JSThisExpression rawqualifier, @NotNull JSClass jsClass, @NotNull JSContext staticOrInstance) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(40);
        }
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(41);
        }
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(42);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
        this.addType(this.createTypeForThisExpression(staticOrInstance, jsClass, typeSource), (PsiElement)jsClass);
    }

    @NotNull
    protected JSType createTypeForThisExpression(@NotNull JSContext staticOrInstance, @NotNull JSClass jsClass, @NotNull JSTypeSource typeSource) {
        JSNamespace ns;
        if (staticOrInstance == null) {
            JSTypeEvaluator.$$$reportNull$$$0(43);
        }
        if (jsClass == null) {
            JSTypeEvaluator.$$$reportNull$$$0(44);
        }
        if (typeSource == null) {
            JSTypeEvaluator.$$$reportNull$$$0(45);
        }
        if ((ns = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)jsClass, typeSource.isStrict())) == null) {
            if (jsClass instanceof JSClassExpression) {
                return new JSClassExpressionType((JSClassExpression)jsClass, staticOrInstance);
            }
            ns = JSAnyType.get(typeSource);
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.copyWithJSContext(ns, staticOrInstance);
        if (jSNamespace == null) {
            JSTypeEvaluator.$$$reportNull$$$0(46);
        }
        return jSNamespace;
    }

    protected void processThisQualifierInExecutionScope(@NotNull JSThisExpression thisQualifier, PsiElement thisScope) {
        JSType type;
        if (thisQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(47);
        }
        if ((type = JSDocumentationUtils.findContextType(thisScope)) != null) {
            this.addType(type, null);
        } else {
            JSNamespace thisType = JSContextResolver.resolveContext((PsiElement)thisQualifier, this.myContext.isAstAccessAllowed((PsiElement)thisQualifier));
            if (thisType != null) {
                this.addType((JSType)thisType, (PsiElement)thisQualifier);
            } else if (thisScope instanceof JSFunctionExpression && thisScope.getParent() instanceof JSArgumentList) {
                JSType funcType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSFunctionExpression)thisScope), this.getContextualExpectedTypeKind());
                if ((funcType = JSTypeUtils.getValuableType(funcType)) instanceof JSFunctionTypeImpl && (thisType = ((JSFunctionTypeImpl)funcType).getThisType()) != null) {
                    this.addType((JSType)thisType, (PsiElement)thisQualifier);
                }
            }
            if (thisType == null) {
                this.setUnknownElement((PsiElement)thisQualifier);
            }
        }
    }

    private void resolveAsBinaryOperationExpression(JSExpression rawqualifier, JSExpression rOperand) {
        JSType type;
        PsiElement resolve;
        boolean isClassCast = false;
        if (rOperand instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)rOperand).resolve()) instanceof JSVariable && (type = ((JSVariable)resolve).getJSType()) instanceof JSNamedType && "Class".equals(type.getTypeText(JSType.TypeTextFormat.SIMPLE))) {
            isClassCast = true;
        }
        if (isClassCast) {
            this.addType(JSAnyType.get((PsiElement)rawqualifier, false), (PsiElement)rawqualifier);
        } else {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)rOperand, false);
            this.addType(JSTypeUtils.createType(rOperand.getText(), source), null);
        }
    }

    protected void processSuperQualifierExpression(JSSuperExpression rawqualifier, @Nullable JSClass jsClass) {
        JSClass aClass;
        String name;
        JSClass[] classes;
        if (jsClass != null && (classes = jsClass.getSuperClasses()).length > 0 && (name = (aClass = classes[0]).getQualifiedName()) != null) {
            this.addType(JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource((PsiElement)aClass, false), JSContext.UNKNOWN), (PsiElement)aClass);
        }
    }

    @Nullable
    private JSType getConditionalPartTypeOrAny(JSExpression conditionalExpression, JSExpression part) {
        JSType partType = null;
        if (part != null && (partType = this.getExpressionTypeInContext(part)) == null) {
            partType = JSAnyType.get((PsiElement)conditionalExpression, false);
        }
        return partType;
    }

    protected boolean isContextualOverloadEvaluation() {
        return this.myContext.isContextualOverloadEvaluation();
    }

    @Nullable
    protected JSType getExpressionTypeInContext(@Nullable JSExpression toEvaluate) {
        return JSResolveUtil.getElementJSType((PsiElement)toEvaluate, this.isContextualOverloadEvaluation());
    }

    @Nullable
    protected JSType getLazyExpressionTypeInContext(@Nullable JSExpression toEvaluate) {
        if (toEvaluate == null) {
            return null;
        }
        return JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)toEvaluate, this.myContext);
    }

    @Nullable
    protected JSTypeEvaluationResult getTypeEvaluationResultInContext(@Nullable PsiElement toEvaluate) {
        return toEvaluate == null ? null : JSTypeEvaluator.getElementType(toEvaluate, this.myContext);
    }

    @NotNull
    protected JSType getArrayTypeFromExpressions(@NotNull JSArrayLiteralExpression rawQualifier, @NotNull Stream<JSExpression> expressions) {
        if (rawQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(48);
        }
        if (expressions == null) {
            JSTypeEvaluator.$$$reportNull$$$0(49);
        }
        List providers = expressions.map(el -> () -> JSTypeEvaluator.getTypeOrSpread(el, this.getExpressionTypeForArrayLiteral((JSExpression)rawQualifier, (JSExpression)el, null))).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, (PsiElement)rawQualifier, true);
        return new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)rawQualifier, true));
    }

    @Nullable
    protected static JSType getTypeOrSpread(@NotNull JSExpression el, @Nullable JSType type) {
        if (el == null) {
            JSTypeEvaluator.$$$reportNull$$$0(50);
        }
        if (el instanceof JSSpreadExpression) {
            return new JSSpreadTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)el, true), type == null ? JSAnyType.get((PsiElement)el, true) : type);
        }
        return type;
    }

    @Nullable
    protected JSType getExpressionTypeForArrayLiteral(@Nullable JSExpression arrayLiteralExpression, @Nullable JSExpression expression, @Nullable AtomicInteger typesToEvaluateLimit) {
        JSType exprType;
        JSType jSType = expression instanceof JSSpreadExpression ? this.getArrayElementTypeFromSpread((JSSpreadExpression)expression) : (exprType = expression != null ? JSTypeEvaluator.getTypeFromConstant(expression) : this.createNullType(arrayLiteralExpression));
        if (exprType == null && (typesToEvaluateLimit == null || typesToEvaluateLimit.decrementAndGet() >= 0)) {
            exprType = this.getLazyExpressionTypeInContext(expression);
        }
        return exprType;
    }

    @Nullable
    private JSType getArrayElementTypeFromSpread(@NotNull JSSpreadExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(51);
        }
        return this.getExpressionTypeInContext(expression.getExpression());
    }

    @NotNull
    protected JSType createNullType(@Nullable JSExpression rawqualifier) {
        JSType jSType = JSNamedTypeFactory.createType("null", JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true), JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(52);
        }
        return jSType;
    }

    protected void addTypeFromLocalName(PsiNamedElement resolveResult) {
        String name = resolveResult.getName();
        if (name != null && DialectDetector.isJavaScript((PsiElement)resolveResult)) {
            JSNamespace ns = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(name, null), JSContext.STATIC, (PsiElement)resolveResult, false, true, true);
            this.addNamespace(ns, (PsiElement)resolveResult);
        }
    }

    protected boolean evaluateDialectSpecificTypes(JSExpression rawqualifier) {
        return false;
    }

    protected void evaluateNewExpressionTypes(@NotNull JSNewExpression newExpression) {
        if (newExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(53);
        }
        this.addCodeBasedType((JSExpression)newExpression);
    }

    @java.lang.Deprecated
    @Deprecated(message="JSEvaluateContext.JSEvaluationPlace is deprecated", replaceWith=@ReplaceWith(expression="evaluateCallExpressionTypes(callExpression)", imports={}))
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression, @NotNull JSEvaluateContext.JSEvaluationPlace place) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(54);
        }
        if (place == null) {
            JSTypeEvaluator.$$$reportNull$$$0(55);
        }
        this.evaluateCallExpressionTypes(callExpression);
    }

    protected void evaluateCallExpressionTypes(@NotNull JSCallExpression callExpression) {
        JSClass jsClass;
        JSFunction parentFunction;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(56);
        }
        if (callExpression instanceof JSNewExpression) {
            this.evaluateNewExpressionTypes((JSNewExpression)callExpression);
            return;
        }
        if (!this.myContext.isAstAccessAllowed((PsiElement)callExpression)) {
            JSExpression methodExpression = callExpression.getStubSafeMethodExpression();
            if (methodExpression != null) {
                JSApplyCallType type = new JSApplyCallType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)methodExpression, this.myContext), JSTypeSourceFactory.createTypeSource((PsiElement)callExpression, true));
                this.addType(type, null);
            }
            return;
        }
        JSExpression methodExpression = callExpression.getMethodExpression();
        if (methodExpression instanceof JSReferenceExpression) {
            boolean isTypeScript;
            JSReferenceExpression invoked = (JSReferenceExpression)methodExpression;
            String referencedName = invoked.getReferenceName();
            DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)callExpression);
            boolean bl = isTypeScript = dialect != null && dialect.isTypeScript;
            if ("create".equals(referencedName) && dialect != null && dialect.isJavaScript()) {
                boolean processed = this.processCreateMethodCall(callExpression, invoked);
                if (processed) {
                    return;
                }
            } else if (!isTypeScript && ("apply".equals(referencedName) || "call".equals(referencedName))) {
                methodExpression = this.processApplyOrCallMethodCall(methodExpression, invoked);
            } else if (!isTypeScript && ("reduce".equals(referencedName) || "reduceRight".equals(referencedName))) {
                methodExpression = JSTypeEvaluator.processReduceMethodCall(methodExpression, invoked);
            } else {
                if (!this.processRequireMethodCall(callExpression)) {
                    return;
                }
                if (JSGclReferenceContributor.isGoogRequireCall(methodExpression)) {
                    this.addTypeFromGclRequireCall(callExpression);
                    return;
                }
            }
        }
        if (methodExpression instanceof JSSuperExpression && !DialectDetector.isTypeScript((PsiElement)callExpression) && (parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)methodExpression)) != null && parentFunction.isConstructor() && (jsClass = JSResolveUtil.getClassOfContext((PsiElement)parentFunction)) != null) {
            this.addType(jsClass.getJSType(), (PsiElement)callExpression);
        }
        if (methodExpression != null) {
            JSApplyCallType type = new JSApplyCallType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)methodExpression, this.myContext), JSTypeSourceFactory.createTypeSource((PsiElement)callExpression, true));
            this.addType(type, null);
        }
    }

    private void addTypeFromGclRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(57);
        }
        JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(DialectDetector.isTypeScript((PsiElement)callExpression)));
        boolean resolvedToModule = false;
        JSGclModuleReference reference = JSGclReferenceContributor.getGclModuleReference(callExpression);
        if (reference != null) {
            ResolveResult[] results;
            for (ResolveResult result2 : results = reference.multiResolve(false)) {
                PsiFile file2;
                PsiElement element = result2.getElement();
                if (!(element instanceof JSImplicitElement) || !"gcl".equals(((JSImplicitElement)element).getUserString()) || !((file2 = element.getContainingFile()) instanceof JSFile)) continue;
                resolvedToModule = true;
                this.addTypeFromExternalModuleReferenceResolveResult((PsiElement)file2);
                List<JSPsiElementBase> exportsList = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit("exports", file2);
                if (exportsList.size() != 1) continue;
                JSPsiElementBase exportElement = (JSPsiElementBase)exportsList.iterator().next();
                JSTypeEvaluator.processWithEvaluationGuard((PsiElement)exportElement, this.myContext, () -> {
                    this.addTypeFromResolveResult((PsiElement)exportElement);
                    return null;
                });
            }
            if (!resolvedToModule) {
                JSQualifiedName qName = reference.getQualifiedName();
                JSNamespace namespace = JSNamedTypeFactory.createNamespace(qName, JSContext.STATIC, reference.getElement(), true);
                this.addNamespace(namespace, reference.getElement());
            }
        }
        this.finishEvaluationWithContext(previousContext);
    }

    protected boolean processRequireMethodCall(@NotNull JSCallExpression callExpression) {
        String value;
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(58);
        }
        if (!callExpression.isRequireCall() || !this.getEvaluateContext().isAstAccessAllowed((PsiElement)callExpression)) {
            return true;
        }
        if (JSAmdPsiUtil.isWithinAmdModule((PsiElement)callExpression)) {
            JSLiteralExpression amdModuleReference = (JSLiteralExpression)callExpression.getArguments()[0];
            Collection<PsiElement> modules = CommonJSUtil.findReferencedModulesIfRequireCall(callExpression);
            if (!modules.isEmpty() && modules.size() <= JSRequireCallExpressionType.MAX_MODULES_TO_EVALUATE) {
                for (PsiElement module : modules) {
                    this.addTypeFromAmdModule(amdModuleReference, module);
                }
            }
            return true;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression && (value = ((JSLiteralExpression)arguments[0]).getStringValue()) != null) {
            boolean isJavaScript = DialectDetector.isJavaScript((PsiElement)callExpression);
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)callExpression, isJavaScript);
            JSRequireCallExpressionType type = new JSRequireCallExpressionType(value, typeSource);
            if (isJavaScript) {
                this.addType(type, null);
                return false;
            }
            this.runWithContext(this.myContext.withCombinedStrictness(false), () -> this.addType(type, null));
            return CommonJSUtil.findReferencedModulesIfRequireCall(callExpression).isEmpty();
        }
        return true;
    }

    private static JSExpression processReduceMethodCall(JSExpression methodExpression, JSReferenceExpression invoked) {
        Optional first;
        JSExpression qualifier = invoked.getQualifier();
        if (qualifier instanceof JSArrayLiteralExpression && (first = ((JSArrayLiteralExpression)qualifier).getExpressionStream().findFirst()).isPresent()) {
            return (JSExpression)first.get();
        }
        return methodExpression;
    }

    private JSExpression processApplyOrCallMethodCall(@NotNull JSExpression methodExpression, @NotNull JSReferenceExpression invoked) {
        JSExpression qualifier;
        if (methodExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(59);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(60);
        }
        if ((qualifier = invoked.getQualifier()) != null) {
            Ref referencesLib = Ref.create((Object)false);
            JSTypeEvaluator.processWithEvaluationGuard((PsiElement)qualifier, this.myContext, () -> {
                ResolveResult[] results;
                for (ResolveResult result2 : results = invoked.multiResolve(false)) {
                    String fileName;
                    PsiElement element = result2.getElement();
                    if (element == null || !"ECMAScript.js2".equals(fileName = element.getContainingFile().getName()) && !JSCorePredefinedLibrariesProvider.isECMAScriptLibraryFileName(fileName)) continue;
                    referencesLib.set((Object)true);
                    break;
                }
                return null;
            });
            if (((Boolean)referencesLib.get()).booleanValue()) {
                return qualifier;
            }
        }
        return methodExpression;
    }

    private boolean processCreateMethodCall(@NotNull JSCallExpression callExpression, @NotNull JSReferenceExpression invoked) {
        if (callExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(61);
        }
        if (invoked == null) {
            JSTypeEvaluator.$$$reportNull$$$0(62);
        }
        Ref processed = Ref.create((Object)false);
        JSTypeEvaluator.processWithEvaluationGuard((PsiElement)invoked, this.myContext, () -> {
            JSType type;
            JSFunctionItem functionItem;
            JSExpression firstArgument;
            JSExpression[] arguments = callExpression.getArguments();
            JSExpression jSExpression = firstArgument = arguments.length > 0 ? arguments[0] : null;
            if (JSSymbolUtil.isAccurateReferenceExpressionName(invoked, "Object", "create")) {
                JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(false));
                this.evaluateTypes(firstArgument);
                this.finishEvaluationWithContext(previousContext);
                processed.set((Object)true);
                return null;
            }
            boolean hasExplicitReturnType = false;
            PsiElement resolve = invoked.resolve();
            if (resolve != null && (functionItem = JSPsiImplUtils.calculatePossibleFunction(resolve, (PsiElement)invoked, true)) != null && JSTypeUtils.isStrictType(type = functionItem.getReturnType())) {
                hasExplicitReturnType = true;
            }
            if (!hasExplicitReturnType && (firstArgument instanceof JSLiteralExpression && ((JSLiteralExpression)firstArgument).isQuotedLiteral() || firstArgument instanceof JSReferenceExpression)) {
                String typeString;
                String string = typeString = firstArgument instanceof JSReferenceExpression ? JSQualifiedNameImpl.toString(JSSymbolUtil.getAccurateReferenceName((PsiQualifiedReference)((JSReferenceExpression)firstArgument))) : ((JSLiteralExpression)firstArgument).getStringValue();
                if (typeString != null) {
                    type = JSNamedTypeFactory.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)firstArgument, false), JSTypeContext.UNKNOWN);
                    this.addType(type, (PsiElement)firstArgument);
                }
                processed.set((Object)true);
            }
            return null;
        });
        return Boolean.TRUE.equals(processed.get());
    }

    public final void addTypeFromExternalModuleReferenceResolveResult(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        this.addTypeFromExternalModuleReferenceResolveResult(element, false);
    }

    public void addTypeFromExternalModuleReferenceResolveResult(@NotNull PsiElement resolve, boolean fromRequire) {
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(63);
        }
        if (resolve instanceof JSFile) {
            this.addType(new JSModuleTypeImpl((JSFile)resolve, fromRequire), null);
        } else {
            this.addTypeFromResolveResult(resolve);
        }
    }

    @NotNull
    public JSEvaluateContext getEvaluateContext() {
        JSEvaluateContext jSEvaluateContext = this.myContext;
        if (jSEvaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(64);
        }
        return jSEvaluateContext;
    }

    protected void runWithContext(@NotNull JSEvaluateContext context, @NotNull Runnable runnable) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(65);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(66);
        }
        JSEvaluateContext previousContext = this.myContext;
        this.myContext = context;
        runnable.run();
        this.myContext = previousContext;
    }

    @NotNull
    public JSEvaluateContext startEvaluationWithContext(@NotNull JSEvaluateContext context) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(67);
        }
        JSEvaluateContext previousContext = this.myContext;
        this.myContext = context;
        JSEvaluateContext jSEvaluateContext = previousContext;
        if (jSEvaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(68);
        }
        return jSEvaluateContext;
    }

    public void finishEvaluationWithContext(@NotNull JSEvaluateContext previousContext) {
        if (previousContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(69);
        }
        this.myContext = previousContext;
    }

    protected boolean processFunction(@NotNull JSFunction function2) {
        if (function2 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(70);
        }
        if (!this.myContext.isAstAccessAllowed((PsiElement)function2, true)) {
            this.addType((JSType)TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function2), (PsiElement)function2);
            this.addTypeFromLocalName((PsiNamedElement)function2);
            return true;
        }
        if (function2.isGetProperty()) {
            JSType returnType = JSFunctionImpl.getReturnTypeInContext((JSFunctionItem)function2, (PsiElement)this.myContext.getProcessedExpression(), this.getContextualExpectedTypeKind());
            if (returnType != null) {
                this.addType(returnType, null);
            }
        } else if (function2.isSetProperty()) {
            JSType parameterType = JSResolveUtil.getTypeFromSetAccessor((JSFunctionItem)function2);
            if (parameterType != null) {
                this.addType(parameterType, null);
            }
        } else {
            JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)function2, false);
            if (source.isTypeScript()) {
                JSFunctionType type = TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function2);
                if (function2 instanceof JSOptionalOwner && ((JSOptionalOwner)function2).isOptional()) {
                    type = TypeScriptTypeGuard.wrapWithUndefined((JSType)type, type.getSource());
                }
                this.addType((JSType)type, (PsiElement)function2);
            } else if (source.isJavaScript()) {
                JSExpression returnedExpression;
                JSType functionType = JSApplyNewType.getTypeFromConstructorName(function2, this.myContext, false, false);
                if (functionType == null && this.myContext.isAstAccessAllowed((PsiElement)function2) && (returnedExpression = JSPsiImplUtils.getReturnedExpressionIfSingle(function2)) != null) {
                    JSType type = JSCodeBasedTypeFactory.getCodeBasedType(returnedExpression, true, this.myContext.isContextualOverloadEvaluation());
                    functionType = TypeScriptTypeParser.buildFunctionTypeWithCustomReturnType((JSFunctionItem)function2, type);
                }
                if (functionType == null) {
                    functionType = TypeScriptTypeParser.buildFunctionType((JSFunctionItem)function2);
                }
                this.addType(functionType, (PsiElement)function2);
            } else {
                this.addType(JSNamedTypeFactory.createFunctionType(source), (PsiElement)function2);
            }
        }
        return true;
    }

    private void processRefExpr(@NotNull JSReferenceExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(71);
        }
        new JSReferenceExpressionType(expression).evaluate(this.myContext).applyWithContext(this.myTypeProcessor, this.myContext);
    }

    public boolean addTypeFromResolveResult(String referenceName, ResolveResult resolveResult) {
        PsiElement element = resolveResult.getElement();
        if (element == null) {
            return true;
        }
        this.addTypeFromResolveResult(element);
        this.addLocalNamespaceFromImport(referenceName, resolveResult);
        return true;
    }

    protected void addLocalNamespaceFromImport(String referenceName, ResolveResult r) {
        ES6ImportExportDeclarationPart anImport;
        if (r instanceof JSResolveResult && (anImport = ((JSResolveResult)r).getES6Import()) instanceof ES6ImportExportSpecifier && Objects.equals(referenceName, anImport.getDeclaredName())) {
            JSNamespace nsFromImport = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create(referenceName, null), JSContext.STATIC, (PsiElement)anImport, true, true, true);
            this.addAdditionalType((JSType)nsFromImport, (PsiElement)anImport);
        }
    }

    public void addTypeFromElement(@NotNull PsiElement element) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(72);
        }
        if (element instanceof JSExpression && JSTypeEvaluator.isEvaluatedAsExpression((JSExpression)element)) {
            this.evaluateTypes((JSExpression)element);
        } else {
            this.addTypeFromResolveResult(element);
        }
    }

    public final void addTypeFromResolveResult(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(73);
        }
        if (resolveResult instanceof JSArrayLiteralExpression) {
            return;
        }
        this.addType(JSCodeBasedTypeFactory.getPsiBasedType(resolveResult, this.myContext), null);
    }

    private void doAddTypeFromResolveResult(@NotNull PsiElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(74);
        }
        this.startEvaluationWithContext(this.myContext.withSource(resolveResult));
        if (resolveResult instanceof TypeScriptProxyImplicitElementWithBackingItem) {
            resolveResult = ((TypeScriptProxyImplicitElementWithBackingItem)resolveResult).getBackingElement();
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
            if (!(handler.addTypeFromResolveResult(this, this.myContext, resolveResult) | handler.addTypeFromResolveResult(this, resolveResult, false))) continue;
            return;
        }
        JSType alias = JSTypeEvaluator.findAliasTypeFromDocComment(resolveResult);
        if (alias != null) {
            this.addType(alias, null);
        }
        if (resolveResult instanceof JSFieldVariable) {
            this.addTypeFromVariableResolveResult((JSFieldVariable)resolveResult);
        } else {
            this.addTypeFromElementResolveResult(resolveResult);
        }
    }

    @Nullable
    public static JSType findAliasTypeFromDocComment(@NotNull PsiElement resolveResult) {
        String alias;
        JSDocComment docComment;
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(75);
        }
        if ((docComment = JSStubBasedPsiTreeUtil.findOwnDocComment(resolveResult)) != null && (alias = docComment.getAlias()) != null) {
            return JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.fromQualifiedName(alias), JSContext.STATIC, (PsiElement)docComment);
        }
        return null;
    }

    protected void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(76);
        }
        this.addTypeFromVariableResolveResult(jsVariable, jsVariable.getJSType());
    }

    public void addTypeFromVariableResolveResult(@NotNull JSFieldVariable jsVariable, @Nullable JSType variableType) {
        JSNamespace namespace;
        boolean useVariableType;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(77);
        }
        if (jsVariable instanceof JSParameter) {
            if (variableType == null && this.myContext.isAstAccessAllowed((PsiElement)jsVariable) && this.addTypeFromAmdModuleReference((JSParameter)jsVariable)) {
                return;
            }
            variableType = this.processParameterType((JSParameter)jsVariable, variableType);
        }
        if ((useVariableType = this.useVariableType(variableType)) && variableType.isJavaScript() && !JSTypeEvaluator.isAcceptableInitializerType(variableType) && this.myContext.isAstAccessAllowed((PsiElement)jsVariable)) {
            useVariableType = false;
        }
        if (useVariableType) {
            this.addType(variableType, EXPLICIT_TYPE_MARKER_ELEMENT);
        } else if (this.myContext.isAstAccessAllowed((PsiElement)jsVariable)) {
            if ((variableType = this.addTypeFromVariableInitializer(jsVariable, variableType)) == null) {
                this.addTypeForAutoTypeVariable(jsVariable);
            }
        } else {
            JSExpression initializer = jsVariable.getInitializerOrStub();
            if (initializer != null) {
                JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withAstAccessForbidden());
                this.evaluateTypes(initializer);
                this.finishEvaluationWithContext(previousContext);
            }
        }
        if ((!useVariableType || variableType instanceof JSCodeBasedType && variableType.isJavaScript() || JSTypeUtils.isNewPropertiesDefinitionAllowed(variableType, false) || this.definesConstructor(jsVariable, variableType)) && (namespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)jsVariable, false)) != null) {
            this.addNamespace(namespace, (PsiElement)jsVariable);
        }
    }

    private void addTypeForAutoTypeVariable(@NotNull JSFieldVariable variable) {
        if (variable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(78);
        }
        if (JSTypeGuardUtil.isAutoTypeField((PsiElement)variable)) {
            JSType typeFromGuard = JSTypeGuardEvaluator.applyToResolveResultType(null, (PsiElement)variable, this.myContext);
            this.addType(Objects.requireNonNullElseGet(typeFromGuard, () -> JSAnyType.get((PsiElement)variable, true)), (PsiElement)variable);
        }
    }

    private boolean definesConstructor(@NotNull JSFieldVariable jsVariable, @Nullable JSType variableType) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(79);
        }
        if (variableType == null || !variableType.isSourceStrict()) {
            return false;
        }
        JSReferenceExpression processedExpression = this.myContext.getProcessedExpression();
        return processedExpression != null && DialectDetector.isJavaScript((PsiElement)processedExpression) && JSTypeUtils.hasFunctionType(variableType, true, (PsiElement)jsVariable);
    }

    @Nullable
    private JSType addTypeFromVariableInitializer(@NotNull JSFieldVariable jsVariable, @Nullable JSType variableType) {
        JSDestructuringContext destructuringContext;
        JSInitializerOwner initializerOwner;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(80);
        }
        JSExpression initializer = (initializerOwner = (destructuringContext = this.findDestructuringParents(jsVariable)).getOuterElement()) != null ? (JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(initializerOwner.getContainingFile(), () -> initializerOwner.getInitializer()) : null;
        JSReferenceExpression expression = this.myContext.getProcessedExpression();
        boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)jsVariable);
        if (isTypeScript && initializerOwner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)initializerOwner).getTypeElement() != null) {
            JSType type = ((JSTypeDeclarationOwner)initializerOwner).getJSType();
            this.addType(destructuringContext.applyToOuterType(type), (PsiElement)initializerOwner);
        } else if (initializer != null) {
            JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(!(jsVariable instanceof JSVariable) || JSVariableBaseImpl.isStrictVariableInitializer((JSVariable)jsVariable)));
            JSTypeWithContext typeFromInitializer = this.getTypeFromInitializer(initializer);
            if (typeFromInitializer != null) {
                PsiElement source = typeFromInitializer.isExplicit() ? EXPLICIT_TYPE_MARKER_ELEMENT : null;
                this.addType(destructuringContext.applyToOuterType(typeFromInitializer.getJSType()), source);
            }
            this.finishEvaluationWithContext(previousContext);
        } else if (variableType == null && jsVariable instanceof JSVariable && JSTypeEvaluator.isForStatementDeclaration((JSVariable)jsVariable)) {
            PsiElement forOf = JSResolveUtil.findParent((PsiElement)jsVariable);
            List<JSType> types2 = this.getLoopVariableTypes(expression, (PsiElement)jsVariable, (JSForInStatement)forOf);
            for (JSType type : types2) {
                this.addType(destructuringContext.applyToOuterType(type), null);
            }
            variableType = (JSType)ContainerUtil.getFirstItem(types2);
        } else if (variableType != null) {
            this.addType(variableType, null);
        }
        return variableType;
    }

    @Nullable
    private JSType processParameterType(@NotNull JSParameter jsVariable, JSType variableType) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(81);
        }
        if (variableType == null && this.myContext.isAstAccessAllowed((PsiElement)jsVariable)) {
            variableType = JSContextTypeEvaluator.getParameterType((JSParameterListElement)jsVariable, this.myContext, this.getContextualExpectedTypeKind());
        }
        if (jsVariable.isRest()) {
            if (!(variableType instanceof JSRestTypeImpl)) {
                JSTypeSource typeSource = variableType != null && variableType.getSourceElement() != null ? variableType.getSource() : JSTypeSourceFactory.createTypeSource((PsiElement)jsVariable, jsVariable.getTypeDecorator().isExplicitlyDeclared());
                variableType = new JSArrayTypeImpl(variableType, typeSource);
            } else {
                variableType = ((JSRestTypeImpl)variableType).getIterableType();
            }
        }
        return this.substituteThisType(variableType, (JSFieldVariable)jsVariable);
    }

    private static boolean isAcceptableInitializerType(@Nullable JSType variableType) {
        return variableType != null && (!(variableType instanceof JSCodeBasedType) || variableType instanceof JSRequireCallExpressionType || variableType instanceof JSStubBasedExpressionType || variableType instanceof JSApplyIndexedAccessType || variableType instanceof JSReferenceType);
    }

    @NotNull
    protected JSDestructuringContext findDestructuringParents(@NotNull JSFieldVariable jsVariable) {
        JSDestructuringContext context;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(82);
        }
        if (DialectDetector.isTypeScript((PsiElement)jsVariable) && (context = JSDestructuringContext.findDestructuringParents((PsiElement)jsVariable, WITH_TYPE_DECLARATION_PREDICATE)).getOuterElement() != null) {
            JSDestructuringContext jSDestructuringContext = context;
            if (jSDestructuringContext == null) {
                JSTypeEvaluator.$$$reportNull$$$0(83);
            }
            return jSDestructuringContext;
        }
        JSDestructuringContext jSDestructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)jsVariable, JSInitializerOwner::hasOwnInitializer);
        if (jSDestructuringContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(84);
        }
        return jSDestructuringContext;
    }

    private static boolean isForStatementDeclaration(@NotNull JSVariable jsVariable) {
        PsiElement forOfCandidate;
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(85);
        }
        return (forOfCandidate = JSResolveUtil.findParent((PsiElement)jsVariable)) instanceof JSForInStatement && PsiTreeUtil.isAncestor((PsiElement)((JSForInStatement)forOfCandidate).getVarDeclaration(), (PsiElement)jsVariable, (boolean)true);
    }

    @Nullable
    private JSTypeWithContext getTypeFromInitializer(@Nullable JSExpression initializer) {
        if (initializer == null) {
            return null;
        }
        if (DialectDetector.isTypeScript((PsiElement)initializer)) {
            JSType contextType = this.getExpressionTypeInContext(initializer);
            if (contextType != null) {
                return new JSTypeWithContext(contextType, true);
            }
            return null;
        }
        JSType type = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)initializer, this.myContext);
        if (JSTypeEvaluator.isEmptyJSObjectLiteral(initializer)) {
            type = type.copyWithStrict(false);
        }
        return new JSTypeWithContext(type, false);
    }

    public static boolean isEmptyJSObjectLiteral(@NotNull JSExpression initializer) {
        if (initializer == null) {
            JSTypeEvaluator.$$$reportNull$$$0(86);
        }
        return DialectDetector.isJavaScript((PsiElement)initializer) && initializer instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)initializer).isEmpty();
    }

    private void evaluateDestructuringContainer(@NotNull JSDestructuringContainer destructuringContainer) {
        JSType type;
        JSDestructuringContext destructuringContext;
        JSInitializerOwner owner;
        if (destructuringContainer == null) {
            JSTypeEvaluator.$$$reportNull$$$0(87);
        }
        if ((owner = (destructuringContext = JSDestructuringContext.findDestructuringParents((PsiElement)destructuringContainer, e -> e.hasOwnInitializer() || JSTypeEvaluator.isApplicableTypeDeclaration(e) || e instanceof JSParameterListElement)).getOuterElement()) == null) {
            return;
        }
        JSType typeFromDestructuringInLoop = this.getTypeFromDestructuringInLoop(owner);
        if (typeFromDestructuringInLoop != null) {
            this.addType(destructuringContext.applyToOuterType(typeFromDestructuringInLoop), (PsiElement)owner);
            return;
        }
        if (WITH_TYPE_DECLARATION_PREDICATE.test(owner) && (type = ((JSTypeDeclarationOwner)owner).getJSType()) != null) {
            this.addType(destructuringContext.applyToOuterType(type), (PsiElement)owner);
        }
        if (owner.hasOwnInitializer()) {
            JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withCombinedStrictness(owner instanceof JSTypeDeclarationOwner && ((JSTypeDeclarationOwner)owner).getJSType() instanceof JSDestructuringTypeImpl));
            JSTypeWithContext typeFromInitializer = this.getTypeFromInitializer((JSExpression)JSStubBasedPsiTreeUtil.forceAllowTreeLoading(owner.getContainingFile(), () -> owner.getInitializer()));
            if (typeFromInitializer != null) {
                PsiElement source = typeFromInitializer.isExplicit() ? EXPLICIT_TYPE_MARKER_ELEMENT : owner.getInitializer();
                this.addType(destructuringContext.applyToOuterType(typeFromInitializer.getJSType()), source);
            }
            this.finishEvaluationWithContext(previousContext);
        }
        if (owner instanceof JSParameterListElement) {
            JSType parameterType;
            if (destructuringContext.isEmpty()) {
                for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.getIndexingHandlers()) {
                    if (!handler.addTypeFromResolveResult(this, this.myContext, (PsiElement)owner)) continue;
                    return;
                }
            }
            if ((parameterType = JSContextTypeEvaluator.getParameterType((JSParameterListElement)owner, this.myContext, JSExpectedTypeKind.EXPECTED)) != null) {
                this.addType(destructuringContext.applyToOuterType(parameterType), (PsiElement)owner);
            }
        }
    }

    @Nullable
    private JSType getTypeFromDestructuringInLoop(JSInitializerOwner owner) {
        PsiElement parent = owner.getParent();
        if (!(parent instanceof JSVarStatement)) {
            return null;
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof JSForInStatement) || !((JSForInStatement)grandParent).isForEach()) {
            return null;
        }
        JSExpression expression = ((JSForInStatement)grandParent).getCollectionExpression();
        if (expression == null) {
            return null;
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource((PsiElement)owner, true);
        JSType expressionType = JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)expression, this.myContext);
        return new JSIterableComponentTypeImpl(expressionType, source);
    }

    private static boolean isApplicableTypeDeclaration(JSInitializerOwner e) {
        if (!(e instanceof JSTypeDeclarationOwner)) {
            return false;
        }
        if (WITH_TYPE_DECLARATION_PREDICATE.test(e)) {
            return true;
        }
        PsiElement parent = e.getParent();
        if (!(parent instanceof JSVarStatement)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof JSForInStatement && ((JSForInStatement)grandParent).isForEach();
    }

    protected JSType substituteThisType(@Nullable JSType type, @NotNull JSFieldVariable jsVariable) {
        if (jsVariable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(88);
        }
        return type;
    }

    protected boolean addTypeFromAmdModuleReference(@NotNull JSParameter parameter) {
        if (parameter == null) {
            JSTypeEvaluator.$$$reportNull$$$0(89);
        }
        boolean result2 = false;
        if (!this.myContext.isAstAccessAllowed((PsiElement)parameter)) {
            return false;
        }
        JSLiteralExpression amdModuleReference = JSSymbolUtil.getParameterInitializationIfRequireArgument(parameter);
        if (amdModuleReference != null) {
            PsiReference[] references = amdModuleReference.getReferences();
            Collection<PsiElement> modules = JSFileReferencesUtil.getMostPriorityModules((PsiElement)parameter, references);
            for (PsiElement resolve : modules) {
                result2 |= this.addTypeFromAmdModule(amdModuleReference, resolve);
            }
        }
        return result2;
    }

    private boolean addTypeFromAmdModule(@NotNull JSLiteralExpression amdModuleReference, @NotNull PsiElement resolve) {
        if (amdModuleReference == null) {
            JSTypeEvaluator.$$$reportNull$$$0(90);
        }
        if (resolve == null) {
            JSTypeEvaluator.$$$reportNull$$$0(91);
        }
        boolean result2 = false;
        JSFunctionExpression moduleInitializer = null;
        if (resolve instanceof JSFile) {
            JSFunctionExpression amdModule = JSAmdModulesIndex.findDefaultAmdModule((JSFile)resolve);
            if (amdModule != null) {
                moduleInitializer = amdModule;
            } else {
                this.addTypeFromExternalModuleReferenceResolveResult(resolve, true);
            }
            result2 = true;
        } else if (resolve instanceof JSFunctionExpression) {
            moduleInitializer = (JSFunctionExpression)resolve;
            JSType type = JSNamedTypeFactory.createType(JSAmdPsiUtil.unifyModuleName(amdModuleReference), JSTypeSourceFactory.createTypeSource(resolve, true), JSContext.STATIC);
            this.addType(type, EXPLICIT_TYPE_MARKER_ELEMENT);
            result2 = true;
        }
        if (moduleInitializer != null) {
            this.addType(new JSApplyCallType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)moduleInitializer, this.myContext), JSTypeSourceFactory.createTypeSource((PsiElement)amdModuleReference, true)), null);
            this.addExportsNamespace((PsiElement)moduleInitializer);
        }
        return result2;
    }

    private void addExportsNamespace(@NotNull PsiElement source) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(92);
        }
        JSNamespace exportsNamespace = JSNamedTypeFactory.createNamespace(JSQualifiedNameImpl.create("exports", null), JSContext.STATIC, source, true, false, true);
        this.addAdditionalType((JSType)exportsNamespace, null);
    }

    @Contract(value="null->false")
    protected boolean useVariableType(JSType type) {
        return type != null;
    }

    public void evaluateTypes(@Nullable JSExpression expression) {
        if (expression == null) {
            return;
        }
        this.addType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)expression, this.myContext), null);
    }

    public void doEvaluateTypesStubSafely(JSExpression expression) {
        if (expression instanceof JSFunction) {
            this.processFunction((JSFunction)expression);
        } else if (expression instanceof JSCallExpression) {
            this.evaluateCallExpressionTypes((JSCallExpression)expression);
        } else if (expression instanceof JSClassExpression) {
            this.addTypeFromClassExpression((JSClassExpression)expression);
        } else if (expression instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expression, false);
        }
    }

    public void addTypeFromClassExpression(JSClassExpression classExpression) {
    }

    protected void addTypeFromElementResolveResult(@Nullable PsiElement resolveResult) {
        if (resolveResult instanceof TypeScriptMergedTypeImplicitElement) {
            this.addTypeFromMergedElementResolveResult((TypeScriptMergedTypeImplicitElement)resolveResult);
        } else if (resolveResult instanceof JSImplicitElement) {
            JSImplicitElement implicitElement = (JSImplicitElement)resolveResult;
            this.addTypeFromImplicitElementResolveResult(implicitElement);
        } else if (resolveResult instanceof JSProperty) {
            this.addTypeFromProperty((JSProperty)resolveResult);
        } else if (resolveResult instanceof JSClass) {
            this.addTypeFromClassCandidate((JSClass)resolveResult);
        } else if (resolveResult instanceof JSFunction && ((JSFunction)resolveResult).isConstructor() && resolveResult.getContext() instanceof JSClass) {
            this.addTypeFromClassCandidate((JSClass)resolveResult.getContext());
        } else if (resolveResult instanceof JSObjectLiteralExpression) {
            this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)resolveResult, false);
        } else if (resolveResult instanceof JSDefinitionExpression) {
            JSType parameterType = null;
            PsiElement resolveResultParent = resolveResult.getContext();
            if (resolveResultParent instanceof JSForInStatement && resolveResult == ((JSForInStatement)resolveResultParent).getVariableExpression()) {
                List<JSType> types2 = this.getLoopVariableTypes(this.myContext.getProcessedExpression(), resolveResult, (JSForInStatement)resolveResultParent);
                for (JSType type : types2) {
                    this.addType(type, null);
                }
                parameterType = (JSType)ContainerUtil.getFirstItem(types2);
            }
            if (parameterType == null) {
                this.addTypeFromDefExpr((JSDefinitionExpression)resolveResult);
            }
        } else if (resolveResult instanceof JSFunction) {
            this.processFunction((JSFunction)resolveResult);
        } else if (resolveResult instanceof JSNamedElement) {
            String name = JSTypeEvaluator.getElementQName((JSNamedElement)resolveResult);
            if (name != null) {
                JSType jsType = JSNamedTypeFactory.createType(name, JSTypeSourceFactory.createTypeSource(resolveResult, false), JSContext.STATIC);
                this.addType(jsType, resolveResult);
            }
        } else if (resolveResult instanceof JSLiteralExpression) {
            this.addTypeFromLiteralExpression((JSExpression)resolveResult);
        } else if (resolveResult instanceof JsonElement) {
            this.addType(JsonElementType.createJsonElementType((JsonElement)resolveResult, null), null);
        } else if (resolveResult instanceof JSFile) {
            this.addTypeFromExternalModuleReferenceResolveResult(resolveResult);
        } else if (resolveResult instanceof StylesheetFile) {
            this.addType(new JSCustomElementType(resolveResult), null);
        }
    }

    private void addTypeFromImplicitElementResolveResult(@NotNull JSImplicitElement resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(93);
        }
        boolean typeAdded = false;
        if (resolveResult instanceof JSLocalImplicitElementImpl) {
            PsiElement owner = resolveResult.getParent();
            JSType jsType = ((JSTypeOwner)resolveResult).getJSType();
            this.addType(jsType, owner);
            return;
        }
        String typeString = resolveResult.getTypeString();
        if (typeString != null) {
            JSType type = JSTypeUtils.createType(typeString, JSTypeSourceFactory.createTypeSource((PsiElement)resolveResult, true));
            this.addType(type, (PsiElement)resolveResult);
            typeAdded = true;
        }
        JSNamespace namespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromQualifiedNamedElement((JSElementBase)resolveResult), JSContext.STATIC, (PsiElement)resolveResult, resolveResult.isNamespaceExplicitlyDeclared());
        if (!typeAdded && resolveResult.getType().providesNamespace()) {
            this.addType((JSType)namespace, (PsiElement)resolveResult);
        } else {
            this.addNamespace(namespace, (PsiElement)resolveResult);
        }
    }

    private void addTypeFromMergedElementResolveResult(TypeScriptMergedTypeImplicitElement resolveResult) {
        PsiElement explicitElement = resolveResult.getExplicitElement();
        JSType jsType = resolveResult.getJSType();
        if (resolveResult.isOptional() && jsType != null) {
            jsType = TypeScriptTypeGuard.wrapWithUndefined(jsType, jsType.getSource());
        }
        PsiElement source = explicitElement == null ? null : explicitElement.getParent();
        this.addType(jsType, source);
    }

    private void addTypeFromProperty(@NotNull JSProperty property) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(94);
        }
        boolean skipEvaluatingProps = false;
        boolean hasType = false;
        JSType jsType = property.getJSType();
        if (jsType != null) {
            this.addType(jsType, (PsiElement)property);
            hasType = true;
            boolean bl = skipEvaluatingProps = !JSTypeUtils.isNewPropertiesDefinitionAllowed(jsType, false);
        }
        if (!skipEvaluatingProps) {
            JSDocComment docComment;
            JSNamespace type;
            JSFunction functionInitializer = property.tryGetFunctionInitializer();
            JSObjectLiteralExpression objectLiteralExpression = property.getObjectLiteralExpressionInitializer();
            boolean providesNamespace = functionInitializer != null && !functionInitializer.isGetProperty() && !functionInitializer.isSetProperty() || objectLiteralExpression != null;
            boolean isTypeScript = DialectDetector.isTypeScript((PsiElement)property);
            if (!isTypeScript && providesNamespace && (type = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)property, (docComment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)property)) != null && docComment.isClassExplicitly())) != null) {
                this.addNamespace(type, (PsiElement)property);
            }
            if (!hasType) {
                JSExpression value;
                if (functionInitializer != null || objectLiteralExpression != null) {
                    if (functionInitializer != null) {
                        if (functionInitializer == property) {
                            this.processFunction(functionInitializer);
                        } else {
                            this.addType(JSCodeBasedTypeFactory.getPsiBasedType((PsiElement)functionInitializer, this.myContext), null);
                        }
                    } else {
                        this.addTypeFromObjectLiteralExpression(objectLiteralExpression, false);
                    }
                } else if (this.myContext.isFromCurrentFile((PsiElement)property) && (value = property.getValue()) != null) {
                    this.evaluateTypes(value);
                }
            }
        }
    }

    protected void addTypeFromClassCandidate(@NotNull JSClass resolveResult) {
        if (resolveResult == null) {
            JSTypeEvaluator.$$$reportNull$$$0(95);
        }
    }

    @NotNull
    private List<JSType> getLoopVariableTypes(@Nullable JSReferenceExpression expression, @NotNull PsiElement element, @Nullable JSForInStatement forInStatement) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(96);
        }
        if (forInStatement == null) {
            List<JSType> list2 = Collections.emptyList();
            if (list2 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(97);
            }
            return list2;
        }
        if (forInStatement.isForEach()) {
            List<JSType> list3 = this.getComponentTypeFromArrayExpression((JSExpression)expression, forInStatement.getCollectionExpression());
            if (list3 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(98);
            }
            return list3;
        }
        List<JSType> list4 = Collections.singletonList(new JSForInStringType(JSTypeSourceFactory.createTypeSource(element, true), JSTypeContext.INSTANCE));
        if (list4 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(99);
        }
        return list4;
    }

    @Nullable
    public final JSType addComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        List<JSType> types2 = this.getComponentTypeFromArrayExpression(rawqualifier, collectionExpression);
        for (JSType type : types2) {
            this.addType(type, (PsiElement)rawqualifier);
        }
        return types2.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types2) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromArrayExpression(@Nullable JSExpression rawqualifier, @Nullable JSExpression collectionExpression) {
        if (collectionExpression == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(100);
            }
            return list2;
        }
        JSTypeEvaluationResult result2 = this.getTypeEvaluationResultInContext((PsiElement)collectionExpression);
        if (result2 == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(101);
            }
            return list3;
        }
        List<JSEvaluationResultElement> results = result2.getResults();
        JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
        result2.applyToProcessor(processor);
        JSType type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(processor.getType());
        int index = -1;
        JSExpression indexExpression = null;
        if (rawqualifier instanceof JSIndexedPropertyAccessExpression && (indexExpression = ((JSIndexedPropertyAccessExpression)rawqualifier).getIndexExpression()) instanceof JSLiteralExpression && ((JSLiteralExpression)indexExpression).isNumericLiteral()) {
            Object value = ((JSLiteralExpression)indexExpression).getValue();
            assert (value instanceof Double || value instanceof Long || value instanceof BigInteger) : indexExpression.getText();
            if (value instanceof Long && (Long)value >= 0L && (Long)value <= Integer.MAX_VALUE) {
                index = Math.toIntExact((Long)value);
            } else if (value instanceof BigInteger && ((BigInteger)value).compareTo(BigInteger.ZERO) >= 0 && ((BigInteger)value).compareTo(JSLiteralExpressionImpl.INT_MAX_VALUE_AS_BIGINT) <= 0) {
                index = ((BigInteger)value).intValueExact();
            }
        }
        boolean processed = false;
        for (JSEvaluationResultElement element : results) {
            JsonProperty property;
            String propertyName;
            JsonElement jsonElement;
            PsiElement source = element.getSource();
            JSType jsType = element.getType();
            if (source instanceof JSArrayLiteralExpression) {
                JSExpression[] expressions = ((JSArrayLiteralExpression)source).getExpressions();
                if (index >= 0 && index < expressions.length) {
                    this.addTypeFromElementResolveResult((PsiElement)expressions[index]);
                    processed = true;
                } else {
                    for (JSExpression expr : expressions) {
                        if (!(expr instanceof JSObjectLiteralExpression)) continue;
                        this.addTypeFromObjectLiteralExpression((JSObjectLiteralExpression)expr, false);
                        processed = true;
                    }
                }
            }
            JsonElement jsonElement2 = jsonElement = jsType instanceof JsonElementType ? (JsonElement)((JsonElementType)jsType).getElement() : null;
            if (jsonElement instanceof JsonArray) {
                List values = ((JsonArray)jsonElement).getValueList();
                if (index < 0 || index >= values.size()) continue;
                JSType jsonType = JsonElementType.createJsonElementType((JsonElement)values.get(index), (PsiElement)collectionExpression);
                this.addType(jsonType, null);
                processed = true;
                continue;
            }
            if (!(jsonElement instanceof JsonObject) || !(indexExpression instanceof JSLiteralExpression) || (propertyName = ((JSLiteralExpression)indexExpression).getValueAsPropertyName()) == null || (property = ((JsonObject)jsonElement).findProperty(propertyName)) == null) continue;
            JSType jsonType = JsonElementType.createJsonElementType((JsonElement)property, (PsiElement)collectionExpression);
            this.addType(jsonType, null);
            processed = true;
        }
        if (!processed && type instanceof JSTupleType && ((JSTupleType)type).hasTypeByIndex(index)) {
            List<JSType> list4 = Collections.singletonList(((JSTupleType)type).getTypeByIndex(index));
            if (list4 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(102);
            }
            return list4;
        }
        List<JSType> list5 = this.getComponentTypeFromProcessor(rawqualifier, type);
        if (list5 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(103);
        }
        return list5;
    }

    @Nullable
    public final JSType addComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        List<JSType> types2 = this.getComponentTypeFromProcessor(rawqualifier, type);
        for (JSType jsType : types2) {
            if (type == null) continue;
            this.addType(jsType, (PsiElement)rawqualifier);
        }
        return types2.size() == 1 ? (JSType)ContainerUtil.getFirstItem(types2) : null;
    }

    @NotNull
    protected List<JSType> getComponentTypeFromProcessor(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        SmartList result2 = this.getComponentTypeWithExpandingComposite(rawqualifier, type);
        SmartList smartList = result2.isEmpty() ? new SmartList((Object)JSAnyType.get((PsiElement)rawqualifier, false)) : result2;
        if (smartList == null) {
            JSTypeEvaluator.$$$reportNull$$$0(104);
        }
        return smartList;
    }

    @NotNull
    protected final List<JSType> getComponentTypeWithExpandingComposite(@Nullable JSExpression rawqualifier, @Nullable JSType type) {
        if ((type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type)) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(105);
            }
            return list2;
        }
        if (type instanceof JSUnionType) {
            ArrayList<JSType> result2 = new ArrayList<JSType>();
            for (JSType typeOption : ((JSUnionType)type).getTypes()) {
                result2.addAll(this.getComponentTypeFromProcessor(rawqualifier, typeOption));
            }
            ArrayList<JSType> arrayList = result2;
            if (arrayList == null) {
                JSTypeEvaluator.$$$reportNull$$$0(106);
            }
            return arrayList;
        }
        JSTypeSource prevSource = type.getSource();
        if ((type = JSTypeUtils.getIndexableComponentType(type)) == null) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSTypeEvaluator.$$$reportNull$$$0(107);
            }
            return list3;
        }
        type = JSTypeUtils.copyWithStrict(type, prevSource.isStrict() && type.isSourceStrict());
        List<JSType> list4 = Collections.singletonList(type);
        if (list4 == null) {
            JSTypeEvaluator.$$$reportNull$$$0(108);
        }
        return list4;
    }

    protected void addTypeFromLiteralExpression(@NotNull JSExpression rawQualifier) {
        JSType type;
        if (rawQualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(109);
        }
        if ((type = JSTypeEvaluator.getTypeFromConstant(rawQualifier)) != null) {
            this.addType(type, (PsiElement)rawQualifier);
        } else {
            this.setUnknownElement((PsiElement)rawQualifier);
        }
    }

    @Nullable
    public static JSType getTypeFromConstant(@NotNull JSExpression rawqualifier) {
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(110);
        }
        if (rawqualifier instanceof JSEmptyExpression) {
            return JSTypeEvaluator.createConstantNamedType("undefined", rawqualifier);
        }
        String type = JSTypeEvaluator.detectTypeByExpression(rawqualifier);
        if (type == "null" && DialectDetector.isActionScript((PsiElement)rawqualifier)) {
            return JSAnyType.get((PsiElement)rawqualifier, false);
        }
        if (type == "number" && DialectDetector.isActionScript((PsiElement)rawqualifier)) {
            String text = JSTypeEvaluator.getConstantLiteralText(rawqualifier);
            if (text != null && text.indexOf(46) == -1) {
                return JSTypeEvaluator.createConstantNamedType("int", rawqualifier);
            }
            return JSTypeEvaluator.createConstantNamedType(type, rawqualifier);
        }
        if (type == "number" && JSTypeEvaluator.isBigIntLiteral(rawqualifier)) {
            type = "bigint";
        }
        if ((type == "XMLList" || type == "XML") && (DialectDetector.isTypeScript((PsiElement)rawqualifier) || DialectDetector.isJSX((PsiElement)rawqualifier))) {
            return null;
        }
        if (type == "string" || DialectDetector.isTypeScript((PsiElement)rawqualifier) && (type == "number" || type == "boolean" || type == "bigint")) {
            Number literal;
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
            if (type == "string" && !DialectDetector.isTypeScript((PsiElement)rawqualifier) && rawqualifier.getTextLength() > 4096) {
                return new JSStringType(true, typeSource, JSTypeContext.INSTANCE);
            }
            if (rawqualifier instanceof JSStringTemplateExpression && DialectDetector.isTypeScript((PsiElement)rawqualifier) && JSWidenType.isConstContext((PsiElement)rawqualifier) && ((JSStringTemplateExpression)rawqualifier).getExpressionKind(false) == JSLiteralExpressionKind.TEMPLATE_WITH_ARGS) {
                return null;
            }
            String literalText = JSTypeEvaluator.getConstantLiteralText(rawqualifier);
            if (type == "string" && literalText != null) {
                return new JSStringLiteralTypeImpl(literalText, true, typeSource);
            }
            if (literalText == null) {
                literalText = "";
            }
            if (type == "boolean" && ("true".equals(literalText) || "false".equals(literalText))) {
                return new JSBooleanLiteralTypeImpl("true".equals(literalText), true, typeSource);
            }
            if (type == "number" && literalText.length() > 0 && (literal = JSNumberParser.tryParseNumericValue(literalText, true)) != null) {
                return new JSNumberLiteralTypeImpl((Double)literal, true, typeSource, literalText);
            }
            if (type == "bigint" && literalText.length() > 0 && (literal = JSNumberParser.tryParseBigInt(literalText)) != null) {
                return new JSBigIntLiteralTypeImpl((BigInteger)literal, true, typeSource, literalText);
            }
        }
        return type != null ? JSTypeEvaluator.createConstantNamedType(type, rawqualifier) : null;
    }

    private static boolean isBigIntLiteral(@NotNull JSExpression rawqualifier) {
        IElementType sign;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(111);
        }
        if (rawqualifier instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)rawqualifier).getOperationSign()) == JSTokenTypes.PLUS || sign == JSTokenTypes.MINUS)) {
            rawqualifier = ((JSPrefixExpression)rawqualifier).getExpression();
        }
        return rawqualifier instanceof JSLiteralExpression && ((JSLiteralExpression)rawqualifier).isBigInteger() && DialectDetector.hasFeature((PsiElement)rawqualifier, JSLanguageFeature.BIG_INT);
    }

    @NotNull
    private static JSType createConstantNamedType(@NotNull String name, @NotNull JSExpression rawqualifier) {
        if (name == null) {
            JSTypeEvaluator.$$$reportNull$$$0(112);
        }
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(113);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)rawqualifier, true);
        JSType jSType = JSNamedTypeFactory.createType(name, typeSource, JSContext.INSTANCE);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(114);
        }
        return jSType;
    }

    @Nullable
    private static String detectTypeByExpression(@NotNull JSExpression rawqualifier) {
        ASTNode childNode;
        IElementType constantType;
        if (rawqualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(115);
        }
        if (rawqualifier instanceof JSPrefixExpression && JSSymbolUtil.isLiteralOrLiteralWithSign(rawqualifier)) {
            return "number";
        }
        if (rawqualifier instanceof JSLiteralExpression) {
            JSLiteralExpressionKind kind = ((JSLiteralExpression)rawqualifier).getExpressionKind(false);
            switch (kind) {
                case QUOTED: 
                case TEMPLATE_NO_ARGS: 
                case TEMPLATE_WITH_ARGS: {
                    return "string";
                }
                case REGEXP: {
                    return "RegExp";
                }
                case TRUE: 
                case FALSE: {
                    return "boolean";
                }
                case NULL: {
                    return "null";
                }
            }
            if (kind.isNumeric()) {
                return "number";
            }
            if (kind != JSLiteralExpressionKind.XML) {
                return null;
            }
        }
        IElementType iElementType = constantType = (childNode = rawqualifier.getNode().getFirstChildNode()) != null ? childNode.getElementType() : null;
        return constantType == JSTokenTypes.XML_START_TAG_START ? "XML" : (constantType == JSTokenTypes.XML_START_TAG_LIST ? "XMLList" : (constantType == JSTokenTypes.UNDEFINED_KEYWORD && !DialectDetector.isActionScript((PsiElement)rawqualifier) ? "undefined" : null));
    }

    @Nullable
    private static String getConstantLiteralText(@NotNull JSExpression jsExpression) {
        String value;
        if (jsExpression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(116);
        }
        String prefix = null;
        if (jsExpression instanceof JSPrefixExpression) {
            IElementType sign = ((JSPrefixExpression)jsExpression).getOperationSign();
            if (sign == JSTokenTypes.MINUS) {
                prefix = "-";
            }
            jsExpression = ((JSPrefixExpression)jsExpression).getExpression();
        }
        if (jsExpression == null) {
            return null;
        }
        if (jsExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)jsExpression).getStringValue()) != null) {
            return value;
        }
        if (jsExpression instanceof JSStringTemplateExpression && ((JSStringTemplateExpression)jsExpression).getArguments().length > 0) {
            return null;
        }
        ASTNode node = jsExpression.getNode();
        ASTNode childNode = node.getFirstChildNode();
        String text = childNode.getText();
        if (prefix != null && text.length() > 0) {
            return prefix + text;
        }
        return text;
    }

    public static boolean addAdditionalTypes(@NotNull PsiElement context, @NotNull JSReferenceItem qualifier, @NotNull JSTypeProcessor processor, @NotNull JSEvaluateContext evaluateContext) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(117);
        }
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(118);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(119);
        }
        if (evaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(120);
        }
        JSEvaluationTask types2 = JSTypeEvaluator.getAdditionalTypes(context, qualifier, evaluateContext);
        types2.applyWithContext(processor, evaluateContext);
        return types2 != JSEvaluationTasks.EMPTY;
    }

    @NotNull
    public static JSEvaluationTask getAdditionalTypes(@NotNull PsiElement context, @NotNull JSReferenceItem qualifier, @NotNull JSEvaluateContext evaluateContext) {
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(121);
        }
        if (qualifier == null) {
            JSTypeEvaluator.$$$reportNull$$$0(122);
        }
        if (evaluateContext == null) {
            JSTypeEvaluator.$$$reportNull$$$0(123);
        }
        if (DialectDetector.isTypeScript(context) || DialectDetector.isActionScript(context)) {
            JSEvaluationTaskList jSEvaluationTaskList = JSEvaluationTasks.EMPTY;
            if (jSEvaluationTaskList == null) {
                JSTypeEvaluator.$$$reportNull$$$0(124);
            }
            return jSEvaluationTaskList;
        }
        JSReferenceItem topmostQualifier = qualifier instanceof JSReferenceExpression ? JSUtils.findRefExprThatStartCallChaining((JSReferenceExpression)qualifier) : qualifier;
        ArrayList<JSEvaluationTask> types2 = new ArrayList<JSEvaluationTask>(2);
        if (JSSymbolUtil.isAccurateReferenceExpressionName(topmostQualifier, "$") || JSSymbolUtil.isAccurateReferenceExpressionName(topmostQualifier, JQUERY_NS) || JSSymbolUtil.isAccurateReferenceExpressionName(topmostQualifier, JQUERY_NS, "$")) {
            types2.add(new JSEvaluationResultElement(JSTypeEvaluator.getJQueryType(context), false, context, evaluateContext));
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(qualifier, "$") || JSSymbolUtil.isAccurateReferenceExpressionName(qualifier, JQUERY_NS)) {
            JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(context, false);
            JSType htmlElementType = JSNamedTypeFactory.createType("HTMLElement", typeSource, JSContext.UNKNOWN);
            types2.add(new JSEvaluationResultElement(htmlElementType, false, context, evaluateContext));
        }
        JSEvaluationTask jSEvaluationTask = JSEvaluationTasks.fromList(types2);
        if (jSEvaluationTask == null) {
            JSTypeEvaluator.$$$reportNull$$$0(125);
        }
        return jSEvaluationTask;
    }

    @NotNull
    public static JSType getJQueryType(@NotNull PsiElement source) {
        if (source == null) {
            JSTypeEvaluator.$$$reportNull$$$0(126);
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(source, false);
        JSType jSType = JSNamedTypeFactory.createType(JQUERY_NS, typeSource, JSContext.UNKNOWN);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(127);
        }
        return jSType;
    }

    @Nullable
    private static String getElementQName(JSNamedElement psiElement) {
        String name = null;
        if (psiElement instanceof JSQualifiedNamedElement) {
            name = ((JSQualifiedNamedElement)psiElement).getQualifiedName();
        }
        if (name == null) {
            name = psiElement.getName();
        }
        return name;
    }

    protected void addTypeFromObjectLiteralExpression(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        JSType recordType = this.getObjectLiteralType(expression, evaluatePropertyTypes);
        this.addType(recordType, (PsiElement)expression);
    }

    @NotNull
    protected JSType getObjectLiteralType(JSObjectLiteralExpression expression, boolean evaluatePropertyTypes) {
        if (DialectDetector.isActionScript((PsiElement)expression)) {
            return new JSObjectType(JSTypeSourceFactory.createTypeSource((PsiElement)expression, false), JSTypeContext.UNKNOWN);
        }
        if (DialectDetector.isTypeScript((PsiElement)expression)) {
            evaluatePropertyTypes = true;
        }
        JSElement[] properties = expression.getPropertiesIncludingSpreads();
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)expression, true);
        HashMap<String, JSRecordType.PropertySignature> propertyMembers = new HashMap<String, JSRecordType.PropertySignature>();
        ArrayList<JSRecordType.TypeMember> nonPropertyMembers = new ArrayList<JSRecordType.TypeMember>();
        SmartList syntheticStringIndexerTypes = new SmartList();
        SmartList syntheticNumericIndexerTypes = new SmartList();
        ArrayList<JSType> unexpandedTypes = new ArrayList<JSType>();
        boolean hasComputedProps = false;
        for (JSElement property : properties) {
            JSType spreadType;
            if (property instanceof JSProperty) {
                ES6ComputedName computedPropertyName;
                JSRecordType.PropertySignature member = this.getTypeMemberFromSimplePropertyValue((JSProperty)property, evaluatePropertyTypes);
                if (member != null && member.hasValidName()) {
                    propertyMembers.put(member.getMemberName(), member);
                }
                boolean hasComputedName = false;
                if (property instanceof JSComputedPropertyNameOwner && (computedPropertyName = ((JSComputedPropertyNameOwner)property).getComputedPropertyName()) != null) {
                    hasComputedName = true;
                    hasComputedProps = true;
                    if (evaluatePropertyTypes) {
                        JSExpression jsExpression = computedPropertyName.getExpression();
                        JSType propNameType = this.getExpressionTypeInContext(jsExpression);
                        JSType propNameValuableType = JSTypeUtils.getValuableType(propNameType);
                        if (propNameValuableType instanceof JSStringType) {
                            ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)this.getWidenedPropertyType((JSProperty)property));
                        }
                        if (propNameValuableType instanceof JSNumberType) {
                            JSType widenedPropertyType = this.getWidenedPropertyType((JSProperty)property);
                            ContainerUtil.addIfNotNull((Collection)syntheticNumericIndexerTypes, (Object)widenedPropertyType);
                            ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)widenedPropertyType);
                        }
                    }
                }
                if (hasComputedName) continue;
                ContainerUtil.addIfNotNull((Collection)syntheticStringIndexerTypes, (Object)this.getWidenedPropertyType((JSProperty)property));
                continue;
            }
            if (!(property instanceof JSSpreadExpression) || (spreadType = JSTypeUtils.getValuableType(((JSSpreadExpression)property).getInnerExpressionType())) == null) continue;
            if (spreadType instanceof JSAnyType) {
                JSTypeSource source = spreadType.getSource();
                if (spreadType.isTypeScript()) {
                    JSType jSType = spreadType;
                    if (jSType == null) {
                        JSTypeEvaluator.$$$reportNull$$$0(128);
                    }
                    return jSType;
                }
                PsiElement sourceElement = spreadType.getSourceElement();
                if (sourceElement == null) {
                    sourceElement = property;
                }
                return new JSRecordTypeImpl(source, Collections.singletonList(new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, source, JSTypeContext.INSTANCE), spreadType, JSRecordMemberSourceFactory.createSource(sourceElement), false)));
            }
            if (JSTypeUtils.hasForeignGenericParameter(spreadType) || spreadType instanceof JSEvaluableOnlyType && spreadType.isJavaScript()) {
                unexpandedTypes.add(spreadType);
                continue;
            }
            for (JSRecordType.TypeMember member : spreadType.asRecordType().getTypeMembers()) {
                if (member instanceof JSRecordType.PropertySignature) {
                    if (member instanceof PsiElement && JSUtils.isPrivateSharpItem((PsiElement)member)) continue;
                    propertyMembers.put(((JSRecordType.PropertySignature)member).getMemberName(), JSTypeEvaluator.mergeIfOptional(typeSource, propertyMembers, (JSRecordType.PropertySignature)member));
                    continue;
                }
                if (spreadType.getSourceElement() instanceof TypeScriptEnum && member instanceof JSRecordType.IndexSignature) continue;
                JSTypeEvaluator.addMember(nonPropertyMembers, member);
            }
        }
        if (hasComputedProps && syntheticStringIndexerTypes.size() > 0) {
            JSTypeEvaluator.addMember(nonPropertyMembers, (JSRecordType.TypeMember)new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSStringType(true, typeSource, JSTypeContext.INSTANCE), JSCompositeTypeImpl.optimizeTypeIfComposite(JSCompositeTypeFactory.createUnionType(typeSource, (Collection<? extends JSType>)syntheticStringIndexerTypes)), (PsiElement)null, true));
        }
        if (hasComputedProps && syntheticNumericIndexerTypes.size() > 0) {
            JSTypeEvaluator.addMember(nonPropertyMembers, (JSRecordType.TypeMember)new JSRecordTypeImpl.IndexSignatureImpl((JSType)new JSNumberType(true, typeSource, JSTypeContext.INSTANCE), JSCompositeTypeImpl.optimizeTypeIfComposite(JSCompositeTypeFactory.createUnionType(typeSource, (Collection<? extends JSType>)syntheticNumericIndexerTypes)), (PsiElement)null, true));
        }
        JSFreshObjectLiteralTypeImpl literalType = new JSFreshObjectLiteralTypeImpl(typeSource, ContainerUtil.concat(nonPropertyMembers, new ArrayList(propertyMembers.values())));
        if (unexpandedTypes.size() == 0) {
            JSFreshObjectLiteralTypeImpl jSFreshObjectLiteralTypeImpl = literalType;
            if (jSFreshObjectLiteralTypeImpl == null) {
                JSTypeEvaluator.$$$reportNull$$$0(129);
            }
            return jSFreshObjectLiteralTypeImpl;
        }
        if (literalType.hasMembers()) {
            unexpandedTypes.add(literalType);
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType(unexpandedTypes, typeSource, true);
        if (jSType == null) {
            JSTypeEvaluator.$$$reportNull$$$0(130);
        }
        return jSType;
    }

    @NotNull
    private static JSRecordType.PropertySignature mergeIfOptional(@NotNull JSTypeSource typeSource, @NotNull Map<String, JSRecordType.PropertySignature> propertyMembers, @NotNull JSRecordType.PropertySignature member) {
        String memberName;
        if (typeSource == null) {
            JSTypeEvaluator.$$$reportNull$$$0(131);
        }
        if (propertyMembers == null) {
            JSTypeEvaluator.$$$reportNull$$$0(132);
        }
        if (member == null) {
            JSTypeEvaluator.$$$reportNull$$$0(133);
        }
        if (propertyMembers.containsKey(memberName = member.getMemberName()) && member.isOptional()) {
            JSRecordType.PropertySignature oldMember = propertyMembers.get(memberName);
            member = new JSRecordTypeImpl.PropertySignatureImpl(memberName, JSCompositeTypeImpl.getCommonType((JSType)ObjectUtils.coalesce((Object)oldMember.getJSType(), (Object)JSAnyType.get(typeSource)), (JSType)ObjectUtils.coalesce((Object)member.getJSType(), (Object)JSAnyType.get(typeSource)), typeSource, true), oldMember.isOptional() && member.isOptional(), oldMember.isConst() || member.isConst());
        }
        JSRecordType.PropertySignature propertySignature = member;
        if (propertySignature == null) {
            JSTypeEvaluator.$$$reportNull$$$0(134);
        }
        return propertySignature;
    }

    private static void addMember(ArrayList<JSRecordType.TypeMember> nonPropertyMembers, JSRecordType.TypeMember member) {
        boolean memberSet = false;
        if (member instanceof JSRecordType.IndexSignature) {
            for (int i = 0; i < nonPropertyMembers.size(); ++i) {
                JSRecordType.TypeMember propertyMember = nonPropertyMembers.get(i);
                if (!(propertyMember instanceof JSRecordType.IndexSignature) || ((JSRecordType.IndexSignature)propertyMember).getIndexSignatureKind() != ((JSRecordType.IndexSignature)member).getIndexSignatureKind()) continue;
                nonPropertyMembers.set(i, member);
                memberSet = true;
            }
        }
        if (!memberSet) {
            nonPropertyMembers.add(member);
        }
    }

    @Nullable
    protected JSType getWidenedPropertyType(@NotNull JSProperty property) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(135);
        }
        return JSTypeUtils.widenLiteralTypes(property.getJSType());
    }

    @Nullable
    private JSRecordType.PropertySignature getTypeMemberFromSimplePropertyValue(@NotNull JSProperty property, boolean evaluatePropertyTypes) {
        JSFunctionType type;
        String name;
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(136);
        }
        if ((name = property.getName()) == null && property instanceof JSComputedPropertyNameOwner) {
            name = JSPsiImplUtils.getComputedPropertyNameWithoutBrackets((JSComputedPropertyNameOwner)property);
        }
        if (name == null && !(property instanceof JSComputedPropertyNameOwner)) {
            return null;
        }
        if (property instanceof JSFunctionProperty) {
            type = TypeScriptTypeParser.buildFunctionType((JSFunctionItem)((JSFunction)property));
        } else {
            type = this.getWidenedPropertyType(property);
            if (!(DialectDetector.isTypeScript((PsiElement)property) || type != null && JSTypeEvaluator.isAcceptableInitializerType((JSType)type) || !evaluatePropertyTypes)) {
                type = this.getExpressionTypeInContext(property.getValue());
            }
        }
        type = JSTypeEvaluator.modifyTypeIfAccessor(property, (JSType)type);
        if (name == null) {
            String referenceName;
            ES6ComputedName propertyName = ((JSComputedPropertyNameOwner)property).getComputedPropertyName();
            String string = referenceName = propertyName == null ? null : propertyName.getExpressionAsReferenceName();
            if (referenceName != null) {
                return new JSRecordTypeImpl.ComputedPropertySignatureImpl(referenceName, (JSType)type, false, property instanceof JSConstStatusOwner && ((JSConstStatusOwner)property).isConst(), JSRecordMemberSourceFactory.createSource((PsiElement)property));
            }
            return null;
        }
        return new JSRecordTypeImpl.PropertySignatureImpl(name, (JSType)type, false, property instanceof JSConstStatusOwner && ((JSConstStatusOwner)property).isConst(), (PsiElement)property);
    }

    @Nullable
    private static JSType modifyTypeIfAccessor(@NotNull JSProperty property, @Nullable JSType type) {
        if (property == null) {
            JSTypeEvaluator.$$$reportNull$$$0(137);
        }
        boolean isGetter = property.isGetProperty();
        boolean isSetter = property.isSetProperty();
        if (!isGetter && !isSetter) {
            return type;
        }
        if (type instanceof JSFunctionTypeImpl) {
            if (isGetter) {
                return ((JSFunctionTypeImpl)type).getReturnType();
            }
            List<JSParameterTypeDecorator> parameters = ((JSFunctionTypeImpl)type).getParameters();
            if (parameters.size() >= 1) {
                return parameters.get(0).getSimpleType();
            }
        }
        return JSAnyType.get(JSTypeSourceFactory.createTypeSource((PsiElement)property, false));
    }

    protected void addTypeFromDefExpr(@NotNull JSDefinitionExpression psiElement) {
        JSDocComment comment;
        JSNamespace providedNs;
        JSType jsType;
        boolean isExportDefinition;
        if (psiElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(138);
        }
        if (isExportDefinition = CommonJSUtil.isExportNamespace(JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)psiElement, true))) {
            this.addExportsNamespace((PsiElement)psiElement);
        }
        if ((jsType = psiElement.getJSType()) instanceof JSStubBasedExpressionType) {
            jsType = null;
        }
        boolean hasType = false;
        if (jsType != null) {
            this.addType(jsType, (PsiElement)psiElement);
            hasType = true;
            if (jsType instanceof JSReferenceType && CommonJSUtil.isExportNamespace(JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)psiElement))) {
                String referencedName = ((JSReferenceType)jsType).getReferenceName();
                JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.create(referencedName, null);
                JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource((PsiElement)psiElement, true);
                for (FrameworkIndexingHandler indexingHandler : FrameworkIndexingHandler.getExtensions((PsiElement)psiElement)) {
                    JSType type = indexingHandler.getExportsInnerAliasType(qualifiedName, typeSource);
                    if (type == null) continue;
                    this.addType(type, (PsiElement)psiElement);
                }
            }
            if (jsType.isSourceStrict()) {
                return;
            }
        }
        JSFunctionExpression functionInitializer = null;
        if (!hasType) {
            boolean evaluateInitializer;
            JSExpression initializer = psiElement.getInitializerOrStub();
            functionInitializer = initializer instanceof JSFunctionExpression ? (JSFunctionExpression)initializer : null;
            boolean bl = evaluateInitializer = this.myContext.isStrict() || isExportDefinition;
            if (evaluateInitializer) {
                if (this.myContext.isAstAccessAllowed((PsiElement)psiElement)) {
                    JSExpression expr = JSPsiImplUtils.getRightmostOperand(psiElement);
                    if (expr != null) {
                        this.evaluateTypes(expr);
                    }
                } else if (initializer != null) {
                    JSEvaluateContext previousContext = this.startEvaluationWithContext(this.myContext.withAstAccessForbidden());
                    this.evaluateTypes(initializer);
                    this.finishEvaluationWithContext(previousContext);
                }
            }
        }
        boolean explicitType = false;
        if (psiElement.isNamespaceExplicitlyDeclared() && (providedNs = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)psiElement, explicitType = (comment = JSStubBasedPsiTreeUtil.findDocComment((PsiElement)psiElement)) != null && comment.hasNamespaceTag())) != null) {
            if (explicitType) {
                this.addType((JSType)providedNs, EXPLICIT_TYPE_MARKER_ELEMENT);
            } else {
                this.addNamespace(providedNs, (PsiElement)psiElement);
            }
        }
        if (jsType == null && !explicitType && !CommonJSUtil.isModuleExportsAssigmentTarget((JSElementBase)psiElement) && functionInitializer == null) {
            this.setUnknownElement((PsiElement)psiElement);
        }
    }

    @NotNull
    protected JSExpectedTypeKind getContextualExpectedTypeKind() {
        JSExpectedTypeKind jSExpectedTypeKind = this.myContext.getContextualExpectedTypeKind();
        if (jSExpectedTypeKind == null) {
            JSTypeEvaluator.$$$reportNull$$$0(139);
        }
        return jSExpectedTypeKind;
    }

    private void simpleEvalType(JSExpression rawqualifier, JSExpression lOperand) {
        JSType evaluatedType = this.getExpressionTypeInContext(lOperand);
        if (evaluatedType != null) {
            this.addType(evaluatedType, (PsiElement)rawqualifier);
        } else {
            this.setUnknownElement((PsiElement)rawqualifier);
        }
    }

    @Nullable
    public static <T> T evaluateWithGuard(@NotNull JSType type, @NotNull JSEvaluateContext context, @NotNull Computable<T> runnable) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(140);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(141);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(142);
        }
        JSEvaluationKey node = new JSEvaluationKey(type.getResolvedTypeId(), context, runnable.getClass());
        return ourRecursionGuard.doPreventingRecursion(node, false, runnable);
    }

    public static void evaluateWithRecursionGuard(@NotNull JSEvaluableOnlyType type, @NotNull JSEvaluateContext context, @NotNull JSTypeProcessor processor) {
        if (type == null) {
            JSTypeEvaluator.$$$reportNull$$$0(143);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(144);
        }
        if (processor == null) {
            JSTypeEvaluator.$$$reportNull$$$0(145);
        }
        Computable computable = () -> {
            type.evaluate(context).applyWithContext(processor, context);
            return null;
        };
        JSEvaluationKey node = new JSEvaluationKey(type.getResolvedTypeId(), context, computable.getClass());
        ourRecursionGuard.doPreventingRecursion(node, false, computable);
    }

    @Nullable
    public static <T> T processWithEvaluationGuard(@NotNull PsiElement element, @NotNull JSEvaluateContext context, @NotNull Computable<T> runnable) {
        if (element == null) {
            JSTypeEvaluator.$$$reportNull$$$0(146);
        }
        if (context == null) {
            JSTypeEvaluator.$$$reportNull$$$0(147);
        }
        if (runnable == null) {
            JSTypeEvaluator.$$$reportNull$$$0(148);
        }
        JSEvaluationKey node = new JSEvaluationKey(element, context, runnable.getClass());
        return ourRecursionGuard.doPreventingRecursion(node, false, runnable);
    }

    public void setUnknownElement(@NotNull PsiElement unknownElement) {
        if (unknownElement == null) {
            JSTypeEvaluator.$$$reportNull$$$0(149);
        }
        this.addType(JSAnyType.get(unknownElement, false), unknownElement);
    }

    protected void addCodeBasedType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSTypeEvaluator.$$$reportNull$$$0(150);
        }
        JSType type = JSCodeBasedTypeFactory.getCodeBasedType(expression, this.myContext.isAstAccessAllowed((PsiElement)expression), this.isContextualOverloadEvaluation());
        this.addType(type, (PsiElement)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 46: 
            case 52: 
            case 64: 
            case 68: 
            case 83: 
            case 84: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 114: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 134: 
            case 139: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 46: 
            case 52: 
            case 64: 
            case 68: 
            case 83: 
            case 84: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 114: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 134: 
            case 139: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 13: 
            case 119: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 16: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeProcessor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetFile";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 23: 
            case 72: 
            case 96: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: 
            case 46: 
            case 52: 
            case 64: 
            case 68: 
            case 83: 
            case 84: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 114: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 134: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 19: 
            case 51: 
            case 71: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 24: 
            case 25: 
            case 29: 
            case 140: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 110: 
            case 111: 
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawqualifier";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluatedExpression";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sign";
                break;
            }
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 45: 
            case 131: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisQualifier";
                break;
            }
            case 48: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawQualifier";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpression";
                break;
            }
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoked";
                break;
            }
            case 63: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 66: 
            case 142: 
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousContext";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 93: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 76: 
            case 77: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 85: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringContainer";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "amdModuleReference";
                break;
            }
            case 92: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 94: 
            case 135: 
            case 136: 
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsExpression";
                break;
            }
            case 118: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 120: 
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyMembers";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unknownElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createEvaluator";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeForThisExpression";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "createNullType";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluateContext";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "startEvaluationWithContext";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "findDestructuringParents";
                break;
            }
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoopVariableTypes";
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromArrayExpression";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeFromProcessor";
                break;
            }
            case 105: 
            case 106: 
            case 107: 
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentTypeWithExpandingComposite";
                break;
            }
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstantNamedType";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalTypes";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getJQueryType";
                break;
            }
            case 128: 
            case 129: 
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectLiteralType";
                break;
            }
            case 134: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeIfOptional";
                break;
            }
            case 139: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextualExpectedTypeKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forceEvaluateType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypes";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "evaluateExpressionOrElementTypes";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateExpressionOrElementTypeForCaching";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateExpressionOrElementTypes";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEvaluatedAsExpression";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluator";
                break;
            }
            case 18: 
            case 46: 
            case 52: 
            case 64: 
            case 68: 
            case 83: 
            case 84: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 114: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 134: 
            case 139: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionType";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getElementType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addTypeEvaluationResultElement";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "doAddType";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyContextAndProcess";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateTypes";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluateTypesImpl";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processBinaryOperation";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "evaluateTypeFromInlineComment";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addNumericOperatorType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "evaluatePlusType";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "evaluateAndOrOrType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPropertyAccessType";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierExpression";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createTypeForThisExpression";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "processThisQualifierInExecutionScope";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getArrayTypeFromExpressions";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOrSpread";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElementTypeFromSpread";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "evaluateNewExpressionTypes";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "evaluateCallExpressionTypes";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromGclRequireCall";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "processRequireMethodCall";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processApplyOrCallMethodCall";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processCreateMethodCall";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromExternalModuleReferenceResolveResult";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "runWithContext";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "startEvaluationWithContext";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "finishEvaluationWithContext";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "processFunction";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processRefExpr";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromElement";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromResolveResult";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "doAddTypeFromResolveResult";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "findAliasTypeFromDocComment";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableResolveResult";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "addTypeForAutoTypeVariable";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "definesConstructor";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromVariableInitializer";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "processParameterType";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "findDestructuringParents";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isForStatementDeclaration";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyJSObjectLiteral";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "evaluateDestructuringContainer";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "substituteThisType";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModuleReference";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromAmdModule";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "addExportsNamespace";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromImplicitElementResolveResult";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromProperty";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromClassCandidate";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getLoopVariableTypes";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromLiteralExpression";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromConstant";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "isBigIntLiteral";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "createConstantNamedType";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "detectTypeByExpression";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "getConstantLiteralText";
                break;
            }
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "addAdditionalTypes";
                break;
            }
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalTypes";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "getJQueryType";
                break;
            }
            case 131: 
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "mergeIfOptional";
                break;
            }
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "getWidenedPropertyType";
                break;
            }
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "getTypeMemberFromSimplePropertyValue";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "modifyTypeIfAccessor";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "addTypeFromDefExpr";
                break;
            }
            case 140: 
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "evaluateWithGuard";
                break;
            }
            case 143: 
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "evaluateWithRecursionGuard";
                break;
            }
            case 146: 
            case 147: 
            case 148: {
                objectArray = objectArray;
                objectArray[2] = "processWithEvaluationGuard";
                break;
            }
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "setUnknownElement";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "addCodeBasedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 46: 
            case 52: 
            case 64: 
            case 68: 
            case 83: 
            case 84: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 114: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 134: 
            case 139: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class JSElementEvaluationResultCache {
        @NotNull
        private final Map<JSEvaluateContext, SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSTypeEvaluationResult>>> myResults = ContainerUtil.createConcurrentSoftMap();

        private JSElementEvaluationResultCache() {
        }

        @Nullable
        public JSTypeEvaluationResult getElementType(@NotNull PsiElement element, @NotNull JSEvaluateContext context) {
            if (element == null) {
                JSElementEvaluationResultCache.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JSElementEvaluationResultCache.$$$reportNull$$$0(1);
            }
            JSEvaluationKey evaluationKey = new JSEvaluationKey(element, context, CACHE_PROVIDER_EXPRESSION_TYPE.getClass());
            return ourRecursionGuard.getCachedValue(evaluationKey, JSEvaluatorComplexityTracker.getDefaultInstance(), () -> {
                SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSTypeEvaluationResult>> value = this.myResults.get(context);
                return value != null ? value.getUpToDateOrNull() : null;
            }, value -> this.myResults.put(context, new SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue>((JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue)value, (ModificationTracker)PsiModificationTracker.SERVICE.getInstance((Project)element.getProject()))), key -> CACHE_PROVIDER_EXPRESSION_TYPE.apply((PsiElement)key.myElement, key.myContext));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$JSElementEvaluationResultCache";
            objectArray[2] = "getElementType";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class JSTypeWithContext {
        @NotNull
        private final JSType myType;
        private final boolean myIsExplicit;

        private JSTypeWithContext(@NotNull JSType type, boolean explicit) {
            if (type == null) {
                JSTypeWithContext.$$$reportNull$$$0(0);
            }
            this.myType = type;
            this.myIsExplicit = explicit;
        }

        @NotNull
        public JSType getJSType() {
            JSType jSType = this.myType;
            if (jSType == null) {
                JSTypeWithContext.$$$reportNull$$$0(1);
            }
            return jSType;
        }

        public boolean isExplicit() {
            return this.myIsExplicit;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$JSTypeWithContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$JSTypeWithContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJSType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class JSEvaluationKey {
        @NotNull
        private final Object myElement;
        @NotNull
        public final JSEvaluateContext myContext;
        @NotNull
        public final Class<?> myProviderClass;

        public JSEvaluationKey(@NotNull PsiElement element, @NotNull JSEvaluateContext context, @NotNull Class<?> providerClass) {
            if (element == null) {
                JSEvaluationKey.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JSEvaluationKey.$$$reportNull$$$0(1);
            }
            if (providerClass == null) {
                JSEvaluationKey.$$$reportNull$$$0(2);
            }
            this.myElement = element;
            this.myContext = context;
            this.myProviderClass = providerClass;
        }

        public JSEvaluationKey(@NotNull JSResolvedTypeId typeId, @NotNull JSEvaluateContext context, @NotNull Class<?> providerClass) {
            if (typeId == null) {
                JSEvaluationKey.$$$reportNull$$$0(3);
            }
            if (context == null) {
                JSEvaluationKey.$$$reportNull$$$0(4);
            }
            if (providerClass == null) {
                JSEvaluationKey.$$$reportNull$$$0(5);
            }
            this.myElement = Pair.create((Object)typeId, (Object)new JSEvaluateContextObject(context));
            this.myContext = context;
            this.myProviderClass = providerClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSEvaluationKey key = (JSEvaluationKey)o;
            return this.myElement.equals(key.myElement) && this.myContext.equals(key.myContext) && this.myProviderClass.equals(key.myProviderClass);
        }

        public int hashCode() {
            return Objects.hash(this.myElement, this.myContext, this.myProviderClass);
        }

        public String toString() {
            String element = this.myElement instanceof PsiElement ? JSEvaluationLogger.toPresentable(this.myElement) : this.myElement.getClass().getSimpleName();
            return String.format("JSEvaluationKey(%s, %s)", element, this.myProviderClass.getSimpleName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "providerClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeId";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$JSEvaluationKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class JSEvaluateContextObject {
            @Nullable
            private final JSReferenceExpression myExpression;
            private final PsiElement mySource;

            private JSEvaluateContextObject(@NotNull JSEvaluateContext context) {
                if (context == null) {
                    JSEvaluateContextObject.$$$reportNull$$$0(0);
                }
                this.myExpression = context.getProcessedExpression();
                this.mySource = context.getSource();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                JSEvaluateContextObject that = (JSEvaluateContextObject)o;
                return Objects.equals(this.myExpression, that.myExpression) && Objects.equals(this.mySource, that.mySource);
            }

            public int hashCode() {
                return Objects.hash(this.myExpression, this.mySource);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSTypeEvaluator$JSEvaluationKey$JSEvaluateContextObject", "<init>"));
            }
        }
    }

    private static final class CacheProviderExpressionType
    implements BiFunction<PsiElement, JSEvaluateContext, JSTypeEvaluationResult> {
        private CacheProviderExpressionType() {
        }

        @Override
        public JSTypeEvaluationResult apply(PsiElement element, JSEvaluateContext context) {
            JSTypeEvaluationResultProcessor processor = new JSTypeEvaluationResultProcessor();
            JSTypeEvaluator.doEvaluateExpressionOrElementTypeForCaching(element, context, processor);
            return processor.getResult();
        }
    }
}

