/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.json.psi.JsonElement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSEvaluationResultElement;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSModuleTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeWithOuterGenerics;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JsonElementType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSimpleTypeProcessor
extends ResolveProcessor
implements JSTypeEvaluationProcessor {
    @Nullable
    private JSTypeEvaluationResult myResult;
    @Nullable
    private final PsiElement myTarget;

    public JSSimpleTypeProcessor() {
        this((PsiElement)null);
    }

    public JSSimpleTypeProcessor(@Nullable PsiElement target) {
        super((String)null);
        this.myTarget = target;
    }

    @Override
    public void process(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement _source) {
        if (type == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(0);
        }
        if (evaluateContext == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(1);
        }
        if (this.myTarget instanceof JSDefinitionExpression && _source instanceof JSReferenceExpression && ((JSDefinitionExpression)this.myTarget).getExpression() != _source) {
            return;
        }
        this.addPossibleOption(type, _source, evaluateContext);
    }

    @Override
    public void processAdditionalType(@NotNull JSType type, @NotNull JSEvaluateContext evaluateContext, PsiElement source) {
        if (type == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(2);
        }
        if (evaluateContext == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(3);
        }
        if (this.myResult == null) {
            this.myResult = new JSTypeEvaluationResult();
        }
        this.myResult.addResultElement(new JSEvaluationResultElement(type, true, source, evaluateContext));
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        if (element == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(4);
        }
        if (state == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(5);
        }
        return true;
    }

    private void addPossibleOption(@NotNull JSType option, @Nullable PsiElement source, @NotNull JSEvaluateContext context) {
        if (option == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(6);
        }
        if (context == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(7);
        }
        if (this.myResult == null) {
            this.myResult = new JSTypeEvaluationResult();
        }
        List typesToAdd = option instanceof JSUnionType && !option.isSourceStrict() ? ContainerUtil.map(((JSUnionType)option).getTypes(), t -> JSTypeUtils.copyWithStrict(t, false)) : Collections.singletonList(option);
        for (JSType newType : typesToAdd) {
            this.myResult.addResultElement(new JSEvaluationResultElement(newType, false, source, context));
        }
    }

    @Nullable
    public final JSType getType() {
        if (this.myResult == null) {
            return null;
        }
        List<JSEvaluationResultElement> results = this.myResult.getResults();
        LinkedHashSet<JSType> types2 = new LinkedHashSet<JSType>(results.size());
        boolean hasUnknownElement = false;
        PsiElement unknownElement = null;
        for (JSEvaluationResultElement result2 : results) {
            JSType innerType;
            JSType type = result2.getType();
            JSType jSType = innerType = type instanceof JSTypeWithOuterGenerics ? ((JSTypeWithOuterGenerics)type).getType() : type;
            if (innerType instanceof JSClassExpressionType) {
                JSClassExpressionType classType = (JSClassExpressionType)innerType;
                innerType = TypeScriptTypeParser.buildTypeFromClass((JSClass)classType.getElement(), classType.getJSContext() == JSContext.STATIC);
                type = type instanceof JSTypeWithOuterGenerics ? JSTypeUtils.applyGenericArguments(innerType, ((JSTypeWithOuterGenerics)type).getOuterArguments()) : innerType;
            } else if (type == null && result2.getAdditionalType() == null && result2.getSource() != null) {
                type = JSSimpleTypeProcessor.buildTypeFromElement(result2.getSource(), result2.getEvaluateContext());
            }
            if (type == null) continue;
            hasUnknownElement |= !type.isSourceStrict();
            types2.add(type);
        }
        if (types2.isEmpty()) {
            return hasUnknownElement ? JSAnyType.get(unknownElement, false) : null;
        }
        JSTypeSource typeSource = JSTypeSourceFactory.copyTypeSource(((JSType)ContainerUtil.getFirstItem(types2)).getSource(), !hasUnknownElement);
        return types2.size() == 1 ? ((JSType)ContainerUtil.getFirstItem(types2)).copyWithStrict(!hasUnknownElement) : (hasUnknownElement ? JSCompositeTypeFactory.createUnionType(typeSource, types2) : JSCompositeTypeFactory.createContextualUnionType(types2, typeSource));
    }

    @Override
    @Nullable
    public JSTypeEvaluationResult getResult() {
        return this.myResult;
    }

    @Nullable
    private static JSType buildTypeFromElement(@NotNull PsiElement element, @NotNull JSEvaluateContext context) {
        if (element == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(8);
        }
        if (context == null) {
            JSSimpleTypeProcessor.$$$reportNull$$$0(9);
        }
        JSModuleTypeImpl type = null;
        if (element instanceof JSFile) {
            type = new JSModuleTypeImpl((JSFile)element, true);
        } else if (element instanceof JsonElement) {
            type = JsonElementType.createJsonElementType((JsonElement)element, (PsiElement)context.getProcessedExpression());
        }
        if (type == null) {
            return null;
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluateContext";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSSimpleTypeProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processAdditionalType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addPossibleOption";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "buildTypeFromElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

