/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.actionscript.psi.impl.ActionScriptFunctionImpl;
import com.intellij.lang.actionscript.psi.impl.ActionScriptVariableImpl;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.flex.AnnotationBackedDescriptor;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.index.JSIndexedRootProvider;
import com.intellij.lang.javascript.index.JSPackageIndex;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLocalVariable;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParenthesizedType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeofType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.ecma6.impl.JSLocalImplicitElementImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptImplicitOverloadedAliasElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSGenericSignature;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSPackage;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.JSUseNamespaceDirective;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassProvider;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptConditionalCompileBlockImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSClassBase;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageStatementImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceSetElement;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSCollectMembersToImplementProcessor;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSContextResolver;
import com.intellij.lang.javascript.psi.resolve.JSElementResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSOverrideHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveScopeProvider;
import com.intellij.lang.javascript.psi.resolve.JSScopeNamesCache;
import com.intellij.lang.javascript.psi.resolve.JSSimpleTypeProcessor;
import com.intellij.lang.javascript.psi.resolve.JSSymbolResolveStatus;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.WalkUpResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.complexity.JSNamedEvaluationTask;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.JSNameIndex;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedElementIndex;
import com.intellij.lang.javascript.psi.stubs.TypeScriptProxyImplicitElement;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelBranchImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.CollectionQuery;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSResolveUtil {
    @NonNls
    public static final String PROTOTYPE_FIELD_NAME = "prototype";
    public static final String CONSTRUCTOR_FIELD_NAME = "constructor";
    public static final String USE_STRICT = "use strict";
    public static final String QUOTED_USE_STRICT = "\"use strict\"";
    public static final String SINGLE_QUOTED_USE_STRICT = "'use strict'";
    private static final Key<GlobalSearchScope> PROJECT_SCOPE_WITH_PREDEFINED_KEY = Key.create((String)"object.default.scope");
    public static final String VECTOR$OBJECT_TYPE_NAME = "Vector$object";
    public static final String EXCLUDE_CLASS_METADATA = "ExcludeClass";
    public static final String FLASH_UTILS_PROXY = "flash.utils.Proxy";
    public static final String BINDABLE_ATTR_NAME = "Bindable";
    public static final Comparator<PsiElement> RESOLVE_RESULT_ELEMENTS_COMPARATOR = Comparator.nullsLast(Comparator.comparing(PsiElement::getContainingFile, Comparator.nullsLast(Comparator.comparing(file2 -> {
        String name = file2.getViewProvider().getVirtualFile().getName();
        return !"lib.es5.d.ts".equals(name);
    }).thenComparing(file2 -> file2.getViewProvider().getVirtualFile().getPath()))).thenComparing(PsiElement::getTextOffset));
    private static final Comparator<ResolveResult> RESOLVE_RESULT_COMPARATOR = Comparator.comparing(o -> JSResolveUtil.explicifyElement(o.getElement()), RESOLVE_RESULT_ELEMENTS_COMPARATOR);
    private static final Key<ParameterizedCachedValue<PsiElement[], PsiElement>> CHILDREN_TO_PROCESS_KEY = Key.create((String)"js.children.to.process");
    private static final ParameterizedCachedValueProvider<PsiElement[], PsiElement> CHILDREN_TO_PROCESS_PROVIDER = element -> {
        PsiElement[] children = element instanceof JSSwitchStatement ? ((JSSwitchStatement)element).getAllStatementListItems() : element.getChildren();
        return new CachedValueProvider.Result((Object)children, new Object[]{element});
    };
    public static final Key<PsiElement> contextKey = Key.create((String)"context.key");

    public static void processInjectedFileForTag(@NotNull XmlTag tag, @NotNull JSInjectedFilesVisitor visitor) {
        if (tag == null) {
            JSResolveUtil.$$$reportNull$$$0(0);
        }
        if (visitor == null) {
            JSResolveUtil.$$$reportNull$$$0(1);
        }
        InjectedLanguageManager manager2 = InjectedLanguageManager.getInstance((Project)tag.getProject());
        for (XmlTagChild child : tag.getValue().getChildren()) {
            if (!(child instanceof XmlText)) continue;
            manager2.enumerate((PsiElement)child, (PsiLanguageInjectionHost.InjectedPsiVisitor)visitor);
        }
    }

    public static String getExpectedPackageNameFromFile(VirtualFile file2, Project project) {
        VirtualFile rootForFile;
        if (file2 == null) {
            return null;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((rootForFile = projectFileIndex.getSourceRootForFile(file2)) != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)(file2.isDirectory() ? file2 : file2.getParent()), (VirtualFile)rootForFile, (char)'.');
        }
        return null;
    }

    public static void processInterfaceMembers(JSClass clazz, JSCollectMembersToImplementProcessor implementedMethodProcessor) {
        clazz.processDeclarations((PsiScopeProcessor)implementedMethodProcessor, ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
    }

    @Nullable
    public static JSType getExpressionJSType(@Nullable JSExpression expression) {
        return JSResolveUtil.getExpressionJSType(expression, false);
    }

    @Nullable
    public static JSType getExpressionJSType(@Nullable JSExpression expression, boolean isContextual) {
        if (expression instanceof JSDefinitionExpression) {
            expression = ((JSDefinitionExpression)expression).getExpression();
        }
        return JSResolveUtil.getElementJSType((PsiElement)expression, isContextual);
    }

    @Nullable
    public static JSType getElementJSType(@Nullable PsiElement expression) {
        return JSResolveUtil.getElementJSType(expression, false);
    }

    @Nullable
    public static JSType getElementJSType(@Nullable PsiElement expression, boolean isContextual) {
        if (expression == null) {
            return null;
        }
        JSTypeEvaluationResult result2 = JSTypeEvaluator.getElementType(expression, new JSEvaluateContext(expression.getContainingFile(), isContextual));
        if (result2 == null) {
            return null;
        }
        JSSimpleTypeProcessor processor = new JSSimpleTypeProcessor();
        result2.applyToProcessor(processor);
        return processor.getType();
    }

    @NotNull
    public static String getShortTypeName(String type, boolean withSignature) {
        int i2;
        String str = type;
        int i = str.indexOf(60);
        String signature = null;
        if (i != -1) {
            int index = str.lastIndexOf(46, i);
            if (index == -1) {
                String string = type;
                if (string == null) {
                    JSResolveUtil.$$$reportNull$$$0(2);
                }
                return string;
            }
            signature = str.substring(index);
            str = str.substring(0, index);
        }
        if ((i2 = str.lastIndexOf(46)) != -1) {
            str = str.substring(i2 + 1);
        }
        String string = str + (withSignature && signature != null ? signature : "");
        if (string == null) {
            JSResolveUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static PsiElement getClassReferenceForXmlFromContext(PsiElement parent) {
        PsiElement context;
        PsiElement psiElement = context = parent != null ? parent.getContext() : null;
        if (context instanceof XmlElement && context.getContainingFile() instanceof XmlFile) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)context);
        }
        return parent;
    }

    @Nullable
    public static XmlBackedJSClass getXmlBackedClass(@NotNull JSFile injectedJsFile) {
        PsiElement context;
        if (injectedJsFile == null) {
            JSResolveUtil.$$$reportNull$$$0(4);
        }
        if ((context = injectedJsFile.getContext()) instanceof XmlAttributeValue || context instanceof XmlText) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)context);
        }
        return null;
    }

    public static boolean isResolveStrict(@NotNull PsiReference reference) {
        if (reference == null) {
            JSResolveUtil.$$$reportNull$$$0(5);
        }
        if (!(reference instanceof PsiPolyVariantReference)) {
            return true;
        }
        if (!(reference instanceof JSPsiReferenceElement) && !(reference instanceof JSReferenceSetElement)) {
            return true;
        }
        if (JSResolveUtil.isSelfReference(reference.getElement())) {
            return true;
        }
        ResolveResult[] results = ((PsiPolyVariantReference)reference).multiResolve(false);
        return JSResolveUtil.isResolveStrict(reference, results);
    }

    public static boolean isResolveStrict(@NotNull PsiReference reference, ResolveResult @NotNull [] resolveResults) {
        if (reference == null) {
            JSResolveUtil.$$$reportNull$$$0(6);
        }
        if (resolveResults == null) {
            JSResolveUtil.$$$reportNull$$$0(7);
        }
        if (JSResolveResult.isTooManyCandidatesResult(resolveResults)) {
            return false;
        }
        PsiElement refElement = reference.getElement();
        if (DialectDetector.isTypeScript(refElement)) {
            JSExpression qualifier = null;
            if (refElement instanceof JSReferenceExpression) {
                qualifier = ((JSReferenceExpression)reference).getQualifier();
            } else if (refElement instanceof JSLiteralExpression && refElement.getParent() instanceof JSIndexedPropertyAccessExpression) {
                qualifier = ((JSIndexedPropertyAccessExpression)refElement.getParent()).getQualifier();
            }
            if (!TypeScriptUtil.isStrictResolveQualifier(qualifier)) {
                return false;
            }
        }
        return JSResolveUtil.areResolveResultsStrict(resolveResults);
    }

    public static boolean areResolveResultsStrict(@NotNull ResolveResult[] resolveResults) {
        if (resolveResults == null) {
            JSResolveUtil.$$$reportNull$$$0(8);
        }
        return Arrays.stream(resolveResults).filter(resolveResult -> resolveResult instanceof JSResolveResult).map(resolveResult -> ((JSResolveResult)resolveResult).getStatus()).noneMatch(status -> status instanceof JSSymbolResolveStatus && ((JSSymbolResolveStatus)status).isPartial());
    }

    public static boolean isTypeScriptDeclarationMerging(ResolveResult @NotNull [] resolveResults) {
        if (resolveResults == null) {
            JSResolveUtil.$$$reportNull$$$0(9);
        }
        for (ResolveResult result2 : resolveResults) {
            PsiElement element = result2.getElement();
            if (element instanceof TypeScriptModule || element instanceof TypeScriptInterface || element instanceof TypeScriptFunction || element instanceof TypeScriptImplicitOverloadedAliasElement || element instanceof TypeScriptClass || element instanceof TypeScriptEnum || element instanceof TypeScriptVariable || element instanceof JSLocalImplicitElementImpl) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiElement findType(String type, @Nullable PsiElement context, boolean ecma) {
        if (type == null || context == null) {
            return null;
        }
        PsiElement typeClass = null;
        if (ecma) {
            if (context.getParent() instanceof JSNewExpression) {
                context = context.getParent();
            }
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(type, context, new ResolveResultSink(context, type));
            processor.setLocalResolve(true);
            processor.setTypeContext(true);
            processor.setToProcessHierarchy(false);
            processor.setToProcessMembers(false);
            JSResolveUtil.treeWalkUp(processor, (PsiElement)context.getContainingFile(), null, context);
            typeClass = processor.getResult();
        }
        if (typeClass == null) {
            typeClass = JSDialectSpecificHandlersFactory.forElement(context).getClassResolver().findClassByQName(type, context);
        }
        return typeClass;
    }

    public static boolean isAssignableJSType(@Nullable JSType lOpType, @Nullable JSType rOpType, @Nullable ProcessingContext context) {
        return lOpType == null || lOpType.isDirectlyAssignableType(rOpType, context);
    }

    public static boolean isAssignableType(@NonNls String expectedType, @NonNls String type, @NotNull PsiElement context) {
        if (context == null) {
            JSResolveUtil.$$$reportNull$$$0(10);
        }
        JSTypeSource source = JSTypeSourceFactory.createTypeSource(context, true);
        JSType lOpType = JSTypeUtils.createType(expectedType, source);
        JSType rOpType = JSTypeUtils.createType(type, source);
        return JSResolveUtil.isAssignableJSType(lOpType, rOpType, null);
    }

    public static boolean isEcmaScript5(@Nullable PsiElement decl) {
        return decl != null && JSResolveUtil.hasUseStrictPragmaUp(decl);
    }

    public static boolean hasUseStrictPragmaUp(@NotNull PsiElement decl) {
        if (decl == null) {
            JSResolveUtil.$$$reportNull$$$0(11);
        }
        for (PsiElement parent = decl; parent != null; parent = parent.getParent()) {
            if (!JSResolveUtil.hasUseStrictPragma(parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasUseStrictPragma(@NotNull PsiElement scope) {
        if (scope == null) {
            JSResolveUtil.$$$reportNull$$$0(12);
        }
        if (scope instanceof JSFile && ((JSFile)scope).getModuleStatus() == JSFile.ModuleStatus.ES6) {
            return true;
        }
        ASTNode node = scope.getNode();
        return node != null && JSTreeUtil.hasUseStrictPragma(node);
    }

    public static Collection<VirtualFile> sortFiles(Collection<? extends VirtualFile> virtualFiles) {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(virtualFiles);
        files.sort((o1, o2) -> (int)(o1.getLength() - o2.getLength()));
        return files;
    }

    public static boolean calculateStaticFromContext(@Nullable PsiElement psiElement) {
        JSAttributeList attributeList;
        JSAttributeListOwner attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSAttributeListOwner.class});
        while (attributeListOwner != null && !JSResolveUtil.changesThisValue(attributeListOwner)) {
            attributeListOwner = (JSAttributeListOwner)PsiTreeUtil.getParentOfType((PsiElement)attributeListOwner, JSAttributeListOwner.class);
        }
        return attributeListOwner != null && (attributeList = attributeListOwner.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
    }

    private static boolean changesThisValue(@NotNull JSAttributeListOwner scope) {
        if (scope == null) {
            JSResolveUtil.$$$reportNull$$$0(13);
        }
        if (scope instanceof JSFunction) {
            return !((JSFunction)scope).isArrowFunction();
        }
        if (scope instanceof JSVariable || scope instanceof JSVarStatement) {
            PsiElement grandParent = JSResolveUtil.findParent((PsiElement)scope);
            return grandParent instanceof JSFile || grandParent instanceof JSClass;
        }
        return true;
    }

    public static boolean shortReferenceIsAmbiguousOrUnequal(@NotNull String shortName, PsiElement context, String expectedFqn, Boolean forceInTypeContext) {
        ResolveResult[] results;
        if (shortName == null) {
            JSResolveUtil.$$$reportNull$$$0(14);
        }
        if ((results = JSReferenceExpressionImpl.resolveUnqualified(shortName, context, forceInTypeContext)).length > 1) {
            return true;
        }
        if (results.length == 0) {
            return false;
        }
        PsiElement element = results[0].getElement();
        if (context.getParent() instanceof JSNewExpression && element instanceof JSFunction && element.getParent() instanceof JSClass) {
            element = element.getParent();
        }
        return element instanceof JSQualifiedNamedElement && !expectedFqn.equals(((JSQualifiedNamedElement)element).getQualifiedName());
    }

    @NotNull
    public static Query<JSPsiElementBase> findOverridingFunctionsByNamespaces(JSPsiElementBase elt) {
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(elt);
        if (qName != null) {
            ArrayList result2 = new ArrayList();
            THashMap results = new THashMap();
            MyNamespaceProcessor namespaceProcessor = new MyNamespaceProcessor((Set)new THashSet(Collections.singletonList(elt)), true, (Map)results, result2){
                final /* synthetic */ Map val$results;
                final /* synthetic */ ArrayList val$result;
                {
                    this.val$results = map;
                    this.val$result = arrayList;
                    super(functions, findAll);
                }

                @Override
                protected boolean doProcess(PsiElement elt) {
                    if (elt instanceof JSProperty) {
                        elt = ((JSProperty)elt).getValue();
                    }
                    if (!(elt instanceof JSPsiElementBase)) {
                        return true;
                    }
                    String qName = JSResolveUtil.getQNameToStartHierarchySearch((JSPsiElementBase)elt);
                    if (qName != null) {
                        ArrayList<JSPsiElementBase> list2 = (ArrayList<JSPsiElementBase>)this.val$results.get(qName);
                        if (list2 == null) {
                            list2 = new ArrayList<JSPsiElementBase>(2);
                            this.val$results.put(qName, list2);
                        }
                        list2.add((JSPsiElementBase)elt);
                    } else {
                        this.val$result.add((JSPsiElementBase)elt);
                    }
                    return true;
                }
            };
            namespaceProcessor.processDescendantsOf(qName, (PsiElement)elt);
            for (List funs : results.values()) {
                result2.addAll(funs);
            }
            return new CollectionQuery(result2);
        }
        return new CollectionQuery(Collections.emptyList());
    }

    public static boolean isFromPredefinedFile(@Nullable PsiFile containingFile) {
        if (containingFile == null) {
            return false;
        }
        return JSResolveUtil.isFromPredefinedFile(containingFile.getProject(), containingFile.getOriginalFile().getVirtualFile());
    }

    public static boolean isFromPredefinedFile(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            JSResolveUtil.$$$reportNull$$$0(15);
        }
        return JSPredefinedLibraryManager.getPredefinedLibraryManager(project).isPredefinedFile(file2);
    }

    public static boolean ownerHasExplicitThisParameter(@Nullable JSExpression qualifier) {
        JSParameter thisParameter;
        JSFunction function2 = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)qualifier);
        return function2 != null && (thisParameter = TypeScriptPsiUtil.getThisParameter(function2)) != null;
    }

    public static boolean hasMultipleOccurenceDelimiters(String expectedType) {
        String commentDelimiters = "|/";
        for (int i = 0; i < "|/".length(); ++i) {
            if (expectedType.indexOf("|/".charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(16);
        }
        ModelBranch branch = ModelBranch.getPsiBranch((PsiElement)element);
        for (JSElementResolveScopeProvider provider : (JSElementResolveScopeProvider[])JSElementResolveScopeProvider.EP_NAME.getExtensions()) {
            GlobalSearchScope scope = provider.getElementResolveScope(element);
            if (scope == null) continue;
            GlobalSearchScope globalSearchScope = branch == null ? scope : ((ModelBranchImpl)branch).modifyScope(scope);
            if (globalSearchScope == null) {
                JSResolveUtil.$$$reportNull$$$0(17);
            }
            return globalSearchScope;
        }
        VirtualFile file2 = JSResolveScopeProvider.getFileForScopeEvaluation(element);
        Project project = element.getProject();
        if (file2 != null) {
            GlobalSearchScope scope = ResolveScopeManager.getInstance((Project)project).getDefaultResolveScope(file2);
            GlobalSearchScope globalSearchScope = branch == null ? scope : ((ModelBranchImpl)branch).modifyScope(scope);
            if (globalSearchScope == null) {
                JSResolveUtil.$$$reportNull$$$0(18);
            }
            return globalSearchScope;
        }
        if (element.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            Logger.getInstance(JSResolveUtil.class).error("Can't find resolve scope");
            return JSResolveUtil.getJavaScriptSymbolsResolveScope(project);
        }
        GlobalSearchScope globalSearchScope = element.getResolveScope();
        if (globalSearchScope == null) {
            JSResolveUtil.$$$reportNull$$$0(19);
        }
        return globalSearchScope;
    }

    @Nullable
    public static PsiElement getContext(@NotNull PsiElement element) {
        PsiElement result2;
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(20);
        }
        if ((result2 = (PsiElement)element.getUserData(contextKey)) != null && !result2.isValid()) {
            result2 = null;
        }
        return result2;
    }

    public static boolean isObjectClass(@NotNull JSPsiElementBase aClass) {
        if (aClass == null) {
            JSResolveUtil.$$$reportNull$$$0(21);
        }
        return "Object".equals(aClass.getQualifiedName());
    }

    public static boolean processHierarchy(String qName, PsiFile containingFile, Processor<? super JSClass> processor, boolean visitInterfaces) {
        PsiElement clazz = JSDialectSpecificHandlersFactory.forElement((PsiElement)containingFile).getClassResolver().findClassByQName(qName, (PsiElement)containingFile);
        if (clazz instanceof JSClass) {
            return JSResolveUtil.processHierarchy((JSClass)clazz, processor, visitInterfaces);
        }
        return true;
    }

    public static boolean processHierarchy(@NotNull JSClass clazz, Processor<? super JSClass> processor, boolean visitInterfaces) {
        if (clazz == null) {
            JSResolveUtil.$$$reportNull$$$0(22);
        }
        return clazz.processDeclarations((PsiScopeProcessor)new VisitAllTypesProcessor(processor, visitInterfaces), ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
    }

    public static void stableResolveOrder(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSResolveUtil.$$$reportNull$$$0(23);
        }
        Arrays.sort(results, RESOLVE_RESULT_COMPARATOR);
    }

    @Nullable
    private static PsiElement explicifyElement(@Nullable PsiElement elt) {
        PsiElement explicitElement;
        if (elt instanceof TypeScriptProxyImplicitElement && (explicitElement = ((TypeScriptProxyImplicitElement)elt).getExplicitElement()) != null) {
            elt = explicitElement;
        }
        return elt;
    }

    public static JSNamedElement findFileLocalElement(@NotNull String str, @NotNull PsiElement context) {
        if (str == null) {
            JSResolveUtil.$$$reportNull$$$0(24);
        }
        if (context == null) {
            JSResolveUtil.$$$reportNull$$$0(25);
        }
        SinkResolveProcessor processor = new SinkResolveProcessor(str, new ResolveResultSink(null, str)){
            {
                this.setTypeContext(true);
                this.setToProcessMembers(false);
            }
        };
        context.getContainingFile().processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), null, context);
        return (JSNamedElement)processor.getResult();
    }

    @Nullable
    public static String getQualifiedTypeName(@Nullable String _typeName) {
        if (_typeName != null) {
            String typeName;
            GenericSignature signature = JSResolveUtil.extractGenericSignature(_typeName);
            String string = typeName = signature != null ? signature.elementType : _typeName;
            if (VECTOR$OBJECT_TYPE_NAME.equals(typeName)) {
                typeName = "Vector";
            }
            return GenericSignature.build(typeName, signature);
        }
        return null;
    }

    public static boolean isAccessibleFromActionScriptPackage(@Nullable PsiElement element, @NotNull String forcedPackageName) {
        if (forcedPackageName == null) {
            JSResolveUtil.$$$reportNull$$$0(26);
        }
        if (!(element instanceof JSAttributeListOwner) || !DialectDetector.isActionScript(element)) {
            return true;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
        if (attributeList != null) {
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType == JSAttributeList.AccessType.PRIVATE && element instanceof JSClass) {
                return false;
            }
            if (!(accessType != JSAttributeList.AccessType.PACKAGE_LOCAL || attributeList.getNamespace() != null || element instanceof JSFunction && ((JSFunction)element).isConstructor() || JSResolveUtil.isQualifiedAS2Symbol(element))) {
                PsiElement parent = JSResolveUtil.findParent(element);
                if (parent instanceof JSClass ? ((JSClass)parent).isInterface() : !(parent instanceof JSFile) && !(parent instanceof JSPackageStatement)) {
                    return true;
                }
                String packageName2 = JSResolveUtil.getPackageName(element);
                if (!forcedPackageName.equals(packageName2)) {
                    return false;
                }
                if (forcedPackageName.isEmpty() && element instanceof JSClass && ActionScriptResolveUtil.isFileLocalSymbol(element)) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isSelfReference(@NotNull PsiElement element) {
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(27);
        }
        return JSResolveUtil.isSelfReference(element.getParent(), element);
    }

    @Nullable
    public static GenericSignature extractGenericSignature(String type) {
        if (type == null) {
            return null;
        }
        int ltPos = type.indexOf(60);
        if (ltPos > 0 && type.charAt(ltPos - 1) == '.') {
            int gtPos = type.lastIndexOf(62);
            String genericType = type.substring(ltPos + 1, gtPos != -1 ? gtPos : type.length()).trim();
            type = type.substring(0, ltPos - 1).trim();
            return new GenericSignature(type, genericType);
        }
        return null;
    }

    public static PsiElement getTopReferenceParent(PsiElement parent) {
        PsiElement currentParent = parent;
        while (currentParent instanceof JSReferenceExpression) {
            currentParent = currentParent.getParent();
        }
        return currentParent;
    }

    public static PsiElement getTopReferenceExpression(@NotNull PsiElement parent) {
        if (parent == null) {
            JSResolveUtil.$$$reportNull$$$0(28);
        }
        PsiElement element = parent;
        PsiElement currentParent = parent.getParent();
        while (currentParent instanceof JSReferenceExpression) {
            element = currentParent;
            currentParent = currentParent.getParent();
        }
        return element;
    }

    @NotNull
    public static JSExpression getLeftmostQualifier(@NotNull JSExpression expr) {
        if (expr == null) {
            JSResolveUtil.$$$reportNull$$$0(29);
        }
        JSExpression current = expr;
        while (current instanceof JSQualifiedExpression) {
            JSExpression qualifier = ((JSQualifiedExpression)current).getQualifier();
            if (qualifier == null) {
                JSExpression jSExpression = current;
                if (jSExpression == null) {
                    JSResolveUtil.$$$reportNull$$$0(30);
                }
                return jSExpression;
            }
            current = qualifier;
        }
        JSExpression jSExpression = current;
        if (jSExpression == null) {
            JSResolveUtil.$$$reportNull$$$0(31);
        }
        return jSExpression;
    }

    public static boolean isSelfReference(PsiElement currentParent, PsiElement elt) {
        PsiElement nameIdentifier;
        if (currentParent instanceof ActionScriptClassImpl && (nameIdentifier = ((ActionScriptClassImpl)currentParent).getNameIdentifier()) != null && nameIdentifier.getParent() == elt) {
            return true;
        }
        return currentParent instanceof JSPackageStatement && ((JSPackageStatement)currentParent).getNameIdentifier() == elt || currentParent instanceof JSNamespaceDeclaration && ((JSNamespaceDeclaration)currentParent).getNameIdentifier() == elt || (currentParent instanceof JSLocalVariable || currentParent instanceof ActionScriptVariableImpl) && ((JSVariable)currentParent).getNameIdentifier() == elt;
    }

    public static boolean isSameReference(@NotNull JSReferenceExpression ref, @NotNull PsiElement resolve) {
        if (ref == null) {
            JSResolveUtil.$$$reportNull$$$0(32);
        }
        if (resolve == null) {
            JSResolveUtil.$$$reportNull$$$0(33);
        }
        if (ref.getContainingFile() != resolve.getContainingFile()) {
            return false;
        }
        JSExpression resolveRef = resolve instanceof JSDefinitionExpression ? ((JSDefinitionExpression)resolve).getExpression() : (resolve instanceof JSNamedElement ? ((JSNamedElement)resolve).getNameIdentifier() : resolve);
        return ref == resolveRef;
    }

    public static boolean isDummyResolve(@NotNull JSReferenceExpression ref) {
        PsiElement resolve;
        if (ref == null) {
            JSResolveUtil.$$$reportNull$$$0(34);
        }
        return (resolve = ref.resolve()) != null && JSResolveUtil.isSameReference(ref, resolve);
    }

    public static boolean isDummyResolve(@NotNull JSPropertyNameReference ref) {
        PsiElement resolve;
        if (ref == null) {
            JSResolveUtil.$$$reportNull$$$0(35);
        }
        return (resolve = ref.resolve()) != null && ref.getElement() == resolve;
    }

    @Nullable
    public static PsiElement findParent(@NotNull PsiElement element) {
        if (element == null) {
            JSResolveUtil.$$$reportNull$$$0(36);
        }
        PsiElement parent = element.getContext();
        if (element instanceof JSVariable && (parent = JSDestructuringUtil.getParentSkippingDestructuring((JSElement)((JSVariable)element))) != null) {
            parent = parent.getContext();
        }
        if (parent instanceof TypeScriptObjectType && parent.getContext() instanceof TypeScriptInterface) {
            parent = parent.getContext();
        }
        if (parent instanceof JSBlockStatement) {
            XmlBackedJSClass xmlBackedClass;
            PsiElement grandParent = parent.getParent();
            if (parent instanceof ActionScriptConditionalCompileBlockImpl) {
                parent = grandParent;
            } else if (grandParent instanceof JSClass) {
                parent = grandParent;
            } else if (grandParent instanceof JSFile && (xmlBackedClass = JSResolveUtil.getXmlBackedClass((JSFile)grandParent)) != null) {
                return xmlBackedClass;
            }
        }
        return parent instanceof JSFile ? JSResolveUtil.findParentClass((JSFile)parent) : parent;
    }

    public static PsiElement findParentClass(@NotNull JSFile file2) {
        PsiFile containingFile;
        XmlBackedJSClass xmlBackedClass;
        if (file2 == null) {
            JSResolveUtil.$$$reportNull$$$0(37);
        }
        if ((xmlBackedClass = JSResolveUtil.getXmlBackedClass(file2)) != null) {
            return xmlBackedClass;
        }
        PsiElement forcedContext = JSResolveUtil.getContext((PsiElement)file2);
        if (forcedContext instanceof JSClass) {
            return forcedContext;
        }
        if (forcedContext instanceof JSFile) {
            return JSResolveUtil.findParentClass((JSFile)forcedContext);
        }
        if (forcedContext instanceof PsiFile && JavaScriptSupportLoader.isFlexMxmFile((PsiFile)forcedContext)) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)forcedContext);
        }
        if (forcedContext instanceof XmlElement && JavaScriptSupportLoader.isFlexMxmFile(containingFile = forcedContext.getContainingFile())) {
            return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)containingFile);
        }
        if (forcedContext != null) {
            JSClass jsClass = (JSClass)PsiTreeUtil.getParentOfType((PsiElement)forcedContext, JSClass.class);
            if (jsClass != null) {
                return jsClass;
            }
            PsiFile containingFile2 = forcedContext.getContainingFile();
            if (containingFile2 instanceof JSFile && containingFile2 != file2) {
                return JSResolveUtil.findParentClass((JSFile)containingFile2);
            }
        }
        return file2;
    }

    @Contract(value="null -> null")
    public static JSClass getClassOfContext(@Nullable PsiElement node) {
        return JSResolveUtil.getClassOfContext(node, false);
    }

    @Nullable
    public static JSClass getClassOfContext(@Nullable PsiElement node, boolean strict) {
        JSFunction fun;
        if (node == null) {
            return null;
        }
        if (strict && (fun = JSPsiImplUtils.getParentFunctionThroughLambdas(node)) != null) {
            PsiElement parent = JSResolveUtil.findParent((PsiElement)fun);
            return parent instanceof JSClass ? (JSClass)parent : null;
        }
        JSClass jsClass = (JSClass)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSClass.class});
        if (jsClass != null) {
            return jsClass;
        }
        PsiElement context = JSResolveUtil.getClassReferenceForXmlFromContext((PsiElement)node.getContainingFile());
        if (context instanceof JSClass) {
            return (JSClass)context;
        }
        return null;
    }

    @Nullable
    public static Pair<? extends PsiElement, String> getElementThatShouldBeQualified(PsiElement element, String fqn) {
        PsiElement parent;
        JSReferenceExpression reference = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{JSReferenceExpression.class});
        if (reference != null && ((parent = reference.getParent()) instanceof JSImportStatement || parent instanceof JSReferenceListMember && reference.getContainingFile().getContext() != null)) {
            return Pair.create((Object)reference, (Object)fqn);
        }
        if (element.getContainingFile() instanceof JSExpressionCodeFragment) {
            return Pair.create((Object)reference, (Object)fqn);
        }
        return null;
    }

    public static boolean isArtificialClassUsedForReferenceList(JSClass clazz) {
        return clazz.getContainingFile().getContext() != null;
    }

    public static Collection<JSQualifiedNamedElement> findElementsByName(String name, Project project, GlobalSearchScope scope) {
        return JSResolveUtil.findElementsByName(name, project, scope, true);
    }

    public static Collection<JSQualifiedNamedElement> findElementsByName(String name, Project project, GlobalSearchScope scope, boolean resultAsNavigatonElements) {
        HashSet<JSQualifiedNamedElement> result2 = new HashSet<JSQualifiedNamedElement>();
        Collection jsQualifiedNamedElements = StubIndex.getElements(JSNameIndex.KEY, (Object)name, (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class);
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (JSQualifiedNamedElement e : jsQualifiedNamedElements) {
            VirtualFile fileOrDir = e.getContainingFile().getVirtualFile();
            if (!projectFileIndex.isInLibrarySource(fileOrDir) ? !projectFileIndex.isInSource(fileOrDir) && !projectFileIndex.isInLibraryClasses(fileOrDir) && e.getContainingFile().getLanguage() == JavaScriptSupportLoader.ECMA_SCRIPT_L4 : ApplicationManager.getApplication().isUnitTestMode() && !projectFileIndex.isInLibraryClasses(fileOrDir)) continue;
            if (resultAsNavigatonElements) {
                PsiElement navElement = e.getNavigationElement();
                if (navElement instanceof JSQualifiedNamedElement) {
                    result2.add((JSQualifiedNamedElement)navElement);
                    continue;
                }
                result2.add(e);
                continue;
            }
            result2.add(e);
        }
        ArrayList files = new ArrayList(FilenameIndex.getVirtualFilesByName((Project)project, (String)(name + ".mxml"), (GlobalSearchScope)scope));
        for (VirtualFile file2 : files) {
            PsiFile psiFile;
            if (!file2.isValid() || !projectFileIndex.isInSource(file2) || !((psiFile = PsiManager.getInstance((Project)project).findFile(file2)) instanceof XmlFile)) continue;
            result2.add((JSQualifiedNamedElement)XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)psiFile));
        }
        return result2;
    }

    @Nullable
    public static JSType getTypeFromSetAccessor(JSFunctionItem fun) {
        JSParameterItem parameter = JSResolveUtil.getParameterFromSetAccessor(fun);
        return parameter != null ? parameter.getSimpleType() : null;
    }

    @Nullable
    public static JSParameterItem getParameterFromSetAccessor(@NotNull JSFunctionItem fun) {
        if (fun == null) {
            JSResolveUtil.$$$reportNull$$$0(38);
        }
        if (!fun.isSetProperty()) {
            return null;
        }
        JSParameterItem[] jsParameters = fun.getParameters();
        if (jsParameters.length != 1) {
            return null;
        }
        return jsParameters[0];
    }

    public static boolean processTopPackages(ResolveProcessor processor, ResolveState state, Project project, GlobalSearchScope scope) {
        if (processor.skipTopLevelItems()) {
            return true;
        }
        return JSPackageIndex.processElementsInScope("", processor.getName(), (file2, name, kind, isPublic) -> {
            if (kind != JSPackageIndexInfo.Kind.PACKAGE) {
                return true;
            }
            return processor.execute((PsiElement)new JSPackageWrapper(name, project, scope), state);
        }, scope, project);
    }

    public static boolean shouldProcessTopLevelGlobalContext(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        PsiElement placeParent;
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(40);
        }
        return JSResolveUtil.shouldProcessImports(place, processor) && (!((placeParent = place.getParent()) instanceof JSCallExpression) || place instanceof JSReferenceExpression && ((JSReferenceExpression)place).getQualifier() != null && ((ResolveProcessor)processor).needsAllVariants() || placeParent instanceof JSNewExpression);
    }

    public static boolean shouldProcessImports(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor) {
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(41);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(42);
        }
        if (!(processor instanceof ResolveProcessor) || ((ResolveProcessor)processor).isLocalResolve()) {
            return false;
        }
        return !(place instanceof JSReferenceExpression) || ((JSReferenceExpression)place).getQualifier() == null || ((ResolveProcessor)processor).needsAllVariants();
    }

    public static boolean processTopLevelClasses(ResolveProcessor processor, ResolveState state, Project project, GlobalSearchScope scope, GlobalSymbolsAcceptanceState acceptOnlyClasses, boolean acceptQualifiedElements) {
        boolean result2 = true;
        String resolvedName = processor.getName();
        if (resolvedName == null) {
            if (processor.skipTopLevelItems()) {
                return true;
            }
            for (String s : StubIndex.getInstance().getAllKeys(JSNameIndex.KEY, project)) {
                if (!processor.needTopLevelClassName(s) || "IArguments".equals(s)) continue;
                for (JSQualifiedNamedElement e : StubIndex.getElements(JSNameIndex.KEY, (Object)s, (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class)) {
                    if (e instanceof JSAttributeListOwner && ActionScriptResolveUtil.hasExcludeClassMetadata((JSAttributeListOwner)e) || !JSResolveUtil.acceptableSymbol(e, acceptOnlyClasses, acceptQualifiedElements, processor.place)) continue;
                    result2 &= processor.execute((PsiElement)e, state);
                }
            }
        } else {
            JSQualifiedNamedElement e;
            Iterator iterator = StubIndex.getElements(JSQualifiedElementIndex.KEY, (Object)resolvedName.hashCode(), (Project)project, (GlobalSearchScope)scope, JSQualifiedNamedElement.class).iterator();
            while (iterator.hasNext() && (!StringUtil.equals((CharSequence)(e = (JSQualifiedNamedElement)iterator.next()).getName(), (CharSequence)resolvedName) || !JSResolveUtil.acceptableSymbol(e, acceptOnlyClasses, acceptQualifiedElements, processor.place) || (result2 = processor.execute((PsiElement)e, state)))) {
            }
        }
        return result2;
    }

    public static boolean acceptableSymbol(JSQualifiedNamedElement e, GlobalSymbolsAcceptanceState acceptOnlyClasses, boolean acceptQualifiedElements, PsiElement place) {
        boolean isNotTopLevel;
        if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES ? !(e instanceof JSClass) : (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_NO_CLASSES ? e instanceof JSClass : acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS && !(e instanceof JSNamespaceDeclaration) && !(e instanceof JSVariable))) {
            return false;
        }
        String qName = e.getQualifiedName();
        boolean bl = isNotTopLevel = qName != null && qName.indexOf(46) != -1;
        if (!isNotTopLevel && !JSResolveUtil.isAccessibleSymbol(e, place)) {
            return false;
        }
        if (!acceptQualifiedElements && isNotTopLevel) {
            return false;
        }
        return !(e instanceof JSVariable) && !(e instanceof JSFunction) || DialectDetector.isActionScript((PsiElement)e);
    }

    public static boolean walkOverStructure(@NotNull PsiElement context, Processor<? super PsiNamedElement> processor) {
        PsiElement forcedContext;
        PsiNamedElement parent;
        if (context == null) {
            JSResolveUtil.$$$reportNull$$$0(43);
        }
        if ((parent = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class})) instanceof JSClass && (forcedContext = JSResolveUtil.getContext((PsiElement)parent)) instanceof XmlBackedJSClass && !processor.process((Object)((PsiNamedElement)forcedContext))) {
            return false;
        }
        while (parent != null) {
            if (parent instanceof JSFunctionExpression) {
                parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class});
                continue;
            }
            if (!processor.process((Object)parent)) {
                return false;
            }
            if (parent instanceof PsiFile) {
                PsiElement data = JSResolveUtil.getContext((PsiElement)parent);
                if (!(data instanceof JSElement)) break;
                parent = (PsiNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)data, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class});
                continue;
            }
            parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, JSFunction.class, PsiFile.class});
        }
        return true;
    }

    private static Map<String, String> doCalcOpenedNses(JSElement context) {
        class MyProcessor
        extends StructureResolveProcessor {
            Map<String, String> openedNses;

            MyProcessor() {
                super((String)null);
                this.putUserData(LOOKING_FOR_USE_NAMESPACES, true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                String nsValue;
                if (element == null) {
                    MyProcessor.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    MyProcessor.$$$reportNull$$$0(1);
                }
                if (element instanceof JSPackageStatement) {
                    return false;
                }
                if (!(element instanceof JSUseNamespaceDirective)) {
                    return true;
                }
                if (this.openedNses == null) {
                    this.openedNses = new THashMap(1);
                }
                if ((nsValue = JSPsiImplUtils.calcNamespaceReference(element)) != null) {
                    this.openedNses.put(nsValue, ((JSUseNamespaceDirective)element).getNamespaceToBeUsed());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$1MyProcessor";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        MyProcessor processor = new MyProcessor();
        JSResolveUtil.walkOverStructure((PsiElement)context, processor);
        return processor.openedNses;
    }

    public static Map<String, String> calculateOpenNses(PsiElement place) {
        Ref result2 = new Ref();
        JSResolveUtil.walkOverStructure(place, (Processor<? super PsiNamedElement>)((Processor)psiNamedElement -> {
            if (psiNamedElement instanceof JSElement) {
                result2.set((Object)((Map)CachedValuesManager.getProjectPsiDependentCache((PsiElement)((JSElement)psiNamedElement), JSResolveUtil::doCalcOpenedNses)));
            }
            return false;
        }));
        return result2.get() != null ? (Map)result2.get() : Collections.emptyMap();
    }

    public static boolean processGlobalThings(ResolveProcessor processor, ResolveState state, PsiElement place, PsiElement context) {
        boolean result2 = true;
        Project project = context.getProject();
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        PsiElement placeParent = place.getParent();
        if (JSResolveUtil.shouldProcessTopLevelGlobalContext(place, processor) && (!(place instanceof JSReferenceExpression) || placeParent instanceof JSReferenceExpression || placeParent instanceof JSNamedElement && ActionScriptFunctionImpl.getNamespaceReference((JSNamedElement)placeParent) == place || processor.needPackages() || processor.getName() == null)) {
            result2 = JSResolveUtil.processTopPackages(processor, state, project, scope);
        }
        if (result2 && !processor.needPackages()) {
            boolean refExpr = place instanceof JSReferenceExpression;
            GlobalSymbolsAcceptanceState acceptOnlyClasses = null;
            if (refExpr && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)place)) {
                acceptOnlyClasses = GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES;
            }
            if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES && processor.getName() == null && JSResolveUtil.isInsideArtificialAttrList((JSReferenceExpression)place)) {
                acceptOnlyClasses = null;
            }
            if (acceptOnlyClasses == GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES && placeParent instanceof JSImportStatement && processor.getName() == null) {
                acceptOnlyClasses = null;
            }
            if (placeParent instanceof JSUseNamespaceDirective) {
                acceptOnlyClasses = GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS;
            } else if (placeParent instanceof JSAttributeList && JSResolveUtil.isPlaceWhereNsCanBe(placeParent) || placeParent instanceof JSExpressionStatement && JSResolveUtil.isPlaceWhereNsCanBe(placeParent)) {
                PsiElement parent = JSResolveUtil.findParent(placeParent);
                acceptOnlyClasses = parent instanceof JSExpressionCodeFragment ? GlobalSymbolsAcceptanceState.ACCEPT_ONLY_CLASSES : (parent instanceof JSClass ? GlobalSymbolsAcceptanceState.ACCEPT_NAMESPACE_DECLARATIONS : GlobalSymbolsAcceptanceState.ACCEPT_NO_CLASSES);
            }
            result2 = JSResolveUtil.processTopLevelClasses(processor, state, project, scope, acceptOnlyClasses, true);
        }
        return result2;
    }

    public static boolean isInsideArtificialAttrList(JSReferenceExpression place) {
        if (place.getParent() instanceof JSAttributeList) {
            PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)place);
            if (next instanceof PsiErrorElement) {
                next = PsiTreeUtil.nextLeaf((PsiElement)next);
            }
            return next instanceof PsiWhiteSpace && next.textContains('\n');
        }
        return false;
    }

    public static void processParametersForUsedArgument(@NotNull JSExpression mainOccurrence, @NotNull JSArgumentList parent, @NotNull Processor<? super JSParameterItem> processor) {
        JSParameterItem parameter;
        PsiElement declaration;
        XmlAttribute attr;
        XmlAttributeDescriptor descriptor2;
        PsiElement context;
        if (mainOccurrence == null) {
            JSResolveUtil.$$$reportNull$$$0(44);
        }
        if (parent == null) {
            JSResolveUtil.$$$reportNull$$$0(45);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(46);
        }
        int _paramIndex = 0;
        for (JSExpression expr : parent.getArguments()) {
            if (expr == mainOccurrence) break;
            ++_paramIndex;
        }
        int paramIndex = _paramIndex;
        PsiElement firstChild = parent.getFirstChild();
        PsiElement originalFirstChild = PsiUtilCore.getOriginalElement((PsiElement)firstChild, firstChild.getClass());
        JSCallExpression originalElement = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)originalFirstChild, JSCallExpression.class);
        if (originalElement == null) {
            return;
        }
        JSExpression methodExpr = originalElement.getMethodExpression();
        if (methodExpr instanceof JSReferenceExpression) {
            ResolveResult[] results;
            for (ResolveResult r : results = ((JSReferenceExpression)methodExpr).multiResolve(false)) {
                JSParameterItem[] params;
                JSFunctionItem matchedFunction;
                PsiElement element = r.getElement();
                if (element == null || !element.isValid() || (matchedFunction = JSPsiImplUtils.calculatePossibleFunction(element, (PsiElement)methodExpr, false)) == null || !(paramIndex < (params = matchedFunction.getParameters()).length ? !processor.process((Object)params[paramIndex]) : params.length > 0 && params[params.length - 1].isRest() && !processor.process((Object)params[params.length - 1]))) continue;
                return;
            }
        } else if (methodExpr instanceof JSParenthesizedExpression && (context = methodExpr.getContainingFile().getContext()) instanceof XmlAttributeValue && (descriptor2 = (attr = (XmlAttribute)context.getParent()).getDescriptor()) instanceof AnnotationBackedDescriptor && (declaration = descriptor2.getDeclaration()) instanceof JSFunction && (parameter = JSResolveUtil.getParameterFromSetAccessor((JSFunctionItem)((JSFunction)declaration))) != null) {
            processor.process((Object)parameter);
        }
    }

    @Nullable
    public static JSParameterItem findParameterForUsedArgument(@NotNull JSExpression mainOccurrence, @NotNull JSArgumentList parent) {
        if (mainOccurrence == null) {
            JSResolveUtil.$$$reportNull$$$0(47);
        }
        if (parent == null) {
            JSResolveUtil.$$$reportNull$$$0(48);
        }
        Ref result2 = new Ref();
        JSResolveUtil.processParametersForUsedArgument(mainOccurrence, parent, (Processor<? super JSParameterItem>)((Processor)jsParameter -> {
            result2.set(jsParameter);
            return false;
        }));
        return (JSParameterItem)result2.get();
    }

    public static boolean isAccessibleSymbol(JSQualifiedNamedElement subject, PsiElement context) {
        if (ActionScriptResolveUtil.isFileLocalSymbol((PsiElement)subject)) {
            return context != null && JSResolveUtil.isFileLocalSymbolAccessible((PsiElement)subject, context);
        }
        return true;
    }

    private static boolean isFileLocalSymbolAccessible(PsiElement subject, PsiElement context) {
        PsiElement fragmentContext;
        PsiFile contextFile = context.getContainingFile().getOriginalFile();
        if (contextFile instanceof PsiCodeFragment && (fragmentContext = JSResolveUtil.getContext((PsiElement)contextFile)) != null) {
            contextFile = fragmentContext.getContainingFile();
        }
        return subject.getContainingFile() == contextFile;
    }

    public static boolean isAccessibleFromCurrentActionScriptPackage(PsiElement element, PsiElement place) {
        return JSResolveUtil.isAccessibleFromCurrentActionScriptPackage(element, place != null ? JSResolveUtil.getPackageNameFromPlace(place) : null, place);
    }

    public static boolean isAccessibleFromCurrentActionScriptPackage(PsiElement element, String packageName2, PsiElement place) {
        JSAttributeList attrList;
        if (place == null || element != null && !DialectDetector.isActionScript(element)) {
            return true;
        }
        if (packageName2 == null) {
            return false;
        }
        PsiFile containingFile = place.getContainingFile();
        if (place.getParent() instanceof JSReferenceListMember && containingFile instanceof JSFile && XmlBackedJSClassImpl.isImplementsAttribute((JSFile)containingFile) && element instanceof JSAttributeListOwner && (attrList = ((JSAttributeListOwner)element).getAttributeList()) != null && attrList.getAccessType() != JSAttributeList.AccessType.PUBLIC) {
            return false;
        }
        if (!JSResolveUtil.isAccessibleFromActionScriptPackage(element, packageName2)) {
            return (JSResolveUtil.getPackageName(element).isEmpty() || packageName2.isEmpty()) && (ActionScriptResolveUtil.isFileLocalSymbol(element) && JSResolveUtil.isFileLocalSymbolAccessible(element, place) || ResolveProcessor.toSkipPackageLocalCheck(place));
        }
        return true;
    }

    private static boolean isQualifiedAS2Symbol(PsiElement element) {
        String qName;
        return element instanceof JSQualifiedNamedElement && (qName = ((JSQualifiedNamedElement)element).getQualifiedName()) != null && !StringUtil.getPackageName((String)qName).isEmpty() && JSResolveUtil.findParent(element) instanceof JSFile;
    }

    public static String getPackageNameFromPlace(@NotNull PsiElement place) {
        String packageName2;
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(49);
        }
        JSQualifiedNamedElement namedElement = (JSQualifiedNamedElement)PsiTreeUtil.getContextOfType((PsiElement)place, (boolean)false, (Class[])Holder.PACKAGE_ELEMENTS);
        while (namedElement instanceof JSFunction || namedElement instanceof JSVariable || namedElement instanceof JSDefinitionExpression) {
            PsiElement namedElementParent = JSResolveUtil.findParent((PsiElement)namedElement);
            if (namedElementParent instanceof JSQualifiedNamedElement) {
                namedElement = (JSQualifiedNamedElement)namedElementParent;
                continue;
            }
            namedElement = (JSQualifiedNamedElement)PsiTreeUtil.getContextOfType((PsiElement)namedElementParent, (boolean)true, (Class[])new Class[]{JSQualifiedNamedElement.class});
        }
        if (namedElement == null) {
            PsiFile containingFile = place.getContainingFile().getOriginalFile();
            PsiElement context = containingFile.getContext();
            if (context != null) {
                containingFile = context.getContainingFile().getOriginalFile();
            }
            if (JavaScriptSupportLoader.isMxmlOrFxgFile(containingFile)) {
                return JSResolveUtil.getExpectedPackageNameFromFile(containingFile.getVirtualFile(), containingFile.getProject());
            }
        }
        String string = namedElement instanceof JSPackageStatement || namedElement instanceof TypeScriptModule ? namedElement.getQualifiedName() : (packageName2 = namedElement != null ? JSResolveUtil.getPackageName((PsiElement)namedElement) : "");
        if (packageName2 == null) {
            packageName2 = "";
        }
        return packageName2;
    }

    @NotNull
    public static String getPackageName(PsiElement element) {
        PsiElement parent = JSResolveUtil.findParent(element);
        if (parent instanceof JSClass) {
            return JSResolveUtil.getPackageName(parent);
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(element);
        if (!(dialect == DialectOptionHolder.ECMA_4 || dialect != null && dialect.isTypeScript)) {
            return "";
        }
        JSQualifiedName namespace = ((JSQualifiedNamedElement)element).getNamespace();
        return namespace != null ? namespace.getQualifiedName() : "";
    }

    private JSResolveUtil() {
    }

    public static void treeWalkUp(JSResolveProcessor processor, PsiElement elt, PsiElement lastParent, PsiElement place) {
        JSResolveUtil.treeWalkUp(processor, elt, lastParent, place, null);
    }

    public static void treeWalkUp(JSResolveProcessor processor, PsiElement elt, PsiElement lastParent, PsiElement place, PsiElement terminatingParent) {
        boolean isExecutionScopeChanged = false;
        while (elt != null && !(elt instanceof PsiDirectory)) {
            boolean finish;
            PsiElement parentElement;
            TreeWalkUpResult result2;
            if (elt instanceof JSExecutionScope) {
                isExecutionScopeChanged = true;
            }
            if ((result2 = JSResolveUtil.processSiblingsForElement(processor, elt, lastParent, place, terminatingParent, parentElement = elt.getContext(), isExecutionScopeChanged)) == TreeWalkUpResult.RETURN) {
                return;
            }
            boolean bl = finish = result2 == TreeWalkUpResult.RETURN_AFTER_POST_PROCESSING;
            if (elt instanceof PsiFile) {
                parentElement = JSResolveUtil.processFileElement(processor, elt, place, parentElement);
            }
            if (finish) {
                return;
            }
            lastParent = elt;
            elt = parentElement;
        }
        return;
    }

    @NotNull
    private static TreeWalkUpResult processSiblingsForElement(@NotNull JSResolveProcessor processor, @NotNull PsiElement elt, PsiElement lastParent, PsiElement place, PsiElement terminatingParent, PsiElement parentElement, boolean isExecutionScopeChanged) {
        int initialIndex;
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(50);
        }
        if (elt == null) {
            JSResolveUtil.$$$reportNull$$$0(51);
        }
        boolean parentIsClass = parentElement instanceof JSClass;
        PsiElement[] children = JSResolveUtil.getSiblingsToProcess(elt, parentElement, isExecutionScopeChanged);
        int index = initialIndex = JSResolveUtil.indexOfElement(elt, children);
        Object cur = elt;
        TreeWalkUpResult result2 = TreeWalkUpResult.CONTINUE;
        do {
            PsiElement actualLastParent;
            Object object = actualLastParent = cur == elt ? lastParent : null;
            if ((cur instanceof JSElement || cur instanceof XmlElement) && !cur.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), actualLastParent, place)) {
                if (!JSResolveUtil.canHaveDeclarationsBefore(cur) || actualLastParent != null) {
                    TreeWalkUpResult treeWalkUpResult = TreeWalkUpResult.RETURN;
                    if (treeWalkUpResult == null) {
                        JSResolveUtil.$$$reportNull$$$0(52);
                    }
                    return treeWalkUpResult;
                }
                result2 = TreeWalkUpResult.RETURN;
            }
            if (terminatingParent != cur) continue;
            TreeWalkUpResult treeWalkUpResult = TreeWalkUpResult.RETURN_AFTER_POST_PROCESSING;
            if (treeWalkUpResult == null) {
                JSResolveUtil.$$$reportNull$$$0(53);
            }
            return treeWalkUpResult;
        } while (!(cur instanceof PsiFile) && !parentIsClass && (!(cur instanceof JSStatement) || !(parentElement instanceof JSIfStatement)) && (cur = index == -1 ? cur.getPrevSibling() : (index == initialIndex + 1 ? null : (index == 0 ? ((index = children.length - 1) > initialIndex ? children[index] : null) : children[--index]))) != null);
        TreeWalkUpResult treeWalkUpResult = result2;
        if (treeWalkUpResult == null) {
            JSResolveUtil.$$$reportNull$$$0(54);
        }
        return treeWalkUpResult;
    }

    private static boolean canHaveDeclarationsBefore(@Nullable PsiElement cur) {
        if (cur instanceof TypeScriptModule) {
            return true;
        }
        if (cur instanceof TypeScriptFunction || cur instanceof TypeScriptClass) {
            return TypeScriptPsiUtil.isAmbientDeclaration(cur);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PsiElement processFileElement(@NotNull JSResolveProcessor processor, @NotNull PsiElement elt, @NotNull PsiElement place, @Nullable PsiElement parentElement) {
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(55);
        }
        if (elt == null) {
            JSResolveUtil.$$$reportNull$$$0(56);
        }
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(57);
        }
        if (elt instanceof XmlFile) {
            JSResolveUtil.processXmlElement(processor, (XmlFile)elt, place);
            if (parentElement != null) {
                return parentElement.getContainingFile();
            }
        } else if (elt instanceof JSFile) {
            FileViewProvider provider;
            if (parentElement == null) return JSResolveUtil.getContext(elt);
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parentElement, XmlTag.class);
            if (tag != null) {
                PsiFile containingFile = parentElement.getContainingFile();
                while (tag != null) {
                    for (XmlBackedJSClassProvider provider2 : XmlBackedJSClassProvider.EP_NAME.getExtensionList()) {
                        if (!provider2.canCreateClassFromTag(tag)) continue;
                        XmlBackedJSClass clazz = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(tag);
                        if (!clazz.processOuterDeclarations((PsiScopeProcessor)processor)) {
                            return null;
                        }
                        clazz.processDeclarations((PsiScopeProcessor)processor, ResolveState.initial(), (PsiElement)clazz, place);
                        return null;
                    }
                    tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)tag, XmlTag.class);
                }
                return containingFile;
            }
            PsiElement topResonableParent = PsiTreeUtil.getParentOfType((PsiElement)parentElement, (Class[])new Class[]{PsiFile.class, JSExecutionScope.class});
            if (topResonableParent instanceof PsiFile && (provider = ((PsiFile)topResonableParent).getViewProvider()) instanceof MultiplePsiFilesPerDocumentFileViewProvider && topResonableParent == provider.getPsi(provider.getBaseLanguage())) {
                return null;
            }
        } else if (parentElement != null) {
            return parentElement.getContainingFile();
        }
        if (elt instanceof JSExpressionCodeFragment || parentElement != null) return parentElement;
        return null;
    }

    private static int indexOfElement(@NotNull PsiElement elt, PsiElement @Nullable [] children) {
        if (elt == null) {
            JSResolveUtil.$$$reportNull$$$0(58);
        }
        int initialIndex = -1;
        if (children != null && children.length > 0) {
            initialIndex = 0;
            for (PsiElement el : children) {
                if (el == elt) break;
                ++initialIndex;
            }
        }
        return initialIndex;
    }

    private static void processXmlElement(PsiScopeProcessor processor, XmlFile xmlFile, PsiElement place) {
        XmlTag rootTag;
        XmlDocument document2 = xmlFile.getDocument();
        XmlTag xmlTag = rootTag = document2 != null ? document2.getRootTag() : null;
        if (JavaScriptSupportLoader.isFlexMxmFile((PsiFile)xmlFile)) {
            JSResolveUtil.processAllGlobalsInXmlFile(processor, xmlFile, place);
        } else if (rootTag != null && xmlFile.getFileType() == XmlFileType.INSTANCE) {
            JSResolveUtil.processAllGlobalsInXmlFile(processor, xmlFile, place);
        }
    }

    public static boolean processAllGlobalsInXmlFile(PsiScopeProcessor processor, XmlFile xmlFile, PsiElement place) {
        XmlBackedJSClass clazz = XmlBackedJSClassFactory.getXmlBackedClass(xmlFile);
        return clazz == null || clazz.processDeclarations(processor, ResolveState.initial(), (PsiElement)clazz, place);
    }

    public static void tryProcessXmlFileImplicitElements(@NotNull PsiElement context, @NotNull WalkUpResolveProcessor processor) {
        if (context == null) {
            JSResolveUtil.$$$reportNull$$$0(59);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(60);
        }
        PsiFile file2 = context.getContainingFile();
        XmlFile xmlFile = null;
        if (file2 instanceof XmlFile) {
            xmlFile = (XmlFile)file2;
        } else {
            PsiFile outerFile;
            PsiElement fileContext = file2.getContext();
            if (fileContext != null && (outerFile = fileContext.getContainingFile()) instanceof XmlFile) {
                xmlFile = (XmlFile)outerFile;
            }
        }
        if (xmlFile == null) {
            return;
        }
        VirtualFile virtualFile = xmlFile.getVirtualFile();
        if (virtualFile != null && JSImplicitElementsIndex.Holder.containFileType(virtualFile.getFileType())) {
            return;
        }
        Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> elements = JSIndexContent.get((PsiFile)xmlFile).getImplicitElements();
        Collection<JSImplicitElementsIndex.JSElementProxy> proxies = elements.get(processor.getRequiredName());
        if (proxies != null) {
            for (JSImplicitElementsIndex.JSElementProxy proxy : proxies) {
                processor.doQualifiedCheck((JSPsiElementBase)proxy.toOffsetBasedImplicitElement((PsiFile)xmlFile));
            }
        }
    }

    public static boolean tryProcessAllElementsInInjectedContext(@NotNull PsiFile file2, final @NotNull Processor<? super JSPsiElementBase> processor) {
        if (file2 == null) {
            JSResolveUtil.$$$reportNull$$$0(61);
        }
        if (processor == null) {
            JSResolveUtil.$$$reportNull$$$0(62);
        }
        if (!(file2 instanceof JSFile) || InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2) == null) {
            return true;
        }
        final Ref stopped = Ref.create((Object)false);
        new JSRecursiveWalkingElementVisitor(){

            public void visitJSElement(JSElement node) {
                Collection elements;
                JSElementIndexingData data;
                if (node instanceof JSFunctionExpression) {
                    return;
                }
                if (node instanceof JSPsiElementBase && !processor.process((Object)((JSPsiElementBase)node))) {
                    this.stopWalking();
                }
                if (node instanceof JSImplicitElementProvider && (data = ((JSImplicitElementProvider)node).getIndexingData()) != null && (elements = data.getImplicitElements()) != null) {
                    for (JSImplicitElement implicitElement : elements) {
                        if (processor.process((Object)implicitElement)) continue;
                        this.stopWalking();
                    }
                }
                super.visitJSElement(node);
            }

            public void stopWalking() {
                super.stopWalking();
                stopped.set((Object)true);
            }
        }.visitJSElement((JSElement)((JSFile)file2));
        return (Boolean)stopped.get() == false;
    }

    private static PsiElement[] getSiblingsToProcess(PsiElement element, PsiElement parent, boolean isExecutionScopeChanged) {
        if (!(parent instanceof JSFile || parent instanceof JSBlockStatement && (isExecutionScopeChanged || parent.getParent() instanceof JSNamedElement) || parent instanceof JSSwitchStatement && element instanceof JSCaseClause)) {
            return null;
        }
        return (PsiElement[])CachedValuesManager.getManager((Project)parent.getProject()).getParameterizedCachedValue((UserDataHolder)parent, CHILDREN_TO_PROCESS_KEY, CHILDREN_TO_PROCESS_PROVIDER, false, (Object)parent);
    }

    @Nullable
    public static JSExpression getRealRefExprQualifier(JSReferenceExpression expr) {
        if (!(expr instanceof JSReferenceExpressionImpl)) {
            return null;
        }
        JSExpression qualifier = ((JSReferenceExpressionImpl)expr).getResolveQualifier();
        if (qualifier != null) {
            return qualifier;
        }
        if (JSResolveUtil.isExprInTypeContext(expr) && DialectDetector.isActionScript((PsiElement)expr)) {
            JSImportedElementResolveResult resolved = JSImportHandlingUtil.resolveTypeNameUsingImports(expr);
            if (resolved == null) {
                return expr.getQualifier();
            }
            return JSResolveUtil.getRealRefExprQualifierFromResult(expr, resolved);
        }
        return null;
    }

    @Nullable
    public static JSExpression getRealRefExprQualifierFromResult(JSReferenceExpression expr, JSImportedElementResolveResult resolved) {
        GenericSignature signature = JSResolveUtil.extractGenericSignature(resolved.qualifiedName);
        String typeWithoutSignature = signature != null ? signature.elementType : resolved.qualifiedName;
        return JSPsiElementFactory.createJSExpression(typeWithoutSignature, (PsiElement)expr, JSReferenceExpression.class).getQualifier();
    }

    public static String findPackageStatementQualifier(PsiElement context) {
        String s;
        if (context instanceof JSClass && (s = ((JSClass)context).getQualifiedName()) != null) {
            int i = s.lastIndexOf(46);
            if (i != -1) {
                return s.substring(0, i);
            }
            return null;
        }
        JSQualifiedNamedElement packageOrModuleStatement = (JSQualifiedNamedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{JSPackageStatement.class, TypeScriptModule.class});
        if (packageOrModuleStatement != null) {
            return packageOrModuleStatement.getQualifiedName();
        }
        return null;
    }

    public static boolean isExprInStrictTypeContext(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            JSResolveUtil.$$$reportNull$$$0(63);
        }
        for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
            if (helper.isStrictTypeContext((PsiElement)expr)) continue;
            return false;
        }
        PsiElement parent = expr.getParent();
        if (parent instanceof JSReferenceListMember) {
            parent = parent.getParent();
        }
        if (parent instanceof TypeScriptParenthesizedType) {
            parent = TypeScriptPsiUtil.getParentSkipTypeParentheses((JSTypeDeclaration)((TypeScriptType)parent));
        }
        if (parent instanceof JSGenericSignature || parent instanceof JSImportStatement || parent instanceof JSReferenceList && !(parent instanceof ES6ReferenceList) || parent instanceof TypeScriptType && !(parent instanceof TypeScriptTypeofType) || parent instanceof JSExpressionCodeFragment && ((JSExpressionCodeFragment)parent).isTypeContext()) {
            return true;
        }
        if (parent instanceof JSFunction && ((JSFunction)parent).getReturnTypeElement() == expr) {
            return true;
        }
        return parent instanceof JSVariable && ((JSVariable)parent).getTypeElement() == expr;
    }

    public static boolean isExprInTypeContext(JSReferenceExpression expr) {
        PsiElement parent = expr.getParent();
        return JSResolveUtil.isExprInStrictTypeContext(expr) || parent instanceof JSNewExpression || parent instanceof JSBinaryExpression && ((JSBinaryExpression)parent).getROperand() == expr && (((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.IS_KEYWORD || ((JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.AS_KEYWORD);
    }

    @Nullable
    public static VirtualFile findPredefinedOrLibraryFile(Project project, String fileName) {
        JSPredefinedLibraryManager manager2 = JSPredefinedLibraryManager.getPredefinedLibraryManager(project);
        VirtualFile vf = manager2.findPredefinedFileByName(fileName);
        if (vf != null) {
            return vf;
        }
        JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
        return libraryManager.getMatchingFile(fileName);
    }

    @NotNull
    public static GlobalSearchScope getJavaScriptSymbolsResolveScope(@NotNull Project project) {
        GlobalSearchScope allScope;
        if (project == null) {
            JSResolveUtil.$$$reportNull$$$0(64);
        }
        if ((allScope = (GlobalSearchScope)project.getUserData(PROJECT_SCOPE_WITH_PREDEFINED_KEY)) == null) {
            allScope = GlobalSearchScope.allScope((Project)project);
            allScope = new AdditionalIndexedRootsScope(allScope, (IndexableFileSet)new AdditionalIndexableFileSet(project, new IndexableSetContributor[]{(IndexableSetContributor)IndexableSetContributor.EP_NAME.findExtension(JSIndexedRootProvider.class)}));
            project.putUserData(PROJECT_SCOPE_WITH_PREDEFINED_KEY, (Object)allScope);
        }
        GlobalSearchScope globalSearchScope = allScope;
        if (globalSearchScope == null) {
            JSResolveUtil.$$$reportNull$$$0(65);
        }
        return globalSearchScope;
    }

    @NotNull
    public static GlobalSearchScope getScopeExcludingJsLibs(@NotNull Module module) {
        if (module == null) {
            JSResolveUtil.$$$reportNull$$$0(66);
        }
        Project project = module.getProject();
        GlobalSearchScope globalSearchScope = (GlobalSearchScope)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope allLibFiles = ScriptingLibraryUtil.getFilesAndDirectoriesScope((Project)project, (Set)((JSIndexedRootProvider)((Object)((Object)IndexableSetContributor.EP_NAME.findExtension(JSIndexedRootProvider.class)))).getLibraryFiles(project));
            GlobalSearchScope moduleContentScope = module.getModuleContentWithDependenciesScope();
            GlobalSearchScope moduleWithDependenciesAndLibrariesScope = module.getModuleWithDependenciesAndLibrariesScope(true);
            GlobalSearchScope result2 = moduleContentScope.uniteWith(moduleWithDependenciesAndLibrariesScope).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)allLibFiles));
            return new CachedValueProvider.Result((Object)result2, new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
        if (globalSearchScope == null) {
            JSResolveUtil.$$$reportNull$$$0(67);
        }
        return globalSearchScope;
    }

    @NotNull
    public static JSNamespace buildNamespaceForQualifier(JSExpression qualifier) {
        List<String> nameIds;
        if (qualifier == null) {
            nameIds = JSSymbolUtil.buildNameIndexArray(null);
        } else {
            JSNamespace ns = JSSymbolUtil.evaluateNamespaceLocally(qualifier);
            if (ns != null && ns.getQualifiedName() != null) {
                JSNamespace jSNamespace = ns;
                if (jSNamespace == null) {
                    JSResolveUtil.$$$reportNull$$$0(68);
                }
                return jSNamespace;
            }
            nameIds = Collections.singletonList("");
        }
        JSNamespace jSNamespace = JSNamedTypeFactory.createNamespace((JSQualifiedName)JSQualifiedNameImpl.fromComponents(nameIds), JSContext.UNKNOWN, (PsiElement)qualifier, true);
        if (jSNamespace == null) {
            JSResolveUtil.$$$reportNull$$$0(69);
        }
        return jSNamespace;
    }

    public static boolean iterateOverrides(@NotNull JSPsiElementBase node, @Nullable JSClass classToStartHierarchySearch, @NotNull JSOverrideHandler handler, boolean onlyFunctions) {
        String namespace;
        boolean processedClassOverrides;
        JSNamespace ns;
        JSClass context;
        JSClass parentClass;
        if (node == null) {
            JSResolveUtil.$$$reportNull$$$0(70);
        }
        if (handler == null) {
            JSResolveUtil.$$$reportNull$$$0(71);
        }
        JSClass jSClass = parentClass = classToStartHierarchySearch != null ? classToStartHierarchySearch : JSUtils.getMemberContainingClass((PsiElement)node);
        if (parentClass != null && node instanceof JSFunction && ((JSFunction)node).isConstructor()) {
            return true;
        }
        Object object = context = parentClass != null ? parentClass : node.getContainingFile();
        if (classToStartHierarchySearch != null) {
            ns = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)classToStartHierarchySearch, true);
            if (ns == null) {
                return true;
            }
            ns = JSNamedTypeFactory.copyWithJSContext(ns, JSContext.INSTANCE);
        } else {
            ns = node.getJSNamespace();
        }
        String name = node.getName();
        if (name == null) {
            return true;
        }
        if (!(parentClass == null || (processedClassOverrides = JSInheritanceUtil.processOverrides(parentClass, handler, name, namespace = JSResolveUtil.getNamespaceValue(((JSAttributeListOwner)node).getAttributeList()), (PsiElement)node, onlyFunctions)) && DialectDetector.isJavaScript((PsiElement)parentClass))) {
            return processedClassOverrides;
        }
        GlobalSearchScope resolveScope = JSResolveUtil.getResolveScope((PsiElement)context);
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forElement((PsiElement)context).getClassResolver();
        THashSet visited = new THashSet();
        return JSTypeEvaluateManager.iterateTypeHierarchyFromBaseTypesIndex((PsiElement)context, ns, true, true, (Processor<JSType>)((Processor)arg_0 -> JSResolveUtil.lambda$iterateOverrides$12((Set)visited, name, resolver, resolveScope, handler, (PsiElement)context, arg_0)));
    }

    @Nullable
    public static String getNamespaceValue(JSAttributeList attributeList) {
        if (attributeList == null) {
            return null;
        }
        String namespace_id = attributeList.getNamespace();
        if (namespace_id == null) {
            return null;
        }
        return attributeList.resolveNamespaceValue();
    }

    @Nullable
    public static String getQNameToStartHierarchySearch(JSPsiElementBase node) {
        return JSNamespace.getQualifiedName((JSNamespace)JSResolveUtil.getNamespaceToStartHierarchySearch(node));
    }

    @Nullable
    public static JSNamespace getNamespaceToStartHierarchySearch(@NotNull JSPsiElementBase node) {
        if (node == null) {
            JSResolveUtil.$$$reportNull$$$0(72);
        }
        if (node instanceof JSFunction && node.getNamespace() != null && !JSSymbolUtil.isConstructorSymbol(node)) {
            return node.getJSNamespace();
        }
        PsiElement parentNode = JSResolveUtil.findParent((PsiElement)node);
        if (parentNode instanceof JSClass) {
            if (JSResolveUtil.isActionScriptClassMemberExceptOverride(node)) {
                return null;
            }
            return node.getJSNamespace();
        }
        if (node instanceof JSFunctionExpression && !DialectDetector.isActionScript((PsiElement)node)) {
            return JSContextResolver.resolveContext(node.getFirstChild());
        }
        if (parentNode instanceof JSFile && !DialectDetector.isActionScript(parentNode)) {
            return JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)node, true);
        }
        if (node instanceof JSDefinitionExpression) {
            JSExpression expression = ((JSDefinitionExpression)node).getExpression();
            if (expression instanceof JSReferenceExpression) {
                JSExpression expr = JSSymbolUtil.isConstructorSymbol(node) ? expression : ((JSReferenceExpression)expression).getQualifier();
                return JSSymbolUtil.evaluateNamespaceLocally(expr);
            }
        } else if (node instanceof JSVariable) {
            return JSContextResolver.resolveContext((PsiElement)node);
        }
        return null;
    }

    public static boolean isActionScriptClassMemberExceptOverride(@NotNull JSPsiElementBase member) {
        if (member == null) {
            JSResolveUtil.$$$reportNull$$$0(73);
        }
        if (DialectDetector.isActionScript((PsiElement)member) && JSResolveUtil.findParent((PsiElement)member) instanceof JSClass) {
            JSAttributeList attributeList;
            JSAttributeList jSAttributeList = attributeList = member instanceof JSAttributeListOwner ? ((JSAttributeListOwner)member).getAttributeList() : null;
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE) || attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInPlaceWhereTypeCanBeDuringCompletion(PsiElement expr) {
        PsiElement parent = expr.getParent();
        if (parent instanceof JSArgumentList || parent instanceof JSVariable && ((JSVariable)parent).getInitializer() == expr) {
            if (expr instanceof JSReferenceExpression) {
                JSExpression qualifier = ((JSReferenceExpression)expr).getQualifier();
                return qualifier == null || qualifier instanceof JSReferenceExpression;
            }
            return true;
        }
        if (parent instanceof JSExpressionStatement) {
            if (expr instanceof JSReferenceExpression) {
                return ((JSReferenceExpression)expr).getQualifier() == null;
            }
            return true;
        }
        return false;
    }

    public static boolean isPlaceWhereNsCanBe(PsiElement parent) {
        PsiElement grandParent = parent.getParent();
        return grandParent instanceof JSClass || grandParent instanceof JSPackageStatement || grandParent instanceof JSFile && grandParent.getContext() == null;
    }

    @Nullable
    public static String getTypeFromTagNameInMxml(@Nullable PsiElement psiElement) {
        JSClass clazz = JSResolveUtil.getClassFromTagNameInMxml(psiElement);
        return clazz != null ? clazz.getQualifiedName() : null;
    }

    public static JSClass getClassFromTagNameInMxml(PsiElement psiElement) {
        XmlTag tag;
        XmlTag xmlTag = tag = psiElement != null ? (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{XmlTag.class}) : null;
        if (tag != null && (!tag.getNamespacePrefix().isEmpty() || JavaScriptSupportLoader.isFlexMxmFile(tag.getContainingFile()))) {
            XmlElementDescriptor descriptor2;
            if ("Script".equals(tag.getLocalName())) {
                tag = ((XmlFile)tag.getContainingFile()).getDocument().getRootTag();
            }
            if ((descriptor2 = tag.getDescriptor()) != null) {
                PsiElement decl = descriptor2.getDeclaration();
                if (decl instanceof JSClass) {
                    return (JSClass)decl;
                }
                if (decl instanceof XmlFile) {
                    return XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)decl);
                }
            }
        }
        return null;
    }

    @NotNull
    public static <T extends PsiPolyVariantReference> ResolveResult[] resolve(final PsiFile file2, final @NotNull T instance, final @NotNull ResolveCache.PolyVariantResolver<T> resolver, final boolean incompleteCode) {
        if (instance == null) {
            JSResolveUtil.$$$reportNull$$$0(74);
        }
        if (resolver == null) {
            JSResolveUtil.$$$reportNull$$$0(75);
        }
        if (file2 == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                JSResolveUtil.$$$reportNull$$$0(76);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] value = JSComplexityAwareRecursionGuard.getCachedValue(JSEvaluatorComplexityTracker.getDefaultInstance(), new JSNamedEvaluationTask<ResolveResult[]>(){

            @Override
            public ResolveResult[] get() {
                return resolver.resolve(instance, incompleteCode);
            }

            public String toString() {
                return "JSResolveUtil.resolve of " + JSEvaluationLogger.toPresentable(instance.getElement());
            }
        }, new JSComplexityAwareRecursionGuard.CachingEvaluator(){

            public <U> U calculateWithCaching(Supplier<U> supplier) {
                return (U)ResolveCache.getInstance((Project)file2.getProject()).resolveWithCaching((PsiReference)instance, (_1, _2) -> supplier.get(), false, incompleteCode);
            }
        });
        ResolveResult[] resolveResultArray = value != null ? value : ResolveResult.EMPTY_ARRAY;
        if (resolveResultArray == null) {
            JSResolveUtil.$$$reportNull$$$0(77);
        }
        return resolveResultArray;
    }

    public static void clearResolveCaches(PsiFile file2) {
        ResolveCache.getInstance((Project)file2.getProject()).clearCache(true);
    }

    private static boolean isOutOfScope(@Nullable Object value, @NotNull JSElement _scope, @NotNull PsiElement place, PsiScopeProcessor processor) {
        if (_scope == null) {
            JSResolveUtil.$$$reportNull$$$0(78);
        }
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(79);
        }
        if (value instanceof PsiElement && ((PsiElement)value).getParent() instanceof ES6ExportDefaultAssignment && !PsiTreeUtil.isAncestor((PsiElement)_scope, (PsiElement)place, (boolean)true)) {
            return true;
        }
        if ((!(processor instanceof SinkResolveProcessor) || ((SinkResolveProcessor)processor).getResultSink() instanceof ResolveResultSink) && value instanceof PsiElement && place instanceof JSReferenceExpression && JSResolveUtil.isIllegalPlaceForPrivate((PsiElement)value, place)) {
            if (processor instanceof SinkResolveProcessor) {
                ((SinkResolveProcessor)processor).addPossibleCandidateResult((PsiElement)value, "javascript.private.member.is.not.accessible.without.sharp.message");
            }
            return true;
        }
        return false;
    }

    public static boolean isIllegalPlaceForPrivate(@Nullable PsiElement value, @NotNull PsiElement place) {
        if (place == null) {
            JSResolveUtil.$$$reportNull$$$0(80);
        }
        return !JSUtils.isPrivateFieldSharpAccessContext(place) && JSUtils.isPrivateSharpItem(value);
    }

    @Deprecated
    public static boolean processDeclarationsInScope(JSElement _scope, PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        JSElement scope = (JSElement)CompletionUtilCoreImpl.getOriginalElement((PsiElement)_scope);
        if (scope == null) {
            return true;
        }
        String requiredName = null;
        boolean toProcessImplicits = true;
        if (processor instanceof JSResolveProcessor) {
            requiredName = ((JSResolveProcessor)processor).getName();
        }
        if (processor instanceof ResolveProcessor) {
            ResolveProcessor resolveProcessor = (ResolveProcessor)processor;
            toProcessImplicits = !resolveProcessor.isProcessingFromIndices();
        }
        boolean result2 = true;
        List<JSElement> elements = JSScopeNamesCache.getNamedElementsInScope(scope, requiredName, false);
        for (JSElement value : elements) {
            if (JSResolveUtil.isOutOfScope(value, _scope, place, processor)) continue;
            result2 &= value.processDeclarations(processor, state, null, place);
        }
        if (result2 && toProcessImplicits && scope instanceof JSClassBase) {
            processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_STARTED, (Object)scope);
            for (JSClass clazz : ((JSClassBase)scope).getImplicitlyDeclaredInterfaces()) {
                result2 = clazz.processDeclarations(processor, state, lastParent, place);
            }
            processor.handleEvent(ResolveProcessor.INHERITED_CLASSES_FINISHED, (Object)scope);
        }
        return result2;
    }

    @NotNull
    public static Collection<JSElement> findNamedElementsInScope(@NotNull String name, @NotNull JSElement scope) {
        if (name == null) {
            JSResolveUtil.$$$reportNull$$$0(81);
        }
        if (scope == null) {
            JSResolveUtil.$$$reportNull$$$0(82);
        }
        if (scope.isValid()) {
            JSElement originalElement = (JSElement)CompletionUtilCoreImpl.getOriginalElement((PsiElement)scope);
            if (originalElement != null) {
                scope = originalElement;
            }
        } else {
            Logger.getInstance(JSResolveUtil.class).error("scope must be valid");
        }
        List<JSElement> list2 = JSScopeNamesCache.getNamedElementsInScope(scope, name, false);
        if (list2 == null) {
            JSResolveUtil.$$$reportNull$$$0(83);
        }
        return list2;
    }

    @Nullable
    public static PsiElement getLocalVariableRef(@Nullable JSFunction function2, JSReferenceExpression expr) {
        return expr.getQualifier() == null ? JSResolveUtil.getLocalVariableRef(function2, expr.getReferenceName()) : null;
    }

    @Nullable
    public static PsiElement getLocalVariableRef(@Nullable JSFunction function2, @Nullable String referencedName) {
        if (referencedName != null) {
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(referencedName, true, new ResolveResultSink(null, referencedName));
            while (function2 != null) {
                boolean val = function2.processDeclarations(processor, ResolveState.initial(), (PsiElement)function2.getParameterList(), (PsiElement)function2);
                if (!val) {
                    return processor.getResult();
                }
                if ((function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)function2, JSFunction.class)) != null) continue;
                break;
            }
        }
        return null;
    }

    public static JSSourceElement[] getSourceElements(PsiElement owner) {
        if (owner instanceof JSStubElementImpl) {
            return (JSSourceElement[])((JSStubElementImpl)owner).getStubOrPsiChildren(JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS, JSSourceElement.ARRAY_FACTORY);
        }
        if (owner instanceof JSFile) {
            return ((JSFile)owner).getStatements();
        }
        return JSSourceElement.EMPTY_ARRAY;
    }

    public static PsiElement[] getStubbedChildren(@Nullable PsiElement owner) {
        return JSResolveUtil.getStubbedChildren(owner, JSExtendedLanguagesTokenSetProvider.OUR_STUBBED_FILTER);
    }

    public static PsiElement[] getStubbedChildren(@Nullable PsiElement owner, @NotNull TokenSet filter) {
        if (filter == null) {
            JSResolveUtil.$$$reportNull$$$0(84);
        }
        if (owner instanceof JSStubElementImpl) {
            JSStubElementImpl element = (JSStubElementImpl)owner;
            StubElement stub = element.getStub();
            if (stub != null) {
                return stub.getChildrenByType(filter, PsiElement.EMPTY_ARRAY);
            }
            return JSResolveUtil.getChildrenFromTokenSet(element.getNode(), filter);
        }
        if (owner instanceof JSFile) {
            JSFile file2 = (JSFile)owner;
            StubElement stub = ((PsiFileImpl)file2).getStub();
            if (stub != null) {
                return stub.getChildrenByType(filter, PsiElement.EMPTY_ARRAY);
            }
            return JSResolveUtil.getChildrenFromTokenSet((ASTNode)file2.getNode(), filter);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static PsiElement[] getChildrenFromTokenSet(ASTNode astNode, TokenSet filter) {
        ASTNode[] astNodes = astNode.getChildren(filter);
        PsiElement[] result2 = new PsiElement[astNodes.length];
        for (int i = 0; i < astNodes.length; ++i) {
            result2[i] = astNodes[i].getPsi();
        }
        return result2;
    }

    @Nullable
    public static JSFunction getClassConstructor(@NotNull JSClass jsClass) {
        if (jsClass == null) {
            JSResolveUtil.$$$reportNull$$$0(85);
        }
        if (jsClass.isInterface()) {
            return null;
        }
        for (Object classMember : jsClass.getMembers()) {
            if (!(classMember instanceof JSFunction) || !JSResolveUtil.isConstructorFunction((PsiElement)((JSFunction)classMember))) continue;
            return (JSFunction)classMember;
        }
        return null;
    }

    @Contract(value="null -> false")
    public static boolean isConstructorFunction(@Nullable PsiElement element) {
        return element instanceof JSFunction && ((JSFunction)element).isConstructor();
    }

    @NotNull
    public static List<? extends PsiElement> getExportedElements(@NotNull JSExecutionScope module) {
        TypeScriptExportAssignment assignment;
        List<JSPsiElementBase> candidates;
        if (module == null) {
            JSResolveUtil.$$$reportNull$$$0(86);
        }
        if (!(candidates = CommonJSUtil.getModuleExports(module)).isEmpty()) {
            List<JSPsiElementBase> list2 = candidates;
            if (list2 == null) {
                JSResolveUtil.$$$reportNull$$$0(87);
            }
            return list2;
        }
        if (DialectDetector.isTypeScript((PsiElement)module) && (assignment = TypeScriptPsiUtil.findExportAssignment((PsiElement)module)) != null) {
            List<TypeScriptExportAssignment> list3 = Collections.singletonList(assignment);
            if (list3 == null) {
                JSResolveUtil.$$$reportNull$$$0(88);
            }
            return list3;
        }
        List<JSPsiElementBase> list4 = candidates;
        if (list4 == null) {
            JSResolveUtil.$$$reportNull$$$0(89);
        }
        return list4;
    }

    public static boolean isEventListenerCall(JSCallExpression e) {
        String methodName;
        JSExpression methodExpression = e.getMethodExpression();
        return methodExpression instanceof JSReferenceExpression && ("addEventListener".equals(methodName = ((JSReferenceExpression)methodExpression).getReferenceName()) || "removeEventListener".equals(methodName));
    }

    @Nullable
    public static PsiElement getScopeToIncludeLocalMembers(@NotNull JSNamespace namespace) {
        if (namespace == null) {
            JSResolveUtil.$$$reportNull$$$0(90);
        }
        return namespace.getSource().getScope();
    }

    public static List<PsiElement> getValidResults(ResolveResult @NotNull [] results) {
        if (results == null) {
            JSResolveUtil.$$$reportNull$$$0(91);
        }
        return ContainerUtil.map((Collection)ContainerUtil.filter((Object[])results, ResolveResult::isValidResult), ResolveResult::getElement);
    }

    private static /* synthetic */ boolean lambda$iterateOverrides$12(Set visited, String name, JSClassResolver resolver, GlobalSearchScope resolveScope, JSOverrideHandler handler, PsiElement context, JSType type) {
        String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (qName == null || !visited.add(qName)) {
            return true;
        }
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        String className2 = qName + "." + name;
        resolver.processElementsByQNameIncludingImplicit(className2, resolveScope, (Processor<? super JSPsiElementBase>)collectProcessor);
        ArrayList<JSPsiElementBase> results = new ArrayList<JSPsiElementBase>(collectProcessor.getResults().size());
        for (JSPsiElementBase result2 : collectProcessor.getResults()) {
            if (result2.getAccessType() == JSAttributeList.AccessType.PRIVATE || result2.getJSContext() == JSContext.STATIC) continue;
            results.add(result2);
        }
        return results.isEmpty() || handler.process(results, context, qName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 52: 
            case 53: 
            case 54: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 83: 
            case 87: 
            case 88: 
            case 89: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 52: 
            case 53: 
            case 54: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 83: 
            case 87: 
            case 88: 
            case 89: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 52: 
            case 53: 
            case 54: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 83: 
            case 87: 
            case 88: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedJsFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResults";
                break;
            }
            case 10: 
            case 25: 
            case 43: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decl";
                break;
            }
            case 12: 
            case 13: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 15: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 20: 
            case 27: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 23: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forcedPackageName";
                break;
            }
            case 28: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 29: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 32: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolve";
                break;
            }
            case 37: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 39: 
            case 41: 
            case 49: 
            case 57: 
            case 79: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 40: 
            case 42: 
            case 46: 
            case 50: 
            case 55: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainOccurrence";
                break;
            }
            case 51: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 66: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_scope";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortTypeName";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeftmostQualifier";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "processSiblingsForElement";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaScriptSymbolsResolveScope";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeExcludingJsLibs";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "buildNamespaceForQualifier";
                break;
            }
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "findNamedElementsInScope";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getExportedElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processInjectedFileForTag";
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 52: 
            case 53: 
            case 54: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 83: 
            case 87: 
            case 88: 
            case 89: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getXmlBackedClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isResolveStrict";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "areResolveResultsStrict";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptDeclarationMerging";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasUseStrictPragmaUp";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasUseStrictPragma";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "changesThisValue";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "shortReferenceIsAmbiguousOrUnequal";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isFromPredefinedFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getContext";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isObjectClass";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processHierarchy";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "stableResolveOrder";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findFileLocalElement";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleFromActionScriptPackage";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isSelfReference";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTopReferenceExpression";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLeftmostQualifier";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isSameReference";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isDummyResolve";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findParent";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "findParentClass";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getParameterFromSetAccessor";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessTopLevelGlobalContext";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessImports";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "walkOverStructure";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processParametersForUsedArgument";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findParameterForUsedArgument";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getPackageNameFromPlace";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "processSiblingsForElement";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processFileElement";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "indexOfElement";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "tryProcessXmlFileImplicitElements";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "tryProcessAllElementsInInjectedContext";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "isExprInStrictTypeContext";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getJavaScriptSymbolsResolveScope";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "getScopeExcludingJsLibs";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverrides";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceToStartHierarchySearch";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isActionScriptClassMemberExceptOverride";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isOutOfScope";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isIllegalPlaceForPrivate";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "findNamedElementsInScope";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getStubbedChildren";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getClassConstructor";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getExportedElements";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getScopeToIncludeLocalMembers";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getValidResults";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 17: 
            case 18: 
            case 19: 
            case 30: 
            case 31: 
            case 52: 
            case 53: 
            case 54: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 76: 
            case 77: 
            case 83: 
            case 87: 
            case 88: 
            case 89: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class MyNamespaceProcessor
    implements Processor<JSType> {
        private final Set<JSPsiElementBase> myFunctions;
        private final LinkedList<String> myDescendants = new LinkedList();
        private final Set<String> myProcessed = new THashSet();
        protected JSPsiElementBase function;
        private final boolean myFindAll;

        public MyNamespaceProcessor(Set<JSPsiElementBase> functions, boolean findAll) {
            this.myFunctions = functions;
            this.myFindAll = findAll;
        }

        public boolean process(@NotNull JSType type) {
            if (type == null) {
                MyNamespaceProcessor.$$$reportNull$$$0(0);
            }
            if (type instanceof JSNamedType && ((JSNamedType)type).getTypeContext() == JSTypeContext.STATIC) {
                return true;
            }
            String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
            if (qName == null) {
                return true;
            }
            if (!this.myFindAll && this.myProcessed.contains(qName)) {
                return true;
            }
            if (this.myProcessed.add(qName)) {
                this.myDescendants.add(qName);
            }
            Collection<JSPsiElementBase> elements = null;
            PsiFile file2 = type.getSource().getScope();
            if (file2 == null) {
                Logger.getInstance(MyNamespaceProcessor.class).error("Null scope");
                return true;
            }
            GlobalSearchScope scope = GlobalSearchScope.fileScope((PsiFile)file2);
            boolean result2 = false;
            Iterator<JSPsiElementBase> functionIterator = this.myFunctions.iterator();
            while (functionIterator.hasNext()) {
                Collection<JSPsiElementBase> elementsToProcess;
                this.function = functionIterator.next();
                if (JSSymbolUtil.isConstructorSymbol(this.function)) {
                    if (elements == null) {
                        elements = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(qName, scope);
                    }
                    elementsToProcess = elements;
                } else {
                    String descendantName = this.function.getName();
                    elementsToProcess = new ArrayList<JSPsiElementBase>();
                    if (descendantName != null) {
                        String memberName = qName + "." + descendantName;
                        Collection<JSPsiElementBase> members = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(memberName, scope);
                        elementsToProcess.addAll(members);
                    }
                }
                boolean skipImplicitElements = false;
                for (JSPsiElementBase elementToProcess : elementsToProcess) {
                    if (elementToProcess instanceof JSImplicitElement) continue;
                    skipImplicitElements = true;
                    break;
                }
                boolean b = true;
                for (JSPsiElementBase elementToProcess : elementsToProcess) {
                    if (skipImplicitElements && elementToProcess instanceof JSImplicitElement) continue;
                    b &= this.doProcess((PsiElement)elementToProcess);
                }
                if (!b) {
                    functionIterator.remove();
                }
                result2 |= b;
            }
            return result2;
        }

        protected abstract boolean doProcess(PsiElement var1);

        public void processDescendantsOf(String qName, PsiElement context) {
            ProgressManager.checkCanceled();
            boolean b = JSTypeEvaluateManager.iterateSubclasses(context, qName, this);
            while (b && !this.myDescendants.isEmpty()) {
                ProgressManager.checkCanceled();
                b = JSTypeEvaluateManager.iterateSubclasses(context, this.myDescendants.removeFirst(), this);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$MyNamespaceProcessor", "process"));
        }
    }

    public static class VisitAllTypesProcessor
    extends ResolveProcessor {
        private final Processor<? super JSClass> myProcessor;
        private final boolean myVisitInterfaces;

        public VisitAllTypesProcessor(Processor<? super JSClass> processor, boolean visitInterfaces) {
            super((String)null);
            this.myProcessor = processor;
            this.setLocalResolve(true);
            this.setTypeContext(true);
            this.setToProcessHierarchy(true);
            this.setToProcessMembers(false);
            this.myVisitInterfaces = visitInterfaces;
        }

        public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
            if (element == null) {
                VisitAllTypesProcessor.$$$reportNull$$$0(0);
            }
            if (state == null) {
                VisitAllTypesProcessor.$$$reportNull$$$0(1);
            }
            if (element instanceof JSClass) {
                JSClass clazz = (JSClass)element;
                if (!this.myProcessor.process((Object)clazz)) {
                    return false;
                }
                if (this.myVisitInterfaces) {
                    for (JSClass im : clazz.getImplementedInterfaces()) {
                        if (im.processDeclarations((PsiScopeProcessor)this, state, (PsiElement)im, (PsiElement)im)) continue;
                        return false;
                    }
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "state";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$VisitAllTypesProcessor";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface AllowFileLocalSymbols {
    }

    static enum TreeWalkUpResult {
        RETURN,
        RETURN_AFTER_POST_PROCESSING,
        CONTINUE;

    }

    public static abstract class JSInjectedFilesVisitor
    implements PsiLanguageInjectionHost.InjectedPsiVisitor,
    XmlBackedJSClass.InjectedFileVisitor {
        public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
            if (injectedPsi == null) {
                JSInjectedFilesVisitor.$$$reportNull$$$0(0);
            }
            if (places == null) {
                JSInjectedFilesVisitor.$$$reportNull$$$0(1);
            }
            if (injectedPsi instanceof JSFile) {
                this.process((JSFile)injectedPsi);
            }
        }

        protected abstract void process(JSFile var1);

        public void visit(XmlTag rootTag, JSFile file2) {
            this.process(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "injectedPsi";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "places";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$JSInjectedFilesVisitor";
            objectArray[2] = "visit";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Holder {
        private static final Class[] PACKAGE_ELEMENTS = new Class[]{TypeScriptModule.class, JSVariable.class, JSNamespaceDeclaration.class, JSPackageStatement.class, JSPackage.class, JSFunction.class, JSClass.class};

        private Holder() {
        }
    }

    public static abstract class StructureResolveProcessor
    extends ResolveProcessor
    implements Processor<PsiNamedElement> {
        private static final ResolveProcessor.ProcessingOptions ourProcessingOptions = new StructureProcessingOptions();

        public StructureResolveProcessor(String name) {
            super(name);
            this.setLocalResolve(true);
            this.setSkipImplicitDeclarations(true);
            this.setProcessingOptions(ourProcessingOptions);
        }

        public boolean process(PsiNamedElement psiNamedElement) {
            PsiFile containingFile;
            PsiElement context;
            boolean b = true;
            if (psiNamedElement instanceof JSElement && (b = psiNamedElement.processDeclarations((PsiScopeProcessor)this, ResolveState.initial(), (PsiElement)psiNamedElement, (PsiElement)psiNamedElement)) && psiNamedElement instanceof JSFile && (context = psiNamedElement.getContext()) != null && (containingFile = context.getContainingFile()) instanceof XmlFile) {
                b = JSResolveUtil.processAllGlobalsInXmlFile(this, (XmlFile)containingFile, context);
            }
            return b;
        }

        public static class StructureProcessingOptions
        extends ResolveProcessor.ProcessingOptions {
            @Override
            public boolean toProcessFunctionArguments() {
                return false;
            }

            @Override
            public boolean toProcessFunctionBodyDeclarations(@Nullable PsiElement lastParent, @NotNull JSFunction fun) {
                if (fun == null) {
                    StructureProcessingOptions.$$$reportNull$$$0(0);
                }
                return lastParent != null;
            }

            @Override
            public boolean toProcessPackageContent(PsiElement lastParent, JSPackageStatementImpl packageStatement) {
                return lastParent != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fun", "com/intellij/lang/javascript/psi/resolve/JSResolveUtil$StructureResolveProcessor$StructureProcessingOptions", "toProcessFunctionBodyDeclarations"));
            }
        }
    }

    public static enum GlobalSymbolsAcceptanceState {
        ACCEPT_ONLY_CLASSES,
        ACCEPT_NO_CLASSES,
        ACCEPT_NAMESPACE_DECLARATIONS,
        WHATEVER;

    }

    public static class GenericSignature {
        public final String genericType;
        public final String elementType;

        public GenericSignature(String _type, String _genericType) {
            this.elementType = _type;
            this.genericType = _genericType;
        }

        public static String build(String typeName, @Nullable GenericSignature genericSignature) {
            if (genericSignature == null) {
                return typeName;
            }
            return typeName + ".<" + genericSignature.genericType + ">";
        }
    }

    static enum AssignableTypeStatus {
        OK,
        LANG_IMPLICIT_COERCION,
        COMPILE_TIME_FAIL;

    }
}

