/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.flex.PsiScopedImportSet;
import com.intellij.lang.javascript.flex.ScopedImportSet;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeNameValuePair;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagValue;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSImportedElementResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSImportHandlingUtil {
    public static final PsiScopedImportSet ourPsiScopedImportSet = new PsiScopedImportSet();

    @Nullable
    public static String resolveTypeName(@Nullable String _str, @NotNull PsiElement context) {
        if (context == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(0);
        }
        if (_str == null) {
            return null;
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement(context).getImportHandler();
        return importHandler.getQualifiedNameResolvedType(_str, context);
    }

    @Nullable
    public static JSImportedElementResolveResult resolveTypeNameUsingImports(@NotNull JSReferenceExpression expr) {
        if (expr == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(1);
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)expr).getImportHandler();
        return importHandler.resolveTypeNameUsingImports(expr);
    }

    public static boolean tryResolveImports(PsiScopeProcessor processor, PsiNamedElement parent, @NotNull PsiElement place) {
        if (place == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(2);
        }
        if (!JSImportHandlingUtil.isAdequatePlaceForImport(parent, place, processor)) {
            return true;
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement((PsiElement)parent).getImportHandler();
        return importHandler.importClass(processor, parent);
    }

    public static boolean isAdequatePlaceForImport(PsiNamedElement parent, @NotNull PsiElement place, PsiScopeProcessor processor) {
        PsiFile containingFile;
        if (place == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(3);
        }
        if ((containingFile = parent.getContainingFile()) instanceof JSFile && !containingFile.getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            return false;
        }
        if (processor instanceof ResolveProcessor && ((ResolveProcessor)processor).isForceImportsForPlace()) {
            return true;
        }
        if (place instanceof JSReferenceExpression) {
            PsiElement currentParent;
            PsiElement placeParent = place.getParent();
            if (placeParent instanceof JSReferenceExpression && (JSResolveUtil.isSelfReference(currentParent = JSResolveUtil.getTopReferenceParent(placeParent), place) || currentParent instanceof JSReferenceListMember || currentParent instanceof JSReferenceList)) {
                return false;
            }
        } else if (!(place instanceof JSDocTagValue || place instanceof JSAttributeNameValuePair || place instanceof XmlAttributeValue || place instanceof XmlTag || place instanceof JSFile)) {
            return JSImportHandlingUtil.isAdequatePlaceForImportViaHelper(place);
        }
        return true;
    }

    private static boolean isAdequatePlaceForImportViaHelper(PsiElement place) {
        for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
            if (!helper.isAdequatePlaceForImport(place)) continue;
            return true;
        }
        return false;
    }

    public static ImportStatus evaluateImportStatus(String newName, PsiElement context) {
        EvaluateImportStatusProcessor statusProcessor = new EvaluateImportStatusProcessor(newName);
        JSResolveUtil.walkOverStructure(context, statusProcessor);
        return (ImportStatus)((Object)statusProcessor.myStatus.get());
    }

    @Nullable
    private static JSResolvableType asResolvableType(@NotNull JSType type, @NotNull PsiElement resolveContext) {
        if (type == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(4);
        }
        if (resolveContext == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(5);
        }
        if (type.getSourceElement() != resolveContext) {
            return null;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = ((JSGenericTypeImpl)type).getType();
        }
        if (type instanceof JSResolvableType) {
            return (JSResolvableType)type;
        }
        return null;
    }

    @NotNull
    public static Collection<? extends PsiElement> resolveElementsByType(@NotNull JSType type, @NotNull PsiElement resolveContext) {
        JSQualifiedName name;
        JSResolvableType resolvableType;
        if (type == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(6);
        }
        if (resolveContext == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(7);
        }
        if ((resolvableType = JSImportHandlingUtil.asResolvableType(type, resolveContext)) != null) {
            Collection<? extends PsiElement> collection = resolvableType.resolveType().getDeclarations();
            if (collection == null) {
                JSImportHandlingUtil.$$$reportNull$$$0(8);
            }
            return collection;
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(type, false);
        if (qName == null) {
            if (type instanceof JSRecordType && resolveContext instanceof JSClassExpression) {
                List list2 = ContainerUtil.createMaybeSingletonList((Object)resolveContext);
                if (list2 == null) {
                    JSImportHandlingUtil.$$$reportNull$$$0(9);
                }
                return list2;
            }
            List list3 = Collections.emptyList();
            if (list3 == null) {
                JSImportHandlingUtil.$$$reportNull$$$0(10);
            }
            return list3;
        }
        if (type instanceof JSNamespace && ((JSNamespace)type).isLocal() && (name = ((JSNamespace)type).getQualifiedName()) != null && name.getParent() == null) {
            List<PsiElement> list4 = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(name.getName(), resolveContext, true);
            if (list4 == null) {
                JSImportHandlingUtil.$$$reportNull$$$0(11);
            }
            return list4;
        }
        JSTypeResolveResult result2 = JSDialectSpecificHandlersFactory.forElement(resolveContext).getImportHandler().resolveTypeName(qName, resolveContext);
        Collection<? extends PsiElement> collection = result2.getElements();
        if (collection == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Nullable
    public static JSReferenceExpression findUnresolvedReferenceExpression(@NotNull Editor editor, @NotNull PsiFile file2, int offset) {
        if (editor == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            JSImportHandlingUtil.$$$reportNull$$$0(14);
        }
        Document document2 = editor.getDocument();
        int lineNumber = document2.getLineNumber(offset);
        int startOffset = document2.getLineStartOffset(lineNumber);
        int endOffset = document2.getLineEndOffset(lineNumber);
        List elements = CollectHighlightsUtil.getElementsInRange((PsiElement)file2, (int)startOffset, (int)endOffset);
        for (PsiElement element : elements) {
            if (!(element instanceof JSReferenceExpression) || ((JSReferenceExpression)element).getQualifier() != null || ((JSReferenceExpression)element).multiResolve(false).length != 0) continue;
            return (JSReferenceExpression)element;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElementsByType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeNameUsingImports";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryResolveImports";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAdequatePlaceForImport";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "asResolvableType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveElementsByType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findUnresolvedReferenceExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class EvaluateImportStatusProcessor
    implements Processor<PsiNamedElement>,
    ScopedImportSet.ImportProcessor<Object> {
        private final String myNewName;
        private final Ref<ImportStatus> myStatus = new Ref((Object)ImportStatus.ABSENT);

        EvaluateImportStatusProcessor(String newName) {
            this.myNewName = newName;
        }

        public boolean process(PsiNamedElement context) {
            ourPsiScopedImportSet.process(this.myNewName, null, context, this);
            if (context instanceof JSPackageStatement) {
                return false;
            }
            return this.myStatus.get() == ImportStatus.ABSENT;
        }

        @Override
        public Object process(@NotNull String referenceName, @NotNull ScopedImportSet.ImportProcessor.ImportInfo info, @NotNull PsiNamedElement scope) {
            PsiElement clazz;
            if (referenceName == null) {
                EvaluateImportStatusProcessor.$$$reportNull$$$0(0);
            }
            if (info == null) {
                EvaluateImportStatusProcessor.$$$reportNull$$$0(1);
            }
            if (scope == null) {
                EvaluateImportStatusProcessor.$$$reportNull$$$0(2);
            }
            if (info.starImport && (clazz = JSDialectSpecificHandlersFactory.forElement((PsiElement)scope).getClassResolver().findClassByQName(info.getQNameToSearch(referenceName), (PsiElement)scope)) == null) {
                return null;
            }
            ImportStatus status = (ImportStatus)((Object)this.myStatus.get());
            if (status == ImportStatus.ABSENT) {
                this.myStatus.set((Object)ImportStatus.UNIQUE);
            } else if (status == ImportStatus.UNIQUE) {
                this.myStatus.set((Object)ImportStatus.MULTIPLE);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "referenceName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "scope";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSImportHandlingUtil$EvaluateImportStatusProcessor";
            objectArray[2] = "process";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ImportStatus {
        ABSENT,
        UNIQUE,
        MULTIPLE;

    }
}

