/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.ecmascript6.TypeScriptSignatureChooser;
import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSGenericsIndex;
import com.intellij.lang.javascript.psi.types.JSAliasTypeImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSRestType;
import com.intellij.lang.javascript.psi.types.JSRestTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSpreadType;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.JSTypeWithGenericParameters;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.TypeScriptConditionalTypeJSTypeImpl;
import com.intellij.lang.javascript.psi.types.TypeScriptJSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericDeclarationTypeImpl;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.TreeItem;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSGenericTypesEvaluatorBase
implements JSGenericTypesEvaluator {
    private static final int ANONYMOUS_STATUS_DELTA = 3;

    @NotNull
    public static JSTypeSubstitutor getTypeSubstitutorForExplicitThisParameterType(@NotNull Getter<? extends JSType> qualifierType, @Nullable JSFunctionType functionType, @Nullable PsiElement context) {
        if (qualifierType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(0);
        }
        if (!(functionType instanceof TypeScriptJSFunctionTypeImpl)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(1);
            }
            return jSTypeSubstitutor;
        }
        JSType definedType = functionType.getThisType();
        if (JSTypeUtils.hasForeignGenericParameter(definedType)) {
            return JSGenericTypesEvaluatorBase.findAndIntersectGenericsTypeValues((JSType)qualifierType.get(), definedType, context);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(2);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected Function.Mono<JSType> getJSQualifierGenericsRemapper(@Nullable JSExpression methodExpression) {
        JSExpression qualifier;
        if (methodExpression instanceof JSReferenceExpression && (qualifier = ((JSReferenceExpression)methodExpression).getQualifier()) != null) {
            Function.Mono mono = type -> JSGenericTypesEvaluatorBase.evaluateJSGenericsFromQualifier(type, qualifier);
            if (mono == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(3);
            }
            return mono;
        }
        Function.Mono mono = Functions.id();
        if (mono == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(4);
        }
        return mono;
    }

    @NotNull
    protected static JSTypeSubstitutor getDefaultTypeSubstitutor(@Nullable JSFunctionType functionType, @NotNull JSCallItem callItem) {
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(5);
        }
        if (JSTypeUtils.hasTypeArguments(callItem)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(6);
            }
            return jSTypeSubstitutor;
        }
        return JSGenericTypesEvaluatorBase.getSubstitutorForDefaultParameters(functionType);
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForDefaultParameters(@NotNull PsiElement typeParametersOwner) {
        if (typeParametersOwner == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(7);
        }
        if (!(typeParametersOwner instanceof TypeScriptTypeParameterListOwner)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(8);
            }
            return jSTypeSubstitutor;
        }
        TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(typeParametersOwner);
        if (parameters.length == 0) {
            JSClass jsClass;
            if (typeParametersOwner instanceof JSFunction && ((JSFunction)typeParametersOwner).isConstructor() && (jsClass = JSUtils.getMemberContainingClass(typeParametersOwner)) != null && !jsClass.isInterface()) {
                return JSGenericTypesEvaluatorBase.getSubstitutorForDefaultParameters((PsiElement)jsClass);
            }
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(9);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        for (TypeScriptTypeParameter parameter : parameters) {
            String name = parameter.getName();
            if (name == null) continue;
            JSTypeSubstitutor.JSTypeGenericId id = parameter.getGenericId();
            JSType type = JSGenericTypesEvaluatorBase.getTypeParameterDefaultType(parameter);
            substitutor.put(id, type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(10);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    public static JSTypeSubstitutor getSubstitutorForDefaultParameters(@Nullable JSFunctionType typeParametersOwner) {
        if (!(typeParametersOwner instanceof TypeScriptJSFunctionTypeImpl)) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(11);
            }
            return jSTypeSubstitutor;
        }
        List<TypeScriptGenericDeclarationTypeImpl> declarations = ((TypeScriptJSFunctionTypeImpl)typeParametersOwner).getGenericDeclarations();
        JSTypeSubstitutor substitutor = new JSTypeSubstitutor();
        for (TypeScriptGenericDeclarationTypeImpl parameter : declarations) {
            JSTypeSubstitutor.JSTypeGenericId id = parameter.getGenericId();
            JSType type = JSGenericTypesEvaluatorBase.getTypeParameterDefaultType(parameter);
            substitutor.put(id, type);
        }
        JSTypeSubstitutor jSTypeSubstitutor = substitutor;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(12);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    protected static Set<JSTypeSubstitutor.JSTypeGenericId> getGenericIds(@Nullable PsiElement resolvedFunction) {
        if (resolvedFunction instanceof TypeScriptTypeParameterListOwner) {
            TypeScriptTypeParameter[] parameters = TypeScriptPsiUtil.getTypeParametersForOwner(resolvedFunction);
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Arrays.stream(parameters).map(p -> p.getGenericId()).collect(Collectors.toSet());
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(13);
            }
            return set;
        }
        Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
        if (set == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(14);
        }
        return set;
    }

    protected static void addGenericDependencyFromType(final @NotNull Set<JSTypeSubstitutor.JSTypeGenericId> generics, final @NotNull MultiMap<Integer, JSTypeSubstitutor.JSTypeGenericId> results, final int ownName, @Nullable JSType type) {
        if (generics == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(15);
        }
        if (results == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(16);
        }
        if (type == null) {
            return;
        }
        type.accept(new JSRecursiveTypeVisitor(){

            public void visitJSType(@NotNull JSType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type instanceof JSGenericParameterImpl && generics.contains(((JSGenericParameterImpl)type).getGenericId())) {
                    results.putValue((Object)ownName, (Object)((JSGenericParameterImpl)type).getGenericId());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase$1", "visitJSType"));
            }
        });
    }

    protected static Integer @NotNull [] reorderByDependencies(int argumentsLength, @NotNull List<? extends JSType> parameterTypes, @NotNull Set<JSTypeSubstitutor.JSTypeGenericId> generics) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(17);
        }
        if (generics == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(18);
        }
        Integer[] result2 = new Integer[argumentsLength];
        MultiMap results = new MultiMap();
        for (int i = 0; i < argumentsLength; ++i) {
            result2[i] = i;
            if (i >= parameterTypes.size()) continue;
            JSGenericTypesEvaluatorBase.addGenericDependencyFromType(generics, (MultiMap<Integer, JSTypeSubstitutor.JSTypeGenericId>)results, i, parameterTypes.get(i));
        }
        Arrays.sort(result2, (r1, r2) -> {
            Collection all2;
            Collection all1 = results.get(r1);
            if (all1 == (all2 = results.get(r2))) {
                return 0;
            }
            return all1.stream().anyMatch(i -> all2.contains(i)) ? -1 : 1;
        });
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(19);
        }
        return result2;
    }

    @NotNull
    protected static JSType getTypeParameterDefaultType(@NotNull TypeScriptGenericDeclarationTypeImpl parameter) {
        JSType defaultType;
        if (parameter == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(20);
        }
        if ((defaultType = parameter.getDefaultType()) == null) {
            defaultType = parameter.getConstraintType();
        }
        JSUnknownType jSUnknownType = defaultType == null ? JSUnknownType.TS_INSTANCE : defaultType;
        if (jSUnknownType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(21);
        }
        return jSUnknownType;
    }

    @NotNull
    public static JSType getTypeParameterDefaultType(@NotNull TypeScriptTypeParameter parameter) {
        TypeScriptType defaultType;
        if (parameter == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(22);
        }
        if ((defaultType = parameter.getDefault()) == null) {
            defaultType = parameter.getTypeConstraint();
        }
        JSUnknownType jSUnknownType = defaultType == null ? JSUnknownType.TS_INSTANCE : defaultType.getJSType();
        if (jSUnknownType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(23);
        }
        return jSUnknownType;
    }

    @Contract(value="null->false")
    protected static boolean canHaveGenericParameters(@Nullable JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof JSUtilType) {
            return type instanceof JSArrayType || type instanceof JSFunctionType;
        }
        return true;
    }

    @NotNull
    protected JSTypeSubstitutor inferGenericTypesForCall(@Nullable JSFunctionType jsFunctionType, @NotNull JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext context, @NotNull Collection<JSTypeSubstitutor.JSTypeGenericId> explicitArguments) {
        boolean isContextualWithOverloads;
        Set names;
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(24);
        }
        if (context == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(25);
        }
        if (explicitArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(26);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        if (context.paramToSkip == -1) {
            result2.putAll(JSGenericTypesEvaluatorBase.getDefaultTypeSubstitutor(jsFunctionType, callItem));
        }
        if (jsFunctionType instanceof JSTypeWithGenericParameters && !callItem.isNewExpression() && jsFunctionType.isTypeScript() && explicitArguments.containsAll(names = ((JSTypeWithGenericParameters)jsFunctionType).getGenericIds())) {
            JSTypeSubstitutor jSTypeSubstitutor = result2;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(27);
            }
            return jSTypeSubstitutor;
        }
        boolean bl = isContextualWithOverloads = context.paramToSkip != -1;
        if (jsFunctionType != null) {
            List argumentTypes = callItem.getArgumentTypes(JSPsiBasedTypeOfType.getArgumentTypeFactory(isContextualWithOverloads));
            List<JSType> parameterTypes = JSGenericTypesEvaluatorBase.getParameterTypesForInference(jsFunctionType.getParameters(), argumentTypes.size());
            Condition<JSType> condition = JSGenericTypesEvaluatorBase.getExcludeExplicitArgumentsCondition(explicitArguments);
            this.doInferParameters(jsFunctionType, callItem, context, result2, argumentTypes, parameterTypes, condition);
        }
        for (JSTypeSubstitutor.JSTypeGenericId key : result2.keys()) {
            JSTypeSubstitutor substitutor = new JSTypeSubstitutor(result2);
            substitutor.put(key, null);
            result2.put(key, JSTypeUtils.applyGenericArguments(result2.get(key), substitutor));
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(28);
        }
        return jSTypeSubstitutor;
    }

    private void doInferParameters(@NotNull JSFunctionType jsFunctionType, @NotNull JSCallItem callItem, @NotNull JSGenericTypesEvaluator.GenericEvaluationContext evaluationContext, @NotNull JSTypeSubstitutor result2, @NotNull List<JSType> argumentTypes, @NotNull List<JSType> parameterTypes, @NotNull Condition<JSType> condition) {
        if (jsFunctionType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(29);
        }
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(30);
        }
        if (evaluationContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(31);
        }
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(32);
        }
        if (argumentTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(33);
        }
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(34);
        }
        if (condition == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(35);
        }
        JSGenericMappings genericArguments = this.inferGenericArgumentsFromCall(argumentTypes, parameterTypes, evaluationContext.paramToSkip, jsFunctionType, condition, evaluationContext.paramToSkip != -1, callItem, evaluationContext.expectedTypeKind.increaseInferenceDepth());
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> mapping = genericArguments.getMapping();
        result2.putAll(this.getTypeSubstitutorForReturnType(jsFunctionType, callItem, (Condition<? super JSType>)Conditions.and(condition, type -> {
            if (type instanceof JSGenericParameterImpl) {
                return !mapping.containsKey((Object)((JSGenericParameterImpl)type).getGenericId());
            }
            return true;
        }), evaluationContext.expectedTypeKind.increaseInferenceDepth()));
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(callItem.getPsiContext());
        if (evaluationContext.paramToSkip == -1) {
            JSGenericTypesEvaluatorBase.widenInferredTypes(mapping, parameterTypes, jsFunctionType, callItem, processingContext);
        }
        result2.putAll(JSGenericTypesEvaluatorBase.intersectGenericsForCall(genericArguments, callItem.getPsiContext(), evaluationContext.reporter, processingContext));
    }

    @NotNull
    public static Condition<JSType> getExcludeExplicitArgumentsCondition(@NotNull Collection<JSTypeSubstitutor.JSTypeGenericId> explicitArguments) {
        if (explicitArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(36);
        }
        Condition condition = type -> type instanceof JSGenericParameterImpl && !explicitArguments.contains(((JSGenericParameterImpl)type).getGenericId());
        if (condition == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(37);
        }
        return condition;
    }

    @NotNull
    protected JSTypeSubstitutor getTypeSubstitutorForReturnType(@NotNull JSFunctionType jsFunctionType, @NotNull JSCallItem callItem, @NotNull Condition<? super JSType> condition, JSExpectedTypeKind expectedTypeKind) {
        JSType returnType;
        if (jsFunctionType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(38);
        }
        if (callItem == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(39);
        }
        if (condition == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(40);
        }
        if ((returnType = jsFunctionType.getReturnType()) instanceof JSCodeBasedType) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(41);
            }
            return jSTypeSubstitutor;
        }
        if (callItem.getTypeArguments().length == 0 && JSTypeUtils.hasTypes(returnType, condition)) {
            PsiElement expression = callItem.getPsiContext();
            JSType expectedType = expression instanceof JSExpression ? JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)expression, expectedTypeKind.increaseInferenceDepth()) : null;
            return JSGenericTypesEvaluatorBase.findAndIntersectGenericsTypeValues(expectedType, returnType, callItem.getPsiContext());
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(42);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static List<JSType> getParameterTypesForInference(@NotNull List<? extends JSParameterItem> parameters, int argumentsLength) {
        if (parameters == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(43);
        }
        SmartList parameterTypes = new SmartList();
        JSType restParameterType = null;
        for (JSParameterItem jSParameterItem : parameters) {
            JSType parameterType = jSParameterItem.getSimpleType();
            parameterTypes.add(parameterType);
            if (!jSParameterItem.isRest()) continue;
            restParameterType = parameterType;
        }
        if (restParameterType != null && argumentsLength > parameterTypes.size()) {
            for (int i = parameterTypes.size(); i < argumentsLength; ++i) {
                parameterTypes.add(restParameterType);
            }
        }
        SmartList smartList = parameterTypes;
        if (smartList == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(44);
        }
        return smartList;
    }

    private static JSTypeSubstitutor intersectGenericsForCall(@NotNull JSGenericMappings applyingContext, @Nullable PsiElement context, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter, @NotNull ProcessingContext processingContext) {
        if (applyingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(45);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(46);
        }
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> mapping = applyingContext.getMapping();
        JSTypeSubstitutor result2 = JSGenericTypesEvaluatorBase.intersectGenerics(mapping, processingContext, reporter);
        for (Map.Entry entry : mapping.entrySet()) {
            Collection types2;
            JSTypeSubstitutor.JSTypeGenericId key = (JSTypeSubstitutor.JSTypeGenericId)entry.getKey();
            if (!result2.containsId(key) || (types2 = (Collection)entry.getValue()) == null || !types2.stream().allMatch(t -> t instanceof JSLiteralType)) continue;
            result2.put(key, JSCompositeTypeFactory.createUnionType(JSTypeSourceFactory.createTypeSource(context, true), new ArrayList(types2)));
        }
        JSTypeSubstitutor deepSubstitutor = JSGenericTypesEvaluatorBase.intersectGenerics(applyingContext.getDeepMapping(), processingContext, null);
        for (JSTypeSubstitutor.JSTypeGenericId key : result2.keys()) {
            result2.put(key, JSTypeUtils.applyGenericArguments(result2.get(key), deepSubstitutor));
        }
        return result2;
    }

    @NotNull
    protected static JSTypeSubstitutor intersectGenerics(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> map, @NotNull ProcessingContext processingContext, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (map == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(47);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(48);
        }
        JSTypeSubstitutor result2 = new JSTypeSubstitutor();
        for (Map.Entry entry : map.entrySet()) {
            Collection rawTypes = (Collection)entry.getValue();
            assert (rawTypes.size() > 0);
            JSTypeSubstitutor.JSTypeGenericId parameterName = (JSTypeSubstitutor.JSTypeGenericId)entry.getKey();
            JSGenericTypesEvaluatorBase.addTypesForParameter(rawTypes, parameterName, result2, processingContext, reporter);
        }
        JSTypeSubstitutor jSTypeSubstitutor = result2;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(49);
        }
        return jSTypeSubstitutor;
    }

    private static void addTypesForParameter(@NotNull Collection<JSType> rawTypes, @NotNull JSTypeSubstitutor.JSTypeGenericId parameterId, @NotNull JSTypeSubstitutor result2, @NotNull ProcessingContext processingContext, @Nullable JSGenericTypesEvaluator.GenericErrorReporter reporter) {
        if (rawTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(50);
        }
        if (parameterId == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(51);
        }
        if (result2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(52);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(53);
        }
        if (rawTypes.size() == 0) {
            return;
        }
        if (rawTypes.size() == 1) {
            result2.put(parameterId, (JSType)ContainerUtil.getFirstItem(rawTypes));
            return;
        }
        boolean hasImplicitly = JSGenericTypesEvaluatorBase.checkImplicitFlags(rawTypes);
        List<Object> typesWithoutGenerics = ContainerUtil.filter(rawTypes, el -> !(el instanceof JSGenericParameterImpl) && el != null && !JSTypeUtils.isNullOrUndefinedType(el));
        List<Object> typesToIntersect = typesWithoutGenerics.isEmpty() ? new ArrayList<JSType>(rawTypes) : typesWithoutGenerics;
        JSType type = JSGenericTypesEvaluatorBase.intersectTypes((List<? extends JSType>)typesToIntersect, processingContext);
        if (type != null) {
            result2.put(parameterId, type);
            return;
        }
        if (hasImplicitly) {
            return;
        }
        if (typesWithoutGenerics.size() <= 0) {
            return;
        }
        result2.put(parameterId, (JSType)typesWithoutGenerics.get(0));
        Set nonWideningLiterals = (Set)processingContext.get(JSGenericTypesEvaluator.nonWideningLiterals);
        if (nonWideningLiterals != null && nonWideningLiterals.contains(parameterId) && typesToIntersect.stream().allMatch(t -> t instanceof JSLiteralType)) {
            return;
        }
        if (reporter != null && typesWithoutGenerics.size() > 1) {
            reporter.error(JavaScriptBundle.message((String)"typescript.validation.cannot.find.best.common.type", (Object[])new Object[0]));
        }
    }

    private static boolean checkImplicitFlags(@NotNull Collection<? extends JSType> types2) {
        if (types2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(54);
        }
        boolean hasImplicitly = false;
        for (JSType jSType : types2) {
            JSType valuableType = JSTypeUtils.getValuableType(jSType);
            if (valuableType != null && valuableType.isSourceStrict()) continue;
            hasImplicitly = true;
            break;
        }
        return hasImplicitly;
    }

    @Nullable
    private static JSType intersectTypes(@NotNull List<? extends JSType> types2, @Nullable ProcessingContext context) {
        int size;
        if (types2 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(55);
        }
        if ((size = types2.size()) == 1) {
            return types2.get(0);
        }
        for (JSType jSType : types2) {
            if (!(jSType instanceof JSAnyType)) continue;
            return jSType;
        }
        ArrayList<Pair> passingTypes = new ArrayList<Pair>(size);
        int[][] nArray = new int[size][size];
        TIntHashSet skip2 = new TIntHashSet();
        for (int i = 0; i < size; ++i) {
            JSType type;
            if (skip2.contains(i) || (type = types2.get(i)) == null || !JSGenericTypesEvaluatorBase.isAcceptableBySourceStrictness(type)) continue;
            boolean result2 = true;
            for (int j = i + 1; j < size; ++j) {
                int status = JSGenericTypesEvaluatorBase.getAssignableStatus(context, type, types2.get(j));
                if (status == Integer.MIN_VALUE) {
                    skip2.add(j);
                    result2 = false;
                    break;
                }
                nArray[i][j] = status;
                nArray[j][i] = -status;
            }
            if (!result2) continue;
            passingTypes.add(Pair.create((Object)type, (Object)i));
        }
        if (passingTypes.isEmpty()) {
            return null;
        }
        if (passingTypes.size() > 1) {
            passingTypes.sort((o1, o2) -> {
                int status = assignableStatus[(Integer)o1.second][(Integer)o2.second];
                if (JSGenericTypesEvaluatorBase.isComingFromAnonymousFunction((Pair<JSType, Integer>)o1)) {
                    status += 3;
                }
                if (JSGenericTypesEvaluatorBase.isComingFromAnonymousFunction((Pair<JSType, Integer>)o2)) {
                    status -= 3;
                }
                return status;
            });
        }
        return (JSType)((Pair)passingTypes.get((int)0)).first;
    }

    private static boolean isComingFromAnonymousFunction(Pair<JSType, Integer> o1) {
        JSParameterList parameterList = (JSParameterList)PsiTreeUtil.getContextOfType((PsiElement)((JSType)o1.first).getSourceElement(), (Class[])new Class[]{JSParameterList.class});
        if (parameterList == null) {
            return false;
        }
        return ContainerUtil.and((Object[])parameterList.getParameters(), p -> p.getTypeElement() == null);
    }

    private static boolean isAcceptableBySourceStrictness(@NotNull JSType type) {
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(56);
        }
        return !type.getSource().isTypeScript() || JSTypeUtils.getValuableType(type).isSourceStrict();
    }

    private static int getAssignableStatus(@Nullable ProcessingContext context, @NotNull JSType type, @NotNull JSType jsType) {
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(57);
        }
        if (jsType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(58);
        }
        if (jsType == type) {
            return 0;
        }
        boolean isLtrAssignable = jsType.isDirectlyAssignableType(type, context);
        boolean isRtlAssignable = type.isDirectlyAssignableType(jsType, context);
        if (isLtrAssignable && isRtlAssignable) {
            return 0;
        }
        if (isLtrAssignable) {
            return 1;
        }
        if (isRtlAssignable) {
            return -1;
        }
        return Integer.MIN_VALUE;
    }

    @NotNull
    protected final JSGenericMappings inferGenericArgumentsFromCall(@NotNull List<? extends JSType> argumentTypes, @NotNull List<? extends JSType> parameterTypes, int callArgumentToSkip, @NotNull JSFunctionType jsFunctionType, @NotNull Condition<? super JSType> acceptableGenericArguments, boolean isContextualWithOverloads, @Nullable JSCallItem callItem, JSExpectedTypeKind expectedTypeKind) {
        if (argumentTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(59);
        }
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(60);
        }
        if (jsFunctionType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(61);
        }
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(62);
        }
        List argumentProviders = ContainerUtil.map(argumentTypes, type -> () -> {
            if (expectedTypeKind.increaseInferenceDepth().isInferenceDepthExceeded()) {
                return type;
            }
            JSType result2 = isContextualWithOverloads ? TypeScriptSignatureChooser.mapContextualTypeForOverload(type, jsFunctionType, callItem, expectedTypeKind) : type;
            return result2 instanceof JSPsiBasedTypeOfType ? JSTypeWithIncompleteSubstitution.substituteCompletely((JSType)result2) : result2;
        });
        return expectedTypeKind.isInferenceDepthExceeded() ? new JSGenericMappings() : JSGenericTypesEvaluatorBase.inferGenericArgumentsFromCall(parameterTypes, argumentProviders, callArgumentToSkip, jsFunctionType, callItem != null ? callItem.getPsiContext() : null, acceptableGenericArguments);
    }

    @NotNull
    public static MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> widenInferredTypes(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> inferred, @NotNull List<? extends JSType> actualParameters, @Nullable JSFunctionType resolvedFunction, @Nullable JSCallItem callItem, @NotNull ProcessingContext processingContext) {
        if (inferred == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(63);
        }
        if (actualParameters == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(64);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(65);
        }
        if (inferred.isEmpty()) {
            MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> multiMap = inferred;
            if (multiMap == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(66);
            }
            return multiMap;
        }
        JSType returnType = resolvedFunction != null ? resolvedFunction.getReturnType() : null;
        JSType returnTypeSubstitute = JSTypeUtils.unwrapType(TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(returnType));
        Set returnIds = ContainerUtil.map2Set(JSGenericTypesEvaluatorBase.getTopLevelGenerics(returnTypeSubstitute), JSGenericParameterImpl::getGenericId);
        Set parameterTypes = StreamEx.of(actualParameters).nonNull().map(el -> JSGenericTypesEvaluatorBase.extractGenericsForParameterType(el)).flatMap(Collection::stream).toSet();
        Set<JSTypeSubstitutor.JSTypeGenericId> excludedFromWideningByContextType = null;
        for (JSGenericParameterType parameterType : parameterTypes) {
            JSTypeSubstitutor.JSTypeGenericId id = parameterType.getGenericId();
            if (!inferred.containsKey((Object)id)) continue;
            Collection types2 = inferred.get((Object)id);
            JSType constraintType = parameterType.getConstraintType();
            if (constraintType instanceof JSEvaluableType) continue;
            if (JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(constraintType)) {
                HashSet<JSTypeSubstitutor.JSTypeGenericId> nonWideningLiterals = (HashSet<JSTypeSubstitutor.JSTypeGenericId>)processingContext.get(JSGenericTypesEvaluator.nonWideningLiterals);
                if (nonWideningLiterals == null) {
                    nonWideningLiterals = new HashSet<JSTypeSubstitutor.JSTypeGenericId>();
                    processingContext.put(JSGenericTypesEvaluator.nonWideningLiterals, nonWideningLiterals);
                }
                nonWideningLiterals.add(id);
                List newTypes = ContainerUtil.map((Collection)types2, type -> {
                    if (type instanceof JSTypeWithWidening && ((JSTypeWithWidening)type).allowWidening()) {
                        type = ((JSTypeWithWidening)type).copyWithAllowWidening(false);
                    }
                    return type;
                });
                inferred.put((Object)id, (Collection)newTypes);
                continue;
            }
            if (returnIds.contains(id)) continue;
            ArrayList<JSType> newTypes = new ArrayList<JSType>(types2.size());
            boolean hasWiden = false;
            for (JSType type2 : types2) {
                JSType widen;
                if (type2 != (widen = JSTypeUtils.widenLiteralTypes(type2))) {
                    if (excludedFromWideningByContextType == null) {
                        excludedFromWideningByContextType = JSGenericTypesEvaluatorBase.calcExcludedFromWideningByContextType(callItem, returnType);
                    }
                    if (!excludedFromWideningByContextType.contains(id)) {
                        hasWiden = true;
                        type2 = widen;
                    }
                }
                newTypes.add(type2);
            }
            if (!hasWiden) continue;
            inferred.put((Object)id, newTypes);
        }
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> multiMap = inferred;
        if (multiMap == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(67);
        }
        return multiMap;
    }

    @NotNull
    private static List<JSGenericParameterType> extractGenericsForParameterType(@NotNull JSType type) {
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(68);
        }
        if (type instanceof JSRestType) {
            type = ((JSRestType)type).getInnerType();
        }
        if (type instanceof JSGenericParameterType) {
            List<JSGenericParameterType> list2 = Collections.singletonList((JSGenericParameterType)type);
            if (list2 == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(69);
            }
            return list2;
        }
        if (type instanceof JSUnionOrIntersectionType) {
            List list3 = StreamEx.of(((JSUnionOrIntersectionType)type).getTypes()).select(JSGenericParameterType.class).toList();
            if (list3 == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(70);
            }
            return list3;
        }
        if (type instanceof JSTupleType) {
            List list4 = StreamEx.of((Collection)((JSTupleType)type).getTypes()).select(JSGenericParameterType.class).toList();
            if (list4 == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(71);
            }
            return list4;
        }
        List<JSGenericParameterType> list5 = Collections.emptyList();
        if (list5 == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(72);
        }
        return list5;
    }

    @NotNull
    private static Set<JSTypeSubstitutor.JSTypeGenericId> calcExcludedFromWideningByContextType(@Nullable JSCallItem callItem, @Nullable JSType returnType) {
        if (returnType == null) {
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(73);
            }
            return set;
        }
        JSCallExpression callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)callItem, JSCallExpression.class);
        if (callExpression == null) {
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(74);
            }
            return set;
        }
        JSType jSType = returnType = returnType instanceof JSArrayType ? ((JSArrayType)returnType).asGenericType() : returnType;
        if (!(returnType instanceof JSGenericTypeImpl)) {
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(75);
            }
            return set;
        }
        JSGenericTypeImpl genericReturnType = (JSGenericTypeImpl)returnType;
        JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)callExpression, JSExpectedTypeKind.WIDENING);
        if (expectedType instanceof JSAliasTypeImpl) {
            expectedType = ((JSAliasTypeImpl)expectedType).getAlias();
        }
        if (expectedType instanceof JSArrayType) {
            expectedType = ((JSArrayType)expectedType).asGenericType();
        }
        if (!(expectedType instanceof JSGenericTypeImpl)) {
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(76);
            }
            return set;
        }
        if (!((JSGenericTypeImpl)expectedType).getType().isEquivalentTo(genericReturnType.getType(), null)) {
            Set<JSTypeSubstitutor.JSTypeGenericId> set = Collections.emptySet();
            if (set == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(77);
            }
            return set;
        }
        List<JSType> arguments = genericReturnType.getArguments();
        List<JSType> expectedArgs = ((JSGenericTypeImpl)expectedType).getArguments();
        HashSet<JSTypeSubstitutor.JSTypeGenericId> result2 = new HashSet<JSTypeSubstitutor.JSTypeGenericId>();
        for (int i = 0; i < Math.min(arguments.size(), expectedArgs.size()); ++i) {
            JSType argument = arguments.get(i);
            JSType expectedArgument = expectedArgs.get(i);
            if (!(argument instanceof JSGenericParameterType) || !JSTypeUtils.containsLiteralOrEnumOrPrimitiveTypes(expectedArgument)) continue;
            result2.add(((JSGenericParameterType)argument).getGenericId());
        }
        HashSet<JSTypeSubstitutor.JSTypeGenericId> hashSet = result2;
        if (hashSet == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(78);
        }
        return hashSet;
    }

    private static void addImpliedArity(@Nullable JSFunctionType jsFunctionType, @NotNull List<? extends JSType> parameterTypes, @NotNull Condition<? super JSType> acceptableGenericArguments, @NotNull List<? extends Supplier<JSType>> arguments, @NotNull ProcessingContext context) {
        JSType type;
        JSType item;
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(79);
        }
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(80);
        }
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(81);
        }
        if (context == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(82);
        }
        if ((item = (JSType)ContainerUtil.getLastItem(parameterTypes)) instanceof JSRestType && (type = ((JSRestType)item).getInnerType()) instanceof JSGenericParameterType && acceptableGenericArguments.value((Object)type)) {
            int size = jsFunctionType != null ? jsFunctionType.getParameters().size() : parameterTypes.size();
            int argCount = Math.min(size - 1, arguments.size());
            JSGenericTypesEvaluator.setImpliedArity((JSGenericParameterType)type, arguments.size() - argCount, context);
        }
    }

    @NotNull
    public static JSGenericMappings inferGenericArgumentsFromCall(@NotNull List<? extends JSType> parameterTypes, @NotNull List<? extends Supplier<JSType>> arguments, int callArgumentToSkip, @Nullable JSFunctionType jsFunctionType, @Nullable PsiElement context, @NotNull Condition<? super JSType> acceptableGenericArguments) {
        if (parameterTypes == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(83);
        }
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(84);
        }
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(85);
        }
        Set generics = jsFunctionType instanceof JSTypeWithGenericParameters ? ((JSTypeWithGenericParameters)jsFunctionType).getGenericIds() : Collections.emptySet();
        Integer[] newIndices = JSGenericTypesEvaluatorBase.reorderByDependencies(arguments.size(), parameterTypes, generics);
        JSGenericMappings applyingContext = new JSGenericMappings();
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(context);
        JSGenericTypesEvaluatorBase.addImpliedArity(jsFunctionType, parameterTypes, acceptableGenericArguments, arguments, processingContext);
        for (int i = 0; i < arguments.size(); ++i) {
            int j = newIndices[i];
            if (j == callArgumentToSkip) continue;
            if (j >= parameterTypes.size()) break;
            JSType paramType = parameterTypes.get(j);
            if (paramType instanceof JSCodeBasedType) {
                paramType = paramType.substitute();
            }
            if (!JSTypeUtils.hasTypes(paramType, acceptableGenericArguments)) continue;
            JSType exprType = JSGenericTypesEvaluatorBase.getArgType(arguments, j);
            boolean matchedTuples = false;
            if (paramType instanceof JSRestTypeImpl) {
                JSType tempType = ((JSRestTypeImpl)paramType).getIterableType();
                if (tempType instanceof JSGenericParameterImpl) {
                    JSType constraintType = ((JSGenericParameterImpl)tempType).getConstraintType();
                    if (constraintType != null && JSTypeUtils.isIterableCollectionType(constraintType)) {
                        List<JSType> types2 = JSGenericTypesEvaluatorBase.getArgTypesForRestTuple(arguments, newIndices, true, i);
                        JSType tupleType = JSCompositeTypeFactory.createTupleType(paramType.getSource(), types2, true, -1, false);
                        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, tupleType, tempType, acceptableGenericArguments);
                        matchedTuples = true;
                    }
                } else if (tempType instanceof JSTupleType) {
                    List<JSType> types3 = JSGenericTypesEvaluatorBase.getArgTypesForRestTuple(arguments, newIndices, false, i);
                    int maxLength = ((JSTupleType)tempType).getMaxLength();
                    List<JSType> effectiveTypes = maxLength == Integer.MAX_VALUE ? types3 : types3.subList(0, Math.min(maxLength, types3.size()));
                    JSType tupleType = JSCompositeTypeFactory.createTupleType(paramType.getSource(), effectiveTypes, true, -1, false);
                    JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, tupleType, tempType, acceptableGenericArguments);
                    matchedTuples = true;
                }
            }
            if (!matchedTuples) {
                JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, exprType, paramType, acceptableGenericArguments);
            }
            if (matchedTuples) break;
        }
        JSGenericMappings jSGenericMappings = applyingContext;
        if (jSGenericMappings == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(86);
        }
        return jSGenericMappings;
    }

    @NotNull
    private static List<JSType> getArgTypesForRestTuple(@NotNull List<? extends Supplier<JSType>> arguments, Integer @NotNull [] newIndices, boolean widen, int i) {
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(87);
        }
        if (newIndices == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(88);
        }
        ArrayList<JSType> types2 = new ArrayList<JSType>();
        for (int k = i; k < arguments.size(); ++k) {
            JSType type = JSGenericTypesEvaluatorBase.getArgType(arguments, newIndices[k]);
            types2.add(widen ? JSTypeUtils.widenLiteralTypes(type) : type);
        }
        ArrayList<JSType> arrayList = types2;
        if (arrayList == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(89);
        }
        return arrayList;
    }

    @Nullable
    private static JSType getArgType(@NotNull List<? extends Supplier<JSType>> arguments, int index) {
        PsiElement sourceElement;
        JSType exprType;
        if (arguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(90);
        }
        if ((exprType = arguments.get(index).get()) != null && exprType.isTypeScript() && (sourceElement = exprType.getSource().getSourceElement()) != null) {
            return TypeScriptGenericTypesEvaluator.getExplicitTypeOrAny(sourceElement, exprType);
        }
        return exprType;
    }

    @NotNull
    public static JSTypeSubstitutor findAndIntersectGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context) {
        MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> generics = JSGenericTypesEvaluatorBase.findGenericsTypeValues(exprType, paramType, context);
        if (!generics.isEmpty()) {
            ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(context);
            return JSGenericTypesEvaluatorBase.intersectGenerics(generics, processingContext, null);
        }
        JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(91);
        }
        return jSTypeSubstitutor;
    }

    protected static MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> findGenericsTypeValues(@Nullable JSType exprType, @Nullable JSType paramType, @Nullable PsiElement context) {
        if (exprType == null || paramType == null) {
            return MultiMap.empty();
        }
        JSGenericMappings applyingContext = new JSGenericMappings();
        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, JSTypeComparingContextService.createProcessingContextWithCache(context), exprType, paramType);
        return applyingContext.getMapping();
    }

    @Deprecated
    public static void matchGenericTypes(@NotNull MultiMap<JSTypeSubstitutor.JSTypeGenericId, JSType> mapping, @NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType) {
        if (mapping == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(92);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(93);
        }
        if (paramType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(94);
        }
        JSGenericTypesEvaluatorBase.matchGenericTypes(new JSGenericMappings(mapping), processingContext, exprType, paramType, (Condition<? super JSType>)Conditions.alwaysTrue());
        JSGenericTypesEvaluatorBase.widenInferredTypes(mapping, Collections.singletonList(paramType), null, null, processingContext);
    }

    public static void matchGenericTypes(@NotNull JSGenericMappings applyingContext, @NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType) {
        if (applyingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(95);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(96);
        }
        if (paramType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(97);
        }
        JSGenericTypesEvaluatorBase.matchGenericTypes(applyingContext, processingContext, exprType, paramType, (Condition<? super JSType>)Conditions.alwaysTrue());
    }

    public static void matchGenericTypes(@NotNull JSGenericMappings applyingContext, @NotNull ProcessingContext processingContext, @Nullable JSType exprType, @NotNull JSType paramType, @NotNull Condition<? super JSType> acceptableGenericArguments) {
        PsiElement sourceElement;
        JSType toCheck;
        if (applyingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(98);
        }
        if (processingContext == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(99);
        }
        if (paramType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(100);
        }
        if (acceptableGenericArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(101);
        }
        if (paramType == (toCheck = paramType.transformTypeHierarchy(type -> {
            if (!(type instanceof JSGenericParameterImpl)) {
                return type;
            }
            JSGenericParameterImpl genericParameter = (JSGenericParameterImpl)type;
            if (!acceptableGenericArguments.value((Object)genericParameter)) {
                return genericParameter;
            }
            return genericParameter.copyWithSourceAndApplying(genericParameter.getSource(), JSGenericParameterType.JSGenericState.APPLYING);
        }))) {
            return;
        }
        if (JSGenericTypesEvaluatorBase.isUntypedArrowFunction(exprType)) {
            return;
        }
        if (exprType instanceof JSFunctionType && exprType instanceof JSTypeWithGenericParameters && !((JSTypeWithGenericParameters)exprType).getGenericIds().isEmpty() && (sourceElement = exprType.getSourceElement()) instanceof JSFunctionExpression && sourceElement.getContext() instanceof JSArgumentList) {
            return;
        }
        processingContext.put(ourGenericArgumentsMapKey, (Object)applyingContext);
        toCheck.isDirectlyAssignableType(exprType instanceof JSSpreadType ? ((JSSpreadType)exprType).getComponentType() : exprType, processingContext);
        processingContext.put(ourGenericArgumentsMapKey, null);
    }

    private static boolean isUntypedArrowFunction(JSType type) {
        return type instanceof JSFunctionType && ((JSFunctionType)type).getParameters().stream().allMatch(p -> JSGenericTypesEvaluatorBase.isAnyOrNull(p.getInferredType())) && JSGenericTypesEvaluatorBase.isAnyOrNull(((JSFunctionType)type).getReturnType());
    }

    private static boolean isAnyOrNull(JSType type1) {
        return type1 == null || !(type1 instanceof JSCodeBasedType) && JSTypeUtils.isAnyType(type1);
    }

    @NotNull
    private static List<JSGenericParameterImpl> getTopLevelGenerics(@Nullable JSType paramType) {
        SmartList topLevelGenerics = new SmartList();
        JSTypeUtils.processExpandedType((Processor<? super JSType>)((Processor)arg_0 -> JSGenericTypesEvaluatorBase.lambda$getTopLevelGenerics$17((List)topLevelGenerics, arg_0)), paramType);
        SmartList smartList = topLevelGenerics;
        if (smartList == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(102);
        }
        return smartList;
    }

    @NotNull
    private static JSType evaluateJSGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier) {
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(103);
        }
        if (qualifier == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(104);
        }
        return JSGenericTypesEvaluatorBase.evaluateJSGenericsFromQualifier(type, () -> JSResolveUtil.getElementJSType((PsiElement)qualifier));
    }

    @NotNull
    protected static JSType evaluateJSGenericsFromQualifier(@NotNull JSType type, @NotNull Supplier<? extends JSType> qualifierTypeSupplier) {
        JSType qualifierType;
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(105);
        }
        if (qualifierTypeSupplier == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(106);
        }
        if (type.getSource().isTypeScript()) {
            JSType jSType = type;
            if (jSType == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(107);
            }
            return jSType;
        }
        PsiElement sourceElement = type.getSource().getSourceElement();
        List<String> javaScriptGenericParameters = null;
        JSQualifiedName qualifiedName = null;
        PsiElement namespaceElement = sourceElement;
        if (namespaceElement instanceof JSDocComment) {
            namespaceElement = JSStubBasedPsiTreeUtil.findAssociatedElement((JSDocComment)namespaceElement);
        }
        if (namespaceElement instanceof JSParameter) {
            namespaceElement = ((JSParameter)namespaceElement).getDeclaringFunction();
        }
        if (namespaceElement instanceof JSPsiElementBase && namespaceElement.isValid()) {
            PsiFile file2 = namespaceElement.getContainingFile();
            for (qualifiedName = ((JSPsiElementBase)namespaceElement).getNamespace(); qualifiedName != null && (javaScriptGenericParameters = JSGenericsIndex.findGenericParameters(qualifiedName.getQualifiedName(), file2)) == null; qualifiedName = qualifiedName.getParent()) {
            }
            if (javaScriptGenericParameters != null) {
                type = JSGenericTypesEvaluatorBase.convertNamedTypesToGenericParameters(type, javaScriptGenericParameters);
            }
        }
        if (JSTypeUtils.hasForeignGenericParameter(type) && javaScriptGenericParameters != null && (qualifierType = qualifierTypeSupplier.get()) != null) {
            qualifierType = JSTypeUtils.unwrapDecorations(qualifierType);
            JSTypeSubstitutor typeArguments = JSGenericTypesEvaluatorBase.findTypeArgumentsForClassInHierarchy(qualifierType, qualifiedName, sourceElement);
            JSType jSType = JSTypeUtils.applyGenericArguments(type, typeArguments);
            if (jSType == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(108);
            }
            return jSType;
        }
        JSType jSType = type;
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(109);
        }
        return jSType;
    }

    @NotNull
    private static JSType convertNamedTypesToGenericParameters(@NotNull JSType type, @NotNull List<String> javaScriptGenericParameters) {
        if (type == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(110);
        }
        if (javaScriptGenericParameters == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(111);
        }
        List<String> genericParameters = javaScriptGenericParameters;
        JSType jSType = type = JSTypeUtils.applyCompositeMapping(type, (Function<JSType, JSType>)((Function)type1 -> {
            String text;
            if (type1 instanceof JSTypeImpl && genericParameters.contains(text = type1.getTypeText())) {
                return new JSGenericParameterImpl(text, type1.getSource(), null);
            }
            return type1;
        }));
        if (jSType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(112);
        }
        return jSType;
    }

    @NotNull
    public static JSTypeSubstitutor findTypeArgumentsForClassInHierarchy(@NotNull JSType genericType, @NotNull JSQualifiedName parentClassNamespace, @NotNull PsiElement scopeElement) {
        String qName;
        if (genericType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(113);
        }
        if (parentClassNamespace == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(114);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(115);
        }
        if ((qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true)) == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(116);
            }
            return jSTypeSubstitutor;
        }
        String parentClassName = parentClassNamespace.getQualifiedName();
        if (parentClassName.equals(qName)) {
            List<String> genericParameters = JSGenericsIndex.findGenericParameters(parentClassName, scopeElement.getContainingFile());
            if (genericParameters == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(117);
                }
                return jSTypeSubstitutor;
            }
            List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
            if (arguments == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(118);
                }
                return jSTypeSubstitutor;
            }
            JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.putForJSGenerics(genericParameters.get(i), arguments.get(i));
            }
            JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(119);
            }
            return jSTypeSubstitutor;
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        JSTypeSubstitutor typeArguments = JSGenericTypesEvaluatorBase.getTypeArgumentsMap(genericType, scope);
        return JSGenericTypesEvaluatorBase.applyTypeSubstitutorUpToParentClass(qName, parentClassName, scopeElement, typeArguments);
    }

    @NotNull
    public static JSTypeSubstitutor applyTypeSubstitutorUpToParentClass(@NotNull String qName, @NotNull String parentClassName, @NotNull PsiElement scopeElement, @NotNull JSTypeSubstitutor typeArguments) {
        if (qName == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(120);
        }
        if (parentClassName == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(121);
        }
        if (scopeElement == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(122);
        }
        if (typeArguments == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(123);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(scopeElement);
        TreeItem<String> root = JSTypeEvaluateManager.buildSuperClassesHierarchy(qName, scope);
        ArrayList<String> pathToSuperClass = new ArrayList<String>();
        for (TreeItem parentClass = JSTypeEvaluateManager.findSuperClass(root, parentClassName); parentClass != null && parentClass != root; parentClass = parentClass.getParent()) {
            pathToSuperClass.add(0, (String)parentClass.getData());
        }
        JSTypeSource typeSource = JSTypeSourceFactory.createTypeSource(scopeElement, true);
        for (String superClass : pathToSuperClass) {
            JSType type = JSTypeUtils.createType(superClass, typeSource);
            if (type == null) {
                JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
                if (jSTypeSubstitutor == null) {
                    JSGenericTypesEvaluatorBase.$$$reportNull$$$0(124);
                }
                return jSTypeSubstitutor;
            }
            type = JSTypeUtils.applyGenericArguments(type, typeArguments);
            typeArguments = JSGenericTypesEvaluatorBase.getTypeArgumentsMap(type, scope);
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(125);
        }
        return jSTypeSubstitutor;
    }

    @NotNull
    private static JSTypeSubstitutor getTypeArgumentsMap(@NotNull JSType genericType, @NotNull GlobalSearchScope scope) {
        if (genericType == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(126);
        }
        if (scope == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(127);
        }
        String qName = JSTypeUtils.getQualifiedNameMatchingType(genericType, true);
        List<JSType> arguments = JSTypeUtils.getGenericTypeArguments(genericType);
        if (qName == null || arguments == null) {
            JSTypeSubstitutor jSTypeSubstitutor = JSTypeSubstitutor.EMPTY;
            if (jSTypeSubstitutor == null) {
                JSGenericTypesEvaluatorBase.$$$reportNull$$$0(128);
            }
            return jSTypeSubstitutor;
        }
        JSTypeSubstitutor typeArguments = new JSTypeSubstitutor();
        List<String> genericParameters = JSGenericsIndex.findGenericParameters(qName, scope);
        if (genericParameters != null) {
            for (int i = 0; i < genericParameters.size() && i < arguments.size(); ++i) {
                typeArguments.putForJSGenerics(genericParameters.get(i), arguments.get(i));
            }
        }
        JSTypeSubstitutor jSTypeSubstitutor = typeArguments;
        if (jSTypeSubstitutor == null) {
            JSGenericTypesEvaluatorBase.$$$reportNull$$$0(129);
        }
        return jSTypeSubstitutor;
    }

    private static /* synthetic */ boolean lambda$getTopLevelGenerics$17(List topLevelGenerics, JSType type) {
        if (type instanceof JSUnionOrIntersectionType) {
            return true;
        }
        if (type instanceof JSGenericParameterImpl) {
            topLevelGenerics.add((JSGenericParameterImpl)type);
        }
        if (type instanceof TypeScriptConditionalTypeJSTypeImpl) {
            JSType typeIfTrue;
            JSType typeIfFalse = ((TypeScriptConditionalTypeJSTypeImpl)type).getTypeIfFalse();
            if (typeIfFalse instanceof JSGenericParameterImpl) {
                topLevelGenerics.add((JSGenericParameterImpl)typeIfFalse);
            }
            if ((typeIfTrue = ((TypeScriptConditionalTypeJSTypeImpl)type).getTypeIfTrue()) instanceof JSGenericParameterImpl) {
                topLevelGenerics.add((JSGenericParameterImpl)typeIfTrue);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 37: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 89: 
            case 91: 
            case 102: 
            case 107: 
            case 108: 
            case 109: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: 
            case 125: 
            case 128: 
            case 129: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 37: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 89: 
            case 91: 
            case 102: 
            case 107: 
            case 108: 
            case 109: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: 
            case 125: 
            case 128: 
            case 129: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 37: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 89: 
            case 91: 
            case 102: 
            case 107: 
            case 108: 
            case 109: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: 
            case 125: 
            case 128: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase";
                break;
            }
            case 5: 
            case 24: 
            case 30: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callItem";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParametersOwner";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generics";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 17: 
            case 34: 
            case 60: 
            case 79: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterTypes";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 25: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitArguments";
                break;
            }
            case 29: 
            case 38: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFunctionType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluationContext";
                break;
            }
            case 32: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 33: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 45: 
            case 95: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applyingContext";
                break;
            }
            case 46: 
            case 48: 
            case 53: 
            case 65: 
            case 93: 
            case 96: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawTypes";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterId";
                break;
            }
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 56: 
            case 57: 
            case 68: 
            case 103: 
            case 105: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsType";
                break;
            }
            case 62: 
            case 80: 
            case 85: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptableGenericArguments";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferred";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualParameters";
                break;
            }
            case 81: 
            case 84: 
            case 87: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newIndices";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 94: 
            case 97: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramType";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierTypeSupplier";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaScriptGenericParameters";
                break;
            }
            case 113: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "genericType";
                break;
            }
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassNamespace";
                break;
            }
            case 115: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluatorBase";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForExplicitThisParameterType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSQualifierGenericsRemapper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeSubstitutor";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericIds";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "reorderByDependencies";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterDefaultType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericTypesForCall";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeExplicitArgumentsCondition";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSubstitutorForReturnType";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypesForInference";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectGenerics";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "widenInferredTypes";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "extractGenericsForParameterType";
                break;
            }
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "calcExcludedFromWideningByContextType";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "inferGenericArgumentsFromCall";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgTypesForRestTuple";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "findAndIntersectGenericsTypeValues";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelGenerics";
                break;
            }
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateJSGenericsFromQualifier";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNamedTypesToGenericParameters";
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 124: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArgumentsMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForExplicitThisParameterType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 37: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 89: 
            case 91: 
            case 102: 
            case 107: 
            case 108: 
            case 109: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: 
            case 125: 
            case 128: 
            case 129: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeSubstitutor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutorForDefaultParameters";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addGenericDependencyFromType";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reorderByDependencies";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDefaultType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericTypesForCall";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "doInferParameters";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getExcludeExplicitArgumentsCondition";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutorForReturnType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getParameterTypesForInference";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenericsForCall";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "intersectGenerics";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "addTypesForParameter";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "checkImplicitFlags";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "intersectTypes";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableBySourceStrictness";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getAssignableStatus";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "inferGenericArgumentsFromCall";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "widenInferredTypes";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "extractGenericsForParameterType";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "addImpliedArity";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getArgTypesForRestTuple";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getArgType";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "matchGenericTypes";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "evaluateJSGenericsFromQualifier";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "convertNamedTypesToGenericParameters";
                break;
            }
            case 113: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "findTypeArgumentsForClassInHierarchy";
                break;
            }
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "applyTypeSubstitutorUpToParentClass";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getTypeArgumentsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 37: 
            case 41: 
            case 42: 
            case 44: 
            case 49: 
            case 66: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 86: 
            case 89: 
            case 91: 
            case 102: 
            case 107: 
            case 108: 
            case 109: 
            case 112: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 124: 
            case 125: 
            case 128: 
            case 129: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

